/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Building;
import com.ea.game.BuildingConstants;
import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.GraphicsConstants;
import com.ea.game.Key;
import com.ea.game.Level;
import com.ea.game.Script;
import com.ea.game.SpriteConstants;
import com.ea.game.Unit;
import com.ea.game.UnitsConstants;
import com.ea.game.XSprite;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;

public class Hud
implements Constants,
Key,
SpriteConstants,
GraphicsConstants,
BuildingConstants,
UnitsConstants {
    public static int _hud_state = 0;
    public static int _hud_old_state;
    public static int _hud_substate;
    public static int _hud_old_substate;
    public static int _hud_current_tab;
    public static int _hud_current_squad;
    static short _changeDownFrames;
    static short _changeDoubleFrames;
    static boolean _bchangeDoubleTap;
    public static int _hud_old_squad;
    public static boolean _blink_RSK;
    public static boolean _bDrawCollisionMap;
    public static int _hud_building;
    public static byte[] _hud_building_cmap;
    public static int _hud_building_offx;
    public static int _hud_building_offy;
    public static int _hud_building_tw;
    public static int _hud_building_th;
    public static int _timer;
    public static int _minimap_timer;
    public static int _minimap_state;
    public static int _old_minimap_state;
    public static int _old_camera_x;
    public static int _old_camera_y;
    public static int _hud_timer;
    public static int _tutorial_squad;
    public static int _event_timer;
    public static byte _move_tab;
    public static boolean _refinery_snap;
    public static int _snap_x;
    public static int _snap_y;
    public static boolean _bInvalidateDetailsHud;
    public static int _minimap_refresh_timer;
    public static int[] _current_hud_colors;
    public static int _hud_old_player_money;
    public static int _hud_old_player_power;
    public static int _hud_old_player_consumption;
    public static int _hud_old_player_cmd_points;
    public static int _hud_old_player_building_cmd_points;
    public static byte[][] _hud_build_items_available;
    public static byte[] _hud_nr_items_available;
    public static int[] _hud_build_items_available_mask;
    public static byte[] _hud_build_cursor_pos;
    public static byte[] _hud_build_page_pos;
    public static byte[][][] _hud_build_items;
    public static byte[] _hud_build_items_count;
    public static int[] _sw_cooldown;
    public static int _hud_sw;
    public static int _hud_bars_height;
    public static boolean _hud_movie_bars;
    static short[] _txtDescrStringLines;
    static int _lines_wrapped;
    static int _strBase;
    public static int _old_player_money;
    static int _tooltip_name_hscroll;
    static int _tooltip_name_hscroll_speed;
    static SDKString _tooltip_name_string;
    static SDKString _tooltip_cost_string;
    static int _tooltip_old_name;
    static boolean _briefing;
    static SDKString _msgBoxTitle;
    static SDKString _msgBoxString;
    static SDKString _pageString;
    static int _msgBoxQueueIndex;
    static int _msgBoxQueueLast;
    static short[] _msgBoxTitleQueue;
    static short[] _msgBoxStrQueue;
    static short[] _msgBoxPositionQueue;
    static short[] _msgBoxSizeQueue;
    static short[] _msgBoxFlagsQueue;
    static short[] _msgBoxSpeedQueue;
    static int _msgBoxLinesPerPage;
    static int _msgBoxCurrentPage;
    static int _msgBoxPageNo;
    static int _msgBoxPosition;
    static int _msgBoxSize;
    static int _msgBoxFlags;
    static int _visibleNoLines;
    static int _textHeight;
    static int _yPosScroll;
    static int _waitTime;
    static int _sizeFontText;
    static int _sizeFontTitle;
    static int _speed;
    static short[] _msgBoxStringLines;

    public static void Init() {
        Hud.Reset();
        _hud_state = 0;
        _changeDownFrames = 0;
        _changeDoubleFrames = (short)6;
        _bchangeDoubleTap = false;
        _blink_RSK = false;
        _timer = 0;
        _minimap_timer = 0;
        _sw_cooldown = new int[2];
        for (int i = 0; i < 2; ++i) {
            Hud._sw_cooldown[i] = -1;
        }
        _event_timer = 0;
        _hud_bars_height = 0;
        _hud_movie_bars = false;
        Hud.ForceDetailsHudRefresh();
    }

    public static void Reset() {
        for (int i = 0; i < 3; ++i) {
            Hud._hud_build_items_available_mask[i] = 0;
            Hud._hud_build_cursor_pos[i] = 0;
            Hud._hud_build_page_pos[i] = 0;
            Hud._hud_nr_items_available[i] = 0;
        }
        _move_tab = 0;
        Hud._hud_build_items_available_mask[0] = ~(Level._buildings_restricted & 0xFFFF);
        Hud._hud_build_items_available_mask[1] = ~(Level._units_restricted & 0xFFFF);
        Hud._hud_build_items_available_mask[2] = ~(Level._sw_restricted & 0xFFFF);
        _hud_bars_height = 0;
        _hud_movie_bars = false;
        _minimap_state = 4;
    }

    public static void Update() {
        _old_player_money = Level._player_money;
        for (int i = 0; i < 2; ++i) {
            if (_sw_cooldown[i] <= 0 || !Level.HasPower(0)) continue;
            int n = i;
            _sw_cooldown[n] = _sw_cooldown[n] - 1;
        }
        if (_event_timer > 0) {
            --_event_timer;
        }
        Hud.UpdateMovieBars();
        Hud.CheckDetailsHudRefresh();
        switch (_hud_state) {
            case 0: {
                Hud.Update_MiniMap();
                Hud.ChangeState(1, true);
                break;
            }
            case 1: {
                Hud.Update_MiniMap();
                Hud.Play_Update();
                break;
            }
            case 2: {
                Hud.Update_MiniMap();
                Hud.Build_Update();
                break;
            }
            case 3: {
                Hud.Update_MiniMap();
                Hud.ChangeSquad_Update();
                break;
            }
            case 4: {
                Hud.Update_MiniMap();
                Hud.MsgBox_Update();
                break;
            }
        }
    }

    public static void Draw(SDKGraphics sDKGraphics) {
        switch (_hud_state) {
            case 0: {
                GameImpl.Tutorials_Draw(sDKGraphics);
                break;
            }
            case 1: {
                Hud.Play_Draw(sDKGraphics);
                GameImpl.Tutorials_Draw(sDKGraphics);
                Hud.DrawMovieBars(sDKGraphics);
                break;
            }
            case 2: {
                Hud.Build_Draw(sDKGraphics);
                GameImpl.Tutorials_Draw(sDKGraphics);
                break;
            }
            case 3: {
                Hud.ChangeSquad_Draw(sDKGraphics);
                GameImpl.Tutorials_Draw(sDKGraphics);
                Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(4, GameImpl._string), true, true, false);
                break;
            }
            case 4: {
                if (!_hud_movie_bars) {
                    Hud.Draw_MiniMap(sDKGraphics);
                    Hud.Draw_Details(sDKGraphics);
                }
                GameImpl.Tutorials_Draw(sDKGraphics);
                Hud.DrawMovieBars(sDKGraphics);
                Hud.MsgBox_Draw(sDKGraphics);
                Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(5, GameImpl._string), true, true, false);
                break;
            }
            case 5: {
                GameImpl.Tutorials_Draw(sDKGraphics);
                Hud.DrawMovieBars(sDKGraphics);
            }
        }
        Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(7, GameImpl._string), false, true, false);
    }

    public static void ChangeState(int n, boolean bl) {
        if (_hud_state == n) {
            return;
        }
        switch (n) {
            case 2: {
                Camera._targetPointer = -1;
                _old_camera_x = Camera._nCamX;
                _old_camera_y = Camera._nCamY;
                if (SDKCanvas.isNewKeyPressed(128)) {
                    _hud_current_tab = 0;
                } else if (SDKCanvas.isNewKeyPressed(16384)) {
                    _hud_current_tab = 1;
                } else if (SDKCanvas.isNewKeyPressed(65536)) {
                    _hud_current_tab = 2;
                }
                Hud.RefreshBuildMenuItems();
                for (int i = 0; i < 3; ++i) {
                    if (!bl) continue;
                    Hud.RefreshCursor(i);
                }
                _hud_substate = 0;
                Hud.MoveCursor(_hud_current_tab, 0);
                Hud.SinkMovieBars();
                break;
            }
            case 3: {
                Hud.SinkMovieBars();
                _hud_old_squad = Level._currentGroup;
                if (Level._currentGroup != 0) break;
                Level._currentGroup = 1;
                break;
            }
            case 1: {
                Hud.SinkMovieBars();
                Level._paused = 0;
                break;
            }
            case 5: {
                Hud.RiseMovieBars();
            }
        }
        _hud_state = n;
    }

    static void GENERIC__() {
    }

    public static void AddAvailableBuildItems(int n, int n2) {
        int n3 = n;
        _hud_build_items_available_mask[n3] = _hud_build_items_available_mask[n3] | n2 & 0xFFFFFFFF;
        Hud.RefreshBuildMenuItems();
        if (_hud_state == 2 && _hud_substate == 0 && _hud_current_tab == n) {
            Hud.RefreshCursor(n);
        }
    }

    public static void RemoveAvailableBuildItems(int n, int n2) {
        int n3 = n;
        _hud_build_items_available_mask[n3] = _hud_build_items_available_mask[n3] & ~(n2 & 0xFFFFFFFF);
        Hud.RefreshBuildMenuItems();
        if (_hud_state == 2 && _hud_substate == 0 && _hud_current_tab == n) {
            Hud.RefreshCursor(n);
        }
    }

    public static int GetBuildMenuItem(int n, int n2) {
        if (n == 0) {
            return n2;
        }
        return _hud_build_items[n][Level._player_faction][n2];
    }

    public static int GetBuildMenuItemCount(int n) {
        if (n == 0) {
            return 8;
        }
        return _hud_build_items_count[n * 2 + Level._player_faction];
    }

    public static void RefreshBuildMenuItems() {
        for (int i = 0; i < 3; ++i) {
            int n;
            int n2;
            byte[] byArray = _hud_build_items_available[i];
            int n3 = _hud_build_items_available_mask[i];
            int n4 = 0;
            int n5 = 0;
            int n6 = Hud.GetBuildMenuItemCount(i);
            while (n5 < n6) {
                int n7 = Hud.GetBuildMenuItem(i, n5);
                if ((n3 & 1 << n7) != 0) {
                    n2 = 0;
                    switch (i) {
                        case 0: {
                            n2 = Level.GetBuildingStats(Level._player_faction, n7, 3);
                            break;
                        }
                        case 1: {
                            n2 = Level.GetUnitStats(n7, 24);
                            break;
                        }
                        case 2: {
                            n2 = Level.GetSWStats(n7, 1);
                        }
                    }
                    if (n2 == 0) {
                        ++n5;
                        continue;
                    }
                    n = 0;
                    boolean bl = true;
                    while (n2 != 0) {
                        if ((n2 & 1) != 0 && Level.GetEntityNo(6, n, 0) == 0) {
                            bl = false;
                            break;
                        }
                        ++n;
                        n2 >>= 1;
                    }
                    byArray[n4++] = bl ? (byte)n7 : (byte)(n7 + 50);
                }
                ++n5;
            }
            if (i == 0 && (n3 & 0x1000) != 0) {
                byArray[n4++] = 12;
            }
            Hud._hud_nr_items_available[i] = (byte)n4;
            if (i != 2) continue;
            for (n2 = 0; n2 < 2; ++n2) {
                n5 = -1;
                for (n = 0; n < n4; ++n) {
                    if (n2 != byArray[n] && n2 != byArray[n] + 50) continue;
                    n5 = n;
                }
                if (n5 == -1) {
                    Hud._sw_cooldown[n2] = -1;
                    continue;
                }
                if (byArray[n5] >= 50) {
                    Hud._sw_cooldown[n2] = -1;
                    continue;
                }
                if (_sw_cooldown[n2] != -1) continue;
                Hud._sw_cooldown[n2] = 14 * Level.GetSWStats(n2, 0);
            }
        }
    }

    public static void RefreshCursor(int n) {
        Hud._hud_build_cursor_pos[n] = -1;
        Hud._hud_build_page_pos[n] = 0;
        Hud.MoveCursor(n, 1);
    }

    public static void MoveCursor(int n, int n2) {
        int n3;
        int n4;
        int n5 = _hud_build_cursor_pos[n];
        n5 += n2;
        if (_hud_nr_items_available[n] == 0) {
            return;
        }
        if (n5 < 0) {
            n5 = _hud_nr_items_available[n] - 1;
        } else if (n5 >= _hud_nr_items_available[n]) {
            n5 = 0;
        }
        if (n5 < _hud_build_page_pos[n]) {
            Hud._hud_build_page_pos[n] = (byte)n5;
        } else if (n5 >= _hud_build_page_pos[n] + 3) {
            Hud._hud_build_page_pos[n] = (byte)(n5 - 3 + 1);
        }
        Hud._hud_build_cursor_pos[n] = (byte)n5;
        SDKCanvas.disableInput(0);
        byte by = _hud_build_cursor_pos[n];
        byte[] byArray = _hud_build_items_available[n];
        int n6 = n4 = byArray[by] < 50 ? byArray[by] : byArray[by] - 50;
        if (byArray[by] >= 50) {
            _tooltip_cost_string = SDKUtils.getString(55, _tooltip_cost_string);
            n3 = 0;
            int n7 = 0;
            switch (n) {
                case 0: {
                    _strBase = 32 + Level._player_faction * 8;
                    n3 = Level.GetBuildingStats(Level._player_faction, n4, 3);
                    break;
                }
                case 1: {
                    _strBase = 22;
                    n3 = Level.GetUnitStats(n4, 24);
                    break;
                }
                case 2: {
                    _strBase = 48;
                    n3 = Level.GetSWStats(n4, 1);
                }
            }
            while (n3 != 0) {
                if ((n3 & 1) != 0 && Level.GetEntityNo(6, n7, 0) == 0) {
                    GameImpl._string = SDKUtils.getString(32 + Level._player_faction * 8 + n7, GameImpl._string);
                }
                ++n7;
                n3 >>= 1;
            }
            _tooltip_cost_string = _tooltip_cost_string.concat(GameImpl._string);
            SDKUtils.wrapString(_tooltip_cost_string, _txtDescrStringLines, Constants.HUD_TOOLTIPS_TEXT_W, (short)124);
            _lines_wrapped = _txtDescrStringLines[0];
        } else if (n == 2) {
            _strBase = 48;
        } else {
            n3 = 0;
            if (n == 0) {
                if (byArray[by] == 12) {
                    _strBase = 57 - n4;
                    n3 = -1;
                } else {
                    _strBase = 32 + Level._player_faction * 8;
                    n3 = Level.GetBuildingStats(Level._player_faction, n4, 15);
                }
            } else {
                _strBase = 22;
                n3 = Level.GetUnitStats(n4, 10);
            }
            SDKUtils.getString(56, _tooltip_cost_string);
            _tooltip_cost_string = GameImpl.ConcatNumber(_tooltip_cost_string, n3, 0);
        }
        if (_tooltip_old_name != _strBase + n4) {
            SDKUtils.getString(_strBase + n4, _tooltip_name_string);
            _tooltip_old_name = _strBase + n4;
            _tooltip_name_hscroll = 0;
            _tooltip_name_hscroll_speed = 0;
            n3 = SDKUtils.getStringSize(_tooltip_name_string);
            if (n3 > Constants.HUD_TOOLTIPS_TEXT_W) {
                _tooltip_name_hscroll = (n3 - Constants.HUD_TOOLTIPS_TEXT_W) / 2;
                _tooltip_name_hscroll_speed = -2;
            }
        }
    }

    public static void MoveTab(int n) {
        int n2 = _hud_current_tab;
        if (n > 0) {
            if (_move_tab < 0) {
                _move_tab = (byte)n;
                return;
            }
        } else if (_move_tab > 0) {
            _move_tab = (byte)n;
            return;
        }
        if (Math.abs(_move_tab = (byte)(_move_tab + (byte)n)) < 4) {
            return;
        }
        if ((n2 += n) < 0) {
            n2 = 2;
        }
        if (n2 >= 3) {
            n2 = 0;
        }
        _hud_current_tab = n2;
        _move_tab = 0;
    }

    static void __GENERIC() {
    }

    static void MINIMAP__() {
    }

    private static void Update_MiniMap() {
        switch (_minimap_state) {
            case 1: {
                if (Level._player_power > Level._player_consumption && Level.GetEntityNo(6, 7, 0) != 0) break;
                _minimap_state = 2;
                _minimap_timer = 0;
                break;
            }
            case 0: {
                if (++_minimap_timer != 4) break;
                _minimap_state = 2;
                _minimap_timer = 0;
                break;
            }
            case 2: {
                if (++_minimap_timer != 20) break;
                _minimap_state = Level._player_power > Level._player_consumption && Level.GetEntityNo(6, 7, 0) > 0 ? 1 : 3;
                _minimap_timer = 0;
                break;
            }
            case 3: {
                if (++_minimap_timer != 6) break;
                _minimap_state = 4;
                _minimap_timer = 0;
                break;
            }
            case 4: {
                if (Level._player_power <= Level._player_consumption || Level.GetEntityNo(6, 7, 0) <= 0) break;
                _minimap_state = 0;
                _minimap_timer = 0;
            }
        }
    }

    private static void Draw_MiniMap(SDKGraphics sDKGraphics) {
        int n;
        int n2;
        Entity entity;
        int n3;
        int n4;
        int n5;
        if (--_minimap_refresh_timer > 0) {
            return;
        }
        _minimap_refresh_timer = 5;
        sDKGraphics.setColor(_current_hud_colors[0]);
        sDKGraphics.fillRect(1, 1, 57, 36);
        if (_hud_bars_height != 0) {
            return;
        }
        sDKGraphics.setColor(_current_hud_colors[1]);
        sDKGraphics.drawRect(0, 0, 58, 37);
        if (_minimap_state == 0) {
            sDKGraphics.setColor(0x400000);
            switch (_minimap_timer) {
                case 0: {
                    int n6 = 29;
                    int n7 = 19;
                    sDKGraphics.drawLine(n6 - 2, n7, n6, n7 - 2);
                    sDKGraphics.drawLine(n6 - 1, n7, n6, n7 - 1);
                    sDKGraphics.drawLine(n6 - 2, n7, n6, n7 + 2);
                    sDKGraphics.drawLine(n6 - 1, n7, n6, n7 + 1);
                    sDKGraphics.drawLine(n6 + 2, n7, n6, n7 - 2);
                    sDKGraphics.drawLine(n6 + 1, n7, n6, n7 - 1);
                    sDKGraphics.drawLine(n6 + 2, n7, n6, n7 + 2);
                    sDKGraphics.drawLine(n6 + 1, n7, n6, n7 + 1);
                    sDKGraphics.drawLine(n6, n7, n6, n7);
                    break;
                }
                case 1: {
                    int n8 = 22;
                    int n9 = 13;
                    sDKGraphics.drawRect(n8, n9, 14, 9);
                    break;
                }
                case 2: {
                    int n10 = 15;
                    int n11 = 10;
                    sDKGraphics.drawRect(n10, n11, 28, 18);
                    break;
                }
                case 3: {
                    int n12 = 8;
                    int n13 = 5;
                    sDKGraphics.drawRect(n12, n13, 42, 27);
                }
            }
            return;
        }
        if (_minimap_state == 3) {
            sDKGraphics.setColor(0xDFDFDF);
            switch (_minimap_timer) {
                case 0: {
                    int n14 = 1;
                    int n15 = 5;
                    sDKGraphics.drawLine(n14, n15, n14 + 57 - 1, n15);
                    sDKGraphics.drawLine(n14, n15 - 1, n14 + 57 - 1, n15 - 1);
                    n15 = 29;
                    sDKGraphics.drawLine(n14, n15, n14 + 57 - 1, n15);
                    sDKGraphics.drawLine(n14, n15 - 1, n14 + 57 - 1, n15 - 1);
                    break;
                }
                case 1: {
                    int n16 = 1;
                    int n17 = 13;
                    sDKGraphics.drawLine(n16, n17, n16 + 57 - 1, n17);
                    sDKGraphics.drawLine(n16, n17 - 1, n16 + 57 - 1, n17 - 1);
                    n17 = 21;
                    sDKGraphics.drawLine(n16, n17, n16 + 57 - 1, n17);
                    sDKGraphics.drawLine(n16, n17 - 1, n16 + 57 - 1, n17 - 1);
                    break;
                }
                case 2: {
                    int n18 = 1;
                    int n19 = 19;
                    sDKGraphics.drawLine(n18, n19, n18 + 57, n19);
                    break;
                }
                case 3: {
                    int n20 = 15;
                    int n21 = 19;
                    sDKGraphics.drawLine(n20, n21, n20 + 28, n21);
                }
                case 4: 
                case 5: {
                    int n20 = 29;
                    int n21 = 19;
                    sDKGraphics.drawLine(n20 - 2, n21, n20, n21 - 2);
                    sDKGraphics.drawLine(n20 - 1, n21, n20, n21 - 1);
                    sDKGraphics.drawLine(n20 - 2, n21, n20, n21 + 2);
                    sDKGraphics.drawLine(n20 - 1, n21, n20, n21 + 1);
                    sDKGraphics.drawLine(n20 + 2, n21, n20, n21 - 2);
                    sDKGraphics.drawLine(n20 + 1, n21, n20, n21 - 1);
                    sDKGraphics.drawLine(n20 + 2, n21, n20, n21 + 2);
                    sDKGraphics.drawLine(n20 + 1, n21, n20, n21 + 1);
                    sDKGraphics.drawLine(n20, n21, n20, n21);
                }
            }
            return;
        }
        if (_minimap_state == 2) {
            for (int i = 0; i < GameImpl.random(10); ++i) {
                int n22 = GameImpl.random(3, 37);
                for (int j = 0; j < GameImpl.random(1, 4); ++j) {
                    Hud.spamLine(sDKGraphics, n22 + j - 2);
                }
            }
            return;
        }
        if (_minimap_state == 4) {
            return;
        }
        if (Level._player_faction == 0) {
            n5 = 0xFF0000;
            n4 = 255;
        } else {
            n5 = 255;
            n4 = 0xFF0000;
        }
        sDKGraphics.setClip(1, 1, 57, 36);
        for (n3 = 0; n3 < 24; ++n3) {
            if (Level._entities_usage[n3] != 1) continue;
            entity = (Unit)Level._entities[n3];
            if (entity._life <= 0 || (entity._flags & 0x10) != 0) continue;
            n2 = 1 + entity._pos_x * 57 / Level._map_w;
            n = 1 + entity._pos_y * 36 / Level._map_h;
            if (entity._allegiance == 0) {
                if (entity._bSelected) {
                    sDKGraphics.setColor(0xFFFFFF);
                } else {
                    sDKGraphics.setColor(n5);
                }
            } else if (entity._allegiance == 1) {
                sDKGraphics.setColor(n4);
            } else {
                sDKGraphics.setColor(0xA0A0A0);
            }
            sDKGraphics.fillRect(n2, n, 2, 2);
        }
        for (n3 = 24; n3 < 48; ++n3) {
            if (Level._entities_usage[n3] != 1) continue;
            entity = (Building)Level._entities[n3];
            if (((Building)entity)._life <= 0 || (entity._flags & 0x10) != 0) continue;
            n2 = 1 + entity._pos_x * 57 / Level._map_w;
            n = 1 + entity._pos_y * 36 / Level._map_h;
            if (((Building)entity)._allegiance == 0) {
                sDKGraphics.setColor(n5);
            } else if (((Building)entity)._allegiance == 1) {
                sDKGraphics.setColor(n4);
            } else {
                sDKGraphics.setColor(0xA0A0A0);
            }
            sDKGraphics.fillRect(n2, n, 3, 3);
        }
        sDKGraphics.setColor(65280);
        sDKGraphics.drawRect(1 + Camera._nCamX * 57 / Level._map_w, 1 + Camera._nCamY * 36 / Level._map_h, Constants.SV_W * 57 / Level._map_w, Constants.SV_H * 36 / Level._map_h);
        sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
    }

    private static void spamLine(SDKGraphics sDKGraphics, int n) {
        int n2 = 2;
        int n3 = 6;
        int n4 = 0;
        int n5 = GameImpl.random(n3);
        int n6 = 1;
        int n7 = GameImpl.random(2);
        n7 = n7 == 1 ? 0xDFDFDF : 0x202020;
        sDKGraphics.setColor(n7);
        sDKGraphics.drawLine(n6, n, n6 + n5, n);
        n7 ^= 0xFFFFFF;
        n6 += n5;
        while (n6 + (n4 = GameImpl.random(n2, n3)) < 57) {
            sDKGraphics.setColor(n7);
            sDKGraphics.drawLine(n6, n, n6 + n4, n);
            n7 ^= 0xFFFFFF;
            n6 += n4;
        }
        n4 = 58 - n6 - 1;
        sDKGraphics.setColor(n7);
        sDKGraphics.drawLine(n6, n, n6 + n4, n);
    }

    static void __MINIMAP() {
    }

    private static void Draw_Details(SDKGraphics sDKGraphics) {
        XSprite xSprite = GameImpl._sprites[4];
        if (_bInvalidateDetailsHud) {
            _bInvalidateDetailsHud = false;
            sDKGraphics.setColor(0);
            sDKGraphics.fillRect(58, 19, Constants.SCR_W - 58, 19);
            if (_hud_bars_height != 0) {
                return;
            }
            sDKGraphics.setColor(_current_hud_colors[6]);
            sDKGraphics.fillRect(58, 0, Constants.SCR_W - 58, 19);
            sDKGraphics.setColor(_current_hud_colors[1]);
            sDKGraphics.drawRect(58, 0, Constants.SCR_W - 58, 37);
            xSprite.DrawFrame(30, (Constants.SCR_W >> 1) + -15, 3, 0);
            SDKUtils.setFont(GameImpl.fonts[0]);
            GameImpl.DrawNumber(Level._player_money, (Constants.SCR_W >> 1) + -15, 3, 0);
            Hud.Draw_Power(sDKGraphics);
            Hud.Draw_CommandPoints(sDKGraphics);
        }
        if (_event_timer > 0) {
            sDKGraphics.setClip(0, 38, Constants.SV_W, Constants.SV_H);
            GameImpl.DrawNumber(_event_timer / 14, (Constants.SCR_W >> 1) + 0, 40, 0);
            sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
        }
    }

    private static void Draw_Power(SDKGraphics sDKGraphics) {
        int n;
        int n2 = Level._player_consumption;
        XSprite xSprite = GameImpl._sprites[4];
        int n3 = (int)GameImpl.Ln(n2);
        int n4 = (int)GameImpl.Ln(Level._player_power);
        if (Level._buildings_off_times[0][1] > 0) {
            n4 = 0;
        }
        n2 = n3 >> 6;
        int n5 = n2 + (n4 - n3 >> 3);
        if (n2 > 15) {
            n2 = 15;
        }
        if (n5 > 15) {
            n5 = 15;
        }
        if ((n = n5) < n2) {
            n = n2;
        }
        int n6 = (Constants.SCR_W >> 1) + -14;
        int n7 = 28;
        xSprite.DrawFrame(31, n6, n7, 0);
        boolean bl = false;
        int n8 = n6;
        int n9 = n6;
        for (int i = 0; i < n; ++i) {
            if (i < n2) {
                xSprite.DrawFrame(16, n6, n7, 0);
                if (Level._player_consumption >= Level._player_power) {
                    n9 = n6;
                }
            } else if (i == n2) {
                xSprite.DrawFrame(18, n6, n7, 0);
                xSprite.DrawFrame(15, n6, n7, 0);
            } else {
                xSprite.DrawFrame(18, n6, n7, 0);
            }
            if (i >= n5 && !bl) {
                n8 = n6;
                bl = true;
            }
            n6 += 4;
        }
        if (!bl) {
            n8 = n6 - 4;
        }
        if (Level._player_consumption >= Level._player_power) {
            n8 = n9;
            xSprite.DrawFrame(16, n8, n7, 0);
        } else {
            xSprite.DrawFrame(18, n8, n7, 0);
            if (n2 == n) {
                xSprite.DrawFrame(15, n8, n7, 0);
            }
        }
    }

    private static void Draw_CommandPoints(SDKGraphics sDKGraphics) {
        XSprite xSprite = GameImpl._sprites[4];
        SDKUtils.setFont(GameImpl.fonts[0]);
        if (Level._player_command_points >= Level._player_max_command_points) {
            SDKUtils.setFont(GameImpl.fonts[1]);
        }
        xSprite.DrawFrame(32, Constants.SCR_W + -32, 0, 0);
        GameImpl.DrawSeparatedNumbers(Level._player_command_points, Level._player_max_command_points, "/", Constants.SCR_W + -32, 0, 0, 0);
        SDKUtils.setFont(GameImpl.fonts[0]);
        if (Level._player_build_points >= Level._player_max_build_points) {
            SDKUtils.setFont(GameImpl.fonts[1]);
        }
        xSprite.DrawFrame(33, Constants.SCR_W + -32, 19, 0);
        GameImpl.DrawSeparatedNumbers(Level._player_build_points, Level._player_max_build_points, "/", Constants.SCR_W + -32, 19, 0, 0);
    }

    static void BUILD__() {
    }

    public static void Build_Update() {
        int n = 82048;
        if (SDKCanvas.isNewKeyPressed(n)) {
            if (SDKCanvas.isNewKeyPressed(128)) {
                if (_hud_current_tab != 0) {
                    _hud_current_tab = 0;
                    Hud.Build_ChangeSubState(0);
                    Hud.MoveCursor(_hud_current_tab, 0);
                } else {
                    Camera.SetState(0);
                    Hud.ChangeState(1, true);
                }
            } else if (SDKCanvas.isNewKeyPressed(16384)) {
                if (_hud_current_tab != 1) {
                    _hud_current_tab = 1;
                    Hud.Build_ChangeSubState(0);
                    Hud.MoveCursor(_hud_current_tab, 0);
                } else {
                    Camera.SetState(0);
                    Hud.ChangeState(1, true);
                }
            } else if (SDKCanvas.isNewKeyPressed(65536)) {
                if (_hud_current_tab != 2) {
                    _hud_current_tab = 2;
                    Hud.Build_ChangeSubState(0);
                    Hud.MoveCursor(_hud_current_tab, 0);
                } else {
                    Camera.SetState(0);
                    Hud.ChangeState(1, true);
                }
            }
            return;
        }
        if (_hud_substate != 5 && _hud_substate != 2 && _hud_substate != 3) {
            if (SDKCanvas.isKeyPressed(2052) || SDKCanvas.isNewKeyPressed(2052) || SDKCanvas.isNewKeyReleased(2052)) {
                Hud.MoveTab(-1);
                if (_move_tab == 0) {
                    Hud.MoveCursor(_hud_current_tab, 0);
                }
                Hud.Build_ChangeSubState(0);
            } else if (SDKCanvas.isKeyPressed(8200) || SDKCanvas.isNewKeyPressed(8200) || SDKCanvas.isNewKeyReleased(8200)) {
                Hud.MoveTab(1);
                if (_move_tab == 0) {
                    Hud.MoveCursor(_hud_current_tab, 0);
                }
                Hud.Build_ChangeSubState(0);
            } else {
                _move_tab = 0;
            }
            if (SDKCanvas.isNewKeyReleased(32)) {
                Camera.SetState(0);
                Hud.ChangeState(1, true);
                return;
            }
        }
        byte[] byArray = _hud_build_items_available[_hud_current_tab];
        switch (_hud_substate) {
            case 0: {
                int n2;
                if (SDKCanvas.isNewKeyReleased(513)) {
                    Hud.MoveCursor(_hud_current_tab, -1);
                } else if (SDKCanvas.isNewKeyReleased(32770)) {
                    Hud.MoveCursor(_hud_current_tab, 1);
                } else if (SDKCanvas.isNewKeyReleased(4112)) {
                    if (_hud_build_cursor_pos[_hud_current_tab] != -1) {
                        if (byArray[_hud_build_cursor_pos[_hud_current_tab]] >= 50) break;
                        if (_hud_current_tab == 0) {
                            if (Level._player_build_points == Level._player_max_build_points && byArray[_hud_build_cursor_pos[_hud_current_tab]] != 12) {
                                return;
                            }
                            if (byArray[_hud_build_cursor_pos[_hud_current_tab]] == 12) {
                                Hud.Build_ChangeSubState(5);
                            } else {
                                Hud.Build_ChangeSubState(2);
                            }
                        } else if (_hud_current_tab == 1) {
                            if (Level._player_command_points == Level._player_max_command_points) {
                                return;
                            }
                            if (Level.HasPower(0)) {
                                Hud.Build_ChangeSubState(1);
                            }
                        } else if (_hud_current_tab == 2 && _sw_cooldown[byArray[_hud_build_cursor_pos[_hud_current_tab]]] == 0 && Level.HasPower(0)) {
                            Hud.Build_ChangeSubState(3);
                        }
                    }
                    SDKCanvas.disableInput(0);
                }
                if (_tooltip_name_string == null || (n2 = SDKUtils.getStringSize(_tooltip_name_string)) <= Constants.HUD_TOOLTIPS_TEXT_W) break;
                if (_tooltip_name_hscroll < -((n2 - Constants.HUD_TOOLTIPS_TEXT_W) / 2)) {
                    _tooltip_name_hscroll_speed = -_tooltip_name_hscroll_speed;
                } else if (_tooltip_name_hscroll > (n2 - Constants.HUD_TOOLTIPS_TEXT_W) / 2) {
                    _tooltip_name_hscroll_speed = -_tooltip_name_hscroll_speed;
                }
                _tooltip_name_hscroll += _tooltip_name_hscroll_speed;
                break;
            }
            case 1: {
                int n3;
                if (--_hud_timer == 0 && (n3 = Level.Group_GetLeader(_hud_current_squad)) != -1) {
                    Camera.DoFollowEntity(n3);
                }
                if (_tutorial_squad < 0 && SDKCanvas.isNewKeyReleased(513)) {
                    if (_hud_current_squad > 1) {
                        --_hud_current_squad;
                    }
                    _hud_timer = 14;
                    SDKCanvas.disableInput(0);
                    break;
                }
                if (_tutorial_squad < 0 && SDKCanvas.isNewKeyReleased(32770)) {
                    if (_hud_current_squad < 2) {
                        ++_hud_current_squad;
                    }
                    _hud_timer = 14;
                    SDKCanvas.disableInput(0);
                    break;
                }
                if (!SDKCanvas.isNewKeyReleased(4112)) break;
                Hud.Build_Unit();
                Hud.Build_ChangeSubState(0);
                SDKCanvas.disableInput(0);
                break;
            }
            case 2: {
                if (_hud_building == 2) {
                    Entity entity = Level.FindClosestMineralField(Camera._nCursorPosX, Camera._nCursorPosY, 64);
                    if (entity != null) {
                        _refinery_snap = true;
                        _snap_x = entity._pos_x;
                        _snap_y = entity._pos_y + 1;
                        if (!Hud.Build_IsValidBuildingPosition(_snap_x, _snap_y)) {
                            _refinery_snap = false;
                        }
                    } else {
                        _refinery_snap = false;
                    }
                }
                if (SDKCanvas.isNewKeyReleased(32)) {
                    Hud.Build_ChangeSubState(0);
                    SDKCanvas.disableInput(0);
                    return;
                }
                if (SDKCanvas.isNewKeyReleased(4112)) {
                    SDKCanvas.disableInput(0);
                    if (Hud.Build_Building()) {
                        Hud.Build_ChangeSubState(0);
                    }
                }
                Camera.UpdateCursorMovement();
                break;
            }
            case 3: {
                if (SDKCanvas.isNewKeyReleased(32)) {
                    Hud.Build_ChangeSubState(0);
                    SDKCanvas.disableInput(0);
                    return;
                }
                if (SDKCanvas.isNewKeyReleased(4112)) {
                    SDKCanvas.disableInput(0);
                    boolean bl = false;
                    switch (_hud_sw) {
                        case 0: {
                            Level.DropNuke(0, Camera._nCursorPosX, Camera._nCursorPosY);
                            break;
                        }
                        case 1: {
                            Level.DropStorm(0, Camera._nCursorPosX, Camera._nCursorPosY);
                        }
                    }
                    if (!bl) {
                        Hud.ChangeState(1, true);
                    }
                }
                Camera.UpdateCursorMovement();
                break;
            }
            case 5: {
                if (SDKCanvas.isNewKeyReleased(32)) {
                    Hud.Build_ChangeSubState(0);
                    SDKCanvas.disableInput(0);
                    return;
                }
                if (SDKCanvas.isNewKeyReleased(4112)) {
                    SDKCanvas.disableInput(0);
                    Entity entity = Level.GetEntitySafe(Camera._targetPointer);
                    if (entity != null && entity._type == 6) {
                        Building building = (Building)entity;
                        if (building._subtype != 0 && building._allegiance == 0) {
                            building.SellBuilding();
                        }
                    }
                }
                Camera.UpdateCursorMovement();
                Camera.UpdateCursorTargetPointer();
            }
        }
    }

    public static void Build_ChangeSubState(int n) {
        if (_hud_substate == n) {
            return;
        }
        if (_hud_substate == 2) {
            Camera.SetState(0);
        } else if (_hud_substate == 1) {
            Camera.DoScroll(_old_camera_x, _old_camera_y);
        }
        switch (n) {
            case 0: {
                Hud.RefreshBuildMenuItems();
                break;
            }
            case 2: {
                int n2 = _hud_build_items_available[_hud_current_tab][_hud_build_cursor_pos[_hud_current_tab]];
                int n3 = Level.GetBuildingStats(Level._player_faction, n2, 15);
                if (n3 > Level._player_money) {
                    return;
                }
                Camera._nCursorPosX = Camera._nCamX + (Constants.SV_W >> 1);
                Camera._nCursorPosY = Camera._nCamY + (Constants.SV_H >> 1);
                Camera.SetState(2);
                int n4 = 0;
                if (Level._player_faction == 1) {
                    n4 = 8;
                }
                _hud_building = n2;
                _hud_building_cmap = Level.GetCMap(n4 + _hud_building);
                _hud_building_offx = Level.GetCMapHeaderData(n4 + _hud_building, 0);
                _hud_building_offy = Level.GetCMapHeaderData(n4 + _hud_building, 1);
                _hud_building_tw = Level.GetCMapHeaderData(n4 + _hud_building, 2);
                _hud_building_th = Level.GetCMapHeaderData(n4 + _hud_building, 3);
                break;
            }
            case 1: {
                byte by = _hud_build_items_available[_hud_current_tab][_hud_build_cursor_pos[_hud_current_tab]];
                int n5 = Level.GetUnitStats(by, 10);
                if (n5 > Level._player_money) {
                    return;
                }
                _hud_timer = 14;
                _tutorial_squad = -1;
                for (int i = 0; i < 4; ++i) {
                    int n6;
                    if (GameImpl._tutorials[i][0] != 1 || (n6 = GameImpl._tutorials[i][1]) != 5) continue;
                    int n7 = GameImpl._tutorials[i][8];
                    int n8 = GameImpl._tutorials[i][6];
                    if (by != n8 || n7 <= 0) continue;
                    _tutorial_squad = n7;
                }
                if (_tutorial_squad < 0) break;
                _hud_current_squad = _tutorial_squad;
                break;
            }
            case 3: {
                _hud_sw = _hud_build_items_available[_hud_current_tab][_hud_build_cursor_pos[_hud_current_tab]];
            }
        }
        _hud_substate = n;
    }

    public static void Build_Draw(SDKGraphics sDKGraphics) {
        switch (_hud_substate) {
            case 0: {
                sDKGraphics.setColor(_current_hud_colors[3]);
                sDKGraphics.fillRect(Constants.SCR_W - 44, 38, 44, Constants.HUD_BUILD_BG_H);
                sDKGraphics.setColor(_current_hud_colors[4]);
                sDKGraphics.drawRect(Constants.SCR_W - 44, 38, 44, Constants.HUD_BUILD_BG_H);
                Hud.Build_Draw_Tabs(sDKGraphics, _hud_current_tab, true);
                Hud.Build_Draw_Slots(sDKGraphics, _hud_current_tab, true);
                Hud.Build_Draw_Slots_Tooltip(sDKGraphics, _hud_current_tab);
                break;
            }
            case 1: {
                sDKGraphics.setColor(_current_hud_colors[3]);
                sDKGraphics.fillRect(Constants.SCR_W - 44, 38, 44, Constants.HUD_BUILD_BG_H);
                sDKGraphics.setColor(_current_hud_colors[4]);
                sDKGraphics.drawRect(Constants.SCR_W - 44, 38, 44, Constants.HUD_BUILD_BG_H);
                Hud.Build_Draw_Tabs(sDKGraphics, _hud_current_tab, true);
                Hud.Build_Draw_Slots(sDKGraphics, _hud_current_tab, false);
                Hud.Build_Draw_SquadSel(sDKGraphics);
                break;
            }
            case 2: {
                Hud.Build_Draw_Overlay(sDKGraphics);
                Camera.DrawCursor(sDKGraphics);
                Hud.Play_Draw_SuperWeapon_Cooldown(sDKGraphics);
                _refinery_snap = false;
                break;
            }
            case 3: {
                Hud.Play_Draw_SuperWeapon_Cooldown(sDKGraphics);
                Hud.Build_Draw_SW_TargetSelection(sDKGraphics, 3);
                break;
            }
            case 5: {
                Hud.Play_Draw_SuperWeapon_Cooldown(sDKGraphics);
                Hud.Build_Draw_SW_TargetSelection(sDKGraphics, 5);
            }
        }
        sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
        Hud.Draw_MiniMap(sDKGraphics);
        Hud.Draw_Details(sDKGraphics);
        Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(4, GameImpl._string), true, true, _blink_RSK);
    }

    private static void Build_Draw_Tabs(SDKGraphics sDKGraphics, int n, boolean bl) {
        XSprite xSprite = GameImpl._sprites[4];
        xSprite.DrawFrame(0, Constants.HUD_BUILD_POSX, 52, 0);
        xSprite.DrawFrame(1 + n, Constants.HUD_BUILD_POSX, 52, 0);
    }

    public static void Build_Draw_Range(SDKGraphics sDKGraphics, int n, int n2, int n3) {
        int n4 = Level.GetBuildingStats(Level._player_faction, n, 10);
        n4 *= 3;
        int n5 = 65280;
        sDKGraphics.setColor(n5);
        sDKGraphics.drawArc(n2 - ((n4 >>= 2) + (n4 >> 2)), n3 - (n4 + (n4 >> 2)), (n4 >> 1) + (n4 << 1), (n4 >> 1) + (n4 << 1), 0, 360);
    }

    private static void Build_Draw_Slots(SDKGraphics sDKGraphics, int n, boolean bl) {
        int n2;
        XSprite xSprite = GameImpl._sprites[4];
        XSprite xSprite2 = null;
        xSprite2 = Level._player_faction == 0 ? GameImpl._sprites[13] : GameImpl._sprites[14];
        byte by = _hud_build_cursor_pos[n];
        int n3 = _hud_build_page_pos[n];
        byte[] byArray = _hud_build_items_available[n];
        byte by2 = _hud_nr_items_available[n];
        int n4 = 97;
        for (n2 = n3; n2 < n3 + 3; ++n2) {
            if (n2 < by2 && n2 != by) {
                int n5 = byArray[n2];
                if (n5 >= 50) {
                    n5 -= 50;
                }
                if (byArray[n2] == 12) {
                    xSprite.DrawFrame(4, Constants.HUD_BUILD_SLOT_OFF_POSX, n4, 0);
                    XSprite xSprite3 = GameImpl._sprites[6];
                    xSprite3.DrawFrame(13, Constants.HUD_BUILD_SLOT_OFF_POSX, n4, 0);
                } else if (n == 0) {
                    xSprite.DrawFrame(4, Constants.HUD_BUILD_SLOT_OFF_POSX, n4, 0);
                    sDKGraphics.setClip(3 + Constants.HUD_BUILD_SLOT_OFF_POSX - 14, 4 + n4 - 14, 24, 23);
                    Building.DrawHudFrame(n5, Level._player_faction, Constants.HUD_BUILD_SLOT_OFF_POSX, n4);
                    sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
                } else if (n == 1) {
                    xSprite.DrawFrame(4, Constants.HUD_BUILD_SLOT_OFF_POSX, n4, 0);
                    sDKGraphics.setClip(3 + Constants.HUD_BUILD_SLOT_OFF_POSX - 14, 4 + n4 - 14, 24, 23);
                    Unit.DrawHudFrame(n5, Constants.HUD_BUILD_SLOT_OFF_POSX, n4);
                    sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
                } else if (n == 2) {
                    xSprite2.DrawFrame(1 + n5, Constants.HUD_BUILD_SLOT_OFF_POSX, n4, 0);
                }
                if (byArray[n2] >= 50) {
                    xSprite.DrawFrame(35, Constants.HUD_BUILD_SLOT_OFF_POSX, n4 + 1, 0);
                }
            }
            n4 += 31;
        }
        if (by != -1) {
            n4 = 97 + (by - n3) * 31;
            n2 = byArray[by];
            if (n2 >= 50) {
                n2 -= 50;
            }
            if (byArray[by] == 12) {
                xSprite.DrawFrame(4, Constants.HUD_BUILD_SLOT_ON_POSX, n4, 0);
                XSprite xSprite4 = GameImpl._sprites[6];
                xSprite4.DrawFrame(13, Constants.HUD_BUILD_SLOT_ON_POSX + 1, n4 + 1, 0);
            } else if (n == 0) {
                xSprite.DrawFrame(4, Constants.HUD_BUILD_SLOT_ON_POSX, n4, 0);
                sDKGraphics.setClip(3 + Constants.HUD_BUILD_SLOT_ON_POSX - 14, 4 + n4 - 14, 24, 23);
                Building.DrawHudFrame(n2, Level._player_faction, Constants.HUD_BUILD_SLOT_ON_POSX, n4);
                sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
            } else if (n == 1) {
                xSprite.DrawFrame(4, Constants.HUD_BUILD_SLOT_ON_POSX, n4, 0);
                sDKGraphics.setClip(3 + Constants.HUD_BUILD_SLOT_ON_POSX - 14, 4 + n4 - 14, 24, 23);
                Unit.DrawHudFrame(n2, Constants.HUD_BUILD_SLOT_ON_POSX, n4);
                sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
            } else if (n == 2) {
                xSprite2.DrawFrame(1 + n2, Constants.HUD_BUILD_SLOT_ON_POSX, n4, 0);
            }
            if (byArray[by] >= 50) {
                xSprite.DrawFrame(35, Constants.HUD_BUILD_SLOT_ON_POSX, n4 + 1, 0);
            }
        }
        if (bl) {
            xSprite.DrawFrame(5, Constants.HUD_BUILD_ARROWS_POSX, 77, 0);
            xSprite.DrawFrame(6, Constants.HUD_BUILD_ARROWS_POSX, 179, 0);
        }
    }

    private static void Build_Draw_Slots_Tooltip(SDKGraphics sDKGraphics, int n) {
        byte by = _hud_build_cursor_pos[n];
        byte by2 = _hud_build_page_pos[n];
        byte[] byArray = _hud_build_items_available[n];
        if (by != -1) {
            int n2;
            boolean bl = true;
            int n3 = 97 + (by - by2) * 31;
            int n4 = 0;
            int n5 = n2 = byArray[by] < 50 ? byArray[by] : byArray[by] - 50;
            if (byArray[by] >= 50) {
                SDKUtils.setFont(GameImpl.fonts[1]);
                bl = false;
            } else {
                if (n == 2) {
                    n4 = -1;
                } else if (n == 0) {
                    n4 = byArray[by] == 12 ? -1 : Level.GetBuildingStats(Level._player_faction, n2, 15);
                } else if (n == 1) {
                    _strBase = 22;
                    n4 = Level.GetUnitStats(n2, 10);
                }
                if (n4 > Level._player_money || !Level.HasPower(0) && n != 0 || n == 2 && _sw_cooldown[n2] / 14 != 0) {
                    SDKUtils.setFont(GameImpl.fonts[1]);
                } else {
                    SDKUtils.setFont(GameImpl.fonts[0]);
                }
            }
            int n6 = SDKUtils.getStringSize(_tooltip_name_string);
            int n7 = SDKUtils.getStringSize(_tooltip_cost_string);
            if (n6 > Constants.HUD_TOOLTIPS_TEXT_W) {
                n6 = Constants.HUD_TOOLTIPS_TEXT_W;
            }
            if (n7 > Constants.HUD_TOOLTIPS_TEXT_W) {
                n7 = Constants.HUD_TOOLTIPS_TEXT_W;
            }
            int n8 = n6 > n7 ? n6 : n7;
            int n9 = n8 + 10;
            int n10 = Constants.HUD_BUILD_POSX - 25 - n9;
            int n11 = 30;
            if (SDKUtils.getStringSize(_tooltip_cost_string) > Constants.HUD_TOOLTIPS_TEXT_W) {
                n11 = (_lines_wrapped + 1) * 15;
            }
            if (n4 < 0) {
                n11 >>= 1;
            }
            int n12 = n3 - (n11 >> 1);
            sDKGraphics.setColor(_current_hud_colors[6]);
            sDKGraphics.fillRect(n10, n12, n9, n11);
            sDKGraphics.setColor(_current_hud_colors[1]);
            sDKGraphics.drawRect(n10, n12, n9, n11);
            sDKGraphics.setClip(n10 + 5, n12, Constants.HUD_TOOLTIPS_TEXT_W, n11);
            SDKUtils.drawString(_tooltip_name_string, n10 + n9 / 2 + _tooltip_name_hscroll, n12, 17);
            if (n4 >= 0) {
                if (bl) {
                    SDKUtils.drawString(_tooltip_cost_string, n10 + n9 / 2, n12 + SDKUtils.getLineSize(), 17);
                } else {
                    SDKUtils.drawWrappedString(_tooltip_cost_string, _txtDescrStringLines, 1, _lines_wrapped, n10 + n9 / 2, n12 + SDKUtils.getLineSize(), 17);
                }
                SDKUtils.setFont(GameImpl.fonts[0]);
            }
            sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
        }
    }

    private static void Build_Draw_SquadSel(SDKGraphics sDKGraphics) {
        byte by = _hud_build_cursor_pos[_hud_current_tab];
        byte by2 = _hud_build_page_pos[_hud_current_tab];
        int n = 97 + (by - by2) * 29;
        Hud.Draw_SquadSel(Constants.HUD_BUILD_SQUADS_POSX, n, _hud_current_squad, sDKGraphics);
    }

    private static void Draw_SquadSel(int n, int n2, int n3, SDKGraphics sDKGraphics) {
        int n4;
        XSprite xSprite = GameImpl._sprites[4];
        int n5 = n4 = n2 - 12 + 6;
        int n6 = 1;
        while (n6 < 3) {
            if (n6 != n3) {
                xSprite.DrawFrame(9 + n6 * 2, n, n5, 0);
                sDKGraphics.setColor(_current_hud_colors[7]);
                sDKGraphics.fillRect(n - 12, n5 - 6, 24, 12);
            }
            ++n6;
            n5 += 12;
        }
        n6 = n4 + (n3 - 1) * 12;
        sDKGraphics.setColor(_current_hud_colors[7]);
        sDKGraphics.fillRect(n - 15, n6 - 9, 30, 18);
        sDKGraphics.setColor(_current_hud_colors[1]);
        sDKGraphics.drawRect(n - 15, n6 - 9, 30, 18);
        xSprite.DrawFrame(9 + n3 * 2 + 1, n, n6, 0);
        xSprite.DrawFrame(5, n, n4 - 12, 0);
        xSprite.DrawFrame(6, n, n5 - 12 + 12, 0);
    }

    public static void Build_Draw_CreepOverlay(SDKGraphics sDKGraphics) {
        int n;
        int n2;
        int n3;
        int n4;
        sDKGraphics.setClip(0, 38, Constants.SV_W, Constants.SV_H);
        sDKGraphics.setColor(52224);
        int n5 = 1;
        if (_hud_building == 2) {
            n5 = 6;
        }
        if ((n4 = Camera._nCamX / 8) < 0) {
            n4 = 0;
        }
        if ((n3 = Camera._nCamY / 8) < 0) {
            n3 = 0;
        }
        if ((n2 = (Camera._nCamX + Constants.SV_W + 8 - 1) / 8) >= Level._coll_map_tw) {
            n2 = Level._coll_map_tw - 1;
        }
        if ((n = (Camera._nCamY + Constants.SV_H + 8 - 1) / 8) >= Level._coll_map_th) {
            n = Level._coll_map_th - 1;
        }
        for (int i = n3; i <= n; ++i) {
            int n6 = i * Level._coll_map_tw + n4;
            int n7 = n4;
            while (n7 <= n2) {
                block12: {
                    block13: {
                        if ((Level._coll_map[n6] & 0x7F) != n5) break block12;
                        if (n5 == 6) break block13;
                        boolean bl = false;
                        for (int j = -1; j <= 1; ++j) {
                            for (int k = -1; k <= 1; ++k) {
                                int n8;
                                if (i + j < 0 || i + j >= Level._coll_map_th || n7 + k < 0 || n7 + k >= Level._coll_map_tw || (n8 = Level._coll_map[n6 + j * Level._coll_map_tw + k] & 0x7F) != 12 && n8 != 6) continue;
                                bl = true;
                                break;
                            }
                            if (bl) break;
                        }
                        if (bl) break block12;
                    }
                    sDKGraphics.setColor(0);
                    sDKGraphics.drawRect(n7 * 8 - Camera._nCamX + 0 + 2, i * 8 - Camera._nCamY + 38 + 2, 6, 6);
                    sDKGraphics.setColor(52224);
                    sDKGraphics.drawRect(n7 * 8 - Camera._nCamX + 0 + 1, i * 8 - Camera._nCamY + 38 + 1, 6, 6);
                }
                ++n7;
                ++n6;
            }
        }
        sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
    }

    private static void Build_Draw_Overlay(SDKGraphics sDKGraphics) {
        sDKGraphics.setClip(0, 38, Constants.SV_W, Constants.SV_H);
        int n = Camera._nCursorPosX;
        int n2 = Camera._nCursorPosY;
        if (_refinery_snap) {
            n = _snap_x;
            n2 = _snap_y;
        }
        int n3 = (n + _hud_building_offx) / 8;
        int n4 = (n2 + _hud_building_offy) / 8;
        int n5 = n3 * 8;
        int n6 = n4 * 8;
        int n7 = 0;
        int n8 = 0;
        int n9 = 65280;
        if (!Hud.Build_IsValidBuildingPosition(n, n2)) {
            n9 = 0xFF0000;
        }
        sDKGraphics.setColor(n9);
        int n10 = 0;
        while (n10 < _hud_building_th) {
            n7 = n5;
            int n11 = 0;
            while (n11 < _hud_building_tw) {
                if (_hud_building_cmap[n8] > 4) {
                    sDKGraphics.fillRect(n7 - Camera._nCamX + 0, n6 - Camera._nCamY + 38, 8, 8);
                }
                ++n11;
                n7 += 8;
                ++n8;
            }
            ++n10;
            n6 += 8;
        }
        sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
    }

    private static void Build_Draw_SW_TargetSelection(SDKGraphics sDKGraphics, int n) {
        sDKGraphics.setClip(0, 38, Constants.SV_W, Constants.SV_H);
        Camera.DrawCursor(sDKGraphics);
        sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
    }

    private static void Build_Unit() {
        byte by = _hud_build_items_available[_hud_current_tab][_hud_build_cursor_pos[_hud_current_tab]];
        int n = Level.GetUnitStats(by, 10);
        if (n > Level._player_money || Level._player_command_points >= Level._player_max_command_points) {
            return;
        }
        Building building = Level.FindSpawnBuilding(by, 0);
        if (Level._buildings_off_times[building._allegiance][building._subtype] > 0) {
            return;
        }
        if (building != null) {
            building.SpawnNewUnit(by);
        }
    }

    private static boolean Build_IsValidBuildingPosition(int n, int n2) {
        int n3 = 1;
        if (_hud_building == 2) {
            n3 = 6;
        }
        int n4 = (n + _hud_building_offx) / 8;
        int n5 = (n2 + _hud_building_offy) / 8;
        int n6 = 0;
        if (_hud_building == 2) {
            for (int i = 0; i < _hud_building_th; ++i) {
                int n7 = 0;
                while (n7 < _hud_building_tw) {
                    if (_hud_building_cmap[n6] == 12 && Level.GetCollisionAtTile(n4 + n7, n5 + i) != n3) {
                        return false;
                    }
                    ++n7;
                    ++n6;
                }
            }
        } else {
            for (int i = 0; i < _hud_building_th; ++i) {
                int n8 = 0;
                while (n8 < _hud_building_tw) {
                    if (_hud_building_cmap[n6] == 12) {
                        if (Level.GetCollisionAtTile(n4 + n8, n5 + i) != n3) {
                            return false;
                        }
                        for (int j = -1; j <= 1; ++j) {
                            for (int k = -1; k <= 1; ++k) {
                                int n9 = Level.GetCollisionAtTile(n4 + n8 + j, n5 + i + k);
                                if (n9 != 12 && n9 != 6) continue;
                                return false;
                            }
                        }
                    }
                    ++n8;
                    ++n6;
                }
            }
        }
        return true;
    }

    private static boolean Build_Building() {
        Entity entity;
        int n = Level.GetBuildingStats(Level._player_faction, _hud_building, 15);
        if (n > Level._player_money) {
            return false;
        }
        if (Level._player_build_points >= Level._player_max_build_points) {
            return false;
        }
        if (Level._buildings_off_times[0][0] > 0) {
            return false;
        }
        int n2 = (Camera._nCursorPosX + _hud_building_offx) / 8;
        int n3 = (Camera._nCursorPosY + _hud_building_offy) / 8;
        int n4 = n2 * 8 - _hud_building_offx;
        int n5 = n3 * 8 - _hud_building_offy;
        if (_refinery_snap) {
            n4 = _snap_x;
            n5 = _snap_y;
        }
        if (!Hud.Build_IsValidBuildingPosition(n4, n5)) {
            return false;
        }
        if (_hud_building == 2) {
            entity = Level.FindClosestMineralField(n4, n5, 64);
            if (entity != null) {
                n4 = entity._pos_x;
                n5 = entity._pos_y + 1;
            } else {
                return false;
            }
        }
        if ((entity = Level.SpawnBuilding(_hud_building, n4, n5, 0, Level._player_faction)) != null) {
            if (((Building)entity)._allegiance == 0) {
                Level._player_money -= Level.GetBuildingStats(((Building)entity)._faction, _hud_building, 15);
                Level._statistics[0] = Level._statistics[0] + 1;
            } else if (((Building)entity)._allegiance == 1) {
                Level._ai_money -= Level.GetBuildingStats(((Building)entity)._faction, _hud_building, 15);
                Level._statistics[1] = Level._statistics[1] + 1;
            }
        }
        return true;
    }

    static void __BUILD() {
    }

    static void PLAY__() {
    }

    public static void Play_Update() {
        int n = 82048;
        int n2 = 32;
        if (Level._enableChangeSK && SDKCanvas.isNewKeyPressed(n2)) {
            _changeDownFrames = 0;
            if (_changeDoubleFrames < 6) {
                Unit unit;
                if (Level.Group_GetLeader(Level._currentGroup) != -1 && (unit = (Unit)Level.GetEntitySafe(Level.Group_GetLeader(Level._currentGroup))) != null) {
                    int n3 = unit._pos_x - (Constants.SV_W >> 1);
                    int n4 = unit._pos_y - (Constants.SV_H >> 1);
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    if (n3 > Level._map_w - Constants.SV_W) {
                        n3 = Level._map_w - Constants.SV_W;
                    }
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (n4 > Level._map_h - Constants.SV_H) {
                        n4 = Level._map_h - Constants.SV_H;
                    }
                    Camera.DoScroll(n3, n4);
                }
                _bchangeDoubleTap = true;
                _changeDoubleFrames = (short)6;
            } else {
                _changeDoubleFrames = 0;
            }
        }
        if (Level._enableChangeSK && SDKCanvas.isKeyPressed(n2)) {
            if (!_bchangeDoubleTap && (_changeDownFrames = (short)(_changeDownFrames + 1)) > 16 && Camera._bUnitsSelected) {
                _changeDownFrames = 0;
                Hud.ChangeState(3, true);
            }
        } else if ((_changeDoubleFrames = (short)(_changeDoubleFrames + 1)) > 6) {
            _changeDoubleFrames = (short)6;
        }
        if (Level._enableChangeSK && SDKCanvas.isNewKeyReleased(n2)) {
            if (!_bchangeDoubleTap && _changeDownFrames > 0 && Hud.CanChangeGroup()) {
                do {
                    if (++Level._currentGroup < 3) continue;
                    Level._currentGroup = 1;
                } while (Level.Group_GetLeader(Level._currentGroup) == -1);
                Camera.SelectCurrentGroup();
            }
            _bchangeDoubleTap = false;
            _changeDownFrames = 0;
        }
        Camera.UpdateCursor();
        if (SDKCanvas.isNewKeyPressed(n) && (_hud_nr_items_available[1] > 0 || _hud_nr_items_available[0] > 0 || _hud_nr_items_available[2] > 0)) {
            Hud.ChangeState(2, true);
        }
    }

    public static void Play_Draw(SDKGraphics sDKGraphics) {
        XSprite xSprite = GameImpl._sprites[4];
        sDKGraphics.setClip(0, 38, Constants.SV_W, Constants.SV_H);
        Camera.DrawCursor(sDKGraphics);
        sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
        Hud.Draw_MiniMap(sDKGraphics);
        Hud.Draw_Details(sDKGraphics);
        sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
        if (Level._enableChangeSK) {
            SDKUtils.setFont(GameImpl.fonts[0]);
            if (Hud.CanChangeGroup()) {
                Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(9, GameImpl._string), true, true, _blink_RSK);
            }
        }
        if (_hud_nr_items_available[1] > 0) {
            xSprite.DrawFrame(25, 0 + (Constants.SV_W >> 1) - 4, 38 + Constants.SV_H, 0, 32);
        }
        Hud.Play_Draw_SuperWeapon_Cooldown(sDKGraphics);
    }

    private static void Play_Draw_SquadSel(SDKGraphics sDKGraphics) {
        int n = 0 + Camera._nCursorPosX - Camera._nCamX;
        int n2 = 38 + Camera._nCursorPosY - Camera._nCamY;
        if (n < 32) {
            n = 32;
        }
        if (n > Constants.SV_W - 32) {
            n = Constants.SV_W - 32;
        }
        if (n2 < 96) {
            n2 = 96;
        }
        if (n2 > Constants.SV_H - 64) {
            n2 = Constants.SV_H - 64;
        }
        _tutorial_squad = -1;
        Hud.Draw_SquadSel(n, n2, Level._currentGroup, sDKGraphics);
    }

    private static void Play_Draw_SuperWeapon_Cooldown(SDKGraphics sDKGraphics) {
        sDKGraphics.setClip(0, 38, Constants.SV_W, Constants.SV_H);
        XSprite xSprite = Level._player_faction == 0 ? GameImpl._sprites[13] : GameImpl._sprites[14];
        int n = 163;
        int n2 = 50;
        byte[] byArray = _hud_build_items_available[2];
        int n3 = _hud_nr_items_available[2];
        for (int i = 0; i < n3; ++i) {
            byte by = byArray[i];
            if (by >= 50) continue;
            if (_sw_cooldown[by] == 0) {
                byte by2 = by;
                _sw_cooldown[by2] = _sw_cooldown[by2] + 10;
            }
            if (_sw_cooldown[by] <= 70 && _sw_cooldown[by] % 10 < 5) {
                SDKUtils.setFont(GameImpl.fonts[1]);
            } else {
                SDKUtils.setFont(GameImpl.fonts[0]);
            }
            xSprite.DrawFrame(3 + by, n, n2, 0);
            GameImpl.DrawSeparatedNumbers(_sw_cooldown[by] / 14 / 60, _sw_cooldown[by] / 14 % 60, ":", n + -8, n2 + 10, 0, 2);
            n += 29;
            SDKUtils.setFont(GameImpl.fonts[0]);
        }
    }

    private static void ChangeSquad_Draw(SDKGraphics sDKGraphics) {
        Hud.Play_Draw_SquadSel(sDKGraphics);
    }

    private static void ChangeSquad_Update() {
        if (SDKCanvas.isNewKeyPressed(32)) {
            Level._currentGroup = _hud_old_squad;
            Hud.ChangeState(1, true);
            SDKCanvas.disableInput(1);
            return;
        }
        if (SDKCanvas.isNewKeyPressed(513)) {
            if (Level._currentGroup > 1) {
                --Level._currentGroup;
            }
        } else if (SDKCanvas.isNewKeyPressed(32770)) {
            if (Level._currentGroup < 2) {
                ++Level._currentGroup;
            }
        } else if (SDKCanvas.isNewKeyReleased(4112)) {
            Camera.CursorOrderGroup();
            Level._currentGroup = _hud_old_squad;
            Hud.ChangeState(1, true);
            SDKCanvas.disableInput(1);
        }
    }

    private static boolean CanChangeGroup() {
        for (int i = 0; i < 3; ++i) {
            if (i == Level._currentGroup || Level.Group_GetLeader(i) == -1) continue;
            return true;
        }
        return false;
    }

    public static void CheckDetailsHudRefresh() {
        if (Level._player_money != _hud_old_player_money || Level._player_power != _hud_old_player_power || Level._player_consumption != _hud_old_player_consumption || Level._player_command_points != _hud_old_player_cmd_points || Level._player_build_points != _hud_old_player_building_cmd_points) {
            Hud.ForceDetailsHudRefresh();
        }
    }

    public static void ForceDetailsHudRefresh() {
        _minimap_refresh_timer = 0;
        _bInvalidateDetailsHud = true;
        _hud_old_player_money = Level._player_money;
        _hud_old_player_power = Level._player_power;
        _hud_old_player_consumption = Level._player_consumption;
        _hud_old_player_cmd_points = Level._player_command_points;
        _hud_old_player_building_cmd_points = Level._player_build_points;
    }

    static void __PLAY() {
    }

    static void RiseMovieBars() {
        _hud_movie_bars = true;
        Hud.ForceDetailsHudRefresh();
    }

    static void SinkMovieBars() {
        _hud_movie_bars = false;
    }

    static void UpdateMovieBars() {
        if (_hud_movie_bars) {
            if (_hud_bars_height < 40) {
                _hud_bars_height += 6;
            }
            if (_hud_bars_height > 40) {
                _hud_bars_height = 40;
            }
        } else if (_hud_bars_height > 0 && (_hud_bars_height -= 6) <= 0) {
            _hud_bars_height = 0;
            Hud.ForceDetailsHudRefresh();
        }
    }

    static void DrawMovieBars(SDKGraphics sDKGraphics) {
        if (_hud_bars_height > 0) {
            sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
            sDKGraphics.setColor(0);
            sDKGraphics.fillRect(0, 0, Constants.SV_W, _hud_bars_height);
            sDKGraphics.fillRect(0, Constants.SCR_H - _hud_bars_height / 2, Constants.SV_W, _hud_bars_height / 2);
        }
    }

    static void DrawSoftKeys(SDKGraphics sDKGraphics, SDKString sDKString, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            sDKString = sDKString.concat(" (Q)");
        } else if (!bl) {
            sDKString = sDKString.concat(" (P)");
        }
        SDKUtils.setFont(GameImpl.fonts[0]);
        SDKUtils.setLeadingSpacing(0);
        int n = SDKUtils.getLineSize();
        int n2 = SDKUtils.getStringSize(sDKString);
        int n3 = n2 + 4;
        boolean bl4 = bl;
        if (bl2) {
            int n4 = 0;
            n4 = bl3 ? _current_hud_colors[2] : _current_hud_colors[1];
            if (bl4) {
                sDKGraphics.setColor(_current_hud_colors[8]);
                sDKGraphics.fillRect(0, Constants.SCR_H - n, n3, n);
                sDKGraphics.setColor(n4);
                sDKGraphics.drawRect(-1, Constants.SCR_H - n, n3, n);
                SDKUtils.drawString(sDKString, 1, Constants.SCR_H - 1, 36);
            } else {
                sDKGraphics.setColor(_current_hud_colors[8]);
                sDKGraphics.fillRect(Constants.SCR_W - n3, Constants.SCR_H - n, n3, n);
                sDKGraphics.setColor(n4);
                sDKGraphics.drawRect(Constants.SCR_W - n3, Constants.SCR_H - n, n3, n);
                SDKUtils.drawString(sDKString, Constants.SCR_W - 1, Constants.SCR_H - 1, 40);
            }
        }
        if (bl4) {
            SDKUtils.drawString(sDKString, 1, Constants.SCR_H - 1, 36);
        } else {
            SDKUtils.drawString(sDKString, Constants.SCR_W - 1, Constants.SCR_H - 1, 40);
        }
    }

    static void MSG_BOX__() {
    }

    static void Start(int n) {
        _msgBoxQueueIndex = 0;
        _msgBoxQueueLast = 0;
        _textHeight = 0;
        _yPosScroll = 0;
        _waitTime = 28;
        _sizeFontText = 0;
        _sizeFontTitle = 0;
        if (n >= 0) {
            int n2 = Script.StartScript(n, 0, 0, 0, 0);
            int n3 = 1;
            if (n2 >= 0) {
                while (n3 > 0) {
                    n3 = Script.RunScript(n2);
                }
                Script.Scripts_Clean();
            }
        } else {
            GameImpl.SetState(8);
        }
    }

    public static void ClearLists() {
        _msgBoxQueueIndex = -1;
        _msgBoxQueueLast = 0;
    }

    static void AddBriefingMessage(int n) {
        _briefing = true;
        if (_msgBoxQueueLast >= 5) {
            return;
        }
        Hud._msgBoxStrQueue[Hud._msgBoxQueueLast] = (short)n;
        Hud._msgBoxTitleQueue[Hud._msgBoxQueueLast] = (short)(168 + Level._crt_level);
        Hud._msgBoxSpeedQueue[Hud._msgBoxQueueLast] = 3;
        if (_msgBoxQueueIndex == _msgBoxQueueLast) {
            Hud.MsgBox_Init();
        }
        ++_msgBoxQueueLast;
    }

    static void AddMessage(int n, int n2, int n3, int n4, int n5, int n6) {
        _briefing = false;
        if (_msgBoxQueueIndex == _msgBoxQueueLast) {
            _msgBoxQueueLast = (_msgBoxQueueIndex + 1) % 5;
        }
        Hud._msgBoxTitleQueue[Hud._msgBoxQueueLast] = (short)n2;
        Hud._msgBoxStrQueue[Hud._msgBoxQueueLast] = (short)n;
        switch (n4) {
            case 2: {
                Hud._msgBoxTitleQueue[Hud._msgBoxQueueLast] = 18;
                break;
            }
            case 16: {
                Hud._msgBoxTitleQueue[Hud._msgBoxQueueLast] = 21;
                break;
            }
            case 8: {
                Hud._msgBoxTitleQueue[Hud._msgBoxQueueLast] = 19;
                break;
            }
            case 4: {
                Hud._msgBoxTitleQueue[Hud._msgBoxQueueLast] = 20;
            }
        }
        Hud._msgBoxPositionQueue[Hud._msgBoxQueueLast] = (short)n4;
        Hud._msgBoxSizeQueue[Hud._msgBoxQueueLast] = (short)n5;
        Hud._msgBoxFlagsQueue[Hud._msgBoxQueueLast] = (short)n6;
        Hud._msgBoxSpeedQueue[Hud._msgBoxQueueLast] = (short)n3;
        _msgBoxQueueLast = (_msgBoxQueueLast + 1) % 5;
        if (_hud_state != 4) {
            Hud.InitNext();
            _hud_old_state = _hud_state;
            _hud_old_substate = _hud_substate;
            Hud.ChangeState(4, true);
            Level._paused = 1;
        }
    }

    public static void MsgBox_Init() {
        short s;
        short s2 = _msgBoxStrQueue[_msgBoxQueueIndex];
        if (s2 >= 0) {
            _msgBoxString = SDKUtils.getString(s2, _msgBoxString);
        }
        if ((s = _msgBoxTitleQueue[_msgBoxQueueIndex]) >= 0) {
            _msgBoxTitle = SDKUtils.getString(s, _msgBoxTitle);
        }
        _speed = _msgBoxSpeedQueue[_msgBoxQueueIndex];
        SDKUtils.setLeadingSpacing(-3);
        int n = Constants.SCR_W - 10 - 20;
        SDKUtils.wrapString(_msgBoxString, _msgBoxStringLines, n, (short)124);
        int n2 = _msgBoxStringLines[0];
        SDKUtils.setFont(GameImpl.fonts[0]);
        _sizeFontText = SDKUtils.getLineSize();
        SDKUtils.setFont(GameImpl.fonts[0]);
        _sizeFontTitle = SDKUtils.getLineSize();
        _visibleNoLines = Constants.BRIEFING_BOX_TEXT_HEIGHT / SDKUtils.getLineSize();
        _textHeight = n2;
        _yPosScroll = 0;
        SDKUtils.setLeadingSpacing(0);
        _waitTime = 28;
    }

    public static void InitNext() {
        if (_briefing) {
            if (_msgBoxQueueIndex < 4) {
                ++_msgBoxQueueIndex;
                Hud.MsgBox_Init();
            }
        } else {
            if (_old_minimap_state != -1) {
                _minimap_state = _old_minimap_state;
                _old_minimap_state = -1;
            }
            if ((_msgBoxQueueLast - _msgBoxQueueIndex + 5) % 5 == 1) {
                Hud.ChangeState(_hud_old_state, false);
                Hud.Build_ChangeSubState(_hud_old_substate);
                Hud.RefreshCursor(_hud_current_tab);
                Level._paused = 0;
                SDKCanvas.disableInput(1);
                return;
            }
            _msgBoxQueueIndex = (_msgBoxQueueIndex + 1) % 5;
            _msgBoxFlags = _msgBoxFlagsQueue[_msgBoxQueueIndex];
            _msgBoxPosition = _msgBoxPositionQueue[_msgBoxQueueIndex];
            _msgBoxSize = _msgBoxSizeQueue[_msgBoxQueueIndex];
            _waitTime = _msgBoxSpeedQueue[_msgBoxQueueIndex];
            short s = _msgBoxStrQueue[_msgBoxQueueIndex];
            _msgBoxString = SDKUtils.getString(s, _msgBoxString);
            SDKUtils.setFont(GameImpl.fonts[0]);
            SDKUtils.setLeadingSpacing(-3);
            int n = Constants.SCR_W - 6 - 5 - 0;
            SDKUtils.wrapString(_msgBoxString, _msgBoxStringLines, n, (short)124);
            short s2 = _msgBoxStringLines[0];
            _msgBoxLinesPerPage = Math.min(s2, _msgBoxSize - 2);
            _msgBoxPageNo = (s2 + _msgBoxLinesPerPage - 1) / _msgBoxLinesPerPage;
            _msgBoxCurrentPage = 0;
            if (_msgBoxPageNo > 1) {
                _pageString = new SDKString(_msgBoxCurrentPage + 1 + "/" + _msgBoxPageNo);
            }
            SDKUtils.setLeadingSpacing(0);
            if ((_msgBoxFlags & 4) == 0) {
                SDKCanvas.disableInput(2);
            }
        }
    }

    public static void InitPrevious() {
        if (_msgBoxQueueIndex > 0) {
            --_msgBoxQueueIndex;
            Hud.MsgBox_Init();
        }
    }

    public static void MsgBox_Update() {
        if (_briefing) {
            SDKUtils.setFont(GameImpl.fonts[0]);
            SDKUtils.setLeadingSpacing(-3);
            int n = SDKUtils.getLineSize();
            if (SDKCanvas.isNewKeyPressed(4144)) {
                if (_msgBoxQueueIndex < _msgBoxQueueLast - 1) {
                    Hud.InitNext();
                } else {
                    GameImpl.SetState(8);
                    _briefing = false;
                    Hud.ClearLists();
                }
                return;
            }
            if (SDKCanvas.isNewKeyPressed(64) || SDKCanvas.isNewKeyPressed(524288)) {
                if (_msgBoxQueueIndex > 0) {
                    Hud.InitPrevious();
                } else {
                    Script.Scripts_Release();
                    GameImpl.PopMenu();
                    Hud.ClearLists();
                }
                return;
            }
            if (SDKCanvas.isKeyPressed(513)) {
                if (--_yPosScroll < 0) {
                    _yPosScroll = 0;
                }
            } else if (SDKCanvas.isKeyPressed(32770) && ++_yPosScroll + Constants.BRIEFING_BOX_TEXT_HEIGHT / n > _textHeight) {
                --_yPosScroll;
            }
            return;
        }
        if (_waitTime <= 0) {
            if (SDKCanvas.isNewKeyReleased(4144)) {
                SDKCanvas.disableInput(0);
                if (_msgBoxCurrentPage < _msgBoxPageNo - 1) {
                    ++_msgBoxCurrentPage;
                    if (_msgBoxPageNo > 1) {
                        _pageString = new SDKString(Integer.toString(_msgBoxCurrentPage + 1) + "/" + Integer.toString(_msgBoxPageNo));
                    }
                } else if (_msgBoxCurrentPage == _msgBoxPageNo - 1) {
                    Hud.InitNext();
                }
                return;
            }
        } else {
            --_waitTime;
        }
    }

    static void MsgBox_Draw(SDKGraphics sDKGraphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = -1;
        SDKUtils.setFont(GameImpl.fonts[0]);
        SDKUtils.setLeadingSpacing(-3);
        int n7 = SDKUtils.getLineSize();
        int n8 = _msgBoxStringLines[0];
        if (_briefing) {
            n5 = 10;
            n4 = 90;
            n3 = Constants.SCR_W - 10 - 20;
            n2 = Constants.BRIEFING_BOX_TEXT_HEIGHT;
        } else {
            n = _msgBoxLinesPerPage;
            n8 = Math.min(_msgBoxLinesPerPage, n8 - _msgBoxCurrentPage * _msgBoxLinesPerPage);
            n6 = _msgBoxTitleQueue[_msgBoxQueueIndex];
            if (_msgBoxFlags != 1) {
                n = n8;
            }
            n5 = 5;
            n4 = 45;
            n3 = Constants.SCR_W - 5 - 6;
            n2 = (n + 1) * n7;
            if (n6 != -1 || _msgBoxPageNo > 1) {
                n2 += n7;
            }
        }
        if (_briefing) {
            SDKUtils.setFont(GameImpl.fonts[0]);
            n6 = _msgBoxTitleQueue[_msgBoxQueueIndex];
            if (n6 != -1) {
                SDKUtils.drawString(_msgBoxTitle, n5 + (n3 >> 1), n4, 1);
            }
            n4 = 105;
            SDKUtils.setFont(GameImpl.fonts[0]);
            Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(5, GameImpl._string), true, true, false);
            Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(4, GameImpl._string), false, true, false);
            SDKUtils.setLeadingSpacing(-3);
            sDKGraphics.setClip(n5, n4, n3, n2);
            n = Math.min(_visibleNoLines, _textHeight - _yPosScroll);
            SDKUtils.drawWrappedString(_msgBoxString, _msgBoxStringLines, 1 + _yPosScroll, n, n5 + (n3 >> 1), n4, 1);
            SDKUtils.setLeadingSpacing(0);
            sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
            sDKGraphics.setColor(0xCC0000);
            sDKGraphics.drawLine(0, n4, Constants.SCR_W, n4);
            sDKGraphics.drawLine(0, n4 + Constants.BRIEFING_BOX_TEXT_HEIGHT, Constants.SCR_W, n4 + Constants.BRIEFING_BOX_TEXT_HEIGHT);
            XSprite xSprite = GameImpl._sprites[23];
            if (_yPosScroll > 0) {
                xSprite.DrawFrame(1, n5 + n3, n4 + 10, 0);
            }
            if (_yPosScroll + _visibleNoLines < _textHeight) {
                xSprite.DrawFrame(2, n5 + n3, n4 + Constants.BRIEFING_BOX_TEXT_HEIGHT - 10, 0);
            }
        } else {
            n4 = Constants.SCR_H - n2 >> 1;
            sDKGraphics.setColor(_current_hud_colors[9]);
            sDKGraphics.fillRect(n5, n4, n3, n2);
            sDKGraphics.setColor(_current_hud_colors[10]);
            sDKGraphics.drawRect(n5, n4, n3, n2);
            n = n4;
            if (n6 != -1) {
                SDKUtils.drawString(SDKUtils.getString(n6, GameImpl._string), n5 + (n3 >> 1), n4 - 2 + 3, 1);
            }
            if (_msgBoxPageNo > 1) {
                SDKUtils.drawString(_pageString, n5 + n3 - 20, n4 - 2, 1);
            }
            if (n6 != -1 || _msgBoxPageNo > 1) {
                n += n7;
            }
            int n9 = n5 + n3 / 2;
            SDKUtils.drawWrappedString(_msgBoxString, _msgBoxStringLines, 1 + _msgBoxCurrentPage * _msgBoxLinesPerPage, n8, n9, (n += n7 / 2) - 2, 1);
        }
        SDKUtils.setLeadingSpacing(0);
    }

    static void __MSG_BOX() {
    }

    static {
        _hud_current_tab = 1;
        _hud_current_squad = 1;
        _bDrawCollisionMap = false;
        _hud_building_cmap = null;
        _old_minimap_state = -1;
        _old_camera_x = 0;
        _old_camera_y = 0;
        _hud_timer = 0;
        _tutorial_squad = 0;
        _event_timer = 0;
        _move_tab = 0;
        _refinery_snap = false;
        _bInvalidateDetailsHud = true;
        _minimap_refresh_timer = 0;
        _hud_old_player_money = -1;
        _hud_old_player_power = -1;
        _hud_old_player_consumption = -1;
        _hud_old_player_cmd_points = -1;
        _hud_old_player_building_cmd_points = -1;
        _hud_build_items_available = new byte[3][10];
        _hud_nr_items_available = new byte[3];
        _hud_build_items_available_mask = new int[3];
        _hud_build_cursor_pos = new byte[3];
        _hud_build_page_pos = new byte[3];
        _hud_build_items = new byte[][][]{new byte[][]{new byte[0], new byte[0]}, new byte[][]{{0, 2, 1, 3}, {6, 7, 9, 8}}, new byte[][]{{0}, {1}}};
        _hud_build_items_count = new byte[]{0, 0, 4, 4, 1, 1};
        _txtDescrStringLines = new short[100];
        _strBase = 0;
        _old_player_money = 0;
        _tooltip_name_hscroll = 0;
        _tooltip_name_hscroll_speed = 0;
        _tooltip_name_string = new SDKString("");
        _tooltip_cost_string = new SDKString("");
        _tooltip_old_name = -1;
        _briefing = true;
        _msgBoxTitle = new SDKString();
        _msgBoxString = new SDKString();
        _pageString = new SDKString();
        _msgBoxQueueIndex = -1;
        _msgBoxQueueLast = 0;
        _msgBoxTitleQueue = new short[5];
        _msgBoxStrQueue = new short[5];
        _msgBoxPositionQueue = new short[5];
        _msgBoxSizeQueue = new short[5];
        _msgBoxFlagsQueue = new short[5];
        _msgBoxSpeedQueue = new short[5];
        _msgBoxPosition = 32;
        _msgBoxSize = 0;
        _msgBoxFlags = 0;
        _visibleNoLines = 0;
        _textHeight = 0;
        _yPosScroll = 90;
        _waitTime = 28;
        _sizeFontText = 0;
        _sizeFontTitle = 0;
        _speed = 0;
        _msgBoxStringLines = new short[100];
    }
}

