/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Building;
import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Debug;
import com.ea.game.Entity;
import com.ea.game.GraphicsConstants;
import com.ea.game.Hud;
import com.ea.game.IStringConstants;
import com.ea.game.Key;
import com.ea.game.Level;
import com.ea.game.Script;
import com.ea.game.SpriteConstants;
import com.ea.game.Unit;
import com.ea.game.XSprite;
import com.ea.sdk.ResourceLoader;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGame;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKMIDlet;
import com.ea.sdk.SDKMoreGames;
import com.ea.sdk.SDKSoundManager;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import java.io.IOException;
import java.util.Random;
import net.rim.device.api.system.Application;
import net.rim.device.api.system.SystemListener;
import net.rim.device.api.system.SystemListener2;
import net.rim.device.api.ui.UiApplication;

public class GameImpl
implements SDKGame,
ResourceLoader,
Constants,
Key,
SpriteConstants,
GraphicsConstants,
IStringConstants,
SystemListener2 {
    static String _versionNumber;
    public static SDKString _stringVer;
    protected static SDKSoundManager _soundManager;
    static SDKCanvas _canvas;
    public static GameImpl _instance;
    public static Object[] fonts;
    public static SDKString _string;
    public static int _gameState;
    public static boolean _player_won;
    private static int _screenW;
    private static int _screenH;
    static int _loadingStatus;
    static int _loadingMax;
    static int _timer;
    static int _frameCounter;
    private static long legalsInitTime;
    static int _maxSovietMission;
    static int _maxAlliedMission;
    static int _maxSkirmishMission;
    static int _nextMission;
    static int _oldSovietMission;
    static int _oldAlliedMission;
    static int _oldSkirmishMission;
    static boolean _soundEnable;
    static boolean _vibrationsEnable;
    static boolean _tutorialEnable;
    static int _language;
    private static int _ID;
    private static byte[] _realData;
    private static int _pos;
    public boolean bIsShown = true;
    public static boolean bBacklightOn;
    public static boolean bBacklightStateChange;
    private static int soundVolume;
    public static SDKString[] _cheatsStrings;
    public static SDKString[] _cheatsNames;
    public static boolean _cheatsEnabledInJad;
    public static char[] _cheatsKeyBuffer;
    public static int _cheatsKeyBufferPos;
    public static int _cheatsDrawTimer;
    public static int _cheatsActive;
    public static short[][] _menuItems;
    public static short[] _menuNames;
    public static short[] _menuSoftKeys;
    static int _menuSP;
    static int[] _menuStack;
    static int[] _menuSelectionStack;
    public static SDKMoreGames _mgInstance;
    public static int _numLangsLoaded;
    public static SDKString _scrolltxt_string;
    public static short[] _scrolltxt_wraplines;
    public static short _scrolltxt_visible_lines;
    public static short _scrolltxt_pos;
    public static short _scrolltxt_nolines;
    public static int _current_menu_language;
    public static int _nextMenuState;
    public static SDKImage[] _mgImages;
    public static boolean bMoreGames;
    static String[] _spritesNames;
    public static final short[] _spriteFlags;
    public static final byte[] _spritePalCount;
    static SDKImage _legalImage;
    public static final byte[] _tileSets;
    static XSprite[] _sprites;
    static int[][] _tutorials;
    public static byte[] _versorX;
    public static byte[] _versorY;
    public static int[] _rgbData;
    public static int _rgbData_OldColor;
    public static int _rgbData_OldW;
    static int[] _rect;
    static Random _rand;
    public static long _randomSeed;
    static SDKString _temp_string;
    static int[] _qsort_w_array;
    static int[] _qsort_other_array;
    private static int _snow_state;
    private static int _snow_particles;
    private static int[] _snow_pos_x;
    private static int[] _snow_pos_y;
    private static int[] _snow_spd_x;
    private static int[] _snow_spd_y;
    private static int[] _snow_time;
    public static SDKString _numbersString;
    public static SDKString _separatedNumbersString;
    public static int _old_number;
    public static int _old_number1;
    public static int _old_number2;
    public static int _old_minSize;
    public static int _fadeCounter;
    public static boolean _darkFade;
    public static int _fadeSteps;
    public static boolean _fadeIn;

    public GameImpl(SDKCanvas sDKCanvas) {
        _canvas = sDKCanvas;
        _instance = this;
    }

    public void init() {
        Application.getApplication().addSystemListener((SystemListener)this);
        GameImpl.SetState(0);
        _loadingStatus = 0;
    }

    public void first_time_init() {
        switch (_loadingStatus) {
            case 0: {
                _versionNumber = "VERSION: " + SDKMIDlet.getAppProp("MIDlet-Version");
                _stringVer = new SDKString(_versionNumber);
                fonts = new Object[2];
                byte[] byArray = SDKInputStream.loadResourceAsByteArray(0);
                GameImpl.fonts[0] = SDKUtils.loadFont(SDKInputStream.loadImageObject(1), byArray);
                GameImpl.fonts[1] = SDKUtils.loadFont(SDKInputStream.loadImageObjectWithPalette(1, 2), byArray);
                Debug.setFont(fonts[0]);
                System.gc();
                break;
            }
            case 1: {
                _soundManager = SDKSoundManager.getManager();
                _soundManager.setLoader(this);
                break;
            }
            case 2: {
                try {
                    SDKInputStream sDKInputStream = new SDKInputStream(6);
                    Level._hud_colors = new int[2][];
                    Level._hud_colors[0] = GameImpl.ReadIntArray(sDKInputStream, 11, null, 0);
                    Level._hud_colors[1] = GameImpl.ReadIntArray(sDKInputStream, 11, null, 0);
                    sDKInputStream.close();
                    sDKInputStream = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Hud._current_hud_colors = Level._hud_colors[0];
                GameImpl.LoadLegal();
                GameImpl.InitMenu();
                break;
            }
            case 3: {
                GameImpl.InitSprites();
                GameImpl.MarkInitSprites();
                GameImpl.LoadSplash();
                break;
            }
            case 4: {
                GameImpl.SetState(1);
                _loadingStatus = 0;
                _loadingMax = 11;
                _timer = 0;
                _maxSovietMission = 0;
                _maxAlliedMission = -1;
                _maxSkirmishMission = 8;
                _nextMission = -1;
                GameImpl.loadRMS();
                GameImpl.InitCheats();
                legalsInitTime = System.currentTimeMillis();
                return;
            }
        }
        ++_loadingStatus;
    }

    public byte[] loadResource(int n) {
        return SDKInputStream.loadResourceAsByteArray(n);
    }

    public void update(long l) {
        UiApplication.getUiApplication().getActiveScreen().setTrackballSensitivityXOffset(0);
        UiApplication.getUiApplication().getActiveScreen().setTrackballSensitivityYOffset(0);
        _screenW = _canvas.getWidth();
        _screenH = _canvas.getHeight();
        GameImpl.UpdateCheats();
        if (UiApplication.getUiApplication().isForeground()) {
            if (!this.bIsShown) {
                this.bIsShown = true;
                if (_soundEnable && _gameState == 4 && !bMoreGames) {
                    GameImpl.PlaySound(4, -1);
                }
                if (_soundEnable && (_gameState == 5 || _gameState == 6)) {
                    GameImpl.PlaySound(5, -1);
                }
            }
        } else if (this.bIsShown) {
            this.bIsShown = false;
            _soundManager.stopSounds();
        }
        switch (_gameState) {
            case 0: {
                this.first_time_init();
                break;
            }
            case 1: {
                if (l - legalsInitTime <= 3000L) break;
                legalsInitTime = l;
                int n = SDKUtils.chooseLanguage(_language);
                if (n < 0) {
                    GameImpl.SetState(10);
                    if (n < 0) {
                        n = 0;
                    } else if (n >= _numLangsLoaded) {
                        n = _numLangsLoaded - 1;
                    }
                    _current_menu_language = n;
                    SDKUtils.setCurrentLanguage(n);
                } else {
                    SDKUtils.setCurrentLanguage(n);
                    _language = n;
                    GameImpl.SetState(2);
                }
                _legalImage = null;
                System.gc();
                break;
            }
            case 2: {
                if (_loadingStatus == _loadingMax) {
                    GameImpl.SetState(3);
                    break;
                }
                GameImpl.InitGame();
                break;
            }
            case 3: {
                GameImpl.UpdateSoundEnable();
                break;
            }
            case 4: {
                GameImpl.UpdateMenu();
                break;
            }
            case 5: {
                UiApplication.getUiApplication().getActiveScreen().setTrackballSensitivityXOffset(100);
                UiApplication.getUiApplication().getActiveScreen().setTrackballSensitivityYOffset(100);
                this.updateGame();
                break;
            }
            case 8: {
                Level.LoadLevel(Level._crt_level, _loadingStatus);
                if (_loadingStatus != 10) break;
                if (Level._crt_level < 7) {
                    _nextMission = Level._crt_level;
                    if (Level._crt_level <= 3) {
                        if (_maxSovietMission < _nextMission) {
                            _maxSovietMission = _nextMission;
                        }
                    } else if (Level._crt_level <= 7 && _maxAlliedMission < _nextMission) {
                        _maxAlliedMission = _nextMission;
                    }
                    GameImpl.saveRMS();
                }
                GameImpl.SetState(5);
                Level._attackSoundPlayed = false;
                Level._lastAttackSoundFrame = 0;
                Level._firstAttackFrame = 0;
                SDKInputStream.purgeCache();
                System.gc();
                GameImpl.PlaySound(5, -1);
                break;
            }
            case 9: {
                GameImpl.UpdateLoadingMainMenu();
                break;
            }
            case 6: {
                GameImpl.UpdateMenu();
                break;
            }
            case 7: {
                GameImpl.UpdateMenu();
                break;
            }
            case 10: {
                GameImpl.UpdateChooseLanguage();
                break;
            }
            case 11: {
                GameImpl.UpdateLoadingBriefing();
                break;
            }
            case 12: {
                GameImpl.UpdateLoadingMG();
            }
        }
    }

    public void draw(SDKGraphics sDKGraphics) {
        if (!UiApplication.getUiApplication().isForeground()) {
            return;
        }
        if (_gameState != 5) {
            this.clearScreen(sDKGraphics, 0);
        }
        SDKUtils.setGraphics(sDKGraphics);
        XSprite.SetGraphics(sDKGraphics);
        switch (_gameState) {
            case 0: {
                GameImpl.DrawLoading(sDKGraphics);
                break;
            }
            case 1: {
                this.PaintLegals(sDKGraphics);
                break;
            }
            case 2: {
                GameImpl.DrawLoading(sDKGraphics);
                break;
            }
            case 3: {
                GameImpl.DrawSoundEnable(sDKGraphics);
                break;
            }
            case 9: {
                GameImpl.DrawLoadingMainMenu(sDKGraphics);
                break;
            }
            case 4: {
                GameImpl.DrawMenu(sDKGraphics);
                break;
            }
            case 5: {
                this.drawGame(sDKGraphics);
                break;
            }
            case 8: {
                GameImpl.DrawLoading(sDKGraphics);
                break;
            }
            case 6: {
                this.drawGame(sDKGraphics);
                GameImpl.DrawMenu(sDKGraphics);
                break;
            }
            case 7: {
                GameImpl.DrawMenu(sDKGraphics);
                break;
            }
            case 10: {
                sDKGraphics.setColor(0);
                sDKGraphics.fillRect(0, 0, Constants.SCR_W, Constants.SCR_H);
                GameImpl.DrawChooseLanguage(sDKGraphics);
                break;
            }
            case 11: {
                GameImpl.DrawLoading(sDKGraphics);
                break;
            }
            case 12: {
                GameImpl.DrawLoading(sDKGraphics);
            }
        }
        GameImpl.PaintCheats(sDKGraphics);
    }

    public void appScreenChanged(int n, int n2) {
    }

    public void backlightStateChange(boolean bl) {
        bBacklightStateChange = true;
        if (bl) {
            UiApplication.getUiApplication().requestForeground();
            bBacklightOn = true;
        } else {
            bBacklightOn = false;
        }
    }

    public void cradleMismatch(boolean bl) {
    }

    public void fastReset() {
    }

    public void powerOffRequested(int n) {
    }

    public void usbConnectionStateChange(int n) {
    }

    public void batteryStatusChange(int n) {
    }

    public void batteryGood() {
    }

    public void batteryLow() {
    }

    public void powerOff() {
    }

    public void powerUp() {
    }

    public void pause() {
        _soundManager.stopSounds();
        Level._old_paused = Level._paused;
        Level._paused = 1;
        UiApplication.getUiApplication().requestBackground();
    }

    public void resume() {
        Level._paused = Level._old_paused;
        if (_gameState == 5) {
            GameImpl.SetState(6);
        }
        Hud.ForceDetailsHudRefresh();
        if (bBacklightStateChange) {
            bBacklightStateChange = false;
            if (!UiApplication.getUiApplication().isForeground() && !bBacklightOn) {
                return;
            }
        } else if (!UiApplication.getUiApplication().isForeground()) {
            return;
        }
        if (_soundEnable && _gameState == 4 && !bMoreGames) {
            GameImpl.PlaySound(4, -1);
        }
        if (_soundEnable && (_gameState == 5 || _gameState == 6)) {
            GameImpl.PlaySound(5, -1);
        }
    }

    public void exiting() {
        _soundManager.stopSounds();
    }

    void PaintLegals(SDKGraphics sDKGraphics) {
        sDKGraphics.drawImage(_legalImage, Constants.SCR_W >> 1, Constants.SCR_H >> 1, 3);
    }

    public static void UpdateSoundEnable() {
        if (SDKCanvas.isNewKeyPressed(64) || SDKCanvas.isNewKeyPressed(524288)) {
            _soundEnable = false;
            GameImpl.ResetMenuStack();
            GameImpl.SetState(4);
        } else if (SDKCanvas.isNewKeyPressed(4144)) {
            _soundEnable = true;
            GameImpl.ResetMenuStack();
            GameImpl.SetState(4);
        }
    }

    public static void DrawSoundEnable(SDKGraphics sDKGraphics) {
        GameImpl.DrawSplash(sDKGraphics);
        SDKUtils.setFont(fonts[0]);
        SDKUtils.getString(15, _string);
        SDKUtils.drawString(_string, Constants.SCR_W >> 1, Constants.SCR_H >> 1, 17);
        Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(11, _string), true, true, false);
        Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(12, _string), false, true, false);
    }

    public void appKeyPressed(int n, long l) {
        if (n == 0x400000) {
            GameImpl.soundVolumeDown();
            return;
        }
        if (n == 0x200000) {
            GameImpl.soundVolumeUp();
            return;
        }
        if (_gameState == 4 && _menuStack[_menuSP] == 20) {
            _mgInstance.processKey(n);
        }
        switch (_gameState) {
            case 5: {
                if (n != 64 && n != 524288) break;
                GameImpl.SetState(6);
            }
        }
    }

    public void appKeyReleased(int n, long l) {
    }

    public void appLetterPressed(int n, long l) {
    }

    public void appLetterReleased(int n, long l) {
    }

    public void updateSoftKeyLabels(String string, String string2) {
    }

    public void appPointerPressed(int n, int n2, long l) {
    }

    public void appPointerReleased(int n, int n2, long l) {
    }

    public void appPointerDragged(int n, int n2, long l) {
    }

    private void updateGame() {
        ++_frameCounter;
        Level.UpdateLevel();
    }

    private void drawGame(SDKGraphics sDKGraphics) {
        Level.DrawLevel(sDKGraphics);
        SDKUtils.setFont(fonts[0]);
    }

    public static void DrawLoading(SDKGraphics sDKGraphics) {
        if (_gameState == 2 || _gameState == 11) {
            GameImpl.DrawSplash(sDKGraphics);
        }
        int n = _loadingStatus * Constants.LOADING_LINE_WIDTH / _loadingMax;
        sDKGraphics.setColor(0xFF0000);
        sDKGraphics.fillRect(0, Constants.LOADING_LINE_Y, n, 3);
        if (_loadingStatus != _loadingMax && _gameState != 0) {
            SDKUtils.setFont(fonts[0]);
            SDKUtils.getString(14, _string);
            SDKUtils.drawString(_string, 5, Constants.LOADING_POS_Y_STR, 16);
        }
    }

    public static void DrawSplash(SDKGraphics sDKGraphics) {
        XSprite xSprite = _sprites[23];
        if (_language == 1) {
            xSprite.DrawFrame(3, 0, 0, 0);
        } else if (_language == 3) {
            xSprite.DrawFrame(4, 0, 0, 0);
        } else {
            xSprite.DrawFrame(0, 0, 0, 0);
        }
    }

    static void SetState(int n) {
        SDKCanvas.disableInput(0);
        switch (_gameState) {
            case 4: {
                break;
            }
            case 6: {
                SDKCanvas.disableInput(2);
            }
        }
        switch (n) {
            case 0: {
                _loadingStatus = 0;
                _loadingMax = 5;
                break;
            }
            case 5: {
                Hud.ForceDetailsHudRefresh();
                break;
            }
            case 8: {
                Camera._nCamX = 0;
                Camera._nCamY = 0;
                Level.InitLevel();
                _loadingStatus = 0;
                _loadingMax = 11;
                Level._paused = 0;
                SDKCanvas.disableInput(2);
                _soundManager.stopSounds();
                break;
            }
            case 4: {
                Hud._current_hud_colors = Level._hud_colors[0];
                GameImpl.PlaySound(4, -1);
                GameImpl.ResetMenuStack();
                GameImpl.ShowMenu(0);
                SDKCanvas.disableInput(2);
                break;
            }
            case 2: {
                SDKUtils.loadStringsChunk(1);
                break;
            }
            case 6: {
                SDKCanvas.disableInput(2);
                GameImpl.ResetMenuStack();
                GameImpl.ShowMenu(9);
                break;
            }
            case 7: {
                if (_player_won) {
                    GameImpl.ShowMenu(21);
                    break;
                }
                GameImpl.ShowMenu(22);
                break;
            }
            case 9: {
                _loadingStatus = 0;
                _loadingMax = 2;
                _nextMenuState = 4;
                _soundManager.stopSounds();
                break;
            }
            case 11: {
                Script.Scripts_Release();
                Script.Scripts_Init(Level._crt_level);
                _loadingStatus = 0;
                _loadingMax = 2 + Script._last_script_file - Script._first_script_file + 1;
                break;
            }
            case 12: {
                _loadingStatus = 0;
                _loadingMax = 4;
            }
        }
        _gameState = n;
    }

    private void clearScreen(SDKGraphics sDKGraphics, int n) {
        sDKGraphics.setColor(n);
        sDKGraphics.setClip(0, 0, _screenW, _screenH);
        sDKGraphics.fillRect(0, 0, _screenW, _screenH);
    }

    public static void InitGame() {
        switch (_loadingStatus) {
            case 0: {
                Level._imgBB = SDKUtils.createImage(Constants.CDB_W, Constants.CDB_H);
                Level._gBB = Level._imgBB.getGraphics();
                Level._crt_level = -1;
                Level._b_skirmish = false;
                Level._player_sk_faction = 2;
                Level._ai_sk_faction = 2;
                Level.InitStats();
                Level.InitCMaps();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                GameImpl.LoadSprites();
                break;
            }
            case 9: {
                Entity.Triggers_Init();
                Entity.WayPoints_Init();
                Entity.BuildSpots_Init();
                GameImpl.SnowInit();
                Script.Scripts_Init(-1);
                Level.InitEntities();
                int n = Script._last_script_file - Script._first_script_file;
                for (int i = 0; i <= n; ++i) {
                    Script.LoadScripts(i);
                }
                break;
            }
            case 10: {
                Script.AI_Init();
                GameImpl.Tutorials_Init();
                GameImpl.setSeed(System.currentTimeMillis());
                SDKUtils.loadStringsChunk(2);
                SDKUtils.loadStringsChunk(11);
            }
        }
        ++_loadingStatus;
    }

    public static void rewindSaveBuffer() {
        _pos = 0;
    }

    public static void putIntSaveBuffer(int n) {
        if (_pos + 4 >= _realData.length) {
            System.out.println("int BUFFER_SIZE too small!" + _pos);
            return;
        }
        for (int i = 0; i < 4; ++i) {
            GameImpl._realData[GameImpl._pos++] = (byte)(n & 0xFF);
            n >>= 8;
        }
    }

    public static void putBoolSaveBuffer(boolean bl) {
        if (_pos >= _realData.length) {
            System.out.println("bool BUFFER_SIZE too small!");
            return;
        }
        GameImpl._realData[GameImpl._pos++] = (byte)(bl ? 1 : 0);
    }

    public static void putShortSaveBuffer(short s) {
        if (_pos + 2 >= _realData.length) {
            System.out.println("short BUFFER_SIZE too small!" + _pos);
            return;
        }
        for (int i = 0; i < 2; ++i) {
            GameImpl._realData[GameImpl._pos++] = (byte)(s & 0xFF);
            s = (short)(s >> 8);
        }
    }

    public static void putLongSaveBuffer(long l) {
        if (_pos + 8 >= _realData.length) {
            System.out.println("long BUFFER_SIZE too small!" + _pos);
            return;
        }
        for (int i = 0; i < 8; ++i) {
            GameImpl._realData[GameImpl._pos++] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    public static void putByteSaveBuffer(byte by) {
        if (_pos >= _realData.length) {
            System.out.println("int BUFFER_SIZE too small!" + _pos);
            return;
        }
        GameImpl._realData[GameImpl._pos++] = by;
    }

    public static int getIntSaveBuffer() {
        if (_pos + 4 >= _realData.length) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n += (_realData[_pos++] & 0xFF) << i * 8;
        }
        return n;
    }

    public static long getLongSaveBuffer() {
        if (_pos + 8 >= _realData.length) {
            return 0L;
        }
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l += (long)((_realData[_pos++] & 0xFF) << i * 8);
        }
        return l;
    }

    public static boolean getBoolSaveBuffer() {
        if (_pos >= _realData.length) {
            return false;
        }
        return _realData[_pos++] == 1;
    }

    public static short getShortSaveBuffer() {
        if (_pos + 2 >= _realData.length) {
            return 0;
        }
        short s = 0;
        for (int i = 0; i < 2; ++i) {
            s = (short)(s + ((_realData[_pos++] & 0xFF) << i * 8));
        }
        return s;
    }

    public static byte getByteSaveBuffer() {
        if (_pos >= _realData.length) {
            return 0;
        }
        return _realData[_pos++];
    }

    private static void showData() {
        System.out.println("DATA-->");
        for (int i = 0; i < _realData.length; ++i) {
            System.out.print(" " + _realData[i]);
        }
        System.out.println("");
        System.out.println("<--DATA");
    }

    public static void saveRMS() {
        _pos = 0;
        GameImpl.putIntSaveBuffer(_maxSovietMission);
        GameImpl.putIntSaveBuffer(_maxAlliedMission);
        GameImpl.putIntSaveBuffer(_maxSkirmishMission);
        GameImpl.putIntSaveBuffer(_nextMission);
        GameImpl.putBoolSaveBuffer(_vibrationsEnable);
        GameImpl.putIntSaveBuffer(_language);
        SDKUtils.saveRecord(_ID, _realData);
        GameImpl.showData();
    }

    public static void loadRMS() {
        if (SDKUtils.isRecordEmpty(_ID)) {
            return;
        }
        _realData = SDKUtils.loadRecord(_ID);
        _maxSovietMission = GameImpl.getIntSaveBuffer();
        _maxAlliedMission = GameImpl.getIntSaveBuffer();
        _maxSkirmishMission = GameImpl.getIntSaveBuffer();
        _nextMission = GameImpl.getIntSaveBuffer();
        _vibrationsEnable = GameImpl.getBoolSaveBuffer();
        _language = GameImpl.getIntSaveBuffer();
    }

    public static void Vibrate(int n) {
        if (_vibrationsEnable) {
            _soundManager.vibrate(n);
        }
    }

    public static void PlaySound(int n, int n2) {
        if (_soundEnable) {
            _soundManager.stopSounds();
            _soundManager.setCurrentLoop(n2);
            _soundManager.playSound(n);
        }
    }

    static void soundVolumeUp() {
        if (soundVolume <= 100) {
            soundVolume += 10;
            try {
                _soundManager.setSoundVolume(soundVolume);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void soundVolumeDown() {
        if (soundVolume >= 0) {
            soundVolume -= 10;
            try {
                _soundManager.setSoundVolume(soundVolume);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void InitCheats() {
        try {
            String string = SDKMIDlet.getAppProp("Enable-Cheats");
            _cheatsEnabledInJad = string != null ? string.trim().toUpperCase().equals("ON") : false;
        }
        catch (Exception exception) {
            _cheatsEnabledInJad = false;
        }
        _cheatsActive = 0;
        for (int i = 0; i < 10; ++i) {
            GameImpl._cheatsKeyBuffer[i] = '\u0000';
        }
        _cheatsKeyBufferPos = 0;
    }

    public static void UpdateCheats() {
        if (!_cheatsEnabledInJad) {
            return;
        }
        if (_cheatsDrawTimer > 0) {
            --_cheatsDrawTimer;
        }
        if (SDKCanvas.isNewKeyPressed(130944)) {
            int n;
            for (n = 0; n < 10; ++n) {
                if (!SDKCanvas.isNewKeyPressed(128 << n)) continue;
                GameImpl._cheatsKeyBuffer[GameImpl._cheatsKeyBufferPos++] = (char)(48 + n);
                if (_cheatsKeyBufferPos < 10) continue;
                _cheatsKeyBufferPos = 0;
            }
            for (n = 0; n < 5; ++n) {
                char c;
                char c2;
                int n2;
                SDKString sDKString = _cheatsStrings[n];
                int n3 = sDKString.length();
                for (n2 = n3 - 1; n2 >= 0 && (c2 = sDKString.charAt(n2)) == (c = _cheatsKeyBuffer[(_cheatsKeyBufferPos - (n3 - n2) + 10) % 10]); --n2) {
                }
                if (n2 != -1) continue;
                _cheatsDrawTimer = 20;
                GameImpl.ActivateCheat(n);
            }
        }
    }

    public static void PaintCheats(SDKGraphics sDKGraphics) {
        if (!_cheatsEnabledInJad) {
            return;
        }
        if (_cheatsDrawTimer > 0) {
            int n = 5;
            for (int i = 0; i < 5; ++i) {
                SDKString sDKString;
                if (GameImpl.IsCheatActive(i)) {
                    SDKUtils.setFont(fonts[0]);
                    sDKString = _cheatsNames[i];
                    SDKUtils.drawString(sDKString, 3, n, 0);
                } else {
                    SDKUtils.setFont(fonts[1]);
                    sDKString = _cheatsNames[i];
                    SDKUtils.drawString(sDKString, 3, n, 0);
                }
                n += 20;
            }
        }
    }

    public static boolean IsCheatActive(int n) {
        if (!_cheatsEnabledInJad) {
            return false;
        }
        return (_cheatsActive & 1 << n) != 0;
    }

    public static void DisableCheat(int n) {
        if (!_cheatsEnabledInJad) {
            return;
        }
        _cheatsActive &= ~(1 << n);
    }

    public static void ActivateCheat(int n) {
        _cheatsActive ^= 1 << n;
        if (GameImpl.IsCheatActive(0)) {
            _maxSovietMission = 3;
            _maxAlliedMission = 7;
            _maxSkirmishMission = 11;
        }
        if (GameImpl.IsCheatActive(1) && _gameState == 5) {
            SDKCanvas.disableInput(2);
            Level.EndLevel(0);
        }
        if (GameImpl.IsCheatActive(2) && _gameState == 5) {
            SDKCanvas.disableInput(2);
            Level.EndLevel(1);
        }
    }

    static void MENU__() {
    }

    static void InitMenu() {
        _menuSP = 0;
        GameImpl._menuStack[GameImpl._menuSP] = 0;
        GameImpl._menuSelectionStack[GameImpl._menuSP] = 0;
        byte[] byArray = SDKInputStream.loadResourceAsByteArray(3);
        _numLangsLoaded = SDKUtils.loadTextHeader(byArray);
        _mgInstance = new SDKMoreGames(Constants.SCR_W, Constants.SCR_H){

            public SDKImage getImage(String string) {
                if (_mgImages == null) {
                    return null;
                }
                if (string.equals("FNR")) {
                    return _mgImages[0];
                }
                if (string.equals("TET")) {
                    return _mgImages[1];
                }
                if (string.equals("LOG")) {
                    return _mgImages[2];
                }
                if (string.equals("MHA")) {
                    return _mgImages[3];
                }
                return null;
            }
        };
        _mgInstance.setProductData(SDKInputStream.loadResourceAsByteArray(7));
        Object[] objectArray = new Object[5];
        objectArray[0] = fonts[0];
        objectArray[2] = fonts[0];
        objectArray[3] = fonts[0];
        objectArray[4] = fonts[0];
        objectArray[1] = fonts[0];
        _mgInstance.setFonts(objectArray);
        _scrolltxt_string = new SDKString();
        _scrolltxt_wraplines = new short[100];
    }

    static void UpdateMenu() {
        int n;
        boolean bl = _gameState == 6;
        int n2 = _menuStack[_menuSP];
        if (n2 == 4 || n2 == 3 || n2 == 15 || n2 == 16) {
            GameImpl.UpdateScrollingText();
            return;
        }
        if (n2 == 19) {
            Hud.MsgBox_Update();
            return;
        }
        if (n2 == 20) {
            if (_mgInstance.isActive()) {
                if (!bMoreGames) {
                    _soundManager.stopSounds();
                    bMoreGames = true;
                }
                _mgInstance.update();
            } else {
                _mgImages = null;
                SDKInputStream.purgeCache();
                System.gc();
                GameImpl.PopMenu();
                if (bMoreGames) {
                    GameImpl.PlaySound(4, -1);
                    bMoreGames = false;
                }
            }
            return;
        }
        if (n2 == 18) {
            GameImpl.UpdateChooseLanguage();
            return;
        }
        if (n2 == 21 || n2 == 22) {
            GameImpl.UpdateStatsScreen();
            return;
        }
        short[] sArray = _menuItems[n2];
        if (sArray != null) {
            if (SDKCanvas.isNewKeyPressed(4112)) {
                SDKCanvas.disableInput(0);
                if (n2 != 17) {
                    GameImpl.MenuAction(sArray[_menuSelectionStack[_menuSP]]);
                }
            } else if (SDKCanvas.isNewKeyPressed(33283)) {
                short s;
                n = sArray.length;
                int n3 = SDKCanvas.isNewKeyPressed(513) ? -1 : 1;
                int n4 = _menuSelectionStack[_menuSP];
                do {
                    GameImpl._menuSelectionStack[GameImpl._menuSP] = (n3 + _menuSelectionStack[_menuSP] + n) % n;
                } while ((s = sArray[_menuSelectionStack[_menuSP]]) != -1 && _menuSelectionStack[_menuSP] != n4 && (s == 156 && !_mgInstance.isAvailable() || s == 155 && bl || s == 189 && bl || s == 158 && _nextMission < 0 || n2 == 1 && s == 181 && _maxAlliedMission < 4 || n2 == 5 && _menuSelectionStack[_menuSP] > _maxSovietMission || n2 == 6 && _menuSelectionStack[_menuSP] > _maxAlliedMission - 4 || n2 == 8 && _menuSelectionStack[_menuSP] > _maxSkirmishMission - 8));
                SDKCanvas.disableInput(0);
            }
        }
        if (SDKCanvas.isNewKeyPressed(96) || SDKCanvas.isNewKeyPressed(524288)) {
            n = _menuSoftKeys[(n2 << 1) + (SDKCanvas.isKeyPressed(64) || SDKCanvas.isKeyPressed(524288) ? 1 : 0)];
            SDKCanvas.disableInput(0);
            if (n == 6) {
                if (_menuSelectionStack[_menuSP] < sArray.length) {
                    GameImpl.MenuAction(sArray[_menuSelectionStack[_menuSP]]);
                }
            } else {
                GameImpl.MenuAction(n);
            }
        }
    }

    static void DrawMenuBackground(SDKGraphics sDKGraphics, int n) {
        sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
        sDKGraphics.setColor(0);
        sDKGraphics.fillRect(0, 0, Constants.SCR_W, Constants.SCR_H);
        if (_gameState == 4 || _gameState == 7) {
            GameImpl.DrawSplash(sDKGraphics);
        } else if (_gameState == 6) {
            Level.DrawLevel(sDKGraphics);
            int n2 = 0;
            if (_menuNames[n] != -1) {
                n2 += 2;
            }
            if (_menuItems[n] != null) {
                n2 += _menuItems[n].length;
            }
            sDKGraphics.setColor(Hud._current_hud_colors[9]);
            sDKGraphics.fillRect(-1, Constants.MENU_OFF_Y - 4, Constants.SCR_W + 1, n2 *= SDKUtils.getLineSize());
            sDKGraphics.setColor(Hud._current_hud_colors[10]);
            sDKGraphics.drawRect(-1, Constants.MENU_OFF_Y - 4, Constants.SCR_W + 1, n2);
        }
    }

    static void DrawMenu(SDKGraphics sDKGraphics) {
        int n;
        short[] sArray;
        boolean bl = _gameState == 6;
        int n2 = _menuStack[_menuSP];
        if (n2 == 4 || n2 == 3 || n2 == 15 || n2 == 16) {
            GameImpl.DrawScrollingText(sDKGraphics);
            return;
        }
        if (n2 == 19) {
            GameImpl.DrawMenuBackground(sDKGraphics, 19);
            Hud.MsgBox_Draw(sDKGraphics);
            return;
        }
        if (n2 == 20) {
            _mgInstance.paint(sDKGraphics);
            return;
        }
        if (n2 == 18) {
            GameImpl.DrawMenuBackground(sDKGraphics, n2);
            GameImpl.DrawChooseLanguage(sDKGraphics);
            return;
        }
        if (n2 == 21 || n2 == 22) {
            GameImpl.DrawStatsScreen(sDKGraphics);
            return;
        }
        GameImpl.DrawMenuBackground(sDKGraphics, n2);
        int n3 = Constants.SCR_W >> 1;
        int n4 = Constants.MENU_OFF_Y;
        short s = _menuNames[n2];
        if (s != -1) {
            SDKUtils.setFont(fonts[0]);
            SDKUtils.drawString(SDKUtils.getString(s, _string), n3, n4, 17);
            n4 += 20;
        }
        if ((sArray = _menuItems[n2]) != null) {
            n = _menuSelectionStack[_menuSP];
            for (int i = 0; i < sArray.length; ++i) {
                short s2 = sArray[i];
                if (s2 == -1 || s2 == 156 && !_mgInstance.isAvailable() || bl && (s2 == 155 || s2 == 189) || s2 == 158 && _nextMission < 0 || n2 == 1 && s2 == 181 && _maxAlliedMission < 4 || n2 == 5 && i > _maxSovietMission || n2 == 6 && i > _maxAlliedMission - 4 || n2 == 8 && i > _maxSkirmishMission - 8 || n2 == 17 && i != Level._crt_level && i != (Level._crt_level % 2 == 1 ? 7 + Level._crt_level / 2 : -1)) continue;
                SDKUtils.setFont(fonts[0 + (i == n ? 1 : 0)]);
                if (n2 == 17) {
                    SDKUtils.setFont(fonts[0]);
                }
                _string = SDKUtils.getString(s2, _string);
                SDKUtils.drawString(_string, n3, n4, 17);
                n4 += 12;
            }
        }
        if ((n = _menuSoftKeys[n2 << 1]) > 0) {
            Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(n, _string), true, true, false);
        }
        if ((n = _menuSoftKeys[(n2 << 1) + 1]) > 0) {
            Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(n, _string), false, true, false);
        }
    }

    static void MenuAction(int n) {
        if (n < 0) {
            return;
        }
        int n2 = _menuStack[_menuSP];
        int n3 = _menuSelectionStack[_menuSP];
        switch (n) {
            case 154: {
                GameImpl.ShowMenu(1);
                break;
            }
            case 157: {
                GameImpl.ShowMenu(7);
                break;
            }
            case 158: {
                if (_nextMission < 0 || _nextMission >= 8) break;
                Level._b_skirmish = false;
                Level._crt_level = _nextMission;
                GameImpl.SetState(11);
                break;
            }
            case 159: {
                GameImpl.ShowMenu(2);
                GameImpl._menuItems[2][0] = (short)(_soundEnable ? 187 : 188);
                GameImpl._menuItems[2][1] = (short)(_vibrationsEnable ? 185 : 186);
                break;
            }
            case 160: {
                GameImpl.ShowMenu(3);
                break;
            }
            case 161: {
                GameImpl.ShowMenu(4);
                break;
            }
            case 4: {
                if (n2 == 9) {
                    GameImpl.SetState(5);
                    break;
                }
                GameImpl.PopMenu();
                break;
            }
            case 187: 
            case 188: {
                _soundEnable = !_soundEnable;
                GameImpl._menuItems[2][0] = (short)(_soundEnable ? 187 : 188);
                _soundManager.setSoundEnabled(_soundEnable);
                if (_soundEnable) {
                    boolean bl;
                    boolean bl2 = bl = _gameState == 6;
                    if (bl) {
                        GameImpl.PlaySound(5, -1);
                    } else {
                        GameImpl.PlaySound(4, -1);
                    }
                } else {
                    _soundManager.stopSounds();
                }
                GameImpl.saveRMS();
                break;
            }
            case 185: 
            case 186: {
                _vibrationsEnable = !_vibrationsEnable;
                GameImpl._menuItems[2][1] = (short)(_vibrationsEnable ? 185 : 186);
                GameImpl.Vibrate(500);
                GameImpl.saveRMS();
                break;
            }
            case 180: {
                if (n2 == 1) {
                    GameImpl.ShowMenu(5);
                    break;
                }
                if (n2 != 7) break;
                Level._player_sk_faction = 0;
                Level._ai_sk_faction = 1;
                GameImpl.ShowMenu(8);
                break;
            }
            case 181: {
                if (n2 == 1) {
                    GameImpl.ShowMenu(6);
                    break;
                }
                if (n2 != 7) break;
                Level._player_sk_faction = 1;
                Level._ai_sk_faction = 0;
                GameImpl.ShowMenu(8);
                break;
            }
            case 182: {
                if (n2 != 7) break;
                Level._player_sk_faction = 2;
                GameImpl.ShowMenu(8);
                break;
            }
            case 156: {
                GameImpl.SetState(12);
                break;
            }
            case 189: {
                GameImpl.ShowMenu(11);
                break;
            }
            case 155: {
                GameImpl.ShowMenu(18);
                break;
            }
            case 165: {
                GameImpl.ShowMenu(12);
                break;
            }
            case 11: {
                if (n2 == 11) {
                    GameImpl.ResetAllSavedData();
                    GameImpl.PopMenu();
                    break;
                }
                if (n2 == 13) {
                    GameImpl.saveRMS();
                    SDKMIDlet.exit();
                    break;
                }
                if (n2 == 12) {
                    GameImpl.SetState(9);
                    break;
                }
                if (n2 != 14) break;
                GameImpl.SetState(8);
                break;
            }
            case 12: {
                GameImpl.PopMenu();
                break;
            }
            case 163: {
                GameImpl.SetState(5);
                break;
            }
            case 164: {
                GameImpl.ShowMenu(14);
                break;
            }
            case 3: {
                if (n2 == 17) {
                    GameImpl.ResetMenuStack();
                    GameImpl.ShowMenu(0);
                    break;
                }
                GameImpl.ShowMenu(13);
                break;
            }
            default: {
                if (n2 == 5 || n2 == 6) {
                    Level._b_skirmish = false;
                    Level._crt_level = (n2 == 5 ? 0 : 4) + n3;
                    GameImpl.SetState(11);
                    break;
                }
                if (n2 != 8) break;
                Level._crt_level = 8 + n3;
                Level._b_skirmish = true;
                GameImpl.SetState(8);
            }
        }
    }

    public static void ResetMenuStack() {
        _menuSP = -1;
    }

    public static void ShowMenu(int n) {
        GameImpl._menuStack[++GameImpl._menuSP] = n;
        GameImpl._menuSelectionStack[GameImpl._menuSP] = 0;
        if (n == 3 || n == 15 || n == 16) {
            _scrolltxt_string = SDKUtils.getString(_menuItems[n][0], _scrolltxt_string);
            GameImpl.ShowScrollingText(_scrolltxt_string);
        } else if (n == 4) {
            String string = null;
            try {
                string = SDKMIDlet.getAppProp("MIDlet-Version").trim();
            }
            catch (Exception exception) {
                string = "";
            }
            _scrolltxt_string = SDKUtils.getString(_menuItems[4][0], _scrolltxt_string);
            _scrolltxt_string = _scrolltxt_string.replaceFirst(string);
            GameImpl.ShowScrollingText(_scrolltxt_string);
        }
    }

    public static void PopMenu() {
        if (_menuSP > 0) {
            --_menuSP;
        }
    }

    public static void UpdateLoadingMainMenu() {
        switch (_loadingStatus) {
            case 0: {
                Level.ClearLevel();
                System.gc();
                for (int i = 0; i < 24; ++i) {
                    if (_sprites[i] == null) continue;
                    GameImpl._sprites[i]._flags &= 0xFFFFFF7F;
                }
                GameImpl.ReleaseUnusedSprites();
                System.gc();
                GameImpl.MarkInitSprites();
                break;
            }
            case 1: {
                GameImpl.LoadSplash();
                break;
            }
            case 2: {
                GameImpl.SetState(_nextMenuState);
            }
        }
        ++_loadingStatus;
    }

    public static void DrawLoadingMainMenu(SDKGraphics sDKGraphics) {
        GameImpl.DrawLoading(sDKGraphics);
    }

    public static void UpdateChooseLanguage() {
        if (SDKCanvas.isNewKeyPressed(4144)) {
            SDKUtils.setCurrentLanguage(_current_menu_language);
            _language = _current_menu_language;
            GameImpl.saveRMS();
            if (_gameState == 10) {
                GameImpl.SetState(2);
            } else {
                GameImpl.PopMenu();
            }
        } else if (SDKCanvas.isNewKeyPressed(64) || SDKCanvas.isNewKeyPressed(524288)) {
            if (_gameState != 10) {
                GameImpl.PopMenu();
            }
        } else if (SDKCanvas.isNewKeyPressed(513)) {
            if (--_current_menu_language < 0) {
                _current_menu_language = _numLangsLoaded - 1;
            }
        } else if (SDKCanvas.isNewKeyPressed(32770)) {
            _current_menu_language = (_current_menu_language + 1) % _numLangsLoaded;
        }
    }

    public static void DrawChooseLanguage(SDKGraphics sDKGraphics) {
        int n;
        SDKUtils.setFont(fonts[0]);
        int n2 = SDKUtils.getLineSize();
        int n3 = (Constants.SCR_H >> 1) - (n2 * _numLangsLoaded >> 1) + 20;
        for (n = 0; n < _numLangsLoaded; n += 1) {
            SDKUtils.getHeaderString(n, 0, _string);
            if (n == _current_menu_language) {
                SDKUtils.setFont(fonts[1]);
                SDKUtils.drawString(_string, Constants.SCR_W >> 1, n3, 17);
                SDKUtils.setFont(fonts[0]);
            } else {
                SDKUtils.drawString(_string, Constants.SCR_W >> 1, n3, 1);
            }
            n3 += n2;
        }
        int n4 = n = _gameState != 10 ? 1 : 0;
        if (_gameState != 10) {
            Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(6, _string), true, n != 0, false);
            Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(4, _string), false, n != 0, false);
        } else {
            Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getHeaderString(_current_menu_language, 1, _string), true, n != 0, false);
        }
    }

    public static void ShowScrollingText(SDKString sDKString) {
        _scrolltxt_string = sDKString;
        SDKUtils.setFont(fonts[0]);
        SDKUtils.wrapString(_scrolltxt_string, _scrolltxt_wraplines, Constants.SCR_W - 10, (short)124);
        _scrolltxt_visible_lines = (short)((Constants.SCR_H - 15 - 15) / SDKUtils.getLineSize());
        _scrolltxt_nolines = _scrolltxt_wraplines[0];
        _scrolltxt_pos = 0;
    }

    public static void UpdateScrollingText() {
        int n = _menuStack[_menuSP];
        SDKUtils.setFont(fonts[0]);
        if (SDKCanvas.isKeyPressed(513)) {
            if ((_scrolltxt_pos = (short)(_scrolltxt_pos - 1)) < 0) {
                _scrolltxt_pos = 0;
            }
        } else if (SDKCanvas.isKeyPressed(32770)) {
            if ((_scrolltxt_pos = (short)(_scrolltxt_pos + 1)) + _scrolltxt_visible_lines > _scrolltxt_nolines) {
                _scrolltxt_pos = (short)(_scrolltxt_pos - 1);
            }
        } else if (SDKCanvas.isKeyPressed(64) || SDKCanvas.isKeyPressed(524288)) {
            GameImpl.PopMenu();
        } else if (SDKCanvas.isKeyPressed(32)) {
            SDKCanvas.disableInput(0);
            if (n == 15) {
                if (_oldAlliedMission != _maxAlliedMission || _oldSkirmishMission != _maxSkirmishMission || _oldSovietMission != _maxSovietMission) {
                    GameImpl.ShowMenu(17);
                } else if (_nextMission >= 0 && _nextMission != Level._crt_level) {
                    Level._b_skirmish = false;
                    Level._crt_level = _nextMission;
                    GameImpl.SetState(11);
                }
            }
            if (n == 16) {
                GameImpl.ResetMenuStack();
                GameImpl.ShowMenu(0);
            }
        }
    }

    public static void DrawScrollingText(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(0);
        sDKGraphics.fillRect(0, 0, Constants.SCR_W, Constants.SCR_H);
        int n = _menuStack[_menuSP];
        SDKUtils.setFont(fonts[0]);
        int n2 = SDKUtils.getLineSize();
        int n3 = Math.min(_scrolltxt_visible_lines, _scrolltxt_nolines - _scrolltxt_pos);
        SDKUtils.drawWrappedString(_scrolltxt_string, _scrolltxt_wraplines, 1 + _scrolltxt_pos, n3, 0, 15, 20);
        sDKGraphics.setColor(0);
        sDKGraphics.fillRect(0, 0, Constants.SCR_W, 15);
        short s = _menuNames[n];
        if (s != -1) {
            SDKUtils.setFont(fonts[1]);
            SDKUtils.drawString(SDKUtils.getString(s, _string), Constants.SCR_W >> 1, 2, 17);
        }
        sDKGraphics.setColor(Hud._current_hud_colors[10]);
        sDKGraphics.drawLine(0, 15, Constants.SCR_W, 15);
        XSprite xSprite = _sprites[23];
        if ((xSprite._flags & 0x100) != 0) {
            if (_scrolltxt_pos > 0) {
                xSprite.DrawFrame(1, Constants.SCR_W - 10, 20, 0);
            }
            if (_scrolltxt_pos + _scrolltxt_visible_lines < _scrolltxt_nolines) {
                xSprite.DrawFrame(2, Constants.SCR_W - 10, Constants.SCR_H - 15 - 5, 0);
            }
        } else {
            xSprite = _sprites[4];
            if (_scrolltxt_pos > 0) {
                xSprite.DrawFrame(7, Constants.SCR_W - 7, 29, 4);
            }
            if (_scrolltxt_pos + _scrolltxt_visible_lines < _scrolltxt_nolines) {
                xSprite.DrawFrame(8, Constants.SCR_W - 7, Constants.SCR_H - 15 - 13, 4);
            }
        }
        sDKGraphics.setColor(0);
        sDKGraphics.fillRect(0, Constants.SCR_H - 15, Constants.SCR_W, 15);
        short s2 = _menuSoftKeys[n << 1];
        if (s2 > 0) {
            Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(s2, _string), true, true, false);
        }
        if ((s2 = _menuSoftKeys[(n << 1) + 1]) > 0) {
            Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(s2, _string), false, true, false);
        }
        sDKGraphics.setColor(Hud._current_hud_colors[10]);
        sDKGraphics.drawLine(0, Constants.SCR_H - 15, Constants.SCR_W, Constants.SCR_H - 15);
    }

    private static void ResetAllSavedData() {
        _maxSovietMission = 0;
        _maxAlliedMission = -1;
        _maxSkirmishMission = 8;
        _nextMission = -1;
        GameImpl.saveRMS();
    }

    public static void UpdateStatsScreen() {
        int n = _menuStack[_menuSP];
        if (SDKCanvas.isNewKeyPressed(32)) {
            SDKCanvas.disableInput(0);
            if (n == 22) {
                GameImpl.SetState(8);
            } else if (!Level._b_skirmish) {
                Hud._current_hud_colors = Level._hud_colors[0];
                GameImpl.ResetMenuStack();
                GameImpl.ShowMenu(0);
                if (Level._crt_level == 3) {
                    GameImpl.ShowMenu(15);
                    return;
                }
                if (Level._crt_level == 7) {
                    GameImpl.ShowMenu(16);
                    return;
                }
                if (_oldAlliedMission != _maxAlliedMission || _oldSkirmishMission != _maxSkirmishMission || _oldSovietMission != _maxSovietMission) {
                    GameImpl.ShowMenu(17);
                } else if (_nextMission >= 0 && _nextMission != Level._crt_level) {
                    Level._b_skirmish = false;
                    Level._crt_level = _nextMission;
                    GameImpl.SetState(11);
                }
            }
        } else if (SDKCanvas.isNewKeyPressed(64) || SDKCanvas.isNewKeyPressed(524288)) {
            SDKCanvas.disableInput(0);
            GameImpl.ResetMenuStack();
            GameImpl.ShowMenu(0);
        }
    }

    public static void DrawStatsScreen(SDKGraphics sDKGraphics) {
        int n;
        sDKGraphics.setColor(Hud._current_hud_colors[9]);
        sDKGraphics.fillRect(0, 0, Constants.STATISTICS_MENU_WIDTH, Constants.STATISTICS_MENU_HEIGHT);
        int n2 = 5;
        int n3 = 10;
        SDKUtils.setFont(fonts[0]);
        SDKUtils.setLeadingSpacing(-1);
        int n4 = SDKUtils.getLineSize();
        int n5 = _menuItems[10].length;
        for (int i = 0; i < n5; ++i) {
            n = 0;
            int n6 = 0;
            if (Level._player_faction == 1) {
                n = i << 1;
                n6 = (i << 1) + 1;
            } else {
                n = (i << 1) + 1;
                n6 = i << 1;
            }
            _string = SDKUtils.getString(_menuItems[10][i], _string);
            SDKUtils.drawString(_string, n2, n3, 0);
            n3 += n4;
            int n7 = 0;
            n7 = Level._statistics[n] > Level._statistics[n6] ? Level._statistics[n] : Level._statistics[n6];
            if (n7 == 0) {
                n7 = 1;
            }
            _string = SDKUtils.getString(196, _string);
            SDKUtils.drawString(_string, 30, n3, 0);
            sDKGraphics.setColor(0x404040);
            sDKGraphics.fillRect(100, n3 + 4, 55, 8);
            sDKGraphics.setColor(255);
            sDKGraphics.fillRect(100, n3 + 4, Level._statistics[n] * 55 / n7, 8);
            GameImpl.DrawNumber(Level._statistics[n], Constants.STATISTICS_NUMBERS_X, n3, 0);
            _string = SDKUtils.getString(197, _string);
            SDKUtils.drawString(_string, 30, n3 += n4, 0);
            sDKGraphics.setColor(0x404040);
            sDKGraphics.fillRect(100, n3 + 4, 55, 8);
            sDKGraphics.setColor(0xFF0000);
            sDKGraphics.fillRect(100, n3 + 4, Level._statistics[n6] * 55 / n7, 8);
            GameImpl.DrawNumber(Level._statistics[n6], Constants.STATISTICS_NUMBERS_X, n3, 0);
            n3 += n4 + 2;
        }
        SDKUtils.setLeadingSpacing(0);
        n = _menuStack[_menuSP];
        if (n == 21) {
            if (_nextMission >= 0 && !Level._b_skirmish) {
                Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(158, _string), true, true, false);
            }
        } else {
            Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(164, _string), true, true, false);
        }
        Hud.DrawSoftKeys(sDKGraphics, SDKUtils.getString(3, _string), false, true, false);
    }

    public static void UpdateLoadingBriefing() {
        int n = Script._last_script_file - Script._first_script_file;
        int n2 = _loadingStatus;
        if (n2 == 0) {
            int n3 = Level.GetLevelStats(Level._crt_level, 16);
            if (n3 != -1) {
                SDKUtils.loadStringsChunk(n3);
            }
        } else if (n2 >= 1 && n2 <= n + 1) {
            Script.LoadScripts(n2 - 1);
        } else {
            SDKInputStream.purgeCache();
            System.gc();
            GameImpl.saveRMS();
            Hud.Start(Level.GetLevelStats(Level._crt_level, 10));
            GameImpl.SetState(4);
            GameImpl.ShowMenu(19);
        }
        ++_loadingStatus;
    }

    public static void UpdateLoadingMG() {
        if (_loadingStatus == 0) {
            SDKUtils.loadStringsChunk(12);
            _mgImages = new SDKImage[4];
        }
        GameImpl._mgImages[GameImpl._loadingStatus] = SDKInputStream.loadImageObject(9 + _loadingStatus);
        if (++_loadingStatus == 4) {
            GameImpl.SetState(4);
            GameImpl.ShowMenu(20);
            _mgInstance.reset();
        }
    }

    static void __MENU() {
    }

    static void SPRITES__() {
    }

    public static String Debug_GetSpriteName(XSprite xSprite) {
        return "UNKNOWN_SPRITE";
    }

    public static void InitSprites() {
        for (int i = 0; i < 24; ++i) {
            if (_spritePalCount[i] == 0) continue;
            GameImpl._sprites[i] = new XSprite(_spriteFlags[i]);
        }
    }

    public static void MarkSprites() {
        int n;
        for (n = 0; n < 24; ++n) {
            XSprite xSprite = _sprites[n];
            if (xSprite == null) continue;
            xSprite._flags &= 0xFFFFFF70;
        }
        if (Level._currentTileSet >= 0) {
            GameImpl._sprites[Level._currentTileSet]._flags |= 0x81;
        }
        if (Level._entities != null) {
            for (n = 0; n < 112; ++n) {
                if (Level._entities_usage[n] != 1) continue;
                Level._entities[n].MarkUsedSprite();
            }
        }
        for (n = 0; n < Level._fixedDataPointer; n += 5) {
            byte by = Level._fixed_ent_data[n + 0];
            if ((by & 0x80) != 0) continue;
            byte by2 = Level._fixed_ent_data[n + 3];
            GameImpl._sprites[by2]._flags |= 0x81;
        }
        GameImpl.MarkDefaultSprites();
        GameImpl.ReleaseUnusedSprites();
        System.gc();
    }

    public static void ReleaseUnusedSprites() {
        for (int i = 0; i < 24; ++i) {
            XSprite xSprite = _sprites[i];
            if (xSprite == null) continue;
            if ((xSprite._flags & 0x80) == 0) {
                if ((xSprite._flags & 0x100) == 0) continue;
                xSprite.Release();
                continue;
            }
            if ((xSprite._flags & 0x100) == 0) continue;
        }
    }

    public static void MarkDefaultSprites() {
        int n;
        GameImpl._sprites[4]._flags |= 0x80 | 1 << Level._player_faction;
        if (Level._player_faction == 0) {
            GameImpl._sprites[13]._flags |= 0x81;
        } else {
            GameImpl._sprites[14]._flags |= 0x81;
        }
        GameImpl._sprites[6]._flags |= 0x81;
        GameImpl._sprites[5]._flags |= 0x81;
        int n2 = 1;
        if (Level._player_faction == Level._ai_faction) {
            n2 = 3;
        }
        if (Level._player_faction == 0 || Level._ai_faction == 0) {
            for (n = 0; n < 24; ++n) {
                if (_sprites[n] == null || (GameImpl._sprites[n]._flags & 0x400) == 0) continue;
                GameImpl._sprites[n]._flags |= 0x80 | n2;
            }
            GameImpl._sprites[8]._flags |= 3;
        }
        if (Level._player_faction == 1 || Level._ai_faction == 1) {
            for (n = 0; n < 24; ++n) {
                if (_sprites[n] == null || (GameImpl._sprites[n]._flags & 0x800) == 0) continue;
                GameImpl._sprites[n]._flags |= 0x80 | n2;
            }
        }
    }

    public static void LoadSprites() {
        int n;
        int n2;
        int n3;
        switch (_loadingStatus) {
            case 1: {
                n3 = 0;
                n2 = 24;
                n = 2;
                break;
            }
            case 2: {
                n3 = 3;
                n2 = 30;
                n = 5;
                break;
            }
            case 3: {
                n3 = 6;
                n2 = 37;
                n = 8;
                break;
            }
            case 4: {
                n3 = 9;
                n2 = 43;
                n = 11;
                break;
            }
            case 5: {
                n3 = 12;
                n2 = 49;
                n = 14;
                break;
            }
            case 6: {
                n3 = 15;
                n2 = 55;
                n = 17;
                break;
            }
            case 7: {
                n3 = 18;
                n2 = 61;
                n = 21;
                break;
            }
            default: {
                return;
            }
        }
        try {
            while (n3 <= n) {
                XSprite xSprite = _sprites[n3];
                if (xSprite == null) {
                    ++n3;
                    continue;
                }
                boolean bl = (xSprite._flags & 0x80) != 0 && (xSprite._flags & 0x100) == 0;
                int n4 = _spritePalCount[n3];
                if (n4 == 0) {
                    ++n3;
                    continue;
                }
                if (!bl) {
                    ++n2;
                    n2 += n4;
                    ++n3;
                    continue;
                }
                SDKInputStream sDKInputStream = new SDKInputStream(n2++);
                xSprite.LoadData(sDKInputStream);
                sDKInputStream.close();
                sDKInputStream = null;
                System.gc();
                int n5 = 0;
                for (int i = 0; i < 4 && i < n4; ++i) {
                    if ((xSprite._flags & 1 << i) == 0) continue;
                    ++n5;
                }
                int[] nArray = new int[n5];
                int n6 = 0;
                if ((xSprite._flags & 1) != 0) {
                    nArray[n6++] = -1;
                }
                for (int i = 1; i < 4 && i < n4; ++i) {
                    if ((xSprite._flags & 1 << i) == 0) continue;
                    nArray[n6++] = n2 + i;
                }
                xSprite._images = SDKInputStream.loadImageObjectWithPalette(n2, nArray);
                n2 += n4;
                ++n3;
            }
            SDKInputStream.purgeCache();
            System.gc();
        }
        catch (Exception exception) {
            Debug.CatchException("LoadSprites", exception);
        }
    }

    public static void LoadSplash() {
        try {
            int[] nArray = new int[]{-1};
            SDKInputStream sDKInputStream = new SDKInputStream(69);
            _sprites[23].LoadData(sDKInputStream);
            sDKInputStream.close();
            sDKInputStream = null;
            System.gc();
            GameImpl._sprites[23]._images = SDKInputStream.loadImageObjectWithPalette(70, nArray);
            SDKInputStream.purgeCache();
            System.gc();
        }
        catch (Exception exception) {
            Debug.CatchException("LoadInitSprites", exception);
        }
    }

    public static void LoadLegal() {
        _legalImage = SDKInputStream.loadImageObject(8);
    }

    public static void MarkInitSprites() {
        GameImpl._sprites[23]._flags |= 0x81;
    }

    static void __SPRITES() {
    }

    static void TUTORIAL__() {
    }

    static void Tutorials_Init() {
        _tutorials = new int[4][];
        for (int i = 0; i < 4; ++i) {
            GameImpl._tutorials[i] = new int[11];
            GameImpl._tutorials[i][0] = 0;
            GameImpl._tutorials[i][2] = 0;
        }
    }

    static void Tutorials_Release() {
        if (_tutorials != null) {
            for (int i = 0; i < 4; ++i) {
                GameImpl._tutorials[i] = null;
            }
            _tutorials = null;
        }
        System.gc();
    }

    static void Tutorials_Clean() {
        for (int i = 0; i < 4; ++i) {
            GameImpl._tutorials[i][0] = 0;
            GameImpl._tutorials[i][2] = 0;
        }
    }

    static void Tutorials_Update() {
        block10: for (int i = 0; i < 4; ++i) {
            if (_tutorials[i][0] != 1) continue;
            int n = _tutorials[i][1];
            switch (n) {
                case 0: {
                    GameImpl.UpdateCursorMovementTutorial(i);
                    continue block10;
                }
                case 1: {
                    GameImpl.UpdateUnitsMovementTutorial(i);
                    continue block10;
                }
                case 2: {
                    GameImpl.UpdateAttackTutorial(i);
                    continue block10;
                }
                case 3: {
                    GameImpl.UpdateBuildTutorial(i);
                    continue block10;
                }
                case 4: {
                    GameImpl.UpdateGroupTutorial(i);
                    continue block10;
                }
                case 5: {
                    GameImpl.UpdateTrainTutorial(i);
                    continue block10;
                }
                case 6: {
                    GameImpl.UpdateSelectTutorial(i);
                    continue block10;
                }
                case 7: {
                    GameImpl.UpdateSWTutorial(i);
                }
            }
        }
    }

    static void Tutorials_Draw(SDKGraphics sDKGraphics) {
        sDKGraphics.setClip(0, 38, Constants.SV_W, Constants.SV_H);
        block10: for (int i = 0; i < 4; ++i) {
            if (_tutorials[i][0] != 1) continue;
            int n = _tutorials[i][1];
            switch (n) {
                case 0: {
                    GameImpl.DrawCursorMovementTutorial(i, sDKGraphics);
                    continue block10;
                }
                case 1: {
                    GameImpl.DrawUnitsMovementTutorial(i, sDKGraphics);
                    continue block10;
                }
                case 2: {
                    GameImpl.DrawAttackTutorial(i, sDKGraphics);
                    continue block10;
                }
                case 3: {
                    GameImpl.DrawBuildTutorial(i, sDKGraphics);
                    continue block10;
                }
                case 4: {
                    GameImpl.DrawGroupTutorial(i, sDKGraphics);
                    continue block10;
                }
                case 5: {
                    GameImpl.DrawTrainTutorial(i, sDKGraphics);
                    continue block10;
                }
                case 6: {
                    GameImpl.DrawSelectTutorial(i, sDKGraphics);
                    continue block10;
                }
                case 7: {
                    GameImpl.DrawSWTutorial(i, sDKGraphics);
                }
            }
        }
        sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
    }

    static void EndTutorial(int n) {
        block3: for (int i = 0; i < 4; ++i) {
            if (_tutorials[i][2] != n) continue;
            GameImpl._tutorials[i][0] = 0;
            GameImpl._tutorials[i][2] = 0;
            int n2 = _tutorials[i][1];
            switch (n2) {
                case 1: 
                case 2: {
                    if (_tutorials[i][7] == -1) continue block3;
                    Entity entity = Level.GetEntitySafe(_tutorials[i][7]);
                    Level.DeleteEntity(entity);
                }
            }
        }
    }

    static int FindTutorialSlot() {
        for (int i = 0; i < 4; ++i) {
            if (_tutorials[i][0] != 0) continue;
            return i;
        }
        return -1;
    }

    static void StartCursorMovementTutorial(int n, int n2) {
        int n3 = GameImpl.FindTutorialSlot();
        if (n3 >= 0) {
            GameImpl._tutorials[n3][0] = 1;
            GameImpl._tutorials[n3][2] = n;
            GameImpl._tutorials[n3][1] = 0;
            GameImpl._tutorials[n3][5] = 0;
            GameImpl._tutorials[n3][6] = n2;
        }
    }

    static void UpdateCursorMovementTutorial(int n) {
        int[] nArray = _tutorials[n];
        nArray[5] = nArray[5] + 1;
        if (_tutorials[n][5] > _tutorials[n][6]) {
            GameImpl._tutorials[n][0] = 0;
            GameImpl._tutorials[n][2] = 0;
        }
    }

    static void DrawCursorMovementTutorial(int n, SDKGraphics sDKGraphics) {
        if (Hud._hud_state != 1) {
            return;
        }
        int n2 = 0 + Camera._nCursorPosX - Camera._nCamX;
        int n3 = 38 + Camera._nCursorPosY - Camera._nCamY;
        if (SDKCanvas.isNewKeyPressed(513) || SDKCanvas.isKeyPressed(513) || SDKCanvas.isNewKeyReleased(513)) {
            sDKGraphics.setColor(-3997696);
        } else {
            sDKGraphics.setColor(-533725184);
        }
        sDKGraphics.fillRect(n2 - 7, n3 + -24 - 7, 15, 15);
        sDKGraphics.setColor(-3997696);
        sDKGraphics.drawRect(n2 - 7, n3 + -24 - 7, 15, 15);
        GameImpl.DrawNumber(2, n2, n3 + -24 - 6, 3);
        if (SDKCanvas.isKeyPressed(32770) || SDKCanvas.isKeyPressed(32770) || SDKCanvas.isNewKeyReleased(32770)) {
            sDKGraphics.setColor(-3997696);
        } else {
            sDKGraphics.setColor(-533725184);
        }
        sDKGraphics.fillRect(n2 - 7, n3 + 24 - 7, 15, 15);
        sDKGraphics.setColor(-3997696);
        sDKGraphics.drawRect(n2 - 7, n3 + 24 - 7, 15, 15);
        GameImpl.DrawNumber(8, n2, n3 + 24 - 6, 3);
        if (SDKCanvas.isKeyPressed(2052) || SDKCanvas.isKeyPressed(2052) || SDKCanvas.isNewKeyReleased(2052)) {
            sDKGraphics.setColor(-3997696);
        } else {
            sDKGraphics.setColor(-533725184);
        }
        sDKGraphics.fillRect(n2 + -24 - 7, n3 - 7, 15, 15);
        sDKGraphics.setColor(-3997696);
        sDKGraphics.drawRect(n2 + -24 - 7, n3 - 7, 15, 15);
        GameImpl.DrawNumber(4, n2 + -24, n3 - 6, 3);
        if (SDKCanvas.isKeyPressed(8200) || SDKCanvas.isKeyPressed(8200) || SDKCanvas.isNewKeyReleased(8200)) {
            sDKGraphics.setColor(-3997696);
        } else {
            sDKGraphics.setColor(-533725184);
        }
        sDKGraphics.fillRect(n2 + 24 - 7, n3 - 7, 15, 15);
        sDKGraphics.setColor(-3997696);
        sDKGraphics.drawRect(n2 + 24 - 7, n3 - 7, 15, 15);
        GameImpl.DrawNumber(6, n2 + 24, n3 - 6, 3);
    }

    static void StartUnitsMovementTutorial(int n, int n2, int n3, int n4) {
        int n5 = GameImpl.FindTutorialSlot();
        if (n5 >= 0) {
            GameImpl._tutorials[n5][0] = 1;
            GameImpl._tutorials[n5][2] = n;
            GameImpl._tutorials[n5][1] = 1;
            GameImpl._tutorials[n5][5] = 0;
            GameImpl._tutorials[n5][3] = n2;
            GameImpl._tutorials[n5][4] = n3;
            GameImpl._tutorials[n5][9] = n4;
            Entity entity = Level.SpawnEntity(2);
            if (entity != null) {
                entity.Decorator_Init(n2, n3, 6, 1, 0, 2);
                GameImpl._tutorials[n5][7] = entity.GetPointer();
            } else {
                GameImpl._tutorials[n5][7] = -1;
            }
        }
    }

    static void UpdateUnitsMovementTutorial(int n) {
        int[] nArray = _tutorials[n];
        nArray[5] = nArray[5] + 1;
        if (_tutorials[n][5] >= 4) {
            GameImpl._tutorials[n][5] = 0;
        }
        if (_tutorials[n][9] >= 0) {
            Hud.AddMessage(_tutorials[n][9], -1, 6, 32, 8, 0);
            GameImpl._tutorials[n][9] = -1;
        }
        for (int i = 0; i < 24; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (unit._allegiance != 0) continue;
            int n2 = _tutorials[n][3] - unit._pos_x;
            int n3 = _tutorials[n][4] - unit._pos_y;
            if (Math.abs(n2) + Math.abs(n3) >= 32) continue;
            GameImpl._tutorials[n][0] = 0;
            GameImpl._tutorials[n][2] = 0;
            if (_tutorials[n][7] == -1) break;
            Entity entity = Level.GetEntitySafe(_tutorials[n][7]);
            Level.DeleteEntity(entity);
            break;
        }
    }

    static void DrawUnitsMovementTutorial(int n, SDKGraphics sDKGraphics) {
        if (Hud._hud_state != 1) {
            return;
        }
        int n2 = 0 + _tutorials[n][3] - Camera._nCamX;
        int n3 = 38 + _tutorials[n][4] - Camera._nCamY;
        int n4 = _tutorials[n][3] - Camera._nCursorPosX;
        int n5 = _tutorials[n][4] - Camera._nCursorPosY;
        if (Math.abs(n4) + Math.abs(n5) < 16) {
            n2 = 0 + Camera._nCursorPosX - Camera._nCamX;
            n3 = 38 + Camera._nCursorPosY - Camera._nCamY;
            if (_tutorials[n][5] > 2) {
                sDKGraphics.setColor(-3997696);
            } else {
                sDKGraphics.setColor(-533725184);
            }
            sDKGraphics.fillRect(n2 - 7, n3 + 24 - 7, 15, 15);
            sDKGraphics.setColor(-3997696);
            sDKGraphics.drawRect(n2 - 7, n3 + 24 - 7, 15, 15);
            GameImpl.DrawNumber(5, n2, n3 + 24 - 6, 3);
        }
    }

    static void StartAttackTutorial(int n, int n2, int n3, int n4, int n5) {
        int n6 = GameImpl.FindTutorialSlot();
        if (n6 >= 0) {
            Entity entity;
            GameImpl._tutorials[n6][0] = 1;
            GameImpl._tutorials[n6][2] = n;
            GameImpl._tutorials[n6][1] = 2;
            GameImpl._tutorials[n6][10] = n5;
            GameImpl._tutorials[n6][3] = n2;
            GameImpl._tutorials[n6][4] = n3;
            if (n5 > 0) {
                entity = Level.GetEntityById(-1, n5);
                if (entity != null) {
                    GameImpl._tutorials[n6][3] = entity._pos_x;
                    GameImpl._tutorials[n6][4] = entity._pos_y;
                    GameImpl._tutorials[n6][10] = entity.GetPointer();
                } else {
                    GameImpl._tutorials[n6][0] = 0;
                    GameImpl._tutorials[n6][2] = 0;
                    return;
                }
            }
            GameImpl._tutorials[n6][9] = n4;
            GameImpl._tutorials[n6][5] = 0;
            entity = Level.SpawnEntity(2);
            if (entity != null) {
                entity.Decorator_Init(n2, n3 - 20, 1, 2, 0, 4);
                GameImpl._tutorials[n6][7] = entity.GetPointer();
            } else {
                GameImpl._tutorials[n6][7] = -1;
            }
        }
    }

    static void UpdateAttackTutorial(int n) {
        Entity entity;
        if (_tutorials[n][9] >= 0) {
            Hud.AddMessage(_tutorials[n][9], -1, 6, 32, 8, 0);
            GameImpl._tutorials[n][9] = -1;
        }
        int[] nArray = _tutorials[n];
        nArray[5] = nArray[5] + 1;
        if (_tutorials[n][5] >= 4) {
            GameImpl._tutorials[n][5] = 0;
        }
        boolean bl = false;
        if (Camera.GetCursorAction() == 4 && SDKCanvas.isNewKeyReleased(4112) && !Camera._bcursorDoubleTap) {
            bl = true;
        }
        if (_tutorials[n][10] > 0) {
            entity = Level.GetEntitySafe(_tutorials[n][10]);
            if (entity == null) {
                bl = true;
            } else {
                Entity entity2 = Level.GetEntitySafe(_tutorials[n][7]);
                entity2._pos_x = entity._pos_x;
                entity2._pos_y = entity._pos_y - 20;
                switch (entity._type) {
                    case 5: {
                        Unit unit = (Unit)entity;
                        if (unit._life > 0) break;
                        bl = true;
                        break;
                    }
                    case 6: {
                        Building building = (Building)entity;
                        if (building._life >= 0) break;
                        bl = true;
                    }
                }
            }
        }
        if (bl) {
            GameImpl._tutorials[n][0] = 0;
            GameImpl._tutorials[n][2] = 0;
            if (_tutorials[n][7] != -1) {
                entity = Level.GetEntitySafe(_tutorials[n][7]);
                Level.DeleteEntity(entity);
            }
        }
    }

    static void DrawAttackTutorial(int n, SDKGraphics sDKGraphics) {
        if (Hud._hud_state != 1) {
            return;
        }
        int n2 = _tutorials[n][3] - Camera._nCursorPosX;
        int n3 = _tutorials[n][4] - Camera._nCursorPosY;
        if (Camera.GetCursorAction() == 4 && Math.abs(n2) + Math.abs(n3) < 16) {
            int n4 = 0 + Camera._nCursorPosX - Camera._nCamX;
            int n5 = 38 + Camera._nCursorPosY - Camera._nCamY;
            if (_tutorials[n][5] > 2) {
                sDKGraphics.setColor(-3997696);
            } else {
                sDKGraphics.setColor(-533725184);
            }
            sDKGraphics.fillRect(n4 - 7, n5 + 24 - 7, 15, 15);
            sDKGraphics.setColor(-3997696);
            sDKGraphics.drawRect(n4 - 7, n5 + 24 - 7, 15, 15);
            GameImpl.DrawNumber(5, n4, n5 + 24 - 6, 3);
        }
    }

    static void StartGroupTutorial(int n, int n2, int n3) {
        int n4 = GameImpl.FindTutorialSlot();
        if (n4 >= 0) {
            GameImpl._tutorials[n4][0] = 1;
            GameImpl._tutorials[n4][2] = n;
            GameImpl._tutorials[n4][1] = 4;
            GameImpl._tutorials[n4][8] = n2;
            GameImpl._tutorials[n4][9] = n3;
        }
    }

    static void UpdateGroupTutorial(int n) {
        int[] nArray = _tutorials[n];
        nArray[5] = nArray[5] + 1;
        if (_tutorials[n][5] >= 2) {
            GameImpl._tutorials[n][5] = 0;
            boolean bl = Hud._blink_RSK = !Hud._blink_RSK;
        }
        if (_tutorials[n][9] >= 0) {
            Hud.AddMessage(_tutorials[n][9], -1, 6, 32, 8, 0);
            GameImpl._tutorials[n][9] = -1;
        }
        if (Level._currentGroup == _tutorials[n][8]) {
            GameImpl._tutorials[n][0] = 0;
            GameImpl._tutorials[n][2] = 0;
            Hud._blink_RSK = true;
        }
    }

    static void DrawGroupTutorial(int n, SDKGraphics sDKGraphics) {
    }

    static void StartBuildTutorial(int n, int n2, int n3, int n4) {
        int n5 = GameImpl.FindTutorialSlot();
        if (n5 >= 0) {
            GameImpl._tutorials[n5][0] = 1;
            GameImpl._tutorials[n5][2] = n;
            GameImpl._tutorials[n5][1] = 3;
            GameImpl._tutorials[n5][5] = 0;
            GameImpl._tutorials[n5][6] = n2;
            GameImpl._tutorials[n5][9] = n3;
            GameImpl._tutorials[n5][10] = n4;
            int n6 = 0;
            for (int i = 24; i < 48; ++i) {
                if (Level._entities_usage[i] != 1) continue;
                Building building = (Building)Level._entities[i];
                if (building._subtype != n2 || building._allegiance != 0) continue;
                ++n6;
            }
            GameImpl._tutorials[n5][7] = n6;
            Hud._hud_current_tab = 0;
            if (Hud._hud_state == 2 && Hud._hud_substate == 2) {
                Hud.Build_ChangeSubState(0);
            }
        }
    }

    static void UpdateBuildTutorial(int n) {
        int[] nArray = _tutorials[n];
        nArray[5] = nArray[5] + 1;
        if (_tutorials[n][5] >= 4) {
            GameImpl._tutorials[n][5] = 0;
        }
        if (_tutorials[n][9] >= 0) {
            Hud.AddMessage(_tutorials[n][9], -1, 6, 32, 8, 0);
            GameImpl._tutorials[n][9] = -1;
        }
        if (_tutorials[n][10] >= 0 && Hud._hud_state == 2 && Hud._hud_substate == 2 && Hud._hud_building == _tutorials[n][6]) {
            Hud.AddMessage(_tutorials[n][10], -1, 6, 32, 8, 0);
            GameImpl._tutorials[n][10] = -1;
        }
        int n2 = 0;
        for (int i = 24; i < 48; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Building building = (Building)Level._entities[i];
            if (building._subtype != _tutorials[n][6] || building._allegiance != 0) continue;
            ++n2;
        }
        if (n2 > _tutorials[n][7]) {
            GameImpl._tutorials[n][0] = 0;
            GameImpl._tutorials[n][2] = 0;
        }
    }

    static void DrawBuildTutorial(int n, SDKGraphics sDKGraphics) {
        if (Hud._hud_state == 2) {
            if (Hud._hud_substate != 2 && Hud._hud_substate != 5 && Hud._hud_current_tab == 0) {
                int n2;
                byte by = Hud._hud_build_cursor_pos[0];
                int n3 = Hud._hud_build_page_pos[0];
                byte[] byArray = Hud._hud_build_items_available[0];
                int n4 = 97;
                int n5 = _tutorials[n][6];
                int n6 = 0;
                for (n2 = 0; n2 < byArray.length; ++n2) {
                    if (byArray[n2] != n5 && byArray[n2] - 50 != n5) continue;
                    n6 = n2;
                    break;
                }
                n2 = 0;
                if (by != -1 && (byArray[by] == n5 || byArray[by] - 50 == n5)) {
                    n4 = 97 + (by - n3) * 31;
                    n2 = 1;
                    if (_tutorials[n][5] > 0) {
                        sDKGraphics.setColor(0xFFFF00);
                        sDKGraphics.drawRect(Constants.HUD_BUILD_POSX + -22, n4 + -16, 32, 32);
                    }
                } else {
                    for (int i = n3; i < n3 + 3; ++i) {
                        if ((byArray[i] == n5 || byArray[i] - 50 == n5) && n2 == 0) {
                            n2 = 1;
                            if (_tutorials[n][5] > 0) {
                                sDKGraphics.setColor(0xFFFF00);
                                sDKGraphics.drawRect(Constants.HUD_BUILD_POSX + -11, n4 + -16, 32, 32);
                            }
                        }
                        n4 += 31;
                    }
                }
                if (n2 == 0 && n6 < n3 && _tutorials[n][5] > 0) {
                    sDKGraphics.setColor(0xFFFF00);
                    sDKGraphics.drawRect(Constants.HUD_BUILD_POSX + -13, 70, 26, 7);
                }
                if (n2 == 0 && n6 >= n3 + 3 && _tutorials[n][5] > 0) {
                    sDKGraphics.setColor(0xFFFF00);
                    sDKGraphics.drawRect(Constants.HUD_BUILD_POSX + -13, 179, 26, 7);
                }
            }
        } else if (Hud._hud_state == 1) {
            XSprite xSprite = _sprites[4];
            if (_tutorials[n][5] > 2) {
                xSprite.DrawFrame(19, Constants.SCR_W >> 1, Constants.SCR_H, 0);
            } else {
                xSprite.DrawFrame(20, Constants.SCR_W >> 1, Constants.SCR_H, 0);
            }
        }
    }

    static void StartTrainTutorial(int n, int n2, int n3, int n4, int n5) {
        int n6 = GameImpl.FindTutorialSlot();
        if (n6 >= 0) {
            GameImpl._tutorials[n6][0] = 1;
            GameImpl._tutorials[n6][2] = n;
            GameImpl._tutorials[n6][1] = 5;
            GameImpl._tutorials[n6][5] = 0;
            GameImpl._tutorials[n6][6] = n2;
            GameImpl._tutorials[n6][8] = n3;
            GameImpl._tutorials[n6][9] = n4;
            GameImpl._tutorials[n6][10] = n5;
            int n7 = 0;
            for (int i = 0; i < 24; ++i) {
                if (Level._entities_usage[i] != 1) continue;
                Unit unit = (Unit)Level._entities[i];
                if (unit._subtype != n2 || unit._allegiance != 0) continue;
                ++n7;
            }
            GameImpl._tutorials[n6][7] = n7;
            Hud._hud_current_tab = 1;
            if (Hud._hud_state == 2 && Hud._hud_substate == 1) {
                Hud.Build_ChangeSubState(0);
            }
        }
    }

    static void UpdateTrainTutorial(int n) {
        int[] nArray = _tutorials[n];
        nArray[5] = nArray[5] + 1;
        if (_tutorials[n][5] >= 4) {
            GameImpl._tutorials[n][5] = 0;
        }
        if (_tutorials[n][9] >= 0) {
            Hud.AddMessage(_tutorials[n][9], -1, 6, 32, 8, 0);
            GameImpl._tutorials[n][9] = -1;
        }
        if (_tutorials[n][10] >= 0 && Hud._hud_state == 2 && Hud._hud_substate == 1 && Hud._hud_build_items_available[1][Hud._hud_build_cursor_pos[1]] == _tutorials[n][6]) {
            Hud.AddMessage(_tutorials[n][10], -1, 6, 32, 8, 0);
            GameImpl._tutorials[n][10] = -1;
        }
        int n2 = 0;
        for (int i = 0; i < 24; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (unit._subtype != _tutorials[n][6] || unit._allegiance != 0) continue;
            ++n2;
        }
        if (n2 > _tutorials[n][7]) {
            GameImpl._tutorials[n][0] = 0;
            GameImpl._tutorials[n][2] = 0;
        }
    }

    static void DrawTrainTutorial(int n, SDKGraphics sDKGraphics) {
        if (Hud._hud_state == 2) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            if (Hud._hud_substate != 1 && Hud._hud_current_tab == 1) {
                n7 = Hud._hud_build_cursor_pos[1];
                n6 = Hud._hud_build_page_pos[1];
                byte[] byArray = Hud._hud_build_items_available[1];
                n5 = 97;
                n4 = _tutorials[n][6];
                int n8 = 0;
                for (n3 = 0; n3 < byArray.length; ++n3) {
                    if (byArray[n3] != n4 && byArray[n3] - 50 != n4) continue;
                    n8 = n3;
                    break;
                }
                n3 = 0;
                if (n7 != -1 && (byArray[n7] == n4 || byArray[n7] - 50 == n4)) {
                    n3 = 1;
                    n5 = 97 + (n7 - n6) * 31;
                    if (_tutorials[n][5] > 0) {
                        sDKGraphics.setColor(0xFFFF00);
                        sDKGraphics.drawRect(Constants.HUD_BUILD_POSX + -22, n5 + -16, 32, 32);
                    }
                } else {
                    for (n2 = n6; n2 < n6 + 3; ++n2) {
                        if ((byArray[n2] == n4 || byArray[n2] - 50 == n4) && n3 == 0) {
                            n3 = 1;
                            if (_tutorials[n][5] <= 0) break;
                            sDKGraphics.setColor(0xFFFF00);
                            sDKGraphics.drawRect(Constants.HUD_BUILD_POSX + -11, n5 + -16, 32, 32);
                            break;
                        }
                        n5 += 31;
                    }
                }
                if (n3 == 0 && n8 < n6 && _tutorials[n][5] > 0) {
                    sDKGraphics.setColor(0xFFFF00);
                    sDKGraphics.drawRect(Constants.HUD_BUILD_POSX + -13, 70, 26, 7);
                }
                if (n3 == 0 && n8 >= n6 + 3 && _tutorials[n][5] > 0) {
                    sDKGraphics.setColor(0xFFFF00);
                    sDKGraphics.drawRect(Constants.HUD_BUILD_POSX + -13, 179, 26, 7);
                }
            }
            if (Hud._hud_substate == 1 && (n7 = _tutorials[n][8]) > 0) {
                n6 = Hud._hud_build_cursor_pos[Hud._hud_current_tab];
                byte by = Hud._hud_build_page_pos[Hud._hud_current_tab];
                n5 = Constants.HUD_BUILD_SQUADS_POSX;
                n4 = 97 + (n6 - by) * 29;
                XSprite xSprite = _sprites[4];
                n2 = n3 = n4 - 12 + 6;
                int n9 = 1;
                while (n9 < 3) {
                    if (n9 == n7) {
                        if (_tutorials[n][5] > 0) {
                            sDKGraphics.setColor(0xFFFF00);
                            if (Hud._hud_current_squad == n7) {
                                sDKGraphics.drawRect(n5 + -17, n2 + -11, 34, 22);
                            } else {
                                sDKGraphics.drawRect(n5 + -18, n2 + -8, 36, 16);
                            }
                        }
                        break;
                    }
                    ++n9;
                    n2 += 12;
                }
            }
        } else if (Hud._hud_state == 1) {
            XSprite xSprite = _sprites[4];
            if (_tutorials[n][5] > 2) {
                xSprite.DrawFrame(21, Constants.SCR_W >> 1, Constants.SCR_H, 0);
            } else {
                xSprite.DrawFrame(22, Constants.SCR_W >> 1, Constants.SCR_H, 0);
            }
        }
    }

    static void StartSelectTutorial(int n, int n2, int n3) {
        int n4 = GameImpl.FindTutorialSlot();
        if (n4 >= 0) {
            GameImpl._tutorials[n4][0] = 1;
            GameImpl._tutorials[n4][2] = n;
            GameImpl._tutorials[n4][5] = 0;
            GameImpl._tutorials[n4][1] = 6;
            GameImpl._tutorials[n4][6] = n2;
            GameImpl._tutorials[n4][9] = n3;
        }
    }

    static void UpdateSelectTutorial(int n) {
        if (_tutorials[n][9] >= 0) {
            Hud.AddMessage(_tutorials[n][9], -1, 6, 32, 8, 0);
            GameImpl._tutorials[n][9] = -1;
        }
        int[] nArray = _tutorials[n];
        nArray[5] = nArray[5] + 1;
        if (_tutorials[n][5] >= 4) {
            GameImpl._tutorials[n][5] = 0;
        }
        int n2 = 0;
        for (int i = 0; i < 24; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (unit._subtype != _tutorials[n][6] || unit._allegiance != 0 || !unit._bSelected) continue;
            ++n2;
        }
        if (n2 > 0) {
            GameImpl._tutorials[n][0] = 0;
            GameImpl._tutorials[n][2] = 0;
        }
    }

    static void DrawSelectTutorial(int n, SDKGraphics sDKGraphics) {
        Unit unit;
        int n2;
        int n3;
        Constants constants;
        int n4 = Camera._targetPointer & 0xFFFF;
        XSprite xSprite = _sprites[6];
        for (int i = 0; i < 24; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            constants = (Unit)Level._entities[i];
            if (constants._subtype != _tutorials[n][6] || constants._allegiance != 0 || constants._bSelected) continue;
            n3 = 0 + constants._pos_x - Camera._nCamX;
            n2 = 38 + constants._pos_y - Camera._nCamY;
            if (_tutorials[n][5] > 2) {
                xSprite.DrawFrame(12, n3, n2 - 24, 0);
                continue;
            }
            xSprite.DrawFrame(12, n3, n2 - 24 - 5, 0);
        }
        if (n4 >= 0 && n4 < 24 && (unit = (Unit)Level.GetEntitySafe(Camera._targetPointer)) != null && unit._subtype == _tutorials[n][6]) {
            constants = _sprites[4];
            n3 = 0 + Camera._nCursorPosX - Camera._nCamX;
            n2 = 38 + Camera._nCursorPosY - Camera._nCamY;
        }
    }

    static void StartSWTutorial(int n, int n2, int n3, int n4, int n5) {
        int n6 = GameImpl.FindTutorialSlot();
        if (n6 >= 0) {
            GameImpl._tutorials[n6][0] = 1;
            GameImpl._tutorials[n6][2] = n;
            GameImpl._tutorials[n6][1] = 7;
            GameImpl._tutorials[n6][5] = 0;
            GameImpl._tutorials[n6][6] = n2;
            GameImpl._tutorials[n6][9] = n3;
            GameImpl._tutorials[n6][10] = n4;
            GameImpl._tutorials[n6][8] = n5;
            Hud._hud_current_tab = 2;
            if (Hud._hud_state == 2 && Hud._hud_substate == 3) {
                Hud.Build_ChangeSubState(0);
            }
        }
    }

    static void UpdateSWTutorial(int n) {
        int[] nArray = _tutorials[n];
        nArray[5] = nArray[5] + 1;
        if (_tutorials[n][5] >= 4) {
            GameImpl._tutorials[n][5] = 0;
        }
        if (_tutorials[n][9] >= 0) {
            Hud.AddMessage(_tutorials[n][9], -1, 6, 32, 8, 0);
            GameImpl._tutorials[n][9] = -1;
        }
        if (Hud._hud_state == 2 && Hud._hud_substate == 3 && Hud._hud_sw == _tutorials[n][6]) {
            if (_tutorials[n][10] >= 0) {
                Hud.AddMessage(_tutorials[n][10], -1, 6, 32, 8, 0);
                GameImpl._tutorials[n][10] = -1;
            }
            GameImpl._tutorials[n][0] = 0;
            GameImpl._tutorials[n][2] = 0;
        }
    }

    static void DrawSWTutorial(int n, SDKGraphics sDKGraphics) {
        if (Hud._hud_state == 2) {
            if (Hud._hud_substate != 3 && Hud._hud_current_tab == 2) {
                byte by = Hud._hud_build_cursor_pos[2];
                int n2 = Hud._hud_build_page_pos[2];
                byte[] byArray = Hud._hud_build_items_available[2];
                int n3 = 97;
                boolean bl = false;
                int n4 = _tutorials[n][6];
                if (by != -1 && byArray[by] == n4) {
                    n3 = 97 + (by - n2) * 29;
                    bl = true;
                    if (_tutorials[n][5] > 0) {
                        sDKGraphics.setColor(0xFFFF00);
                        sDKGraphics.drawRect(Constants.HUD_BUILD_POSX + -22, n3 + -16, 32, 32);
                    }
                } else {
                    for (int i = n2; i < n2 + 3; ++i) {
                        if (byArray[i] == n4 && !bl) {
                            bl = true;
                            if (_tutorials[n][5] > 0) {
                                sDKGraphics.setColor(0xFFFF00);
                                sDKGraphics.drawRect(Constants.HUD_BUILD_POSX + -11, n3 + -16, 32, 32);
                            }
                        }
                        n3 += 31;
                    }
                }
                if (!bl && n4 < n2 && _tutorials[n][5] > 0) {
                    sDKGraphics.setColor(0xFFFF00);
                    sDKGraphics.drawRect(Constants.HUD_BUILD_POSX + -13, 70, 26, 7);
                }
                if (!bl && n4 >= n2 + 3 && _tutorials[n][5] > 0) {
                    sDKGraphics.setColor(0xFFFF00);
                    sDKGraphics.drawRect(Constants.HUD_BUILD_POSX + -13, 179, 26, 7);
                }
            }
        } else if (Hud._hud_state == 1) {
            XSprite xSprite = _sprites[4];
            if (_tutorials[n][5] > 2) {
                xSprite.DrawFrame(23, Constants.SCR_W >> 1, Constants.SCR_H, 0);
            } else {
                xSprite.DrawFrame(24, Constants.SCR_W >> 1, Constants.SCR_H, 0);
            }
        }
    }

    static void __TUTORIAL() {
    }

    static void UTILS__() {
    }

    static void FillRect(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4, int n5) {
        sDKGraphics.setColor(n & 0xFFFFFF);
        sDKGraphics.fillRect(n2, n3, n4, n5);
    }

    public static void ResetRect(int[] nArray) {
        nArray[0] = 1024;
        nArray[1] = 1024;
        nArray[2] = -1024;
        nArray[3] = -1024;
    }

    public static int[] Rect(int[] nArray, int n, int n2, int n3, int n4) {
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n + n3;
        nArray[3] = n2 + n4;
        return nArray;
    }

    public static int[] Rect(int[] nArray, int[] nArray2) {
        nArray[0] = nArray2[0];
        nArray[1] = nArray2[1];
        nArray[2] = nArray2[2];
        nArray[3] = nArray2[3];
        return nArray;
    }

    public static void RectUnion(int[] nArray, int[] nArray2, int[] nArray3) {
        nArray[0] = Math.min(nArray2[0], nArray3[0]);
        nArray[1] = Math.min(nArray2[1], nArray3[1]);
        nArray[2] = Math.max(nArray2[2], nArray3[2]);
        nArray[3] = Math.max(nArray2[3], nArray3[3]);
    }

    public static void RectExpand(int[] nArray, int[] nArray2, int n) {
        nArray[0] = nArray2[0] - n;
        nArray[1] = nArray2[1] - n;
        nArray[2] = nArray2[2] + n;
        nArray[3] = nArray2[3] + n;
    }

    public static boolean PointInRect(int[] nArray, int n, int n2) {
        return n >= nArray[0] && n2 >= nArray[1] && n <= nArray[2] && n2 <= nArray[3];
    }

    public static void RectIntersect(int[] nArray, int[] nArray2, int[] nArray3) {
        nArray[0] = Math.max(nArray2[0], nArray3[0]);
        nArray[1] = Math.max(nArray2[1], nArray3[1]);
        nArray[2] = Math.min(nArray2[2], nArray3[2]);
        nArray[3] = Math.min(nArray2[3], nArray3[3]);
    }

    public static boolean RectIntersect(int[] nArray, int[] nArray2) {
        int n = Math.max(nArray[0], nArray2[0]);
        int n2 = Math.max(nArray[1], nArray2[1]);
        int n3 = Math.min(nArray[2], nArray2[2]);
        int n4 = Math.min(nArray[3], nArray2[3]);
        if (n > n3) {
            return false;
        }
        return n2 <= n4;
    }

    public static void RectDraw(int[] nArray, boolean bl, int n, SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(n);
        if (bl) {
            sDKGraphics.drawRect(nArray[0] - Camera._nCamX, nArray[1] - Camera._nCamY, nArray[2] - nArray[0], nArray[3] - nArray[1]);
        } else {
            sDKGraphics.drawRect(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
        }
    }

    public static void RectFill(int[] nArray, boolean bl, int n, SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(n);
        if (bl) {
            sDKGraphics.fillRect(nArray[0] - Camera._nCamX, nArray[1] - Camera._nCamY, nArray[2] - nArray[0], nArray[3] - nArray[1]);
        } else {
            sDKGraphics.fillRect(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
        }
    }

    public static void RectFill(int[] nArray, int n, SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(n);
        sDKGraphics.fillRect(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
    }

    public static boolean IsRectNotVisible(int[] nArray) {
        return nArray[2] - Camera._nCamX < 10 || nArray[0] - Camera._nCamX > 0 + Constants.SV_W - 10 || nArray[3] - Camera._nCamY < 48 || nArray[1] - Camera._nCamY > 38 + Constants.SV_H - 10;
    }

    public static final int randomInt() {
        _randomSeed = _randomSeed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(_randomSeed >>> 16);
    }

    public static final int random(int n) {
        return Math.abs(GameImpl.randomInt()) % n;
    }

    public static int random(int n, int n2) {
        return n + Math.abs(GameImpl.randomInt()) % (n2 - n);
    }

    public static void setSeed(long l) {
        _randomSeed = (l ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    public static void MemSet(int[] nArray, int n) {
        int n2 = nArray.length;
        if (n2 > 0) {
            nArray[0] = n;
        }
        for (int i = 1; i < n2; i += i) {
            System.arraycopy(nArray, 0, nArray, i, n2 - i < i ? n2 - i : i);
        }
    }

    public static void MemSet(int[] nArray, int n, int n2) {
        if (n2 > 0) {
            nArray[0] = n;
        }
        for (int i = 1; i < n2; i += i) {
            System.arraycopy(nArray, 0, nArray, i, n2 - i < i ? n2 - i : i);
        }
    }

    public static void MemSet(short[] sArray, short s) {
        int n = sArray.length;
        if (n > 0) {
            sArray[0] = s;
        }
        for (int i = 1; i < n; i += i) {
            System.arraycopy(sArray, 0, sArray, i, n - i < i ? n - i : i);
        }
    }

    public static void MemSet(byte[] byArray, byte by) {
        int n = byArray.length;
        if (n > 0) {
            byArray[0] = by;
        }
        for (int i = 1; i < n; i += i) {
            System.arraycopy(byArray, 0, byArray, i, n - i < i ? n - i : i);
        }
    }

    public static void DumpArray(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            for (int j = 0; j < 16 && i < byArray.length; ++j, ++i) {
                String string = Integer.toHexString(byArray[i] & 0xFF);
                if (string.length() == 1) {
                    System.err.print("0" + string + " ");
                    continue;
                }
                System.err.print(string + " ");
            }
            System.err.println();
        }
    }

    public static SDKImage LoadImageWithPalette(byte[] byArray, byte[] byArray2) {
        SDKImage sDKImage = null;
        System.arraycopy(byArray2, 0, byArray, 41, byArray2.length);
        try {
            sDKImage = SDKUtils.createImage(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            Debug.CatchException("Exception on LoadImageWithPalette:", exception);
        }
        return sDKImage;
    }

    public static byte[] ReadByteArray(SDKInputStream sDKInputStream, int n, byte[] byArray, int n2) throws IOException {
        if (n > 0) {
            if (byArray == null) {
                byArray = new byte[n];
            }
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)sDKInputStream.read();
            }
        }
        return byArray;
    }

    public static short[] ReadShortArray(SDKInputStream sDKInputStream, int n, short[] sArray, int n2) throws IOException {
        if (n > 0) {
            if (sArray == null) {
                sArray = new short[n];
            }
            for (int i = n2; i < n; ++i) {
                sArray[i] = sDKInputStream.readShort();
            }
        }
        return sArray;
    }

    public static int[] ReadIntArray(SDKInputStream sDKInputStream, int n, int[] nArray, int n2) throws IOException {
        if (n > 0) {
            if (nArray == null) {
                nArray = new int[n];
            }
            for (int i = 0; i < n; ++i) {
                nArray[i] = sDKInputStream.read() & 0xFF | (sDKInputStream.read() & 0xFF) << 8 | (sDKInputStream.read() & 0xFF) << 16 | (sDKInputStream.read() & 0xFF) << 24;
            }
        }
        return nArray;
    }

    public static void DrawString(int n, int n2, int n3, int n4) {
        SDKUtils.drawString(SDKUtils.getString(n, _string), n2, n3, n4);
    }

    public static void QuickSort(int[] nArray, int[] nArray2, int n, int n2) {
        _qsort_w_array = nArray;
        _qsort_other_array = nArray2;
        GameImpl.QuickSort(n, n2);
    }

    public static void QuickSort(int n, int n2) {
        if (n2 <= n) {
            return;
        }
        int n3 = n;
        int n4 = _qsort_w_array[n3];
        GameImpl.QuickSort_SwitchValues(n3, n2);
        n3 = n;
        for (int i = n; i < n2; ++i) {
            if (_qsort_w_array[i] > n4) continue;
            GameImpl.QuickSort_SwitchValues(n3, i);
            ++n3;
        }
        GameImpl.QuickSort_SwitchValues(n3, n2);
        GameImpl.QuickSort(n, n3 - 1);
        GameImpl.QuickSort(n3 + 1, n2);
    }

    public static void QuickSort_SwitchValues(int n, int n2) {
        int n3 = _qsort_w_array[n];
        GameImpl._qsort_w_array[n] = _qsort_w_array[n2];
        GameImpl._qsort_w_array[n2] = n3;
        if (_qsort_other_array != null) {
            n3 = _qsort_other_array[n];
            GameImpl._qsort_other_array[n] = _qsort_other_array[n2];
            GameImpl._qsort_other_array[n2] = n3;
        }
    }

    public static long Sqrt(long l) {
        long l2;
        if (l == 0L) {
            return 0L;
        }
        long l3 = l2 = 1L + l >> 1;
        long l4;
        long l5;
        while ((l5 = Math.abs((l4 = l2 + l / l2 >> 1) - l2)) < l3) {
            l3 = l5;
            l2 = l4;
        }
        return l2;
    }

    public static long Ln(long l) {
        if (l == 0L) {
            return 0L;
        }
        long l2 = GameImpl.Sqrt(l);
        long l3 = (6L * (l - 1L) << 16) / (l + 1L + 4L * l2);
        return l3 >> 10;
    }

    public static void DrawLightningBolt(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7, int n8) {
        if (n6 < n5) {
            n = 0 + (n >> 6) - Camera._nCamX;
            n2 = 38 + (n2 >> 6) - Camera._nCamY;
            n3 = 0 + (n3 >> 6) - Camera._nCamX;
            n4 = 38 + (n4 >> 6) - Camera._nCamY;
            sDKGraphics.setColor(n7);
            sDKGraphics.drawLine(n, n2, n3, n4);
            sDKGraphics.setColor(n8);
            if (n3 >= n) {
                sDKGraphics.drawLine(n + 1, n2 - 1, n3 + 1, n4 - 1);
                sDKGraphics.drawLine(n - 1, n2 + 1, n3 - 1, n4 + 1);
            } else {
                sDKGraphics.drawLine(n + 1, n2 + 1, n3 + 1, n4 + 1);
                sDKGraphics.drawLine(n - 1, n2 - 1, n3 - 1, n4 - 1);
            }
        } else {
            int n9 = n3 + n >> 1;
            int n10 = n4 + n2 >> 1;
            int n11 = GameImpl.random(0, 12);
            n9 += (n11 - 6) * n6;
            n11 = GameImpl.random(0, 12);
            n10 = bl ? (n10 -= Math.abs(n11 - 6) * n6) : (n10 += (n11 - 6) * n6);
            GameImpl.DrawLightningBolt(sDKGraphics, n, n2, n9, n10, n5, n6 >> 1, bl, n7, n8);
            GameImpl.DrawLightningBolt(sDKGraphics, n3, n4, n9, n10, n5, n6 >> 1, bl, n7, n8);
            n11 = GameImpl.random(0, 12);
            if (n11 > 3) {
                GameImpl.DrawLightningBolt(sDKGraphics, n3, n4, n9, n10, n5, n6 >> 1, bl, n7, n8);
            }
            if (n11 > 9) {
                GameImpl.DrawLightningBolt(sDKGraphics, n3, n4, n9, n10, n5, n6 >> 1, bl, n7, n8);
            }
        }
    }

    public static void DrawNarrowBolt(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n6 < n5) {
            sDKGraphics.setColor(n7);
            sDKGraphics.drawLine((n >> 6) - Camera._nCamX, (n2 >> 6) - Camera._nCamY, (n3 >> 6) - Camera._nCamX, (n4 >> 6) - Camera._nCamY);
        } else {
            int n8 = n3 + n >> 1;
            int n9 = n4 + n2 >> 1;
            int n10 = GameImpl.random(0, 12);
            n8 += (n10 - 6) * n6;
            n10 = GameImpl.random(0, 12);
            GameImpl.DrawNarrowBolt(sDKGraphics, n, n2, n8, n9 += (n10 - 6) * n6, n5, n6 >> 1, n7);
            GameImpl.DrawNarrowBolt(sDKGraphics, n3, n4, n8, n9, n5, n6 >> 1, n7);
        }
    }

    public static void DrawChargedBolt(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4) {
        int n5 = GameImpl.random(n3 >> 2, n3);
        int n6 = GameImpl.random(n3 >> 2, n3);
        GameImpl.DrawNarrowBolt(sDKGraphics, n - (n5 << 6), n2 - (n6 << 6), n + (n5 << 6), n2 + (n6 << 6), 16, 64, n4);
        GameImpl.DrawNarrowBolt(sDKGraphics, n - (n5 << 6), n2 + (n6 << 6), n + (n5 << 6), n2 - (n6 << 6), 16, 64, n4);
    }

    public static void DrawCrossBolt(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4) {
        int n5 = GameImpl.random(n3 >> 2, n3);
        GameImpl.DrawNarrowBolt(sDKGraphics, n - (n5 << 6), n2, n + (n5 << 6), n2, 2, 48, n4);
        GameImpl.DrawNarrowBolt(sDKGraphics, n, n2 + (n5 << 6), n, n2 - (n5 << 6), 2, 48, n4);
    }

    static void SnowSetState(int n) {
        _snow_state = n;
    }

    static void SnowInit() {
        _snow_pos_x = new int[50];
        _snow_pos_y = new int[50];
        _snow_spd_x = new int[50];
        _snow_spd_y = new int[50];
        _snow_time = new int[50];
        _snow_state = 1;
        _snow_particles = 0;
        for (int i = 0; i < _snow_particles; ++i) {
            GameImpl.SnowInitParticle(i);
        }
    }

    static void SnowClean() {
        _snow_particles = 0;
        _snow_state = 0;
    }

    static void SnowInitParticle(int n) {
        GameImpl._snow_pos_x[n] = GameImpl.random(0, Constants.SCR_W << 16);
        GameImpl._snow_pos_y[n] = GameImpl.random(0, Constants.SCR_H << 16);
        GameImpl._snow_spd_x[n] = GameImpl.random(-65536, 65536);
        GameImpl._snow_spd_y[n] = GameImpl.random(8192, 131072);
        GameImpl._snow_time[n] = GameImpl.random(50, 100);
    }

    static void SnowRelease() {
        _snow_pos_x = null;
        _snow_pos_y = null;
        _snow_spd_x = null;
        _snow_spd_y = null;
        _snow_time = null;
        _snow_particles = 0;
        _snow_state = 0;
    }

    static void SnowUpdate() {
        if (_snow_state == 0) {
            return;
        }
        if (_snow_state == 1) {
            if (_snow_particles == 50) {
                _snow_state = 2;
            } else {
                GameImpl.SnowInitParticle(_snow_particles);
                ++_snow_particles;
            }
        }
        for (int i = 0; i < _snow_particles; ++i) {
            int n;
            int n2 = _snow_spd_x[i] + GameImpl.random(-16384, 16384);
            if (n2 < -65536) {
                n2 = -65536;
            }
            if (n2 > 65536) {
                n2 = 65536;
            }
            if ((n = _snow_spd_y[i] + GameImpl.random(-1024, 1024)) < 8192) {
                n = 8192;
            }
            if (n > 131072) {
                n = 131072;
            }
            int n3 = i;
            _snow_pos_x[n3] = _snow_pos_x[n3] + n2;
            int n4 = i;
            _snow_pos_y[n4] = _snow_pos_y[n4] + n;
            GameImpl._snow_spd_x[i] = n2;
            GameImpl._snow_spd_y[i] = n;
            int n5 = i;
            _snow_time[n5] = _snow_time[n5] - 1;
            if (_snow_time[i] > 0 && _snow_pos_y[i] <= Constants.SCR_H << 16) continue;
            if (_snow_state == 3) {
                if (--_snow_particles == 0) {
                    _snow_state = 0;
                    continue;
                }
                GameImpl._snow_pos_x[i] = _snow_pos_x[_snow_particles];
                GameImpl._snow_pos_y[i] = _snow_pos_y[_snow_particles];
                GameImpl._snow_spd_x[i] = _snow_spd_x[_snow_particles];
                GameImpl._snow_spd_y[i] = _snow_spd_y[_snow_particles];
                GameImpl._snow_time[i] = _snow_time[_snow_particles];
                continue;
            }
            GameImpl.SnowInitParticle(i);
        }
    }

    static void SnowDraw(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(-1);
        for (int i = 0; i < _snow_particles; ++i) {
            int n;
            int n2;
            for (n2 = (_snow_pos_x[i] >> 16) - Camera._nCamX; n2 > Constants.SCR_W; n2 -= Constants.SCR_W) {
            }
            while (n2 < 0) {
                n2 += Constants.SCR_W;
            }
            for (n = (_snow_pos_y[i] >> 16) - Camera._nCamY; n > Constants.SCR_H; n -= Constants.SCR_H) {
            }
            while (n < 0) {
                n += Constants.SCR_H;
            }
            if (_snow_time[i] < 10 || _snow_time[i] > 90) {
                sDKGraphics.fillRect(n2, n, 1, 1);
                continue;
            }
            sDKGraphics.fillRect(n2, n, 2, 2);
        }
    }

    public static void DrawNumber(int n, int n2, int n3, int n4) {
        if (_old_number != n) {
            _old_number = n;
            _numbersString.setLength(0);
            _numbersString = GameImpl.AppendNumber(_numbersString, n, 0);
        }
        SDKUtils.drawString(_numbersString, n2, n3, n4);
    }

    public static void DrawSeparatedNumbers(int n, int n2, String string, int n3, int n4, int n5, int n6) {
        if (_old_number1 != n || _old_number2 != n2 || _old_minSize != n6) {
            _old_number1 = n;
            _old_number2 = n2;
            _old_minSize = n6;
            _separatedNumbersString.setLength(0);
            _separatedNumbersString = GameImpl.AppendNumber(_separatedNumbersString, n, 0);
            _separatedNumbersString.append(string);
            _separatedNumbersString = GameImpl.AppendNumber(_separatedNumbersString, n2, n6);
        }
        SDKUtils.drawString(_separatedNumbersString, n3, n4, n5);
    }

    public static SDKString ConcatNumber(SDKString sDKString, int n, int n2) {
        if (_language == 1 && n > 999 && n2 == 0) {
            sDKString = GameImpl.ConcatNumber(sDKString, n / 1000, 0);
            sDKString = sDKString.concat(" ");
            n %= 1000;
            n2 = 3;
        }
        if (n2 == 3 & n < 100) {
            sDKString = sDKString.concat(0);
            --n2;
        }
        if (n2 == 2 && n < 10) {
            sDKString = sDKString.concat(0);
            --n2;
        }
        sDKString = sDKString.concat(n);
        return sDKString;
    }

    public static SDKString AppendNumber(SDKString sDKString, int n, int n2) {
        if (_language == 1 && n > 999 && n2 == 0) {
            sDKString = GameImpl.AppendNumber(sDKString, n / 1000, 0);
            sDKString = sDKString.append(" ");
            n %= 1000;
            n2 = 3;
        }
        if (n2 == 3 & n < 100) {
            sDKString = sDKString.append(0);
            --n2;
        }
        if (n2 == 2 && n < 10) {
            sDKString = sDKString.append(0);
            --n2;
        }
        sDKString = sDKString.append(n);
        return sDKString;
    }

    public static int GetInitialSpeed(int n, int n2) {
        return n2 * n / 2;
    }

    public static int GetOrientation2(int n, int n2, int n3) {
        int n4 = n;
        int n5 = -n2 + n3;
        if (Math.abs(n4) <= 5 && Math.abs(n5) <= 5) {
            return 16;
        }
        int n6 = (int)Math.sqrt(n4 * n4 + n5 * n5 << 12);
        int n7 = Math.abs((n4 << 12) / n6);
        int n8 = Math.abs((n5 << 12) / n6);
        if (n4 <= 0 && n5 > 0) {
            if (n7 <= 4) {
                return 0;
            }
            if (n7 <= 32) {
                return 1;
            }
            if (n7 > 32 && n8 > 32) {
                return 2;
            }
            if (n8 >= 4) {
                return 3;
            }
            return 4;
        }
        if (n4 < 0 && n5 <= 0) {
            if (n7 <= 4) {
                return 8;
            }
            if (n7 <= 32) {
                return 7;
            }
            if (n7 > 32 && n8 > 32) {
                return 6;
            }
            if (n8 >= 4) {
                return 5;
            }
            return 4;
        }
        if (n4 >= 0 && n5 < 0) {
            if (n7 <= 4) {
                return 8;
            }
            if (n7 <= 32) {
                return 9;
            }
            if (n7 > 32 && n8 > 32) {
                return 10;
            }
            if (n8 >= 4) {
                return 11;
            }
            return 12;
        }
        if (n7 <= 4) {
            return 0;
        }
        if (n7 <= 32) {
            return 15;
        }
        if (n7 > 32 && n8 > 32) {
            return 14;
        }
        if (n8 >= 4) {
            return 13;
        }
        return 12;
    }

    public static void Clear_Fade() {
        _fadeCounter = 0;
        _darkFade = false;
        _fadeSteps = 20;
        _fadeIn = false;
    }

    public static void Fade(boolean bl, int n, boolean bl2) {
        _darkFade = bl2;
        _fadeIn = bl;
        _fadeSteps = n;
        if (bl) {
            _fadeCounter = 0;
            if (_fadeSteps == 0) {
                _fadeSteps = 1;
                _fadeCounter = 1;
                return;
            }
        } else {
            _fadeCounter = _fadeSteps;
        }
    }

    public static void Update_FadeIn() {
        if (_fadeCounter < _fadeSteps) {
            _fadeCounter += 2;
        }
    }

    public static void Update_FadeOut() {
        if (_fadeCounter > 0 && (_fadeCounter -= 2) <= 0) {
            Hud.ForceDetailsHudRefresh();
        }
    }

    public static void Update_Fade() {
        if (_fadeIn) {
            GameImpl.Update_FadeIn();
        } else {
            GameImpl.Update_FadeOut();
        }
    }

    public static void Draw_Fade(SDKGraphics sDKGraphics) {
        if (_fadeCounter <= 0) {
            return;
        }
        int n = _fadeCounter * (Constants.SCR_H / 2) / _fadeSteps;
        sDKGraphics.setColor(_darkFade ? -16777216 : -1);
        sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
        sDKGraphics.fillRect(0, 0, Constants.SCR_W, n);
        sDKGraphics.fillRect(0, Constants.SCR_H - n, Constants.SCR_W, n);
    }

    public static byte[][] BS_ReadByteArray(SDKInputStream sDKInputStream, byte[][] object) throws IOException {
        int n = sDKInputStream.readShort();
        if (n > 0) {
            if (object == null) {
                object = new byte[n][];
            }
            for (int i = 0; i < n; ++i) {
                short s = sDKInputStream.readShort();
                if (s <= 0) continue;
                object[i] = GameImpl.ReadByteArray(sDKInputStream, s, object[i], 0);
            }
        }
        return object;
    }

    public static short[][] BS_ReadShortArray(SDKInputStream sDKInputStream, short[][] object) throws IOException {
        int n = sDKInputStream.readShort();
        if (n > 0) {
            if (object == null) {
                object = new short[n][];
            }
            for (int i = 0; i < n; ++i) {
                short s = sDKInputStream.readShort();
                if (s <= 0) continue;
                object[i] = GameImpl.ReadShortArray(sDKInputStream, s, object[i], 0);
            }
        }
        return object;
    }

    public static int[][] BS_ReadIntArray(SDKInputStream sDKInputStream, int[][] object) throws IOException {
        int n = sDKInputStream.readShort();
        if (n > 0) {
            if (object == null) {
                object = new int[n][];
            }
            for (int i = 0; i < n; ++i) {
                short s = sDKInputStream.readShort();
                if (s <= 0) continue;
                object[i] = GameImpl.ReadIntArray(sDKInputStream, s, object[i], 0);
            }
        }
        return object;
    }

    public static byte[][][] BS_ReadByteArray(SDKInputStream sDKInputStream, byte[][][] object) throws IOException {
        int n = sDKInputStream.readShort();
        if (n > 0) {
            if (object == null) {
                object = new byte[n][][];
            }
            for (int i = 0; i < n; ++i) {
                GameImpl.BS_ReadByteArray(sDKInputStream, object[i]);
            }
        }
        return object;
    }

    public static short[][][] BS_ReadShortArray(SDKInputStream sDKInputStream, short[][][] object) throws IOException {
        int n = sDKInputStream.readShort();
        if (n > 0) {
            if (object == null) {
                object = new short[n][][];
            }
            for (int i = 0; i < n; ++i) {
                GameImpl.BS_ReadShortArray(sDKInputStream, object[i]);
            }
        }
        return object;
    }

    public static int[][][] BS_ReadIntArray(SDKInputStream sDKInputStream, int[][][] object) throws IOException {
        int n = sDKInputStream.readShort();
        if (n > 0) {
            if (object == null) {
                object = new int[n][][];
            }
            for (int i = 0; i < n; ++i) {
                GameImpl.BS_ReadIntArray(sDKInputStream, object[i]);
            }
        }
        return object;
    }

    static void __UTILS() {
    }

    static {
        _string = new SDKString("");
        _frameCounter = 0;
        _maxSovietMission = 0;
        _maxAlliedMission = -1;
        _maxSkirmishMission = 0;
        _nextMission = -1;
        _oldSovietMission = 0;
        _oldAlliedMission = -1;
        _oldSkirmishMission = 0;
        _soundEnable = false;
        _vibrationsEnable = true;
        _tutorialEnable = true;
        _language = -1;
        _ID = 1;
        _realData = new byte[30];
        _pos = 0;
        bBacklightOn = true;
        bBacklightStateChange = false;
        soundVolume = 100;
        _cheatsStrings = new SDKString[]{new SDKString("1234"), new SDKString("2345"), new SDKString("3456"), new SDKString("1337"), new SDKString("4567")};
        _cheatsNames = new SDKString[]{new SDKString("UNLOCK_ALL_LEVELS"), new SDKString("INSTANT_WIN"), new SDKString("INSTANT_LOOSE"), new SDKString("GOD_MODE"), new SDKString("REVEAL_MAP")};
        _cheatsEnabledInJad = false;
        _cheatsKeyBuffer = new char[10];
        _menuItems = null;
        _menuNames = null;
        _menuSoftKeys = null;
        _menuStack = new int[18];
        _menuSelectionStack = new int[18];
        _scrolltxt_pos = 0;
        _scrolltxt_nolines = 0;
        _current_menu_language = 0;
        _nextMenuState = 0;
        bMoreGames = false;
        _spritesNames = null;
        _spriteFlags = new short[]{1024, 0, 1024, 1024, 0, 0, 0, 1024, 0, 0, 1024, 2048, 2048, 0, 0, 2048, 2048, 2048, 0, 0, 0, 0, 0, 0};
        _spritePalCount = new byte[]{1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1};
        _legalImage = null;
        _tileSets = new byte[]{20, 21};
        _sprites = new XSprite[24];
        _versorX = new byte[]{0, 1, 1, 1, 0, -1, -1, -1};
        _versorY = new byte[]{-1, -1, 0, 1, 1, 1, 0, -1};
        _rgbData = new int[Constants.SCR_W];
        _rgbData_OldColor = 0;
        _rgbData_OldW = 0;
        _rect = new int[4];
        _rand = new Random();
        _randomSeed = 0L;
        _temp_string = new SDKString("");
        _qsort_w_array = null;
        _qsort_other_array = null;
        _numbersString = new SDKString(64, 1);
        _separatedNumbersString = new SDKString(64, 1);
        _old_number = -1;
        _old_number1 = -1;
        _old_number2 = -1;
        _old_minSize = -1;
        _darkFade = false;
        _fadeSteps = 20;
        _fadeIn = false;
    }
}

