/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Building;
import com.ea.game.BuildingConstants;
import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.GameImpl;
import com.ea.game.GraphicsConstants;
import com.ea.game.Hud;
import com.ea.game.Level;
import com.ea.game.Script;
import com.ea.game.SpriteConstants;
import com.ea.game.Unit;
import com.ea.game.UnitsConstants;
import com.ea.game.XSprite;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import java.io.IOException;

public class Entity
implements Constants,
UnitsConstants,
BuildingConstants,
GraphicsConstants,
SpriteConstants {
    public static short _global_uid = 0;
    protected static SDKString _descr_string;
    static short[] _txtDescrStringLines;
    short _uid;
    short _arrayIndex;
    int _type;
    int _id;
    int _flags;
    int _pos_x;
    int _pos_y;
    byte _orientation;
    int _z_order;
    int _state;
    int _timer;
    short[] _sdata;
    int[] _idata;
    int _tooltipDelta;
    int _tooltipTxt;
    int _sprite;
    int _crt_anim;
    int _crt_aframe;
    int _crt_aframe_time;
    static int nrTriggers;
    static int[] _triggers;
    static int nrWayPoints;
    static short[] _wayPoints;
    static int nrBuildSpots;
    static short[] _buildSpots;
    static int[] _objectives;

    protected static short GetGlobalUID() {
        _global_uid = (short)(_global_uid + 1 & 0xFFF);
        return _global_uid;
    }

    public Entity(int n) {
        this._arrayIndex = (short)n;
        this._type = 0;
        this._id = 0;
        this._flags = 0;
        this._pos_x = 0;
        this._pos_y = 0;
        this._z_order = 0;
        this._timer = 0;
        this._idata = null;
        this._sdata = null;
        this._sprite = 0;
        this._crt_anim = 0;
        this._crt_aframe = 0;
        this._crt_aframe_time = 0;
        this._orientation = 0;
        this._tooltipDelta = 0;
        this._tooltipTxt = 0;
    }

    public Entity(int n, int n2) {
        this._arrayIndex = (short)n;
        this._type = -1;
        this.EntityConstructor(n2);
    }

    public void Release() {
        this._type = -1;
        this._id = 0;
        this._flags = 0;
        this._pos_x = 0;
        this._pos_y = 0;
        this._z_order = 0;
        this._timer = 0;
        this._idata = null;
        this._sdata = null;
        this._sprite = 0;
        this._crt_anim = 0;
        this._crt_aframe = 0;
        this._crt_aframe_time = 0;
        this._orientation = 0;
    }

    public void EntityConstructor(int n) {
        if (this._type != n) {
            this.Release();
            switch (n) {
                case 103: {
                    this._sdata = new short[12];
                    break;
                }
                case 104: {
                    this._sdata = new short[2];
                    break;
                }
                case 105: {
                    this._sdata = new short[4];
                    break;
                }
                case 10: {
                    this._idata = new int[1];
                    break;
                }
                case 109: {
                    this._sdata = new short[6];
                    break;
                }
                case 106: {
                    this._idata = new int[4];
                    break;
                }
                case 114: {
                    this._sdata = new short[3];
                    break;
                }
                case 115: {
                    this._sdata = new short[0];
                }
            }
        }
        this._type = n;
        this._state = -1;
        this._sprite = -1;
        this._flags = 0;
    }

    public void EntityDestructor() {
        if (this._type == -1) {
            return;
        }
        this._id = 0;
        switch (this._type) {
            case 6: {
                ((Building)this).Building_Destructor();
                break;
            }
            case 5: {
                ((Unit)this).Unit_Destructor();
            }
        }
    }

    public void Load(SDKInputStream sDKInputStream) throws IOException {
        this._id = sDKInputStream.readShort();
        short s = sDKInputStream.readShort();
        short s2 = sDKInputStream.readShort();
        this.SetPosition(s, s2);
        switch (this._type) {
            case 5: {
                ((Unit)this).Unit_Load(sDKInputStream);
                break;
            }
            case 6: {
                ((Building)this).Building_Load(sDKInputStream);
                break;
            }
            case 0: 
            case 1: {
                this._sprite = sDKInputStream.read();
                this._crt_anim = sDKInputStream.read();
                this._flags |= sDKInputStream.read();
                this._z_order = sDKInputStream.read();
                if (this._type != 1) break;
                this._crt_aframe = sDKInputStream.read();
                break;
            }
            case 2: {
                this._sprite = sDKInputStream.read();
                this._crt_anim = sDKInputStream.read();
                this._flags |= sDKInputStream.read();
                this._z_order = sDKInputStream.read();
                break;
            }
            case 10: {
                this._idata[0] = sDKInputStream.readInt() & 0xFFFF;
            }
        }
    }

    public void Init() {
        switch (this._type) {
            case 5: {
                ((Unit)this).Unit_Init();
                break;
            }
            case 6: {
                ((Building)this).Building_Init();
                break;
            }
            case 10: {
                this.MField_Init();
            }
        }
    }

    public void Init2() {
        switch (this._type) {
            case 2: {
                this.SetCrtAnim(this._crt_anim);
                break;
            }
            case 5: {
                ((Unit)this).Unit_Init2();
                break;
            }
            case 6: {
                ((Building)this).Building_Init2();
                break;
            }
            case 10: {
                this.MField_Init2();
            }
        }
    }

    public void Update() {
        if ((this._flags & 8) != 0) {
            return;
        }
        switch (this._type) {
            case 5: {
                ((Unit)this).Unit_Update();
                break;
            }
            case 6: {
                ((Building)this).Building_Update();
                break;
            }
            case 103: {
                this.Bullet_Update();
                break;
            }
            case 104: {
                this.Lightning_Update();
                break;
            }
            case 105: {
                this.IGMessage_Update();
                break;
            }
            case 2: {
                this.UpdateCrtAnim();
                if ((this._flags & 0x200) == 0 || !this.IsCrtAnimEnded()) break;
                Level.DeleteEntity(this);
                break;
            }
            case 10: {
                this.MField_Update();
                break;
            }
            case 106: {
                this.Nuke_Update();
                break;
            }
            case 109: {
                this.Laser_Update();
                break;
            }
            case 114: {
                this.StormBolt_Update();
                break;
            }
            case 115: {
                this.Storm_Update();
                break;
            }
            default: {
                if ((this._flags & 0x80) == 0 || this._sprite < 0) break;
                this.UpdateCrtAnim();
            }
        }
    }

    public void Draw(SDKGraphics sDKGraphics) {
        if ((this._flags & 0x10) != 0) {
            return;
        }
        switch (this._type) {
            case 5: {
                ((Unit)this).Unit_Draw(sDKGraphics);
                break;
            }
            case 6: {
                ((Building)this).Building_Draw(sDKGraphics);
                break;
            }
            case 103: {
                this.Bullet_Draw(sDKGraphics);
                break;
            }
            case 104: {
                this.Lightning_Draw(sDKGraphics);
                break;
            }
            case 105: {
                this.IGMessage_Draw(sDKGraphics);
                break;
            }
            case 1: {
                GameImpl._sprites[this._sprite].SetCurrentPalette(this._crt_aframe);
                this.Decorator_Draw(sDKGraphics);
                GameImpl._sprites[this._sprite].SetCurrentPalette(0);
                break;
            }
            case 0: {
                this.Decorator_Draw(sDKGraphics);
                break;
            }
            case 10: {
                this.MField_Draw(sDKGraphics);
                break;
            }
            case 106: {
                this.Nuke_Draw(sDKGraphics);
                break;
            }
            case 109: {
                this.Laser_Draw(sDKGraphics);
                break;
            }
            case 114: {
                this.StormBolt_Draw(sDKGraphics);
                break;
            }
            case 115: {
                break;
            }
            default: {
                this.DrawCrtAnim(sDKGraphics);
            }
        }
    }

    public void DrawTooltip(SDKGraphics sDKGraphics) {
        int n = 90;
        boolean bl = false;
        if (this._type == 10) {
            bl = true;
            this._tooltipDelta = 30;
            this._tooltipTxt = 16;
            _descr_string = SDKUtils.getString(this._tooltipTxt, _descr_string);
            _descr_string = GameImpl.ConcatNumber(_descr_string, this._idata[0], 0);
        }
        if (bl && Camera._targetPointer == this.GetPointer()) {
            SDKUtils.setFont(GameImpl.fonts[0]);
            _txtDescrStringLines = SDKUtils.wrapString(_descr_string, _txtDescrStringLines, n, (short)124);
            int n2 = _txtDescrStringLines[0] * SDKUtils.getLineSize();
            int n3 = this._pos_x;
            int n4 = this._pos_y - this._tooltipDelta;
            if (n3 - n / 2 < 0) {
                n3 = n / 2;
            } else if (n3 + n / 2 > Level._map_w) {
                n3 = Level._map_w - n / 2;
            }
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 + n2 > Level._map_h) {
                n4 = Level._map_h - n2;
            }
            SDKUtils.drawWrappedString(_descr_string, _txtDescrStringLines, 1, _txtDescrStringLines[0], n3 += 0 - Camera._nCamX, n4 += 38 - Camera._nCamY, 1);
        }
    }

    static void XSPRITE_ANIM__() {
    }

    public void SetCrtAnim(int n) {
        this._crt_anim = n;
        this._crt_aframe = 0;
        XSprite xSprite = GameImpl._sprites[this._sprite];
        this._crt_aframe_time = xSprite.GetAnimFrameTime(this._crt_anim, this._crt_aframe);
        this._flags &= 0xFFFFFFDF;
    }

    public void UpdateCrtAnim() {
        if (this._crt_aframe_time == 0 || (this._flags & 0x820) == 2080) {
            return;
        }
        this._flags &= 0xFFFFFFDF;
        --this._crt_aframe_time;
        if (this._crt_aframe_time <= 0) {
            XSprite xSprite = GameImpl._sprites[this._sprite];
            ++this._crt_aframe;
            if (this._crt_aframe >= xSprite.GetAnimLength(this._crt_anim)) {
                this._crt_aframe = (this._flags & 0x800) != 0 ? --this._crt_aframe : 0;
                this._flags |= 0x20;
            }
            this._crt_aframe_time = xSprite.GetAnimFrameTime(this._crt_anim, this._crt_aframe);
        }
    }

    public boolean IsCrtAnimEnded() {
        return this._crt_aframe_time == 0 || (this._flags & 0x20) != 0;
    }

    public void DrawCrtAnim(SDKGraphics sDKGraphics) {
        int n = this._pos_x - Camera._nCamX;
        int n2 = this._pos_y - Camera._nCamY;
        if ((this._flags & 0x10000) == 0) {
            n += 0;
            n2 += 38;
        }
        XSprite xSprite = GameImpl._sprites[this._sprite];
        if (this._type == 103) {
            xSprite.DrawAnimFrame(this._crt_anim, this._crt_aframe, n, n2, this._flags & 7);
        } else {
            xSprite.DrawAnimFrame(this._crt_anim, this._crt_aframe, n, n2, this._flags & 7);
        }
    }

    static void __XSPRITE_ANIM() {
    }

    public void MarkUsedSprite() {
        int n = 1;
        switch (this._type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 10: {
                if (this._sprite < 0) break;
                GameImpl._sprites[this._sprite]._flags |= 0x80 | n;
                break;
            }
            case 6: {
                n = ((Building)this).GetUsedPalette();
                if (this._sprite < 0) break;
                int n2 = 0;
                int n3 = GameImpl._spritePalCount[this._sprite];
                for (int i = 0; i < 4 && i < n3; ++i) {
                    if ((GameImpl._sprites[this._sprite]._flags & 1 << i) == 0) continue;
                    ++n2;
                }
                if (n2 != n && (GameImpl._sprites[this._sprite]._flags & 0x100) != 0) {
                    GameImpl._sprites[this._sprite].Release();
                }
                GameImpl._sprites[this._sprite]._flags |= 0x80 | n;
                break;
            }
            case 5: {
                n = ((Unit)this).GetUsedPalette();
                switch (((Unit)this)._subtype) {
                    default: 
                }
                if (this._sprite < 0) break;
                int n4 = 0;
                int n5 = GameImpl._spritePalCount[this._sprite];
                for (int i = 0; i < 4 && i < n5; ++i) {
                    if ((GameImpl._sprites[this._sprite]._flags & 1 << i) == 0) continue;
                    ++n4;
                }
                if (n4 != n && (GameImpl._sprites[this._sprite]._flags & 0x100) != 0) {
                    GameImpl._sprites[this._sprite].Release();
                }
                GameImpl._sprites[this._sprite]._flags |= 0x80 | n;
            }
        }
    }

    public int[] ComputeBoundingBox() {
        XSprite xSprite = GameImpl._sprites[this._sprite];
        switch (this._type) {
            default: 
        }
        xSprite.RectFrame(xSprite.GetAnimFrameId(this._crt_anim, this._crt_aframe), this._pos_x, this._pos_y, 0);
        return XSprite._rect;
    }

    public int[] GetCollisionRect(boolean bl) {
        if ((this._flags & 0x58) != 0) {
            return null;
        }
        switch (this._type) {
            default: 
        }
        return null;
    }

    public int GetLife() {
        switch (this._type) {
            case 5: {
                return ((Unit)this)._life;
            }
            case 6: {
                return ((Building)this)._life;
            }
        }
        return 0;
    }

    public int GetPointer() {
        return (this._uid & 0xFFFF) << 16 | this._arrayIndex & 0xFFFF;
    }

    public void SetPosition(int n, int n2) {
        if (this._type == 5) {
            int n3 = this._pos_x;
            int n4 = this._pos_y;
            this._pos_x = n;
            this._pos_y = n2;
            Entity.CheckTriggers((Unit)this, n3, n4);
        } else {
            this._pos_x = n;
            this._pos_y = n2;
        }
    }

    void SetState(int n) {
    }

    public int Move(int n, boolean bl) {
        int n2;
        int n3 = this._sdata[0];
        int n4 = this._sdata[1];
        int n5 = n3 - this._pos_x;
        int n6 = n4 - this._pos_y;
        int n7 = Math.abs(n5);
        int n8 = n7 + (n2 = Math.abs(n6));
        if (n8 <= 4) {
            if (bl && Level.GetCollisionAt(n3, n4) > 10) {
                return 2;
            }
            this._pos_x = n3;
            this._pos_y = n4;
            return 1;
        }
        this._orientation = this.GetOrientation(n5, n6);
        if (n8 <= n) {
            if (bl && Level.GetCollisionAt(n3, n4) > 10) {
                return 2;
            }
            this._pos_x = n3;
            this._pos_y = n4;
            return 1;
        }
        n8 = n7 > n2 ? n7 : n2;
        n5 = (n5 * n << 6) / n8;
        n6 = (n6 * n << 6) / n8;
        int n9 = (this._pos_x << 6) + n5 >> 6;
        int n10 = (this._pos_y << 6) + n6 >> 6;
        if (bl && Level.GetCollisionAt(n9, n10) > 10) {
            return 2;
        }
        this._pos_x = n9;
        this._pos_y = n10;
        return 0;
    }

    public byte TurnTowards(byte by, byte by2) {
        if (by2 == by) {
            return by2;
        }
        by2 = by2 > by ? (by2 - by < 7 - by2 + by ? (byte)(by2 - 1) : (byte)(by2 + 1)) : (by - by2 < 7 - by + by2 ? (byte)(by2 + 1) : (byte)(by2 - 1));
        if (by2 > 7) {
            by2 = 0;
        }
        if (by2 < 0) {
            by2 = (byte)7;
        }
        return by2;
    }

    public byte GetOrientation(int n, int n2) {
        if (Math.abs(n) >= Math.abs(n2)) {
            if (n >= 0) {
                if (Math.abs(n) >= Math.abs(n2 << 1)) {
                    return 2;
                }
                if (n2 >= 0) {
                    return 3;
                }
                return 1;
            }
            if (Math.abs(n) >= Math.abs(n2 << 1)) {
                return 6;
            }
            if (n2 >= 0) {
                return 5;
            }
            return 7;
        }
        if (n2 >= 0) {
            if (Math.abs(n2) >= Math.abs(n << 1)) {
                return 4;
            }
            if (n >= 0) {
                return 3;
            }
            return 5;
        }
        if (Math.abs(n2) >= Math.abs(n << 1)) {
            return 0;
        }
        if (n >= 0) {
            return 1;
        }
        return 7;
    }

    public void TakeDamage(int n, int n2, int n3) {
        if (n < 0 || (this._flags & 0x2000) != 0) {
            return;
        }
        switch (this._type) {
            case 5: {
                ((Unit)this).Unit_TakeDamage(n, n2, n3);
                break;
            }
            case 6: {
                ((Building)this).Building_TakeDamage(n, n2, n3);
            }
        }
    }

    Entity FindTarget(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        Entity entity;
        int n8;
        int n9 = -1;
        int n10 = -1;
        boolean bl = true;
        if (n == 2) {
            return null;
        }
        for (n8 = 0; n8 < 24; ++n8) {
            Entity entity2;
            int n11;
            if (Level._entities_usage[n8] != 1) continue;
            entity = (Unit)Level._entities[n8];
            if (entity._allegiance == n || entity._allegiance == 2 || entity._life <= 0 || (entity._flags & 0x8000) != 0 || (n11 = (n7 = Math.abs(entity._pos_x - this._pos_x)) + (n6 = Math.abs(entity._pos_y - this._pos_y))) >= n2 || !Entity.CanAttack(entity, this) || !Level.NoLineOfSightCollisionBetween(this, entity, n5, 0, 0, 0, 0) || n4 == 4 && ((entity2 = Level.GetEntitySafe(entity._targetPointer)) == null || entity2._type != 5 || ((Unit)entity2)._subtype != 4)) continue;
            int n12 = this.GetTargetScore(entity, n2, n3, n11, n5);
            if (n9 >= 0 && n12 >= n9) continue;
            n9 = n12;
            n10 = n8;
            entity._requested_action = false;
        }
        if (n4 >= 0) {
            switch (n4) {
                case 4: 
                case 5: {
                    bl = false;
                }
            }
        }
        if (bl) {
            for (n8 = 24; n8 < 48; ++n8) {
                if (Level._entities_usage[n8] != 1) continue;
                entity = (Building)Level._entities[n8];
                if (((Building)entity)._allegiance == n || ((Building)entity)._allegiance == 2 || ((Building)entity)._life <= 0 || (entity._flags & 0x8000) != 0 || (n7 = Math.abs(entity._pos_x - this._pos_x) + Math.abs(entity._pos_y - this._pos_y)) >= n2 || !Level.NoLineOfSightCollisionBetween(this, entity, 4, 0, 0, 0, 0)) continue;
                n6 = this.GetTargetScore(entity, n2, n3, n7, n5);
                if (n9 >= 0 && n6 >= n9) continue;
                n9 = n6;
                n10 = n8;
            }
        }
        if (n10 != -1) {
            return Level._entities[n10];
        }
        return null;
    }

    public static boolean CanAttack(Entity entity, Entity entity2) {
        if (entity2 == null || entity == null) {
            return false;
        }
        if (entity2._type == 6) {
            return entity._type == 5 || entity._type == 6;
        }
        if (entity2._type != 5) {
            return false;
        }
        int n = Level.GetUnitStats(((Unit)entity2)._subtype, 26);
        switch (entity._type) {
            case 5: {
                Unit unit = (Unit)entity;
                if ((unit._attack_capabilities & 0x100) != 0) {
                    return (n & 2) != 0;
                }
                return (n & 1) != 0;
            }
            case 6: {
                return (n & 2) != 0;
            }
        }
        return false;
    }

    private int GetTargetScore(Entity entity, int n, int n2, int n3, int n4) {
        Entity entity2;
        int n5 = 0;
        int n6 = 1;
        if (this._type == 5) {
            entity2 = (Unit)this;
            n5 = entity2._subtype * 11;
        } else if (this._type == 6) {
            entity2 = (Building)this;
            switch (((Building)entity2)._subtype) {
                case 5: {
                    n5 = 110;
                }
            }
        }
        switch (entity._type) {
            case 5: {
                entity2 = (Unit)entity;
                n6 = Level._attack_priorities[n5 + entity2._subtype];
                break;
            }
            case 6: {
                Building building = (Building)entity;
                switch (building._subtype) {
                    case 5: {
                        n6 = Level._attack_priorities[n5 + 10];
                    }
                }
            }
        }
        if (n3 < n2) {
            return (n2 << 6) / n6;
        }
        return (n3 << 6) / n6;
    }

    public boolean Demolish(Unit unit) {
        Building building = (Building)this;
        switch (unit._subtype) {
            case 4: {
                Level._buildings_off_times[building._allegiance][building._subtype] = (short)Level.GetBuildingStats(building._faction, building._subtype, 19);
                Level._bAreBuildingsDisabled = true;
                return true;
            }
            case 5: {
                building._life = 0;
                building.SetState(3);
                return true;
            }
        }
        return false;
    }

    public void Decorator_Init(int n, int n2, int n3, int n4, int n5, int n6) {
        this._pos_x = n;
        this._pos_y = n2;
        this._sprite = n3;
        this._crt_anim = n4;
        this._flags = n5;
        this._z_order = n6;
        this.Init2();
    }

    public void Decorator_Draw(SDKGraphics sDKGraphics) {
        int n = this._pos_x - Camera._nCamX;
        int n2 = this._pos_y - Camera._nCamY;
        if ((this._flags & 0x10000) == 0) {
            n += 0;
            n2 += 38;
        }
        GameImpl._sprites[this._sprite].DrawFrame(this._crt_anim, n, n2, this._flags & 7);
    }

    static void BULLET__() {
    }

    public void Bullet_Init(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this._z_order = 3;
        this._pos_x = n3;
        this._pos_y = n4;
        this._sdata[0] = (short)n5;
        this._sdata[1] = (short)n6;
        this._sdata[2] = (short)n;
        this._sdata[3] = (short)n2;
        this._sdata[4] = (short)n8;
        this._sdata[5] = (short)Level.GetBulletStats(n, 2);
        this._sdata[6] = (short)Level.GetBulletStats(n, 3);
        this._sdata[7] = (short)(n7 & 0xFFFF);
        this._sdata[8] = (short)(n7 >> 16);
        this._sdata[9] = (short)(n9 & 0xFFFF);
        this._sdata[10] = (short)(n9 >> 16);
        this._sdata[11] = 0;
        switch (n) {
            case 8: {
                this._sprite = 5;
                this.SetCrtAnim(2);
                this._flags &= 0xFFFFF7FF;
                break;
            }
            default: {
                this._sprite = Level.GetBulletStats(n, 4);
                this.SetCrtAnim(Level.GetBulletStats(n, 5));
            }
        }
    }

    private void Bullet_Update() {
        short s = this._sdata[2];
        boolean bl = this._sdata[11] == 1;
        switch (s) {
            case 8: {
                if (bl) break;
                this.UpdateCrtAnim();
            }
        }
        if (this.Move(this._sdata[5], false) == 1 && !bl) {
            int n;
            int n2 = Level.GetBulletStats(s, 1);
            int n3 = this._sdata[9] & 0xFFFF | this._sdata[10] << 16;
            int n4 = this._sdata[7] & 0xFFFF | this._sdata[8] << 16;
            Entity entity = Level.GetEntitySafe(n4);
            if (entity != null) {
                entity.TakeDamage(this._sdata[4], n2, n3);
            }
            if (this._sdata[6] > 0) {
                Level.DoSplashDamage(this._pos_x, this._pos_y, this._sdata[6], this._sdata[4], n2, n3);
            }
            if ((n = Level.GetBulletStats(s, 7)) >= 0) {
                Entity entity2 = Level.SpawnEntity(2);
                entity2.Decorator_Init(this._pos_x, this._pos_y, Level.GetBulletStats(s, 6), n, 512, 4);
            }
            this._sdata[11] = 1;
            bl = true;
        }
        if (!bl) {
            return;
        }
        Level.DeleteEntity(this);
    }

    private void Bullet_Draw(SDKGraphics sDKGraphics) {
        short s = this._sdata[2];
        switch (s) {
            case 0: {
                break;
            }
            case 1: 
            case 4: {
                this.DrawCrtAnim(sDKGraphics);
                break;
            }
            case 2: {
                break;
            }
            case 8: {
                int n = this._sdata[0] - this._pos_x;
                int n2 = this._sdata[1] - this._pos_y;
                byte by = this.GetOrientation(n, n2);
                sDKGraphics.setColor(0);
                sDKGraphics.drawLine(this._pos_x + 0 - Camera._nCamX, this._pos_y + 38 - Camera._nCamY, this._pos_x + 0 - Camera._nCamX + GameImpl._versorX[by] * 7, this._pos_y + 38 - Camera._nCamY + GameImpl._versorY[by] * 7);
                this.DrawCrtAnim(sDKGraphics);
            }
        }
    }

    void FireBullet(int n, int n2, int n3, int n4, int n5, int n6) {
        Entity entity = Level.GetEntitySafe(n4);
        if (entity == null) {
            return;
        }
        if (this._type == 5) {
            Level.GetUnitFiringPosition(((Unit)this)._subtype, this._orientation);
        } else if (this._type == 6) {
            Level.GetBuildingFiringPosition(((Building)this)._subtype, ((Building)this)._faction, this._orientation);
        } else {
            Level._firingOffsetX = 0;
            Level._firingOffsetY = 0;
        }
        n5 += Level._firingOffsetX;
        n6 += Level._firingOffsetY;
        if (n3 < 0) {
            n3 = Level.GetBulletStats(n2, 0);
        }
        int n7 = 0;
        block0 : switch (n2) {
            case 0: 
            case 6: {
                n7 = Level.GetBulletStats(n2, 1);
                entity.TakeDamage(n3, n7, this.GetPointer());
                Entity entity2 = Level.SpawnEntity(2);
                if (entity2 == null) break;
                entity2.Decorator_Init(entity._pos_x, entity._pos_y - 5, 5, 1, 512, 4);
                break;
            }
            case 5: {
                n7 = Level.GetBulletStats(n2, 1);
                entity.TakeDamage(n3, n7, this.GetPointer());
                break;
            }
            case 7: {
                n7 = Level.GetBulletStats(n2, 1);
                entity.TakeDamage(n3, n7, this.GetPointer());
                break;
            }
            case 2: 
            case 3: {
                n7 = Level.GetBulletStats(n2, 1);
                entity.TakeDamage(n3, n7, this.GetPointer());
                Entity entity3 = Level.SpawnEntity(104);
                if (entity3 == null) break;
                entity3.Lightning_Init(n5, n6, entity._pos_x, entity._pos_y);
                break;
            }
            case 9: {
                Unit unit = (Unit)this;
                Entity entity4 = Level.SpawnEntity(109);
                if (entity4 != null) {
                    entity4.Laser_Init(9, n5, n6, n4, false, 0, 0);
                }
                unit._gathered_damage = 0;
                entity.TakeDamage(n3 += unit._gathered_damage, n7, this.GetPointer());
                if (unit._proxyPointer == n4) break;
                int n8 = 4;
                for (int i = 0; i < 48; ++i) {
                    int n9;
                    if (Level._entities_usage[i] != 1) continue;
                    if (n8 <= 0) break block0;
                    Entity entity5 = Level.GetEntityUnsafe(i);
                    if (entity5._type == 5) {
                        Unit unit2 = (Unit)entity5;
                        if (unit2._life <= 0 || unit2._allegiance == n || unit2._allegiance == 2) {
                            continue;
                        }
                    } else if (entity5._type == 6) {
                        Building building = (Building)entity5;
                        if (building._life <= 0 || building._allegiance == n || building._allegiance == 2) continue;
                    }
                    if ((n9 = Math.abs(entity._pos_x - entity5._pos_x) + Math.abs(entity._pos_y - entity5._pos_y)) > Level.GetBulletStats(9, 3) || entity.GetPointer() == entity5.GetPointer()) continue;
                    Entity entity6 = Level.SpawnEntity(109);
                    entity6.Laser_Init(9, entity._pos_x, entity._pos_y, entity5.GetPointer(), true, 0, 0);
                    if (this._type == 5) {
                        Unit unit3 = (Unit)this;
                        if (unit3._subtype == 8) {
                            int n10 = n3 * ((Unit)this)._splash_damage / 100;
                            entity5.TakeDamage(n10, n7, this.GetPointer());
                        }
                    }
                    --n8;
                }
                break;
            }
            case 11: {
                Building building;
                Entity entity7 = Level.SpawnEntity(109);
                if (entity._type == 6 && this._type == 6) {
                    building = (Building)this;
                    Building building2 = (Building)entity;
                    if (building._subtype == 5 && building._faction == 1 && building2._subtype == 5 && building2._faction == 1 && building2._allegiance == building._allegiance) {
                        Level.GetBuildingFiringPosition(5, 1, this.GetOrientation(-building2._pos_x + building._pos_x, -building2._pos_y + building._pos_y));
                        entity7.Laser_Init(11, n5, n6, n4, false, Level._firingOffsetX, Level._firingOffsetY);
                        return;
                    }
                }
                if (this._type == 6) {
                    building = (Building)this;
                    if (building._subtype == 5 && building._faction == 1) {
                        n3 *= building._prismTowers;
                    }
                }
                entity7.Laser_Init(11, n5, n6, n4, false, 0, 0);
                entity.TakeDamage(n3, n7, this.GetPointer());
                break;
            }
            case 10: {
                Entity entity8;
                n7 = Level.GetBulletStats(n2, 1);
                entity.TakeDamage(n3, n7, this.GetPointer());
                if (entity._type == 5) {
                    ((Unit)entity)._slow_timer = (short)14;
                }
                if ((entity8 = Level.SpawnEntity(2)) == null) break;
                entity8.Decorator_Init(entity._pos_x, entity._pos_y - 5, 5, 1, 512, 4);
                break;
            }
            default: {
                Entity entity9 = Level.SpawnEntity(103);
                if (entity9 == null) break;
                entity9.Bullet_Init(n2, n, n5, n6, entity._pos_x, entity._pos_y, n4, n3, this.GetPointer());
            }
        }
    }

    static void __BULLET() {
    }

    static void LIGHTNING__() {
    }

    public void Lightning_Init(int n, int n2, int n3, int n4) {
        this._z_order = 4;
        this._pos_x = n;
        this._pos_y = n2;
        this._sdata[0] = (short)n3;
        this._sdata[1] = (short)n4;
        this._timer = 0;
    }

    private void Lightning_Update() {
        ++this._timer;
        if (this._timer > 6) {
            Level.DeleteEntity(this);
        }
    }

    private void Lightning_Draw(SDKGraphics sDKGraphics) {
        GameImpl.DrawLightningBolt(sDKGraphics, this._pos_x << 6, this._pos_y << 6, this._sdata[0] << 6, this._sdata[1] << 6, 32, 128, true, 0xFFFFFF, 0x8080FF);
    }

    static void __LIGHTNING() {
    }

    static void IGMESSAGE__() {
    }

    public void IGMessage_Init(int n, int n2, int n3, int n4, int n5, int n6) {
        this._pos_x = n2;
        this._pos_y = n3;
        this._z_order = 5;
        short[] sArray = this._sdata;
        sArray[0] = (short)n;
        sArray[1] = (short)n4;
        sArray[2] = (short)n5;
        sArray[3] = (short)n6;
        if (n == 0) {
            this._timer = 0;
        }
    }

    private void IGMessage_Update() {
        short[] sArray = this._sdata;
        int n = sArray[1];
        if (n != 32760) {
            --n;
        }
        if (n <= 0) {
            Level.DeleteEntity(this);
            return;
        }
        short s = sArray[0];
        switch (s) {
            case 0: {
                --this._timer;
                if (this._timer > 0) break;
                --this._pos_y;
                this._timer = 1;
            }
        }
        sArray[1] = (short)n;
    }

    private void IGMessage_Draw(SDKGraphics sDKGraphics) {
        short[] sArray = this._sdata;
        short s = sArray[0];
        switch (s) {
            case 0: {
                int n = SDKUtils.getLineSize();
                SDKString sDKString = SDKUtils.getString(sArray[2], GameImpl._string);
                int n2 = SDKUtils.getStringSize(sDKString) + 4;
                int n3 = n + 2;
                int n4 = 0 + this._pos_x - Camera._nCamX;
                int n5 = 38 + this._pos_y - Camera._nCamY;
                if ((sArray[3] & 4) != 0) {
                    if (n4 <= 0) {
                        n4 = n4 + n2 / 2 >= 0 ? 1 : -n2 - 4;
                    } else if (n4 + n2 + 2 >= Constants.SV_W) {
                        n4 = n4 + n2 / 2 + 2 <= Constants.SV_W ? Constants.SV_W - n2 - 2 : Constants.SV_W;
                    }
                } else if ((sArray[3] & 1) != 0) {
                    if (n4 - n2 / 2 < 0) {
                        n4 = n4 >= 0 ? n2 / 2 : -n2 - 4;
                    } else if (n4 + n2 / 2 > Constants.SV_W) {
                        n4 = n4 <= Constants.SV_W + n2 / 2 ? Constants.SV_W - n2 / 2 : Constants.SV_W + n2;
                    }
                } else if ((sArray[3] & 8) != 0) {
                    if (n4 + n2 < 0) {
                        n4 = n4 + n2 + n2 / 2 > 0 ? -n2 : -2 * n2 - 4;
                    } else if (n4 > Constants.SV_W) {
                        n4 = n4 - n2 / 2 < Constants.SV_W ? Constants.SV_W : Constants.SV_W + n2 + 2;
                    }
                }
                GameImpl.FillRect(sDKGraphics, -1610612736, n4 - (n2 >> 1), n5 - (n3 - 1), n2, n3);
                SDKUtils.drawString(sDKString, n4, n5, sArray[3]);
            }
        }
    }

    static void __IGMESSAGE() {
    }

    static void MFIELD__() {
    }

    public void MField_Init() {
        this._sprite = 1;
        this._z_order = 1;
        int n = Level.GetCMapHeaderData(16, 0);
        int n2 = Level.GetCMapHeaderData(16, 1);
        int n3 = (this._pos_x + n) / 8;
        int n4 = (this._pos_y + n2) / 8;
        this._pos_x = n3 * 8 - n;
        this._pos_y = n4 * 8 - n2;
        Level.ApplyCollisionMap(this._pos_x, this._pos_y, 16);
    }

    public void MField_Init2() {
        this.SetCrtAnim(0);
    }

    public void MField_Update() {
        this.UpdateCrtAnim();
    }

    public int MField_ExtractMoney(int n) {
        int n2 = 0;
        int n3 = this._idata[0];
        if (n3 > 0) {
            if ((n3 -= n) < 0) {
                n += n3;
                n3 = 0;
            }
            n2 = n;
        }
        this._idata[0] = n3;
        return n2;
    }

    public void MField_Draw(SDKGraphics sDKGraphics) {
        this.DrawCrtAnim(sDKGraphics);
    }

    static void __MFIELD() {
    }

    static void LASER__() {
    }

    public void Laser_Init(int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        this._z_order = 5;
        this._timer = 0;
        this._flags = 0;
        this._sdata[0] = (short)n;
        this._sdata[1] = (short)n2;
        this._sdata[2] = (short)n3;
        Entity entity = Level.GetEntitySafe(n4);
        if (entity == null) {
            Level.DeleteEntity(this);
            return;
        }
        this._sdata[3] = (short)(entity._pos_x + n5);
        this._pos_x = this._sdata[3];
        this._sdata[4] = (short)(entity._pos_y + n6);
        this._pos_y = this._sdata[4];
        this._sdata[5] = (short)(bl && n == 9 ? 1 : 0);
        if (bl && n == 9) {
            this._sprite = Level.GetBulletStats(9, 6);
            this.SetCrtAnim(Level.GetBulletStats(9, 7));
        }
    }

    public void Laser_Update() {
        boolean bl;
        boolean bl2 = bl = this._sdata[5] == 1;
        if (bl && !this.IsCrtAnimEnded()) {
            this.UpdateCrtAnim();
        }
        int n = 0;
        switch (this._sdata[0]) {
            case 9: 
            case 11: {
                n = 7;
            }
        }
        ++this._timer;
        if (this._timer >= n) {
            Level.DeleteEntity(this);
        }
    }

    public void Laser_Draw(SDKGraphics sDKGraphics) {
        int n;
        int n2;
        boolean bl;
        int n3 = this._sdata[1] + 0 - Camera._nCamX;
        int n4 = this._sdata[2] + 38 - Camera._nCamY;
        int n5 = this._sdata[3] + 0 - Camera._nCamX;
        int n6 = this._sdata[4] + 38 - Camera._nCamY;
        boolean bl2 = bl = this._sdata[5] == 1;
        if (bl && !this.IsCrtAnimEnded()) {
            this.DrawCrtAnim(sDKGraphics);
        }
        switch (this._sdata[0]) {
            case 9: {
                n2 = 0x33FFFF;
                n = 0xAAFFFF;
                break;
            }
            default: {
                n2 = 0x33FFFF;
                n = 0xAAFFFF;
            }
        }
        if (this._timer == 6) {
            sDKGraphics.setColor(n2);
            sDKGraphics.drawLine(n3, n4, n5, n6);
        } else {
            sDKGraphics.setColor(n);
            sDKGraphics.drawLine(n3, n4, n5, n6);
            sDKGraphics.setColor(n2);
            sDKGraphics.drawLine(n3 + 1, n4, n5 + 1, n6);
            sDKGraphics.drawLine(n3 - 1, n4, n5 - 1, n6);
        }
    }

    static void __LASER() {
    }

    static void NUKE__() {
    }

    public void Nuke_Init(int n, int n2, int n3) {
        this._z_order = 5;
        this._pos_x = n2;
        this._pos_y = n3;
        this._idata[0] = 0;
        this._idata[1] = 0;
        this._idata[2] = this._pos_y - 400;
        this._idata[3] = 4;
    }

    private void Nuke_Update() {
        int n = this._idata[0];
        switch (n) {
            case 0: {
                this._idata[2] = this._idata[2] + this._idata[3];
                if (this._idata[2] >= this._pos_y) {
                    this._idata[0] = 1;
                    this._idata[2] = this._pos_y;
                    this._sprite = 5;
                    this.SetCrtAnim(3);
                    this._flags |= 0x800;
                    GameImpl.Vibrate(1000);
                    int n2 = this._pos_x;
                    int n3 = this._pos_y;
                    int n4 = Level.GetSWStats(0, 4);
                    int n5 = Level.GetSWStats(0, 5);
                    int n6 = Level.GetSWStats(0, 3);
                    for (int i = 0; i < 112; ++i) {
                        int n7;
                        if (Level._entities_usage[i] != 1 || (n7 = Math.abs(Level._entities[i]._pos_x - n2) + Math.abs(Level._entities[i]._pos_y - n3)) >= n4) continue;
                        Level._entities[i].TakeDamage(n5 - n7, n6, this.GetPointer());
                    }
                    break;
                }
                this._idata[3] = this._idata[3] + 1;
                if (this._idata[3] <= 32) break;
                this._idata[3] = 32;
                break;
            }
            case 1: {
                this.UpdateCrtAnim();
                if (!this.IsCrtAnimEnded()) break;
                Level.DeleteEntity(this);
            }
        }
    }

    private void Nuke_Draw(SDKGraphics sDKGraphics) {
        int n = this._idata[0];
        switch (n) {
            case 0: {
                int n2 = this._idata[2];
                int n3 = this._pos_x;
                n3 = 0 + n3 - Camera._nCamX;
                n2 = 38 + n2 - Camera._nCamY;
                GameImpl._sprites[5].DrawFrame(16, n3, n2, 0);
                break;
            }
            case 1: {
                if (this._sprite < 0) break;
                this.DrawCrtAnim(sDKGraphics);
            }
        }
    }

    static void __NUKE() {
    }

    static void STORMBOLT__() {
    }

    public void StormBolt_Init(int n, int n2, int n3, int n4) {
        this._z_order = 4;
        this._pos_x = n3;
        this._pos_y = n4;
        this._sdata[0] = (short)n;
        this._sdata[1] = (short)n2;
        this._timer = 0;
    }

    private void StormBolt_Update() {
        ++this._timer;
        if (this._timer == 1) {
            int n = this._pos_x;
            int n2 = this._pos_y;
            int n3 = Level.GetSWStats(1, 6);
            int n4 = Level.GetSWStats(1, 5);
            int n5 = Level.GetSWStats(1, 3);
            for (int i = 0; i < 112; ++i) {
                int n6;
                if (Level._entities_usage[i] != 1 || (n6 = Math.abs(Level._entities[i]._pos_x - n) + Math.abs(Level._entities[i]._pos_y - n2)) >= n3) continue;
                Level._entities[i].TakeDamage(n4 - n6, n5, this.GetPointer());
            }
        }
        if (this._timer > 4) {
            Level.DeleteEntity(this);
        }
    }

    private void StormBolt_Draw(SDKGraphics sDKGraphics) {
        GameImpl.DrawLightningBolt(sDKGraphics, this._sdata[0] << 6, this._sdata[1] << 6, this._pos_x << 6, this._pos_y << 6, 64, 256, false, 0xFFFFFF, 0x8080FF);
    }

    static void __STORMBOLT() {
    }

    static void STORM__() {
    }

    public void Storm_Init(int n, int n2, int n3) {
        this._z_order = 5;
        this._pos_x = n2;
        this._pos_y = n3;
        this._timer = 14;
        this._state = 0;
        this._sprite = 1;
    }

    private void Storm_Update() {
        boolean bl = true;
        switch (this._state) {
            case 0: {
                --this._timer;
                if (this._timer > 0) break;
                this._state = 1;
                this._timer = 0;
                GameImpl.Vibrate(18);
                break;
            }
            case 1: {
                ++this._timer;
                int n = Level.GetSWStats(1, 4);
                int n2 = GameImpl.random(0, n) - (n >> 1);
                int n3 = GameImpl.random(0, n) - (n >> 1);
                Entity entity = Level.SpawnEntity(114);
                entity.StormBolt_Init(this._pos_x + n2, Camera._nCamY, this._pos_x + n2, this._pos_y + n3);
                if (this._timer <= 18) break;
                this._state = 2;
                this._timer = 0;
                break;
            }
            case 2: {
                --this._timer;
                if (this._timer > 0) break;
                Level.DeleteEntity(this);
                if (!Level._bCodeMovieState) break;
                Hud.SinkMovieBars();
                Hud.ChangeState(Level._hud_state_storm, true);
                Level._bCodeMovieState = false;
            }
        }
    }

    static void __STORM() {
    }

    static void UTIL_ENTITY__() {
    }

    static void Triggers_Init() {
        nrTriggers = 0;
        _triggers = new int[234];
    }

    static void Triggers_Release() {
        nrTriggers = 0;
        _triggers = null;
        System.gc();
    }

    static void Triggers_Clean() {
        int n = 0;
        for (int i = 0; i < nrTriggers; ++i) {
            Entity._triggers[n + 0] = 0;
            Entity._triggers[n + 1] = 0;
            Entity._triggers[n + 2] = 0;
            Entity._triggers[n + 3] = 0;
            Entity._triggers[n + 4] = 0;
            Entity._triggers[n + 5] = 1;
            Entity._triggers[n + 6] = 0;
            Entity._triggers[n + 7] = 0;
            Entity._triggers[n + 8] = -1;
            Entity._triggers[n + 9] = -1;
            Entity._triggers[n + 10] = -1;
            Entity._triggers[n + 11] = 1;
            Entity._triggers[n + 12] = -1;
            Entity._triggers[n + 13] = -1;
            Entity._triggers[n + 14] = -1;
            Entity._triggers[n + 15] = -1;
            Entity._triggers[n + 16] = -1;
            Entity._triggers[n + 17] = -1;
            n += 18;
        }
        nrTriggers = 0;
    }

    static void Load_Trigger(SDKInputStream sDKInputStream) throws IOException {
        short s = sDKInputStream.readShort();
        short s2 = sDKInputStream.readShort();
        short s3 = sDKInputStream.readShort();
        short s4 = sDKInputStream.readShort();
        short s5 = sDKInputStream.readShort();
        int n = sDKInputStream.read();
        int n2 = sDKInputStream.read();
        byte by = (byte)sDKInputStream.read();
        byte by2 = (byte)sDKInputStream.read();
        short s6 = sDKInputStream.readShort();
        int n3 = sDKInputStream.read();
        short s7 = sDKInputStream.readShort();
        short s8 = sDKInputStream.readShort();
        short s9 = sDKInputStream.readShort();
        short s10 = sDKInputStream.readShort();
        short s11 = sDKInputStream.readShort();
        short s12 = sDKInputStream.readShort();
        if (nrTriggers >= 13) {
            return;
        }
        int n4 = nrTriggers * 18;
        Entity._triggers[n4 + 0] = s2;
        Entity._triggers[n4 + 1] = s3;
        Entity._triggers[n4 + 2] = s2 + s4;
        Entity._triggers[n4 + 3] = s3 + s5;
        Entity._triggers[n4 + 4] = s;
        Entity._triggers[n4 + 5] = n;
        Entity._triggers[n4 + 6] = 0;
        Entity._triggers[n4 + 7] = n2;
        Entity._triggers[n4 + 8] = by;
        Entity._triggers[n4 + 9] = by2;
        Entity._triggers[n4 + 10] = s6;
        Entity._triggers[n4 + 11] = n3;
        Entity._triggers[n4 + 12] = s7;
        Entity._triggers[n4 + 13] = s9;
        Entity._triggers[n4 + 14] = s10;
        Entity._triggers[n4 + 15] = s11;
        Entity._triggers[n4 + 16] = s12;
        Entity._triggers[n4 + 17] = s8;
        ++nrTriggers;
    }

    static boolean IsTriggerUnit(int n, Unit unit) {
        if (_triggers[n + 10] != -1 && unit._id != _triggers[n + 10]) {
            return false;
        }
        if (_triggers[n + 8] != -1 && unit._subtype != _triggers[n + 8]) {
            return false;
        }
        return _triggers[n + 9] == -1 || unit._allegiance == _triggers[n + 9];
    }

    static boolean IsUnitInTrigger(int n, Unit unit, int n2, int n3) {
        return n2 >= _triggers[n + 0] && n3 >= _triggers[n + 1] && n2 <= _triggers[n + 2] && n3 <= _triggers[n + 3];
    }

    static void CheckTrigger(int n, Unit unit, int n2, int n3) {
        if (Entity.IsTriggerUnit(n, unit)) {
            if (Entity.IsUnitInTrigger(n, unit, unit._pos_x, unit._pos_y) && unit._life > 0) {
                if (!Entity.IsUnitInTrigger(n, unit, n2, n3)) {
                    int n4 = n + 6;
                    _triggers[n4] = _triggers[n4] + 1;
                }
            } else if (Entity.IsUnitInTrigger(n, unit, n2, n3)) {
                int n5 = n + 6;
                _triggers[n5] = _triggers[n5] - 1;
            }
        }
    }

    static void CheckTriggers(Unit unit, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < nrTriggers; ++i) {
            Entity.CheckTrigger(n3, unit, n, n2);
            n3 += 18;
        }
    }

    static void Update_Triggers() {
        int n = 0;
        for (int i = 0; i < nrTriggers; ++i) {
            int n2 = _triggers[n + 5];
            switch (n2) {
                case 0: {
                    if (_triggers[n + 6] >= _triggers[n + 11]) break;
                    Entity._triggers[n + 5] = 1;
                    break;
                }
                case 1: {
                    if (_triggers[n + 6] < _triggers[n + 11]) break;
                    if (_triggers[n + 17] > 0) {
                        for (int j = 0; j < 24; ++j) {
                            Unit unit;
                            if (Level._entities_usage[j] != 1 || !Entity.IsTriggerUnit(n, unit = (Unit)Level._entities[j]) || !Entity.IsUnitInTrigger(n, unit, unit._pos_x, unit._pos_y) || unit._id > 0) continue;
                            unit._id = _triggers[n + 17];
                            break;
                        }
                    }
                    if (_triggers[n + 12] >= 0) {
                        Script.StartScript(_triggers[n + 12], _triggers[n + 13], _triggers[n + 14], _triggers[n + 15], _triggers[n + 16]);
                    }
                    Entity._triggers[n + 5] = _triggers[n + 7] > 0 ? 2 : 0;
                }
            }
            n += 18;
        }
    }

    static void Draw_Triggers(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(0xFF0000);
        int n = 0;
        for (int i = 0; i < nrTriggers; ++i) {
            int n2 = 0 + _triggers[n + 0] - Camera._nCamX;
            int n3 = 38 + _triggers[n + 1] - Camera._nCamY;
            int n4 = _triggers[n + 2] - _triggers[n + 0];
            int n5 = _triggers[n + 3] - _triggers[n + 1];
            sDKGraphics.drawRect(n2, n3, n4, n5);
            n += 18;
        }
    }

    static void WayPoints_Init() {
        nrWayPoints = 0;
        _wayPoints = new short[320];
    }

    static void WayPoints_Release() {
        nrWayPoints = 0;
        _wayPoints = null;
        System.gc();
    }

    static void WayPoints_Clean() {
        int n = 0;
        for (int i = 0; i < nrWayPoints; ++i) {
            Entity._wayPoints[n + 0] = -1;
            Entity._wayPoints[n + 1] = -1;
            Entity._wayPoints[n + 2] = -1;
            Entity._wayPoints[n + 3] = -1;
            Entity._wayPoints[n + 4] = 0;
            n += 5;
        }
        nrWayPoints = 0;
    }

    static void Load_WayPoint(SDKInputStream sDKInputStream) throws IOException {
        short s = sDKInputStream.readShort();
        short s2 = sDKInputStream.readShort();
        short s3 = sDKInputStream.readShort();
        short s4 = sDKInputStream.readShort();
        short s5 = sDKInputStream.readShort();
        if (nrWayPoints >= 64) {
            return;
        }
        int n = nrWayPoints * 5;
        Entity._wayPoints[n + 0] = s;
        Entity._wayPoints[n + 1] = s2;
        Entity._wayPoints[n + 2] = s3;
        Entity._wayPoints[n + 3] = s4;
        Entity._wayPoints[n + 4] = s5;
        ++nrWayPoints;
    }

    static int Get_WayPoint(int n) {
        int n2 = 0;
        for (int i = 0; i < nrWayPoints; ++i) {
            if (_wayPoints[n2 + 0] == n) {
                return n2;
            }
            n2 += 5;
        }
        return -1;
    }

    static void BuildSpots_Init() {
        nrBuildSpots = 0;
        _buildSpots = new short[128];
    }

    static void BuildSpots_Release() {
        nrBuildSpots = 0;
        _buildSpots = null;
        System.gc();
    }

    static void BuildSpots_Clean() {
        int n = 0;
        for (int i = 0; i < nrBuildSpots; ++i) {
            Entity._buildSpots[n + 0] = -1;
            Entity._buildSpots[n + 1] = -1;
            Entity._buildSpots[n + 2] = -1;
            Entity._buildSpots[n + 3] = -1;
            n += 4;
        }
        nrBuildSpots = 0;
    }

    static void Load_BuildSpot(SDKInputStream sDKInputStream) throws IOException {
        short s = sDKInputStream.readShort();
        short s2 = sDKInputStream.readShort();
        short s3 = sDKInputStream.readShort();
        short s4 = (short)sDKInputStream.read();
        if (nrBuildSpots >= 32) {
            return;
        }
        int n = nrBuildSpots * 4;
        Entity._buildSpots[n + 0] = s;
        Entity._buildSpots[n + 1] = s2;
        Entity._buildSpots[n + 2] = s3;
        Entity._buildSpots[n + 3] = s4;
        ++nrBuildSpots;
    }

    static int Get_BuildSpot(int n) {
        int n2 = 0;
        for (int i = 0; i < nrBuildSpots; ++i) {
            if (_buildSpots[n2 + 0] == n) {
                return n2;
            }
            n2 += 4;
        }
        return -1;
    }

    static int FindBuildSpot(int n, int n2, int n3, boolean bl) {
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        for (int i = 0; i < nrBuildSpots; ++i) {
            int n7 = Entity.BuildSpotScore(n6, n, n2, n3, bl);
            if (n7 >= 0 && (n4 < 0 || n7 < n4)) {
                n4 = n7;
                n5 = n6;
            }
            n6 += 4;
        }
        return n5;
    }

    static int BuildSpotScore(int n, int n2, int n3, int n4, boolean bl) {
        short s = _buildSpots[n + 3];
        if (bl && s != n2) {
            return -1;
        }
        if (!Script.IsValidBuildingPosition(n2, _buildSpots[n + 1], _buildSpots[n + 2])) {
            return -1;
        }
        int n5 = Math.abs(n3 - _buildSpots[n + 1]) + Math.abs(n4 - _buildSpots[n + 2]);
        return n5;
    }

    static void __UTIL_ENTITY() {
    }

    static {
        _txtDescrStringLines = new short[100];
    }
}

