/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Building;
import com.ea.game.BuildingConstants;
import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Debug;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.GraphicsConstants;
import com.ea.game.Hud;
import com.ea.game.PathfinderConstants;
import com.ea.game.Region;
import com.ea.game.Script;
import com.ea.game.Unit;
import com.ea.game.UnitsConstants;
import com.ea.game.XSprite;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKUtils;
import java.io.IOException;

public class Level
implements Constants,
GraphicsConstants,
BuildingConstants,
UnitsConstants,
PathfinderConstants {
    public static final short[] _levels = new short[]{73, 76, 79, 82, 85, 88, 91, 94, 97, 100, 103, 106};
    public static final short[] _level_maps = new short[]{71, 74, 77, 80, 83, 86, 89, 92, 95, 98, 101, 104};
    public static final short[] _level_coll = new short[]{72, 75, 78, 81, 84, 87, 90, 93, 96, 99, 102, 105};
    public static int _crt_level = -1;
    static int _player_faction;
    static int _ai_faction;
    public static int _player_sk_faction;
    public static int _ai_sk_faction;
    public static boolean _b_skirmish;
    static int _player_power;
    static int _player_consumption;
    static int _player_money;
    static int _player_command_points;
    static int _player_max_command_points;
    static int _player_build_points;
    static int _player_max_build_points;
    static int _ai_power;
    static int _ai_consumption;
    static int _ai_money;
    static int _ai_command_points;
    static int _ai_max_command_points;
    static int _ai_build_points;
    static int _ai_max_build_points;
    public static int _buildings_restricted;
    public static int _units_restricted;
    public static int _sw_restricted;
    static int _currentGroup;
    static int[] _groupLeaders;
    static int _level_timer;
    static long _last_time;
    static int _timeline_counter;
    static int _paused;
    static int _old_paused;
    static boolean _enableChangeSK;
    static boolean _enableSelectionChange;
    public static int[] _statistics;
    public static boolean _bAreBuildingsDisabled;
    static boolean _attackSoundPlayed;
    static int _firstAttackFrame;
    static int _lastAttackSoundFrame;
    static Entity[] _entities;
    static byte[] _entities_usage;
    public static int[] _entities_no;
    public static short[][] _buildings_off_times;
    static int _lastSpawnedIndex;
    static byte[] _fixed_ent_data;
    static short[] _fixed_ent_list;
    static int _fixedListPointer;
    static int _fixedDataPointer;
    static int _nrFixedLevelEntities;
    static int _lastCellOffset;
    static int _nClipCellX;
    static int _nClipCellY;
    static int _nClipCellX2;
    static int _nClipCellY2;
    static int[] _fixed_w_array;
    static int[] _fixed_clip_array;
    static int _fixed_clip_count;
    static int[] _dynamic_w_array;
    static int[] _dynamic_entities_clip;
    static int _dynamic_entities_clip_count;
    static short[] _building_stats_allied;
    static short[] _building_stats_soviets;
    static byte[] _bullet_stats;
    static short[] _unit_stats;
    static byte[] _attack_priorities;
    static byte[] _firing_positions;
    static short[] _sw_stats;
    static short[] _level_stats;
    static int[][] _hud_colors;
    static int _firingOffsetX;
    static int _firingOffsetY;
    static short[] _cmaps_header;
    static byte[][] _cmaps;
    static int _gravity_center_X;
    static int _gravity_center_Y;
    public static boolean _bCodeMovieState;
    public static int _hud_state_storm;
    public static int _nrTiles;
    public static short[] _tilePalette;
    public static byte[] _map;
    public static int _map_tw;
    public static int _map_th;
    public static int _map_size;
    public static int _map_w;
    public static int _map_h;
    public static int _map_vcell_w;
    public static int _map_vcell_h;
    public static byte[] _coll_map;
    public static int _coll_map_tw;
    public static int _coll_map_th;
    public static int _coll_map_size;
    public static int _currentTileSet;
    static int _validTileX;
    static int _validTileY;
    static int[] _xx;
    static int[] _yy;
    static int[] _invalidator_rect;
    static boolean _bInvalidatorCDB;
    public static SDKImage _imgBB;
    public static SDKGraphics _gBB;
    public static SDKGraphics _g;
    public static boolean _bResetCDB;
    public static int _CDB_view_tx;
    public static int _CDB_view_ty;
    public static int _CDB_orig_tx;
    public static int _CDB_orig_ty;
    public static int _CDB_xo;
    public static int _CDB_yo;
    public static int _CDB_oldX;
    public static int _CDB_oldY;
    public static int _CDB_x;
    public static int _CDB_y;
    public static int _CDB_w;
    public static int _CDB_h;
    public static int _CDB_nrRegions;
    public static Region[] _CDB_regions;
    public static int _CDB_separator;
    static short[] _tasks_data;
    static int _tasks_current;
    static int _tasks_last;
    static byte[][] _results_data;
    static byte[] _cache_result;
    static int _cache_result_count;
    public static boolean _bAStarThreadRunning;
    public static boolean _bAStarSignalStop;
    public static short[] _node_data_list;
    public static int _node_data_list_count;
    public static short[] _open_list;
    public static int _open_list_count;
    public static int _start_tileX;
    public static int _start_tileY;
    public static int _start_tileIndex;
    public static int _finish_tileX;
    public static int _finish_tileY;
    public static int _finish_tileIndex;
    public static int _cache_start_tileX;
    public static int _cache_start_tileY;
    public static int _cache_finish_tileX;
    public static int _cache_finish_tileY;
    public static int _frames_left_per_task;
    static short[] _regions;
    static int _regions_count;

    static void InitLevel() {
        Level.CDB_Invalidator_Init();
        Hud.Init();
        _entities_no = new int[54];
        _buildings_off_times = new short[3][8];
    }

    static void ClearLevel() {
        Script.AI_Clean();
        Level.ClearOffTimes();
        Level.ClearTileMap();
        Level.ClearCollisionMap();
        GameImpl.Clear_Fade();
        _units_restricted = 0;
        _buildings_restricted = 0;
        _sw_restricted = 0;
        Hud.Reset();
        Level.ClearEntities();
        Entity.Triggers_Clean();
        Entity.WayPoints_Clean();
        Entity.BuildSpots_Clean();
        Script.Scripts_Clean();
        GameImpl.Tutorials_Clean();
        GameImpl.SnowClean();
    }

    static void ClearOffTimes() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 8; ++j) {
                Level._buildings_off_times[i][j] = 0;
            }
        }
        _bAreBuildingsDisabled = false;
    }

    static void ClearStatistics() {
        for (int i = 0; i < 8; ++i) {
            Level._statistics[i] = 0;
        }
    }

    static void UpdateOffTimes() {
        if (_bAreBuildingsDisabled) {
            _bAreBuildingsDisabled = false;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 8; ++j) {
                    if (_buildings_off_times[i][j] <= 0) continue;
                    short[] sArray = _buildings_off_times[i];
                    int n = j;
                    sArray[n] = (short)(sArray[n] - 1);
                    _bAreBuildingsDisabled = true;
                }
            }
        }
    }

    static void LoadLevel(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 == 0) {
            int n6;
            if (n < 0 || n >= 13) {
                _crt_level = -1;
                return;
            }
            _last_time = GameImpl._canvas.getAppTime();
            _level_timer = 0;
            _timeline_counter = 0;
            Level.ClearLevel();
            Level.ClearStatistics();
            GameImpl.DisableCheat(2);
            GameImpl.DisableCheat(1);
            GameImpl.DisableCheat(4);
            Level.LoadTileMap(_level_maps[n]);
            Level.LoadCollisionMap(_level_coll[n]);
            _enableChangeSK = true;
            _enableSelectionChange = true;
            _player_faction = Level.GetLevelStats(n, 0);
            _ai_faction = Level.GetLevelStats(n, 1);
            if (_b_skirmish) {
                if (_player_sk_faction == 2) {
                    _player_faction = 0 + GameImpl.randomInt() % 2;
                    _ai_faction = 1 - _player_faction;
                    XSprite xSprite = GameImpl._sprites[4];
                    if (xSprite != null) {
                        xSprite.Release();
                    }
                } else {
                    _player_faction = _player_sk_faction;
                    _ai_faction = _ai_sk_faction;
                }
            }
            Hud._current_hud_colors = _hud_colors[_player_faction];
            _currentGroup = 0;
            for (n6 = 0; n6 < 54; ++n6) {
                Level._entities_no[n6] = 0;
            }
            Level.Groups_Init();
            _player_power = 0;
            _player_consumption = 0;
            _ai_power = 0;
            _ai_consumption = 0;
            _player_money = Level.GetLevelStats(n, 2);
            _ai_money = Level.GetLevelStats(n, 3);
            _player_command_points = 0;
            _player_build_points = 0;
            _ai_command_points = 0;
            _ai_build_points = 0;
            _player_max_command_points = Level.GetLevelStats(n, 4);
            _ai_max_command_points = Level.GetLevelStats(n, 5);
            _player_max_build_points = Level.GetLevelStats(n, 6);
            _ai_max_build_points = Level.GetLevelStats(n, 7);
            _buildings_restricted = Level.GetLevelStats(n, 13) & 0xFFFF;
            _units_restricted = Level.GetLevelStats(n, 14) & 0xFFFF;
            _sw_restricted = Level.GetLevelStats(n, 15) & 0xFFFF;
            Level.Init();
            Level.LoadEntities(_levels[n]);
            SDKInputStream.purgeCache();
            System.gc();
            if (_b_skirmish) {
                for (n6 = 24; n6 < 48; ++n6) {
                    if (_entities_usage[n6] != 1) continue;
                    Building building = (Building)_entities[n6];
                    if (building._allegiance == 0) {
                        building._faction = (byte)_player_faction;
                    }
                    if (building._allegiance != 1) continue;
                    building._faction = (byte)_ai_faction;
                }
            }
            for (n6 = 0; n6 < 112; ++n6) {
                if (_entities_usage[n6] != 1) continue;
                _entities[n6].Init();
            }
            GameImpl._loadingStatus = 1;
            GameImpl.MarkSprites();
            return;
        }
        if (n2 < 8) {
            GameImpl.LoadSprites();
            ++GameImpl._loadingStatus;
            return;
        }
        if (n2 == 8) {
            if (_b_skirmish) {
                n5 = Level.GetLevelStats(_crt_level, 16);
                if (n5 != -1) {
                    SDKUtils.loadStringsChunk(n5);
                }
                Script.Scripts_Release();
                Script.Scripts_Init(_crt_level);
                n4 = Script._last_script_file - Script._first_script_file;
                for (n3 = 0; n3 <= n4; ++n3) {
                    Script.LoadScripts(n3);
                }
            }
            ++GameImpl._loadingStatus;
        }
        if (n2 == 9) {
            for (n5 = 0; n5 < 112; ++n5) {
                if (_entities_usage[n5] != 1) continue;
                _entities[n5].Init2();
            }
            Script._AI_defend = true;
            Script._AI_run_script = true;
            Camera.ResetCamera();
            Script.StartScript(Level.GetLevelStats(n, 8), 0, 0, 0, 0);
            n5 = Level.GetLevelStats(n, 9);
            if (_b_skirmish) {
                n4 = GameImpl.randomInt();
                n5 = _ai_faction == 0 ? (n4 % 2 == 0 ? (n5 += 0) : ++n5) : (n4 % 2 == 0 ? (n5 += 2) : (n5 += 3));
            }
            Script._AI_script_instance = Script.StartAIScript(n5, 0, 0, 0, 0);
            _crt_level = n;
            _bResetCDB = true;
            Camera.InitCursor();
            Camera.SetState(0);
            if (Level.Group_GetLeader(1) != -1) {
                _currentGroup = 1;
            } else if (Level.Group_GetLeader(2) != -1) {
                _currentGroup = 2;
            }
            Unit unit = (Unit)Level.GetEntitySafe(Level.Group_GetLeader(_currentGroup));
            if (unit != null) {
                n3 = unit._pos_x - (Constants.SV_W >> 1);
                int n7 = unit._pos_y - (Constants.SV_H >> 1);
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n3 > _map_w - Constants.SV_W) {
                    n3 = _map_w - Constants.SV_W;
                }
                if (n7 < 0) {
                    n7 = 0;
                }
                if (n7 > _map_h - Constants.SV_H) {
                    n7 = _map_h - Constants.SV_H;
                }
                Camera.DoScroll(n3, n7);
                Camera._nCamX = n3;
                Camera._nCamY = n7;
                int n8 = Camera._nCursorPosX - n3;
                int n9 = Camera._nCursorPosY - n7;
                Camera._nCursorPosX = Camera._nCamX + n8;
                Camera._nCursorPosY = Camera._nCamX + n9;
                Camera.SelectCurrentGroup();
                SDKCanvas.disableInput(1);
            }
            if (_b_skirmish) {
                GameImpl.Fade(true, 0, true);
                GameImpl.Fade(false, 10, true);
            }
            GameImpl._loadingStatus = 10;
        }
        Hud._minimap_state = Level.GetEntityNo(6, 7, 0) > 0 ? 1 : 4;
    }

    static void LoadEntities(int n) {
        try {
            int n2 = _map_vcell_w * _map_vcell_h;
            _fixed_ent_data = new byte[2000];
            _fixed_ent_list = new short[(n2 * 2 + 400) * 2];
            GameImpl.MemSet(_fixed_ent_list, (short)-1);
            _fixedDataPointer = 0;
            _fixedListPointer = n2 * 2;
            SDKInputStream sDKInputStream = null;
            try {
                sDKInputStream = new SDKInputStream(n);
                block10: while (sDKInputStream.available() > 0) {
                    int n3 = sDKInputStream.read() & 0xFF;
                    if (Level.IsFixedEntity(n3)) {
                        Level.LoadFixedEntity(sDKInputStream, n3);
                        ++_nrFixedLevelEntities;
                        continue;
                    }
                    switch (n3) {
                        case 108: {
                            Entity.Load_Trigger(sDKInputStream);
                            continue block10;
                        }
                        case 4: {
                            Entity.Load_WayPoint(sDKInputStream);
                            continue block10;
                        }
                        case 12: {
                            Entity.Load_BuildSpot(sDKInputStream);
                            continue block10;
                        }
                        case 116: {
                            Level.Region_Load(sDKInputStream);
                            continue block10;
                        }
                    }
                    Entity entity = Level.SpawnEntity(n3);
                    entity.Load(sDKInputStream);
                }
            }
            catch (Exception exception) {
                Debug.CatchException("Exception on LoadEntities:", exception);
            }
            sDKInputStream.close();
            sDKInputStream = null;
            System.gc();
        }
        catch (Exception exception) {
            Debug.CatchException("Exception on LoadEntities:", exception);
        }
    }

    static void UpdateLevel() {
        long l = GameImpl._canvas.getAppTime();
        _level_timer = (int)((long)_level_timer + (l - _last_time));
        _last_time = l;
        try {
            Hud.Update();
            GameImpl.Tutorials_Update();
            Script.AI_Update();
            Camera.UpdateCamera();
            if (_paused == 0) {
                Level.UpdateEntities();
                Level.UpdateOffTimes();
                ++_timeline_counter;
            }
            Entity.Update_Triggers();
            Script.RunEngine();
            Level.Update();
            GameImpl.SnowUpdate();
            GameImpl.Update_Fade();
        }
        catch (Exception exception) {
            Debug.CatchException("Level update", exception);
        }
    }

    static void UpdateEntities() {
        for (int i = 0; i < 112; ++i) {
            if (_entities_usage[i] != 1) continue;
            _entities[i].Update();
        }
    }

    static void DrawLevel(SDKGraphics sDKGraphics) {
        try {
            Level.CDB_Update();
            Level.CDB_Invalidator_Update();
            sDKGraphics.setClip(0, 38, Constants.SV_W, Constants.SV_H);
            Level.CDB_Draw(sDKGraphics);
            sDKGraphics.setClip(0, 38, Constants.SV_W, Constants.SV_H);
            if (Hud._hud_state == 2 && Hud._hud_substate == 2) {
                Hud.Build_Draw_CreepOverlay(sDKGraphics);
            }
            sDKGraphics.setClip(0, 38, Constants.SV_W, Constants.SV_H);
            Level.DrawEntities(sDKGraphics);
            GameImpl.SnowDraw(sDKGraphics);
            Entity entity = Level.GetEntitySafe(Camera._targetPointer);
            if (entity != null) {
                entity.DrawTooltip(sDKGraphics);
            }
            sDKGraphics.setClip(0, 0, Constants.SCR_W, Constants.SCR_H);
            if (GameImpl._gameState == 5) {
                Hud.Draw(sDKGraphics);
            }
            GameImpl.Draw_Fade(sDKGraphics);
        }
        catch (Exception exception) {
            Debug.CatchException("Level paint", exception);
        }
    }

    static void DrawEntities(SDKGraphics sDKGraphics) {
        int n;
        XSprite.SetGraphics(sDKGraphics);
        Level.SetEntityClipWithBorder(Camera._nCamX, Camera._nCamY, Constants.SV_W, Constants.SV_H);
        Level.ResetFixedEntitiesClipList();
        Level.FindFixedEntitiesInClip(false);
        GameImpl.QuickSort(_fixed_w_array, _fixed_clip_array, 0, _fixed_clip_count - 1);
        Level.ResetDynamicEntitiesClipList();
        Level.FindDynamicEntitiesInClip();
        GameImpl.QuickSort(_dynamic_w_array, _dynamic_entities_clip, 0, _dynamic_entities_clip_count - 1);
        int n2 = 0;
        int n3 = 0;
        while (_fixed_clip_count > 0 && _dynamic_entities_clip_count > 0) {
            if ((_fixed_w_array[n2] & 0xFFFFFFFF) < (_dynamic_w_array[n3] & 0xFFFFFFFF)) {
                Level.DrawFixedEntityFromPackedValue(sDKGraphics, _fixed_clip_array[n2], true);
                ++n2;
                --_fixed_clip_count;
                continue;
            }
            _entities[_dynamic_entities_clip[n3]].Draw(sDKGraphics);
            ++n3;
            --_dynamic_entities_clip_count;
        }
        while (_fixed_clip_count > 0) {
            Level.DrawFixedEntityFromPackedValue(sDKGraphics, _fixed_clip_array[n2], true);
            ++n2;
            --_fixed_clip_count;
        }
        while (_dynamic_entities_clip_count > 0) {
            _entities[_dynamic_entities_clip[n3]].Draw(sDKGraphics);
            ++n3;
            --_dynamic_entities_clip_count;
        }
        XSprite.SetGraphics(sDKGraphics);
        for (n = 24; n < 48; ++n) {
            if (_entities_usage[n] != 1) continue;
            ((Building)_entities[n]).Building_DrawDetails(sDKGraphics);
        }
        for (n = 0; n < 24; ++n) {
            if (_entities_usage[n] != 1) continue;
            Entity entity = _entities[n];
            if (entity._type != 5) continue;
            ((Unit)entity).Unit_Draw_Lines(sDKGraphics);
        }
    }

    static void DrawCDBEntities(SDKGraphics sDKGraphics) {
        Level.ResetFixedEntitiesClipList();
        Level.FindFixedEntitiesInClip(true);
        GameImpl.QuickSort(_fixed_w_array, _fixed_clip_array, 0, _fixed_clip_count - 1);
        for (int i = 0; i < _fixed_clip_count; ++i) {
            Level.DrawFixedEntityFromPackedValue(null, _fixed_clip_array[i], false);
        }
    }

    static void GROUP_MANAGEMENT__() {
    }

    public static void Groups_Init() {
        for (int i = 0; i < 3; ++i) {
            Level._groupLeaders[i] = -1;
        }
    }

    public static void Group_Add(Unit unit, int n) {
        if (unit._allegiance != 0) {
            return;
        }
        unit._group = (byte)n;
        if (n != -1 && n != 0) {
            if (_groupLeaders[n] == -1) {
                Level._groupLeaders[n] = unit.GetPointer();
            }
            if (_currentGroup == n) {
                unit._bSelected = true;
            }
        }
    }

    public static void Group_Remove(Unit unit) {
        if (unit._allegiance != 0) {
            return;
        }
        int n = -1;
        if (unit._group != 0 && _groupLeaders[unit._group] == unit.GetPointer()) {
            n = unit._group;
            Level._groupLeaders[unit._group] = -1;
        }
        if (_currentGroup == unit._group) {
            unit._bSelected = false;
        }
        unit._group = 0;
        if (n != -1) {
            Level.Group_FindNewLeader(n);
        }
    }

    public static void Group_SetToSelection(int n) {
        int n2 = -1;
        for (int i = 0; i < 24; ++i) {
            if (_entities_usage[i] != 1) continue;
            Unit unit = (Unit)_entities[i];
            if (!unit._bSelected) continue;
            if (n != unit._group && unit.GetPointer() == _groupLeaders[unit._group]) {
                n2 = unit._group;
                Level._groupLeaders[unit._group] = -1;
            }
            Level.Group_Add(unit, n);
        }
        if (n2 != -1) {
            Level.Group_FindNewLeader(n2);
        }
    }

    public static void Group_Clear(int n) {
        if (n == 0) {
            return;
        }
        for (int i = 0; i < 24; ++i) {
            if (_entities_usage[i] != 1) continue;
            Unit unit = (Unit)_entities[i];
            if (unit._group != n) continue;
            unit._group = 0;
        }
        Level._groupLeaders[n] = -1;
    }

    public static boolean Group_Select(int n) {
        if (n == 0 || n == -1) {
            _currentGroup = 0;
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < 24; ++i) {
            if (_entities_usage[i] != 1) continue;
            Unit unit = (Unit)_entities[i];
            if (unit._group == n && unit._allegiance == 0 && (unit._flags & 0x400) == 0) {
                unit._bSelected = true;
                bl = true;
                continue;
            }
            unit._bSelected = false;
        }
        _currentGroup = n;
        return bl;
    }

    static int Group_GetLeader(int n) {
        if (n == -1 || n == 0) {
            return -1;
        }
        return _groupLeaders[n];
    }

    static void Group_FindNewLeader(int n) {
        Level._groupLeaders[n] = -1;
        for (int i = 0; i < 24; ++i) {
            if (_entities_usage[i] != 1) continue;
            Unit unit = (Unit)_entities[i];
            if (unit._group != n || unit._allegiance != 0 || unit._life <= 0) continue;
            Level._groupLeaders[n] = unit.GetPointer();
            break;
        }
        if (_groupLeaders[n] == -1 && _currentGroup == n) {
            _currentGroup = 0;
        }
    }

    static void __GROUP_MANAGEMENT() {
    }

    static void SPAWNING__() {
    }

    static Unit SpawnUnit(int n, int n2, int n3, int n4, int n5, byte by) {
        Unit unit = (Unit)Level.SpawnEntity(5);
        if (unit != null) {
            unit._subtype = (byte)n;
            unit._allegiance = (byte)n4;
            unit.SetPosition(n2, n3);
            unit._orientation = (byte)n5;
            unit._group = by;
            unit._veterancy_lvl = 0;
            unit.Unit_Init();
            unit.Unit_Init2();
            unit.DoAction(2, -1, n2, n3);
            if ((by == 1 || by == 2) && n4 == 0) {
                Unit unit2 = (Unit)Level.GetEntitySafe(Level.Group_GetLeader(by));
                if (unit2 == null) {
                    Level._groupLeaders[by] = unit.GetPointer();
                    unit2 = unit;
                }
                if (unit2 != unit) {
                    int n6 = unit2._pos_x;
                    int n7 = unit2._pos_y;
                    if (unit2._path_cursor > 0) {
                        n6 = unit2._waypoints[0] * 8;
                        n7 = unit2._waypoints[1] * 8;
                    }
                    unit.DoAction(2, -1, n6, n7);
                }
            }
        }
        return unit;
    }

    static Building SpawnBuilding(int n, int n2, int n3, int n4, int n5) {
        Building building = (Building)Level.SpawnEntity(6);
        if (building != null) {
            building._subtype = (byte)n;
            building.SetPosition(n2, n3);
            building._allegiance = (byte)n4;
            building._faction = (byte)n5;
            building.Building_Init();
            building.Building_Init2();
            Level.CDB_AddInvalidateRegion(building._collisionBox);
            int n6 = 0;
            if (_player_faction == 1) {
                n6 = 8;
            }
            byte[] byArray = Level.GetCMap(n6 + n);
            int n7 = Level.GetCMapHeaderData(n6 + n, 0);
            int n8 = Level.GetCMapHeaderData(n6 + n, 1);
            int n9 = Level.GetCMapHeaderData(n6 + n, 2);
            int n10 = Level.GetCMapHeaderData(n6 + n, 3);
            int n11 = (n2 + n7) / 8;
            int n12 = (n3 + n8) / 8;
            int n13 = 0;
            for (n3 = 0; n3 < n10; ++n3) {
                n2 = 0;
                while (n2 < n9) {
                    if (byArray[n13] == 12) {
                        int n14 = (n11 + n2) * 8;
                        int n15 = (n12 + n3) * 8;
                        for (int i = 0; i < 24; ++i) {
                            if (_entities_usage[i] != 1) continue;
                            Unit unit = (Unit)_entities[i];
                            if (unit._life <= 0 || unit._pos_x <= n14 - 8 || unit._pos_x >= n14 + 8 + 8 || unit._pos_y <= n15 - 8 || unit._pos_y >= n15 + 8 + 8) continue;
                            unit.Unit_Jump_From_Collision();
                        }
                    }
                    ++n2;
                    ++n13;
                }
            }
        }
        return building;
    }

    static Entity SpawnIGMessage(int n, int n2, int n3, int n4, int n5, int n6) {
        Entity entity = Level.SpawnEntity(105);
        if (entity != null) {
            entity.IGMessage_Init(n, n2, n3, n4, n5, n6);
        }
        return entity;
    }

    static Building FindSpawnBuilding(int n, int n2) {
        for (int i = 24; i < 48; ++i) {
            if (_entities_usage[i] != 1) continue;
            Building building = (Building)_entities[i];
            if (building._allegiance != n2 || (building._spawn_unit_types & 1 << n) == 0) continue;
            return building;
        }
        return null;
    }

    static void __SPAWNING() {
    }

    static void Debug_DrawCollisionMapLayer(SDKGraphics sDKGraphics) {
        int n = Camera._nCamX / 8;
        int n2 = Camera._nCamY / 8;
        int n3 = (Camera._nCamX + Constants.SV_W + 7) / 8;
        int n4 = (Camera._nCamY + Constants.SV_H + 7) / 8;
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                int n5 = Level.GetCollisionAt(j * 8, i * 8);
                int n6 = 0;
                if (n5 == 0) {
                    n6 = 0x3300FF00;
                } else if (n5 == 1) {
                    n6 = 0x33FF0000;
                } else if (n5 == 2) {
                    n6 = 0x330000FF;
                } else if (n5 == 3) {
                    n6 = 0x33FF00FF;
                }
                GameImpl.FillRect(sDKGraphics, n6, j * 8 - Camera._nCamX, i * 8 - Camera._nCamY, 8, 8);
            }
        }
    }

    static void ENTITIES__() {
    }

    static void InitEntities() {
        _entities_usage = new byte[112];
        _entities = new Entity[112];
        int n = 0;
        for (n = 0; n < 24; ++n) {
            Level._entities[n] = new Unit(n);
            Level._entities_usage[n] = 0;
        }
        for (n = 24; n < 48; ++n) {
            Level._entities[n] = new Building(n);
            Level._entities_usage[n] = 0;
        }
        for (n = 48; n < 112; ++n) {
            Level._entities[n] = new Entity(n);
            Level._entities_usage[n] = 0;
        }
    }

    static void ReleaseEntities() {
        _entities_usage = null;
        for (int i = 0; i < 112; ++i) {
            Level._entities[i] = null;
        }
        _entities = null;
        System.gc();
    }

    static void ClearEntities() {
        int n;
        for (n = 0; n < 24; ++n) {
            if (_entities_usage[n] != 1) continue;
            Level._entities_usage[n] = 0;
            ((Unit)_entities[n]).Clean();
        }
        for (n = 24; n < 48; ++n) {
            if (_entities_usage[n] != 1) continue;
            Level._entities_usage[n] = 0;
            ((Building)_entities[n]).Clean();
        }
        for (n = 48; n < 112; ++n) {
            Level._entities_usage[n] = 0;
            _entities[n].Release();
        }
    }

    static int GetUnusedEntityIndex(int n) {
        if (n == 5) {
            for (int i = 0; i < 24; ++i) {
                if (_entities_usage[i] != 0) continue;
                return i;
            }
        } else if (n == 6) {
            for (int i = 24; i < 48; ++i) {
                if (_entities_usage[i] != 0) continue;
                return i;
            }
        } else {
            int n2 = -1;
            for (int i = 48; i < 112; ++i) {
                if (_entities_usage[i] != 0) continue;
                if (n2 == -1) {
                    n2 = i;
                }
                if (Level._entities[i]._type != n) continue;
                return i;
            }
            return n2;
        }
        return -1;
    }

    static Entity GetEntityUnsafe(int n) {
        return _entities[n];
    }

    static Entity GetEntitySafe(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = n & 0xFFFF;
        if (_entities_usage[n2] == 1 && Level._entities[n2]._uid == n >> 16) {
            return _entities[n2];
        }
        return null;
    }

    static Entity GetEntityById(int n, int n2) {
        int n3;
        if (n2 == -1) {
            return null;
        }
        if (n == -1 || n == 5) {
            for (n3 = 0; n3 < 24; ++n3) {
                if (_entities_usage[n3] != 1 || Level._entities[n3]._id != n2) continue;
                return _entities[n3];
            }
        }
        if (n == -1 || n == 6) {
            for (n3 = 24; n3 < 48; ++n3) {
                if (_entities_usage[n3] != 1 || Level._entities[n3]._id != n2) continue;
                return _entities[n3];
            }
        }
        for (n3 = 48; n3 < 112; ++n3) {
            if (_entities_usage[n3] != 1 || Level._entities[n3]._id != n2) continue;
            return _entities[n3];
        }
        return null;
    }

    static void DeleteEntity(int n) {
        Level.DeleteEntity(Level.GetEntitySafe(n));
    }

    static void DeleteEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        int n = entity.GetPointer();
        short s = entity._arrayIndex;
        if (Camera._targetPointer == n) {
            Camera._targetPointer = -1;
        }
        if (entity._type == 5) {
            byte by;
            Unit unit = (Unit)entity;
            if (unit._group > 0 && unit._allegiance == 1 && Script._AI_groups[by = unit._group][0] > 0) {
                int[] nArray = Script._AI_groups[by];
                nArray[0] = nArray[0] - 1;
            }
        }
        Level._entities_usage[s] = 0;
        entity.EntityDestructor();
        if ((entity._flags & 0x1000) != 0) {
            Level.DeleteFixedEntity(entity);
        }
    }

    static Entity SpawnEntity(int n) {
        int n2 = Level.GetUnusedEntityIndex(n);
        if (n2 < 0) {
            return null;
        }
        _lastSpawnedIndex = n2;
        Entity entity = _entities[n2];
        entity._uid = Entity.GetGlobalUID();
        entity.EntityConstructor(n);
        Level._entities_usage[n2] = 1;
        return entity;
    }

    public static void IncEntityNo(int n, int n2, int n3) {
        if (n == 6) {
            int n4 = n3 * 18 + (10 + n2);
            _entities_no[n4] = _entities_no[n4] + 1;
        } else if (n == 5) {
            int n5 = n3 * 18 + (0 + n2);
            _entities_no[n5] = _entities_no[n5] + 1;
        }
    }

    public static void DecEntityNo(int n, int n2, int n3) {
        if (n == 6) {
            int n4 = n3 * 18 + (10 + n2);
            _entities_no[n4] = _entities_no[n4] - 1;
        } else if (n == 5) {
            int n5 = n3 * 18 + (0 + n2);
            _entities_no[n5] = _entities_no[n5] - 1;
        }
    }

    public static int GetEntityNo(int n, int n2, int n3) {
        if (n == 6) {
            return _entities_no[n3 * 18 + (10 + n2)];
        }
        if (n == 5) {
            return _entities_no[n3 * 18 + (0 + n2)];
        }
        return -1;
    }

    static void __ENTITIES() {
    }

    static void FIXED_ENTITIES__() {
    }

    static boolean IsFixedEntity(int n) {
        return n == 0 || n == 10;
    }

    static boolean IsCDBEntity(Entity entity) {
        if (entity._z_order > 2) {
            return false;
        }
        return entity._type == 0 || entity._type == 10;
    }

    static int AddFixedEntity(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5 & 0xC7 | (n6 & 7) << 3;
        int n8 = _fixedDataPointer;
        Level._fixed_ent_data[n8 + 0] = (byte)(n7 & 0xFF);
        Level._fixed_ent_data[n8 + 1] = (byte)(n & 0x3F);
        Level._fixed_ent_data[n8 + 2] = (byte)(n2 & 0x3F);
        Level._fixed_ent_data[n8 + 3] = (byte)n3;
        Level._fixed_ent_data[n8 + 4] = (byte)n4;
        _fixedDataPointer += 5;
        _lastCellOffset = (n2 >> 6) * _map_vcell_w + (n >> 6) << 1;
        return Level.AddFixedEntityToList(_lastCellOffset, n8);
    }

    static int AddFixedCustomEntity(Entity entity) {
        short s = entity._arrayIndex;
        int n = s >> 8 & 0xFF;
        int n2 = s & 0xFF;
        int n3 = 128;
        entity._flags |= 0x1000;
        if (Level.IsCDBEntity(entity)) {
            entity._flags |= 0x10000;
            n3 |= 0x40;
        }
        return Level.AddFixedEntity(entity._pos_x, entity._pos_y, n, n2, n3, entity._z_order);
    }

    static int AddFixedCustomEntity(int n) {
        Entity entity = Level.GetEntityUnsafe(n);
        int n2 = n >> 8 & 0xFF;
        int n3 = n & 0xFF;
        int n4 = 128;
        entity._flags |= 0x1000;
        if (Level.IsCDBEntity(entity)) {
            entity._flags |= 0x10000;
            n4 |= 0x40;
        }
        return Level.AddFixedEntity(entity._pos_x, entity._pos_y, n2, n3, n4, entity._z_order);
    }

    static int AddFixedEntityToList(int n, int n2) {
        Level._fixed_ent_list[Level._fixedListPointer + 0] = -1;
        Level._fixed_ent_list[Level._fixedListPointer + 1] = (short)n2;
        short s = _fixed_ent_list[n + 0];
        short s2 = _fixed_ent_list[n + 1];
        if (s == -1) {
            Level._fixed_ent_list[n + 0] = (short)_fixedListPointer;
        }
        if (s2 != -1) {
            Level._fixed_ent_list[s2 + 0] = (short)_fixedListPointer;
        }
        Level._fixed_ent_list[n + 1] = (short)_fixedListPointer;
        return (_fixedListPointer += 2) - 2;
    }

    static void DeleteFixedEntity(Entity entity) {
        Level.DeleteFixedEntity(entity._arrayIndex);
    }

    static void DeleteFixedEntity(int n) {
    }

    static void LoadFixedEntity(SDKInputStream sDKInputStream, int n) throws IOException {
        if (n == 0) {
            Level.LoadStaticDecorator(sDKInputStream);
        } else {
            Level.LoadFixedCustomEntity(sDKInputStream, n);
        }
    }

    static void LoadStaticDecorator(SDKInputStream sDKInputStream) throws IOException {
        short s = sDKInputStream.readShort();
        short s2 = sDKInputStream.readShort();
        short s3 = sDKInputStream.readShort();
        int n = sDKInputStream.read();
        int n2 = sDKInputStream.read();
        int n3 = sDKInputStream.read() & 0xFF;
        int n4 = sDKInputStream.read() & 0xFF;
        if (n4 <= 2) {
            n3 |= 0x40;
        }
        Level.AddFixedEntity(s2, s3, n, n2, n3, n4);
    }

    static void LoadFixedCustomEntity(SDKInputStream sDKInputStream, int n) throws IOException {
        Entity entity = Level.SpawnEntity(n);
        entity.Load(sDKInputStream);
        Level.AddFixedCustomEntity(entity);
    }

    static void SetEntityClipWithBorder(int n, int n2, int n3, int n4) {
        _nClipCellX = n - 42 >> 6;
        _nClipCellY = n2 - 35 >> 6;
        _nClipCellX2 = n + n3 - -40 >> 6;
        _nClipCellY2 = n2 + n4 - -40 >> 6;
        if (_nClipCellX < 0) {
            _nClipCellX = 0;
        }
        if (_nClipCellY < 0) {
            _nClipCellY = 0;
        }
        if (_nClipCellX2 >= _map_vcell_w) {
            _nClipCellX2 = _map_vcell_w - 1;
        }
        if (_nClipCellY2 >= _map_vcell_h) {
            _nClipCellY2 = _map_vcell_h - 1;
        }
    }

    static void SetEntityClip(int n, int n2, int n3, int n4) {
        _nClipCellX = n >> 6;
        _nClipCellY = n2 >> 6;
        _nClipCellX2 = n + n3 >> 6;
        _nClipCellY2 = n2 + n4 >> 6;
        if (_nClipCellX < 0) {
            _nClipCellX = 0;
        }
        if (_nClipCellY < 0) {
            _nClipCellY = 0;
        }
        if (_nClipCellX2 >= _map_vcell_w) {
            _nClipCellX2 = _map_vcell_w - 1;
        }
        if (_nClipCellY2 >= _map_vcell_h) {
            _nClipCellY2 = _map_vcell_h - 1;
        }
    }

    static void ResetFixedEntitiesClipList() {
        _fixed_clip_count = 0;
    }

    static void FindFixedEntitiesInClip(boolean bl) {
        for (int i = _nClipCellY; i <= _nClipCellY2; ++i) {
            for (int j = _nClipCellX; j <= _nClipCellX2; ++j) {
                int n = (i * _map_vcell_w + j) * 2;
                short s = _fixed_ent_list[n + 0];
                while (s != -1) {
                    short s2 = _fixed_ent_list[s + 1];
                    byte by = _fixed_ent_data[s2 + 0];
                    int n2 = by >> 3 & 7;
                    int n3 = 0;
                    int n4 = 0;
                    if (bl && (by & 0x40) != 0) {
                        n3 = (n2 & 7) << 16 | s2;
                    } else if (!bl && (by & 0x40) == 0) {
                        int n5 = (j << 6) + _fixed_ent_data[s2 + 1];
                        int n6 = (i << 6) + _fixed_ent_data[s2 + 2];
                        n3 = (n2 & 7) << 24 | (n6 & 0xFFF) << 12 | n5 & 0xFFF;
                    } else {
                        s = _fixed_ent_list[s + 0];
                        continue;
                    }
                    n4 = (i & 0xFF) << 24 | (j & 0xFF) << 16 | s2 & 0xFFFF;
                    Level._fixed_w_array[Level._fixed_clip_count] = n3;
                    Level._fixed_clip_array[Level._fixed_clip_count] = n4;
                    ++_fixed_clip_count;
                    s = _fixed_ent_list[s + 0];
                }
            }
        }
    }

    static void DrawFixedEntityFromPackedValue(SDKGraphics sDKGraphics, int n, boolean bl) {
        int n2 = n & 0xFFFF;
        byte by = _fixed_ent_data[n2 + 0];
        byte by2 = _fixed_ent_data[n2 + 3];
        byte by3 = _fixed_ent_data[n2 + 4];
        if ((by & 0x80) == 0) {
            int n3 = (n >> 24 & 0xFF) << 6;
            int n4 = (n >> 16 & 0xFF) << 6;
            int n5 = (_fixed_ent_data[n2 + 1] & 0xFF) + n4 - Camera._nCamX;
            int n6 = (_fixed_ent_data[n2 + 2] & 0xFF) + n3 - Camera._nCamY;
            if (bl) {
                n5 += 0;
                n6 += 38;
            }
            GameImpl._sprites[by2].DrawFrame(by3, n5, n6, by & 7);
        } else {
            Level.GetEntityUnsafe((by2 & 0xFF) << 8 | by3 & 0xFF).Draw(sDKGraphics);
        }
    }

    static void ResetDynamicEntitiesClipList() {
        _dynamic_entities_clip_count = 0;
    }

    static void FindDynamicEntitiesInClip() {
        GameImpl.Rect(GameImpl._rect, Camera._nCamX - 42, Camera._nCamY - 35, Constants.SV_W + 42 - -40, Constants.SV_H + 35 - -40);
        for (int i = 0; i < 112; ++i) {
            int n;
            if (_entities_usage[i] != 1) continue;
            Entity entity = _entities[i];
            if ((entity._flags & 0x11000) != 0 || !GameImpl.PointInRect(GameImpl._rect, entity._pos_x, entity._pos_y)) continue;
            Level._dynamic_w_array[Level._dynamic_entities_clip_count] = n = (entity._z_order & 7) << 24 | (entity._pos_y & 0xFFF) << 12 | entity._pos_x & 0xFFF;
            Level._dynamic_entities_clip[Level._dynamic_entities_clip_count] = i;
            ++_dynamic_entities_clip_count;
        }
    }

    static void __FIXED_ENTITIES() {
    }

    static void STATS__() {
    }

    static void InitStats() {
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(13);
            _building_stats_soviets = null;
            _building_stats_soviets = GameImpl.ReadShortArray(sDKInputStream, 160, _building_stats_soviets, 0);
            sDKInputStream.close();
            sDKInputStream = null;
            sDKInputStream = new SDKInputStream(14);
            _building_stats_allied = null;
            _building_stats_allied = GameImpl.ReadShortArray(sDKInputStream, 160, _building_stats_allied, 0);
            sDKInputStream.close();
            sDKInputStream = null;
            _bullet_stats = SDKInputStream.loadResourceAsByteArray(15);
            sDKInputStream = new SDKInputStream(16);
            _unit_stats = null;
            _unit_stats = GameImpl.ReadShortArray(sDKInputStream, 270, _unit_stats, 0);
            sDKInputStream.close();
            sDKInputStream = null;
            _attack_priorities = SDKInputStream.loadResourceAsByteArray(17);
            System.gc();
            _firing_positions = SDKInputStream.loadResourceAsByteArray(18);
            System.gc();
            sDKInputStream = new SDKInputStream(19);
            _sw_stats = null;
            _sw_stats = GameImpl.ReadShortArray(sDKInputStream, 110, _sw_stats, 0);
            sDKInputStream.close();
            sDKInputStream = null;
            sDKInputStream = new SDKInputStream(20);
            _level_stats = null;
            _level_stats = GameImpl.ReadShortArray(sDKInputStream, 221, _level_stats, 0);
            sDKInputStream.close();
            sDKInputStream = null;
            sDKInputStream = new SDKInputStream(21);
            GameImpl._menuItems = GameImpl.BS_ReadShortArray(sDKInputStream, GameImpl._menuItems);
            sDKInputStream.close();
            sDKInputStream = null;
            sDKInputStream = new SDKInputStream(22);
            GameImpl._menuSoftKeys = GameImpl.ReadShortArray(sDKInputStream, 36, GameImpl._menuSoftKeys, 0);
            sDKInputStream.close();
            sDKInputStream = null;
            sDKInputStream = new SDKInputStream(23);
            GameImpl._menuNames = GameImpl.ReadShortArray(sDKInputStream, 36, GameImpl._menuNames, 0);
            sDKInputStream.close();
            sDKInputStream = null;
            SDKInputStream.purgeCache();
            System.gc();
        }
        catch (Exception exception) {
            Debug.CatchException("InitStats", exception);
        }
    }

    public static void ReleaseStats() {
        _building_stats_allied = null;
        _building_stats_soviets = null;
        _bullet_stats = null;
        _unit_stats = null;
        _attack_priorities = null;
        _firing_positions = null;
        _sw_stats = null;
        _level_stats = null;
        _hud_colors = null;
    }

    public static int GetBulletStats(int n, int n2) {
        return _bullet_stats[n * 8 + n2];
    }

    public static int GetBuildingStats(int n, int n2, int n3) {
        short[] sArray = n == 0 ? _building_stats_soviets : _building_stats_allied;
        return sArray[n2 * 20 + n3];
    }

    public static void SetBuildingStats(int n, int n2, int n3, int n4) {
        short[] sArray = n == 0 ? _building_stats_soviets : _building_stats_allied;
        sArray[n2 * 20 + n3] = (byte)n4;
    }

    public static int GetUnitStats(int n, int n2) {
        return _unit_stats[n * 27 + n2];
    }

    public static int GetSWStats(int n, int n2) {
        return _sw_stats[n * 11 + n2];
    }

    public static int GetLevelStats(int n, int n2) {
        return _level_stats[n * 17 + n2];
    }

    public static void GetBuildingFiringPosition(int n, int n2, int n3) {
        int n4 = 0;
        switch (n) {
            case 5: {
                n4 = n2 == 0 ? 1 : 2;
            }
        }
        _firingOffsetX = _firing_positions[(n4 << 4) + (n3 << 1)];
        _firingOffsetY = _firing_positions[(n4 << 4) + (n3 << 1) + 1];
    }

    static void GetUnitFiringPosition(int n, int n2) {
        int n3 = 0;
        _firingOffsetX = _firing_positions[(n3 << 4) + (n2 << 1)];
        _firingOffsetY = _firing_positions[(n3 << 4) + (n2 << 1) + 1];
    }

    static void __STATS() {
    }

    static void BUILDING_CMAP__() {
    }

    static void InitCMaps() {
        for (int i = 0; i < 17; ++i) {
            Level.LoadCMap(201 + i, i);
        }
        SDKInputStream.purgeCache();
        System.gc();
    }

    static int GetCMapHeaderData(int n, int n2) {
        return _cmaps_header[n * 4 + n2];
    }

    static void LoadCMap(int n, int n2) {
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n);
            short s = sDKInputStream.readShort();
            short s2 = sDKInputStream.readShort();
            int n3 = sDKInputStream.read() & 0xFF;
            int n4 = sDKInputStream.read() & 0xFF;
            int n5 = n3 * n4;
            int n6 = n2 * 4;
            Level._cmaps_header[n6 + 0] = s;
            Level._cmaps_header[n6 + 1] = s2;
            Level._cmaps_header[n6 + 2] = (short)n3;
            Level._cmaps_header[n6 + 3] = (short)n4;
            Level._cmaps[n2] = new byte[n5];
            byte[] byArray = Level._cmaps[n2];
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            while (n9 < n4) {
                boolean bl = true;
                for (int i = 0; i < n3; ++i) {
                    if (bl) {
                        n8 = sDKInputStream.read();
                    }
                    bl = !bl;
                    int n10 = n8 & 0xF;
                    byArray[n7 + i] = (byte)n10;
                    n8 >>= 4;
                }
                ++n9;
                n7 += n3;
            }
            sDKInputStream.close();
            sDKInputStream = null;
            System.gc();
        }
        catch (Exception exception) {
            Debug.CatchException("Exception on LoadBuildingCollisionMap(" + n2 + "):", exception);
        }
    }

    static byte[] GetCMap(int n) {
        return _cmaps[n];
    }

    static void ApplyCollisionMap(int n, int n2, int n3) {
        int n4 = Level.GetCMapHeaderData(n3, 0);
        int n5 = Level.GetCMapHeaderData(n3, 1);
        int n6 = Level.GetCMapHeaderData(n3, 2);
        int n7 = Level.GetCMapHeaderData(n3, 3);
        byte[] byArray = Level.GetCMap(n3);
        int n8 = (n + n4) / 8;
        int n9 = (n2 + n5) / 8;
        int n10 = 0;
        for (int i = 0; i < n7; ++i) {
            int n11 = 0;
            while (n11 < n6) {
                if (byArray[n10] != 0) {
                    Level.SetCollisionAtTile(n8 + n11, n9 + i, byArray[n10]);
                }
                ++n11;
                ++n10;
            }
        }
    }

    static void EraseCollisionMap(int n, int n2, int n3, int n4) {
        int n5 = Level.GetCMapHeaderData(n3, 0);
        int n6 = Level.GetCMapHeaderData(n3, 1);
        int n7 = Level.GetCMapHeaderData(n3, 2);
        int n8 = Level.GetCMapHeaderData(n3, 3);
        byte[] byArray = Level.GetCMap(n3);
        int n9 = (n + n5) / 8;
        int n10 = (n2 + n6) / 8;
        int n11 = 0;
        for (int i = 0; i < n8; ++i) {
            int n12 = 0;
            while (n12 < n7) {
                if (byArray[n11] != 0) {
                    Level.SetCollisionAtTile(n9 + n12, n10 + i, n4);
                }
                ++n12;
                ++n11;
            }
        }
    }

    static void __BUILDING_CMAP() {
    }

    static void RefreshCreep(int n) {
        for (int i = 24; i < 48; ++i) {
            if (_entities_usage[i] != 1) continue;
            Building building = (Building)_entities[i];
            if (building._allegiance != n) continue;
            building.ApplyCreep(true);
        }
    }

    static void EndLevel(int n) {
        GameImpl._player_won = n == 0;
        GameImpl._oldSovietMission = GameImpl._maxSovietMission;
        GameImpl._oldAlliedMission = GameImpl._maxAlliedMission;
        GameImpl._oldSkirmishMission = GameImpl._maxSkirmishMission;
        if (GameImpl._player_won && !_b_skirmish && _crt_level < 7) {
            GameImpl._nextMission = _crt_level + 1;
            if (_crt_level == 1) {
                if (GameImpl._maxSkirmishMission < 9) {
                    GameImpl._maxSkirmishMission = 9;
                }
            } else if (_crt_level == 3) {
                if (GameImpl._maxSkirmishMission < 10) {
                    GameImpl._maxSkirmishMission = 10;
                }
                if (GameImpl._maxAlliedMission < 4) {
                    GameImpl._maxAlliedMission = 4;
                }
            } else if (_crt_level == 5 && GameImpl._maxSkirmishMission < 11) {
                GameImpl._maxSkirmishMission = 11;
            }
            if (_crt_level < 3) {
                if (GameImpl._maxSovietMission < GameImpl._nextMission) {
                    GameImpl._maxSovietMission = GameImpl._nextMission;
                }
            } else if (_crt_level < 7 && GameImpl._maxAlliedMission < GameImpl._nextMission) {
                GameImpl._maxAlliedMission = GameImpl._nextMission;
            }
            GameImpl.saveRMS();
        }
        Level.SetEndLevelMusic(GameImpl._player_won);
        GameImpl.SetState(9);
        GameImpl._nextMenuState = 7;
    }

    static void GetCurrentGravCenter(int n, int n2) {
        _gravity_center_X = -1;
        _gravity_center_Y = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < 24; ++i) {
            if (_entities_usage[i] != 1) continue;
            Unit unit = (Unit)_entities[i];
            if (unit._allegiance != n2 || unit._life <= 0 || (n != -1 || !unit._bSelected) && (n == -1 || unit._group != n)) continue;
            ++n3;
            n4 += unit._pos_x;
            n5 += unit._pos_y;
        }
        if (n3 > 0) {
            _gravity_center_X = n4 / n3;
            _gravity_center_Y = n5 / n3;
        }
    }

    public static Entity FindClosestMineralField(int n, int n2, int n3) {
        Entity entity = null;
        int n4 = 0;
        for (int i = 48; i < 112; ++i) {
            int n5;
            if (_entities_usage[i] != 1) continue;
            Entity entity2 = _entities[i];
            if (entity2._type != 10 || (n5 = Math.abs(n - entity2._pos_x) + Math.abs(n2 - entity2._pos_y)) >= n3 || entity != null && n5 >= n4) continue;
            entity = entity2;
            n4 = n5;
        }
        return entity;
    }

    static void SuperWeapons__() {
    }

    static void ResetSWTimer(int n, int n2) {
        if (n == 0) {
            if (Hud._sw_cooldown[n2] <= 10 && Hud._sw_cooldown[n2] >= 0) {
                Hud._sw_cooldown[n2] = 14 * Level.GetSWStats(n2, 0);
            }
        } else if (n == 1) {
            Script._AI_sw_cooldown[n2] = 14 * Level.GetSWStats(n2, 0);
        }
    }

    static void DropNuke(int n, int n2, int n3) {
        Entity entity = Level.SpawnEntity(106);
        entity.Nuke_Init(n, n2, n3);
        Level.ResetSWTimer(n, 0);
    }

    static void DropStorm(int n, int n2, int n3) {
        if (Hud._hud_state != 5) {
            _hud_state_storm = Hud._hud_state;
            _bCodeMovieState = true;
            Hud.ChangeState(5, true);
            Hud.RiseMovieBars();
        }
        Entity entity = Level.SpawnEntity(115);
        entity.Storm_Init(n, n2, n3);
        Level.ResetSWTimer(n, 1);
    }

    static void __SuperWeapons() {
    }

    static void DoSplashDamage(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < 112; ++i) {
            if (_entities_usage[i] != 1) continue;
            Entity entity = _entities[i];
            int n7 = Math.abs(entity._pos_x - n) + Math.abs(entity._pos_y - n2);
            if (n7 >= n3) continue;
            entity.TakeDamage(n4, n5, n6);
        }
    }

    public static boolean HasPower(int n) {
        if (n == 0) {
            return _player_consumption < _player_power && _buildings_off_times[0][1] <= 0;
        }
        if (n == 1) {
            return _ai_consumption < _ai_power && _buildings_off_times[1][1] <= 0;
        }
        return true;
    }

    static void SetEndLevelMusic(boolean bl) {
        if (!GameImpl._soundEnable || bl) {
            // empty if block
        }
    }

    static short WinterToGrass_Tile(short s) {
        return (short)(s + 1 + s / 2);
    }

    static int WinterToGrass_DecoratorSprite(int n, int n2) {
        if (n == 18) {
            n = 19;
        } else if (n == 1 && n2 == 0) {
            return 19;
        }
        return n;
    }

    static int WinterToGrass_DecoratorFrame(int n, int n2) {
        if (n == 18) {
            return 8 + n2;
        }
        return n2;
    }

    static void MAP__() {
    }

    static void ClearTileMap() {
        _tilePalette = null;
        _map = null;
        _coll_map = null;
        System.gc();
    }

    static void LoadTileMap(int n) {
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n);
            _currentTileSet = GameImpl._tileSets[sDKInputStream.read()];
            _nrTiles = sDKInputStream.read() & 0xFF;
            _tilePalette = new short[_nrTiles];
            for (int i = 0; i < _nrTiles; ++i) {
                Level._tilePalette[i] = sDKInputStream.readShort();
            }
            _map_tw = sDKInputStream.read() & 0xFF;
            _map_th = sDKInputStream.read() & 0xFF;
            _map_size = _map_tw * _map_th;
            _map_w = _map_tw * 24;
            _map_h = _map_th * 24;
            _map_vcell_w = _map_w + 64 - 1 >> 6;
            _map_vcell_h = _map_h + 64 - 1 >> 6;
            _map = GameImpl.ReadByteArray(sDKInputStream, _map_size << 1, new byte[_map_size << 1], 0);
            sDKInputStream.close();
            sDKInputStream = null;
            System.gc();
        }
        catch (Exception exception) {
            Debug.CatchException("Exception on LoadTileMap:", exception);
        }
    }

    static void ClearCollisionMap() {
        _coll_map = null;
        System.gc();
    }

    static void LoadCollisionMap(int n) {
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n);
            sDKInputStream.readShort();
            sDKInputStream.readShort();
            _coll_map_tw = sDKInputStream.read() & 0xFF;
            _coll_map_th = sDKInputStream.read() & 0xFF;
            _coll_map_size = _coll_map_tw * _coll_map_th;
            _coll_map = new byte[_coll_map_size];
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < _coll_map_th) {
                boolean bl = true;
                for (int i = 0; i < _coll_map_tw; ++i) {
                    if (bl) {
                        n3 = sDKInputStream.read();
                    }
                    bl = !bl;
                    int n5 = n3 & 0xF;
                    Level._coll_map[n2 + i] = (byte)n5;
                    n3 >>= 4;
                }
                ++n4;
                n2 += _coll_map_tw;
            }
            sDKInputStream.close();
            sDKInputStream = null;
            System.gc();
        }
        catch (Exception exception) {
            Debug.CatchException("Exception on LoadCollisionMap:", exception);
        }
    }

    static void COLLISION_MAP__() {
    }

    static int GetCollisionAt(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= _map_w || n2 >= _map_h) {
            return 15;
        }
        return _coll_map[n2 / 8 * _coll_map_tw + n / 8] & 0x7F;
    }

    static int GetCollisionAtTile(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= _coll_map_tw || n2 >= _coll_map_th) {
            return 15;
        }
        return _coll_map[n2 * _coll_map_tw + n] & 0x7F;
    }

    static int GetCollisionAtTile(int n) {
        if (n < 0 || n >= _coll_map_size) {
            return 15;
        }
        return _coll_map[n] & 0x7F;
    }

    static void SetCollisionAtTile(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n >= _coll_map_tw || n2 >= _coll_map_th) {
            return;
        }
        Level._coll_map[n2 * Level._coll_map_tw + n] = (byte)(n3 & 0x7F);
    }

    static boolean NoLineOfSightCollisionBetween(Entity entity, Entity entity2, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        boolean bl;
        if (entity != null) {
            n2 = entity._pos_x / 8;
            n3 = entity._pos_y / 8;
        }
        if (entity2 != null) {
            n4 = entity2._pos_x / 8;
            n5 = entity2._pos_y / 8;
        }
        boolean bl2 = bl = Math.abs(n3 - n5) > Math.abs(n2 - n4);
        if (bl) {
            n9 = n2;
            n2 = n3;
            n3 = n9;
            n8 = n4;
            n4 = n5;
            n5 = n8;
        }
        if (n2 > n4) {
            n9 = n2;
            n2 = n4;
            n4 = n9;
            n8 = n3;
            n3 = n5;
            n5 = n8;
        }
        int n10 = n4 - n2;
        int n11 = Math.abs(n5 - n3);
        int n12 = n10 / 2;
        int n13 = n3 < n5 ? 1 : -1;
        n8 = n3;
        n9 = n2;
        if (bl) {
            n7 = n9 * _coll_map_tw + n8;
            n6 = n13;
        } else {
            n7 = n8 * _coll_map_tw + n9;
            n6 = n13 * _coll_map_tw;
        }
        for (n9 = n2; n9 < n4; ++n9) {
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            Building building;
            boolean bl3 = false;
            if (entity != null && entity._type == 6) {
                building = (Building)entity;
                n18 = building._subtype * 4;
                n17 = (entity._pos_x + _cmaps_header[n18 + 0]) / 8;
                n16 = (entity._pos_y + _cmaps_header[n18 + 1]) / 8;
                n15 = n17 + _cmaps_header[n18 + 2];
                n14 = n16 + _cmaps_header[n18 + 3];
                if (bl) {
                    if (n8 >= n17 && n8 <= n15 && n9 >= n16 && n9 <= n14) {
                        bl3 = true;
                    }
                } else if (n9 >= n17 && n9 <= n15 && n8 >= n16 && n8 <= n14) {
                    bl3 = true;
                }
            }
            if (entity2 != null && entity2._type == 6) {
                building = (Building)entity2;
                n18 = building._subtype * 4;
                n17 = (entity2._pos_x + _cmaps_header[n18 + 0]) / 8;
                n16 = (entity2._pos_y + _cmaps_header[n18 + 1]) / 8;
                n15 = n17 + _cmaps_header[n18 + 2];
                n14 = n16 + _cmaps_header[n18 + 3];
                if (bl) {
                    if (n8 >= n17 && n8 <= n15 && n9 >= n16 && n9 <= n14) {
                        bl3 = true;
                    }
                } else if (n9 >= n17 && n9 <= n15 && n8 >= n16 && n8 <= n14) {
                    bl3 = true;
                }
            }
            if (!bl3 && _coll_map[n7] > n) {
                return false;
            }
            if ((n12 -= n11) < 0) {
                n8 += n13;
                n12 += n10;
                n7 += n6;
            }
            if (bl) {
                n7 += _coll_map_tw;
                continue;
            }
            ++n7;
        }
        return true;
    }

    static boolean ValidateCollisionTile(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n >= _coll_map_tw || n2 >= _coll_map_th) {
            return false;
        }
        _validTileX = n;
        _validTileY = n2;
        int n4 = n2 * _coll_map_tw + n;
        if (_coll_map[n4] > 4) {
            int n5;
            int n6 = GameImpl.randomInt() & 7;
            for (n5 = 0; n5 < 8; ++n5) {
                if (Level.GetCollisionAtTile(n + _xx[n6], n2 + _yy[n6]) <= 4) {
                    _validTileX = n + _xx[n6];
                    _validTileY = n2 + _yy[n6];
                    return true;
                }
                n6 = n6 + 1 & 7;
            }
            for (n5 = 2; n5 < n3; ++n5) {
                for (int i = -n5; i <= n5; ++i) {
                    if (n + i < 0 || n + i > _coll_map_tw - 1) continue;
                    for (int j = -n5; j <= n5; ++j) {
                        if (n2 + j < 0 || n2 + j > _coll_map_th - 1 || Math.abs(i) + Math.abs(j) != n5 || Level.GetCollisionAtTile(n + i, n2 + j) > 4) continue;
                        _validTileX = n + i;
                        _validTileY = n2 + j;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    static void __COLLISION_MAP() {
    }

    static void CDB_INVALIDATOR__() {
    }

    static void CDB_Invalidator_Init() {
        GameImpl.ResetRect(_invalidator_rect);
    }

    static void CDB_AddInvalidateRegion(int[] nArray) {
        _bInvalidatorCDB = true;
        GameImpl.RectUnion(_invalidator_rect, _invalidator_rect, nArray);
    }

    static void CDB_AddInvalidateRegion(int n, int n2, int n3, int n4) {
        _bInvalidatorCDB = true;
        Level._invalidator_rect[0] = Math.min(_invalidator_rect[0], n);
        Level._invalidator_rect[1] = Math.min(_invalidator_rect[1], n2);
        Level._invalidator_rect[2] = Math.max(_invalidator_rect[2], n + n3);
        Level._invalidator_rect[3] = Math.max(_invalidator_rect[3], n2 + n4);
    }

    static void CDB_Invalidator_Update() {
        if (_bInvalidatorCDB) {
            _bInvalidatorCDB = false;
            Level.CDB_InvalidatePixels(_invalidator_rect[0], _invalidator_rect[1], _invalidator_rect[2] - _invalidator_rect[0], _invalidator_rect[3] - _invalidator_rect[1], false);
            GameImpl.ResetRect(_invalidator_rect);
        }
    }

    static void __CDB_INVALIDATOR() {
    }

    static void CDB_Update() {
        int n;
        int n2;
        int n3;
        if (!_bResetCDB) {
            n3 = Camera._nCamX - _CDB_view_tx * 24;
            if (n3 < 0) {
                n2 = (23 - n3) / 24;
                if (n2 >= Constants.CDB_TW) {
                    _bResetCDB = true;
                } else {
                    _CDB_view_tx -= n2;
                    if ((_CDB_orig_tx -= n2) < 0) {
                        n = n2 + _CDB_orig_tx;
                        if (n != 0) {
                            Level.CDB_InvalidateTilesV(0, n, _CDB_view_tx - _CDB_orig_tx);
                        }
                        Level.CDB_InvalidateTilesV(_CDB_orig_tx += Constants.CDB_TW, n2 - n, _CDB_view_tx);
                    } else {
                        Level.CDB_InvalidateTilesV(_CDB_orig_tx, n2, _CDB_view_tx);
                    }
                }
            } else if (n3 > Constants.CDB_W - Constants.SV_W) {
                n2 = (n3 - (Constants.CDB_W - Constants.SV_W) + 23) / 24;
                if (n2 >= Constants.CDB_TW) {
                    _bResetCDB = true;
                } else {
                    n = _CDB_orig_tx + n2 - Constants.CDB_TW;
                    if (n >= 0) {
                        Level.CDB_InvalidateTilesV(_CDB_orig_tx, Constants.CDB_TW - _CDB_orig_tx, _CDB_view_tx + Constants.CDB_TW);
                        if (n != 0) {
                            Level.CDB_InvalidateTilesV(0, n, _CDB_view_tx + Constants.CDB_TW + Constants.CDB_TW - _CDB_orig_tx);
                        }
                        _CDB_orig_tx = n;
                    } else {
                        Level.CDB_InvalidateTilesV(_CDB_orig_tx, n2, _CDB_view_tx + Constants.CDB_TW);
                        _CDB_orig_tx += n2;
                    }
                    _CDB_view_tx += n2;
                }
            }
        }
        if (!_bResetCDB) {
            n3 = Camera._nCamY - _CDB_view_ty * 24;
            if (n3 < 0) {
                n2 = (23 - n3) / 24;
                if (n2 >= Constants.CDB_TH) {
                    _bResetCDB = true;
                } else {
                    _CDB_view_ty -= n2;
                    if ((_CDB_orig_ty -= n2) < 0) {
                        n = n2 + _CDB_orig_ty;
                        if (n != 0) {
                            Level.CDB_InvalidateTilesH(0, n, _CDB_view_ty - _CDB_orig_ty);
                        }
                        Level.CDB_InvalidateTilesH(_CDB_orig_ty += Constants.CDB_TH, n2 - n, _CDB_view_ty);
                    } else {
                        Level.CDB_InvalidateTilesH(_CDB_orig_ty, n2, _CDB_view_ty);
                    }
                }
            } else if (n3 > Constants.CDB_H - Constants.SV_H) {
                n2 = (n3 - (Constants.CDB_H - Constants.SV_H) + 23) / 24;
                if (n2 >= Constants.CDB_TH) {
                    _bResetCDB = true;
                } else {
                    n = _CDB_orig_ty + n2 - Constants.CDB_TH;
                    if (n >= 0) {
                        Level.CDB_InvalidateTilesH(_CDB_orig_ty, Constants.CDB_TH - _CDB_orig_ty, _CDB_view_ty + Constants.CDB_TH);
                        if (n != 0) {
                            Level.CDB_InvalidateTilesH(0, n, _CDB_view_ty + Constants.CDB_TH + Constants.CDB_TH - _CDB_orig_ty);
                        }
                        _CDB_orig_ty = n;
                    } else {
                        Level.CDB_InvalidateTilesH(_CDB_orig_ty, n2, _CDB_view_ty + Constants.CDB_TH);
                        _CDB_orig_ty += n2;
                    }
                    _CDB_view_ty += n2;
                }
            }
        }
        if (_bResetCDB) {
            _bResetCDB = false;
            _CDB_view_tx = Camera._nCamX / 24;
            if (_CDB_view_tx > _map_tw - Constants.CDB_TW) {
                _CDB_view_tx = _map_tw - Constants.CDB_TW;
            }
            if ((_CDB_view_ty = Camera._nCamY / 24) > _map_th - Constants.CDB_TH) {
                _CDB_view_ty = _map_th - Constants.CDB_TH;
            }
            _CDB_orig_tx = 0;
            _CDB_orig_ty = 0;
            Level.CDB_InvalidateTiles(0, 0, Constants.CDB_TW, Constants.CDB_TH, _CDB_view_tx, _CDB_view_ty);
        }
    }

    static void CDB_Invalidate(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = n / 24;
        int n12 = n2 / 24;
        int n13 = (n + n3 - 1) / 24 + 1;
        int n14 = (n2 + n4 - 1) / 24 + 1;
        if (n11 < _CDB_view_tx) {
            n11 = _CDB_view_tx;
        }
        if (n13 > _CDB_view_tx + Constants.CDB_TW) {
            n13 = _CDB_view_tx + Constants.CDB_TW;
        }
        if (n13 - n11 <= 0) {
            return;
        }
        if (n12 < _CDB_view_ty) {
            n12 = _CDB_view_ty;
        }
        if (n14 > _CDB_view_ty + Constants.CDB_TH) {
            n14 = _CDB_view_ty + Constants.CDB_TH;
        }
        if (n14 - n12 <= 0) {
            return;
        }
        int n15 = n11 + _CDB_orig_tx - _CDB_view_tx;
        int n16 = n15 - Constants.CDB_TW;
        if (n16 < 0) {
            n16 = 0;
        }
        if ((n10 = Constants.CDB_TW - n15) > (n9 = n13 - n11)) {
            n10 = n9;
        }
        if ((n8 = n9 - n10) > n9) {
            n8 = n9;
        }
        n13 = n11 + n9 - n8;
        int n17 = n12 + _CDB_orig_ty - _CDB_view_ty;
        int n18 = n17 - Constants.CDB_TH;
        if (n18 < 0) {
            n18 = 0;
        }
        if ((n7 = Constants.CDB_TH - n17) > (n6 = n14 - n12)) {
            n7 = n6;
        }
        if ((n5 = n6 - n7) > n6) {
            n5 = n6;
        }
        n14 = n12 + n6 - n5;
        if (n10 > 0) {
            if (n7 > 0) {
                Level.CDB_InvalidateTiles(n15, n17, n10, n7, n11, n12);
            }
            if (n5 > 0) {
                Level.CDB_InvalidateTiles(n15, n18, n10, n5, n11, n14);
            }
        }
        if (n8 > 0) {
            if (n7 > 0) {
                Level.CDB_InvalidateTiles(n16, n17, n8, n7, n13, n12);
            }
            if (n5 > 0) {
                Level.CDB_InvalidateTiles(n16, n18, n8, n5, n13, n14);
            }
        }
    }

    static void CDB_InvalidatePixels(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n;
        int n6 = n2;
        int n7 = n + n3;
        int n8 = n2 + n4;
        if (bl) {
            if (n5 < Camera._nCamX) {
                n5 = Camera._nCamX;
            }
            if (n7 > Camera._nCamX + Constants.SV_W) {
                n7 = Camera._nCamX + Constants.SV_W;
            }
            if (n7 - n5 <= 0) {
                return;
            }
            if (n6 < Camera._nCamY) {
                n6 = Camera._nCamY;
            }
            if (n8 > Camera._nCamY + Constants.SV_H) {
                n8 = Camera._nCamY + Constants.SV_H;
            }
            if (n8 - n6 <= 0) {
                return;
            }
            n3 = n7 - n5;
            n4 = n8 - n6;
            Level.CDB_InvalidateArea(n5 - Camera._nCamX, n6 - Camera._nCamY, n3, n4, n5, n6, bl);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13 = _CDB_view_tx * 24;
            int n14 = _CDB_view_ty * 24;
            int n15 = _CDB_orig_tx * 24;
            int n16 = _CDB_orig_ty * 24;
            int n17 = Constants.CDB_W;
            int n18 = Constants.CDB_H;
            if (n5 < n13) {
                n5 = n13;
            }
            if (n7 > n13 + n17) {
                n7 = n13 + n17;
            }
            if (n7 - n5 <= 0) {
                return;
            }
            if (n6 < n14) {
                n6 = n14;
            }
            if (n8 > n14 + n18) {
                n8 = n14 + n18;
            }
            if (n8 - n6 <= 0) {
                return;
            }
            int n19 = n5 + n15 - n13;
            int n20 = n19 - n17;
            if (n20 < 0) {
                n20 = 0;
            }
            if ((n12 = n17 - n19) > (n3 = n7 - n5)) {
                n12 = n3;
            }
            if ((n11 = n3 - n12) > n3) {
                n11 = n3;
            }
            n7 = n5 + n3 - n11;
            int n21 = n6 + n16 - n14;
            int n22 = n21 - n18;
            if (n22 < 0) {
                n22 = 0;
            }
            if ((n10 = n18 - n21) > (n4 = n8 - n6)) {
                n10 = n4;
            }
            if ((n9 = n4 - n10) > n4) {
                n9 = n4;
            }
            n8 = n6 + n4 - n9;
            if (n12 > 0) {
                if (n10 > 0) {
                    Level.CDB_InvalidateArea(n19, n21, n12, n10, n5, n6, bl);
                }
                if (n9 > 0) {
                    Level.CDB_InvalidateArea(n19, n22, n12, n9, n5, n8, bl);
                }
            }
            if (n11 > 0) {
                if (n10 > 0) {
                    Level.CDB_InvalidateArea(n20, n21, n11, n10, n7, n6, bl);
                }
                if (n9 > 0) {
                    Level.CDB_InvalidateArea(n20, n22, n11, n9, n7, n8, bl);
                }
            }
        }
    }

    private static void CDB_InvalidateTilesV(int n, int n2, int n3) {
        if (_CDB_orig_ty > 0) {
            Level.CDB_InvalidateTiles(n, 0, n2, _CDB_orig_ty, n3, _CDB_view_ty + Constants.CDB_TH - _CDB_orig_ty);
            Level.CDB_InvalidateTiles(n, _CDB_orig_ty, n2, Constants.CDB_TH - _CDB_orig_ty, n3, _CDB_view_ty);
        } else {
            Level.CDB_InvalidateTiles(n, 0, n2, Constants.CDB_TH, n3, _CDB_view_ty);
        }
    }

    private static void CDB_InvalidateTilesH(int n, int n2, int n3) {
        if (_CDB_orig_tx > 0) {
            Level.CDB_InvalidateTiles(0, n, _CDB_orig_tx, n2, _CDB_view_tx + Constants.CDB_TW - _CDB_orig_tx, n3);
            Level.CDB_InvalidateTiles(_CDB_orig_tx, n, Constants.CDB_TW - _CDB_orig_tx, n2, _CDB_view_tx, n3);
        } else {
            Level.CDB_InvalidateTiles(0, n, Constants.CDB_TW, n2, _CDB_view_tx, n3);
        }
    }

    private static void CDB_InvalidateTiles(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n * 24;
        int n8 = n2 * 24;
        int n9 = n3 * 24;
        int n10 = n4 * 24;
        int n11 = n5 * 24;
        int n12 = n6 * 24;
        _gBB.setClip(n7, n8, n9, n10);
        XSprite.SetGraphics(_gBB);
        if (n3 == 1) {
            int n13 = n8 + n10;
            int n14 = n5 + n6 * _map_tw;
            int n15 = n8;
            while (n15 < n13) {
                Level.CDB_DrawTile(n14, n7, n15);
                n15 += 24;
                n14 += _map_tw;
            }
        } else if (n4 == 1) {
            int n16 = n7 + n9;
            int n17 = n5 + n6 * _map_tw;
            int n18 = n7;
            while (n18 < n16) {
                Level.CDB_DrawTile(n17, n18, n8);
                n18 += 24;
                ++n17;
            }
        } else {
            int n19 = n7 + n9;
            int n20 = n8 + n10;
            int n21 = n5 + n6 * _map_tw;
            int n22 = n8;
            while (n22 < n20) {
                int n23 = n21;
                int n24 = n7;
                while (n24 < n19) {
                    Level.CDB_DrawTile(n23, n24, n22);
                    n24 += 24;
                    ++n23;
                }
                n22 += 24;
                n21 += _map_tw;
            }
        }
        Level.CDB_DrawBackgroundEntities(n7, n8, n9, n10, n11, n12);
    }

    private static void CDB_InvalidateArea(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7;
        int n8 = n3;
        int n9 = n4;
        if (n8 * n9 > 9216) {
            if (n3 > n4) {
                Level.CDB_InvalidateArea(n, n2, n3 >> 1, n4, n5, n6, bl);
                Level.CDB_InvalidateArea(n + (n3 >> 1), n2, n3 - (n3 >> 1), n4, n5 + (n3 >> 1), n6, bl);
            } else {
                Level.CDB_InvalidateArea(n, n2, n3, n4 >> 1, n5, n6, bl);
                Level.CDB_InvalidateArea(n, n2 + (n4 >> 1), n3, n4 - (n4 >> 1), n5, n6 + (n4 >> 1), bl);
            }
            return;
        }
        int n10 = n;
        int n11 = n2;
        _gBB.setClip(n, n2, n3, n4);
        XSprite.SetGraphics(_gBB);
        int n12 = n5 / 24;
        int n13 = n6 / 24;
        int n14 = (n + n3 - 1) / 24 + 1 - n / 24;
        int n15 = (n2 + n4 - 1) / 24 + 1 - n2 / 24;
        int n16 = n12 + n13 * _map_tw;
        int n17 = n12 * 24 - n5 + n10;
        int n18 = n7 = n13 * 24 - n6 + n11;
        while (n18 < n9 + n11) {
            int n19 = n16;
            int n20 = n17;
            while (n20 < n8 + n10) {
                Level.CDB_DrawTile(n19, n20, n18);
                n20 += 24;
                ++n19;
            }
            n18 += 24;
            n16 += _map_tw;
        }
        Level.CDB_DrawBackgroundEntities(n10, n11, n8, n9, n5, n6);
        XSprite._op = 0;
    }

    private static void CDB_DrawBackgroundEntities(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Camera._nCamX;
        int n8 = Camera._nCamY;
        Camera._nCamX = n5 - n;
        Camera._nCamY = n6 - n2;
        Level.SetEntityClipWithBorder(n5, n6, n3, n4);
        Level.DrawCDBEntities(null);
        for (int i = 24; i < 48; ++i) {
            if (_entities_usage[i] != 1) continue;
            Building building = (Building)_entities[i];
            if (building._pos_x < n5 - 42 || building._pos_y < n6 - 35 || building._pos_x > n5 + n3 + 42 - -40 || building._pos_y > n6 + n4 + 35 - -40) continue;
            building.Draw(null);
        }
        Camera._nCamX = n7;
        Camera._nCamY = n8;
    }

    static void CDB_Draw(SDKGraphics sDKGraphics) {
        int n = Camera._nCamX - (_CDB_view_tx - _CDB_orig_tx) * 24;
        int n2 = Camera._nCamY - (_CDB_view_ty - _CDB_orig_ty) * 24;
        int n3 = Constants.CDB_W - n;
        if (n3 < 0) {
            int n4 = 0 + Constants.CDB_W - n;
            int n5 = Constants.CDB_H - n2;
            if (n5 < 0) {
                int n6 = 38 + Constants.CDB_H - n2;
                sDKGraphics.setClip(0, 38, Constants.SV_W, Constants.SV_H);
                sDKGraphics.drawImage(_imgBB, n4, n6, 0);
            } else if (n5 > Constants.SV_H) {
                int n7 = 38 - n2;
                sDKGraphics.setClip(0, 38, Constants.SV_W, Constants.SV_H);
                sDKGraphics.drawImage(_imgBB, n4, n7, 0);
            } else {
                int n8 = Constants.SV_H - n5;
                int n9 = 38 - n2;
                int n10 = 38 + Constants.CDB_H - n2;
                sDKGraphics.setClip(0, 38, Constants.SV_W, n5);
                sDKGraphics.drawImage(_imgBB, n4, n9, 0);
                sDKGraphics.setClip(0, n10, Constants.SV_W, n8);
                sDKGraphics.drawImage(_imgBB, n4, n10, 0);
            }
        } else if (n3 > Constants.SV_W) {
            int n11 = 0 - n;
            int n12 = Constants.CDB_H - n2;
            if (n12 < 0) {
                int n13 = 38 + Constants.CDB_H - n2;
                sDKGraphics.setClip(0, 38, Constants.SV_W, Constants.SV_H);
                sDKGraphics.drawImage(_imgBB, n11, n13, 0);
            } else if (n12 > Constants.SV_H) {
                int n14 = 38 - n2;
                sDKGraphics.setClip(0, 38, Constants.SV_W, Constants.SV_H);
                sDKGraphics.drawImage(_imgBB, n11, n14, 0);
            } else {
                int n15 = Constants.SV_H - n12;
                int n16 = 38 - n2;
                int n17 = 38 + Constants.CDB_H - n2;
                sDKGraphics.setClip(0, 38, Constants.SV_W, n12);
                sDKGraphics.drawImage(_imgBB, n11, n16, 0);
                sDKGraphics.setClip(0, n17, Constants.SV_W, n15);
                sDKGraphics.drawImage(_imgBB, n11, n17, 0);
            }
        } else {
            int n18 = Constants.SV_W - n3;
            int n19 = 0 - n;
            int n20 = 0 + Constants.CDB_W - n;
            int n21 = Constants.CDB_H - n2;
            if (n21 < 0) {
                int n22 = 38 + Constants.CDB_H - n2;
                sDKGraphics.setClip(0, 38, n3, Constants.SV_H);
                sDKGraphics.drawImage(_imgBB, n19, n22, 0);
                sDKGraphics.setClip(n20, 38, n18, Constants.SV_H);
                sDKGraphics.drawImage(_imgBB, n20, n22, 0);
            } else if (n21 > Constants.SV_H) {
                int n23 = 38 - n2;
                sDKGraphics.setClip(0, 38, n3, Constants.SV_H);
                sDKGraphics.drawImage(_imgBB, n19, n23, 0);
                sDKGraphics.setClip(n20, 38, n18, Constants.SV_H);
                sDKGraphics.drawImage(_imgBB, n20, n23, 0);
            } else {
                int n24 = Constants.SV_H - n21;
                int n25 = 38 - n2;
                int n26 = 38 + Constants.CDB_H - n2;
                sDKGraphics.setClip(0, 38, n3, n21);
                sDKGraphics.drawImage(_imgBB, n19, n25, 0);
                sDKGraphics.setClip(0, n26, n3, n24);
                sDKGraphics.drawImage(_imgBB, n19, n26, 0);
                sDKGraphics.setClip(n20, 38, n18, n21);
                sDKGraphics.drawImage(_imgBB, n20, n25, 0);
                sDKGraphics.setClip(n20, n26, n18, n24);
                sDKGraphics.drawImage(_imgBB, n20, n26, 0);
            }
        }
    }

    private static void CDB_DrawTile(int n, int n2, int n3) {
        _gBB.setColor(0);
        _gBB.fillRect(n2, n3, 24, 24);
        if ((n <<= 1) < 0 || n >= _map.length) {
            return;
        }
        int n4 = _map[n] & 0xFF;
        if (n4 != 255 && (n4 = _tilePalette[n4]) >= 0) {
            int n5 = _map[n + 1] & 0xFF;
            int n6 = n2;
            int n7 = n3;
            if ((n5 & 4) != 0) {
                if ((n5 & 1) != 0) {
                    n7 += 24;
                }
                if ((n5 & 1) == 0) {
                    n6 += 24;
                }
            } else {
                if ((n5 & 1) != 0) {
                    n6 += 24;
                }
                if ((n5 & 2) != 0) {
                    n7 += 24;
                }
            }
            GameImpl._sprites[_currentTileSet].DrawFrame(n4, n6, n7, n5);
        }
    }

    private static void CDB_DrawCollisionMask(int n, int n2, int n3) {
        int n4 = n / _map_tw * 24;
        int n5 = n % _map_tw * 24;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int n6 = Level.GetCollisionAt(n5 + j * 8, n4 + i * 8);
                SDKGraphics sDKGraphics = _gBB;
                if (n6 == 0) {
                    sDKGraphics.setColor(0x3300FF00);
                } else if (n6 == 1) {
                    sDKGraphics.setColor(0x33FF0000);
                } else if (n6 == 2) {
                    sDKGraphics.setColor(0x330000FF);
                } else if (n6 == 3) {
                    sDKGraphics.setColor(0x33FF00FF);
                }
                sDKGraphics.fillRect(n2 + j * 8, n3 + i * 8, 8, 8);
            }
        }
    }

    public static void _CDB_init(int n, int n2) {
        _CDB_separator = -1;
        _CDB_x = n;
        _CDB_y = n2;
        _CDB_xo = 0;
        _CDB_yo = 0;
        _CDB_oldX = n;
        _CDB_oldY = n2;
        _CDB_nrRegions = 0;
        Level._CDB_addRegion(n, n2, _CDB_xo, _CDB_yo, _CDB_w, _CDB_h);
    }

    public static void _CDB_moveX(int n) {
        int n2 = _CDB_xo;
        if ((_CDB_xo += n) >= _CDB_w) {
            Level._CDB_findXRegion(_CDB_x + _CDB_w, n2, _CDB_w - n2);
            Level._CDB_findXRegion(_CDB_x + _CDB_w + (_CDB_w - n2), 0, _CDB_xo -= _CDB_w);
            return;
        }
        if (_CDB_xo < 0) {
            Level._CDB_findXRegion(_CDB_x + n, _CDB_xo += _CDB_w, _CDB_w - _CDB_xo);
            Level._CDB_findXRegion(_CDB_x + n + _CDB_w - _CDB_xo, 0, n2);
            return;
        }
        if (n > 0) {
            Level._CDB_findXRegion(_CDB_x + _CDB_w, n2, n);
        } else {
            Level._CDB_findXRegion(_CDB_x + n, n2 + n, -n);
        }
    }

    public static void _CDB_findXRegion(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        Level._CDB_addRegion(n, _CDB_y, n2, _CDB_yo, n3, _CDB_h - _CDB_yo);
        if (_CDB_yo != 0) {
            Level._CDB_addRegion(n, _CDB_y + (_CDB_h - _CDB_yo), n2, 0, n3, _CDB_yo);
        }
    }

    public static void _CDB_moveY(int n) {
        int n2 = _CDB_yo;
        if ((_CDB_yo += n) >= _CDB_h) {
            Level._CDB_findYRegion(_CDB_y + _CDB_h, n2, _CDB_h - n2);
            Level._CDB_findYRegion(_CDB_y + _CDB_h + (_CDB_h - n2), 0, _CDB_yo -= _CDB_h);
            return;
        }
        if (_CDB_yo < 0) {
            Level._CDB_findYRegion(_CDB_y + n, _CDB_yo += _CDB_h, _CDB_h - _CDB_yo);
            Level._CDB_findYRegion(_CDB_y + n + _CDB_h - _CDB_yo, 0, n2);
            return;
        }
        if (n > 0) {
            Level._CDB_findYRegion(_CDB_y + _CDB_h, n2, n);
        } else {
            Level._CDB_findYRegion(_CDB_y + n, n2 + n, -n);
        }
    }

    public static void _CDB_findYRegion(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        Level._CDB_addRegion(_CDB_x, n, _CDB_xo, n2, _CDB_w - _CDB_xo, n3);
        if (_CDB_xo != 0) {
            Level._CDB_addRegion(_CDB_x + (_CDB_w - _CDB_xo), n, 0, n2, _CDB_xo, n3);
        }
    }

    public static void _CDB_addRegion(int n, int n2, int n3, int n4, int n5, int n6) {
        Region region = new Region();
        region.x = (short)n;
        region.y = (short)n2;
        region.xo = (short)n3;
        region.yo = (short)n4;
        region.w = (short)n5;
        region.h = (short)n6;
        Level._CDB_regions[Level._CDB_nrRegions++] = region;
    }

    public static void _CDB_update(int n, int n2) {
        int n3;
        _CDB_separator = 0;
        if (_bResetCDB) {
            Level._CDB_init(n, n2);
            _bResetCDB = false;
            return;
        }
        _CDB_nrRegions = 0;
        int n4 = n - _CDB_oldX;
        if (n4 <= -_CDB_w || n4 >= _CDB_w) {
            Level._CDB_init(n, n2);
            return;
        }
        if (n4 != 0) {
            Level._CDB_moveX(n4);
        }
        _CDB_x = n;
        _CDB_oldX = n;
        if (_CDB_separator != -1) {
            _CDB_separator = _CDB_nrRegions;
        }
        if ((n3 = n2 - _CDB_oldY) <= -_CDB_h || n3 >= _CDB_h) {
            Level._CDB_init(n, n2);
            return;
        }
        if (n3 != 0) {
            Level._CDB_moveY(n3);
        }
        _CDB_y = n2;
        _CDB_oldY = n2;
    }

    public static void _CDB_blitToScreen(SDKGraphics sDKGraphics) {
        if (_CDB_w - _CDB_xo != 0) {
            if (_CDB_h - _CDB_yo != 0) {
                sDKGraphics.drawRegion(_imgBB, _CDB_xo, _CDB_yo, _CDB_w - _CDB_xo, _CDB_h - _CDB_yo, 0, 0, 38, 20);
            }
            if (_CDB_yo != 0) {
                sDKGraphics.drawRegion(_imgBB, _CDB_xo, 0, _CDB_w - _CDB_xo, _CDB_yo, 0, 0, _CDB_h - _CDB_yo + 38, 20);
            }
        }
        if (_CDB_xo != 0) {
            if (_CDB_h - _CDB_yo != 0) {
                sDKGraphics.drawRegion(_imgBB, 0, _CDB_yo, _CDB_xo, _CDB_h - _CDB_yo, 0, _CDB_w - _CDB_xo + 0, 38, 20);
            }
            if (_CDB_yo != 0) {
                sDKGraphics.drawRegion(_imgBB, 0, 0, _CDB_xo, _CDB_yo, 0, _CDB_w - _CDB_xo + 0, _CDB_h - _CDB_yo + 38, 20);
            }
        }
    }

    static void __MAP() {
    }

    static void PATHFINDER__() {
    }

    public static void Init() {
        _tasks_current = 0;
        _tasks_last = 0;
        _bAStarThreadRunning = false;
        _bAStarSignalStop = false;
        _open_list_count = 0;
        _node_data_list_count = 0;
        _tasks_data = null;
        if (_results_data != null) {
            for (int i = 0; i < 20; ++i) {
                Level._results_data[i] = null;
            }
            _results_data = null;
        }
        System.gc();
        _tasks_data = new short[120];
        _results_data = new byte[20][128];
        _cache_start_tileX = -1;
        _cache_start_tileY = -1;
        _cache_finish_tileX = -1;
        _cache_finish_tileY = -1;
        _cache_result_count = 0;
        Level.Region_Init();
    }

    public static void Update() {
        if (_bAStarThreadRunning) {
            try {
                Level.AStar_MainLoop();
            }
            catch (Exception exception) {
                Level.AStar_SignalStop();
                Level.AbortPath(_tasks_current);
            }
        } else if (_tasks_current != _tasks_last) {
            while (_tasks_current != _tasks_last && _tasks_data[(_tasks_current = (_tasks_current + 6) % 120) + 0] == -1) {
            }
            if (_tasks_data[_tasks_current + 0] != -1) {
                Level.AStar_DoTask(_tasks_current);
            }
        }
    }

    public static void Draw(SDKGraphics sDKGraphics) {
    }

    static void TASK_MANAGEMENT__() {
    }

    public static int RequestPath(int n, int n2, int n3, int n4) {
        int n5 = Level.GetRegionAt(n, n2);
        int n6 = Level.GetRegionAt(n3, n4);
        if (n5 != -1 && n6 != -1 && n5 != n6) {
            return -1;
        }
        int n7 = (_tasks_last + 6) % 120;
        if (n7 == _tasks_current) {
            return -1;
        }
        _tasks_last = (short)n7;
        Level._tasks_data[n7 + 0] = 0;
        Level._tasks_data[n7 + 1] = (short)n;
        Level._tasks_data[n7 + 2] = (short)n2;
        Level._tasks_data[n7 + 3] = (short)n3;
        Level._tasks_data[n7 + 4] = (short)n4;
        Level._tasks_data[n7 + 5] = -1;
        return n7;
    }

    public static int UpdatePathData(int n, int n2, int n3, int n4, int n5) {
        if (n < 0 || n >= 120) {
            return -1;
        }
        short s = _tasks_data[n + 0];
        if (s == 0) {
            Level._tasks_data[n + 1] = (short)n2;
            Level._tasks_data[n + 2] = (short)n3;
            Level._tasks_data[n + 3] = (short)n4;
            Level._tasks_data[n + 4] = (short)n5;
            return n;
        }
        Level.AbortPath(n);
        return Level.RequestPath(n2, n3, n4, n5);
    }

    public static void AbortPath(int n) {
        short s = _tasks_data[n + 0];
        if (s == 1) {
            Level.AStar_SignalStop();
        }
        Level._tasks_data[n + 0] = -1;
    }

    public static int GetPathStatus(int n) {
        return _tasks_data[n + 0];
    }

    public static byte[] GetPathData(int n) {
        return _results_data[n / 6];
    }

    public static int GetPathWaypoints(int n, byte[] byArray) {
        byte[] byArray2 = _results_data[n / 6];
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = _tasks_data[n + 5];
        if (n5 > n2) {
            n3 = n5 - n2;
        }
        while (n3 < n5) {
            byArray[n4] = byArray2[n3];
            ++n3;
            ++n4;
        }
        return n4 - 2;
    }

    public static boolean CanUseCachedResult() {
        int n = Math.abs(_cache_start_tileX - _start_tileX) + Math.abs(_cache_start_tileY - _start_tileY);
        if (n > 5) {
            return false;
        }
        int n2 = Math.abs(_cache_finish_tileX - _finish_tileX) + Math.abs(_cache_finish_tileY - _finish_tileY);
        if (n2 > 5) {
            return false;
        }
        if (!Level.NoLineOfSightCollisionBetween(null, null, 4, _cache_start_tileX, _cache_start_tileY, _start_tileX, _start_tileY)) {
            return false;
        }
        return Level.NoLineOfSightCollisionBetween(null, null, 4, _cache_finish_tileX, _cache_finish_tileY, _finish_tileX, _finish_tileY);
    }

    public static int CopyCachedResult(int n) {
        byte[] byArray = _results_data[n / 6];
        int n2 = 0;
        byArray[n2++] = (byte)_finish_tileX;
        byArray[n2++] = (byte)_finish_tileY;
        int n3 = 0;
        while (n3 < _cache_result_count) {
            byArray[n2] = _cache_result[n3];
            byArray[n2 + 1] = _cache_result[n3 + 1];
            n3 += 2;
            n2 += 2;
        }
        return n2;
    }

    static void __TASK_MANAGEMENT() {
    }

    static void ASTAR__() {
    }

    public static void AStar_DoTask(int n) {
        Level._tasks_data[n + 0] = 1;
        _start_tileX = _tasks_data[n + 1] / 8;
        _start_tileY = _tasks_data[n + 2] / 8;
        _start_tileIndex = _start_tileY * _coll_map_tw + _start_tileX;
        _finish_tileX = _tasks_data[n + 3] / 8;
        _finish_tileY = _tasks_data[n + 4] / 8;
        if (!Level.ValidateCollisionTile(_start_tileX, _start_tileY, 7)) {
            return;
        }
        _start_tileX = _validTileX;
        _start_tileY = _validTileY;
        _start_tileIndex = _start_tileY * _coll_map_tw + _start_tileX;
        if (!Level.ValidateCollisionTile(_finish_tileX, _finish_tileY, 7)) {
            return;
        }
        _finish_tileY = _validTileY;
        _finish_tileX = _validTileX;
        _finish_tileIndex = _finish_tileY * _coll_map_tw + _finish_tileX;
        if (_start_tileIndex == _finish_tileIndex) {
            Level._tasks_data[n + 0] = 2;
            return;
        }
        if (Level.CanUseCachedResult()) {
            Level._tasks_data[n + 0] = 2;
            Level._tasks_data[n + 5] = (short)Level.CopyCachedResult(n);
            return;
        }
        Level.AStar_Start();
    }

    public static void AStar_Start() {
        _bAStarThreadRunning = true;
        _bAStarSignalStop = false;
        _frames_left_per_task = 10;
        int n = Level.AddNodeData(_start_tileIndex, 0, 0, -1);
        Level.AddPointerToOpenList(n);
    }

    private static void AStar_SignalStop() {
        _bAStarSignalStop = true;
    }

    public static void AStar_Reset() {
        _open_list_count = 0;
        _node_data_list_count <<= 2;
        for (int i = 0; i < _node_data_list_count; i += 4) {
            if (_node_data_list[i + 0] < 0 || _node_data_list[i + 0] >= _coll_map_size) continue;
            short s = _node_data_list[i + 0];
            _coll_map[s] = (byte)(_coll_map[s] & 0x7F);
        }
        _node_data_list_count = 0;
    }

    public static void AStar_MainLoop() {
        long l = -1L;
        long l2 = 40L;
        int n = -1;
        if (_bAStarThreadRunning && _frames_left_per_task == 0) {
            Level._tasks_data[Level._tasks_current + 0] = 3;
            Level.AStar_SignalStop();
        }
        --_frames_left_per_task;
        while (_bAStarThreadRunning) {
            if (_bAStarSignalStop) {
                _bAStarThreadRunning = false;
                _bAStarSignalStop = false;
                break;
            }
            long l3 = System.currentTimeMillis();
            if (l != -1L) {
                l2 -= l3 - l;
            }
            if (l2 < 0L) break;
            l = l3;
            int n2 = 0;
            int n3 = Level.FindBestNodeInOpenList();
            if (n3 == -1) {
                Level.AStar_SignalStop();
                Level.AbortPath(_tasks_current);
                continue;
            }
            n2 = Level.RemoveOpenNodeByIndex(n3);
            if (_node_data_list[n2 + 0] < 0 || _node_data_list[n2 + 0] >= _coll_map_size) {
                Level.AStar_SignalStop();
                Level.AbortPath(_tasks_current);
                continue;
            }
            short s = _node_data_list[n2 + 0];
            _coll_map[s] = (byte)(_coll_map[s] | 0x80);
            n3 = _node_data_list[n2 + 0];
            if (n3 == _finish_tileIndex) {
                n = n2;
                Level.AStar_Finish(n);
                continue;
            }
            short s2 = _node_data_list[n2 + 2];
            int n4 = _node_data_list[n2 + 1] - s2;
            int n5 = n3 % _coll_map_tw;
            int n6 = n3 / _coll_map_tw;
            int n7 = n3 - _coll_map_tw - 1;
            int n8 = -1;
            while (n8 < 2) {
                int n9 = -1;
                while (n9 < 2) {
                    if (n9 != 0 || n8 != 0) {
                        int n10;
                        int n11 = n5 + n9;
                        int n12 = n6 + n8;
                        if (n11 >= 0 && n12 >= 0 && n11 < _coll_map_tw && n12 < _coll_map_th && n7 >= 0 && n7 < _coll_map_size && (_coll_map[n7] & 0x80) == 0 && (n10 = _coll_map[n7] & 0x7F) <= 4) {
                            int n13;
                            int n14 = 0;
                            n14 = n9 == 0 || n8 == 0 ? n4 + 5 : n4 + 7;
                            int n15 = 7 * Math.max(Math.abs(n11 - _finish_tileX), Math.abs(n12 - _finish_tileY));
                            int n16 = Level.FindNodeInOpenList(n7);
                            if (n16 != -1) {
                                n13 = _open_list[n16];
                                if (_node_data_list[n13 + 1] > n14 + n15) {
                                    Level._node_data_list[n13 + 1] = (short)(n14 + n15);
                                    Level._node_data_list[n13 + 2] = (short)n15;
                                    Level._node_data_list[n13 + 3] = (short)n2;
                                }
                            } else {
                                n13 = Level.AddNodeData(n7, n14 + n15, n15, n2);
                                if (n13 != -1) {
                                    Level.AddPointerToOpenList(n13);
                                }
                            }
                        }
                    }
                    ++n9;
                    ++n7;
                }
                ++n8;
                n7 += _coll_map_tw - 3;
            }
        }
        if (!_bAStarThreadRunning) {
            Level.AStar_Reset();
        }
    }

    public static void AStar_Finish(int n) {
        Level._tasks_data[Level._tasks_current + 0] = 2;
        Level.AStar_SignalStop();
        byte[] byArray = _results_data[_tasks_current / 6];
        byte[] byArray2 = null;
        byArray2 = _cache_result;
        _cache_start_tileX = _start_tileX;
        _cache_start_tileY = _start_tileY;
        _cache_finish_tileX = _finish_tileX;
        _cache_finish_tileY = _finish_tileY;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        while (n5 != -1) {
            short s = _node_data_list[n5 + 0];
            int n6 = s % _coll_map_tw;
            int n7 = s / _coll_map_tw;
            byArray[n2] = (byte)n6;
            byArray[n2 + 1] = (byte)n7;
            byArray2[n2] = (byte)n6;
            byArray2[n2 + 1] = (byte)n7;
            if (n2 == 2) {
                n3 = n6 - byArray[n2 - 2];
                n4 = n7 - byArray[n2 - 1];
            } else if (n2 > 2) {
                int n8 = n6 - byArray[n2 - 2];
                int n9 = n7 - byArray[n2 - 1];
                if (n8 == n3 && n9 == n4) {
                    byArray[n2 - 2] = (byte)n6;
                    byArray[n2 - 1] = (byte)n7;
                    byArray2[n2 - 2] = (byte)n6;
                    byArray2[n2 - 1] = (byte)n7;
                    n2 -= 2;
                } else {
                    byArray[n2] = (byte)n6;
                    byArray[n2 + 1] = (byte)n7;
                    byArray2[n2] = (byte)n6;
                    byArray2[n2 + 1] = (byte)n7;
                    n3 = n8;
                    n4 = n9;
                }
            }
            if ((n2 += 2) >= 128) break;
            n5 = _node_data_list[n5 + 3];
        }
        Level._tasks_data[Level._tasks_current + 5] = (short)n2;
        _cache_result_count = n2;
    }

    public static int AddNodeData(int n, int n2, int n3, int n4) {
        if (_node_data_list_count >= 1200) {
            Level.AStar_SignalStop();
            return -1;
        }
        int n5 = _node_data_list_count << 2;
        Level._node_data_list[n5 + 0] = (short)n;
        Level._node_data_list[n5 + 1] = (short)n2;
        Level._node_data_list[n5 + 2] = (short)n3;
        Level._node_data_list[n5 + 3] = (short)n4;
        ++_node_data_list_count;
        return n5;
    }

    public static void PushOpenPointer(int n) {
        short s = _node_data_list[n + 1];
        short s2 = _node_data_list[n + 2];
        short s3 = 0;
        short s4 = 0;
        for (int i = ++_open_list_count; i != 1 && (s < (s3 = _node_data_list[(s4 = _open_list[i >> 1]) + 1]) || s == s3 && s2 < _node_data_list[s4 + 2]); i >>= 1) {
            Level._open_list[i] = _open_list[i >> 1];
        }
        Level._open_list[i] = (short)n;
    }

    public static short PopBestOpenPointer() {
        short s = _open_list[1];
        short s2 = _open_list[_open_list_count];
        --_open_list_count;
        int n = 1;
        while (n << 1 <= _open_list_count) {
            int n2 = n << 1;
            short s3 = _open_list[n2];
            short s4 = _open_list[n2 + 1];
            if (n2 < _open_list_count && _node_data_list[s3 + 1] > _node_data_list[s4 + 1]) {
                ++n2;
            }
            if (_node_data_list[s2 + 1] <= _node_data_list[s4 + 1]) break;
            Level._open_list[n] = _open_list[n2];
            n = n2;
        }
        Level._open_list[n] = s2;
        return s;
    }

    public static int AddPointerToOpenList(int n) {
        if (_open_list_count >= 400) {
            Level.AbortPath(_tasks_current);
            return -1;
        }
        Level._open_list[Level._open_list_count++] = (short)n;
        return _open_list_count - 1;
    }

    public static int FindBestNodeInOpenList() {
        int n = -1;
        short s = 0;
        short s2 = 0;
        for (int i = 0; i < _open_list_count; ++i) {
            short s3 = _open_list[i];
            short s4 = _node_data_list[s3 + 2];
            short s5 = _node_data_list[s3 + 1];
            if (n != -1 && s5 >= s && (s5 != s || s4 >= s2)) continue;
            s = s5;
            s2 = s4;
            n = i;
        }
        return n;
    }

    public static int FindNodeInOpenList(int n) {
        for (int i = _open_list_count - 1; i >= 0; --i) {
            if (_node_data_list[_open_list[i] + 0] != n) continue;
            return i;
        }
        return -1;
    }

    public static int RemoveOpenNodeByIndex(int n) {
        short s = _open_list[n];
        if (_open_list_count > 1) {
            Level._open_list[n] = _open_list[_open_list_count - 1];
        }
        --_open_list_count;
        return s;
    }

    static void __ASTAR() {
    }

    static void REGIONS__() {
    }

    static void Region_Init() {
        _regions_count = 0;
    }

    static void Region_Load(SDKInputStream sDKInputStream) throws IOException {
        short s = sDKInputStream.readShort();
        short s2 = sDKInputStream.readShort();
        short s3 = sDKInputStream.readShort();
        short s4 = sDKInputStream.readShort();
        short s5 = sDKInputStream.readShort();
        int n = sDKInputStream.read() & 0xFF;
        Level.Region_Add(s, s2, s3, s4, s5, n);
    }

    static void Region_Add(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = _regions_count * 6;
        Level._regions[n7 + 0] = (short)n;
        Level._regions[n7 + 1] = (short)n2;
        Level._regions[n7 + 2] = (short)n3;
        Level._regions[n7 + 3] = (short)(n2 + n4);
        Level._regions[n7 + 4] = (short)(n3 + n5);
        Level._regions[n7 + 5] = (short)n6;
        ++_regions_count;
    }

    static void Region_Set(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = _regions_count * 6;
        for (int i = 0; i < n7; i += 6) {
            if (_regions[i + 0] != n) continue;
            Level._regions[i + 1] = (short)n2;
            Level._regions[i + 2] = (short)n3;
            Level._regions[i + 3] = (short)(n2 + n4);
            Level._regions[i + 4] = (short)(n3 + n5);
            Level._regions[i + 5] = (short)n6;
            break;
        }
    }

    static void Region_Delete(int n) {
        int n2 = _regions_count * 6;
        for (int i = 0; i < n2; i += 6) {
            int n3;
            if (_regions[i + 0] != n) continue;
            if (--_regions_count <= 0 || (n3 = _regions_count * 6) == i) break;
            Level._regions[i + 0] = _regions[n3 + 0];
            Level._regions[i + 1] = _regions[n3 + 1];
            Level._regions[i + 2] = _regions[n3 + 2];
            Level._regions[i + 3] = _regions[n3 + 3];
            Level._regions[i + 4] = _regions[n3 + 4];
            Level._regions[i + 5] = _regions[n3 + 5];
            break;
        }
    }

    static void Region_Draw(SDKGraphics sDKGraphics) {
        int n = _regions_count * 6;
        for (int i = 0; i < n; i += 6) {
            short s = _regions[i + 1];
            short s2 = _regions[i + 2];
            int n2 = _regions[i + 3] - s;
            int n3 = _regions[i + 4] - s2;
            short s3 = _regions[i + 5];
            sDKGraphics.setColor(65280);
            sDKGraphics.drawRect(0 + s - Camera._nCamX, 38 + s2 - Camera._nCamY, n2, n3);
            SDKUtils.setFont(GameImpl.fonts[0]);
            GameImpl.DrawNumber(s3, 0 + s - Camera._nCamX, 38 + s2 - Camera._nCamY, 0);
        }
    }

    static int GetRegionAt(int n, int n2) {
        int n3 = -1;
        int n4 = _regions_count * 6;
        for (int i = 0; i < n4; i += 6) {
            if (n < _regions[i + 1] || n > _regions[i + 3] || n2 < _regions[i + 2] || n2 > _regions[i + 4]) continue;
            n3 = _regions[i + 5];
            break;
        }
        return n3;
    }

    static void __REGIONS() {
    }

    static void __PATHFINDER() {
    }

    static {
        _groupLeaders = new int[3];
        _paused = 0;
        _old_paused = 0;
        _enableChangeSK = true;
        _enableSelectionChange = true;
        _statistics = new int[8];
        _bAreBuildingsDisabled = false;
        _attackSoundPlayed = false;
        _firstAttackFrame = 0;
        _lastAttackSoundFrame = 0;
        _lastSpawnedIndex = -1;
        _fixed_ent_data = null;
        _fixed_ent_list = null;
        _fixedListPointer = 0;
        _fixedDataPointer = 0;
        _nrFixedLevelEntities = 0;
        _lastCellOffset = 0;
        _fixed_w_array = new int[220];
        _fixed_clip_array = new int[220];
        _fixed_clip_count = 0;
        _dynamic_w_array = new int[120];
        _dynamic_entities_clip = new int[120];
        _dynamic_entities_clip_count = 0;
        _cmaps_header = new short[68];
        _cmaps = new byte[17][];
        _bCodeMovieState = false;
        _hud_state_storm = 0;
        _currentTileSet = -1;
        _xx = new int[]{0, -1, 0, 1, -1, -1, 1, 1};
        _yy = new int[]{-1, 0, 1, 0, -1, 1, 1, -1};
        _invalidator_rect = new int[5];
        _bInvalidatorCDB = false;
        _CDB_regions = new Region[24];
        _tasks_data = new short[120];
        _tasks_current = 0;
        _tasks_last = 0;
        _results_data = new byte[20][128];
        _cache_result = new byte[128];
        _bAStarThreadRunning = false;
        _bAStarSignalStop = false;
        _node_data_list = new short[4800];
        _node_data_list_count = 0;
        _open_list = new short[400];
        _open_list_count = 0;
        _start_tileX = 0;
        _start_tileY = 0;
        _start_tileIndex = 0;
        _finish_tileX = 0;
        _finish_tileY = 0;
        _finish_tileIndex = 0;
        _cache_start_tileX = 0;
        _cache_start_tileY = 0;
        _cache_finish_tileX = 0;
        _cache_finish_tileY = 0;
        _frames_left_per_task = 0;
        _regions = new short[60];
    }
}

