/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Building;
import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.Hud;
import com.ea.game.Level;
import com.ea.game.PathfinderConstants;
import com.ea.game.SpriteConstants;
import com.ea.game.XSprite;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKInputStream;
import java.io.IOException;

public class Unit
extends Entity
implements Constants,
PathfinderConstants,
SpriteConstants {
    public static final int[][] _units_damage_matrix = new int[][]{{64, 32, 16, 16}, {32, 64, 32, 64}, {16, 64, 32, 16}, {64, 64, 64, 64}, {64, 0, 0, 0}};
    byte _subtype;
    byte _allegiance;
    short _life;
    short _initial_life;
    short _speed;
    int _sight_range;
    int _attack_range;
    public int _fire_range;
    int _fire_rate;
    int _damage;
    int _armour;
    int _bullet_type;
    byte _veterancy_lvl;
    byte _self_heal_delay;
    int _experience_for_lvlup;
    int _experience;
    short _dmg_increase;
    short _fire_rate_increase;
    short _self_heal;
    short _self_heal_start_lvl;
    byte _group;
    boolean _bIgnoreCollisions;
    boolean _bCanFireMove;
    boolean _bSelected;
    boolean _bTargeted;
    boolean _bHasTurret;
    byte _turretOrientation;
    int _turret_flags;
    int _turret_sprite;
    int _turret_crt_anim;
    int _turret_crt_aframe;
    int _turret_crt_aframe_time;
    int[] _collisionBox;
    byte _scatter_dist;
    int _targetPointer;
    public byte[] _waypoints;
    int _path_handle;
    public int _path_cursor;
    int _action;
    short _rallyX;
    short _rallyY;
    boolean _noticed;
    short _unit_ai_timer;
    short _timer2;
    short _self_heal_timer;
    short _stealth_timer;
    short _firing_timer;
    short _slow_timer;
    boolean _bMoving;
    int _splash_damage;
    int _proxyPointer;
    int _gathered_damage;
    short _crawling_timer;
    byte _force_crawl;
    boolean _bMoveDie;
    int _attack_capabilities;
    int _pathPointer;
    int _patrolTimer;
    public boolean _requested_action = false;

    public Unit(int n) {
        super(n);
        this.Clean();
    }

    public void Clean() {
        int n;
        this._id = 0;
        this._pos_x = 0;
        this._pos_y = 0;
        this._subtype = (byte)-1;
        this._allegiance = 0;
        this._orientation = 0;
        this._noticed = false;
        this._life = 0;
        this._initial_life = 0;
        this._speed = 0;
        this._bHasTurret = false;
        this._bCanFireMove = false;
        this._bSelected = false;
        this._group = 0;
        this._turret_sprite = -1;
        this._turret_crt_anim = -1;
        this._turret_crt_aframe = -1;
        this._turret_crt_aframe_time = -1;
        this._type = 5;
        if (this._collisionBox == null) {
            this._collisionBox = new int[4];
        } else {
            this._collisionBox[0] = 0;
            this._collisionBox[1] = 0;
            this._collisionBox[2] = 0;
            this._collisionBox[3] = 0;
        }
        if (this._sdata == null) {
            this._sdata = new short[4];
        } else {
            for (n = 0; n < 4; ++n) {
                this._sdata[n] = 0;
            }
        }
        this._bMoving = false;
        this._targetPointer = -1;
        this._action = 0;
        if (this._waypoints == null) {
            this._waypoints = new byte[64];
        } else {
            for (n = 0; n < 64; ++n) {
                this._waypoints[n] = 0;
            }
        }
        this._path_handle = -1;
        this._path_cursor = -1;
        this._rallyX = (short)-1;
        this._rallyY = (short)-1;
        this._veterancy_lvl = 0;
        this._self_heal_delay = 1;
        this._experience_for_lvlup = 1;
        this._experience = 0;
        this._dmg_increase = 0;
        this._fire_rate_increase = 0;
        this._self_heal = 0;
        this._self_heal_start_lvl = 0;
        this._self_heal_timer = 0;
        this._bIgnoreCollisions = false;
        this._splash_damage = 0;
        this._firing_timer = 0;
        this._proxyPointer = -1;
        this._gathered_damage = 0;
        this._crawling_timer = 0;
        this._force_crawl = 0;
        this._bMoveDie = false;
        this._attack_capabilities = 0;
        this._flags = 0;
        this._pathPointer = -1;
        this._patrolTimer = 0;
    }

    public void Unit_Destructor() {
        this._pos_x = -1;
        this._pos_y = -1;
        this._veterancy_lvl = 0;
        this._experience = 0;
        this._firing_timer = 0;
        this._proxyPointer = -1;
        this._attack_capabilities = 0;
    }

    public void Unit_Load(SDKInputStream sDKInputStream) throws IOException {
        this._bSelected = false;
        this._subtype = (byte)(sDKInputStream.read() & 0xFF);
        this._allegiance = (byte)(sDKInputStream.read() & 0xFF);
        this._orientation = (byte)(sDKInputStream.read() & 0xFF);
        this._group = (byte)(sDKInputStream.read() & 0xFF);
        this._veterancy_lvl = (byte)(sDKInputStream.read() & 0xFF);
    }

    public void Unit_Init() {
        if (this._subtype == 4 || this._subtype == 5) {
            this._veterancy_lvl = (byte)2;
        }
        int n = this._subtype * 27;
        this._initial_life = this._life = Level._unit_stats[n + 0];
        this._speed = Level._unit_stats[n + 1];
        this._sight_range = Level._unit_stats[n + 2];
        this._attack_range = Level._unit_stats[n + 3];
        this._fire_range = Level._unit_stats[n + 4];
        this._fire_rate = Level._unit_stats[n + 5];
        this._armour = Level._unit_stats[n + 7];
        this._bullet_type = Level._unit_stats[n + 8];
        this._damage = Level._unit_stats[n + 6];
        this._experience = 0;
        this._experience_for_lvlup = Level._unit_stats[n + 12];
        this._dmg_increase = Level._unit_stats[n + 13];
        this._fire_rate_increase = Level._unit_stats[n + 14];
        this._self_heal = Level._unit_stats[n + 15];
        this._self_heal_start_lvl = Level._unit_stats[n + 16];
        this._self_heal_delay = (byte)Level._unit_stats[n + 17];
        this._splash_damage = Level._unit_stats[n + 22];
        this._attack_capabilities = Level._unit_stats[n + 26];
        this._bIgnoreCollisions = Level._unit_stats[n + 18] == 1;
        this._timer = 0;
        this._timer2 = 0;
        this._unit_ai_timer = 0;
        this._self_heal_timer = 0;
        this._stealth_timer = 0;
        this._slow_timer = 0;
        this._bHasTurret = false;
        this._bCanFireMove = true;
        this._bSelected = false;
        this._scatter_dist = (byte)4;
        this._requested_action = false;
        Level.Group_Add(this, this._group);
        switch (this._subtype) {
            case 0: {
                this._sprite = 2;
                break;
            }
            case 2: {
                this._sprite = 7;
                break;
            }
            case 1: {
                this._bHasTurret = true;
                this._sprite = 3;
                this._turret_sprite = 3;
                this._turretOrientation = this._orientation;
                this._scatter_dist = (byte)6;
                break;
            }
            case 3: {
                this._bHasTurret = true;
                this._sprite = 10;
                this._turret_sprite = 10;
                this._turretOrientation = this._orientation;
                this._scatter_dist = (byte)6;
                break;
            }
            case 4: {
                this._sprite = 8;
                break;
            }
            case 5: {
                this._sprite = 9;
                break;
            }
            case 6: {
                this._sprite = 12;
                break;
            }
            case 7: {
                this._sprite = 15;
                this._bCanFireMove = false;
                break;
            }
            case 8: {
                this._sprite = 16;
                this._bCanFireMove = false;
                this._proxyPointer = -1;
                this._scatter_dist = (byte)6;
                break;
            }
            case 9: {
                this._sprite = 17;
                this._bCanFireMove = false;
                this._proxyPointer = -1;
                this._scatter_dist = (byte)6;
            }
        }
        this._bTargeted = false;
        this._path_handle = -1;
        this._path_cursor = -1;
        this._noticed = false;
        this._bMoving = false;
        this._firing_timer = (short)(this._fire_rate + 1);
        this._proxyPointer = -1;
        this._gathered_damage = 0;
        this._crawling_timer = 0;
        this._force_crawl = 0;
        this._bMoveDie = false;
    }

    public void Unit_Init2() {
        this._action = -1;
        Level.IncEntityNo(5, this._subtype, this._allegiance);
        if (this._allegiance == 0) {
            ++Level._player_command_points;
        }
        if (this._allegiance == 1) {
            ++Level._ai_command_points;
        }
        this.DoAction(0, -1, -1, -1);
        Entity.CheckTriggers(this, this._pos_x, this._pos_y);
        this.SetCollisionBox();
    }

    public void Unit_Update() {
        if ((this._flags & 8) != 0) {
            return;
        }
        if (this._state != 3 && this._state != 4) {
            this._firing_timer = (short)(this._firing_timer + 1);
            if (this._firing_timer > this._fire_rate * 2) {
                this._firing_timer = (short)(this._fire_rate * 2);
            }
            this._self_heal_timer = (short)(this._self_heal_timer + 1);
            if (this._self_heal_timer > 14 * this._self_heal_delay) {
                this.DoSelfHeal();
                this._self_heal_timer = 0;
            }
            if (this._crawling_timer > 0 && this._force_crawl == 0) {
                this._crawling_timer = (short)(this._crawling_timer - 1);
                if (this._crawling_timer == 0) {
                    this.RefreshCrawlingAnim();
                }
            }
            this._slow_timer = (short)(this._slow_timer - 1);
            if (this._slow_timer < 0) {
                this._slow_timer = 0;
            }
        }
        switch (this._state) {
            case 0: {
                this.DoStay();
                break;
            }
            case 1: {
                this.DoMove();
                break;
            }
            case 2: {
                this.DoFire();
                break;
            }
            case 3: {
                this.DoDie();
                break;
            }
            case 4: {
                this.DoDeath();
                break;
            }
            case 5: {
                this.DoWaitForPath();
                break;
            }
            case 6: {
                this.DoDemolish();
                break;
            }
            case 7: {
                this.DoLauchBullets();
            }
        }
        if (this._sprite >= 0) {
            this.UpdateCrtAnim();
        }
        if (this._bHasTurret && this._turret_sprite >= 0) {
            this.Turret_UpdateCrtAnim();
        }
        switch (this._action) {
            case 1: {
                this.Unit_AI_Guard();
                break;
            }
            case 2: {
                this.Unit_AI_Goto();
                break;
            }
            case 3: {
                this.Unit_AI_Attack();
                break;
            }
            case 5: {
                this.Unit_AI_Demolish();
                break;
            }
            case 6: {
                this.Unit_AI_Patrol();
            }
        }
    }

    public void Unit_Draw_Lines(SDKGraphics sDKGraphics) {
        Entity entity;
        if (this._life <= 0) {
            return;
        }
        if (!this._requested_action) {
            return;
        }
        if (this._bSelected && this._action == 2 && this._rallyX != -1 && this._rallyY != -1 && this._allegiance == 0 && Hud._hud_state != 5) {
            sDKGraphics.setColor(0xFFFFFF);
            sDKGraphics.drawLine(0 + this._pos_x - Camera._nCamX, 38 + this._pos_y - Camera._nCamY, 0 + this._rallyX - Camera._nCamX, 38 + this._rallyY - Camera._nCamY);
        }
        if ((entity = Level.GetEntitySafe(this._targetPointer)) != null && this._allegiance == 0 && Hud._hud_state != 5) {
            sDKGraphics.setColor(0xFF0000);
            sDKGraphics.drawLine(0 + this._pos_x - Camera._nCamX, 38 + this._pos_y - Camera._nCamY, 0 + entity._pos_x - Camera._nCamX, 38 + entity._pos_y - Camera._nCamY);
        }
    }

    public void Unit_Draw(SDKGraphics sDKGraphics) {
        if ((this._flags & 0x10) != 0) {
            return;
        }
        if (this._bSelected) {
            this.DrawSelection(sDKGraphics);
        }
        XSprite xSprite = GameImpl._sprites[this._sprite];
        this.SetPalette(xSprite);
        this.DrawCrtAnim(sDKGraphics);
        if (this._bHasTurret) {
            this.Turret_DrawCrtAnim(sDKGraphics);
        }
        if (this._bSelected || this._bTargeted) {
            this.DrawLife(sDKGraphics);
        }
        this._bTargeted = false;
        this.DrawSlowEffect(sDKGraphics);
        if (this._veterancy_lvl != 0) {
            this.DrawVeterancy(sDKGraphics);
        }
    }

    private void SetPalette(XSprite xSprite) {
        int n = 0;
        xSprite.SetCurrentPalette(n);
    }

    public int GetUsedPalette() {
        int n = 1;
        return n;
    }

    public boolean IsSelectable(boolean bl) {
        if (this._life <= 0) {
            return false;
        }
        if (bl) {
            return this._allegiance == 0 && (this._flags & 0x400) == 0;
        }
        if (this._allegiance == 1 && (this._flags & 0x8000) != 0) {
            return false;
        }
        return (this._flags & 0x400) == 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void SetState(int n) {
        if (this._state == n) {
            return;
        }
        switch (this._state) {
            case 0: {
                this._bMoveDie = false;
                break;
            }
            case 1: {
                this._bMoveDie = true;
                break;
            }
            case 2: {
                if (!this._bMoving) break;
                this._bMoveDie = true;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
        }
        this._z_order = 3;
        this._flags &= 0xFFFFF7FF;
        this._turret_flags &= 0xFFFFF7FF;
        switch (n) {
            case 0: 
            case 5: {
                this.SetStayAnim();
                break;
            }
            case 1: {
                this.SetMoveAnim();
                this._timer2 = 0;
                this._stealth_timer = 0;
                break;
            }
            case 2: {
                this.SetStayAnim();
                this._stealth_timer = 0;
                break;
            }
            case 3: {
                this.SetDieAnim();
                if (!this.IsInfantry()) {
                    Entity entity = Level.SpawnEntity(2);
                    entity.Decorator_Init(this._pos_x, this._pos_y, 5, 3, 512, 4);
                }
                this._stealth_timer = 0;
                this._slow_timer = 0;
                break;
            }
            case 4: {
                Entity.CheckTriggers(this, this._pos_x, this._pos_y);
                this._z_order = 1;
                this._timer = Level.GetUnitStats(this._subtype, 9);
                this.SetDeathAnim();
                Level.DecEntityNo(5, this._subtype, this._allegiance);
                if (this._allegiance == 0) {
                    --Level._player_command_points;
                }
                if (this._allegiance != 1) break;
                --Level._ai_command_points;
                break;
            }
            case 6: {
                this._flags |= 0x800;
                this._stealth_timer = 0;
                switch (this._subtype) {
                    case 4: 
                    case 5: {
                        if ((this._flags & 0x100) != 0) break;
                        this.SetCrtAnim(30);
                    }
                }
                break;
            }
        }
        this.SetCollisionBox();
        this._state = n;
    }

    public void SetCollisionBox() {
        this._collisionBox = GameImpl.Rect(this._collisionBox, this.ComputeBoundingBox());
    }

    public void Unit_TakeDamage(int n, int n2, int n3) {
        Entity entity;
        if (this._subtype == 8) {
            Entity entity2 = Level.GetEntitySafe(n3);
            if (entity2._type == 5 && ((Unit)entity2)._allegiance == 0 && ((Unit)entity2)._subtype == 8) {
                this._gathered_damage += n;
                if (this._proxyPointer > 0) {
                    this.FireBullet(this._allegiance, this._bullet_type, this._gathered_damage, this._proxyPointer, this._pos_x, this._pos_y);
                    this._gathered_damage = 0;
                }
                return;
            }
        }
        this._self_heal_timer = 0;
        this._stealth_timer = 0;
        if (this._allegiance != 0) {
            this._noticed = true;
        } else if (GameImpl.IsCheatActive(3)) {
            return;
        }
        n *= _units_damage_matrix[n2][this._armour];
        int n4 = Level.GetUnitStats(this._subtype, 23);
        if (n4 != -1 && (n >>= 6) >= n4 && this._force_crawl == 0) {
            if (this._crawling_timer <= 0) {
                this.RefreshCrawlingAnim();
            }
            this._crawling_timer = (short)64;
        }
        if (n2 == 4) {
            switch (this._subtype) {
                case 0: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n = this._life;
                }
            }
        } else if (this._crawling_timer > 0) {
            int n5 = 70;
            entity = Level.GetEntitySafe(n3);
            if (entity != null && entity._type == 5 && ((Unit)entity).IsInfantry()) {
                n5 = 20;
            }
            n = n * n5 / 100;
        }
        if (this._life > 0) {
            this._life = (short)(this._life - n);
            Entity entity3 = Level.GetEntitySafe(n3);
            if (entity3 != null && entity3._type == 5) {
                entity = (Unit)entity3;
                ((Unit)entity).ReceiveExperience(this._life, n, 0, 5, this._subtype);
            }
            if (this._life <= 0) {
                this._life = 0;
                this.DoAction(4, -1, -1, -1);
                Level.Group_Remove(this);
            }
        }
    }

    void Turret_SetCrtAnim(int n) {
        this._turret_crt_anim = n;
        this._turret_crt_aframe = 0;
        XSprite xSprite = GameImpl._sprites[this._turret_sprite];
        this._turret_crt_aframe_time = xSprite.GetAnimFrameTime(this._turret_crt_anim, this._turret_crt_aframe);
        this._turret_flags &= 0xFFFFFFDF;
    }

    private void Turret_UpdateCrtAnim() {
        if (this._turret_crt_aframe_time == 0 || (this._turret_flags & 0x820) == 2080) {
            return;
        }
        this._turret_flags &= 0xFFFFFFDF;
        --this._turret_crt_aframe_time;
        if (this._turret_crt_aframe_time <= 0) {
            XSprite xSprite = GameImpl._sprites[this._turret_sprite];
            ++this._turret_crt_aframe;
            if (this._turret_crt_aframe >= xSprite.GetAnimLength(this._turret_crt_anim)) {
                this._turret_crt_aframe = (this._turret_flags & 0x800) != 0 ? --this._turret_crt_aframe : 0;
                this._turret_flags |= 0x20;
            }
            this._turret_crt_aframe_time = xSprite.GetAnimFrameTime(this._turret_crt_anim, this._turret_crt_aframe);
        }
    }

    private boolean Turret_IsCrtAnimEnded() {
        return this._turret_crt_aframe_time == 0 || (this._turret_flags & 0x20) != 0;
    }

    private void Turret_DrawCrtAnim(SDKGraphics sDKGraphics) {
        int n = this._pos_x - Camera._nCamX;
        int n2 = this._pos_y - Camera._nCamY;
        if ((this._flags & 0x10000) == 0) {
            n += 0;
            n2 += 38;
        }
        XSprite xSprite = GameImpl._sprites[this._turret_sprite];
        xSprite.DrawAnimFrame(this._turret_crt_anim, this._turret_crt_aframe, n, n2, this._turret_flags & 7);
    }

    private void DrawLife(SDKGraphics sDKGraphics) {
        int n = this.IsInfantry() ? 14 : 20;
        int n2 = this._pos_x - (n >> 1) - Camera._nCamX + 0;
        int n3 = this._collisionBox[1] - 3 - 1 - Camera._nCamY + 38;
        if (this._allegiance == 0) {
            sDKGraphics.setColor(65280);
        } else if (this._allegiance == 2) {
            sDKGraphics.setColor(0xFFFF00);
        } else {
            sDKGraphics.setColor(0xFF0000);
        }
        sDKGraphics.drawRect(n2, n3, 20, 3);
        short s = this._initial_life;
        if (this._life > s) {
            s = this._life;
        }
        if (s != 0) {
            sDKGraphics.fillRect(n2, n3, this._life * 20 / s, 3);
        }
    }

    private void DrawVeterancy(SDKGraphics sDKGraphics) {
        int n = this._pos_x - 10 - Camera._nCamX + 0 - 5;
        int n2 = this._collisionBox[1] - 3 - 1 - Camera._nCamY + 38;
        XSprite xSprite = GameImpl._sprites[4];
        if (this._veterancy_lvl == 1) {
            xSprite.DrawFrame(28, n, n2, 0);
        } else if (this._veterancy_lvl == 2) {
            xSprite.DrawFrame(29, n, n2, 0);
        }
    }

    private void DrawSelection(SDKGraphics sDKGraphics) {
        int n = 0xFFFFFF;
        int n2 = 0xFFFFFF;
        if (this._group == 1) {
            n = 184645;
            n2 = 10222532;
        }
        if (this._group == 2) {
            n = 15596056;
            n2 = 16507139;
        }
        this.DrawSelection(sDKGraphics, n, n2);
    }

    private void DrawSlowEffect(SDKGraphics sDKGraphics) {
        if (this._slow_timer > 0) {
            int n;
            int n2;
            if (!this._bSelected) {
                n2 = 255;
                n = 0xFFFFFF;
                this.DrawSelection(sDKGraphics, n2, n);
            }
            n2 = this._pos_x - 10 - Camera._nCamX + 0 - 5;
            n = this._collisionBox[1] - 3 - 1 - Camera._nCamY + 38;
            GameImpl._sprites[4].DrawFrame(34, n2, n, 0, 0);
        }
    }

    private void DrawSelection(SDKGraphics sDKGraphics, int n, int n2) {
        int n3 = this._pos_x - Camera._nCamX + 0;
        int n4 = this._pos_y - Camera._nCamY + 38;
        int n5 = 16;
        int n6 = 30;
        if (this.IsInfantry()) {
            n5 >>= 1;
            n6 >>= 1;
        }
        n4 = n4 - (n5 >> 1) + 3;
        sDKGraphics.setColor(n);
        sDKGraphics.drawArc(n3 -= n6 >> 1, n4, n6, n5, 0, 360);
        sDKGraphics.setColor(n2);
        sDKGraphics.drawArc(n3 - 1, n4 - 1, n6 + 2, n5 + 2, 0, 360);
        sDKGraphics.setColor(n);
        sDKGraphics.drawArc(n3 - 2, n4 - 2, n6 + 4, n5 + 4, 0, 360);
    }

    private void SetDest(int n, int n2) {
        this._sdata[0] = (short)n;
        this._sdata[1] = (short)n2;
    }

    private void SetDestToWaypoint(int n) {
        this._sdata[0] = (short)(this._waypoints[n] * 8 + 4);
        this._sdata[1] = (short)(this._waypoints[n + 1] * 8 + 4);
    }

    private void SetLeash(int n, int n2) {
        this._sdata[2] = (short)n;
        this._sdata[3] = (short)n2;
    }

    public void SetRallyPoint(int n, int n2) {
        this._rallyX = (short)n;
        this._rallyY = (short)n2;
    }

    private void RequestPath(int n, int n2) {
        if (n >= Level._map_w) {
            n = Level._map_w - 1;
        }
        if (n <= 0) {
            n = 1;
        }
        if (n2 >= Level._map_h) {
            n2 = Level._map_h - 1;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        this._path_handle = this._path_handle != -1 ? Level.UpdatePathData(this._path_handle, this._pos_x, this._pos_y, n, n2) : Level.RequestPath(this._pos_x, this._pos_y, n, n2);
        if (this._path_handle == -1) {
            this.DoAction(0, -1, -1, -1);
        } else {
            this.SetState(5);
        }
    }

    private void AlignTurretToBody() {
        if (this._bHasTurret && this._orientation != this._turretOrientation) {
            this._turretOrientation = this.TurnTowards(this._orientation, this._turretOrientation);
            int n = 16;
            if (this._turret_crt_anim != n + this._turretOrientation) {
                this.Turret_SetCrtAnim(n + this._turretOrientation);
            }
        }
    }

    private void Fire(boolean bl) {
        if (this._firing_timer > this._fire_rate) {
            int n;
            if (this._subtype == 8) {
                this.PrismTank_ComputeProxy();
                if (this._proxyPointer < 0) {
                    if (this._firing_timer == this._fire_rate + 1) {
                        return;
                    }
                    this._firing_timer = 0;
                } else {
                    n = this.PrismTank_GetShooter();
                    Unit unit = (Unit)Level.GetEntitySafe(n);
                    if (unit._firing_timer <= unit._fire_rate) {
                        return;
                    }
                    this._firing_timer = (short)-1;
                }
            } else {
                this._firing_timer = (short)-1;
            }
            n = 24;
            switch (this._subtype) {
                case 0: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (bl) {
                        n = 20;
                        break;
                    }
                    n = 12;
                    break;
                }
                case 8: 
                case 9: {
                    n = 8;
                }
            }
            this._bMoving = bl;
            this._self_heal_timer = 0;
            if (this._bHasTurret) {
                if ((this._flags & 0x100) == 0) {
                    this.Turret_SetCrtAnim(n + this._turretOrientation);
                }
            } else if ((this._flags & 0x100) == 0) {
                this.SetCrtAnim(n + this._orientation);
            }
            this.SetState(7);
        } else {
            this._proxyPointer = -1;
        }
    }

    public int MoveOnWaypoints(int n) {
        int n2 = this.SmartMove(n);
        if (n2 == 2) {
            return 2;
        }
        if (n2 == 1) {
            this._path_cursor -= 2;
            if (this._path_cursor >= 0) {
                this.SetDestToWaypoint(this._path_cursor);
                return 0;
            }
            this.SetDest(-1, -1);
            return 1;
        }
        return 0;
    }

    public int SmartMove(int n) {
        int n2 = this._sdata[0];
        int n3 = this._sdata[1];
        int n4 = n2 - this._pos_x;
        int n5 = n3 - this._pos_y;
        int n6 = Math.abs(n4);
        int n7 = Math.abs(n5);
        int n8 = n6 + n7;
        boolean bl = false;
        if (Level.GetCollisionAt(this._pos_x, this._pos_y) > 4) {
            bl = true;
        }
        if (n8 <= 4) {
            if (bl || Level.GetCollisionAt(n2, n3) <= 4) {
                this._pos_x = n2;
                this._pos_y = n3;
                return 1;
            }
            return 2;
        }
        this._orientation = this.GetOrientation(n4, n5);
        if (n8 <= n) {
            if (bl || Level.GetCollisionAt(n2, n3) <= 4) {
                this._pos_x = n2;
                this._pos_y = n3;
                return 1;
            }
            return 2;
        }
        n8 = n6 > n7 ? n6 : n7;
        n4 = n4 * n / n8;
        n5 = n5 * n / n8;
        this._pos_x += n4;
        this._pos_y += n5;
        return 0;
    }

    public boolean SolveOverlapping() {
        for (int i = 0; i < 24; ++i) {
            int n;
            int n2;
            int n3;
            Entity entity;
            if (Level._entities_usage[i] != 1 || (entity = Level._entities[i]) == this || entity._type != 5 || entity._state != 0) continue;
            int n4 = this._scatter_dist + ((Unit)entity)._scatter_dist << 1;
            if (Math.abs(this._pos_x - entity._pos_x) + Math.abs(this._pos_y - entity._pos_y) >= n4) continue;
            int n5 = 0;
            while (Level.GetCollisionAt(n3 = this._pos_x + GameImpl._versorX[n2 = GameImpl.random(64) & 7] * (n4 - this._scatter_dist), n = this._pos_y + GameImpl._versorY[n2] * (n4 - this._scatter_dist)) > 4 || ++n5 < 12) {
            }
            if (n5 == 12) {
                this.SetDest(this._pos_x, this._pos_y);
            } else {
                this.SetDest(n3, n);
            }
            this.SetState(1);
            return false;
        }
        return true;
    }

    public int GetCraterFrame() {
        switch (this._subtype) {
            case 1: {
                return 8;
            }
            case 3: {
                return 9;
            }
        }
        return -1;
    }

    public boolean IsInfantry() {
        return this._subtype == 0 || this._subtype == 2 || this._subtype == 7 || this._subtype == 6 || this._subtype == 5 || this._subtype == 4;
    }

    public static void DrawHudFrame(int n, int n2, int n3) {
        int n4 = -1;
        switch (n) {
            case 0: {
                n4 = 2;
                break;
            }
            case 2: {
                n4 = 7;
                break;
            }
            case 1: {
                n4 = 3;
                break;
            }
            case 3: {
                n4 = 10;
                break;
            }
            case 4: {
                n4 = 8;
                break;
            }
            case 5: {
                n4 = 9;
                break;
            }
            case 6: {
                n4 = 12;
                break;
            }
            case 7: {
                n4 = 15;
                break;
            }
            case 8: {
                n4 = 16;
                break;
            }
            case 9: {
                n4 = 17;
            }
        }
        if (n4 >= 0) {
            GameImpl._sprites[n4].DrawFrame(0, n2, n3, 0);
        }
    }

    private static void STATES__() {
    }

    private void DoStay() {
        this.AlignTurretToBody();
    }

    private void DoMove() {
        byte by;
        int n;
        int n2;
        boolean bl = true;
        if (this._bHasTurret) {
            n2 = this._sdata[0] - this._pos_x;
            n = this._sdata[1] - this._pos_y;
            if (Math.abs(n2) + Math.abs(n) > 4 && (by = (byte)this.GetOrientation(n2, n)) != this._orientation) {
                this._orientation = this.TurnTowards(by, this._orientation);
                this.SetMoveAnim();
                if (by != this._orientation) {
                    bl = false;
                }
            }
        }
        if (bl) {
            n2 = this._pos_x;
            n = this._pos_y;
            by = this._speed;
            if (this._crawling_timer > 0) {
                by = this._speed * 30 / 100;
            }
            if (this._slow_timer > 0) {
                by = this._speed * 50 / 100;
            }
            if (this.MoveOnWaypoints(by) != 0) {
                this.SetState(0);
                Entity.CheckTriggers(this, n2, n);
                return;
            }
            this.SetMoveAnim();
            Entity.CheckTriggers(this, n2, n);
        }
        if (this._bCanFireMove && this._crawling_timer == 0 && this._targetPointer != -1) {
            Entity entity = Level.GetEntitySafe(this._targetPointer);
            if (entity == null || entity.GetLife() <= 0) {
                return;
            }
            n = entity._pos_x - this._pos_x;
            by = entity._pos_y - this._pos_y;
            int n3 = Math.abs(n) + Math.abs(by);
            int n4 = 10;
            if (this._bIgnoreCollisions) {
                n4 = 16;
            }
            if (n3 <= this._fire_range && Level.NoLineOfSightCollisionBetween(this, entity, n4, 0, 0, 0, 0)) {
                byte by2 = this.GetOrientation(n, by);
                if (by2 != this._orientation || this._bHasTurret && by2 != this._turretOrientation) {
                    if (this._bHasTurret) {
                        this._turretOrientation = this.TurnTowards(by2, this._turretOrientation);
                        this.SetMoveAnim();
                    } else if (Math.abs(this._orientation - by2) > 2) {
                        return;
                    }
                }
                if (this.IsCrtAnimEnded()) {
                    if (this._bHasTurret) {
                        if (this._turretOrientation == by2) {
                            this.Fire(true);
                        }
                    } else {
                        this.Fire(true);
                    }
                }
            } else if (bl) {
                this.AlignTurretToBody();
            }
        } else if (bl) {
            this.AlignTurretToBody();
        }
    }

    private void DoFire() {
        Entity entity = Level.GetEntitySafe(this._targetPointer);
        if (entity == null || entity.GetLife() <= 0) {
            this._targetPointer = -1;
            this.SetState(0);
            return;
        }
        int n = entity._pos_x - this._pos_x;
        int n2 = entity._pos_y - this._pos_y;
        int n3 = 10;
        if (this._bIgnoreCollisions) {
            n3 = 16;
        }
        if (Math.abs(n) + Math.abs(n2) > this._fire_range || !Level.NoLineOfSightCollisionBetween(this, entity, n3, 0, 0, 0, 0)) {
            this.SetState(0);
            return;
        }
        byte by = this.GetOrientation(n, n2);
        if (by != this._orientation || this._bHasTurret && by != this._turretOrientation) {
            if (this._bHasTurret) {
                this._turretOrientation = this.TurnTowards(by, this._turretOrientation);
            } else {
                this._orientation = this.TurnTowards(by, this._orientation);
            }
            this.SetFireStayAnim();
        }
        if (this._bHasTurret) {
            if (this._turretOrientation == by) {
                this.Fire(false);
            }
        } else if (this._orientation == by) {
            this.Fire(false);
        }
    }

    private void DoDie() {
        if (this.IsCrtAnimEnded() && (!this._bHasTurret || this._bHasTurret && this.Turret_IsCrtAnimEnded())) {
            if (this._allegiance == 0) {
                Level._statistics[7] = Level._statistics[7] + 1;
            } else if (this._allegiance == 1) {
                Level._statistics[6] = Level._statistics[6] + 1;
            }
            this.SetState(4);
        }
    }

    private void DoDeath() {
        --this._timer;
        if (this.IsCrtAnimEnded() && this._timer < 0) {
            Level.DeleteEntity(this);
        }
    }

    private void DoWaitForPath() {
        int n = Level.GetPathStatus(this._path_handle);
        if (n == 2) {
            this._path_cursor = Level.GetPathWaypoints(this._path_handle, this._waypoints);
            this._path_handle = -1;
            if (this._path_cursor >= 0) {
                this.SetDestToWaypoint(this._path_cursor);
                this.SetState(1);
            } else {
                this.SetState(0);
            }
        } else if (n == 3) {
            this._path_cursor = -1;
            this._path_handle = -1;
            this.DoAction(1, -1, -1, -1);
        }
    }

    private void DoDemolish() {
        Entity entity = Level.GetEntitySafe(this._targetPointer);
        if (entity == null) {
            this._targetPointer = -1;
            if (this.SolveOverlapping()) {
                this.DoAction(0, -1, -1, -1);
            }
            return;
        }
        if (this.IsCrtAnimEnded()) {
            entity.Demolish(this);
            this.SetState(0);
            this.DoAction(0, -1, -1, -1);
        }
    }

    private void DoLauchBullets() {
        int n;
        int n2;
        int n3;
        if (this._bMoving) {
            n3 = this._pos_x;
            n2 = this._pos_y;
            n = this._speed;
            if (this._crawling_timer > 0) {
                n = this._speed * 30 / 100;
            }
            if (this._slow_timer > 0) {
                n = this._speed * 50 / 100;
            }
            if (this.MoveOnWaypoints(n) != 0) {
                this._bMoving = false;
            }
            Entity.CheckTriggers(this, n3, n2);
        }
        n3 = 0;
        if (this._subtype == 3) {
            if (this._firing_timer == 2 || this._firing_timer == 0) {
                n2 = 24;
                if (this._turret_crt_anim != n2 + this._turretOrientation && (this._flags & 0x100) == 0) {
                    this.Turret_SetCrtAnim(n2 + this._turretOrientation);
                }
                this.FireBullet(this._allegiance, this._bullet_type, this._damage, this._targetPointer, this._pos_x, this._pos_y);
                if (this._firing_timer == 2) {
                    n3 = 1;
                }
            }
        } else if (this._subtype == 8) {
            n2 = Level.GetUnitStats(this._subtype, 21);
            if (n2 < 0) {
                n2 = 0;
            }
            if (this._crt_aframe == n2) {
                n = this._targetPointer;
                if (this._proxyPointer >= 0) {
                    n = this._proxyPointer;
                }
                this.FireBullet(this._allegiance, this._bullet_type, this._damage + this._gathered_damage, n, this._pos_x, this._pos_y);
                this._proxyPointer = -1;
                this._gathered_damage = 0;
            }
            if (this.IsCrtAnimEnded()) {
                n3 = 1;
            }
        } else {
            n2 = Level.GetUnitStats(this._subtype, 21);
            if (this._bHasTurret) {
                if (n2 < 0) {
                    n2 = 0;
                }
                if (this._turret_crt_aframe == n2) {
                    this.FireBullet(this._allegiance, this._bullet_type, this._damage, this._targetPointer, this._pos_x, this._pos_y);
                }
            } else {
                if (n2 < 0) {
                    n2 = 0;
                }
                if (this._crt_aframe == n2) {
                    this.FireBullet(this._allegiance, this._bullet_type, this._damage, this._targetPointer, this._pos_x, this._pos_y);
                }
            }
            if (this.IsCrtAnimEnded() && !this._bHasTurret || this.Turret_IsCrtAnimEnded() && this._bHasTurret) {
                n3 = 1;
            }
        }
        if (n3 != 0) {
            n2 = this._firing_timer;
            if (this._bMoving) {
                this.SetState(1);
            } else {
                this.SetState(2);
            }
            this._firing_timer = (short)n2;
        }
    }

    private static void __STATES() {
    }

    private static void UNIT_AI__() {
    }

    private void Unit_AI_Goto() {
        if (this._state == 5) {
            return;
        }
        if (this._state == 0) {
            if (this._path_cursor < 0) {
                if (this.SolveOverlapping()) {
                    this.DoAction(1, -1, -1, -1);
                }
            } else {
                this.RequestPath(this._waypoints[0] * 8 + 4, this._waypoints[1] * 8 + 4);
            }
        } else if (this._bCanFireMove && this._crawling_timer == 0) {
            this._unit_ai_timer = (short)(this._unit_ai_timer - 1);
            if (this._unit_ai_timer <= 0) {
                Entity entity;
                int n;
                this._unit_ai_timer = (short)5;
                int n2 = 10;
                if (this._bIgnoreCollisions) {
                    n2 = 16;
                }
                int n3 = n = this._fire_range > this._sight_range ? this._sight_range : this._fire_range;
                if ((this._flags & 0x4000) == 0 && (entity = this.FindTarget(this._allegiance, n, this._fire_range, this._subtype, n2)) != null && this._targetPointer != entity.GetPointer()) {
                    this._targetPointer = entity.GetPointer();
                    this._requested_action = false;
                }
            }
        }
    }

    private void Unit_AI_Attack() {
        if (this._targetPointer == -1) {
            if (this._state == 0 && this.SolveOverlapping()) {
                this.DoAction(0, -1, -1, -1);
            }
            this._requested_action = false;
            return;
        }
        Entity entity = Level.GetEntitySafe(this._targetPointer);
        if (entity == null || entity.GetLife() <= 0) {
            this._targetPointer = -1;
            this.SetState(0);
            this._requested_action = false;
            return;
        }
        if (this._state != 2 && this._state != 7 && Math.abs(entity._pos_x - this._pos_x) + Math.abs(entity._pos_y - this._pos_y) <= this._fire_range) {
            int n = 10;
            if (this._bIgnoreCollisions) {
                n = 16;
            }
            if (Level.NoLineOfSightCollisionBetween(this, entity, n, 0, 0, 0, 0)) {
                this.SetState(2);
            } else if (this._state != 5 && this._state != 1) {
                this.RequestPath(entity._pos_x, entity._pos_y);
            }
        } else if (this._state == 0) {
            this.RequestPath(entity._pos_x, entity._pos_y);
        } else if (this._state == 1) {
            int n = this._pos_x - entity._pos_x;
            int n2 = this._pos_y - entity._pos_y;
            if (Math.abs(n) + Math.abs(n2) < this._sight_range) {
                n = this._sdata[0] - entity._pos_x;
                n2 = this._sdata[1] - entity._pos_y;
                int n3 = this._path_cursor;
                while (n3 >= 0) {
                    if ((n3 -= 2) < 0) continue;
                    n = this._waypoints[n3] * 8 + 4 - entity._pos_x;
                    n2 = this._waypoints[n3 + 1] * 8 + 4 - entity._pos_y;
                }
                if (Math.abs(n) + Math.abs(n2) > 24 + GameImpl.random(24)) {
                    this.SetState(0);
                }
            }
        }
    }

    private void Unit_AI_Guard() {
        if (this._targetPointer != -1) {
            if (this._state == 1 && Math.abs(this._sdata[2] - this._pos_x) + Math.abs(this._sdata[3] - this._pos_y) > this._attack_range) {
                this._targetPointer = -1;
                this._unit_ai_timer = (short)15;
                this.SetState(0);
                return;
            }
            Entity entity = Level.GetEntitySafe(this._targetPointer);
            if (entity == null || entity.GetLife() <= 0) {
                this._targetPointer = -1;
                this.SetState(0);
                this._unit_ai_timer = (short)15;
                return;
            }
            if (this._state != 2 && this._state != 7 && Math.abs(entity._pos_x - this._pos_x) + Math.abs(entity._pos_y - this._pos_y) <= this._fire_range) {
                int n = 10;
                if (this._bIgnoreCollisions) {
                    n = 16;
                }
                if (Level.NoLineOfSightCollisionBetween(this, entity, n, 0, 0, 0, 0)) {
                    this.SetState(2);
                } else if (this._state != 5 && this._state != 1) {
                    this.RequestPath(entity._pos_x, entity._pos_y);
                }
            } else if (this._state == 0) {
                this.RequestPath(entity._pos_x, entity._pos_y);
            }
        } else if (this._state == 0 && Math.abs(this._pos_x - this._sdata[2]) + Math.abs(this._pos_y - this._sdata[3]) > this._attack_range >> 1 && this._unit_ai_timer <= 10) {
            this.RequestPath(this._sdata[2], this._sdata[3]);
        }
        this._unit_ai_timer = (short)(this._unit_ai_timer - 1);
        if (this._unit_ai_timer <= 0) {
            Entity entity;
            this._unit_ai_timer = (short)5;
            int n = 10;
            if (this._bIgnoreCollisions) {
                n = 16;
            }
            if ((this._flags & 0x4000) == 0 && (entity = this.FindTarget(this._allegiance, this._sight_range, this._fire_range, this._subtype, n)) != null) {
                this._targetPointer = entity.GetPointer();
            }
        }
    }

    private void Unit_AI_Demolish() {
        Entity entity = Level.GetEntitySafe(this._targetPointer);
        if (entity == null) {
            this._targetPointer = -1;
            if (this._state == 0 && this.SolveOverlapping()) {
                this.DoAction(0, -1, -1, -1);
            }
            return;
        }
        switch (this._subtype) {
            case 4: {
                if (Math.abs(entity._pos_x - this._pos_x) + Math.abs(entity._pos_y - this._pos_y) <= this._fire_range >> 1 && Level.NoLineOfSightCollisionBetween(this, entity, 10, 0, 0, 0, 0)) {
                    if (this._state == 6) break;
                    this.SetState(6);
                    break;
                }
                if (this._state != 0) break;
                this.RequestPath(entity._pos_x, entity._pos_y);
                break;
            }
            case 5: {
                if (Math.abs(entity._pos_x - this._pos_x) + Math.abs(entity._pos_y - this._pos_y) <= this._fire_range >> 1) {
                    if (this._state == 6) break;
                    this.SetState(6);
                    break;
                }
                if (this._state != 0) break;
                this.RequestPath(entity._pos_x, entity._pos_y);
            }
        }
    }

    private void Unit_AI_Patrol() {
        if (this._state == 5) {
            return;
        }
        if (this._state == 0) {
            if (this._path_cursor < 0) {
                if (this._patrolTimer > 0) {
                    --this._patrolTimer;
                    if (this._targetPointer != -1) {
                        Entity entity = Level.GetEntitySafe(this._targetPointer);
                        if (entity == null || entity.GetLife() <= 0) {
                            this._targetPointer = -1;
                            this._unit_ai_timer = (short)15;
                            return;
                        }
                        if (this._state != 2 && this._state != 7 && Math.abs(entity._pos_x - this._pos_x) + Math.abs(entity._pos_y - this._pos_y) <= this._fire_range) {
                            int n = 10;
                            if (this._bIgnoreCollisions) {
                                n = 16;
                            }
                            if (Level.NoLineOfSightCollisionBetween(this, entity, n, 0, 0, 0, 0)) {
                                this.SetState(2);
                            } else {
                                this._targetPointer = -1;
                            }
                        } else {
                            this._targetPointer = -1;
                        }
                    } else {
                        this._unit_ai_timer = (short)(this._unit_ai_timer - 1);
                        if (this._unit_ai_timer <= 0) {
                            Entity entity;
                            this._unit_ai_timer = (short)5;
                            int n = 10;
                            if (this._bIgnoreCollisions) {
                                n = 16;
                            }
                            if ((this._flags & 0x4000) == 0 && (entity = this.FindTarget(this._allegiance, this._sight_range, this._fire_range, this._subtype, n)) != null) {
                                this._targetPointer = entity.GetPointer();
                            }
                        }
                    }
                } else {
                    int n = Entity.Get_WayPoint(this._pathPointer);
                    if (n >= 0) {
                        short s = Entity._wayPoints[n + 3];
                        if (s >= 0) {
                            this.DoAction(6, s, -1, -1);
                        } else {
                            this.DoAction(1, -1, -1, -1);
                        }
                    } else {
                        this.DoAction(1, -1, -1, -1);
                    }
                }
            } else {
                this.RequestPath(this._waypoints[0] * 8 + 4, this._waypoints[1] * 8 + 4);
            }
        } else if (this._bCanFireMove && this._crawling_timer == 0) {
            this._unit_ai_timer = (short)(this._unit_ai_timer - 1);
            if (this._unit_ai_timer <= 0) {
                Entity entity;
                int n;
                this._unit_ai_timer = (short)5;
                int n2 = 10;
                if (this._bIgnoreCollisions) {
                    n2 = 16;
                }
                int n3 = n = this._fire_range > this._sight_range ? this._sight_range : this._fire_range;
                if ((this._flags & 0x4000) == 0 && (entity = this.FindTarget(this._allegiance, n, this._fire_range, this._subtype, n2)) != null && this._targetPointer != entity.GetPointer()) {
                    this._targetPointer = entity.GetPointer();
                }
            }
        }
    }

    public void DoAction(int n, int n2, int n3, int n4) {
        switch (this._action) {
            case 1: {
                this.SetLeash(-1, -1);
                break;
            }
            case 4: {
                return;
            }
        }
        this._rallyX = (short)-1;
        this._rallyY = (short)-1;
        this._action = n;
        switch (n) {
            case 2: {
                this.DoAction_Goto(n3, n4);
                break;
            }
            case 3: {
                this.DoAction_Attack(n2, n3, n4);
                break;
            }
            case 4: {
                this._targetPointer = -1;
                this.SetState(3);
                break;
            }
            case 5: {
                this.DoAction_Demolish(n2);
                break;
            }
            case 6: {
                this.DoAction_Patrol(n2);
                break;
            }
            default: {
                this._action = 1;
                this.DoAction_Guard();
            }
        }
    }

    private void DoAction_Guard() {
        if (this._life <= 0) {
            return;
        }
        this._targetPointer = -1;
        this._unit_ai_timer = 0;
        this._path_cursor = -1;
        this.SetState(0);
        this.SetLeash(this._pos_x, this._pos_y);
    }

    private void DoAction_Goto(int n, int n2) {
        if (this._life <= 0) {
            return;
        }
        this._targetPointer = -1;
        this._unit_ai_timer = 0;
        this.RequestPath(n, n2);
    }

    private void DoAction_Attack(int n, int n2, int n3) {
        Entity entity;
        if (this._life <= 0) {
            return;
        }
        int n4 = 10;
        if (this._bIgnoreCollisions) {
            n4 = 16;
        }
        if ((entity = Level.GetEntitySafe(n)) == null) {
            this.DoAction(0, -1, -1, -1);
            return;
        }
        if (!Entity.CanAttack(entity, this)) {
            this.DoAction(2, -1, n2, n3);
            return;
        }
        this._targetPointer = n;
        if (Math.abs(entity._pos_x - this._pos_x) + Math.abs(entity._pos_y - this._pos_y) <= this._fire_range && Level.NoLineOfSightCollisionBetween(this, entity, n4, 0, 0, 0, 0)) {
            this.SetState(2);
        } else {
            if (n2 == -1 && n3 == -1) {
                n2 = entity._pos_x;
                n3 = entity._pos_y;
            }
            this.RequestPath(n2, n3);
        }
    }

    private void DoAction_Demolish(int n) {
        if (this._life <= 0) {
            return;
        }
        Entity entity = Level.GetEntitySafe(n);
        if (entity == null) {
            this.DoAction(0, -1, -1, -1);
            return;
        }
        this._targetPointer = n;
        switch (this._subtype) {
            case 4: {
                if (Math.abs(entity._pos_x - this._pos_x) + Math.abs(entity._pos_y - this._pos_y) <= this._fire_range >> 1) {
                    if (this._state == 6) break;
                    this.SetState(6);
                    break;
                }
                this.RequestPath(entity._pos_x, entity._pos_y);
                break;
            }
            case 5: {
                if (Math.abs(entity._pos_x - this._pos_x) + Math.abs(entity._pos_y - this._pos_y) <= this._fire_range >> 2) {
                    if (this._state == 6) break;
                    this.SetState(6);
                    break;
                }
                this.RequestPath(entity._pos_x, entity._pos_y);
            }
        }
    }

    private void DoAction_Patrol(int n) {
        if (this._life <= 0) {
            return;
        }
        this._targetPointer = -1;
        this._unit_ai_timer = 0;
        int n2 = Entity.Get_WayPoint(n);
        this._pathPointer = n;
        if (n2 < 0) {
            this.DoAction(0, -1, -1, -1);
            return;
        }
        this._patrolTimer = Entity._wayPoints[n2 + 4];
        this.RequestPath(Entity._wayPoints[n2 + 1], Entity._wayPoints[n2 + 2]);
    }

    private static void __UNIT_AI() {
    }

    private static void ANIMS__() {
    }

    public void SetStayAnim() {
        if ((this._flags & 0x100) != 0) {
            return;
        }
        this._flags &= 0xFFFFF7FF;
        this._turret_flags &= 0xFFFFF7FF;
        int n = this._orientation;
        n >>= 1;
        switch (this._subtype) {
            case 0: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.SetCrtAnim(0 + n);
                if (this._crawling_timer <= 0) break;
                this.SetCrtAnim(38 + n);
                break;
            }
            case 1: 
            case 3: {
                this.SetCrtAnim(0 + this._orientation);
                this.Turret_SetCrtAnim(16 + this._turretOrientation);
                break;
            }
            case 8: 
            case 9: {
                this.SetCrtAnim(0 + this._orientation);
            }
        }
    }

    public void SetMoveAnim() {
        if ((this._flags & 0x100) != 0) {
            return;
        }
        this._flags &= 0xFFFFF7FF;
        this._turret_flags &= 0xFFFFF7FF;
        int n = 0;
        int n2 = 0;
        switch (this._subtype) {
            case 0: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n = 4;
                if (this._crawling_timer <= 0) break;
                n = 30;
                break;
            }
            default: {
                n = 0;
                n2 = 16;
            }
        }
        if (this._crt_anim != n + this._orientation) {
            this.SetCrtAnim(n + this._orientation);
        }
        if (this._bHasTurret && this._turret_crt_anim != n2 + this._turretOrientation) {
            this.Turret_SetCrtAnim(n2 + this._turretOrientation);
        }
        this.SetCollisionBox();
    }

    public void SetFireStayAnim() {
        if ((this._flags & 0x100) != 0) {
            return;
        }
        int n = this._orientation;
        n >>= 1;
        int n2 = 0;
        switch (this._subtype) {
            case 0: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 0;
                if (this._crawling_timer <= 0) break;
                n2 = 38;
                break;
            }
            case 1: 
            case 3: {
                n2 = 16;
                break;
            }
            case 8: 
            case 9: {
                n2 = 0;
            }
        }
        if (this._bHasTurret) {
            if (this._turret_crt_anim != n2 + this._turretOrientation) {
                this.Turret_SetCrtAnim(n2 + this._turretOrientation);
            }
        } else {
            if (this._crt_anim != n2 + n) {
                this.SetCrtAnim(n2 + n);
            }
            this.SetCollisionBox();
        }
    }

    public void SetDieAnim() {
        if ((this._flags & 0x100) != 0) {
            return;
        }
        this._flags |= 0x800;
        this._turret_flags |= 0x800;
        switch (this._subtype) {
            case 0: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.SetCrtAnim(28);
                break;
            }
            case 1: 
            case 3: {
                this.SetCrtAnim(0 + this._orientation);
                this.Turret_SetCrtAnim(16 + this._orientation);
                break;
            }
            case 8: 
            case 9: {
                this.SetCrtAnim(0 + this._orientation);
            }
        }
    }

    public void SetDeathAnim() {
        if ((this._flags & 0x100) != 0) {
            return;
        }
        this._flags |= 0x800;
        this._turret_flags |= 0x800;
        switch (this._subtype) {
            case 0: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                this.SetCrtAnim(29);
                break;
            }
            case 1: 
            case 3: {
                this.SetCrtAnim(0 + this._orientation);
                this.Turret_SetCrtAnim(16 + this._turretOrientation);
                break;
            }
        }
    }

    private static void __ANIMS() {
    }

    public static void VETERANCY__() {
    }

    void ReceiveExperience(int n, int n2, int n3, int n4, int n5) {
        if (n <= 0) {
            if (n4 == 5) {
                this._experience += Level.GetUnitStats(n5, 10);
            } else if (n4 == 6) {
                this._experience += Level.GetBuildingStats(n3, n5, 15);
            }
            if (this._experience >= this._experience_for_lvlup && this._veterancy_lvl < 2) {
                this._veterancy_lvl = (byte)(this._veterancy_lvl + 1);
                this._experience = 0;
                this.RecalculateDmgFireRate();
            }
        }
    }

    void DoSelfHeal() {
        if (this._veterancy_lvl >= this._self_heal_start_lvl && this._life < this._initial_life && this._life > 0) {
            this._life = (short)(this._life + this._self_heal);
            if (this._life > this._initial_life) {
                this._life = this._initial_life;
            }
        }
    }

    void RecalculateDmgFireRate() {
        this._damage = Level.GetBulletStats(this._bullet_type, 0);
        this._damage = this._damage * (100 + this._veterancy_lvl * this._dmg_increase) / 100;
        this._fire_rate = Level.GetUnitStats(this._subtype, 5);
        this._fire_rate = this._fire_rate * (100 - this._veterancy_lvl * this._fire_rate_increase) / 100;
    }

    public static void __VETERANCY() {
    }

    void RefreshCrawlingAnim() {
        switch (this._state) {
            case 0: {
                this.SetStayAnim();
                break;
            }
            case 1: {
                this.SetMoveAnim();
            }
        }
    }

    public void PrismTank_ComputeProxy() {
        if (this._subtype != 8) {
            this._proxyPointer = -1;
            return;
        }
        if (this._targetPointer == -1) {
            this._proxyPointer = -1;
            return;
        }
        Entity entity = Level.GetEntitySafe(this._targetPointer);
        if (entity == null) {
            this._proxyPointer = -1;
            return;
        }
        if (entity._type == 5) {
            if (((Unit)entity)._life <= 0) {
                this._proxyPointer = -1;
                return;
            }
        } else if (entity._type == 6 && ((Building)entity)._life <= 0) {
            this._proxyPointer = -1;
            return;
        }
        int n = Math.abs(entity._pos_x - this._pos_x) + Math.abs(entity._pos_y - this._pos_y);
        int n2 = -1;
        for (int i = 0; i < 24; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level.GetEntityUnsafe(i);
            if (unit._subtype != this._subtype || unit._targetPointer != this._targetPointer || unit._allegiance != this._allegiance) continue;
            int n3 = Math.abs(entity._pos_x - unit._pos_x) + Math.abs(entity._pos_y - unit._pos_y);
            int n4 = Math.abs(this._pos_x - unit._pos_x) + Math.abs(this._pos_y - unit._pos_y);
            if (n4 > Level.GetUnitStats(this._subtype, 4) / 2 || n3 >= n || !Level.NoLineOfSightCollisionBetween(unit, entity, 10, 0, 0, 0, 0) || unit.GetPointer() == this.GetPointer()) continue;
            unit.PrismTank_ComputeProxy();
            if (unit._proxyPointer == -1) continue;
            n = n3;
            n2 = unit.GetPointer();
        }
        this._proxyPointer = n2;
        if (this._proxyPointer == -1 && Math.abs(entity._pos_x - this._pos_x) + Math.abs(entity._pos_y - this._pos_y) <= this._fire_range && Level.NoLineOfSightCollisionBetween(this, entity, 10, 0, 0, 0, 0)) {
            this._proxyPointer = -2;
        }
    }

    public int PrismTank_GetShooter() {
        this.PrismTank_ComputeProxy();
        int n = this.GetPointer();
        Unit unit = this;
        if (unit._proxyPointer > 0) {
            n = unit._proxyPointer;
            unit = (Unit)Level.GetEntitySafe(n);
        }
        if (unit == null) {
            return this.GetPointer();
        }
        while (unit._proxyPointer > 0) {
            if (unit == null) {
                unit = this;
                n = this.GetPointer();
                break;
            }
            if (n == this.GetPointer()) {
                return n;
            }
            n = unit._proxyPointer;
            unit = (Unit)Level.GetEntitySafe(n);
            if (unit != null && unit._life > 0) continue;
            unit = this;
            n = this.GetPointer();
            break;
        }
        return n;
    }

    public void Unit_Jump_From_Collision() {
        int n = this._pos_x / 8;
        int n2 = this._pos_y / 8;
        if (Level.ValidateCollisionTile(n, n2, 16)) {
            this.SetPosition(Level._validTileX * 8 + 4, Level._validTileY * 8 + 4);
            this.SetCollisionBox();
        }
    }
}

