/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Building;
import com.ea.game.BuildingConstants;
import com.ea.game.Constants;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.GraphicsConstants;
import com.ea.game.Hud;
import com.ea.game.Key;
import com.ea.game.Level;
import com.ea.game.SpriteConstants;
import com.ea.game.Unit;
import com.ea.game.UnitsConstants;
import com.ea.game.XSprite;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGraphics;

public class Camera
implements Constants,
UnitsConstants,
BuildingConstants,
SpriteConstants,
GraphicsConstants,
Key {
    public static int _nCamX;
    public static int _nCamY;
    public static int _state;
    public static int _nDestX;
    public static int _nDestY;
    static int _nCamSpd;
    static int _nCamMaxSpd;
    public static int _nCursorDX;
    public static int _nCursorDY;
    public static int _followEntityPointer;
    static int _nCursorPosX;
    static int _nCursorPosY;
    static int _nCursorSpdX;
    static int _nCursorSpdY;
    static int[] _pCursorTrailX;
    static int[] _pCursorTrailY;
    static int _nCursorTrailLastPt;
    static int _nCursorTrailLength;
    static boolean _bCursorScroll;
    static boolean _bUnitsSelected;
    static boolean _bCursorExpanded;
    static short _cursorDownFrames;
    static short _cursorDoubleFrames;
    static boolean _bcursorDoubleTap;
    static int _nCursorSpdExp;
    static int[] _cursorRect;
    static int _targetPointer;
    static int _sovietHeroPointer;
    static int _selectedUnitsCapabilities;

    public static void ResetCamera() {
        _nCamMaxSpd = 75;
        _nCamSpd = 5;
    }

    public static void DoScroll(int n, int n2) {
        _nDestX = n < 0 ? 0 : n;
        _nDestY = n2 < 0 ? 0 : n2;
        _nCursorDX = _nCursorPosX - _nCamX;
        _nCursorDY = _nCursorPosY - _nCamY;
        _nCamSpd = 5;
        Camera.SetState(1);
    }

    public static void DoFollowEntity(int n) {
        _followEntityPointer = n;
        Camera.SetState(3);
    }

    static void SetState(int n) {
        if (_state == n) {
            return;
        }
        _state = n;
    }

    static void UpdateCamera() {
        switch (_state) {
            case 0: {
                Camera.Update_State_Cursor();
                break;
            }
            case 2: {
                Camera.Update_State_CenterCursor();
                break;
            }
            case 1: {
                Camera.Update_State_Scroll();
                break;
            }
            case 3: {
                Camera.Update_State_FollowEntity();
            }
        }
    }

    private static boolean MoveCamera() {
        int n;
        int n2 = _nDestX - _nCamX;
        int n3 = _nDestY - _nCamY;
        int n4 = Math.abs(n2);
        int n5 = n4 + (n = Math.abs(n3));
        if (n5 <= 4) {
            _nCamX = _nDestX;
            _nCamY = _nDestY;
            return false;
        }
        if (n5 <= _nCamSpd) {
            _nCamX = _nDestX;
            _nCamY = _nDestY;
            return true;
        }
        n5 = n4 > n ? n4 : n;
        n2 = (n2 * _nCamSpd << 6) / n5;
        n3 = (n3 * _nCamSpd << 6) / n5;
        _nCamX = (_nCamX << 6) + n2 >> 6;
        _nCamY = (_nCamY << 6) + n3 >> 6;
        return true;
    }

    private static void Update_State_Cursor() {
        _bCursorScroll = false;
        if (_nCamX > _nCursorPosX - 24) {
            _nCamX = _nCursorPosX - 24;
            _bCursorScroll = true;
            if (_nCamX < 0) {
                _nCamX = 0;
            }
        }
        if (_nCamX < _nCursorPosX + 24 - Constants.SV_W) {
            _nCamX = _nCursorPosX + 24 - Constants.SV_W;
            _bCursorScroll = true;
            if (_nCamX > Level._map_w - Constants.SV_W) {
                _nCamX = Level._map_w - Constants.SV_W;
            }
        }
        if (_nCamY > _nCursorPosY - 10 - 24) {
            _nCamY = _nCursorPosY - 10 - 24;
            _bCursorScroll = true;
            if (_nCamY < 0) {
                _nCamY = 0;
            }
        }
        if (_nCamY < _nCursorPosY + 24 - Constants.SV_H) {
            _nCamY = _nCursorPosY + 24 - Constants.SV_H;
            _bCursorScroll = true;
            if (_nCamY > Level._map_h - Constants.SV_H) {
                _nCamY = Level._map_h - Constants.SV_H;
            }
        }
    }

    private static void Update_State_CenterCursor() {
        _bCursorScroll = true;
        _nCamX = _nCursorPosX - (Constants.SV_W >> 1);
        _nCamY = _nCursorPosY - (Constants.SV_H >> 1);
        if (_nCamX < 0) {
            _nCamX = 0;
        }
        if (_nCamX > Level._map_w - Constants.SV_W) {
            _nCamX = Level._map_w - Constants.SV_W;
        }
        if (_nCamY < 0) {
            _nCamY = 0;
        }
        if (_nCamY > Level._map_h - Constants.SV_H) {
            _nCamY = Level._map_h - Constants.SV_H;
        }
    }

    private static void Update_State_Scroll() {
        boolean bl = false;
        if ((_nCamSpd += 5) > _nCamMaxSpd) {
            _nCamSpd = _nCamMaxSpd;
        }
        if (Camera.MoveCamera()) {
            if (_nCamX < 0) {
                _nCamX = 0;
                bl = true;
            }
            if (_nCamX > Level._map_w - Constants.SV_W) {
                _nCamX = Level._map_w - Constants.SV_W;
                bl = true;
            }
            if (_nCamY < 0) {
                _nCamY = 0;
                bl = true;
            }
            if (_nCamY > Level._map_h - Constants.SV_H) {
                _nCamY = Level._map_h - Constants.SV_H;
                bl = true;
            }
        } else {
            if (_nCamX < 0) {
                _nCamX = 0;
            }
            if (_nCamX > Level._map_w - Constants.SV_W) {
                _nCamX = Level._map_w - Constants.SV_W;
            }
            if (_nCamY < 0) {
                _nCamY = 0;
            }
            if (_nCamY > Level._map_h - Constants.SV_H) {
                _nCamY = Level._map_h - Constants.SV_H;
            }
            bl = true;
        }
        _nCursorPosX = _nCamX + _nCursorDX;
        _nCursorPosY = _nCamY + _nCursorDY;
        if (bl) {
            Camera.SetState(0);
        }
    }

    private static void Update_State_FollowEntity() {
        Entity entity = Level.GetEntitySafe(_followEntityPointer);
        if (entity == null) {
            Camera.SetState(0);
            return;
        }
        _bCursorScroll = false;
        _nDestX = entity._pos_x - (Constants.SV_W >> 1);
        _nDestY = entity._pos_y - (Constants.SV_H >> 1);
        _nCursorDX = _nCursorPosX - _nCamX;
        _nCursorDY = _nCursorPosY - _nCamY;
        if (_nDestX < 0) {
            _nDestX = 0;
        }
        if (_nDestX > Level._map_w - Constants.SV_W) {
            _nDestX = Level._map_w - Constants.SV_W;
        }
        if (_nDestY < 0) {
            _nDestY = 0;
        }
        if (_nDestY > Level._map_h - Constants.SV_H) {
            _nDestY = Level._map_h - Constants.SV_H;
        }
        Camera.MoveCamera();
        _nCursorPosX = _nCamX + _nCursorDX;
        _nCursorPosY = _nCamY + _nCursorDY;
    }

    static void CURSOR__() {
    }

    static void InitCursor() {
        _nCursorPosX = Constants.SV_W / 2;
        _nCursorPosY = Constants.SV_H / 2;
        _nCursorSpdX = 0;
        _nCursorSpdY = 0;
        _nCursorSpdExp = 0;
        _bCursorScroll = false;
        _nCursorTrailLastPt = 0;
        _nCursorTrailLength = 0;
        _targetPointer = -1;
        _cursorDownFrames = 0;
        _cursorDoubleFrames = (short)6;
        _bcursorDoubleTap = false;
        _bUnitsSelected = false;
        _cursorRect = GameImpl.Rect(_cursorRect, _nCursorPosX - 4, _nCursorPosY - 4, 8, 8);
        _sovietHeroPointer = -1;
        _selectedUnitsCapabilities = 0;
    }

    static void UpdateCursor() {
        if (!_bCursorExpanded) {
            Camera.UpdateCursorMovement();
        }
        Camera.UpdateCursorTargetPointer();
        Camera.UpdateCursorSelection();
        Camera.RefreshSelectCapabilities();
    }

    static void DrawCursor(SDKGraphics sDKGraphics) {
        int n = 0 + _nCursorPosX - _nCamX;
        int n2 = 38 + _nCursorPosY - _nCamY;
        if (_bCursorExpanded) {
            sDKGraphics.setColor(65280);
            sDKGraphics.drawLine(n, n2, n, n2);
            sDKGraphics.drawRect(_cursorRect[0] - _nCamX + 0, _cursorRect[1] - _nCamY + 38, _cursorRect[3] - _cursorRect[1], _cursorRect[2] - _cursorRect[0]);
        } else {
            int n3 = Camera.GetCursorAction();
            XSprite xSprite = GameImpl._sprites[6];
            int n4 = 2;
            block0 : switch (n3) {
                case 0: {
                    n4 = 2;
                    break;
                }
                case 1: {
                    n4 = 3;
                    break;
                }
                case 3: {
                    n4 = 4;
                    break;
                }
                case 4: {
                    n4 = 5;
                    break;
                }
                case 2: {
                    n4 = 6;
                    break;
                }
                case 5: {
                    n4 = 8;
                    break;
                }
                case 6: {
                    n4 = 7;
                    break;
                }
                case 7: {
                    switch (Hud._hud_sw) {
                        case 1: {
                            n4 = 10;
                            break block0;
                        }
                    }
                    n4 = 9;
                    break;
                }
                case 8: {
                    n4 = 0;
                    break;
                }
                case 9: {
                    n4 = 1;
                    break;
                }
                case 10: 
                case 11: {
                    n4 = 13;
                }
            }
            xSprite.DrawFrame(n4, n, n2, 0);
            if (n3 == 11) {
                sDKGraphics.setColor(0xFF0000);
                sDKGraphics.drawArc(n - 12, n2 - 12, 20, 20, 0, 360);
                sDKGraphics.drawArc(n - 13, n2 - 13, 22, 22, 0, 360);
                sDKGraphics.drawArc(n - 14, n2 - 14, 24, 24, 0, 360);
                sDKGraphics.drawLine(n + 10, n2 - 11, n - 11, n2 + 10);
                sDKGraphics.drawLine(n + 11, n2 - 11, n - 11, n2 + 11);
                sDKGraphics.drawLine(n + 11, n2 - 10, n - 10, n2 + 11);
            }
        }
    }

    static void UpdateCursorMovement() {
        if (SDKCanvas.isKeyPressed(2052)) {
            if (_nCursorSpdX > 0) {
                _nCursorSpdX /= 2;
            }
            if ((_nCursorSpdX -= 4) < -26) {
                _nCursorSpdX = -26;
            }
        } else if (SDKCanvas.isKeyPressed(8200)) {
            if (_nCursorSpdX < 0) {
                _nCursorSpdX /= 2;
            }
            if ((_nCursorSpdX += 4) > 26) {
                _nCursorSpdX = 26;
            }
        } else {
            _nCursorSpdX /= 2;
        }
        if (SDKCanvas.isKeyPressed(513)) {
            if (_nCursorSpdY > 0) {
                _nCursorSpdY /= 2;
            }
            if ((_nCursorSpdY -= 4) < -26) {
                _nCursorSpdY = -26;
            }
        } else if (SDKCanvas.isKeyPressed(32770)) {
            if (_nCursorSpdY < 0) {
                _nCursorSpdY /= 2;
            }
            if ((_nCursorSpdY += 4) > 26) {
                _nCursorSpdY = 26;
            }
        } else {
            _nCursorSpdY /= 2;
        }
        if (_nCursorSpdX > 0) {
            if ((_nCursorPosX += _nCursorSpdX) > Level._map_w - 6) {
                _nCursorPosX = Level._map_w - 6;
            }
        } else if (_nCursorSpdX < 0 && (_nCursorPosX += _nCursorSpdX) < 0) {
            _nCursorPosX = 0;
        }
        if (_nCursorSpdY > 0) {
            if ((_nCursorPosY += _nCursorSpdY) > Level._map_h - 6) {
                _nCursorPosY = Level._map_h - 6;
            }
        } else if (_nCursorSpdY < 0 && (_nCursorPosY += _nCursorSpdY) < 0) {
            _nCursorPosY = 0;
        }
    }

    static void UpdateCursorTargetPointer() {
        if (!_bCursorExpanded) {
            _cursorRect = GameImpl.Rect(_cursorRect, _nCursorPosX - 4, _nCursorPosY - 4, 8, 8);
        }
        int n = -1;
        _targetPointer = -1;
        boolean bl = true;
        if (bl) {
            int n2;
            Entity entity;
            int n3;
            for (n3 = 0; n3 < 24; ++n3) {
                if (Level._entities_usage[n3] == 1 && ((Unit)(entity = (Unit)Level._entities[n3])).IsSelectable(!_bUnitsSelected) && GameImpl.RectIntersect(((Unit)entity)._collisionBox, _cursorRect)) {
                    n2 = Math.abs(entity._pos_x - _nCursorPosX) + Math.abs(entity._pos_y - _nCursorPosY);
                    if (n < 0 || n > n2) {
                        n = n2;
                        _targetPointer = entity.GetPointer();
                    }
                }
                if (_targetPointer < 0) continue;
                ((Unit)Level.GetEntitySafe((int)Camera._targetPointer))._bTargeted = true;
            }
            if (_targetPointer < 0) {
                for (n3 = 24; n3 < 48; ++n3) {
                    if (Level._entities_usage[n3] != 1 || !((Building)(entity = (Building)Level._entities[n3])).IsSelectable(!_bUnitsSelected) || !GameImpl.RectIntersect(((Building)entity)._collisionBox, _cursorRect)) continue;
                    n2 = Math.abs(entity._pos_x - _nCursorPosX) + Math.abs(entity._pos_y - _nCursorPosY);
                    if (n >= 0 && n <= n2) continue;
                    n = n2;
                    _targetPointer = entity.GetPointer();
                }
                if (_targetPointer >= 0) {
                    ((Building)Level.GetEntitySafe((int)Camera._targetPointer))._bTargeted = true;
                }
            }
            if (_targetPointer < 0) {
                for (n3 = 48; n3 < 112; ++n3) {
                    int[] nArray;
                    if (Level._entities_usage[n3] != 1) continue;
                    entity = Level._entities[n3];
                    if ((entity._flags & 0x400) != 0 || entity._type != 10 || !GameImpl.RectIntersect(nArray = entity.ComputeBoundingBox(), _cursorRect)) continue;
                    int n4 = Math.abs(entity._pos_x - _nCursorPosX) + Math.abs(entity._pos_y - _nCursorPosY);
                    if (n >= 0 && n <= n4) continue;
                    n = n4;
                    _targetPointer = entity.GetPointer();
                }
            }
        }
    }

    static void UpdateCursorSelection() {
        if (SDKCanvas.isNewKeyPressed(4112)) {
            _cursorDownFrames = 0;
            if (_cursorDoubleFrames < 6) {
                if (Level._enableSelectionChange) {
                    Camera.CursorSelectSameUnits();
                }
                _bcursorDoubleTap = true;
            }
            _cursorDoubleFrames = 0;
        }
        if (SDKCanvas.isKeyPressed(4112)) {
            if (_bCursorExpanded) {
                if (++_nCursorSpdExp > 9) {
                    _nCursorSpdExp = 9;
                }
                _cursorRect[1] = _cursorRect[1] - _nCursorSpdExp;
                if (_cursorRect[1] < 0) {
                    Camera._cursorRect[1] = 0;
                }
                _cursorRect[0] = _cursorRect[0] - _nCursorSpdExp;
                if (_cursorRect[0] < 0) {
                    Camera._cursorRect[0] = 0;
                }
                _cursorRect[3] = _cursorRect[3] + _nCursorSpdExp;
                if (_cursorRect[3] > Level._map_h) {
                    Camera._cursorRect[3] = Level._map_h;
                }
                _cursorRect[2] = _cursorRect[2] + _nCursorSpdExp;
                if (_cursorRect[2] > Level._map_w) {
                    Camera._cursorRect[2] = Level._map_w;
                }
            } else {
                _cursorDownFrames = (short)(_cursorDownFrames + 1);
                if (!_bcursorDoubleTap && _cursorDownFrames > 6) {
                    _bCursorExpanded = true;
                    _nCursorSpdExp = 3;
                }
            }
        } else if ((_cursorDoubleFrames = (short)(_cursorDoubleFrames + 1)) > 6) {
            _cursorDoubleFrames = (short)6;
        }
        if (SDKCanvas.isNewKeyReleased(4112)) {
            if (!_bcursorDoubleTap) {
                int n = Camera.GetCursorAction();
                switch (n) {
                    case 1: {
                        if (!Level._enableSelectionChange) break;
                        Camera.CursorSelect();
                        break;
                    }
                    case 3: {
                        Camera.CursorOrderMove();
                        break;
                    }
                    case 4: 
                    case 8: 
                    case 9: {
                        Camera.CursorOrderAttack();
                        break;
                    }
                    case 5: 
                    case 6: {
                        Camera.CursorOrderDemolish();
                    }
                }
            }
            _bcursorDoubleTap = false;
            _cursorDownFrames = 0;
            _bCursorExpanded = false;
        }
    }

    static void CursorSelectSameUnits() {
        int n = _targetPointer & 0xFFFF;
        if (n >= 0 && n < 24) {
            Unit unit = (Unit)Level.GetEntitySafe(_targetPointer);
            if (unit == null) {
                return;
            }
            if (unit._allegiance == 0) {
                for (int i = 0; i < 24; ++i) {
                    Unit unit2;
                    if (Level._entities_usage[i] != 1 || !(unit2 = (Unit)Level._entities[i]).IsSelectable(true)) continue;
                    if (unit2._subtype != unit._subtype) {
                        unit2._bSelected = false;
                        continue;
                    }
                    unit2._bSelected = true;
                    _bUnitsSelected = true;
                    Level._currentGroup = 0;
                }
            }
        }
    }

    static void CursorSelect() {
        if (_bCursorExpanded) {
            Level._currentGroup = 0;
            for (int i = 0; i < 24; ++i) {
                if (Level._entities_usage[i] != 1) continue;
                Unit unit = (Unit)Level._entities[i];
                if (unit.IsSelectable(true) && GameImpl.RectIntersect(unit._collisionBox, _cursorRect)) {
                    unit._bSelected = true;
                    _bUnitsSelected = true;
                    continue;
                }
                unit._bSelected = false;
            }
        } else {
            Building building;
            int n = _targetPointer & 0xFFFF;
            if (n < 24) {
                for (int i = 0; i < 24; ++i) {
                    if (Level._entities_usage[i] != 1) continue;
                    ((Unit)Level._entities[i])._bSelected = false;
                }
                Unit unit = (Unit)Level.GetEntitySafe(_targetPointer);
                if (unit != null) {
                    unit._bSelected = true;
                    _bUnitsSelected = true;
                    Level._currentGroup = 0;
                }
            } else if (n < 48 && (building = (Building)Level.GetEntitySafe(_targetPointer)) != null) {
                switch (building._subtype) {
                    case 0: {
                        Hud._hud_current_tab = 0;
                        Hud.ChangeState(2, true);
                        break;
                    }
                    case 3: 
                    case 4: {
                        Hud._hud_current_tab = 1;
                        Hud.ChangeState(2, true);
                        break;
                    }
                    case 6: 
                    case 7: {
                        Hud._hud_current_tab = 2;
                        Hud.ChangeState(2, true);
                    }
                }
            }
        }
    }

    static void CursorOrderMove() {
        if (_bCursorExpanded) {
            return;
        }
        Level.GetCurrentGravCenter(-1, 0);
        for (int i = 0; i < 24; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (!unit._bSelected) continue;
            int n = unit._pos_x - Level._gravity_center_X;
            int n2 = unit._pos_y - Level._gravity_center_Y;
            while (Math.abs(n) + Math.abs(n2) > 50) {
                n >>= 1;
                n2 >>= 1;
            }
            unit.DoAction(2, -1, n + _nCursorPosX, n2 + _nCursorPosY);
            unit.SetRallyPoint(_nCursorPosX, _nCursorPosY);
            unit._requested_action = true;
        }
    }

    static void CursorOrderDemolish() {
        if (_bCursorExpanded) {
            return;
        }
        Entity entity = Level.GetEntitySafe(_targetPointer);
        if (entity == null) {
            return;
        }
        if (entity._type == 6) {
            for (int i = 0; i < 24; ++i) {
                if (Level._entities_usage[i] != 1) continue;
                Unit unit = (Unit)Level._entities[i];
                if (Camera.CheckCapability(4)) {
                    if (!unit._bSelected || unit._subtype != 5) continue;
                    unit.DoAction(5, _targetPointer, -1, -1);
                    break;
                }
                if (!Camera.CheckCapability(8) || !unit._bSelected || unit._subtype != 4) continue;
                unit.DoAction(5, _targetPointer, -1, -1);
                break;
            }
        }
    }

    static void CursorOrderAttack() {
        if (_bCursorExpanded) {
            return;
        }
        Level.GetCurrentGravCenter(-1, 0);
        for (int i = 0; i < 24; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (!unit._bSelected) continue;
            int n = unit._pos_x - Level._gravity_center_X;
            int n2 = unit._pos_y - Level._gravity_center_Y;
            while (Math.abs(n) + Math.abs(n2) > 50) {
                n >>= 1;
                n2 >>= 1;
            }
            unit.DoAction(3, _targetPointer, n + _nCursorPosX, n2 + _nCursorPosY);
            unit._requested_action = true;
        }
    }

    static void CursorOrderGroup() {
        Level.Group_SetToSelection(Level._currentGroup);
    }

    static int GetCursorAction() {
        if (_bCursorExpanded) {
            return 1;
        }
        if (Hud._hud_state == 2) {
            if (Hud._hud_substate == 5) {
                Entity entity = Level.GetEntitySafe(_targetPointer);
                if (entity != null && entity._type == 6) {
                    Building building = (Building)entity;
                    if (building._subtype != 0 && building._allegiance == 0) {
                        return 10;
                    }
                }
                return 11;
            }
            if (Hud._hud_substate == 2) {
                return 0;
            }
            if (Hud._hud_substate == 3) {
                return 7;
            }
        }
        if (!_bUnitsSelected) {
            if (_targetPointer >= 0) {
                return 1;
            }
            return 0;
        }
        Entity entity = Level.GetEntitySafe(_targetPointer);
        if (entity == null) {
            if (Level.GetCollisionAt(_nCursorPosX, _nCursorPosY) > 4) {
                return 2;
            }
            return 3;
        }
        switch (entity._type) {
            case 5: {
                Unit unit = (Unit)entity;
                if (unit._allegiance == 0) {
                    return 1;
                }
                if (unit._allegiance == 2) {
                    if (Level.GetCollisionAt(_nCursorPosX, _nCursorPosY) > 4) {
                        return 2;
                    }
                    return 3;
                }
                if ((unit._attack_capabilities & 0x100) != 0) {
                    if (Camera.CheckCapability(2)) {
                        return 4;
                    }
                    if (Level.GetCollisionAt(_nCursorPosX, _nCursorPosY) > 4) {
                        return 2;
                    }
                    return 3;
                }
                if (Camera.CheckCapability(512)) {
                    Unit unit2 = (Unit)Level.GetEntitySafe(_sovietHeroPointer);
                    int n = Math.abs(unit2._pos_x - unit._pos_x) + Math.abs(unit2._pos_y - unit._pos_y);
                    if (n < unit2._fire_range && Level.NoLineOfSightCollisionBetween(unit2, entity, 10, 0, 0, 0, 0)) {
                        if (unit2._targetPointer == entity.GetPointer()) {
                            return 9;
                        }
                        return 8;
                    }
                    return 4;
                }
                if (Camera.CheckCapability(1)) {
                    return 4;
                }
                if (Level.GetCollisionAt(_nCursorPosX, _nCursorPosY) > 4) {
                    return 2;
                }
                return 3;
            }
            case 6: {
                Building building = (Building)entity;
                if (building._allegiance == 0) {
                    return 1;
                }
                if (building._allegiance == 2) {
                    return 0;
                }
                if (building._subtype != 5) {
                    if (Camera.CheckCapability(4)) {
                        return 5;
                    }
                    if (Camera.CheckCapability(8) && Level._buildings_off_times[1][building._subtype] == 0) {
                        return 6;
                    }
                }
                if (Camera.CheckCapability(2)) {
                    return 4;
                }
                if (Level.GetCollisionAt(_nCursorPosX, _nCursorPosY) > 4) {
                    return 2;
                }
                return 3;
            }
        }
        if (Level.GetCollisionAt(_nCursorPosX, _nCursorPosY) > 4) {
            return 2;
        }
        return 3;
    }

    static void SelectCurrentGroup() {
        Entity entity;
        _bUnitsSelected = Level.Group_Select(Level._currentGroup);
        if (Level._currentGroup != 0 && Level._currentGroup != -1 && (entity = Level.GetEntitySafe(Level.Group_GetLeader(Level._currentGroup))) != null) {
            Level.SpawnIGMessage(0, _nCursorPosX, _nCursorPosY, 20, 53 + Level._currentGroup - 1, 33);
        }
    }

    static void RefreshSelectCapabilities() {
        _selectedUnitsCapabilities = 0;
        _sovietHeroPointer = -1;
        for (int i = 0; i < 24; ++i) {
            Entity entity;
            if (Level._entities_usage[i] != 1 || (entity = Level.GetEntityUnsafe(i)) == null) continue;
            Unit unit = (Unit)entity;
            if (unit._life <= 0 || !unit._bSelected) continue;
            _selectedUnitsCapabilities |= unit._attack_capabilities;
            if (unit._subtype != 4) continue;
            _sovietHeroPointer = unit.GetPointer();
        }
    }

    static boolean CheckCapability(int n) {
        return (_selectedUnitsCapabilities & n) != 0;
    }

    static void __CURSOR() {
    }

    static {
        _nCamSpd = 0;
        _nCamMaxSpd = 75;
        _nCursorPosX = 0;
        _nCursorPosY = 0;
        _nCursorSpdX = 0;
        _nCursorSpdY = 0;
        _pCursorTrailX = new int[16];
        _pCursorTrailY = new int[16];
        _nCursorTrailLastPt = 0;
        _nCursorTrailLength = 0;
        _bCursorScroll = false;
        _bUnitsSelected = false;
        _bCursorExpanded = false;
        _cursorRect = new int[4];
    }
}

