/*
 * Decompiled with CFR 0.152.
 */
package generic;

import com.ea.sdk.ResourceLoader;
import constants.AnimConstants;
import constants.ResourceConstants;
import constants.SoundEventConstants;
import game.AppEngine;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public final class ResourceManager
implements ResourceLoader,
AnimConstants,
ResourceConstants,
SoundEventConstants {
    private int[] m_crcTable;

    public ResourceManager() {
        this.buildCRC32LUT();
    }

    public static final int getFileSize(int n) {
        return ResourceConstants.RESOURCE_FILESIZE_LIST[n];
    }

    public static final String getFileName(int n) {
        return ResourceConstants.RESOURCE_FILENAMES_LIST[n];
    }

    public final Image loadImage(int n) {
        try {
            return Image.createImage((String)ResourceManager.getFileName(n));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public final InputStream loadBinaryFile(int n) {
        return this.getClass().getResourceAsStream(ResourceManager.getFileName(n));
    }

    public byte[] loadResource(int n) {
        return this.loadFileIntoByteArray(SoundEventConstants.SOUND_DATA_SETS[n]);
    }

    public byte[] loadFileIntoByteArray(int n) {
        int n2 = ResourceConstants.RESOURCE_FILESIZE_LIST[n];
        byte[] byArray = new byte[n2];
        if (byArray == null) {
            return null;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(this.loadBinaryFile(n));
            if (dataInputStream == null) {
                return null;
            }
            dataInputStream.readFully(byArray);
            dataInputStream = null;
        }
        catch (Exception exception) {
            return null;
        }
        return byArray;
    }

    private static final int unsignedByteToInt(byte by) {
        return 0xFF & by;
    }

    private static final int readBigEndianInt(byte[] byArray, int n) {
        int n2 = (byArray[n + 0] & 0xFF) << 24;
        int n3 = (byArray[n + 1] & 0xFF) << 16;
        int n4 = (byArray[n + 2] & 0xFF) << 8;
        int n5 = byArray[n + 3] & 0xFF;
        int n6 = n2 | n3 | n4 | n5;
        return n6;
    }

    private final void buildCRC32LUT() {
        this.m_crcTable = new int[256];
        for (int i = 0; i <= 255; ++i) {
            int n = i;
            for (int j = 8; j > 0; --j) {
                if ((n & 1) == 1) {
                    n = n >>> 1 ^ 0xEDB88320;
                    continue;
                }
                n >>>= 1;
            }
            this.m_crcTable[i] = n;
        }
    }

    public int calcCRC32(byte[] byArray, int n, int n2) {
        int n3 = -1;
        for (int i = n; i < n + n2; ++i) {
            int n4 = 0xFF & byArray[i] ^ n3 & 0xFF;
            n3 = n3 >>> 8 ^ this.m_crcTable[n4];
        }
        return ~n3;
    }

    private void patchPalette(byte[] byArray, int n, int n2, int[] nArray, int[] nArray2) {
        AppEngine.ASSERT(nArray.length == nArray2.length, "sources and patches must be equal length");
        int n3 = nArray.length;
        int n4 = n2 / 3;
        for (int i = 0; i < n3; ++i) {
            if (nArray[i] == 0xFF00FF) continue;
            int n5 = nArray[i];
            int n6 = (n5 & 0xFF0000) >> 16;
            int n7 = (n5 & 0xFF00) >> 8;
            int n8 = (n5 & 0xFF) >> 0;
            int n9 = n;
            for (int j = 0; j < n4; ++j) {
                int n10 = byArray[n9 + 0] & 0xFF;
                int n11 = byArray[n9 + 1] & 0xFF;
                int n12 = byArray[n9 + 2] & 0xFF;
                if (n10 == n6 && n11 == n7 && n12 == n8) {
                    int n13 = (nArray2[i] & 0xFF0000) >> 16;
                    int n14 = (nArray2[i] & 0xFF00) >> 8;
                    int n15 = (nArray2[i] & 0xFF) >> 0;
                    byArray[n9 + 0] = (byte)(n13 & 0xFF);
                    byArray[n9 + 1] = (byte)(n14 & 0xFF);
                    byArray[n9 + 2] = (byte)(n15 & 0xFF);
                }
                n9 += 3;
            }
        }
    }

    private static final void DEBUG_LOADPALIMAGE(String string) {
    }

    public Image loadImage(int n, int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        byte[] byArray = this.loadFileIntoByteArray(n);
        if (ResourceManager.unsignedByteToInt(byArray[0]) != 137 || ResourceManager.unsignedByteToInt(byArray[1]) != 80 || ResourceManager.unsignedByteToInt(byArray[2]) != 78 || ResourceManager.unsignedByteToInt(byArray[3]) != 71 || ResourceManager.unsignedByteToInt(byArray[4]) != 13 || ResourceManager.unsignedByteToInt(byArray[5]) != 10 || ResourceManager.unsignedByteToInt(byArray[6]) != 26 || ResourceManager.unsignedByteToInt(byArray[7]) != 10) {
            return null;
        }
        int n4 = ResourceManager.readBigEndianInt(byArray, 8);
        int n5 = ResourceManager.readBigEndianInt(byArray, 12);
        int n6 = 0;
        int n7 = 0;
        if (n4 > 0 && n5 == 1229472850) {
            n6 = byArray[24];
            n7 = byArray[25];
        }
        if (n6 != 4 && n6 != 8 || n7 != 3) {
            ResourceManager.DEBUG_LOADPALIMAGE("Unable to read IHDR information");
            return null;
        }
        int n8 = 0;
        int n9 = 0;
        int n10 = 8;
        do {
            n3 = ResourceManager.readBigEndianInt(byArray, n10);
            n2 = ResourceManager.readBigEndianInt(byArray, n10 + 4);
            if (n2 != 1347179589) continue;
            ResourceManager.DEBUG_LOADPALIMAGE("found PLTE");
            n8 = n10;
            n9 = n3;
            break;
        } while ((n10 += 12 + n3) < byArray.length);
        this.patchPalette(byArray, n8 + 4 + 4, n9, nArray, nArray2);
        if (n8 > 0) {
            ResourceManager.DEBUG_LOADPALIMAGE("doing new CRC32 for PLTE");
            n3 = this.calcCRC32(byArray, n8 + 4, n9 + 4);
            n2 = n8 + 4 + 4 + n9;
            byArray[n2] = (byte)((n3 & 0xFF000000) >>> 24);
            byArray[n2 + 1] = (byte)((n3 & 0xFF0000) >>> 16);
            byArray[n2 + 2] = (byte)((n3 & 0xFF00) >>> 8);
            byArray[n2 + 3] = (byte)(n3 & 0xFF);
        }
        try {
            Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            if (image != null) {
                return image;
            }
            ResourceManager.DEBUG_LOADPALIMAGE("FAIL: Image from shifted byte array is null");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

