/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.ea.sdk.SDKString;
import constants.AnimConstants;
import constants.ResourceConstants;
import constants.SoundEventConstants;
import game.AppEngine;
import game.MapObjectSim;
import game.SceneGame;
import game.SimData;
import game.SimWorld;
import generic.AnimPlayer;
import generic.AnimationManager;
import generic.MathExt;
import javax.microedition.lcdui.Graphics;

public class MapObject
implements AnimConstants,
ResourceConstants,
SoundEventConstants {
    protected static final int[] s_tempInt10 = new int[10];
    protected final SceneGame m_scene;
    protected final AppEngine m_engine;
    private int m_type;
    private int m_id;
    private short m_typeString;
    private int m_flags;
    private int m_runtimeFlags;
    private int m_state;
    private int m_stateTime;
    private int m_posXF;
    private int m_posZF;
    private int m_facingDir;
    private byte m_footprintWidth;
    private byte m_footprintHeight;
    private boolean m_inView;
    private short m_breakCleanPoints;
    private int m_breakCleanTimer;
    private boolean m_updateCachedStuff;
    private int m_cachedZSortOrderLeft;
    private int m_cachedZSortOrderRight;
    private int m_occupiedFlags;
    private int m_effectMoney;
    private short m_animSetId;
    private AnimPlayer[] m_animPlayers;
    private short m_effectAnimId;
    private int m_zSortOffsetLeft;
    private int m_zSortOffsetRight;
    private MapObjectSim m_postRenderTarget1;
    private MapObjectSim m_postRenderTarget2;

    public final SimData getSimData() {
        return this.m_engine.getSimData();
    }

    public final SimWorld getSimWorld() {
        return this.m_engine.getSimWorld();
    }

    public MapObject(SceneGame sceneGame) {
        this.m_scene = sceneGame;
        this.m_engine = AppEngine.getCanvas();
        this.m_animPlayers = new AnimPlayer[1];
        this.m_animPlayers[0] = new AnimPlayer();
    }

    public void init(int n, int n2, int n3, int n4, int n5) {
        int n6;
        SimWorld simWorld = this.getSimWorld();
        SimData simData = this.getSimData();
        this.setPos(n2, n3);
        this.setFacingDir(n4);
        this.m_type = n;
        this.m_id = n5;
        this.m_flags = simWorld.getObjectFlags(n);
        this.m_runtimeFlags = 0;
        this.m_typeString = (short)simWorld.getObjectStringId(n);
        this.m_zSortOffsetLeft = 0;
        this.m_zSortOffsetRight = 0;
        this.m_postRenderTarget1 = null;
        this.m_postRenderTarget2 = null;
        this.setRuntimeFlag(128);
        this.m_occupiedFlags = 0;
        int n7 = simWorld.getObjectAnimId(n);
        int n8 = simWorld.getObjectAnimSetId(n, 0);
        if (n == 100) {
            n7 = simWorld.getPlayerHouseMMAnim();
            AppEngine.ASSERT(n8 == 0, "player house shouldn't have an animset");
        }
        if (n7 == 203 && n8 != 0) {
            this.setAnimSet(n8);
        } else {
            this.m_animSetId = (short)-1;
            this.setAnim(n7);
        }
        this.setEffectAnimId(-1);
        int n9 = this.getObjectValue();
        int n10 = 0;
        if (n == 9) {
            n10 = 1;
        } else if (n == 92) {
            n10 = n9 & 0xFFFFFF;
            if (n10 != 0 && simWorld.getHouseId() != 0) {
                n6 = simData.getGameTimeAbs();
                int n11 = this.getObjectValueTime();
                if (n11 != -1 && n6 - n11 > 1440) {
                    n10 = 0;
                }
            }
        } else if (simWorld.getObjectParent(n) == 16) {
            n10 = n9 & 0xFFFFFF;
        }
        this.stateTransition(n10);
        if ((n9 & 0x1000000) != 0) {
            this.breakObject();
        }
        if ((n9 & 0x2000000) != 0) {
            this.dirtyObject();
        }
        if (this.getFlag(0xC000000) && !this.getRuntimeFlag(768)) {
            this.m_breakCleanPoints = (short)(n9 & 0xFFFFFF);
            this.m_breakCleanTimer = 0;
            if (this.m_breakCleanPoints == 0) {
                this.m_breakCleanPoints = (short)this.m_engine.rand(0, 100);
            }
        }
        if (this.getParentType() == 10) {
            n6 = 47;
            if (n == 48) {
                n6 = 49;
            } else if (n == 50) {
                n6 = 51;
            } else if (n == 52) {
                n6 = 53;
            }
            MapObject mapObject = this.m_scene.createObject(n6, this.getPosX(), this.getPosZ(), this.getFacingDir(), this.getId());
            mapObject.setZSortOffset(20);
        }
        if (this.getParentType() == 8) {
            this.computerCreateChair();
        }
    }

    public void destroy() {
        if (this.getParentType() == 8) {
            this.computerGetChair().destroy();
        }
        this.m_scene.removeObject(this);
        this.m_postRenderTarget1 = null;
        this.m_postRenderTarget2 = null;
    }

    public void setInView(boolean bl) {
        this.m_inView = bl;
    }

    public boolean isInView() {
        return this.m_inView;
    }

    public final int getType() {
        return this.m_type;
    }

    public final int getParentType() {
        return this.getSimWorld().getObjectParent(this.m_type);
    }

    public final int getId() {
        return this.m_id;
    }

    public final int getTypeString() {
        if (this.getFlag(64)) {
            return this.getHouseTypeString();
        }
        return this.m_typeString;
    }

    public final int getPosX() {
        return this.m_posXF;
    }

    public final int getPosZ() {
        return this.m_posZF;
    }

    public void setPos(int n, int n2) {
        this.m_updateCachedStuff = true;
        this.m_posXF = n;
        this.m_posZF = n2;
    }

    public boolean getFlag(int n) {
        return (this.m_flags & n) != 0;
    }

    public void setFlag(int n) {
        this.m_flags |= n;
    }

    public boolean getRuntimeFlag(int n) {
        return (this.m_runtimeFlags & n) != 0;
    }

    public void setRuntimeFlag(int n, boolean bl) {
        if (bl) {
            this.setRuntimeFlag(n);
        } else {
            this.unsetRuntimeFlag(n);
        }
    }

    public void setRuntimeFlag(int n) {
        this.m_runtimeFlags |= n;
    }

    public void unsetRuntimeFlag(int n) {
        this.m_runtimeFlags &= ~n;
    }

    public void hide() {
        this.setRuntimeFlag(8192);
        if (this.getParentType() == 8) {
            this.computerGetChair().setRuntimeFlag(8192);
        }
    }

    public void unhide() {
        this.unsetRuntimeFlag(8192);
        if (this.getParentType() == 8) {
            this.computerGetChair().unsetRuntimeFlag(8192);
        }
    }

    public void reposition(int n, int n2, int n3) {
        MapObject mapObject = null;
        if (this.getParentType() == 8) {
            mapObject = this.computerGetChair();
        }
        this.setPos(n, n2);
        this.setFacingDir(n3);
        if (mapObject != null) {
            int[] nArray = s_tempInt10;
            this.computerGetChairPosition(nArray);
            mapObject.reposition(nArray[0], nArray[1], nArray[2]);
        }
    }

    protected void updateCachedStuff() {
        if (this.m_updateCachedStuff) {
            this.m_updateCachedStuff = false;
            SimWorld simWorld = this.getSimWorld();
            int n = simWorld.coordWorldToScreenPixelsY(this.m_posXF, this.m_posZF);
            this.m_cachedZSortOrderLeft = n + this.m_zSortOffsetLeft;
            this.m_cachedZSortOrderRight = n + this.m_zSortOffsetRight;
        }
    }

    public int getTooltipStringId() {
        if (this.getFlag(16)) {
            return this.getTypeString();
        }
        return 27;
    }

    public void getHotSpot(int[] nArray) {
        SimWorld simWorld = this.getSimWorld();
        int n = 0;
        int n2 = 0;
        AnimPlayer animPlayer = this.getAnimPlayer(0);
        int n3 = animPlayer.getAnimID();
        int n4 = animPlayer.getCurrAnimFrame();
        if (this.getParentType() == 16) {
            n3 = 278;
            n4 = 0;
        }
        if (n3 != -1) {
            if (AnimationManager.getAnimFrameFirePoint(nArray, n3, n4, 0)) {
                n = nArray[0];
                n2 = nArray[1];
            } else if (this.getFlag(16384)) {
                n2 -= this.m_scene.isMapMode() ? 7 : 38;
            }
        }
        nArray[0] = simWorld.coordWorldToScreenX(this.getPosX(), this.getPosZ()) + (n << 16);
        nArray[1] = simWorld.coordWorldToScreenY(this.getPosX(), this.getPosZ()) + (n2 << 16);
    }

    public void getInterestPoint(int[] nArray, int n) {
        SimWorld simWorld = this.getSimWorld();
        int n2 = simWorld.coordWorldToWorldTileX(this.getPosX());
        int n3 = simWorld.coordWorldToWorldTileZ(this.getPosZ());
        int n4 = simWorld.getObjectInterestPointX(this.getType(), n, this.getFacingDir());
        int n5 = simWorld.getObjectInterestPointZ(this.getType(), n, this.getFacingDir());
        int n6 = n2 + n4;
        int n7 = n3 + n5;
        nArray[0] = simWorld.coordWorldTileToWorldCenterX(n6);
        nArray[1] = simWorld.coordWorldTileToWorldCenterZ(n7);
    }

    public int getClosestInterestPoint(int n, int n2, boolean bl, MapObjectSim mapObjectSim) {
        SimWorld simWorld = this.getSimWorld();
        int[] nArray = s_tempInt10;
        int n3 = simWorld.getObjectInterestPointCount(this.getType());
        if (n3 > 0) {
            int n4 = -1;
            int n5 = Integer.MAX_VALUE;
            for (int i = 0; i < n3; ++i) {
                int n6;
                int n7;
                int n8;
                if (bl && !this.occupiedIsAvailable(i)) continue;
                this.getInterestPoint(nArray, i);
                int n9 = nArray[0];
                int n10 = nArray[1];
                if (!simWorld.isWorldPointWalkable(n9, n10)) continue;
                if (bl && !this.getFlag(0x400000)) {
                    n8 = simWorld.coordWorldToWorldTileX(n9);
                    n7 = simWorld.coordWorldToWorldTileZ(n10);
                    n6 = 0;
                    MapObjectSim[] mapObjectSimArray = this.m_scene.getSimObjects();
                    for (int j = 0; j < mapObjectSimArray.length && n6 == 0; ++j) {
                        MapObjectSim mapObjectSim2 = mapObjectSimArray[j];
                        if (mapObjectSim2 == mapObjectSim) continue;
                        int n11 = simWorld.coordWorldToWorldTileX(mapObjectSim2.getPosX());
                        int n12 = simWorld.coordWorldToWorldTileZ(mapObjectSim2.getPosZ());
                        if (n11 != n8 || n12 != n7) continue;
                        n6 = 1;
                    }
                    if (n6 != 0) continue;
                }
                if ((n6 = (n8 = Math.abs(n - n9)) + (n7 = Math.abs(n2 - n10))) >= n5) continue;
                n5 = n6;
                n4 = i;
            }
            return n4;
        }
        return -1;
    }

    public boolean occupiedCapture(int n, MapObjectSim mapObjectSim) {
        if (this.getFlag(0x400000)) {
            return true;
        }
        if (this.getFlag(0x800000)) {
            if ((this.m_occupiedFlags & 1 << n) == 0) {
                this.m_occupiedFlags |= 1 << n;
                return true;
            }
        } else if (this.m_occupiedFlags == 0) {
            this.m_occupiedFlags = -1;
            return true;
        }
        return false;
    }

    public void occupiedRelease(int n) {
        if (this.getFlag(0x800000)) {
            AppEngine.ASSERT((this.m_occupiedFlags & 1 << n) != 0, "releasing already unoccupied flag");
            this.m_occupiedFlags &= ~(1 << n);
        } else {
            this.m_occupiedFlags = 0;
        }
    }

    public boolean occupiedIsEmpty() {
        if (this.getFlag(0x400000)) {
            return true;
        }
        return this.m_occupiedFlags == 0;
    }

    public boolean occupiedIsAnyAvailable() {
        if (this.occupiedIsEmpty()) {
            return true;
        }
        int n = this.getSimWorld().getObjectInterestPointCount(this.getType());
        return this.m_occupiedFlags < (1 << n) - 1;
    }

    public boolean occupiedIsAvailable(int n) {
        return (this.m_occupiedFlags & 1 << n) == 0;
    }

    private int getObjectValue() {
        if (this.getId() == -1) {
            return 0;
        }
        SimWorld simWorld = this.getSimWorld();
        SimData simData = this.getSimData();
        return simData.getObjectValue(simWorld.getHouseId(), this.getId());
    }

    private int getObjectValueTime() {
        if (this.getId() == -1) {
            return -1;
        }
        SimWorld simWorld = this.getSimWorld();
        SimData simData = this.getSimData();
        return simData.getObjectValueTime(simWorld.getHouseId(), this.getId());
    }

    private void saveObjectValue() {
        if (this.getId() == -1) {
            return;
        }
        SimWorld simWorld = this.getSimWorld();
        SimData simData = this.getSimData();
        int n = 0;
        if (this.getType() == 92) {
            n = this.m_state;
        } else if (this.getParentType() == 16) {
            n = this.m_state;
        }
        if (this.getFlag(0x4000000) && this.getRuntimeFlag(256)) {
            n |= 0x1000000;
        }
        if (this.getFlag(0x8000000) && this.getRuntimeFlag(512)) {
            n |= 0x2000000;
        }
        if (simWorld.getHouseId() == 0 && this.getFlag(0xC000000)) {
            n |= this.m_breakCleanPoints;
        }
        if (this.getRuntimeFlag(32768)) {
            n |= 0x8000000;
        }
        if (this.getRuntimeFlag(16384)) {
            n |= 0x4000000;
        }
        if (this.getRuntimeFlag(65536)) {
            n |= 0x10000000;
        }
        simData.saveObjectValue(simWorld.getHouseId(), this.getId(), n);
    }

    public boolean isIdle() {
        if (this.getParentType() == 16) {
            return !this.isAnimating() && !this.isAnimating(1) && this.m_state != 1;
        }
        return this.m_state == 0;
    }

    public boolean isActive() {
        if (this.getParentType() == 16 && (this.isAnimating() || this.isAnimating(1))) {
            return false;
        }
        return this.m_state == 1;
    }

    protected final void stateTransition(int n) {
        int n2 = this.getParentType();
        if (n2 == 2) {
            this.basinStateTransition(n);
        } else if (n2 == 3) {
            this.bathStateTransition(n);
        } else if (n2 == 7) {
            this.coffeeMachineStateTransition(n);
        } else if (n2 == 8) {
            this.computerStateTransition(n);
        } else if (n2 == 10) {
            this.doorStateTransition(n);
        } else if (n2 == 17) {
            this.showerStateTransition(n);
        } else if (n2 == 19) {
            this.stoveStateTransition(n);
        } else if (n2 == 16) {
            this.plantStateTransition(n);
        } else if (this.getType() == 92) {
            this.trashCanStateTransition(n);
        }
        this.m_state = n;
        this.m_stateTime = 0;
        if (this.getType() == 92) {
            this.saveObjectValue();
        }
    }

    public void update(int n) {
        this.m_stateTime += n;
        if (this.getFlag(0xC000000) && !this.getRuntimeFlag(768)) {
            this.m_breakCleanTimer += n;
            if (this.m_breakCleanTimer > 4000) {
                this.m_breakCleanTimer -= 4000;
                this.addBreakCleanPoints(1);
            }
        }
        if (this.getRuntimeFlag(1)) {
            n = this.m_scene.getNormalTimeStep();
        }
        int n2 = this.getType();
        int n3 = this.getParentType();
        if (n3 == 3) {
            this.bathUpdate(n);
        } else if (n3 == 16) {
            this.plantUpdate(n);
        } else {
            this.updateAnim(n);
            if (!this.isAnimating()) {
                if (n3 == 7) {
                    this.stateTransition(2);
                } else if (this.getType() == 92 && this.m_state == 2) {
                    this.stateTransition(1);
                }
            }
            if (n3 == 8) {
                this.updateAnimPlayer(n, 2);
                if (!this.isAnimating(2)) {
                    if (this.m_state == 2) {
                        this.stateTransition(1);
                    } else {
                        this.stateTransition(0);
                    }
                }
            }
        }
        if (n2 == 7) {
            if (!this.isAnimating()) {
                this.destroy();
            }
        } else if (n2 == 8 && this.m_stateTime > 1500) {
            this.destroy();
        }
    }

    protected void updateAnim(int n) {
        if (this.getRuntimeFlag(2048)) {
            n = MathExt.Fmul(n << 16, 81920) >> 16;
        } else if (this.getRuntimeFlag(4096)) {
            n = MathExt.Fmul(n << 16, 49152) >> 16;
        }
        boolean bl = this.updateAnimPlayer(n, 0);
        if (this.updateAnimPlayer(n, 1)) {
            bl = true;
        }
        if (this.m_effectAnimId != -1 && bl) {
            this.spawnEffects();
        }
    }

    protected boolean updateAnimPlayer(int n, int n2) {
        AnimPlayer animPlayer = this.getAnimPlayer(n2);
        if (animPlayer != null) {
            return animPlayer.updateAnim(n);
        }
        return false;
    }

    protected final void spawnEffects() {
        int n;
        int[] nArray = s_tempInt10;
        AnimPlayer animPlayer = this.getAnimPlayer(0);
        AnimPlayer animPlayer2 = this.getAnimPlayer(1);
        int n2 = 1;
        AnimPlayer animPlayer3 = animPlayer;
        int n3 = 0;
        int n4 = 0;
        if (animPlayer2 != null && animPlayer2.isAnimating()) {
            animPlayer3 = animPlayer2;
            n2 = 0;
            if (animPlayer.getFirePointCurrFrame(nArray, 1)) {
                n3 = nArray[0];
                n4 = nArray[1];
            } else if (this.getRuntimeFlag(1024)) {
                n4 = -30;
            }
        }
        if ((n = animPlayer3.getNumFirePointsCurrFrame()) > n2) {
            SimWorld simWorld = this.getSimWorld();
            if (this.getParentType() == 16) {
                int n5 = animPlayer3.getCurrAnimFrame();
                int n6 = this.fruitPerHarvest();
                int n7 = 2 + n6 - n5;
                AppEngine.ASSERT(n7 >= 2 && n7 <= 9, "too many fruit spawns!");
                this.DEBUG_PLANT("spawn fruit");
                this.getAnimPlayerCreate(n7).startAnim(this.m_effectAnimId, 16);
                return;
            }
            for (int i = n2; i < n; ++i) {
                int n8 = this.getPosX();
                int n9 = this.getPosZ();
                int n10 = simWorld.coordWorldToScreenX(n8, n9);
                int n11 = simWorld.coordWorldToScreenY(n8, n9);
                animPlayer3.getFirePointCurrFrame(nArray, i);
                n8 = simWorld.coordScreenToWorldX(n10 += nArray[0] + n3 << 16, n11 += nArray[1] + n4 << 16);
                n9 = simWorld.coordScreenToWorldZ(n10, n11);
                int n12 = -(nArray[1] + n4);
                if (this.getFlag(524288)) {
                    n12 += 5;
                }
                this.m_scene.createEffectAnim(n8, n9, this.m_effectAnimId, n12);
            }
        }
    }

    public boolean respondToAction(int n, MapObjectSim mapObjectSim) {
        if (this.getType() == 92) {
            if (n == 150) {
                this.stateTransition(0);
            }
        } else if (this.getType() == 9) {
            if (n == 151) {
                if (this.getId() != -1) {
                    this.getSimWorld().objectSell(this.getId());
                }
                this.destroy();
            }
        } else if (this.getParentType() == 10) {
            if (n == 152 || n == 155) {
                this.stateTransition(1);
                if (mapObjectSim.getId() == 0 && !this.getSimData().getSimCurRelStateFlags(0, 1)) {
                    this.m_scene.advertiseEvent(23, mapObjectSim, this);
                }
            } else if (n == 153) {
                if (!this.m_scene.isObjectAt(0, this.getPosX(), this.getPosZ())) {
                    this.stateTransition(0);
                }
            } else if (n == 154 && mapObjectSim.getId() == 0) {
                this.m_scene.advertiseEvent(24, mapObjectSim, this);
            }
        } else if (this.getParentType() == 22) {
            if (n == 133) {
                this.unsetRuntimeFlag(16384);
                this.setRuntimeFlag(32768);
                this.saveObjectValue();
            } else if (n == 132) {
                this.setRuntimeFlag(16384);
                this.unsetRuntimeFlag(32768);
                this.saveObjectValue();
            }
        } else if (this.getParentType() == 16 && n == 114) {
            this.setRuntimeFlag(65536);
            this.saveObjectValue();
        }
        return false;
    }

    public void breakObject() {
        this.setRuntimeFlag(256);
        switch (this.getParentType()) {
            case 15: 
            case 22: 
            case 23: {
                this.turnOff();
            }
        }
        this.saveObjectValue();
        this.setSecondaryAnim(29, 20);
        this.m_scene.showTutorialMessage((byte)8);
    }

    public void repairObject() {
        this.unsetRuntimeFlag(256);
        this.saveObjectValue();
        this.stopSecondaryAnim();
    }

    public void dirtyObject() {
        this.setRuntimeFlag(512);
        this.saveObjectValue();
        this.setSecondaryAnim(42, 20);
        this.m_scene.showTutorialMessage((byte)9);
    }

    public void cleanObject() {
        this.unsetRuntimeFlag(512);
        this.saveObjectValue();
        this.stopSecondaryAnim();
    }

    public void addBreakCleanPoints(int n) {
        if (this.getSimWorld().getHouseId() != 0) {
            return;
        }
        this.m_breakCleanPoints = (short)(this.m_breakCleanPoints + n);
        if (this.m_breakCleanPoints > 300) {
            this.m_breakCleanPoints = 0;
            if (this.getFlag(0x4000000)) {
                this.breakObject();
            } else {
                this.dirtyObject();
            }
        }
        this.saveObjectValue();
    }

    public void turnOn() {
        int n = this.getParentType();
        if (n == 15 || n == 22 || n == 18 || n == 23) {
            this.setAnimSetIndex(1);
        }
        if (n == 22 && !this.getRuntimeFlag(49152)) {
            this.setRuntimeFlag(32768);
        } else if (n == 8) {
            this.stateTransition(2);
        }
        this.setRuntimeFlag(64);
        this.addBreakCleanPoints(15);
    }

    public void turnOff() {
        int n = this.getParentType();
        if (n == 15 || n == 22 || n == 18 || n == 23) {
            this.setAnimSetIndex(0);
        } else if (n == 8) {
            this.stateTransition(3);
        }
        this.unsetRuntimeFlag(64);
        this.addBreakCleanPoints(15);
    }

    public void effectPlayAnim(int n, int n2) {
        this.unsetRuntimeFlag(128);
        this.setAnim(n);
        if (n == 36 || n == 37) {
            this.setRuntimeFlag(1);
        }
        this.setZSortOffset(n2);
    }

    public void effectShowMoney(int n) {
        this.m_effectMoney = n;
        this.setAnim(203);
        this.setZSortOffset(30);
    }

    private void renderMoneyEffect(int n, int n2) {
        AppEngine appEngine = this.m_engine;
        int n3 = MathExt.smoothstepF(0, 1500, this.m_stateTime);
        int n4 = -40 + MathExt.Fmul(n3, -30);
        SDKString sDKString = appEngine.clearStringBuffer();
        appEngine.appendMoneyToBuffer(this.m_effectMoney);
        appEngine.drawString(sDKString, 0, n, n2 + n4, 17);
    }

    public void basinStart() {
        this.stateTransition(1);
    }

    public void basinEnd() {
        this.stateTransition(0);
    }

    private void basinStateTransition(int n) {
        int n2;
        int n3;
        switch (n) {
            default: {
                AppEngine.ASSERT(false, "invalid state for basin");
            }
            case 0: {
                n3 = -1;
                n2 = 0;
                break;
            }
            case 1: {
                n3 = 45;
                n2 = 1;
            }
        }
        this.setEffectAnimId(n3);
        this.setAnimSetIndex(n2);
    }

    public void bathToFill() {
        if (this.m_state == 0 || this.m_state == 3) {
            this.stateTransition(2);
        }
    }

    public void bathToEmpty() {
        if (this.m_state == 1 || this.m_state == 2) {
            this.stateTransition(3);
        }
    }

    public boolean bathIsFull() {
        return this.m_state == 1;
    }

    public void getBathSimPos(int[] nArray) {
        SimWorld simWorld = this.getSimWorld();
        int n = simWorld.coordWorldToScreenPixelsX(this.getPosX(), this.getPosZ());
        int n2 = simWorld.coordWorldToScreenPixelsY(this.getPosX(), this.getPosZ());
        AnimPlayer animPlayer = this.getAnimPlayer(2);
        animPlayer.getFirePointCurrFrame(nArray, 0);
        nArray[0] = nArray[0] + n;
        nArray[1] = nArray[1] + n2;
    }

    private void bathUpdate(int n) {
        this.updateAnim(n);
        this.updateAnimPlayer(n, 2);
        if (!this.isAnimating(2)) {
            if (this.m_state == 2) {
                this.stateTransition(1);
            } else if (this.m_state == 3) {
                this.stateTransition(0);
            }
        }
    }

    private void bathStateTransition(int n) {
        int n2 = -1;
        boolean bl = true;
        switch (n) {
            default: {
                AppEngine.ASSERT(false, "invalid state for bath");
            }
            case 0: {
                break;
            }
            case 2: {
                n2 = 157;
                bl = false;
                break;
            }
            case 1: {
                n2 = 158;
                break;
            }
            case 3: {
                n2 = 159;
                bl = false;
            }
        }
        AnimPlayer animPlayer = this.getAnimPlayerCreate(2);
        if (n2 != -1) {
            int n3 = this.getSimWorld().getAnim(n2, this.getFacingDir());
            animPlayer.startAnim(n3, bl ? 20 : 16);
        } else {
            animPlayer.setAnimating(false);
        }
    }

    public int bedGetRelStateFlags() {
        MapObject[] mapObjectArray = this.m_scene.getObjects();
        MapObject mapObject = null;
        for (int i = 0; i < mapObjectArray.length; ++i) {
            MapObject mapObject2 = mapObjectArray[i];
            if (mapObject2 == this || mapObject2.getParentType() != 4) continue;
            mapObject = mapObject2;
            break;
        }
        if (mapObject != null) {
            return this.getId() < mapObject.getId() ? 512 : 1024;
        }
        return 512;
    }

    public boolean chairShouldSnap() {
        int n;
        int n2;
        SimWorld simWorld = this.getSimWorld();
        return !simWorld.isAgainstWall(n2 = simWorld.coordWorldToWorldTileX(this.getPosX()), n = simWorld.coordWorldToWorldTileZ(this.getPosZ()), 1, 1, this.getFacingDir()) && this.getType() != 40;
    }

    public MapObject computerChairGetComputer() {
        MapObject[] mapObjectArray = this.m_scene.getObjects();
        for (int i = 0; i < mapObjectArray.length; ++i) {
            MapObject mapObject = mapObjectArray[i];
            if (mapObject.getParentType() != 8 || mapObject.computerGetChair() != this) continue;
            return mapObject;
        }
        return null;
    }

    public void coffeeMachineActivate() {
        this.stateTransition(1);
    }

    public void coffeeMachineDeactivate() {
        this.stateTransition(0);
    }

    private void coffeeMachineStateTransition(int n) {
        int n2 = 0;
        boolean bl = true;
        int n3 = -1;
        if (n == 1) {
            n2 = 1;
            bl = false;
            n3 = 43;
        }
        this.m_effectAnimId = (short)n3;
        this.setRuntimeFlag(128, bl);
        this.setAnimSetIndex(n2);
    }

    public boolean coffeeMachineIsReady() {
        return this.m_state == 2;
    }

    private void computerCreateChair() {
        int n = 40;
        int[] nArray = s_tempInt10;
        this.computerGetChairPosition(nArray);
        this.m_scene.createObject(n, nArray[0], nArray[1], nArray[2], -1);
    }

    private void computerGetChairPosition(int[] nArray) {
        int n = this.getPosX();
        int n2 = this.getPosZ();
        int n3 = 3;
        if (this.getFacingDir() == 0) {
            n += 524288;
            n2 -= 524288;
            n3 = 2;
        } else {
            n -= 524288;
            n2 += 524288;
        }
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n3;
    }

    public MapObject computerGetChair() {
        int[] nArray = s_tempInt10;
        this.computerGetChairPosition(nArray);
        return this.m_scene.findObjectByTypeNearest(40, nArray[0], nArray[1]);
    }

    public void computerStateTransition(int n) {
        this.m_state = n;
        int n2 = -1;
        int n3 = 20;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                n3 = 16;
                break;
            }
            case 3: {
                n2 = 3;
                n3 = 16;
            }
        }
        if (n2 != -1) {
            SimWorld simWorld = this.getSimWorld();
            int n4 = simWorld.getObjectAnimSetId(this.getType(), n2);
            int n5 = simWorld.getAnim(n4, this.getFacingDir());
            this.getAnimPlayerCreate(2).startAnim(n5, n3);
        } else {
            this.getAnimPlayerCreate(2).setAnimating(false);
        }
    }

    private void doorStateTransition(int n) {
        this.m_state = n;
        int n2 = -1;
        int n3 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                n3 = 0;
                this.unsetRuntimeFlag(64);
                break;
            }
            case 1: {
                n2 = 1;
                n3 = -15;
                this.setRuntimeFlag(64);
            }
        }
        this.setAnimSetIndex(n2);
        this.applyFootprint(!this.getRuntimeFlag(64));
        this.setZSortOffset(n3);
    }

    public void fridgeOpen() {
        this.setAnimSetIndex(1);
    }

    public void fridgeClose() {
        this.setAnimSetIndex(0);
        this.addBreakCleanPoints(15);
    }

    private final int getHouseTypeString() {
        int n = -1;
        int n2 = -1;
        int n3 = this.getSimWorld().getHouseForObject(this.getType());
        SimData simData = this.getSimData();
        int n4 = simData.getSimCount();
        for (int i = 0; i < n4; ++i) {
            int n5 = simData.getSimHome(i);
            if (n5 != n3) continue;
            if (n == -1) {
                n = i;
                continue;
            }
            if (n2 == -1) {
                n2 = i;
                continue;
            }
            AppEngine.ASSERT(false, "argh, three sims in the one house!");
        }
        if (n == -1 && n2 == -1) {
            return 208;
        }
        AppEngine appEngine = this.m_engine;
        SDKString sDKString = n == 0 ? appEngine.getSimName() : appEngine.getString(simData.getSimName(n));
        if (n2 == -1) {
            appEngine.dynamicString(-10, 209, sDKString);
        } else {
            SDKString sDKString2 = appEngine.getString(simData.getSimName(n2));
            appEngine.dynamicString(-10, 210, sDKString, sDKString2);
        }
        return -10;
    }

    private void DEBUG_PLANT(String string) {
    }

    private static final int plantForSeed(int n) {
        switch (n) {
            case 9: {
                return 18;
            }
            case 10: {
                return 21;
            }
            case 11: {
                return 19;
            }
            case 12: {
                return 22;
            }
            case 13: {
                return 20;
            }
        }
        AppEngine.ASSERT(false, "invalid seed type");
        return -1;
    }

    private static final int fruitAnimForPlant(int n, int n2) {
        switch (n) {
            case 18: {
                return 272;
            }
            case 21: {
                return n2 == 0 ? 270 : 271;
            }
            case 19: {
                return 273;
            }
            case 20: {
                return 274;
            }
            case 22: {
                return n2 == 0 ? 276 : 277;
            }
        }
        AppEngine.ASSERT(false, "invalid plant type");
        return -1;
    }

    private static final int fruitItemForPlant(int n) {
        switch (n) {
            case 18: {
                return 15;
            }
            case 21: {
                return 16;
            }
            case 19: {
                return 17;
            }
            case 22: {
                return 19;
            }
            case 20: {
                return 23;
            }
        }
        AppEngine.ASSERT(false, "invalid plant type");
        return -1;
    }

    private int fruitPerHarvest() {
        if (this.isGroundPlant()) {
            return 5;
        }
        return 8;
    }

    private boolean isGroundPlant() {
        return (this.getSimWorld().getObjectFlags(this.getType()) & 0x10000) != 0;
    }

    public void plantSeed(int n) {
        int n2;
        this.DEBUG_PLANT("plantSeed");
        SimWorld simWorld = this.getSimWorld();
        this.m_type = n2 = MapObject.plantForSeed(n);
        simWorld.objectChange(this.getId(), n2);
        this.m_typeString = (short)simWorld.getObjectStringId(n2);
        this.m_state = 2;
        this.saveObjectValue();
        this.unsetRuntimeFlag(128);
        if (this.isGroundPlant()) {
            this.setAnim(279);
            this.setSecondaryAnim(275, 16);
            this.setEffectAnimId(MapObject.fruitAnimForPlant(n2, 0));
        } else {
            this.setAnim(280);
        }
        this.DEBUG_PLANT("plantSeeded");
    }

    public void plantGrow() {
        this.DEBUG_PLANT("plantGrow");
        boolean bl = false;
        switch (this.m_state) {
            default: {
                AppEngine.ASSERT(false, "invalid state for plant growth");
            }
            case 2: {
                if (this.isGroundPlant()) {
                    bl = true;
                    this.m_state = 1;
                    this.unsetRuntimeFlag(128);
                    this.setAnim(279);
                    this.setSecondaryAnim(275, 16);
                    this.setEffectAnimId(MapObject.fruitAnimForPlant(this.getType(), 1));
                    break;
                }
                this.m_state = 3;
                this.unsetRuntimeFlag(128);
                this.setAnim(281);
                break;
            }
            case 3: {
                bl = true;
                this.m_state = 1;
                this.unsetRuntimeFlag(128);
                this.setAnim(282);
                this.setSecondaryAnim(283, 16);
                this.setEffectAnimId(MapObject.fruitAnimForPlant(this.getType(), 0));
            }
        }
        if (bl) {
            SimData simData = this.getSimData();
            simData.dreamCompleteEvent(39);
            if (this.getType() == 21) {
                simData.dreamCompleteEvent(40);
            } else if (this.getType() == 19) {
                simData.dreamCompleteEvent(41);
            } else if (this.getType() == 20) {
                simData.dreamCompleteEvent(42);
            }
        }
        this.saveObjectValue();
        this.DEBUG_PLANT("plantGrowing");
    }

    private void plantClearFruit() {
        this.setSecondaryAnim(203, 16);
        for (int i = 2; i <= 9; ++i) {
            AnimPlayer animPlayer = this.getAnimPlayer(i);
            if (animPlayer == null) continue;
            animPlayer.startAnim(203, 16);
        }
    }

    private void plantCreateFruit(int n) {
        int n2 = MapObject.fruitAnimForPlant(this.getType(), n);
        int n3 = this.fruitPerHarvest();
        int n4 = 2 + n3 - 1;
        for (int i = 0; i < n3; ++i) {
            AnimPlayer animPlayer = this.getAnimPlayerCreate(n4 - i);
            animPlayer.startAnim(n2, 16);
            animPlayer.setLastFrame();
        }
    }

    public void plantHarvest() {
        this.DEBUG_PLANT("plantHarvest");
        int n = MapObject.fruitItemForPlant(this.getType());
        int n2 = this.fruitPerHarvest();
        if (this.getRuntimeFlag(65536)) {
            n2 += 2;
            this.unsetRuntimeFlag(65536);
        }
        this.getSimData().registerHarvest(n2);
        this.getSimData().adjustInventory(n, n2);
        this.m_scene.showGetItem(n, n2, 296, 722);
        if (this.isGroundPlant()) {
            this.plantUproot();
        } else {
            this.stateTransition(3);
        }
        this.plantClearFruit();
        this.saveObjectValue();
    }

    public void plantUproot() {
        this.m_type = 17;
        this.getSimWorld().objectChange(this.getId(), 17);
        this.m_typeString = (short)this.getSimWorld().getObjectStringId(17);
        this.m_state = 0;
        this.plantClearFruit();
        this.unsetRuntimeFlag(128);
        this.setAnim(278);
        this.saveObjectValue();
        this.DEBUG_PLANT("plantUprooted");
    }

    private void plantStateTransition(int n) {
        int n2;
        this.m_state = n;
        switch (n) {
            default: {
                AppEngine.ASSERT(false, "invalid state for shower");
            }
            case 0: {
                n2 = 278;
                break;
            }
            case 2: {
                if (this.isGroundPlant()) {
                    this.plantCreateFruit(0);
                    n2 = 279;
                    AnimPlayer animPlayer = this.getAnimPlayerCreate(1);
                    animPlayer.startAnim(275, 16);
                    animPlayer.setLastFrame();
                    break;
                }
                n2 = 280;
                break;
            }
            case 3: {
                n2 = 281;
                break;
            }
            case 1: {
                this.plantCreateFruit(1);
                int n3 = 283;
                n2 = 282;
                if (this.isGroundPlant()) {
                    n3 = 275;
                    n2 = 279;
                }
                AnimPlayer animPlayer = this.getAnimPlayerCreate(1);
                animPlayer.startAnim(n3, 16);
                animPlayer.setLastFrame();
                break;
            }
        }
        this.unsetRuntimeFlag(128);
        this.setAnim(n2);
        this.getAnimPlayer(0).setLastFrame();
    }

    private void plantUpdate(int n) {
        int n2 = this.fruitPerHarvest();
        for (int i = 0; i < n2; ++i) {
            this.updateAnimPlayer(n, 2 + i);
        }
        this.updateAnim(n);
    }

    public void phonePickup() {
        this.setAnimSetIndex(1);
    }

    public void phoneHangup() {
        this.setAnimSetIndex(0);
    }

    public void showerStart() {
        this.stateTransition(1);
    }

    public void showerEnd() {
        this.addBreakCleanPoints(15);
        this.stateTransition(0);
    }

    private void showerStateTransition(int n) {
        int n2;
        int n3;
        this.m_state = n;
        switch (n) {
            default: {
                AppEngine.ASSERT(false, "invalid state for shower");
            }
            case 0: {
                n3 = -1;
                n2 = 0;
                break;
            }
            case 1: {
                n3 = 43;
                n2 = 1;
            }
        }
        this.setEffectAnimId(n3);
        this.setAnimSetIndex(n2);
    }

    public void stoveStart() {
        this.stateTransition(1);
    }

    public void stoveEnd() {
        this.stateTransition(0);
    }

    private void stoveStateTransition(int n) {
        int n2;
        int n3;
        this.m_state = n;
        switch (n) {
            default: {
                AppEngine.ASSERT(false, "invalid state for stove");
            }
            case 0: {
                n3 = -1;
                n2 = 0;
                break;
            }
            case 1: {
                n3 = 43;
                n2 = 1;
            }
        }
        this.setEffectAnimId(n3);
        this.setAnimSetIndex(n2);
    }

    public void trashCanKick(MapObjectSim mapObjectSim) {
        this.m_scene.advertiseEvent(21, mapObjectSim, this);
        this.setFacingObject(mapObjectSim);
        this.setFacingDir((this.m_facingDir + 2) % 4);
        this.stateTransition(2);
    }

    private void trashCanStateTransition(int n) {
        int n2;
        AppEngine.ASSERT(true, "idle state for trashcan must be 0 to match default persistant value");
        boolean bl = true;
        switch (n) {
            default: {
                AppEngine.ASSERT(false, "invalid state for trashcan");
            }
            case 0: {
                this.stopSecondaryAnim();
                n2 = 0;
                break;
            }
            case 2: {
                this.setSecondaryAnim(42, 20);
                n2 = 1;
                bl = false;
                break;
            }
            case 1: {
                this.setSecondaryAnim(42, 4);
                n2 = 2;
            }
        }
        this.setRuntimeFlag(128, bl);
        this.setAnimSetIndex(n2);
    }

    protected AnimPlayer getAnimPlayer(int n) {
        if (n < this.m_animPlayers.length) {
            return this.m_animPlayers[n];
        }
        return null;
    }

    protected AnimPlayer getAnimPlayerCreate(int n) {
        Object object;
        if (n >= this.m_animPlayers.length) {
            object = new AnimPlayer[n + 1];
            System.arraycopy(this.m_animPlayers, 0, object, 0, this.m_animPlayers.length);
            this.m_animPlayers = object;
        }
        if (this.m_animPlayers[n] == null) {
            this.m_animPlayers[n] = object = new AnimPlayer();
            ((AnimPlayer)object).setAnimating(false);
        }
        return this.m_animPlayers[n];
    }

    protected void setSecondaryAnim(int n, int n2) {
        AnimPlayer animPlayer = this.getAnimPlayerCreate(1);
        animPlayer.startAnim(n, n2);
    }

    protected void stopSecondaryAnim() {
        AnimPlayer animPlayer = this.getAnimPlayer(1);
        if (animPlayer != null) {
            animPlayer.setAnimating(false);
        }
    }

    public void setEffectAnimId(int n) {
        this.m_effectAnimId = (short)n;
    }

    public int getZSortOrderLeft() {
        this.updateCachedStuff();
        return this.m_cachedZSortOrderLeft;
    }

    public int getZSortOrderRight() {
        this.updateCachedStuff();
        return this.m_cachedZSortOrderRight;
    }

    public void setZSortOffset(int n) {
        this.m_zSortOffsetLeft = n;
        this.m_zSortOffsetRight = n;
        this.m_updateCachedStuff = true;
    }

    public void setPostRenderTarget(MapObjectSim mapObjectSim) {
        if (this.m_postRenderTarget1 == null) {
            this.m_postRenderTarget1 = mapObjectSim;
        } else if (this.m_postRenderTarget2 == null) {
            this.m_postRenderTarget2 = mapObjectSim;
        } else {
            AppEngine.ASSERT(false, "can't have three post-render targets");
        }
    }

    public void releasePostRenderTarget(MapObjectSim mapObjectSim) {
        if (this.m_postRenderTarget1 == mapObjectSim) {
            this.m_postRenderTarget1 = null;
        }
        if (this.m_postRenderTarget2 == mapObjectSim) {
            this.m_postRenderTarget2 = null;
        }
    }

    public void render2D(Graphics graphics) {
        AnimPlayer animPlayer;
        int n;
        int n2;
        AnimPlayer animPlayer2;
        SimWorld simWorld = this.getSimWorld();
        int[] nArray = s_tempInt10;
        int n3 = simWorld.getCameraPixelX();
        int n4 = simWorld.getCameraPixelY();
        int n5 = n3 + simWorld.coordWorldToScreenPixelsX(this.getPosX(), this.getPosZ());
        int n6 = n4 + simWorld.coordWorldToScreenPixelsY(this.getPosX(), this.getPosZ());
        if (this.getType() == 8) {
            this.renderMoneyEffect(n5, n6);
            return;
        }
        AnimPlayer animPlayer3 = this.getAnimPlayer(0);
        animPlayer3.drawAnim(graphics, n5, n6);
        int n7 = this.getParentType();
        if (n7 == 8 && (animPlayer2 = this.getAnimPlayer(2)) != null && animPlayer2.isAnimating()) {
            animPlayer2.drawAnim(graphics, n5, n6);
        }
        int n8 = n5;
        int n9 = n6;
        AnimPlayer animPlayer4 = this.getAnimPlayer(1);
        if (animPlayer4 != null && animPlayer4.isAnimating()) {
            if (animPlayer3.getFirePointCurrFrame(nArray, 1)) {
                n8 += nArray[0];
                n9 += nArray[1];
            } else if (animPlayer3.getFirePointCurrFrame(nArray, 0)) {
                n8 += nArray[0];
                n9 += nArray[1];
            }
            animPlayer4.drawAnim(graphics, n8, n9);
        }
        if (n7 == 16 && animPlayer4 != null && (n2 = animPlayer4.getAnimID()) != 203) {
            n = this.fruitPerHarvest();
            for (int i = n - 1; i >= 0; --i) {
                AnimPlayer animPlayer5 = this.getAnimPlayer(2 + i);
                if (animPlayer5 == null) continue;
                int n10 = n - i;
                AnimationManager.getAnimFrameFirePoint(nArray, n2, n10, 0);
                int n11 = n8 + nArray[0];
                int n12 = n9 + nArray[1];
                animPlayer5.drawAnim(graphics, n11, n12);
            }
        }
        if (n7 == 3 && (animPlayer = this.getAnimPlayer(2)).isAnimating()) {
            animPlayer.drawAnim(graphics, n5, n6);
        }
        if (this.getFlag(0x2000000)) {
            if (this.m_postRenderTarget1 != null) {
                this.m_postRenderTarget1.render2DPost(graphics);
            }
            if (this.m_postRenderTarget2 != null) {
                this.m_postRenderTarget2.render2DPost(graphics);
            }
            n2 = simWorld.getObjectAnimSetId(this.getType(), 1);
            n = simWorld.getAnim(n2, this.getFacingDir());
            AnimationManager.drawAnimFrame(graphics, n, 0, n5, n6);
        }
    }

    public void createBuildContextMenu(short[] sArray) {
        AppEngine.menuClear(sArray, this.m_typeString);
        if (!this.buildInUse()) {
            if (this.buildCanRotate()) {
                AppEngine.menuAppendItem(sArray, 333);
            }
            if (this.buildCanMove()) {
                AppEngine.menuAppendItem(sArray, 332);
            }
            if (this.buildCanSell()) {
                AppEngine.menuAppendItem(sArray, 331);
            }
        } else {
            AppEngine.menuAppendItem(sArray, 282);
        }
    }

    public void applyFootprint(boolean bl) {
        int n;
        int n2;
        if (this.getFlag(524288)) {
            this.setZSortOffset(5);
            return;
        }
        if (this.getFlag(4)) {
            if (this.getType() == 11) {
                this.setZSortOffset(5);
            }
            return;
        }
        SimWorld simWorld = this.getSimWorld();
        int n3 = simWorld.coordWorldToWorldTileX(this.getPosX());
        int n4 = simWorld.coordWorldToWorldTileZ(this.getPosZ());
        int n5 = simWorld.getObjectFootprintWidth(this.getType());
        int n6 = simWorld.getObjectFootprintHeight(this.getType());
        if (this.getFacingDir() == 1 || this.getFacingDir() == 3) {
            n2 = n5;
            n5 = n6;
            n6 = n2;
        }
        if (bl) {
            if (this.getParentType() == 10) {
                n2 = 255;
                n = 32;
            } else if (this.getType() == 117) {
                n2 = -129;
                n = 0;
            } else {
                n2 = 255;
                n = 128;
            }
        } else {
            n2 = -161;
            n = 0;
        }
        simWorld.paintAttributes(n3 - n5 + 1, n4 - n6 + 1, n5, n6, n2, n);
        this.m_footprintWidth = (byte)n5;
        this.m_footprintHeight = (byte)n6;
        if (this.getFlag(0x1000000)) {
            this.setZSortOffset(-10);
        } else if (this.getFlag(8)) {
            this.setZSortOffset(0);
        } else if (this.getParentType() == 14 || this.getParentType() == 12) {
            this.setZSortOffset(20);
        } else if (n5 != 0 && n6 != 0) {
            this.m_zSortOffsetLeft = n5 * -8 + 4;
            this.m_zSortOffsetRight = n6 * -8 + 4;
        }
        this.m_updateCachedStuff = true;
    }

    public int getFacingDir() {
        return this.m_facingDir;
    }

    public void setFacingDir(int n) {
        if (this.m_facingDir != n) {
            this.m_updateCachedStuff = true;
            this.m_facingDir = n;
            if (this.m_animSetId != -1) {
                this.setAnimSet(this.m_animSetId);
            }
        }
    }

    public void setFacingDir(int n, int n2) {
        this.setFacingDir(Math.abs(n) > Math.abs(n2) ? (n < 0 ? 2 : 0) : (n2 < 0 ? 3 : 1));
    }

    public void setFacingObject(MapObject mapObject) {
        int n = Math.max(mapObject.m_footprintWidth - 1, 0);
        int n2 = Math.max(mapObject.m_footprintHeight - 1, 0);
        int n3 = n << 18;
        int n4 = n2 << 18;
        int n5 = mapObject.getPosX() - n3;
        int n6 = mapObject.getPosZ() - n4;
        this.setFacingDir(n5 - this.getPosX(), n6 - this.getPosZ());
    }

    public void setAnim(int n) {
        this.getAnimPlayer(0).startAnim(n, this.getRuntimeFlag(128) ? 20 : 16);
    }

    public boolean isAnimating() {
        return this.m_animPlayers[0].isAnimating();
    }

    public boolean isAnimating(int n) {
        AnimPlayer animPlayer = this.getAnimPlayer(n);
        return animPlayer != null && animPlayer.isAnimating();
    }

    public void setAnimSet(int n) {
        this.m_animSetId = (short)n;
        int n2 = this.getSimWorld().getAnim(n, this.getFacingDir());
        this.setAnim(n2);
    }

    public void setAnimSetIndex(int n) {
        this.setAnimSet(this.getSimWorld().getObjectAnimSetId(this.getType(), n));
    }

    private boolean buildInUse() {
        int n;
        MapObjectSim[] mapObjectSimArray;
        if (this.m_occupiedFlags != 0) {
            return true;
        }
        if (this.getFlag(262144)) {
            int n2;
            mapObjectSimArray = this.getSimWorld();
            n = this.getType();
            int n3 = mapObjectSimArray.getObjectFootprintWidth(n);
            int n4 = mapObjectSimArray.getObjectFootprintHeight(n);
            if (this.getFacingDir() == 1 || this.getFacingDir() == 3) {
                n2 = n3;
                n3 = n4;
                n4 = n2;
            }
            n2 = mapObjectSimArray.coordWorldToWorldTileX(this.getPosX());
            int n5 = mapObjectSimArray.coordWorldToWorldTileZ(this.getPosZ());
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    if (!mapObjectSimArray.isBenchTopObjectAt(n2 - i, n5 - j)) continue;
                    return true;
                }
            }
        }
        mapObjectSimArray = this.m_scene.getSimObjects();
        for (n = 0; n < mapObjectSimArray.length; ++n) {
            if (mapObjectSimArray[n].getPostureObject() != this) continue;
            return true;
        }
        return false;
    }

    public boolean buildCanSell() {
        SimWorld simWorld = this.getSimWorld();
        return simWorld.getObjectSellPrice(this.m_type) > 0;
    }

    public boolean buildCanMove() {
        SimWorld simWorld = this.getSimWorld();
        this.applyFootprint(false);
        int n = simWorld.createBuildPoints(this.getType());
        this.m_scene.removeBuildPoints();
        this.applyFootprint(true);
        return n > 1;
    }

    public boolean buildCanRotate() {
        return this.getNextValidRotation() != this.getFacingDir();
    }

    private int getNextValidRotation() {
        SimWorld simWorld = this.getSimWorld();
        boolean bl = this.getFlag(524288);
        if (!bl) {
            this.applyFootprint(false);
        }
        int n = this.getFacingDir();
        int n2 = simWorld.coordWorldToWorldTileX(this.getPosX());
        int n3 = simWorld.coordWorldToWorldTileZ(this.getPosZ());
        int n4 = simWorld.getObjectValidRotations(this.getType(), n2, n3);
        AppEngine.ASSERT(n4 != 0, "object in invalid position");
        for (int i = 1; i <= 4; ++i) {
            int n5 = (n + i) % 4;
            int n6 = SimWorld.ROTATION_FLAGS[n5];
            if ((n4 & n6) == 0) continue;
            n = n5;
            break;
        }
        if (!bl) {
            this.applyFootprint(true);
        }
        return n;
    }

    public void buildRotate() {
        int n = this.getNextValidRotation();
        this.applyFootprint(false);
        this.reposition(this.getPosX(), this.getPosZ(), n);
        this.applyFootprint(true);
    }
}

