/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.ea.sdk.SDKString;
import constants.AnimConstants;
import constants.ResourceConstants;
import constants.SoundEventConstants;
import game.AppEngine;
import game.SceneGame;
import game.SceneMenu;
import game.SimData;
import game.SimWorld;
import generic.AnimPlayer;
import generic.AnimationManager;
import generic.MathExt;
import javax.microedition.lcdui.Graphics;

public abstract class Scene
implements AnimConstants,
ResourceConstants,
SoundEventConstants {
    protected final AppEngine m_engine;
    protected final int[] m_tempInt4;
    protected int m_uiTextScreenWrapWidth;
    private int m_uiTextScreenMaxLines;
    protected int m_uiWrappedLineHeight;
    protected int m_uiMessageBoxWidth;
    protected int m_uiMessageBoxWrapWidth;
    protected int m_uiInfoBoxWrapWidth;
    protected int m_uiTextHeight;
    private static final int[] s_uiParams = new int[6];
    private final short[] m_uiStrings = new short[11];
    protected AnimPlayer m_arrowLeftAnimPlayer;
    protected AnimPlayer m_arrowRightAnimPlayer;
    private int m_uiListNum;
    private int m_uiListLeading;
    private int m_uiListOffset;
    private int m_uiListPage;
    private int m_uiListCursor;
    private int m_uiTextBoxTopLine;

    public boolean checkKeys(int n, int n2, int n3, int n4) {
        if ((n2 & n4) != 0 || (n & n3) != 0) {
            this.m_engine.clearCommandKeys();
            this.m_engine.clearKeyBit(n3);
            return true;
        }
        return false;
    }

    protected Scene(AppEngine appEngine) {
        this.m_engine = appEngine;
        this.m_tempInt4 = new int[4];
    }

    public abstract void start(int var1);

    public abstract void pause();

    public abstract void resume();

    public abstract void end();

    public abstract void render(Graphics var1);

    public abstract void processKeys(int var1, int var2);

    public abstract void update(int var1);

    protected void drawUIFullScreen(Graphics graphics, int n) {
        AppEngine appEngine = this.m_engine;
        this.drawUI(graphics, n, 0, 0, appEngine.getWidth(), appEngine.getHeight() - 15);
    }

    protected void drawUIFullScreen(Graphics graphics, int n, int n2) {
        AppEngine appEngine = this.m_engine;
        this.drawUI(graphics, n, 0, n2, appEngine.getWidth(), appEngine.getHeight() - 15 - n2);
    }

    protected void initUI() {
        AppEngine appEngine = this.m_engine;
        this.m_uiWrappedLineHeight = appEngine.getLineHeight(1);
        this.m_uiMessageBoxWidth = appEngine.getWidth() * 9 / 10;
        this.m_uiMessageBoxWrapWidth = this.m_uiMessageBoxWidth * 4 / 5;
        this.m_uiTextScreenWrapWidth = this.m_uiMessageBoxWidth * 17 / 20 - this.getScrollBarWidth();
        this.m_uiInfoBoxWrapWidth = appEngine.getWidth() * 4 / 5;
        this.m_uiTextScreenMaxLines = appEngine.getHeight() * 3 / 5 / appEngine.getLineHeight(1);
        this.m_uiTextHeight = appEngine.getLineHeight(1) + 2;
        this.m_arrowLeftAnimPlayer = new AnimPlayer();
        this.m_arrowRightAnimPlayer = new AnimPlayer();
        this.m_arrowLeftAnimPlayer.startAnim(570, 4);
        this.m_arrowRightAnimPlayer.startAnim(572, 4);
    }

    public void triggerLeftArrow() {
        this.m_arrowLeftAnimPlayer.startAnim(569, 16);
    }

    public void triggerRightArrow() {
        this.m_arrowRightAnimPlayer.startAnim(571, 16);
    }

    public void updateLeftRightArrows(int n) {
        this.m_arrowLeftAnimPlayer.updateAnim(n);
        this.m_arrowRightAnimPlayer.updateAnim(n);
        if (!this.m_arrowLeftAnimPlayer.isAnimating()) {
            this.m_arrowLeftAnimPlayer.startAnim(570, 20);
        }
        if (!this.m_arrowRightAnimPlayer.isAnimating()) {
            this.m_arrowRightAnimPlayer.startAnim(572, 20);
        }
    }

    public void setUIPlaceholderString(int n, int n2) {
        this.m_uiStrings[n] = (short)n2;
    }

    public void drawUI(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.drawUI(graphics, this.getUIPanel(n), n2, n3, n4, n5);
    }

    public void drawUI(Graphics graphics, short[] sArray, int n, int n2, int n3, int n4) {
        int[] nArray = s_uiParams;
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n3;
        nArray[3] = 0;
        this.drawSubUI(null, sArray, nArray);
        nArray[0] = n;
        nArray[2] = n3;
        int n5 = nArray[3];
        if (this.getUIPanelStretchWeight(sArray) != 0) {
            nArray[1] = n2;
            nArray[3] = n4 - n5;
        } else {
            nArray[1] = n2 + (n4 - n5 >> 1);
            nArray[3] = n5;
        }
        this.drawSubUI(graphics, sArray, nArray);
    }

    private void drawSubUI(Graphics graphics, short[] sArray, int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = nArray[0];
        int n6 = nArray[1];
        int n7 = nArray[2];
        int n8 = nArray[3];
        int n9 = 0;
        int n10 = 0;
        for (n4 = 0; n4 < sArray.length; n4 += 2) {
            n3 = sArray[n4];
            nArray[4] = n2 = sArray[n4 + 1];
            this.drawUIElement(null, n3, nArray);
            n = nArray[3];
            n10 += this.getUIElementStretchWeight(n3, n2);
            n9 += n;
        }
        if (graphics != null) {
            n4 = n8;
            if (n10 > 0) {
                n4 += n9;
            }
            nArray[0] = n5;
            nArray[1] = n6;
            nArray[2] = n7;
            n3 = 0;
            for (n2 = 0; n2 < sArray.length; n2 += 2) {
                int n11;
                n = sArray[n2];
                nArray[4] = n11 = sArray[n2 + 1];
                int n12 = this.getUIElementStretchWeight(n, n11);
                if (n12 != 0) {
                    int n13;
                    AppEngine.ASSERT(n10 > 0, "unexpected stretchable found");
                    nArray[3] = n13 = n8 * n12 / n10;
                    this.drawUIElement(graphics, n, nArray);
                } else {
                    nArray[3] = n4 - n3;
                    this.drawUIElement(graphics, n, nArray);
                }
                n3 += nArray[3];
            }
        }
        nArray[3] = graphics == null ? n9 : n8 + n9;
    }

    private final int getUIElementStretchWeight(int n, int n2) {
        int n3 = 0;
        if (n == 22) {
            return n2;
        }
        if (n == 27) {
            n3 = 1;
        } else if (n == 29) {
            n3 = this.getUIPanelStretchWeight(this.getUIPanel(n2));
        }
        return n3;
    }

    private final int getUIPanelStretchWeight(short[] sArray) {
        int n = 0;
        for (int i = 0; i < sArray.length; i += 2) {
            short s = sArray[i];
            short s2 = sArray[i + 1];
            n += this.getUIElementStretchWeight(s, s2);
        }
        return n;
    }

    private void drawUIElement(Graphics graphics, int n, int[] nArray) {
        AppEngine appEngine = this.m_engine;
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        int n6 = nArray[4];
        int n7 = 0;
        switch (n) {
            case 0: {
                if (graphics == null) break;
                graphics.setColor(0);
                graphics.drawRect(n2, n3, n4, n5);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (n == 4) {
                    n4 = this.m_uiMessageBoxWidth;
                    n2 = this.m_engine.getWidth() - n4 >> 1;
                }
                if (graphics != null) {
                    this.drawTitleBox(graphics, n2, n3, n4, n5, n6, n);
                }
                n2 += 5;
                n3 += 22;
                n4 -= 10;
                n7 = 27;
                break;
            }
            case 5: {
                if (graphics == null) break;
                this.drawTitleBoxMargin(graphics, n2, n3, n4, n5);
                break;
            }
            case 6: {
                if (graphics != null) {
                    this.drawInnerBox(graphics, n2, n3, n4, n5);
                }
                n2 += 8;
                n3 += 8;
                n4 -= 16;
                n7 = 16;
                break;
            }
            case 7: {
                if (graphics != null) {
                    this.drawDescBox(graphics, n2, n3, n4, n5);
                }
                n2 += 4;
                n3 += 4;
                n4 -= 8;
                n7 = 8;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                SDKString sDKString;
                if (graphics == null || (sDKString = this.getUIString(n6)) == null) break;
                int n8 = n2;
                int n9 = n3 + 1;
                int n10 = 20;
                if (n == 10 || n == 13) {
                    n8 += n4;
                    n10 = 24;
                } else if (n == 11 || n == 14) {
                    n8 += n4 >> 1;
                    n10 = 17;
                }
                int n11 = n == 12 || n == 13 || n == 14 ? 0 : 1;
                appEngine.drawString(sDKString, n11, n8, n9, n10);
                break;
            }
            case 15: {
                n7 = this.m_uiTextHeight;
                n3 += n7;
                break;
            }
            case 16: 
            case 17: {
                n7 = Math.max(n6, appEngine.getNumWrappedLines()) * this.m_uiWrappedLineHeight;
                if (graphics != null) {
                    if (n == 17) {
                        n7 = n5;
                    }
                    appEngine.drawWrappedString(1, n2 + (n4 >> 1), n3 + (n7 >> 1), 3);
                }
                n3 += n7;
                break;
            }
            case 19: {
                int n12 = appEngine.getWidth();
                int n13 = n3 + 3;
                int n14 = appEngine.getHeight() - 15 - 3;
                int n15 = n14 - n13;
                if (graphics != null) {
                    AnimationManager.setColor(graphics, 77);
                    graphics.fillRect(0, n3, n12, 3);
                    AnimationManager.setColor(graphics, 76);
                    graphics.fillRect(0, n13, n12, n15);
                    n3 = n13;
                    n7 = n5 - n15;
                } else {
                    n7 = n5;
                    n3 = n13;
                }
                n2 = 0;
                n4 = n12;
                break;
            }
            case 20: {
                if (graphics == null) break;
                int n16 = this.m_uiTextHeight + 2;
                int n17 = appEngine.getWidth();
                int n18 = n3 - 2;
                AnimationManager.setColor(graphics, 77);
                graphics.fillRect(0, n18, n17, 1);
                graphics.fillRect(0, n18 + n16 - 1, appEngine.getWidth(), 1);
                AnimationManager.setColor(graphics, 1);
                graphics.fillRect(0, n18 + 1, n17, n16 - 2);
                int n19 = n2 + n4 - 25 + 3;
                int n20 = n2 + n4 + 3;
                AnimationManager.drawAnimFrame(graphics, 669, 0, n19, n3);
                AnimationManager.drawAnimFrame(graphics, 668, 0, n20, n3);
                break;
            }
            case 21: {
                int n21 = this.m_uiTextHeight + 8;
                if (graphics != null) {
                    int n22 = n4 * 4 / 5;
                    int n23 = n2 + (n4 - n22 >> 1);
                    this.drawInnerBox(graphics, n23, n3, n22, n21);
                    int n24 = n23 + (n22 >> 1);
                    int n25 = n3 + (n21 >> 1) + 2;
                    appEngine.drawString(this.getUIString(n6), 0, n24, n25, 3);
                }
                n7 = n21;
                n3 += n7;
                break;
            }
            case 18: {
                n7 = 1;
                if (graphics != null) {
                    int n26 = n2 + 1;
                    int n27 = n4 - 3;
                    AnimationManager.setColor(graphics, n6);
                    graphics.fillRect(n26, n3, n27, 1);
                }
                break;
            }
            case 22: {
                if (graphics == null) break;
                n7 = n5;
                n3 += n7;
                break;
            }
            case 23: {
                int n28 = n6;
                n2 += n28;
                n4 -= n28 << 1;
                n3 += n28;
                n7 = n28 << 1;
                break;
            }
            case 24: {
                int n29 = n6;
                n2 += n29;
                n4 -= n29 << 1;
                break;
            }
            case 25: {
                int n30 = n6;
                n3 += n30;
                n7 = n30 << 1;
                break;
            }
            case 26: {
                n7 = n6;
                n3 += n7;
                break;
            }
            case 27: {
                if (graphics == null) break;
                this.drawUIList(graphics, n2, n3, n4, n5, n6);
                n7 = n5;
                n3 += n7;
                break;
            }
            case 28: {
                this.drawTextBox(graphics, nArray);
                n7 = nArray[3];
                n3 += n7;
                break;
            }
            case 29: {
                short[] sArray = this.getUIPanel(n6);
                this.drawSubUI(graphics, sArray, nArray);
                n7 = nArray[3];
                n3 += n7;
                break;
            }
            case 30: {
                n7 = ((SceneMenu)this).drawUIPersonaDesc(graphics, n2, n3, n4, n7);
                n3 += n7;
                break;
            }
            case 31: 
            case 33: 
            case 36: {
                n7 = this.drawUITraitsList(graphics, n2, n3, n4, n7, n);
                n3 += n7;
                break;
            }
            case 32: {
                n7 = ((SceneGame)this).drawUICurrentDream(graphics, n2, n3, n4, n7);
                n3 += n7;
                break;
            }
            case 34: {
                n7 = ((SceneGame)this).drawUISkill(graphics, n2, n3, n4, n7, n6);
                n3 += n7;
                break;
            }
            case 35: {
                n7 = ((SceneGame)this).drawUIRelationship(graphics, n2, n3, n4, n7);
                n3 += n7;
                break;
            }
            case 37: {
                ((SceneGame)this).drawUIFurniturePreview(graphics, nArray);
                return;
            }
            case 38: {
                n7 = ((SceneGame)this).drawUIGetItem(graphics, n2, n3, n4, n7);
                n3 += n7;
                break;
            }
            default: {
                AppEngine.ASSERT(false, "invalid ui element");
            }
        }
        nArray[0] = n2;
        nArray[1] = ++n3;
        nArray[2] = n4;
        nArray[3] = n7;
    }

    public void drawTitleBox(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        AppEngine appEngine = this.m_engine;
        if (n6 == 4) {
            this.drawRoundedBox(graphics, n, n2, n3, n4);
        }
        int n9 = graphics.getClipX();
        int n10 = graphics.getClipY();
        int n11 = graphics.getClipWidth();
        int n12 = graphics.getClipHeight();
        int n13 = AnimationManager.getAnimFrameWidth(592, 0);
        int n14 = AnimationManager.getAnimFrameHeight(592, 0);
        AnimationManager.drawAnimFrame(graphics, 592, 0, n, n2);
        AnimationManager.drawAnimFrame(graphics, 592, 2, n + n3 - n13, n2);
        graphics.setClip(n + n13, n10, n3 - (n13 << 1), n12);
        AnimationManager.drawAnimFrame(graphics, 592, 1, n + n13, n2);
        graphics.setClip(n9, n10, n11, n12);
        if (n6 != 4) {
            AnimationManager.setColor(graphics, 0);
            graphics.fillRect(n, n2 + n14, 1, n4 - n14);
            graphics.fillRect(n + n3 - 1, n2 + n14, 1, n4 - n14);
            graphics.fillRect(n, n2 + n4 - 1, n3, 1);
            AnimationManager.setColor(graphics, 76);
            graphics.fillRect(n + 1, n2 + n14, n3 - 2, n4 - n14 - 1);
        }
        if (n5 != -1) {
            n8 = n + (n3 >> 1);
            n7 = n2 + 5;
            if (n5 != 36) {
                appEngine.drawString(this.getUIString(n5), 0, n8, n7, 17);
            }
        }
        if (n6 == 2) {
            n8 = n2 + 3;
            n7 = n + 4;
            int n15 = n + n3 - 4;
            this.m_arrowLeftAnimPlayer.drawAnim(graphics, n7, n8);
            this.m_arrowRightAnimPlayer.drawAnim(graphics, n15, n8);
        }
        if (n6 == 3) {
            n5 = this.getUIPlaceholderStringId(n5);
            n8 = -1;
            if (n5 == 216) {
                n8 = 675;
            } else if (n5 == 212) {
                n8 = 677;
            } else if (n5 == 215) {
                n8 = 676;
            } else if (n5 == 211) {
                n8 = 678;
            }
            if (n8 != -1) {
                int[] nArray = this.m_tempInt4;
                AnimationManager.getAnimFrameCollisionBox(nArray, n8, 0, 0);
                graphics.setClip(n + nArray[0], n2 + nArray[1], nArray[2], nArray[3]);
                AnimationManager.drawAnimFrame(graphics, n8, 0, n, n2);
                graphics.setClip(n + n3 - nArray[2] + nArray[0], n2 + nArray[1], nArray[2], nArray[3]);
                AnimationManager.drawAnimFrame(graphics, n8, 0, n + n3 - nArray[2], n2);
                graphics.setClip(n9, n10, n11, n12);
            }
        }
    }

    public void drawTitleBoxMargin(Graphics graphics, int n, int n2, int n3, int n4) {
        AnimationManager.setColor(graphics, 77);
        graphics.fillRect(n, n2, n3, 6);
        graphics.fillRect(n, n2 + n4 - 6, n3, 6);
        graphics.fillRect(n, n2 + 6, 6, n4 - 12);
        graphics.fillRect(n + n3 - 6, n2 + 6, 6, n4 - 12);
    }

    public void drawAnimBox(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = graphics.getClipX();
        int n8 = graphics.getClipY();
        int n9 = graphics.getClipWidth();
        int n10 = graphics.getClipHeight();
        int n11 = AnimationManager.getAnimFrameWidth(n5, 0);
        int n12 = AnimationManager.getAnimFrameHeight(n5, 0);
        int n13 = n + n11;
        int n14 = n + n3 - n11;
        int n15 = n3 - (n11 << 1);
        int n16 = n2 + n12;
        int n17 = n2 + n4 - n12;
        int n18 = n4 - (n12 << 1);
        AnimationManager.drawAnimFrame(graphics, n5, 0, n, n2);
        AnimationManager.drawAnimFrame(graphics, n5, 2, n14, n2);
        AnimationManager.drawAnimFrame(graphics, n5, 6, n, n17);
        AnimationManager.drawAnimFrame(graphics, n5, 4, n14, n17);
        graphics.setClip(n7, n16, n9, n18);
        AnimationManager.drawAnimFrame(graphics, n5, 7, n, n16);
        AnimationManager.drawAnimFrame(graphics, n5, 3, n14, n16);
        graphics.setClip(n13, n8, n15, n10);
        AnimationManager.drawAnimFrame(graphics, n5, 1, n13, n2);
        AnimationManager.drawAnimFrame(graphics, n5, 5, n13, n17);
        graphics.setClip(n7, n8, n9, n10);
        if (n6 != -1) {
            AnimationManager.setColor(graphics, n6);
            graphics.fillRect(n13, n16, n15, n18);
        }
    }

    public void drawInnerBox(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawAnimBox(graphics, n, n2, n3, n4, 586, 1);
    }

    public void drawInnerTitleBox(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawAnimBox(graphics, n, n2, n3, n4, 590, 81);
    }

    public void drawButtonBox(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, int n5) {
        this.drawButtonBox(graphics, n, n2, n3, n4, bl, this.m_engine.getString(n5));
    }

    public void drawButtonBox(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, SDKString sDKString) {
        int n5;
        if (bl) {
            n5 = 0;
            this.drawAnimBox(graphics, n - 1, n2 - 1, n3 + 2, n4 + 2, 588, 94);
        } else {
            n5 = 1;
            this.drawAnimBox(graphics, n, n2, n3, n4, 589, 90);
        }
        this.m_engine.drawString(sDKString, n5, n + (n3 >> 1), n2 + (n4 >> 1) + 2, 3);
    }

    public void drawButtonBoxForMoreGames(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, int n5) {
        this.drawButtonBoxForMoreGames(graphics, n, n2, n3, n4, bl, this.m_engine.getString(n5));
    }

    public void drawButtonBoxForMoreGames(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, SDKString sDKString) {
        int n5 = 0;
        if (bl) {
            this.drawAnimBox(graphics, n - 1, n2 - 1, n3 + 2, n4 + 2, 588, 94);
        } else {
            this.drawAnimBox(graphics, n, n2, n3, n4, 589, 90);
        }
        this.m_engine.drawString(sDKString, n5, n + (n3 >> 1), n2 + (n4 >> 1) + 2, 3);
    }

    public void drawRoundedBox(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawAnimBox(graphics, n, n2, n3, n4, 587, 76);
    }

    public void drawDescBox(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        AnimationManager.setColor(graphics, n5);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        AnimationManager.setColor(graphics, 73);
        graphics.fillRect(n + 1, n2 + 1, n3 - 2, 1);
        graphics.fillRect(n + 1, n2 + 2, 1, n4 - 3);
        AnimationManager.setColor(graphics, 74);
        graphics.fillRect(n + 2, n2 + 2, n3 - 3, n4 - 3);
    }

    public void drawDescBox(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawDescBox(graphics, n, n2, n3, n4, 77);
    }

    public void drawDescBoxDark(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawDescBox(graphics, n, n2, n3, n4, 0);
    }

    protected void drawTextBox(Graphics graphics, int[] nArray) {
        AppEngine appEngine = this.m_engine;
        int n = appEngine.getLineHeight(1);
        int n2 = Math.max(5, Math.min(appEngine.getNumWrappedLines(), this.m_uiTextScreenMaxLines));
        int n3 = n * n2 + 16;
        if (graphics == null) {
            nArray[3] = n3;
            return;
        }
        int n4 = nArray[0];
        int n5 = nArray[2] - this.getScrollBarWidth();
        int n6 = nArray[1];
        int n7 = n4 + 8;
        int n8 = n6 + 8;
        int n9 = n4 + n5;
        int n10 = n6;
        int n11 = n3;
        this.drawInnerBox(graphics, n4, n6, n5, n3);
        appEngine.drawPartWrappedString(1, n7, n8, 20, this.m_uiTextBoxTopLine, this.m_uiTextScreenMaxLines);
        this.drawScrollBar(graphics, n9, n10, n11, this.m_uiTextBoxTopLine, this.m_uiTextScreenMaxLines, appEngine.getNumWrappedLines(), true);
    }

    public int drawDropDownTitle(Graphics graphics, int n, int n2, int n3, int n4) {
        AppEngine appEngine = this.m_engine;
        int n5 = n3 - 3 - 3;
        int n6 = n2;
        int n7 = 6 + n5 + 3;
        int n8 = n;
        this.drawRoundedBox(graphics, n8, -3, n6, n7);
        int n9 = n2 - 6;
        int n10 = n8 + (n6 - n9 >> 1);
        this.drawInnerTitleBox(graphics, n10, 3, n9, n5);
        appEngine.drawString(n4, 0, n10 + (n9 >> 1), 3 + (n5 >> 1) + 2, 3);
        return n7 - 3;
    }

    public int drawDropDownTitle(Graphics graphics, int n, int n2, int n3) {
        return this.drawDropDownTitle(graphics, n, n2, 25, n3);
    }

    public int drawDropDownDoubleTitle(Graphics graphics, int n, int n2, int n3, int n4) {
        AppEngine appEngine = this.m_engine;
        int n5 = n2;
        int n6 = n;
        this.drawRoundedBox(graphics, n6, -3, n5, 47);
        int n7 = n2 - 6;
        int n8 = n6 + (n5 - n7 >> 1);
        this.drawInnerTitleBox(graphics, n8, 3, n7, 19);
        appEngine.drawString(n3, 0, n8 + (n7 >> 1), 14, 3);
        this.drawInnerBox(graphics, n8, 25, n7, 16);
        if (n4 != -1) {
            appEngine.drawString(n4, 1, n8 + (n7 >> 1), 34, 3);
        }
        return 44;
    }

    public void drawHUDSim(Graphics graphics, int n, int n2) {
        this.drawHUDSim(graphics, n, n2, 0, false, 0);
    }

    public void drawHUDSim(Graphics graphics, int n, int n2, int n3, boolean bl, int n4) {
        AppEngine appEngine = this.m_engine;
        SimData simData = appEngine.getSimData();
        int n5 = simData.getSimAttribute(n3, 0) == 0 ? (bl ? 604 : 603) : (bl ? 602 : 601);
        int n6 = simData.getSimAttribute(n3, 2);
        AnimationManager.setBank(n4);
        AnimationManager.drawAnimFrame(graphics, n5, n6, n, n2);
        AnimationManager.setBank(0);
    }

    public static void drawHollowBox(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n5;
        int n7 = n4 - n6 - n6;
        int n8 = n3;
        graphics.fillRect(n, n2, n8, n6);
        graphics.fillRect(n, n2 + n4 - n6, n8, n6);
        graphics.fillRect(n, n2 + n6, n6, n7);
        graphics.fillRect(n + n3 - n6, n2 + n6, n6, n7);
    }

    protected SDKString getUIString(int n) {
        AppEngine appEngine = this.m_engine;
        if (n >= -12) {
            return appEngine.getString(n);
        }
        AppEngine.ASSERT(n >= -23, "invalid string id");
        n = this.getUIPlaceholderStringId(n);
        return n == 27 ? null : appEngine.getString(n);
    }

    private int getUIPlaceholderStringId(int n) {
        return this.m_uiStrings[-13 - n];
    }

    protected short[] getUIPanel(int n) {
        return this.m_engine.getUIPanel(n);
    }

    protected void initList(int n, int n2, int n3) {
        this.m_uiListNum = n;
        this.m_uiListLeading = n2;
        this.m_uiListOffset = 0;
        this.m_uiListPage = -1;
        this.m_uiListCursor = n3;
    }

    protected boolean processKeysList(int n, int n2) {
        if (this.m_uiListPage != -1) {
            int n3 = this.m_uiListCursor;
            int n4 = this.m_uiListCursor == -1 ? this.m_uiListOffset : this.m_uiListCursor;
            if (this.checkKeys(n, n2, 16640, 0)) {
                ++n4;
            } else if (this.checkKeys(n, n2, 8196, 0)) {
                --n4;
            }
            if (this.m_uiListCursor == -1) {
                this.m_uiListOffset = Math.max(0, Math.min(n4, this.m_uiListNum - this.m_uiListPage));
            } else {
                this.m_uiListCursor = Math.max(0, Math.min(n4, this.m_uiListNum - 1));
            }
            return n3 != this.m_uiListCursor;
        }
        return false;
    }

    public int getListNum() {
        return this.m_uiListNum;
    }

    public int getListOffset() {
        return this.m_uiListOffset;
    }

    public int getListCursor() {
        return this.m_uiListCursor;
    }

    protected void drawUIList(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        AppEngine appEngine = this.m_engine;
        int n8 = n3 - this.getScrollBarWidth();
        int n9 = n + 2;
        int n10 = n2 + 2;
        int n11 = n8 - 2 - 1;
        int n12 = n4 - 2 - 1;
        this.drawInnerBox(graphics, n, n2, n8, n4);
        int n13 = n12 / this.m_uiListLeading;
        int n14 = this.m_uiListNum;
        this.m_uiListPage = n13;
        if (this.m_uiListCursor != -1) {
            n7 = this.m_uiListCursor;
            n6 = this.m_uiListOffset;
            if (n7 < n6) {
                n6 = n7;
            } else if (n7 >= n6 + n13) {
                n6 = Math.max(0, n7 - n13 + 1);
            }
            this.m_uiListOffset = n6;
        }
        n7 = n + n8;
        this.drawScrollBar(graphics, n7, n2, n4, this.m_uiListOffset, n13, n14, true);
        n6 = graphics.getClipX();
        int n15 = graphics.getClipY();
        int n16 = graphics.getClipWidth();
        int n17 = graphics.getClipHeight();
        graphics.setClip(n9, n10, n11, n12);
        SceneMenu sceneMenu = appEngine.getSceneMenu();
        SceneGame sceneGame = appEngine.getSceneGame();
        switch (n5) {
            case 0: {
                sceneMenu.drawListPersonas(graphics, n9, n10, n11, n12);
                break;
            }
            case 1: {
                sceneMenu.drawListTraits(graphics, n9, n10, n11, n12);
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                this.drawListGoals(graphics, n9, n10, n11, n12, n5);
                break;
            }
            case 3: {
                sceneGame.drawListStatus(graphics, n9, n10, n11, n12);
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                sceneGame.drawListInventory(graphics, n9, n10, n11, n12, n5);
                break;
            }
            case 7: {
                sceneGame.drawListRelationships(graphics, n9, n10, n11, n12);
                break;
            }
            case 10: {
                sceneGame.drawListFuniture(graphics, n9, n10, n11, n12);
                break;
            }
            default: {
                AppEngine.ASSERT(false, "unknown list id");
            }
        }
        graphics.setClip(n6, n15, n16, n17);
    }

    protected void drawListDivider(Graphics graphics, int n, int n2, int n3) {
        AnimationManager.setColor(graphics, 75);
        graphics.fillRect(n, n2, n3, 1);
    }

    protected void drawListSelect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n7 == this.getListOffset()) {
            this.drawListSelectTop(graphics, n, n2, n3, n4, n6);
        } else if (n2 + n4 >= n5) {
            this.drawListSelectBottom(graphics, n, n2, n3, n5 - n2, n6);
        } else {
            this.drawListSelect(graphics, n, n2, n3, n4, n6);
        }
    }

    private void drawListSelect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        AnimationManager.setColor(graphics, n5);
        graphics.fillRect(n, n2 + 1, n3, n4 - 1);
    }

    private void drawListSelectTop(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        AnimationManager.setColor(graphics, n5);
        graphics.fillRect(n + 1, n2, n3 - 2, 1);
        graphics.fillRect(n, n2 + 1, n3, n4 - 1);
    }

    private void drawListSelectBottom(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        AnimationManager.setColor(graphics, n5);
        graphics.fillRect(n, n2 + 1, n3, n4 - 1 - 1);
        graphics.fillRect(n + 1, n2 + n4 - 1, n3 - 2, 1);
    }

    protected void renderGoalsScreen(Graphics graphics, int n) {
        AppEngine appEngine = this.m_engine;
        int n2 = appEngine.getSimData().getTaskCount();
        SDKString sDKString = appEngine.clearStringBuffer();
        appEngine.appendStringIdToBuffer(558);
        appEngine.appendIntToBuffer(appEngine.getNumGoalsComplete());
        appEngine.appendStringIdToBuffer(30);
        appEngine.appendIntToBuffer(n2);
        appEngine.dynamicString(-9, sDKString);
        this.setUIPlaceholderString(1, -9);
        sDKString = appEngine.clearStringBuffer();
        appEngine.appendStringIdToBuffer(557);
        appEngine.appendIntToBuffer(appEngine.getNumGoalsDiscovered());
        appEngine.appendStringIdToBuffer(30);
        appEngine.appendIntToBuffer(n2);
        appEngine.dynamicString(-8, sDKString);
        this.setUIPlaceholderString(2, -8);
        this.drawUIFullScreen(graphics, n);
    }

    protected void initListGoals() {
        this.initList(this.m_engine.getSimData().getTaskCount(), 27, -1);
    }

    private int remapGlobalGoalIndex(int n) {
        AppEngine appEngine = this.m_engine;
        int n2 = appEngine.getSimData().getTaskCount();
        int n3 = appEngine.getNumGoalsDiscovered();
        int n4 = appEngine.getNumGoalsComplete();
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!appEngine.isDreamDiscovered(i) && n >= n3) {
                return i;
            }
            if (!appEngine.isDreamDiscovered(i)) continue;
            if (appEngine.isGoalCompleted(i)) {
                if (n5 == n) {
                    return i;
                }
                ++n5;
                continue;
            }
            if (n6 == n - n4 && n >= n4) {
                return i;
            }
            ++n6;
        }
        AppEngine.ASSERT(false, "no dreams! (shouldn't happen)");
        return -1;
    }

    private void drawListGoals(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        AppEngine appEngine = this.m_engine;
        SimData simData = appEngine.getSimData();
        int n6 = n + 3;
        int n7 = AnimationManager.getAnimFrameHeight(575, 0);
        int n8 = 13 - (n7 >> 1);
        int n9 = n + 3 + n7 + 3;
        int n10 = n9 + 3;
        int n11 = n + n3 - n10 - 3;
        AnimationManager.setColor(graphics, 75);
        graphics.fillRect(n9, n2, 1, n4);
        int n12 = n2;
        int n13 = 0;
        for (int i = this.getListOffset(); n12 < n2 + n4 && i < this.getListNum(); ++i) {
            int n14;
            int n15;
            int n16;
            int n17 = i;
            int n18 = 0;
            if (n5 == 2) {
                if (appEngine.isDreamDiscovered(n17 = this.remapGlobalGoalIndex(n17))) {
                    n16 = simData.getDreamDescString(n17);
                    if (appEngine.isGoalCompleted(n17)) {
                        n15 = 575;
                        n18 = 1;
                    } else {
                        n15 = 575;
                        n18 = 0;
                    }
                } else {
                    n16 = 556;
                    n15 = 575;
                    n18 = 2;
                }
            } else if (n5 == 8) {
                n14 = simData.getPromise(n17);
                n16 = simData.getDreamDescString(n14);
                n15 = 598;
                if (n14 == -1) {
                    n15 = 203;
                }
            } else {
                n14 = simData.getPersonaNthGoalItem(n17);
                n16 = simData.getDreamDescString(n14);
                n15 = 575;
                n18 = simData.isPersonaGoalsCompleted(n17) ? 1 : 0;
            }
            appEngine.drawWrappedStringChunk(n13, n16, 1, n11, n10, n12 + 13, 6);
            AnimationManager.drawAnimFrame(graphics, n15, n18, n6, n12 + n8);
            ++n13;
            this.drawListDivider(graphics, n, n12 += 27, n3);
        }
    }

    public int drawUITraitsList(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = 8 + 6 * this.m_uiWrappedLineHeight;
        if (graphics != null) {
            AppEngine appEngine = this.m_engine;
            SimData simData = appEngine.getSimData();
            int n7 = 0;
            int n8 = 5;
            if (n5 == 36) {
                n7 = ((SceneGame)this).getInfoSim();
                n8 = simData.getSimTraitCount(n7);
            }
            this.drawDescBox(graphics, n, n2, n3, n6);
            int n9 = n + 4;
            int n10 = n2 + 4;
            int n11 = n9 + 12;
            int n12 = n10 + this.m_uiWrappedLineHeight + 2;
            int n13 = this.m_uiWrappedLineHeight - 2;
            int n14 = n3 >> 1;
            int n15 = 651;
            if (n5 == 31) {
                n15 = 752;
            }
            appEngine.drawString(n15, 1, n9, n10, 20);
            SDKString sDKString = appEngine.clearStringBuffer();
            int n16 = n12;
            for (int i = 0; i < n8; ++i) {
                sDKString = appEngine.clearStringBuffer();
                appEngine.appendIntToBuffer(i + 1);
                appEngine.appendStringIdToBuffer(32);
                appEngine.drawString(sDKString, 1, n9, n16, 20);
                int n17 = simData.getSimTrait(n7, i);
                if (n5 == 36 && !simData.isTraitDiscovered(n7, n17)) {
                    n17 = -1;
                }
                if (n17 != -1) {
                    short s = simData.getTraitDescString(n17);
                    appEngine.drawString(s, 1, n11, n16, 20);
                } else {
                    AnimationManager.setColor(graphics, 0);
                    graphics.fillRect(n11, n16 + n13, n3 - n14, 1);
                }
                n16 += this.m_uiWrappedLineHeight;
            }
            if (n5 == 36) {
                ((SceneGame)this).drawUINPCPortrait(graphics, n, n2, n3, n6);
            } else if (n5 == 33) {
                ((SceneGame)this).drawUIPlayerPortrait(graphics, n, n2, n3, n6);
            }
        }
        return n6;
    }

    public void prepareGenericMessageBox(int n, int n2) {
        AppEngine.ASSERT(n2 != -1, "no title supplied to prepareGenericMessageBox!");
        this.setUIPlaceholderString(0, n2);
        this.m_engine.wrapString(n, 1, this.m_uiMessageBoxWrapWidth);
    }

    public void drawGenericMessageBox(Graphics graphics) {
        this.drawUIFullScreen(graphics, 1);
    }

    public void prepareTextScreen(int n, int n2) {
        this.setUIPlaceholderString(0, n2);
        this.m_engine.wrapString(n, 1, this.m_uiTextScreenWrapWidth);
        this.m_uiTextBoxTopLine = 0;
    }

    public void drawTextScreen(Graphics graphics) {
        this.drawUIFullScreen(graphics, 2);
    }

    public void processKeysTextScreen(int n) {
        if (this.checkKeys(n, 0, 8196, 0)) {
            this.m_uiTextBoxTopLine = Math.max(0, this.m_uiTextBoxTopLine - 1);
        }
        if (this.checkKeys(n, 0, 16640, 0) && this.m_engine.getNumWrappedLines() > this.m_uiTextBoxTopLine + this.m_uiTextScreenMaxLines) {
            ++this.m_uiTextBoxTopLine;
        }
    }

    public void drawGenericMenu(Graphics graphics, short[] sArray, int n) {
        this.drawGenericMenu(graphics, sArray, n, null);
    }

    public void drawGenericMenu(Graphics graphics, short[] sArray, int n, SDKString[] sDKStringArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl;
        AppEngine appEngine = this.m_engine;
        SimWorld simWorld = appEngine.getSimWorld();
        int n7 = sArray[0];
        short s = sArray[3];
        short s2 = sArray[2];
        short s3 = sArray[4];
        int n8 = s3 != -1 ? Math.min(s3, n7) : n7;
        int n9 = appEngine.getWidth();
        int n10 = appEngine.getHeight();
        int n11 = (n & 1) != 0 ? 4 : 0;
        boolean bl2 = bl = (n & 6) != 0;
        int n12 = bl ? n9 >> 1 : ((n & 8) != 0 ? n9 >> 1 : n9 * 4 / 5);
        int n13 = (n & 0x10) == 0 ? 14 : 0;
        int n14 = n13 + 7 + 13 * n8 + 1 + (n11 << 1);
        int n15 = (n & 2) != 0 ? simWorld.getViewportX() + 3 : ((n & 4) != 0 ? simWorld.getViewportX() + simWorld.getViewportWidth() - n12 - 3 : ((n & 8) != 0 ? 3 : n9 - n12 >> 1));
        int n16 = bl ? (simWorld.getViewportY() + simWorld.getViewportHeight() - n14 >> 1) - ((n & 2) != 0 ? 13 : 0) : n10 - 15 - n14 >> 1;
        if (n11 != 0) {
            n6 = 77;
            n5 = 61;
            if ((n & 0x20) != 0) {
                n6 = 77;
                n5 = 76;
            }
            AnimationManager.setColor(graphics, n6);
            graphics.drawRect(n15, n16, n12, n14);
            AnimationManager.setColor(graphics, n5);
            Scene.drawHollowBox(graphics, n15 + 1, n16 + 1, n12 - 1, n14 - 1, n11 - 1);
            n15 += n11;
            n16 += n11;
            n12 -= n11 << 1;
            n14 -= n11 << 1;
        }
        n6 = n8 != n7 ? 1 : 0;
        n5 = n15 + 3;
        int n17 = n12 - 6 + (n6 != 0 ? -9 : 1);
        int n18 = n5 + (n17 >> 1);
        AnimationManager.setColor(graphics, 76);
        graphics.fillRect(n15, n16, n12, n14);
        AnimationManager.setColor(graphics, 77);
        graphics.drawRect(n15, n16, n12, n14);
        if ((n & 0x10) == 0) {
            graphics.fillRect(n15, n16 + n13, n12, 1);
            appEngine.renderScroller(0, graphics, sArray[1], 0, n15 + 3, n16 + 0, n12 - 6, 17);
        }
        if (n6 != 0) {
            n4 = n15 + n12 - this.getScrollBarWidth();
            n3 = n16 + n13 + 2;
            n2 = n14 - n13 - 4;
            this.drawScrollBar(graphics, n4, n3, n2, s, n8, n7, false);
        }
        n4 = n16 + n13 + 7;
        for (n3 = 0; n3 < n8; ++n3) {
            int n19;
            n2 = s + n3;
            int n20 = 1;
            int n21 = -1;
            if (sDKStringArray == null) {
                n21 = sArray[5 + n2];
            }
            if (s2 == n2 && n21 != 281 && n21 != 282) {
                n20 = 0;
                n19 = n4;
                if ((n & 0x20) != 0) {
                    AnimationManager.setColor(graphics, 1);
                    graphics.fillRect(n5, n19, n17, 13);
                } else if (bl) {
                    AnimationManager.setColor(graphics, 77);
                    graphics.fillRect(n5, n19, n17, 13);
                } else {
                    this.drawMenuSelector(graphics, n5, n19, n17, 13);
                }
            }
            if ((n19 = appEngine.getRMSOptionString(n21)) != -1) {
                int n22 = appEngine.getStringWidth(n21, n20) + appEngine.getSpaceWidth(n20);
                int n23 = appEngine.getStringWidth(n19, n20);
                int n24 = n18 - (n22 + n23 >> 1);
                int n25 = n24 + n22;
                appEngine.drawString(n21, n20, n24, n4, 20);
                appEngine.drawString(n19, n20, n25, n4, 20);
            } else if (n21 != -1) {
                if (s2 == n2) {
                    appEngine.renderScroller(1, graphics, n21, n20, n5, n4, n17, 17);
                } else {
                    appEngine.drawClippedString(graphics, n21, n20, n5, n4, n17, 17);
                }
            } else {
                SDKString sDKString = sDKStringArray[n2];
                if (s2 == n2) {
                    appEngine.renderScroller(1, graphics, sDKString, n20, n5, n4, n17, 17);
                } else {
                    appEngine.drawClippedString(graphics, sDKString, n20, n5, n4, n17, 17);
                }
            }
            n4 += 13;
        }
    }

    public void drawMenuSelector(Graphics graphics, int n, int n2, int n3, int n4) {
        AnimationManager.setColor(graphics, 62);
        graphics.fillRect(n, n2, n3, 1);
        AnimationManager.setColor(graphics, 77);
        graphics.fillRect(n, n2 + 1, n3, n4 - 3);
        AnimationManager.setColor(graphics, 64);
        graphics.fillRect(n, n2 + n4 - 2, n3, 1);
    }

    public void drawScrollBar(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7;
        int n8;
        n += 3;
        int n9 = AnimationManager.getAnimFrameHeight(608, 0);
        int n10 = n2 + n9 + 1 + 2;
        int n11 = n3 - (n9 + 1 + 2 << 1);
        if (n5 >= n6) {
            n8 = n10;
            n7 = n11;
        } else {
            n7 = Math.max(18, n11 * n5 / n6);
            n8 = n10 + (n11 - n7) * n4 / (n6 - n5);
        }
        int n12 = n4 > 0 ? 1 : 0;
        int n13 = n4 + n5 < n6 ? 1 : 0;
        int n14 = 2;
        int n15 = n2 + 2;
        int n16 = n2 + n3 - 2 - n9;
        AnimationManager.drawAnimFrame(graphics, 608, n12, n, n15);
        AnimationManager.drawAnimFrame(graphics, 607, n13, n, n16);
        if (n14 == 2) {
            this.drawScrollBarFill(graphics, n, n10, n11, 1);
        }
        this.drawScrollBarFill(graphics, n, n8, n7, n14);
        if (bl) {
            AnimationManager.setColor(graphics, 77);
            int n17 = n - 2;
            int n18 = AnimationManager.getAnimFrameWidth(611, 0) + 4;
            graphics.fillRect(n17, n2, n18, 1);
            graphics.fillRect(n17, n2 + n3 - 1, n18, 1);
            graphics.fillRect(n17 + n18, n2, 1, n3);
        }
    }

    private void drawScrollBarFill(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = AnimationManager.getAnimFrameHeight(610, n4);
        int n6 = AnimationManager.getAnimFrameHeight(609, n4);
        int n7 = graphics.getClipX();
        int n8 = graphics.getClipY();
        int n9 = graphics.getClipWidth();
        int n10 = graphics.getClipHeight();
        graphics.setClip(n7, n2, n9, n3);
        AnimationManager.drawAnimFrame(graphics, 610, n4, n, n2);
        AnimationManager.drawAnimFrame(graphics, 609, n4, n, n2 + n3 - n6);
        graphics.setClip(n7, n2 += n5, n9, n3 -= n5 + n6);
        AnimationManager.drawAnimFrame(graphics, 611, n4, n, n2);
        graphics.setClip(n7, n8, n9, n10);
    }

    public int getScrollBarWidth() {
        return AnimationManager.getAnimFrameWidth(611, 0) + 6;
    }

    protected int interpolateValue(int n, int n2, int n3, int n4) {
        if (n != n2) {
            int n5 = n2 - n;
            int n6 = n5 * n3 >> n4;
            if (n6 == 0) {
                n6 = MathExt.sign(n5);
            } else if (n5 > 0 && n + n6 > n2 || n5 < 0 && n + n6 < n2) {
                n6 = n5;
            }
            n += n6;
        }
        return n;
    }
}

