/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.ea.sdk.SDKString;
import constants.AnimConstants;
import constants.ResourceConstants;
import constants.SoundEventConstants;
import game.AppEngine;
import game.MapObject;
import game.MapObjectSim;
import game.SceneGame;
import game.SimWorld;
import generic.MathExt;
import generic.ResourceManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class SimData
implements AnimConstants,
ResourceConstants,
SoundEventConstants {
    private AppEngine m_engine;
    private short[] d_skillDescStrings;
    private int[][] d_skillRates;
    private short[][] d_skillIconAnims;
    private short[][] d_skillLevelDescStrings;
    private short[] d_careerDescStrings;
    private short[] d_careerStreamers;
    private short[] d_careerRabbitHoles;
    private byte[] d_careerBosses;
    private short[] d_careerFreakDeath1s;
    private short[] d_careerFreakDeath2s;
    private short[] d_careerRaiseFail;
    private short[][] d_careerLevelDescStrings;
    private short[][] d_careerLevelIncomes;
    private short[][] d_careerLevelFlags;
    private short[][] d_careerLevelHoursStarts;
    private short[][] d_careerLevelHoursEnds;
    private byte[][][] d_careerLevelRequirements;
    private short[] d_personaDescStrings;
    private short[] d_personaLongDescStrings;
    private short[] d_personaIcons;
    private short[] d_personaFlags;
    private short[] d_dreamDescStrings;
    private short[] d_dreamFlags;
    private int d_motiveCount;
    private short[] d_motiveDescStrings;
    private int[] d_motiveStartLevel;
    private int[] d_motiveDecayRate;
    private short[] d_motiveTriggersNeeds;
    private int[] d_motiveTriggersNeedLevels;
    private short[] d_motiveAnimHighs;
    private short[] d_motiveAnimLows;
    private byte[] d_timeRangeDreams;
    private int d_buffCount;
    private short[] d_buffDescStringIds;
    private int[] d_buffTimeouts;
    private byte[] d_buffTimeoutChains;
    private byte[] d_buffTimes;
    private byte[] d_buffFlags;
    private byte[][] d_buffTriggerMotives;
    private int[][] d_buffTriggerMotiveLevels;
    private byte[][] d_buffEffectMood;
    private byte[][] d_buffEffectMoodAmount;
    private byte[][] d_buffEffectMotive;
    private int[][] d_buffEffectMotiveFactors;
    private short[] d_traitDescStrings;
    private short[] d_traitExcludes;
    private int d_numRelLevels;
    private short[] d_relStateDescStrings;
    private byte[] d_relStateFlags;
    private short[] d_relStateEffectAnims;
    private short[] d_relStateToStrings;
    private byte[][] d_relStateTriggerToStates;
    private byte[][] d_relStateTriggerLevels;
    private short[][] d_relStateTriggerLevelValues;
    private int d_numSims;
    private short[] d_simNameStrings;
    private byte[] d_simMacromapColors;
    private byte[][] d_simAttributes;
    private short[] d_simHomes;
    private byte[] d_simFlags;
    private byte[] d_simPartners;
    private byte[] d_simCareers;
    private byte[] d_simCareerLevels;
    private byte[][] d_simTraits;
    private byte[][] d_simQuests;
    private int d_numPresets;
    private byte[][] d_simPresets;
    private short[] d_commodityStringIds;
    private int d_numActions;
    private short[] d_actionStringIds;
    private short[] d_actionGroupStringIds;
    private int[] d_actionFlags;
    private short[] d_actionWorldArgs;
    private byte[][] d_actionConditionCommodities;
    private byte[][] d_actionConditionTraits;
    private int[][] d_actionConditionRelStates;
    private short[][] d_actionEffectFlags;
    private byte[][] d_actionAffectFriendships;
    private byte[][] d_actionAffectRomances;
    private byte[][] d_actionAffectCommodities;
    private byte[][] d_actionAffectCommodityAmounts;
    private short[][] d_actionResponseActions;
    private byte[][] d_actionPhases;
    private short[] d_chanceCardPrompts;
    private byte[] d_chanceCardYesPercents;
    private byte[] d_chanceCardNoPercents;
    private byte[] d_chanceCardResultYes1s;
    private short[] d_chanceCardResultYes1Strings;
    private byte[] d_chanceCardResultYes2s;
    private short[] d_chanceCardResultYes2Strings;
    private byte[] d_chanceCardResultNo1s;
    private short[] d_chanceCardResultNo1Strings;
    private byte[] d_chanceCardResultNo2s;
    private short[] d_chanceCardResultNo2Strings;
    private byte[] d_questFlags;
    private short[] d_questPrompts;
    private short[] d_questMessages;
    private short[] d_questFinishActions;
    private short[] d_questGiveItem;
    private short[] d_questRewardCash;
    private short[][] d_questTriggerActions;
    public static final int[] DAY_FLAGS = new int[]{4, 8, 16, 32, 64, 128, 256};
    public static final int[] DAY_STRINGS = new int[]{660, 661, 662, 663, 664, 665, 666};
    private int m_timeTimer;
    private int m_timeTotal;
    private int m_money;
    private int m_moneySpent;
    private boolean m_fastForward;
    private byte m_furnitureStage;
    private short m_houseUpgradeDay;
    private byte[] m_inventory;
    private int m_activeRecipe;
    private int[] m_skillLevelsF;
    public static final int[] PERK_FLAGS = new int[]{1, 2};
    public static final int[] PERK_STRINGS = new int[]{672, 673};
    private byte m_careerAcceptDay;
    private short m_careerDaysWorked;
    private short m_careerDaysMissed;
    private byte[] m_careerLevelsAttained;
    private byte m_phoneCareer;
    private int m_phoneCareerTimer;
    private byte m_persona;
    private byte m_dream;
    private short m_dreamLGCSeed;
    private int m_dreamTimer;
    private byte[] m_promises;
    private int m_personaGoalsCompleted;
    private int m_achievements;
    private int[] m_timeRanges;
    private short m_dreamFishCount;
    private short m_dreamHarvestCount;
    private int[] m_woohooTimes;
    private int m_quickLinkFlags;
    private int m_motiveTimer;
    private int[] m_motiveLevelsF;
    private int[] m_motiveDecaysF;
    private int[] m_motiveDecayFactorsF;
    private int[] m_motiveDecayAdjustsF;
    private short[] m_buffsActive;
    private int[] m_buffTimers;
    private static final short[] MOODDESC_STRINGS = new short[]{394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 405};
    private int[] m_moodLevelsF;
    private int m_moodDesc;
    private int m_moodLevel;
    private byte[] m_currentRelStates;
    private short[] m_currentRelStateFlags;
    private int[][] m_currentRelLevelsF;
    private int[][] m_commodityLevelsF;
    private short[][] m_actionHistories;
    private byte[][] m_knownTraits;
    private int m_commodityTimer;
    private int m_lastNPC;
    private int m_lastNPCTimer;
    private static final short[] RESPONSE_ANIMS = new short[]{582, 581, 580, 203, 583, 584, 585};
    private static final short[] SPEECHICONS = new short[]{1, 5, 2, 165, 3, 9, 7, 289, 8, 261, 9, 321, 14, 257, 11, 1, 12, 289, 15, 257, 17, 261, 18, 257, 19, 257, 20, 1, 21, 513, 22, 257, 23, 257, 25, 257, 26, 305, 27, 1073, 28, 257, 203, 2};
    private byte[] m_questSims;
    private int[] m_questTimes;
    private int m_timeoutDelay;
    private short[] m_objectStateIds;
    private int[] m_objectStateValues;
    private int[] m_objectStateTimes;

    public SimData(AppEngine appEngine) {
        this.m_engine = appEngine;
        this.initData();
        this.resetRMSGameData();
    }

    public void moveObject(int n, int n2) {
        int n3 = 0 | n;
        int n4 = AppEngine.indexOf(n3, this.m_objectStateIds);
        if (n4 != -1) {
            int n5 = this.m_objectStateIds[n4] & 0xFF00;
            this.m_objectStateIds[n4] = (short)(n5 | n2);
        }
    }

    private static final short lookupSimsData(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    private void initData() {
        ResourceManager resourceManager = this.m_engine.getResourceManager();
        try {
            byte[] byArray;
            int n;
            short[] sArray;
            byte[] byArray2;
            Object[] objectArray;
            byte[] byArray3;
            Object[] objectArray2;
            Object[] objectArray3;
            Object[] objectArray4;
            byte[] byArray4;
            byte[] byArray5;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            short[] sArray2;
            Object object;
            byte[] byArray6;
            int n7;
            int n8;
            int n9;
            Object[] objectArray5;
            int n10;
            int n11;
            int n12;
            Object[] objectArray6;
            int n13;
            Object object2;
            short[] sArray3;
            short[] sArray4;
            short[] sArray5;
            short[] sArray6;
            int n14;
            short[] sArray7;
            Object[] objectArray7;
            short[] sArray8;
            int n15;
            DataInputStream dataInputStream = new DataInputStream(resourceManager.loadBinaryFile(67));
            int n16 = dataInputStream.readByte();
            short[] sArray9 = new short[n16];
            int[][] nArrayArray = new int[n16][];
            short[][] sArrayArray = new short[n16][];
            short[][] sArrayArray2 = new short[n16][];
            for (n15 = 0; n15 < n16; ++n15) {
                sArray9[n15] = SimData.lookupSimsData(dataInputStream);
                AppEngine.ASSERT(true, "invalid SKILL_NUM_RANKS");
                sArray8 = new short[3];
                for (int i = 0; i < sArray8.length; ++i) {
                    sArray8[i] = SimData.lookupSimsData(dataInputStream);
                }
                sArrayArray[n15] = sArray8;
                objectArray7 = new int[5];
                for (int i = 0; i < 5; ++i) {
                    objectArray7[i] = dataInputStream.readInt();
                }
                nArrayArray[n15] = objectArray7;
                sArray7 = new short[6];
                for (int i = 0; i < 6; ++i) {
                    sArray7[i] = SimData.lookupSimsData(dataInputStream);
                }
                sArrayArray2[n15] = sArray7;
            }
            n15 = dataInputStream.readByte();
            sArray8 = new short[n15];
            objectArray7 = new short[n15];
            sArray7 = new short[n15];
            byte[] byArray7 = new byte[n15];
            short[] sArray10 = new short[n15];
            short[] sArray11 = new short[n15];
            short[] sArray12 = new short[n15];
            short[][] sArrayArray3 = new short[n15][];
            short[][] sArrayArray4 = new short[n15][];
            short[][] sArrayArray5 = new short[n15][];
            short[][] sArrayArray6 = new short[n15][];
            short[][] sArrayArray7 = new short[n15][];
            byte[][][] byArrayArray = new byte[n15][][];
            for (n14 = 0; n14 < n15; ++n14) {
                sArray8[n14] = SimData.lookupSimsData(dataInputStream);
                objectArray7[n14] = SimData.lookupSimsData(dataInputStream);
                sArray7[n14] = SimData.lookupSimsData(dataInputStream);
                byArray7[n14] = dataInputStream.readByte();
                sArray10[n14] = SimData.lookupSimsData(dataInputStream);
                sArray11[n14] = SimData.lookupSimsData(dataInputStream);
                sArray12[n14] = SimData.lookupSimsData(dataInputStream);
                byte by = dataInputStream.readByte();
                sArray6 = new short[by];
                sArray5 = new short[by];
                sArray4 = new short[by];
                short[] sArray13 = new short[by];
                sArray3 = new short[by];
                object2 = new byte[by][];
                for (n13 = 0; n13 < by; ++n13) {
                    sArray6[n13] = SimData.lookupSimsData(dataInputStream);
                    sArray5[n13] = dataInputStream.readShort();
                    sArray4[n13] = dataInputStream.readShort();
                    int n17 = dataInputStream.readShort();
                    int n18 = dataInputStream.readShort();
                    n17 = n17 % 100 + n17 / 100 * 60;
                    n18 = n18 % 100 + n18 / 100 * 60;
                    sArray13[n13] = (short)n17;
                    sArray3[n13] = (short)n18;
                    objectArray6 = new byte[4];
                    objectArray6[0] = (byte)SimData.lookupSimsData(dataInputStream);
                    objectArray6[1] = dataInputStream.readByte();
                    objectArray6[2] = (byte)SimData.lookupSimsData(dataInputStream);
                    objectArray6[3] = dataInputStream.readByte();
                    object2[n13] = (short)objectArray6;
                }
                sArrayArray3[n14] = sArray6;
                sArrayArray4[n14] = sArray5;
                sArrayArray5[n14] = sArray4;
                sArrayArray6[n14] = sArray13;
                sArrayArray7[n14] = sArray3;
                byArrayArray[n14] = (byte[][])object2;
            }
            n14 = dataInputStream.readByte();
            short[] sArray14 = new short[n14];
            sArray6 = new short[n14];
            sArray5 = new short[n14];
            sArray4 = new short[n14];
            for (n12 = 0; n12 < n14; ++n12) {
                sArray14[n12] = SimData.lookupSimsData(dataInputStream);
                sArray6[n12] = SimData.lookupSimsData(dataInputStream);
                sArray5[n12] = SimData.lookupSimsData(dataInputStream);
                sArray4[n12] = dataInputStream.readShort();
            }
            n12 = dataInputStream.readByte();
            sArray3 = new short[n12];
            object2 = new short[n12];
            for (n13 = 0; n13 < n12; ++n13) {
                sArray3[n13] = SimData.lookupSimsData(dataInputStream);
                object2[n13] = dataInputStream.readShort();
            }
            n13 = dataInputStream.readByte();
            short[] sArray15 = new short[n13];
            int[] nArray = new int[n13];
            objectArray6 = new int[n13];
            short[] sArray16 = new short[n13];
            int[] nArray2 = new int[n13];
            short[] sArray17 = new short[n13];
            short[] sArray18 = new short[n13];
            for (n11 = 0; n11 < n13; ++n11) {
                sArray15[n11] = SimData.lookupSimsData(dataInputStream);
                nArray[n11] = dataInputStream.readInt();
                objectArray6[n11] = dataInputStream.readInt();
                sArray16[n11] = dataInputStream.readShort();
                nArray2[n11] = dataInputStream.readInt();
                sArray17[n11] = SimData.lookupSimsData(dataInputStream);
                sArray18[n11] = SimData.lookupSimsData(dataInputStream);
            }
            n11 = dataInputStream.readByte();
            byte[] byArray8 = new byte[n11];
            dataInputStream.readFully(byArray8);
            int n19 = dataInputStream.readByte();
            short[] sArray19 = new short[n19];
            int[] nArray3 = new int[n19];
            byte[] byArray9 = new byte[n19];
            byte[] byArray10 = new byte[n19];
            byte[] byArray11 = new byte[n19];
            byte[][] byArrayArray2 = new byte[n19][];
            int[][] nArrayArray2 = new int[n19][];
            byte[][] byArrayArray3 = new byte[n19][];
            byte[][] byArrayArray4 = new byte[n19][];
            byte[][] byArrayArray5 = new byte[n19][];
            int[][] nArrayArray3 = new int[n19][];
            for (n10 = 0; n10 < n19; ++n10) {
                sArray19[n10] = SimData.lookupSimsData(dataInputStream);
                nArray3[n10] = dataInputStream.readInt();
                byArray9[n10] = dataInputStream.readByte();
                byArray10[n10] = dataInputStream.readByte();
                byArray11[n10] = dataInputStream.readByte();
                byte by = dataInputStream.readByte();
                objectArray5 = new byte[by];
                Object[] objectArray8 = new int[by];
                for (n9 = 0; n9 < by; ++n9) {
                    objectArray5[n9] = dataInputStream.readByte();
                    objectArray8[n9] = dataInputStream.readInt();
                }
                byArrayArray2[n10] = (byte[])objectArray5;
                nArrayArray2[n10] = objectArray8;
                by = dataInputStream.readByte();
                objectArray5 = new byte[by];
                objectArray8 = new byte[by];
                for (n9 = 0; n9 < by; ++n9) {
                    objectArray5[n9] = (byte)SimData.lookupSimsData(dataInputStream);
                    objectArray8[n9] = dataInputStream.readByte();
                }
                byArrayArray3[n10] = (byte[])objectArray5;
                byArrayArray4[n10] = (byte[])objectArray8;
                by = dataInputStream.readByte();
                objectArray5 = new byte[by];
                objectArray8 = new int[by];
                for (n9 = 0; n9 < by; ++n9) {
                    objectArray5[n9] = dataInputStream.readByte();
                    objectArray8[n9] = dataInputStream.readInt();
                }
                byArrayArray5[n10] = (byte[])objectArray5;
                nArrayArray3[n10] = objectArray8;
            }
            n10 = dataInputStream.readByte();
            short[] sArray20 = new short[n10];
            objectArray5 = new short[n10];
            for (n8 = 0; n8 < n10; ++n8) {
                sArray20[n8] = SimData.lookupSimsData(dataInputStream);
                objectArray5[n8] = dataInputStream.readByte();
            }
            n8 = dataInputStream.readByte();
            n9 = dataInputStream.readByte();
            short[] sArray21 = new short[n9];
            byte[] byArray12 = new byte[n9];
            short[] sArray22 = new short[n9];
            short[] sArray23 = new short[n9];
            byte[][] byArrayArray6 = new byte[n9][];
            byte[][] byArrayArray7 = new byte[n9][];
            short[][] sArrayArray8 = new short[n9][];
            for (n7 = 0; n7 < n9; ++n7) {
                sArray21[n7] = SimData.lookupSimsData(dataInputStream);
                byArray12[n7] = dataInputStream.readByte();
                sArray22[n7] = SimData.lookupSimsData(dataInputStream);
                sArray23[n7] = SimData.lookupSimsData(dataInputStream);
                int n20 = dataInputStream.readUnsignedByte();
                byArray6 = new byte[n20];
                object = new byte[n20];
                sArray2 = new short[n20];
                for (int i = 0; i < n20; ++i) {
                    byArray6[i] = dataInputStream.readByte();
                    object[i] = (byte[])dataInputStream.readByte();
                    sArray2[i] = dataInputStream.readShort();
                }
                byArrayArray6[n7] = byArray6;
                byArrayArray7[n7] = (byte[])object;
                sArrayArray8[n7] = sArray2;
            }
            n7 = dataInputStream.readByte();
            short[] sArray24 = new short[n7];
            byArray6 = new byte[n7];
            object = new byte[n7][10];
            sArray2 = new short[n7];
            byte[] byArray13 = new byte[n7];
            byte[] byArray14 = new byte[n7];
            byte[] byArray15 = new byte[n7];
            byte[] byArray16 = new byte[n7];
            byte[][] byArrayArray8 = new byte[n7][];
            byte[][] byArrayArray9 = new byte[n7][];
            for (n6 = 0; n6 < n7; ++n6) {
                int n21;
                sArray24[n6] = SimData.lookupSimsData(dataInputStream);
                byArray6[n6] = dataInputStream.readByte();
                for (n21 = 0; n21 < 10; ++n21) {
                    object[n6][n21] = dataInputStream.readByte();
                }
                sArray2[n6] = SimData.lookupSimsData(dataInputStream);
                byArray13[n6] = dataInputStream.readByte();
                byArray14[n6] = dataInputStream.readByte();
                byArray15[n6] = dataInputStream.readByte();
                byArray16[n6] = dataInputStream.readByte();
                n21 = dataInputStream.readByte();
                byte[] byArray17 = new byte[n21];
                dataInputStream.readFully(byArray17);
                byArrayArray8[n6] = byArray17;
                n5 = dataInputStream.readByte();
                byte[] byArray18 = new byte[n5];
                dataInputStream.readFully(byArray18);
                byArrayArray9[n6] = byArray18;
            }
            n6 = dataInputStream.readByte();
            byte[][] byArray19 = new byte[n6][12];
            for (n4 = 0; n4 < n6; ++n4) {
                for (n5 = 0; n5 < 12; ++n5) {
                    byArray19[n4][n5] = dataInputStream.readByte();
                }
            }
            n4 = dataInputStream.readByte();
            short[] sArray25 = new short[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                sArray25[n3] = SimData.lookupSimsData(dataInputStream);
            }
            n3 = dataInputStream.readShort();
            short[] sArray26 = new short[n3];
            short[] sArray27 = new short[n3];
            int[] nArray4 = new int[n3];
            short[] sArray28 = new short[n3];
            byte[][] byArrayArray10 = new byte[n3][];
            byte[][] byArrayArray11 = new byte[n3][];
            byte[][] byArrayArray12 = new byte[n3][];
            int[][] nArrayArray4 = new int[n3][];
            short[][] sArrayArray9 = new short[n3][];
            byte[][] byArrayArray13 = new byte[n3][];
            byte[][] byArrayArray14 = new byte[n3][];
            byte[][] byArrayArray15 = new byte[n3][];
            byte[][] byArrayArray16 = new byte[n3][];
            short[][] sArrayArray10 = new short[n3][];
            for (n2 = 0; n2 < n3; ++n2) {
                int n22;
                sArray26[n2] = SimData.lookupSimsData(dataInputStream);
                sArray27[n2] = SimData.lookupSimsData(dataInputStream);
                nArray4[n2] = n22 = dataInputStream.readInt();
                sArray28[n2] = SimData.lookupSimsData(dataInputStream);
                byte by = dataInputStream.readByte();
                byArray5 = new byte[by];
                byArray4 = new byte[by];
                objectArray4 = new int[by];
                objectArray3 = new short[by];
                objectArray2 = new byte[by];
                byArray3 = new byte[by];
                objectArray = new byte[by];
                byArray2 = new byte[by];
                sArray = new short[by];
                for (n = 0; n < by; ++n) {
                    byArray5[n] = dataInputStream.readByte();
                    byArray4[n] = dataInputStream.readByte();
                    int n23 = dataInputStream.readInt();
                    objectArray3[n] = dataInputStream.readShort();
                    objectArray2[n] = dataInputStream.readByte();
                    byArray3[n] = dataInputStream.readByte();
                    objectArray[n] = dataInputStream.readByte();
                    byArray2[n] = dataInputStream.readByte();
                    sArray[n] = dataInputStream.readShort();
                    objectArray4[n] = (n23 & 1) != 0 ? ~n23 : n23;
                }
                n = dataInputStream.readByte();
                byArray = null;
                if ((n22 & 0x40000000) != 0) {
                    AppEngine.ASSERT(byArrayArray10[26] != null && n == 0, "invalid generic talk");
                    byArray = byArrayArray10[26];
                } else {
                    byArray = new byte[n];
                    dataInputStream.readFully(byArray);
                }
                byArrayArray11[n2] = byArray5;
                byArrayArray12[n2] = byArray4;
                nArrayArray4[n2] = objectArray4;
                sArrayArray9[n2] = objectArray3;
                byArrayArray13[n2] = (byte[])objectArray2;
                byArrayArray14[n2] = byArray3;
                byArrayArray15[n2] = (byte[])objectArray;
                byArrayArray16[n2] = byArray2;
                sArrayArray10[n2] = sArray;
                byArrayArray10[n2] = byArray;
            }
            n2 = dataInputStream.readByte();
            short[] sArray29 = new short[n2];
            byte[] byArray20 = new byte[n2];
            byArray5 = new byte[n2];
            byArray4 = new byte[n2];
            objectArray4 = new short[n2];
            objectArray3 = new byte[n2];
            objectArray2 = new short[n2];
            byArray3 = new byte[n2];
            objectArray = new short[n2];
            byArray2 = new byte[n2];
            sArray = new short[n2];
            for (n = 0; n < n2; ++n) {
                sArray29[n] = SimData.lookupSimsData(dataInputStream);
                byArray20[n] = dataInputStream.readByte();
                byArray5[n] = dataInputStream.readByte();
                byArray4[n] = dataInputStream.readByte();
                objectArray4[n] = SimData.lookupSimsData(dataInputStream);
                objectArray3[n] = dataInputStream.readByte();
                objectArray2[n] = SimData.lookupSimsData(dataInputStream);
                byArray3[n] = dataInputStream.readByte();
                objectArray[n] = SimData.lookupSimsData(dataInputStream);
                byArray2[n] = dataInputStream.readByte();
                sArray[n] = SimData.lookupSimsData(dataInputStream);
            }
            n = dataInputStream.readByte();
            byArray = new byte[n];
            short[] sArray30 = new short[n];
            short[] sArray31 = new short[n];
            short[] sArray32 = new short[n];
            short[] sArray33 = new short[n];
            short[] sArray34 = new short[n];
            short[][] sArrayArray11 = new short[n][];
            for (int i = 0; i < n; ++i) {
                byArray[i] = dataInputStream.readByte();
                sArray30[i] = SimData.lookupSimsData(dataInputStream);
                sArray31[i] = SimData.lookupSimsData(dataInputStream);
                sArray32[i] = dataInputStream.readShort();
                sArray33[i] = SimData.lookupSimsData(dataInputStream);
                sArray34[i] = dataInputStream.readShort();
                int n24 = dataInputStream.readByte();
                short[] sArray35 = new short[n24];
                for (int j = 0; j < n24; ++j) {
                    sArray35[j] = dataInputStream.readShort();
                }
                sArrayArray11[i] = sArray35;
            }
            dataInputStream.close();
            this.d_skillDescStrings = sArray9;
            this.d_skillRates = nArrayArray;
            this.d_skillIconAnims = sArrayArray;
            this.d_skillLevelDescStrings = sArrayArray2;
            this.d_careerDescStrings = sArray8;
            this.d_careerStreamers = objectArray7;
            this.d_careerRabbitHoles = sArray7;
            this.d_careerBosses = byArray7;
            this.d_careerFreakDeath1s = sArray10;
            this.d_careerFreakDeath2s = sArray11;
            this.d_careerRaiseFail = sArray12;
            this.d_careerLevelDescStrings = sArrayArray3;
            this.d_careerLevelIncomes = sArrayArray4;
            this.d_careerLevelFlags = sArrayArray5;
            this.d_careerLevelHoursStarts = sArrayArray6;
            this.d_careerLevelHoursEnds = sArrayArray7;
            this.d_careerLevelRequirements = byArrayArray;
            this.d_personaDescStrings = sArray14;
            this.d_personaLongDescStrings = sArray6;
            this.d_personaIcons = sArray5;
            this.d_personaFlags = sArray4;
            this.d_dreamDescStrings = sArray3;
            this.d_dreamFlags = object2;
            this.d_motiveCount = n13;
            this.d_motiveDescStrings = sArray15;
            this.d_motiveStartLevel = nArray;
            this.d_motiveDecayRate = objectArray6;
            this.d_motiveTriggersNeeds = sArray16;
            this.d_motiveTriggersNeedLevels = nArray2;
            this.d_motiveAnimHighs = sArray17;
            this.d_motiveAnimLows = sArray18;
            this.d_timeRangeDreams = byArray8;
            this.d_buffCount = n19;
            this.d_buffDescStringIds = sArray19;
            this.d_buffTimeouts = nArray3;
            this.d_buffTimeoutChains = byArray9;
            this.d_buffTimes = byArray10;
            this.d_buffFlags = byArray11;
            this.d_buffTriggerMotives = byArrayArray2;
            this.d_buffTriggerMotiveLevels = nArrayArray2;
            this.d_buffEffectMood = byArrayArray3;
            this.d_buffEffectMoodAmount = byArrayArray4;
            this.d_buffEffectMotive = byArrayArray5;
            this.d_buffEffectMotiveFactors = nArrayArray3;
            this.d_traitDescStrings = sArray20;
            this.d_traitExcludes = objectArray5;
            this.d_numRelLevels = n8;
            this.d_relStateDescStrings = sArray21;
            this.d_relStateFlags = byArray12;
            this.d_relStateEffectAnims = sArray22;
            this.d_relStateToStrings = sArray23;
            this.d_relStateTriggerToStates = byArrayArray6;
            this.d_relStateTriggerLevels = byArrayArray7;
            this.d_relStateTriggerLevelValues = sArrayArray8;
            this.d_numSims = n7;
            this.d_simNameStrings = sArray24;
            this.d_simMacromapColors = byArray6;
            this.d_simAttributes = object;
            this.d_simHomes = sArray2;
            this.d_simFlags = byArray13;
            this.d_simPartners = byArray14;
            this.d_simCareers = byArray15;
            this.d_simCareerLevels = byArray16;
            this.d_simTraits = byArrayArray8;
            this.d_simQuests = byArrayArray9;
            this.d_numPresets = n6;
            this.d_simPresets = byArray19;
            this.d_commodityStringIds = sArray25;
            this.d_numActions = n3;
            this.d_actionStringIds = sArray26;
            this.d_actionGroupStringIds = sArray27;
            this.d_actionFlags = nArray4;
            this.d_actionWorldArgs = sArray28;
            this.d_actionConditionCommodities = byArrayArray11;
            this.d_actionConditionTraits = byArrayArray12;
            this.d_actionConditionRelStates = nArrayArray4;
            this.d_actionEffectFlags = sArrayArray9;
            this.d_actionAffectFriendships = byArrayArray13;
            this.d_actionAffectRomances = byArrayArray14;
            this.d_actionAffectCommodities = byArrayArray15;
            this.d_actionAffectCommodityAmounts = byArrayArray16;
            this.d_actionResponseActions = sArrayArray10;
            this.d_actionPhases = byArrayArray10;
            this.d_chanceCardPrompts = sArray29;
            this.d_chanceCardYesPercents = byArray20;
            this.d_chanceCardNoPercents = byArray5;
            this.d_chanceCardResultYes1s = byArray4;
            this.d_chanceCardResultYes1Strings = objectArray4;
            this.d_chanceCardResultYes2s = objectArray3;
            this.d_chanceCardResultYes2Strings = objectArray2;
            this.d_chanceCardResultNo1s = byArray3;
            this.d_chanceCardResultNo1Strings = objectArray;
            this.d_chanceCardResultNo2s = byArray2;
            this.d_chanceCardResultNo2Strings = sArray;
            this.d_questFlags = byArray;
            this.d_questPrompts = sArray30;
            this.d_questMessages = sArray31;
            this.d_questFinishActions = sArray32;
            this.d_questGiveItem = sArray33;
            this.d_questRewardCash = sArray34;
            this.d_questTriggerActions = sArrayArray11;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getGameTimeAbs() {
        return this.m_timeTotal;
    }

    public int getGameTime() {
        return SimData.getGameTime(this.m_timeTotal);
    }

    public static int getGameTime(int n) {
        return n % 1440;
    }

    public int getGameDay() {
        return SimData.getGameDay(this.m_timeTotal);
    }

    public static int getGameDay(int n) {
        return n / 1440 % 7;
    }

    public static int getGameMidnight(int n) {
        return n / 1440 * 1440;
    }

    public int getTotalDays() {
        return (this.getGameTimeAbs() - 840) / 1440;
    }

    public int getMoney() {
        return this.m_money;
    }

    public int getMoneySpent() {
        return this.m_moneySpent;
    }

    public void adjustMoney(int n) {
        this.m_money += n;
        if (n < 0) {
            this.m_moneySpent -= n;
        } else {
            if (this.m_money >= 1000) {
                this.dreamCompleteEvent(50);
            }
            if (this.m_money >= 5000) {
                this.dreamCompleteEvent(69);
            }
        }
    }

    private void initGameTimeMoney() {
        this.m_timeTotal = 840;
        this.m_money = 700;
        this.m_moneySpent = 0;
        this.m_fastForward = false;
        this.m_furnitureStage = 0;
        this.m_houseUpgradeDay = (short)-1;
    }

    public void setFastforward(boolean bl) {
        this.m_fastForward = bl;
    }

    public boolean getFastforward() {
        return this.m_fastForward;
    }

    private void updateGameTime(int n) {
        this.m_timeTimer += n;
        if (this.m_timeTimer > 1000) {
            int n2 = this.m_timeTimer / 1000;
            this.m_timeTimer -= n2 * 1000;
            int n3 = this.m_timeTotal;
            this.m_timeTotal += n2;
            this.m_engine.getSceneGame().checkGameTimeTriggers(n3, this.m_timeTotal);
        }
    }

    public int getCostForAction(int n) {
        if (n == 127) {
            return 10;
        }
        if (n == 164) {
            int n2;
            int n3;
            int n4 = this.getSimCareer(0);
            if (n4 != -1 && ((n3 = this.getCareerLevelFlags(n4, n2 = this.getSimCareerLevel(0))) & 2) != 0) {
                return 15;
            }
            return 30;
        }
        AppEngine.ASSERT(false, "unknown cost for action");
        return 0;
    }

    public int getFurnitureStage() {
        int n = this.getTotalDays();
        for (int i = 0; i < this.getSkillCount(); ++i) {
            n += this.getSkillRank(i);
        }
        if (n >= 15) {
            return 2;
        }
        if (n >= 5) {
            return 1;
        }
        return 0;
    }

    public boolean isFurnitureStageChange() {
        int n = this.getFurnitureStage();
        if (n > this.m_furnitureStage) {
            this.m_furnitureStage = (byte)n;
            return true;
        }
        return false;
    }

    public void upgradePlayerHouse() {
        this.m_houseUpgradeDay = (short)this.getTotalDays();
    }

    public int getHouseUpgradeMessage() {
        int n = this.getTotalDays();
        int n2 = this.m_engine.getSimWorld().getHouseUpgradeLevel();
        if (n2 == 0) {
            if (n >= 3 && !this.getAchievements(16)) {
                this.setAchievements(16);
                return 784;
            }
        } else if (n2 == 1 && n - this.m_houseUpgradeDay >= 5 && !this.getAchievements(32)) {
            this.setAchievements(32);
            return 785;
        }
        return -1;
    }

    public int getDesiredWakeupTime(int n) {
        int n2 = 480;
        if (this.hasSimGotTrait(n, 10) != -1) {
            n2 = 540;
        } else if (this.hasSimGotTrait(n, 11) != -1) {
            n2 = 420;
        }
        return n2;
    }

    public int getWakeupTime(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.getGameTimeAbs();
        if (n == 0) {
            n5 = this.m_motiveLevelsF[1];
            n4 = 65536 - MathExt.Fdiv(n5, 0x640000);
            n3 = n6 + MathExt.Fmul(n4, 600);
        } else {
            n3 = n6 + 600;
        }
        n5 = this.getSimCareer(n);
        if (n5 != -1 && (n2 = (n4 = this.getNextJobStartTime(n, n6)) - 60) > n6 && n2 - n6 < 1440) {
            n3 = Math.min(n2, n3);
        }
        AppEngine.ASSERT(n3 >= n6, "can't wake up in the past!");
        return n3;
    }

    public void updateSkipWorking() {
        int n;
        int n2;
        int n3 = this.getSimCareer(0);
        int n4 = this.getCareerLevelHoursEnd(n3, n2 = this.getSimCareerLevel(0));
        int n5 = n4 - (n = this.getGameTime());
        if (n5 < 0) {
            n5 += 1440;
        }
        AppEngine.ASSERT(n4 >= n, "Can't knock-off *before* we go to work!");
        int n6 = n5 * 1000;
        this.updateGameTime(n6);
        this.adjustMotiveLevelWithBuffCheck(1, -983040, 3);
        this.adjustMotiveLevelWithBuffCheck(3, -1310720, 8);
        this.adjustMotiveLevel(5, -1638400);
        this.adjustMotiveLevel(2, this.getMotiveLevel(2) < 0x230000 ? 0x320000 : -983040);
        if (this.getSimCareer(0) != 0) {
            this.adjustMotiveLevelWithBuffCheck(0, -1310720, 0);
        }
        this.delayAlerts();
    }

    public void updateSkipSleeping(int n) {
        int n2 = this.getGameTimeAbs();
        AppEngine.ASSERT(n >= n2, "Can't wake up *before* we go to sleep!");
        int n3 = (n - n2) * 1000;
        this.updateGameTime(n3);
        this.adjustMotiveLevel(1, 0x640000);
        this.adjustMotiveLevel(2, -655360);
        this.adjustMotiveLevelWithBuffCheck(0, -1310720, 0);
        this.adjustMotiveLevelWithBuffCheck(3, -983040, 8);
        this.delayAlerts();
    }

    private void initInventory() {
        if (this.m_inventory == null) {
            int n = this.m_engine.getSimWorld().getItemCount();
            this.m_inventory = new byte[n];
        }
        AppEngine.fillArray(this.m_inventory, 0);
    }

    public int getInventoryCount(int n) {
        return this.m_inventory[n];
    }

    public int getInventoryNthCount() {
        return this.m_inventory.length - AppEngine.countOf(0, this.m_inventory);
    }

    public int getInventoryNthItem(int n) {
        return AppEngine.indexOfNthElement(n, this.m_inventory, 0);
    }

    public void adjustInventory(int n, int n2) {
        SimWorld simWorld;
        int n3 = this.m_engine.getSimWorld().getItemMaxInventory(n);
        this.m_inventory[n] = (byte)Math.min(n3, this.m_inventory[n] + n2);
        if (n2 > 0 && ((simWorld = this.m_engine.getSimWorld()).getItemFlags(n) & 0x800) != 0) {
            this.dreamCompleteEvent(34);
        }
    }

    public void createPlantContextMenu(short[] sArray, short[] sArray2, int n) {
        short s = this.d_actionStringIds[n];
        AppEngine.menuClear(sArray, s);
        AppEngine.menuClear(sArray2, s);
        SimWorld simWorld = this.m_engine.getSimWorld();
        byte[] byArray = this.m_inventory;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] <= 0 || (simWorld.getItemFlags(i) & 0x40) == 0) continue;
            AppEngine.menuAppendItem(sArray, simWorld.getItemDescString(i));
            AppEngine.menuAppendItem(sArray2, n);
        }
    }

    public void createCookContextMenu(short[] sArray, short[] sArray2, int n) {
        short s = this.d_actionStringIds[n];
        AppEngine.menuClear(sArray, s);
        AppEngine.menuClear(sArray2, s);
        SimWorld simWorld = this.m_engine.getSimWorld();
        byte[] byArray = this.m_inventory;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] <= 0 || (simWorld.getItemFlags(i) & 0x800) == 0) continue;
            AppEngine.menuAppendItem(sArray, simWorld.getItemDescString(i));
            AppEngine.menuAppendItem(sArray2, n);
        }
    }

    public boolean startRecipe(int n) {
        int n2;
        int n3;
        SimWorld simWorld = this.m_engine.getSimWorld();
        int n4 = simWorld.getRecipeIngredientCount(n);
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = simWorld.getRecipeIngredient(n, n3);
            if (this.getInventoryCount(n2) >= 1) continue;
            return false;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = simWorld.getRecipeIngredient(n, n3);
            this.adjustInventory(n2, -1);
        }
        this.m_activeRecipe = n;
        return true;
    }

    public int getActiveRecipe() {
        return this.m_activeRecipe;
    }

    public boolean startFishing() {
        return this.getInventoryCount(2) > 0;
    }

    public boolean startSkiing() {
        return this.getInventoryCount(3) > 0;
    }

    public boolean startXmasLighting() {
        return this.getInventoryCount(4) > 0;
    }

    public boolean plantSnowMan() {
        return this.getInventoryCount(5) > 0;
    }

    public boolean plantReindeerSleigh() {
        return this.getInventoryCount(6) > 0;
    }

    public boolean startRepairing() {
        return this.getInventoryCount(1) > 0;
    }

    public boolean startCleaning() {
        return this.getInventoryCount(0) > 0;
    }

    private void initSkills() {
        int n = this.getSkillCount();
        if (this.m_skillLevelsF == null) {
            this.m_skillLevelsF = new int[n];
        }
        AppEngine.fillArray(this.m_skillLevelsF, 0);
    }

    public int getSkillLevel(int n) {
        return this.m_skillLevelsF[n];
    }

    public int getSkillCount() {
        return this.d_skillDescStrings.length;
    }

    public int getSkillDesc(int n) {
        return this.d_skillDescStrings[n];
    }

    public int getSkillIcon1(int n) {
        return this.d_skillIconAnims[n][0];
    }

    public int getSkillIcon2(int n) {
        return this.d_skillIconAnims[n][1];
    }

    public int getSkillEventAnim(int n) {
        return this.d_skillIconAnims[n][2];
    }

    public int getSkillLevelDesc(int n) {
        return this.d_skillLevelDescStrings[n][this.getSkillRank(n)];
    }

    public int getSkillRank(int n) {
        return this.m_skillLevelsF[n] / 65536;
    }

    public void increaseSkill(int n) {
        int[] nArray = this.m_skillLevelsF;
        int n2 = this.getSkillRank(n);
        if (n2 < 5) {
            int n3 = n;
            nArray[n3] = nArray[n3] + this.d_skillRates[n][n2];
            nArray[n] = Math.min(nArray[n], 65536 * (n2 + 1));
        }
    }

    private void initCareer() {
        this.d_simCareers[0] = -1;
        this.d_simCareerLevels[0] = 0;
        this.m_careerAcceptDay = (byte)-1;
        this.m_careerDaysWorked = 0;
        this.m_careerDaysMissed = 0;
        if (this.m_careerLevelsAttained == null) {
            this.m_careerLevelsAttained = new byte[this.d_careerDescStrings.length];
        }
        AppEngine.fillArray(this.m_careerLevelsAttained, 0);
        this.m_phoneCareer = (byte)-1;
        this.m_phoneCareerTimer = 1440000;
    }

    private void updateCareer(int n) {
        this.m_phoneCareerTimer += n;
        if (this.m_phoneCareerTimer > 1440000) {
            this.m_phoneCareerTimer = 0;
            int n2 = this.d_careerDescStrings.length;
            if (!this.m_engine.isBonusUnlocked()) {
                --n2;
            }
            this.m_phoneCareer = (byte)(this.m_engine.rand(0, n2) - 1);
        }
    }

    public void careerAcceptJob(int n, int n2) {
        byte by = this.d_simCareers[0];
        byte by2 = this.d_simCareerLevels[0];
        this.d_simCareers[0] = (byte)n;
        this.d_simCareerLevels[0] = (byte)n2;
        if (n != -1) {
            this.m_careerLevelsAttained[n] = (byte)n2;
        }
        this.m_careerDaysWorked = 0;
        this.m_careerDaysMissed = 0;
        if (n != -1) {
            if (by != n) {
                this.m_careerAcceptDay = (byte)this.getGameDay();
            }
            AppEngine appEngine = this.m_engine;
            SceneGame sceneGame = appEngine.getSceneGame();
            int n3 = by == n ? (n2 > by2 ? 642 : 644) : 641;
            int n4 = this.getNextJobStartTime(0, this.getGameTimeAbs());
            int n5 = SimData.getGameDay(n4);
            int n6 = SimData.getGameDay(this.getGameTimeAbs() + 1440) == n5 ? 667 : DAY_STRINGS[n5];
            SDKString sDKString = appEngine.getString(n6);
            SDKString sDKString2 = appEngine.clearStringBuffer();
            appEngine.appendTimeToBuffer24Hour(this.d_careerLevelHoursStarts[n][n2]);
            SDKString sDKString3 = appEngine.getString(appEngine.getSimWorld().getObjectStringId(this.d_careerRabbitHoles[n]));
            appEngine.dynamicString(-11, n3, sDKString, sDKString2, sDKString3);
            int n7 = 0;
            if (by == n && n2 > by2) {
                n7 = 4;
            } else if (n != -1) {
                n7 = 3;
            }
            int n8 = this.getCareerLevelDescString(n, n2);
            sceneGame.showMessageBox(-11, n8, n7);
        }
    }

    public int careerDayWorked() {
        int n = this.getSimCareer(0);
        int n2 = this.getSimCareerLevel(0);
        int n3 = this.getCareerLevelIncome(n, n2);
        this.adjustMoney(n3);
        this.m_careerDaysWorked = (short)(this.m_careerDaysWorked + 1);
        if (this.m_careerDaysWorked % 3 == 2 && this.m_careerDaysMissed > 0) {
            this.m_careerDaysMissed = (short)(this.m_careerDaysMissed - 1);
        }
        return n3;
    }

    public void careerDayMissed() {
        this.m_careerDaysMissed = (short)(this.m_careerDaysMissed + 1);
        if (this.m_careerDaysMissed >= 3) {
            this.careerAcceptJob(-1, 0);
        }
    }

    public int getRequirementValue(int n) {
        switch (n) {
            default: {
                AppEngine.ASSERT(false, "invalid requirement");
            }
            case 0: {
                return this.getSkillRank(0);
            }
            case 1: {
                return this.getSkillRank(2);
            }
            case 6: {
                return this.getSkillRank(2);
            }
            case 2: {
                return this.m_careerDaysWorked;
            }
            case 3: {
                int n2 = 0;
                for (int i = 1; i < this.d_numSims; ++i) {
                    byte by = this.m_currentRelStates[i];
                    if ((this.getRelStateFlags(by) & 0x10) == 0) continue;
                    ++n2;
                }
                return n2;
            }
            case 4: {
                return this.getSkillRank(4);
            }
            case 5: 
        }
        return this.getSkillRank(3);
    }

    public int getRequimentName(int n) {
        switch (n) {
            default: {
                AppEngine.ASSERT(false, "invalid requirement");
            }
            case 0: {
                return 493;
            }
            case 1: {
                return 507;
            }
            case 6: {
                return 507;
            }
            case 2: {
                return 715;
            }
            case 3: {
                return 714;
            }
            case 4: {
                return 521;
            }
            case 5: 
        }
        return 514;
    }

    public boolean careerRequirementsMet(int n, int n2) {
        int n3;
        int n4;
        byte[] byArray = this.d_careerLevelRequirements[n][n2];
        byte by = byArray[0];
        byte by2 = byArray[1];
        if (by != -1 && (n4 = this.getRequirementValue(by)) < by2) {
            return false;
        }
        n4 = byArray[2];
        byte by3 = byArray[3];
        if (n4 != -1 && (n3 = this.getRequirementValue(n4)) < by3) {
            return false;
        }
        n3 = this.getCareerBoss(n);
        byte by4 = this.m_currentRelStates[n3];
        return (this.getRelStateFlags(by4) & 2) == 0;
    }

    public boolean careerAutoPromotionDue() {
        int n = this.getSimCareer(0);
        int n2 = this.getSimCareerLevel(0);
        return n2 < this.getCareerLevelCount(n) - 1 && this.careerRequirementsMet(n, n2 + 1) && this.m_careerDaysWorked >= 10;
    }

    public int getJobSearchCareerFromObject(MapObject mapObject) {
        byte by = this.d_simCareers[0];
        int n = -1;
        if (mapObject == null || mapObject.getType() == 77) {
            int n2 = this.getGameTime();
            if (n2 >= 450 && n2 <= 1110 && this.m_phoneCareer != by) {
                n = this.m_phoneCareer;
            }
        } else {
            n = AppEngine.indexOf(mapObject.getType(), this.d_careerRabbitHoles);
        }
        return n;
    }

    public int getJobSearchLevel(int n) {
        if (n == -1) {
            return 0;
        }
        int n2 = Math.max(this.m_careerLevelsAttained[n] - 1, 0);
        return n2;
    }

    public boolean isTimeInRange(int n, int n2, int n3) {
        if ((n2 = (n2 + 1440) % 1440) < (n3 = (n3 + 1440) % 1440)) {
            return n >= n2 && n <= n3;
        }
        return n >= n2 || n <= n3;
    }

    public int getTimeFlags(int n) {
        return this.getTimeFlags(n, this.getGameTimeAbs());
    }

    public int getTimeFlags(int n, int n2) {
        int n3 = 0;
        int n4 = SimData.getGameDay(n2);
        int n5 = SimData.getGameTime(n2);
        int n6 = this.getDesiredWakeupTime(n);
        int n7 = n6 - 600;
        byte by = this.d_simCareers[n];
        if (by == -1) {
            n3 |= 8;
        } else {
            byte by2 = this.d_simCareerLevels[n];
            short s = this.d_careerLevelHoursStarts[by][by2];
            if (n == 0 && n4 == this.m_careerAcceptDay) {
                n3 |= 8;
            } else {
                int n8;
                short s2;
                if (n == 0) {
                    this.m_careerAcceptDay = (byte)-1;
                }
                if (((s2 = this.d_careerLevelFlags[by][by2]) & (n8 = DAY_FLAGS[n4])) != 0) {
                    short s3 = this.d_careerLevelHoursEnds[by][by2];
                    n3 = n5 < s - 30 ? (n3 |= 8) : (n5 < s ? (n3 |= 1) : (n5 < s + 60 ? (n3 |= 2) : (n5 < s3 ? (n3 |= 4) : (n3 |= 8))));
                } else {
                    n3 |= 8;
                }
            }
            n7 = s - 660;
            n6 = s - 60;
        }
        if (this.isTimeInRange(n5, n7, n6)) {
            n3 |= 0x10;
        }
        return n3;
    }

    public int getNextJobStartTime(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.getSimCareer(n);
        AppEngine.ASSERT(n5 != -1, "Can't get the start time for a slacker");
        int n6 = this.getSimCareerLevel(n);
        int n7 = this.getCareerLevelFlags(n5, n6);
        int n8 = this.getCareerLevelHoursStart(n5, n6);
        int n9 = SimData.getGameTime(n2);
        int n10 = n4 = SimData.getGameDay(n2);
        for (n3 = 0; n3 < 7 && ((n7 & DAY_FLAGS[n10 = (n4 + n3) % 7]) == 0 || n == 0 && n10 == this.m_careerAcceptDay || n10 == n4 && n9 >= n8); ++n3) {
        }
        n3 = SimData.getGameMidnight(this.getGameTimeAbs()) + n8;
        if (n10 != n4) {
            n3 += (n10 - n4 + 7) % 7 * 1440;
        }
        return n3;
    }

    private boolean isPlaceForWork(MapObject mapObject, int n) {
        byte by = this.d_simCareers[n];
        if (by == -1) {
            return false;
        }
        if (mapObject != null) {
            int n2 = this.getCareerRabbitHole(by);
            return mapObject.getType() == n2;
        }
        return false;
    }

    public boolean isTimeForWork(MapObject mapObject, int n) {
        if (mapObject != null && !this.isPlaceForWork(mapObject, n)) {
            return false;
        }
        int n2 = this.getTimeFlags(n);
        return (n2 & 3) != 0;
    }

    public int getCareerLevelCount(int n) {
        return this.d_careerLevelDescStrings[n].length;
    }

    public int getCareerDescString(int n) {
        if (n == -1) {
            return 674;
        }
        return this.d_careerDescStrings[n];
    }

    public int getCareerStreamer(int n) {
        return this.d_careerStreamers[n];
    }

    public int getCareerRabbitHole(int n) {
        return this.d_careerRabbitHoles[n];
    }

    public int getCareerBoss(int n) {
        return this.d_careerBosses[n];
    }

    public int getCareerDeathString() {
        byte by = this.d_simCareers[0];
        if (this.m_engine.randPercent() < 50) {
            return this.d_careerFreakDeath1s[by];
        }
        return this.d_careerFreakDeath2s[by];
    }

    public int getCareerFailString(int n) {
        return this.d_careerRaiseFail[n];
    }

    public int getCareerLevelDescString(int n, int n2) {
        return this.d_careerLevelDescStrings[n][n2];
    }

    public int getCareerLevelIncome(int n, int n2) {
        return this.d_careerLevelIncomes[n][n2];
    }

    public int getCareerLevelFlags(int n, int n2) {
        return this.d_careerLevelFlags[n][n2];
    }

    public int getCareerLevelHoursStart(int n, int n2) {
        return this.d_careerLevelHoursStarts[n][n2];
    }

    public int getCareerLevelHoursEnd(int n, int n2) {
        return this.d_careerLevelHoursEnds[n][n2];
    }

    public byte[] getCareerLevelRequirements(int n, int n2) {
        return this.d_careerLevelRequirements[n][n2];
    }

    public int getPersona() {
        return this.m_persona;
    }

    public void setPersona(int n) {
        this.m_persona = (byte)n;
    }

    public int getPersonaCount() {
        return this.d_personaDescStrings.length;
    }

    public short getPersonaDescString(int n) {
        if (n == 1 && this.getSimAttribute(0, 0) == 1) {
            return 541;
        }
        return this.d_personaDescStrings[n];
    }

    public short getPersonaLongDescString(int n) {
        return this.d_personaLongDescStrings[n];
    }

    public int getPersonaIcon() {
        return this.d_personaIcons[this.m_persona];
    }

    public int getPersonaFlags() {
        return this.d_personaFlags[this.m_persona];
    }

    public int getPersonaNthGoalCount() {
        return AppEngine.countOfFlags(this.getPersonaFlags(), this.d_dreamFlags);
    }

    public int getPersonaNthGoalItem(int n) {
        return AppEngine.indexOfNthElementFlags(n, this.d_dreamFlags, this.getPersonaFlags());
    }

    private int getPersonaActionFlags() {
        switch (this.m_persona) {
            default: {
                AppEngine.ASSERT(false, "invalid persona");
            }
            case 5: {
                return 0x1000000;
            }
            case 3: {
                return 0x2000000;
            }
            case 4: {
                return 0x4000000;
            }
            case 1: {
                return 0x8000000;
            }
            case 2: {
                return 0x10000000;
            }
            case 0: 
        }
        return 0x20000000;
    }

    public boolean showPersonaComplete() {
        if (this.getAchievements(1) && !this.getAchievements(2)) {
            this.setAchievements(2);
            return true;
        }
        return false;
    }

    private void initDreams() {
        this.m_dream = (byte)-1;
        this.m_dreamLGCSeed = (short)this.m_engine.rand(0, this.d_dreamFlags.length - 1);
        this.m_dreamTimer = 115000;
        if (this.m_promises == null) {
            this.m_promises = new byte[4];
            this.m_timeRanges = new int[this.d_timeRangeDreams.length];
            this.m_woohooTimes = new int[10];
        }
        AppEngine.fillArray(this.m_promises, -1);
        this.m_personaGoalsCompleted = 0;
        this.m_achievements = 0;
        AppEngine.fillArray(this.m_timeRanges, this.getGameTimeAbs());
        this.m_dreamFishCount = 0;
        this.m_dreamHarvestCount = 0;
        AppEngine.fillArray(this.m_woohooTimes, -1);
        this.m_quickLinkFlags = 0;
    }

    public boolean getAchievements(int n) {
        return (this.m_achievements & n) != 0;
    }

    public void setAchievements(int n) {
        this.m_achievements |= n;
    }

    private void updateDreams(int n) {
        this.m_dreamTimer += n;
        if (this.m_dream != -1) {
            if (this.m_dreamTimer > 240000) {
                this.m_engine.getSceneGame().showExpiredDream(this.m_dream);
                this.m_dream = (byte)-1;
                this.m_dreamTimer = 0;
            }
        } else if (this.m_dreamTimer > 120000) {
            this.m_dream = (byte)this.dreamNew();
            this.m_dreamTimer = 0;
            this.m_engine.getSceneGame().showNewDream();
        }
        int n2 = this.getGameTimeAbs();
        for (int i = 0; i < this.m_timeRanges.length; ++i) {
            int n3 = this.m_timeRanges[i];
            if (n3 == -1 || n2 - n3 <= 4320) continue;
            this.m_timeRanges[i] = n2;
            this.dreamCompleteEvent(this.d_timeRangeDreams[i]);
        }
    }

    private static final void DEBUG_NEWDREAM(String string) {
    }

    private int dreamNew() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < 4; ++i) {
            byte by = this.m_promises[i];
            if (by == -1) continue;
            n2 = this.d_dreamFlags[by];
            if ((n2 & 1) != 0) {
                ++n3;
            }
            if ((n2 & 2) != 0) {
                ++n4;
            }
            if ((n2 & 4) == 0) continue;
            ++n5;
        }
        n2 = this.d_dreamFlags.length;
        AppEngine.ASSERT(n2 <= 257, "LGC isn't big enough for dreams list");
        int n6 = -1;
        int n7 = this.m_dreamLGCSeed;
        for (n = 0; n < n2; ++n) {
            while ((n7 = (1543 * n7 + 3571) % 257) >= n2) {
            }
            int n8 = n7;
            if (this.getDreamSlot(n8) != -1) {
                SimData.DEBUG_NEWDREAM("already active");
                continue;
            }
            short s = this.d_dreamFlags[n8];
            if ((s & 8) != 0) {
                SimData.DEBUG_NEWDREAM("persona dream");
                continue;
            }
            if (!this.dreamSuitable(n8)) {
                SimData.DEBUG_NEWDREAM("unsuitable");
                continue;
            }
            if (this.m_engine.isGoalCompleted(n8) && this.m_engine.randPercent() < 70) {
                SimData.DEBUG_NEWDREAM("already completed");
                continue;
            }
            SimData.DEBUG_NEWDREAM("   accepted");
            n6 = n8;
            this.m_dreamLGCSeed = (short)n8;
            break;
        }
        switch (n6) {
            case 51: {
                this.m_dreamFishCount = 0;
                break;
            }
            case 52: {
                this.m_dreamHarvestCount = 0;
                break;
            }
            case 59: {
                this.clearAllRelStateFlags(1536);
            }
        }
        n = AppEngine.indexOf(n6, this.d_timeRangeDreams);
        if (n != -1 && this.m_timeRanges[n] != -1) {
            this.m_timeRanges[n] = this.getGameTimeAbs();
        }
        AppEngine.ASSERT(n6 != -1, "couldn't find a new dream");
        this.m_engine.setGoalDiscovered(n6);
        return n6;
    }

    public void dreamToPromise() {
        int n = this.getDreamSlot(-1);
        if (n != -1 && this.m_dream != -1) {
            this.m_promises[n] = this.m_dream;
            this.m_dream = (byte)-1;
            this.m_dreamTimer = 0;
            this.m_engine.getSceneGame().showNewPromise(n);
        }
    }

    public boolean isDreamToPromisePossible() {
        return AppEngine.indexOf(-1, this.m_promises) != -1;
    }

    private boolean dreamSuitable(int n) {
        SimWorld simWorld = this.m_engine.getSimWorld();
        switch (n) {
            case 0: {
                return !this.getAchievements(4);
            }
            case 1: {
                return !this.getAchievements(64);
            }
            case 2: {
                return !this.getAchievements(8);
            }
            case 3: {
                return this.getInventoryCount(2) == 0;
            }
            case 4: {
                return this.getInventoryCount(3) == 0;
            }
            case 15: {
                return this.getInventoryCount(36) == 0;
            }
            case 5: {
                return this.getInventoryCount(7) == 0;
            }
            case 6: {
                return this.getInventoryCount(1) == 0;
            }
            case 7: {
                return !simWorld.playerOwnsParentType(19);
            }
            case 8: {
                return !simWorld.playerOwnsParentType(3);
            }
            case 9: {
                return this.getSkillRank(0) < 5;
            }
            case 12: {
                return this.getSkillRank(2) < 5;
            }
            case 13: {
                return this.getSkillRank(5) < 5;
            }
            case 16: {
                return this.getSkillRank(1) < 5;
            }
            case 17: {
                return this.getSkillRank(3) < 5;
            }
            case 18: 
            case 57: {
                AppEngine.ASSERT(true, "stranger should be 0");
                AppEngine.ASSERT(this.m_currentRelStates[0] == 0, "player rel state should be stranger");
                return AppEngine.countOf(0, this.m_currentRelStates) > 1;
            }
            case 19: 
            case 20: 
            case 21: {
                int n2 = n == 19 ? 16 : (n == 20 ? 4 : 8);
                for (int i = 1; i < this.d_numSims; ++i) {
                    if ((this.getRelStateFlags(this.m_currentRelStates[i]) & n2) != 0) continue;
                    return true;
                }
                return false;
            }
            case 27: {
                return this.getSimCareer(0) == -1;
            }
            case 34: {
                for (int i = 0; i < this.m_inventory.length; ++i) {
                    if (this.m_inventory[i] != 0 || (simWorld.getItemFlags(i) & 0x800) == 0) continue;
                    return true;
                }
                return false;
            }
            case 48: {
                return simWorld.playerOwnsParentType(9) && !simWorld.playerOwnsObject(43) && !simWorld.playerOwnsObject(44) && !simWorld.playerOwnsObject(45);
            }
            case 49: {
                return simWorld.playerOwnsParentType(22) && !simWorld.playerOwnsObject(96) && !simWorld.playerOwnsObject(97) && !simWorld.playerOwnsObject(98);
            }
            case 50: {
                return this.m_money < 500;
            }
            case 61: 
            case 62: {
                return this.getSimCareer(0) != -1 && this.getSimCareerLevel(0) < this.getCareerLevelCount(this.getSimCareer(0));
            }
        }
        return true;
    }

    public int getDreamSlot(int n) {
        return AppEngine.indexOf(n, this.m_promises);
    }

    public int getDream() {
        return this.m_dream;
    }

    public int getPromise(int n) {
        return this.m_promises[n];
    }

    public int getDreamDescString(int n) {
        if (n < 0 || n >= this.d_dreamDescStrings.length) {
            return 555;
        }
        return this.d_dreamDescStrings[n];
    }

    public int getTaskCount() {
        return this.d_dreamDescStrings.length;
    }

    public int getTaskFlags(int n) {
        return this.d_dreamFlags[n];
    }

    public void dreamCompleteEvent(int n) {
        int n2;
        int n3;
        AppEngine appEngine = this.m_engine;
        SceneGame sceneGame = appEngine.getSceneGame();
        boolean bl = false;
        int n4 = this.getDreamSlot(n);
        if (n4 != -1) {
            bl = true;
            this.m_promises[n4] = -1;
        } else if (this.m_dream == n) {
            bl = true;
            this.m_dream = (byte)-1;
            this.m_dreamTimer = 0;
        }
        int n5 = 0;
        switch (n) {
            case 0: {
                n5 |= 4;
                break;
            }
            case 1: {
                n5 |= 0x40;
                break;
            }
            case 2: {
                n5 |= 8;
            }
        }
        this.setAchievements(n5);
        int n6 = 0;
        int n7 = 0;
        int n8 = this.getTaskCount();
        int n9 = this.getPersonaFlags();
        for (n3 = 0; n3 < n8; ++n3) {
            if ((this.getTaskFlags(n3) & n9) == 0) continue;
            n2 = 1 << n6;
            if (n == n3 && (this.m_personaGoalsCompleted & n2) == 0) {
                this.m_personaGoalsCompleted |= n2;
                bl = true;
            }
            if ((this.m_personaGoalsCompleted & n2) != 0) {
                ++n7;
            }
            ++n6;
        }
        if (bl) {
            appEngine.setGoalCompleted(n);
            sceneGame.showGoalCompleted(n, n4);
        }
        if (n7 == n6) {
            this.setAchievements(1);
        }
        if ((n3 = (int)(appEngine.isBonusUnlocked() ? 1 : 0)) == 0) {
            n2 = this.d_dreamDescStrings.length;
            if (appEngine.getNumGoalsComplete() == n2) {
                sceneGame.unlockBonus();
            }
        }
        switch (n) {
            case 29: {
                this.m_dreamFishCount = (short)(this.m_dreamFishCount + 1);
                if (this.m_dreamFishCount < 15) break;
                this.dreamCompleteEvent(51);
            }
        }
    }

    public void registerBuyFurninture(int n) {
        SimWorld simWorld = this.m_engine.getSimWorld();
        int n2 = simWorld.getObjectParent(n);
        if (n2 == 3) {
            this.dreamCompleteEvent(8);
        } else if (n2 == 9) {
            if (n != 41) {
                this.dreamCompleteEvent(48);
            }
        } else if (n2 == 19) {
            this.dreamCompleteEvent(7);
        } else if (n2 == 22) {
            if (n != 95) {
                this.dreamCompleteEvent(49);
            }
        } else if (n2 == 23 && n == 93) {
            this.dreamCompleteEvent(14);
        }
        if (simWorld.gotBestFurniture()) {
            this.dreamCompleteEvent(71);
        }
        this.dreamCompleteEvent(28);
    }

    public void registerBuyItem(int n) {
        this.dreamCompleteEvent(28);
        if (n == 2) {
            this.dreamCompleteEvent(3);
        }
        if (n == 3) {
            this.dreamCompleteEvent(4);
        }
        if (n == 7) {
            this.dreamCompleteEvent(5);
        }
        if (n == 1) {
            this.dreamCompleteEvent(6);
        }
        if (n == 36) {
            this.dreamCompleteEvent(15);
        }
    }

    public void registerHarvest(int n) {
        this.m_dreamHarvestCount = (short)(this.m_dreamHarvestCount + n);
        if (this.m_dreamHarvestCount > 30) {
            this.dreamCompleteEvent(52);
        }
    }

    public boolean registerWooHoo() {
        int[] nArray = this.m_woohooTimes;
        int n = this.getGameTimeAbs();
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < 10; ++i) {
            int n4 = nArray[i];
            if (n - n4 > 1440) {
                nArray[i] = -1;
                n4 = -1;
            }
            if (n4 == -1 && n3 == -1) {
                n3 = i;
                nArray[i] = n;
                n4 = n;
            }
            if (n4 == -1) continue;
            ++n2;
        }
        if (n3 == -1 || n2 >= 10) {
            return true;
        }
        if (n2 >= 8) {
            this.dreamCompleteEvent(68);
        }
        this.dreamCompleteEvent(60);
        return false;
    }

    public boolean isPersonaGoalsCompleted(int n) {
        return (this.m_personaGoalsCompleted & 1 << n) != 0;
    }

    public boolean isQuickLinkVisited(int n) {
        int n2 = this.m_engine.getSimWorld().getObjectQuickLinkIndex(n);
        if (n2 != -1) {
            return (this.m_quickLinkFlags & 1 << n2) != 0;
        }
        return false;
    }

    public void setQuickLinkVisited(int n) {
        int n2 = this.m_engine.getSimWorld().getObjectQuickLinkIndex(n);
        if (n2 != -1) {
            this.m_quickLinkFlags |= 1 << n2;
        }
    }

    public int getMotiveCount() {
        return this.d_motiveCount;
    }

    public short getMotiveDescString(int n) {
        return this.d_motiveDescStrings[n];
    }

    public short getMotiveHighAnim(int n) {
        return this.d_motiveAnimHighs[n];
    }

    public short getMotiveLowAnim(int n) {
        return this.d_motiveAnimLows[n];
    }

    public int getMotiveLevel(int n) {
        return this.m_motiveLevelsF[n];
    }

    private void initMotives() {
        if (this.m_motiveLevelsF == null) {
            this.m_motiveLevelsF = new int[this.d_motiveCount];
            this.m_motiveDecaysF = new int[this.d_motiveCount];
            this.m_motiveDecayAdjustsF = new int[this.d_motiveCount];
            this.m_motiveDecayFactorsF = new int[this.d_motiveCount];
        }
        System.arraycopy(this.d_motiveStartLevel, 0, this.m_motiveLevelsF, 0, this.d_motiveCount);
        System.arraycopy(this.d_motiveDecayRate, 0, this.m_motiveDecaysF, 0, this.d_motiveCount);
        AppEngine.fillArray(this.m_motiveDecayAdjustsF, 0);
        AppEngine.fillArray(this.m_motiveDecayFactorsF, 65536);
        this.m_motiveTimer = 0;
    }

    private void updateMotives(int n) {
        this.m_motiveTimer += n;
        if (this.m_motiveTimer > 500) {
            this.m_motiveTimer -= 500;
            int[] nArray = this.m_motiveDecaysF;
            int[] nArray2 = this.m_motiveDecayFactorsF;
            int[] nArray3 = this.m_motiveDecayAdjustsF;
            for (int i = 0; i < this.d_motiveCount; ++i) {
                int n2 = MathExt.Fmul(nArray2[i], nArray[i]);
                this.adjustMotiveLevel(i, n2 + nArray3[i] >> 1);
            }
        }
    }

    public void adjustMotiveLevel(int n, int n2) {
        int[] nArray = this.m_motiveLevelsF;
        int n3 = n;
        nArray[n3] = nArray[n3] + n2;
        nArray[n] = MathExt.clip(nArray[n], 0, 0x640000);
    }

    private void adjustMotiveLevelWithBuffCheck(int n, int n2, int n3) {
        if (this.buffGetActiveSlot(n3) == -1) {
            this.adjustMotiveLevel(n, n2);
        }
    }

    public void setMotiveAdjust(int n, int n2) {
        this.m_motiveDecayAdjustsF[n] = n2;
    }

    public int getPlayerNeedFlags() {
        int n = 0;
        int[] nArray = this.m_motiveLevelsF;
        short[] sArray = this.d_motiveTriggersNeeds;
        int[] nArray2 = this.d_motiveTriggersNeedLevels;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= nArray2[i]) continue;
            n |= sArray[i];
        }
        return n;
    }

    private void initBuffs() {
        if (this.m_buffsActive == null) {
            this.m_buffsActive = new short[6];
            this.m_buffTimers = new int[6];
        }
        AppEngine.fillArray(this.m_buffsActive, -1);
        AppEngine.fillArray(this.m_buffTimers, 0);
    }

    private void updateBuffs(int n) {
        int n2;
        int n3;
        int n4;
        AppEngine appEngine = this.m_engine;
        short[] sArray = this.m_buffsActive;
        int[] nArray = this.m_buffTimers;
        byte[] byArray = this.d_buffFlags;
        int[] nArray2 = this.d_buffTimeouts;
        byte[] byArray2 = this.d_buffTimeoutChains;
        for (n4 = 0; n4 < 6; ++n4) {
            n3 = sArray[n4];
            if (n3 == -1) continue;
            if ((byArray[n3] & 2) == 0 && !this.buffTriggerConditionsExist(n3)) {
                this.removeActiveBuff(n3);
                continue;
            }
            n2 = nArray2[n3] * 1000;
            int n5 = n4;
            nArray[n5] = nArray[n5] + n;
            if (nArray[n4] <= n2) continue;
            nArray[n4] = n2;
            if (byArray2[n3] != -1) {
                this.setBuff(n4, byArray2[n3]);
                continue;
            }
            if (!this.buffTriggerConditionsExist(n3)) {
                this.removeActiveBuff(n3);
                continue;
            }
            switch (n3) {
                case 2: {
                    appEngine.dynamicString(-11, 809, appEngine.getSimName());
                    appEngine.getSceneGame().killPlayer(-11);
                    this.delayAlerts();
                    return;
                }
                case 5: {
                    appEngine.getSceneGame().passOut();
                    this.delayAlerts();
                    this.setBuff(n4, 4);
                    return;
                }
                case 10: {
                    this.adjustMotiveLevel(2, 0x320000);
                    this.removeActiveBuff(n3);
                    SceneGame sceneGame = appEngine.getSceneGame();
                    if (!sceneGame.isMapMode()) {
                        MapObjectSim mapObjectSim = sceneGame.getPlayerSim();
                        if (!mapObjectSim.isReady()) {
                            mapObjectSim.interrupt();
                        }
                        mapObjectSim.queueSimAction(4, null, 0, 0);
                    }
                    this.delayAlerts();
                    return;
                }
            }
        }
        n4 = this.d_buffCount;
        for (n3 = 0; n3 < n4; ++n3) {
            int n6;
            n2 = n3;
            if ((byArray[n2] & 8) != 0 || !this.buffTriggerConditionsExist(n2)) continue;
            if (n2 == 3 && (this.m_engine.getSceneGame().getPlayerSim().getSimPhase() == 52 || this.buffGetActiveSlot(6) != -1)) {
                n2 = 6;
            }
            if ((n6 = this.buffGetActiveSlot(n2)) == -1) {
                this.addActiveBuff(n2);
                this.delayAlerts();
                return;
            }
            if (n2 != 6) continue;
            this.m_buffTimers[n6] = 0;
        }
    }

    private void applyBuffsToMood() {
        int n;
        int[] nArray = this.m_moodLevelsF;
        AppEngine.fillArray(nArray, 0);
        for (n = 0; n < 6; ++n) {
            short s = this.m_buffsActive[n];
            if (s == -1) continue;
            byte[] byArray = this.d_buffEffectMood[s];
            byte[] byArray2 = this.d_buffEffectMoodAmount[s];
            int n2 = byArray.length;
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[i];
                nArray[by] = nArray[by] + (byArray2[i] << 16);
            }
        }
        for (n = 0; n < 2; ++n) {
            nArray[n] = MathExt.clip(nArray[n], -6553600, 0x640000);
        }
        this.updateMood();
    }

    private void setBuff(int n, int n2) {
        int n3;
        short s = this.m_buffsActive[n];
        this.m_buffsActive[n] = (short)n2;
        this.m_buffTimers[n] = 0;
        MapObjectSim mapObjectSim = this.m_engine.getSceneGame().getPlayerSim();
        mapObjectSim.endBuff(s);
        mapObjectSim.startBuff(n2);
        byte[][] byArray = this.d_buffEffectMotive;
        int[][] nArray = this.d_buffEffectMotiveFactors;
        int[] nArray2 = this.m_motiveDecayFactorsF;
        if (s != -1) {
            for (n3 = 0; n3 < byArray[s].length; ++n3) {
                byte by = byArray[s][n3];
                nArray2[by] = nArray2[by] + nArray[s][n3];
            }
        }
        if (n2 != -1) {
            for (n3 = 0; n3 < byArray[n2].length; ++n3) {
                byte by = byArray[n2][n3];
                nArray2[by] = nArray2[by] - nArray[n2][n3];
            }
            if (n2 == 9) {
                this.removeActiveBuff(8);
            } else if (n2 == 6) {
                this.removeActiveBuff(3);
                this.removeActiveBuff(7);
            } else if (n2 == 3) {
                this.removeActiveBuff(6);
                this.removeActiveBuff(7);
            }
            SceneGame sceneGame = this.m_engine.getSceneGame();
            if (n2 == 2) {
                sceneGame.showMessageBox(808, 408);
            } else if (n2 == 1) {
                sceneGame.showTutorialMessage((byte)10);
            } else if (n2 == 4) {
                sceneGame.showTutorialMessage((byte)11);
            } else if (n2 == 5) {
                sceneGame.showTutorialMessage((byte)12);
            } else if (n2 == 10) {
                sceneGame.showTutorialMessage((byte)13);
            } else if (n2 == 9) {
                sceneGame.showTutorialMessage((byte)14);
            } else if (n2 == 11) {
                sceneGame.showTutorialMessage((byte)15);
            }
        }
        this.applyBuffsToMood();
    }

    private void addActiveBuff(int n) {
        int n2;
        byte by = this.d_buffTimes[n];
        if (by != -1) {
            this.m_timeRanges[by] = -1;
        }
        AppEngine.ASSERT((n2 = AppEngine.indexOf(-1, this.m_buffsActive)) != -1, "no free buff slots");
        this.setBuff(n2, n);
    }

    private void removeActiveBuff(int n) {
        int n2;
        byte by = this.d_buffTimes[n];
        if (by != -1) {
            this.m_timeRanges[by] = this.getGameTimeAbs();
        }
        if ((n2 = AppEngine.indexOf(n, this.m_buffsActive)) != -1) {
            this.setBuff(n2, -1);
        }
    }

    private boolean buffTriggerConditionsExist(int n) {
        byte by = this.d_buffTimeoutChains[n];
        if (by != -1 && this.buffGetActiveSlot(by) != -1) {
            return false;
        }
        int[] nArray = this.m_motiveLevelsF;
        byte[] byArray = this.d_buffTriggerMotives[n];
        int[] nArray2 = this.d_buffTriggerMotiveLevels[n];
        int n2 = byArray.length;
        if (n2 == 0) {
            return true;
        }
        for (int i = 0; i < n2; ++i) {
            byte by2 = byArray[i];
            int n3 = nArray2[i];
            int n4 = nArray[by2];
            if (n3 > 0 && n4 > n3) {
                return true;
            }
            if (n3 >= 0 || n4 >= -n3) continue;
            return true;
        }
        return false;
    }

    public int buffGetActiveSlot(int n) {
        short[] sArray = this.m_buffsActive;
        for (int i = 0; i < 6; ++i) {
            if (sArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public int getBuff(int n) {
        return this.m_buffsActive[n];
    }

    public int getBuffDescString(int n) {
        return this.d_buffDescStringIds[n];
    }

    public int getBuffFlags(int n) {
        return this.d_buffFlags[n];
    }

    public int getTraitCount() {
        return 17;
    }

    public short getTraitDescString(int n) {
        return this.d_traitDescStrings[n];
    }

    private void initMoods() {
        if (this.m_moodLevelsF == null) {
            this.m_moodLevelsF = new int[4];
        }
        AppEngine.fillArray(this.m_moodLevelsF, 0x190000);
    }

    private void updateMood() {
        int n;
        int[] nArray = this.m_moodLevelsF;
        int n2 = Integer.MIN_VALUE;
        int n3 = -1;
        int n4 = Integer.MAX_VALUE;
        for (n = 0; n < 4; ++n) {
            if (nArray[n] > n2) {
                n2 = nArray[n];
            }
            if (nArray[n] >= n4) continue;
            n3 = n;
            n4 = nArray[n];
        }
        n = 3;
        int n5 = n2;
        if (n4 < -655360) {
            if (n4 < -3276800) {
                switch (n3) {
                    default: {
                        AppEngine.ASSERT(false, "invalid mood");
                    }
                    case 0: {
                        n = 5;
                        break;
                    }
                    case 1: {
                        n = 7;
                        break;
                    }
                    case 2: {
                        n = 9;
                        break;
                    }
                    case 3: {
                        n = 11;
                        break;
                    }
                }
            } else {
                switch (n3) {
                    default: {
                        AppEngine.ASSERT(false, "invalid mood");
                    }
                    case 0: {
                        n = 4;
                        break;
                    }
                    case 1: {
                        n = 6;
                        break;
                    }
                    case 2: {
                        n = 8;
                        break;
                    }
                    case 3: {
                        n = 10;
                    }
                }
            }
            n5 = n4;
        } else if (n2 > 655360) {
            n = n2 > 0x4B0000 ? 0 : (n2 > 0x280000 ? 1 : 2);
            n5 = n2;
        }
        this.m_moodDesc = n;
        this.m_moodLevel = n5;
    }

    public int getMoodDescStringId() {
        return MOODDESC_STRINGS[this.m_moodDesc];
    }

    public int getMoodLevel() {
        return this.m_moodLevel;
    }

    private void initRelationships() {
        int n = this.d_numSims;
        if (this.m_currentRelStates == null) {
            byte[] byArray = new byte[n];
            short[] sArray = new short[n];
            int[][] nArrayArray = new int[n][];
            int[][] nArrayArray2 = new int[n][];
            short[][] sArrayArray = new short[n][];
            byte[][] byArrayArray = new byte[n][];
            for (int i = 1; i < n; ++i) {
                nArrayArray[i] = new int[this.d_numRelLevels];
                nArrayArray2[i] = new int[this.d_commodityStringIds.length];
                sArrayArray[i] = new short[10];
                byArrayArray[i] = new byte[this.d_simTraits[i].length];
            }
            this.m_currentRelStates = byArray;
            this.m_currentRelStateFlags = sArray;
            this.m_currentRelLevelsF = nArrayArray;
            this.m_commodityLevelsF = nArrayArray2;
            this.m_actionHistories = sArrayArray;
            this.m_knownTraits = byArrayArray;
        }
        for (int i = 1; i < n; ++i) {
            this.m_currentRelStates[i] = 0;
            this.m_currentRelStateFlags[i] = 0;
            AppEngine.fillArray(this.m_currentRelLevelsF[i], 0);
            AppEngine.fillArray(this.m_actionHistories[i], -1);
            AppEngine.fillArray(this.m_knownTraits[i], 0);
        }
        this.m_commodityTimer = 0;
        this.m_lastNPC = -1;
        this.m_lastNPCTimer = 0;
    }

    private void updateRelationships(int n) {
        if (this.m_lastNPCTimer < 10000) {
            this.m_lastNPCTimer += this.m_engine.getSceneGame().getNormalTimeStep();
            if (this.m_lastNPCTimer >= 10000) {
                this.m_lastNPC = -1;
            }
        }
        this.m_commodityTimer += n;
        if (this.m_commodityTimer > 3000) {
            this.m_commodityTimer = 0;
        }
        int n2 = this.d_numSims;
        for (int i = 1; i < n2; ++i) {
            this.checkRelationshipTriggers(i);
            if (this.m_commodityTimer != 0) continue;
            int n3 = this.getDominantCommodity(i);
            this.decayCommodities(i, 327680);
            int n4 = this.getDominantCommodity(i);
            if (this.m_lastNPC != i || this.m_lastNPCTimer >= 10000 || n3 == n4) continue;
            short s = this.d_commodityStringIds[n4];
            int n5 = this.getSimName(i);
            this.m_engine.dynamicString(-12, (int)s, n5);
            this.m_engine.getSceneGame().showTickerMessage(-12, -1);
        }
    }

    public void setLastNPC(int n) {
        this.m_lastNPC = n;
        this.m_lastNPCTimer = 0;
    }

    public int getLastNPC() {
        return this.m_lastNPC;
    }

    public boolean isLastNPCStillRelevant() {
        return this.m_lastNPCTimer < 10000;
    }

    private void decayCommodities(int n, int n2) {
        int[] nArray = this.m_commodityLevelsF[n];
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = i;
            nArray[n3] = nArray[n3] - n2;
            if (nArray[i] >= 0) continue;
            nArray[i] = 0;
        }
    }

    private boolean checkRelationshipStranger(int n) {
        if (this.m_currentRelStates[n] == 0) {
            int n2 = 1;
            if (this.m_currentRelLevelsF[n][0] < 0) {
                n2 = 2;
            }
            this.relationshipStateTransition(n, n2);
            return true;
        }
        return false;
    }

    public void adjustRelLevels(int n, int n2, int n3) {
        int[] nArray = this.m_currentRelLevelsF[n];
        int n4 = nArray[0] + (n2 << 16);
        int n5 = nArray[1] + (n3 << 16);
        nArray[0] = MathExt.clip(n4, -1966080, 0x1E0000);
        nArray[1] = MathExt.clip(n5, -327680, 0x1E0000);
    }

    private boolean checkRelationshipTriggers(int n) {
        byte by = this.m_currentRelStates[n];
        int[] nArray = this.m_currentRelLevelsF[n];
        byte[] byArray = this.d_relStateTriggerToStates[by];
        byte[] byArray2 = this.d_relStateTriggerLevels[by];
        short[] sArray = this.d_relStateTriggerLevelValues[by];
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            boolean bl = true;
            byte by2 = byArray2[i];
            short s = sArray[i];
            int n3 = nArray[by2];
            boolean bl2 = s < 0;
            int n4 = s << 16;
            if (bl2 && n3 > n4 || !bl2 && n3 < n4) {
                bl = false;
            }
            if (!bl) continue;
            int n5 = byArray[i];
            if (n5 == 1 && nArray[0] < 0) {
                n5 = 2;
            }
            this.relationshipStateTransition(n, n5);
            return true;
        }
        return false;
    }

    private void relationshipStateTransition(int n, int n2) {
        byte[] byArray = this.m_currentRelStates;
        byte by = byArray[n];
        byArray[n] = (byte)n2;
        AppEngine.fillArray(this.m_currentRelLevelsF[n], 0);
        if (by == 0) {
            this.dreamCompleteEvent(18);
        }
        if (n2 == 12) {
            this.dreamCompleteEvent(72);
        }
        if ((this.getRelStateFlags(by) & 0x10) == 0 && (this.getRelStateFlags(n2) & 0x10) != 0) {
            this.dreamCompleteEvent(19);
        }
        if ((this.getRelStateFlags(by) & 8) == 0 && (this.getRelStateFlags(n2) & 8) != 0) {
            this.dreamCompleteEvent(21);
        }
        if ((this.getRelStateFlags(by) & 4) == 0 && (this.getRelStateFlags(n2) & 4) != 0) {
            this.dreamCompleteEvent(20);
        }
        if (AppEngine.indexOf(0, byArray, 1) == -1) {
            this.dreamCompleteEvent(57);
        }
        int n3 = 0;
        short s = 1;
        boolean bl = true;
        for (int i = 1; i < byArray.length; ++i) {
            byte by2 = byArray[i];
            s = s != 0 && (this.d_relStateFlags[by2] & 1) != 0 ? (short)1 : 0;
            boolean bl2 = bl = bl && (this.d_relStateFlags[by2] & 2) != 0;
            if ((this.d_relStateFlags[by2] & 4) == 0) continue;
            ++n3;
        }
        if (s != 0) {
            this.dreamCompleteEvent(73);
        }
        if (bl) {
            this.dreamCompleteEvent(74);
        }
        if (n3 >= 3) {
            this.dreamCompleteEvent(67);
        }
        if (n2 == 12) {
            this.m_engine.getSceneGame().triggerEvent(1, -1, n);
        } else {
            n3 = this.d_relStateToStrings[n2];
            s = this.d_simNameStrings[n];
            this.m_engine.dynamicString(-11, n3, s);
            this.m_engine.getSceneGame().showMessageBox(-11, this.getRelStateDescString(n2));
        }
    }

    private boolean actionEffectEvent(int n, int n2, int n3) {
        SceneGame sceneGame = this.m_engine.getSceneGame();
        byte by = this.m_currentRelStates[n];
        int n4 = -1;
        if (n2 == 87) {
            AppEngine.ASSERT(by == 10, "non-partners becoming fiancees");
            n4 = 11;
        } else if (n2 == 88) {
            AppEngine.ASSERT(by == 11, "non-fiancees getting married");
            n4 = 12;
        } else if (n2 == 98) {
            AppEngine.ASSERT(by == 12, "non-spouse getting divorced");
            n4 = 13;
        } else if (n2 == 97) {
            AppEngine.ASSERT(by == 9 || by == 10 || by == 11, "non-date/partner/fiancee breakup");
            n4 = 14;
        } else if (n2 == 99) {
            this.setSimCurRelStateFlags(n, 2);
            sceneGame.showMessageBox(776, 775);
        } else if (n2 == 100) {
            this.unsetSimCurRelStateFlags(n, 2);
            sceneGame.showMessageBox(777, 772);
        } else if (n2 == 101) {
            if ((n3 & 0x1000) != 0) {
                sceneGame.showMessageBox(643, this.getSimName(n));
            } else {
                byte by2 = this.d_simCareerLevels[0];
                byte by3 = this.d_simCareers[0];
                if (by2 < this.d_careerLevelFlags[by3].length - 1) {
                    sceneGame.showJobOffer(by3, by2 + 1, false);
                }
            }
        } else if (n2 == 102) {
            sceneGame.showQuitJob();
        }
        if (n4 != -1) {
            this.relationshipStateTransition(n, n4);
            return true;
        }
        return false;
    }

    public static int responseToFeedbackAnim(int n) {
        return RESPONSE_ANIMS[n & 0xF];
    }

    public void relationshipAction(int[] nArray, int n, int n2, int n3) {
        int n4;
        SceneGame sceneGame = this.m_engine.getSceneGame();
        int n5 = 0;
        int n6 = -1;
        int n7 = -1;
        int n8 = 0;
        boolean bl = false;
        int n9 = this.d_actionFlags[n3];
        if (n2 == 0) {
            if ((n9 & 0x80000) == 0) {
                if (n3 == 19) {
                    n5 = 35;
                    n6 = 11;
                } else {
                    n5 = 19;
                    n6 = 10;
                }
            }
            this.setSimCurRelStateFlags(n, 1);
            this.setSimCurRelStateFlags(0, 1);
            if (this.checkRelationshipStranger(n)) {
                bl = true;
            }
        } else if (n != 0) {
            if ((n9 & 0x80000) == 0) {
                n5 = 20;
                n6 = 10;
            }
        } else {
            n4 = this.calcActionEffect(n2, n3);
            if (n4 == -1) {
                n6 = (n9 & 0x200000) != 0 ? -1 : -1;
            } else {
                byte by;
                int n10;
                int n11;
                boolean bl2 = false;
                byte by2 = this.d_actionConditionTraits[n3][n4];
                if (by2 != -1) {
                    bl2 = this.tryDiscoverTrait(n2, by2);
                }
                short[] sArray = this.m_actionHistories[n2];
                for (n11 = 9; n11 > 0; --n11) {
                    sArray[n11] = sArray[n11 - 1];
                }
                sArray[0] = (short)n3;
                if ((n9 & 0x10) != 0) {
                    this.unsetSimCurRelStateFlags(n2, 1);
                } else {
                    this.setSimCurRelStateFlags(n2, 1);
                    this.setSimCurRelStateFlags(0, 1);
                }
                n6 = this.d_actionResponseActions[n3][n4];
                n11 = 1;
                MapObjectSim mapObjectSim = sceneGame.findSim(n2);
                if (n6 == -1 && mapObjectSim != null && mapObjectSim.isSleeping()) {
                    n11 = 0;
                }
                int n12 = 0;
                if (n11 != 0) {
                    int n13;
                    n10 = this.d_actionAffectFriendships[n3][n4];
                    by = this.d_actionAffectRomances[n3][n4];
                    this.adjustRelLevels(n2, n10, by);
                    n12 = n10 + by;
                    if (by > 0) {
                        n5 |= 0x40;
                    }
                    int n14 = this.getDominantCommodity(n2);
                    byte by3 = this.d_actionAffectCommodities[n3][n4];
                    byte by4 = this.d_actionAffectCommodityAmounts[n3][n4];
                    int[] nArray2 = this.m_commodityLevelsF[n2];
                    for (n13 = 0; n13 < nArray2.length; ++n13) {
                        if (n13 == by3) {
                            byte by5 = by3;
                            nArray2[by5] = nArray2[by5] + (by4 << 16);
                            if (nArray2[by3] <= 0xC80000) continue;
                            nArray2[by3] = 0xC80000;
                            continue;
                        }
                        int n15 = n13;
                        nArray2[n15] = nArray2[n15] - 655360;
                        if (nArray2[n13] >= 0) continue;
                        nArray2[n13] = 0;
                    }
                    n13 = this.getDominantCommodity(n2);
                    if (n13 != n14 && !bl2) {
                        short s = this.d_commodityStringIds[n13];
                        int n16 = this.getSimName(n2);
                        this.m_engine.dynamicString(-12, (int)s, n16);
                        sceneGame.showTickerMessage(-12, -1);
                        if (n13 == 1 || n13 == 2 || n13 == 8) {
                            this.dreamCompleteEvent(23);
                            this.setSimCurRelStateFlags(n2, 16384);
                        }
                        if (n13 == 2) {
                            this.dreamCompleteEvent(24);
                            this.setSimCurRelStateFlags(n2, 64);
                        }
                        if (n13 == 1) {
                            this.dreamCompleteEvent(25);
                            this.setSimCurRelStateFlags(n2, 128);
                        }
                    }
                }
                if (((n8 = this.d_actionEffectFlags[n3][n4]) & 8) != 0) {
                    if (this.actionEffectEvent(n2, n3, n8)) {
                        bl = true;
                    }
                } else if (n3 == 101 && (by = this.d_simCareerLevels[0]) < this.d_careerLevelFlags[n10 = this.d_simCareers[0]].length - 1) {
                    sceneGame.showJobRaiseFail(n10, by + 1);
                }
                if (this.checkRelationshipTriggers(n2)) {
                    bl = true;
                } else if ((n9 & 0x200000) == 0 && this.checkRelationshipStranger(n2)) {
                    bl = true;
                }
                if (bl) {
                    n7 = this.d_relStateEffectAnims[this.m_currentRelStates[n2]];
                }
                if (n7 != -1) {
                    n5 |= 3;
                } else {
                    n10 = 3 + n12;
                    n10 = MathExt.clip(n10, 0, 6);
                    n5 |= n10;
                }
                n5 = n5 < 3 ? (n5 |= 0x20) : (n5 |= 0x10);
            }
        }
        if (n6 != -1) {
            n4 = -1;
            if (n == 0) {
                n4 = n2;
            } else if (n2 == 0) {
                n4 = n;
            }
            if (n4 != -1) {
                this.adjustMotiveLevel(4, 0x140000);
                this.setLastNPC(n4);
            }
        }
        if (n == 0 && (n8 & 0x2000) != 0) {
            this.questCheckTriggers(n2, n3, !bl);
        }
        nArray[0] = n5;
        nArray[1] = n6;
        nArray[2] = n7;
    }

    public int getRelStateDescString(int n) {
        return this.d_relStateDescStrings[n];
    }

    public int getRelStateFlags(int n) {
        return this.d_relStateFlags[n];
    }

    public int getRelState(int n) {
        return this.m_currentRelStates[n];
    }

    public void getRelationshipLevels(int n, int[] nArray) {
        int n2 = this.getRelState(n);
        int[] nArray2 = this.m_currentRelLevelsF[n];
        byte[] byArray = this.d_relStateTriggerToStates[n2];
        byte[] byArray2 = this.d_relStateTriggerLevels[n2];
        short[] sArray = this.d_relStateTriggerLevelValues[n2];
        int n3 = 0;
        int n4 = byArray.length;
        for (int i = 0; i < n4; ++i) {
            byte by = byArray2[i];
            short s = sArray[i];
            int n5 = nArray2[by] >> 16;
            if ((s <= 0 || n5 <= 0) && (s >= 0 || n5 >= 0)) continue;
            nArray[n3 + 0] = byArray[i];
            nArray[n3 + 1] = MathExt.Fdiv(n5 << 16, s << 16);
            n3 += 2;
        }
        nArray[n3] = -1;
    }

    public boolean isWelcome() {
        if (!this.m_engine.getSceneGame().isHouseMode()) {
            return true;
        }
        int n = this.m_engine.getSimWorld().getHouseId();
        int n2 = this.getSimCount();
        for (int i = 1; i < n2; ++i) {
            int n3;
            int n4;
            if (this.getSimHome(i) != n || ((n4 = this.getRelStateFlags(n3 = this.getRelState(i))) & 0x20) == 0) continue;
            return true;
        }
        return n == 0;
    }

    private void clearAllRelStateFlags(int n) {
        int n2 = 1;
        while (n2 < this.d_numSims) {
            int n3 = n2++;
            this.m_currentRelStateFlags[n3] = (short)(this.m_currentRelStateFlags[n3] & ~n);
        }
    }

    private int countHouseRelStateFlags(int n) {
        boolean bl = true;
        int n2 = 0;
        for (int i = this.d_numSims - 1; i >= 1; --i) {
            int n3 = this.getSimHome(i);
            if (n3 == 0) continue;
            boolean bl2 = (this.m_currentRelStateFlags[i] & n) != 0;
            boolean bl3 = bl = bl && bl2;
            if (!bl2 || AppEngine.indexOf(n3, this.d_simHomes, i + 1) != -1) continue;
            ++n2;
        }
        if (bl) {
            return -1;
        }
        return n2;
    }

    public void setHouseCurRelStateFlags(int n, int n2) {
        int n3;
        for (n3 = 1; n3 < this.d_numSims; ++n3) {
            if (this.d_simHomes[n3] != n) continue;
            int n4 = n3;
            this.m_currentRelStateFlags[n4] = (short)(this.m_currentRelStateFlags[n4] | n2);
        }
        n3 = this.countHouseRelStateFlags(n2);
        if (n3 == -1) {
            switch (n2) {
                case 8: {
                    this.dreamCompleteEvent(64);
                    break;
                }
                case 4: {
                    this.dreamCompleteEvent(63);
                    break;
                }
                case 16: {
                    this.dreamCompleteEvent(77);
                }
            }
        }
        if (n2 == 512 || n2 == 1024) {
            if (n3 == -1) {
                this.dreamCompleteEvent(59);
            } else {
                int n5;
                int n6 = n5 = n2 == 512 ? 1024 : 512;
                if ((n3 += this.countHouseRelStateFlags(n5)) >= 3) {
                    this.dreamCompleteEvent(59);
                }
            }
        }
    }

    public void setSimCurRelStateFlags(int n, int n2) {
        int n3 = n;
        this.m_currentRelStateFlags[n3] = (short)(this.m_currentRelStateFlags[n3] | n2);
        int n4 = AppEngine.countOfFlags(n2, this.m_currentRelStateFlags, 0);
        switch (n2) {
            case 32: {
                AppEngine.ASSERT((this.m_currentRelStateFlags[0] & n2) == 0, "player shouldn't have slap flag");
                if (n4 < 4) break;
                this.dreamCompleteEvent(75);
                break;
            }
            case 64: {
                AppEngine.ASSERT((this.m_currentRelStateFlags[0] & n2) == 0, "player shouldn't have insulted flag");
                if (n4 < 5) break;
                this.dreamCompleteEvent(76);
                break;
            }
            case 128: {
                AppEngine.ASSERT((this.m_currentRelStateFlags[0] & n2) == 0, "player shouldn't have creeped flag");
                if (n4 < 5) break;
                this.dreamCompleteEvent(65);
                break;
            }
            case 256: {
                AppEngine.ASSERT((this.m_currentRelStateFlags[0] & n2) == 0, "player shouldn't have watch flag");
                if (n4 < 3) break;
                this.dreamCompleteEvent(66);
            }
        }
    }

    private void unsetSimCurRelStateFlags(int n, int n2) {
        int n3 = n;
        this.m_currentRelStateFlags[n3] = (short)(this.m_currentRelStateFlags[n3] & ~n2);
    }

    public boolean getSimCurRelStateFlags(int n, int n2) {
        return (this.m_currentRelStateFlags[n] & n2) != 0;
    }

    public int getRelationshipNthCount() {
        AppEngine.ASSERT(true, "stranger should be 0");
        AppEngine.ASSERT(this.m_currentRelStates[0] == 0, "player rel state should be stranger");
        return this.m_currentRelStates.length - AppEngine.countOf(0, this.m_currentRelStates);
    }

    public int getRelationshipNthItem(int n) {
        return AppEngine.indexOfNthElement(n, this.m_currentRelStates, 0);
    }

    public int getActionWorldArg(int n) {
        return this.d_actionWorldArgs[n];
    }

    public int getActionString(int n) {
        return this.d_actionStringIds[n];
    }

    public int getActionFlags(int n) {
        return this.d_actionFlags[n];
    }

    public int getActionPhaseCount(int n) {
        return this.d_actionPhases[n].length;
    }

    public int getActionPhase(int n, int n2) {
        return this.d_actionPhases[n][n2];
    }

    public void createContextMenu(MapObject mapObject, short[] sArray, short[] sArray2) {
        if (mapObject.getFlag(16384)) {
            MapObjectSim mapObjectSim = (MapObjectSim)mapObject;
            this.createSimContextMenu(mapObjectSim, sArray, sArray2);
        } else {
            this.createObjectContextMenu(mapObject, sArray, sArray2);
        }
    }

    private void createSimContextMenu(MapObjectSim mapObjectSim, short[] sArray, short[] sArray2) {
        int n = this.d_numActions;
        short[] sArray3 = this.d_actionStringIds;
        int[] nArray = this.d_actionFlags;
        int n2 = mapObjectSim.getId();
        boolean bl = mapObjectSim.isSleeping();
        this.setLastNPC(n2);
        short s = this.d_simNameStrings[n2];
        AppEngine.menuClear(sArray, s);
        AppEngine.menuClear(sArray2, s);
        if (this.m_engine.getSceneGame().isMapMode()) {
            int n3 = 161;
            AppEngine.menuAppendItem(sArray, sArray3[n3]);
            AppEngine.menuAppendItem(sArray2, n3);
            return;
        }
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            if ((nArray[i] & 1) == 0 || (nArray[i] & 4) == 0 && bl || (nArray[i] & 4) != 0 && !bl || sArray3[i] == 27) continue;
            boolean bl2 = true;
            int n6 = nArray[i];
            if (bl2) {
                if ((n6 & 8) != 0) {
                    bl2 = !this.getSimCurRelStateFlags(n2, 1);
                } else if ((n6 & 0x10) != 0) {
                    bl2 = this.getSimCurRelStateFlags(n2, 1);
                }
            }
            if ((n6 & 0x3F000000) != 0) {
                n5 = this.getPersonaActionFlags();
                boolean bl3 = bl2 = (n6 & n5) != 0;
            }
            if (bl2) {
                n5 = this.calcActionEffect(n2, i);
                boolean bl4 = bl2 = n5 != -1;
            }
            if (bl2) {
                n5 = this.d_simCareers[0];
                if ((n6 & 0x4000) != 0) {
                    bl2 = n5 != -1 ? (n4 = this.getCareerBoss(n5)) == n2 : false;
                }
                if (bl2 && (n6 & 0x8000) != 0) {
                    bl2 = n5 != -1 ? this.getSimCareer(n2) == n5 : false;
                }
            }
            if (bl2) {
                n5 = this.m_engine.getSimWorld().getHouseId();
                n4 = this.getSimHome(n2);
                if ((n6 & 0x30000) == 196608) {
                    bl2 = this.getSimCurRelStateFlags(n2, 2);
                } else if ((n6 & 0x10000) != 0) {
                    bl2 = n5 == 0 && n4 != 0;
                } else if ((n6 & 0x20000) != 0) {
                    boolean bl5 = bl2 = n5 != 0 && n4 == n5;
                }
            }
            if (bl2 && (n6 & 0x800000) != 0) {
                n5 = this.getQuestForActionFinish(i);
                boolean bl6 = bl2 = this.m_questSims[n5] == n2 && this.questConditionsSatisfied(n5);
            }
            if (bl2) {
                switch (i) {
                    case 99: {
                        bl2 = AppEngine.indexOfFlags(2, this.m_currentRelStateFlags) == -1;
                        break;
                    }
                    case 100: {
                        bl2 = this.m_currentRelStates[n2] != 12;
                        break;
                    }
                    case 87: {
                        bl2 = AppEngine.indexOf(12, this.m_currentRelStates) == -1;
                        break;
                    }
                    case 96: {
                        MapObjectSim mapObjectSim2 = this.m_engine.getSceneGame().getPlayerSim();
                        n4 = Math.abs(mapObjectSim.getPosX() - mapObjectSim2.getPosX());
                        int n7 = Math.abs(mapObjectSim.getPosZ() - mapObjectSim2.getPosZ());
                        bl2 = n4 + n7 > 0x200000;
                        break;
                    }
                }
            }
            if (!bl2) continue;
            AppEngine.menuAppendItem(sArray, sArray3[i]);
            AppEngine.menuAppendItem(sArray2, i);
        }
    }

    private void createObjectContextMenu(MapObject mapObject, short[] sArray, short[] sArray2) {
        int n;
        MapObjectSim mapObjectSim = this.m_engine.getSceneGame().getPlayerSim();
        short[] sArray3 = this.d_actionStringIds;
        int[] nArray = this.d_actionFlags;
        int n2 = mapObject.getTypeString();
        AppEngine.menuClear(sArray, n2);
        AppEngine.menuClear(sArray2, n2);
        int n3 = mapObject.getType();
        SimWorld simWorld = this.m_engine.getSimWorld();
        short[] sArray4 = simWorld.getObjectActions(n3);
        int n4 = simWorld.getObjectFlags(n3);
        int n5 = sArray4.length;
        if ((n4 & 0x4000000) != 0 && mapObject.getRuntimeFlag(256)) {
            AppEngine.menuAppendItem(sArray, sArray3[112]);
            AppEngine.menuAppendItem(sArray2, 112);
        }
        if ((n4 & 0x8000000) != 0 && mapObject.getRuntimeFlag(512)) {
            AppEngine.menuAppendItem(sArray, sArray3[111]);
            AppEngine.menuAppendItem(sArray2, 111);
        }
        for (n = 0; n < n5; ++n) {
            int n6;
            int n7;
            short s = sArray4[n];
            AppEngine.ASSERT(sArray3[s] != 27, "invalid action");
            int n8 = nArray[s];
            if ((n8 & 1) != 0 || (n8 & 0x20) != 0 && !mapObject.getRuntimeFlag(64) || (n8 & 0x40) != 0 && mapObject.getRuntimeFlag(64) || (n8 & 0x80) != 0 && !mapObject.isIdle() || (n8 & 0x100) != 0 && !mapObject.isActive() || (n8 & 0x200) != 0 && mapObject.getRuntimeFlag(256) || (n8 & 0x400) != 0 && mapObject.getRuntimeFlag(512) || (n8 & 0x1000) != 0 && !this.isPlaceForWork(mapObject, 0) || (n8 & 0x2000) != 0 && !this.isTimeForWork(mapObject, 0) || (n8 & 0x800) != 0 && this.isPlaceForWork(mapObject, 0) || (n8 & 0x20000) != 0 && simWorld.getHouseId() != 0 || (n8 & 0x10000) != 0 && simWorld.getHouseId() == 0 || s == 144 && n3 == 115 && !this.m_engine.isBonusUnlocked() || (n8 & 0x3F000000) != 0 && (n8 & (n7 = this.getPersonaActionFlags())) == 0 || s == 132 && mapObject.getRuntimeFlag(16384) || s == 133 && mapObject.getRuntimeFlag(32768) || s == 152 && !this.getSimCurRelStateFlags(0, 1) && simWorld.getHouseId() != 0 || s == 155 && (this.getSimCurRelStateFlags(0, 1) || simWorld.getHouseId() == 0) || s == 154 && (simWorld.getAttribute(n7 = simWorld.coordWorldToWorldTileX(mapObjectSim.getPosX()), n6 = simWorld.coordWorldToWorldTileZ(mapObjectSim.getPosZ())) & 0x10) != 0) continue;
            AppEngine.menuAppendItem(sArray, sArray3[s]);
            AppEngine.menuAppendItem(sArray2, s);
        }
        if ((n4 & 0x1000) != 0) {
            n = 108;
            AppEngine.menuAppendItem(sArray, sArray3[n]);
            AppEngine.menuAppendItem(sArray2, n);
        }
        if (sArray[0] == 0) {
            AppEngine.menuAppendItem(sArray, 281);
            AppEngine.menuAppendItem(sArray2, -4);
        }
    }

    public void compactContextMenu(short[] sArray, short[] sArray2, short[] sArray3) {
        AppEngine.menuClear(sArray, sArray3[1]);
        AppEngine.menuClear(sArray2, 27);
        short[] sArray4 = this.d_actionStringIds;
        short[] sArray5 = this.d_actionGroupStringIds;
        int n = sArray3[0];
        for (int i = 0; i < n; ++i) {
            short s = sArray3[5 + i];
            short s2 = sArray5[s];
            if (s2 != 27 && this.countContextMenuGroup(sArray3, s2) >= 2) {
                if (AppEngine.menuContains(sArray, s2)) continue;
                AppEngine.menuAppendItem(sArray, s2);
                AppEngine.menuAppendItem(sArray2, -2);
                continue;
            }
            AppEngine.menuAppendItem(sArray, sArray4[s]);
            AppEngine.menuAppendItem(sArray2, s);
        }
    }

    private int countContextMenuGroup(short[] sArray, int n) {
        short[] sArray2 = this.d_actionGroupStringIds;
        int n2 = 0;
        int n3 = sArray[0];
        for (int i = 0; i < n3; ++i) {
            short s = sArray[i + 5];
            short s2 = sArray2[s];
            if (s2 != n) continue;
            ++n2;
        }
        return n2;
    }

    public void filterContextMenu(short[] sArray, short[] sArray2, short[] sArray3, int n) {
        AppEngine.menuClear(sArray, n);
        AppEngine.menuClear(sArray2, n);
        short[] sArray4 = this.d_actionStringIds;
        short[] sArray5 = this.d_actionGroupStringIds;
        int n2 = sArray3[0];
        for (int i = 0; i < n2; ++i) {
            short s = sArray3[5 + i];
            short s2 = sArray5[s];
            if (s2 != n) continue;
            AppEngine.menuAppendItem(sArray, sArray4[s]);
            AppEngine.menuAppendItem(sArray2, s);
        }
    }

    public void createCallContextMenu(short[] sArray, short[] sArray2, int n) {
        short s = this.d_actionStringIds[n];
        AppEngine.menuClear(sArray, s);
        AppEngine.menuClear(sArray2, s);
        int n2 = this.m_engine.getSimWorld().getHouseId();
        for (int i = 1; i < this.d_numSims; ++i) {
            if (this.m_currentRelStates[i] == 0 || this.getSimHome(i) == n2) continue;
            AppEngine.menuAppendItem(sArray, this.d_simNameStrings[i]);
            AppEngine.menuAppendItem(sArray2, n);
        }
    }

    public int getDominantCommodity(int n) {
        int[] nArray = this.m_commodityLevelsF[n];
        int n2 = nArray.length;
        int n3 = 3;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] <= n4) continue;
            n4 = nArray[i];
            n3 = i;
        }
        return n3;
    }

    private int relStateToRelStateBit(int n) {
        switch (n) {
            default: {
                AppEngine.ASSERT(false, "invalid state");
            }
            case 0: {
                return 2;
            }
            case 1: {
                return 4;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 64;
            }
            case 7: {
                return 128;
            }
            case 8: {
                return 16;
            }
            case 9: {
                return 256;
            }
            case 10: {
                return 512;
            }
            case 2: {
                return 32;
            }
            case 3: {
                return 1024;
            }
            case 4: {
                return 2048;
            }
            case 11: {
                return 4096;
            }
            case 12: {
                return 8192;
            }
            case 13: {
                return 16384;
            }
            case 14: 
        }
        return 32768;
    }

    private boolean checkActionHistory(int n, int n2, int n3, int n4) {
        short[] sArray = this.m_actionHistories[n];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            if (sArray[i] != n2 || ++n5 < n3) continue;
            return true;
        }
        return false;
    }

    private int calcActionEffect(int n, int n2) {
        int n3 = this.getDominantCommodity(n);
        byte by = this.m_currentRelStates[n];
        int n4 = this.relStateToRelStateBit(by);
        byte[] byArray = this.d_actionConditionCommodities[n2];
        byte[] byArray2 = this.d_actionConditionTraits[n2];
        int[] nArray = this.d_actionConditionRelStates[n2];
        short[] sArray = this.d_actionEffectFlags[n2];
        for (int i = byArray.length - 1; i >= 0; --i) {
            int n5;
            int n6;
            int n7;
            int n8;
            byte by2;
            byte by3 = byArray[i];
            if (by3 != -1 && by3 != n3 || (by2 = byArray2[i]) != -1 && this.hasSimGotTrait(n, by2) == -1 || (n8 = nArray[i]) != 0 && (n8 & n4) == 0) continue;
            short s = sArray[i];
            if ((s & 7) != 0) {
                int n9 = 3;
                n7 = 6;
                if ((s & 1) != 0) {
                    n9 = 2;
                    n7 = 4;
                } else if ((s & 4) != 0) {
                    n9 = 6;
                    n7 = 10;
                }
                if (!this.checkActionHistory(n, n2, n9, n7)) continue;
            }
            if ((s & 0x1F0) != 0) {
                n7 = (s & 0x10) != 0 ? 0 : ((s & 0x20) != 0 ? 1 : ((s & 0x40) != 0 ? 2 : ((s & 0x80) != 0 ? 3 : 4)));
                n6 = this.m_skillLevelsF[n7];
                int n10 = n5 = (s & 0x200) != 0 ? 196608 : 65536;
                if (n6 < n5) continue;
            }
            if ((s & 0xC00) != 0 && ((s & 0x800) == 0 ? !this.buffTriggerConditionsExist(1) : !this.buffTriggerConditionsExist(4))) continue;
            if (n2 == 101 && (s & 8) != 0 && (s & 0x1000) == 0 && ((n6 = this.d_simCareers[0]) == -1 || (n5 = this.d_simCareerLevels[0]) >= this.d_careerLevelDescStrings[n6].length - 1 || !this.careerRequirementsMet(n6, n5 + 1))) continue;
            return i;
        }
        return -1;
    }

    public boolean actionAccept(int n, int n2, int n3) {
        if (n == 0) {
            int n4 = this.calcActionEffect(n2, n3);
            return (this.d_actionEffectFlags[n3][n4] & 0x1000) == 0;
        }
        return true;
    }

    public int getActionTalkIcon(int n) {
        int n2;
        int n3;
        switch (n) {
            default: {
                AppEngine.ASSERT(false, "unknown action with talk phase");
            }
            case 19: {
                n3 = 16;
                break;
            }
            case 20: {
                n3 = 16;
                break;
            }
            case 26: {
                n3 = 1;
                break;
            }
            case 27: {
                n3 = 1;
                break;
            }
            case 28: {
                n3 = 16;
                break;
            }
            case 61: {
                n3 = 4;
                break;
            }
            case 62: {
                n3 = 64;
                break;
            }
            case 63: {
                n3 = 1;
                break;
            }
            case 64: {
                n3 = 1;
                break;
            }
            case 65: {
                n3 = 1;
                break;
            }
            case 67: {
                n3 = 1;
                break;
            }
            case 66: {
                n3 = 1;
                break;
            }
            case 68: {
                n3 = 1;
                break;
            }
            case 69: {
                n3 = 4;
                break;
            }
            case 70: {
                n3 = 128;
                break;
            }
            case 71: {
                n3 = 512;
                break;
            }
            case 74: {
                n3 = 4;
                break;
            }
            case 76: {
                n3 = 512;
                break;
            }
            case 75: {
                n3 = 128;
                break;
            }
            case 73: {
                n3 = 256;
                break;
            }
            case 77: {
                n3 = 256;
                break;
            }
            case 78: {
                n3 = 32;
                break;
            }
            case 79: {
                n3 = 32;
                break;
            }
            case 80: {
                n3 = 32;
                break;
            }
            case 82: {
                n3 = 1;
                break;
            }
            case 83: {
                n3 = 1;
                break;
            }
            case 91: {
                n3 = 1;
                break;
            }
            case 87: {
                n3 = 1;
                break;
            }
            case 88: {
                n3 = 1;
                break;
            }
            case 89: {
                n3 = 1;
                break;
            }
            case 90: {
                n3 = 1;
                break;
            }
            case 92: {
                n3 = 16;
                break;
            }
            case 93: {
                n3 = 16;
                break;
            }
            case 94: {
                n3 = 16;
                break;
            }
            case 101: {
                n3 = 1;
                break;
            }
            case 96: {
                n3 = 8;
                break;
            }
            case 97: {
                n3 = 1;
                break;
            }
            case 98: {
                n3 = 1;
                break;
            }
            case 99: {
                n3 = 1;
                break;
            }
            case 100: {
                n3 = 1;
                break;
            }
            case 102: {
                n3 = 1;
                break;
            }
            case 103: {
                n3 = 1;
                break;
            }
            case 104: {
                n3 = 1;
                break;
            }
            case 105: {
                n3 = 1;
                break;
            }
            case 142: {
                n3 = 1;
                break;
            }
            case 138: {
                n3 = 1;
                break;
            }
            case 139: {
                n3 = 1;
                break;
            }
            case 140: {
                n3 = 256;
                break;
            }
            case 141: {
                n3 = 256;
                break;
            }
            case 114: {
                n3 = -1;
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                n3 = 1;
            }
        }
        int n4 = 0;
        for (n2 = 0; n2 < SPEECHICONS.length; n2 += 2) {
            if ((n3 & SPEECHICONS[n2 + 1]) == 0) continue;
            ++n4;
        }
        n2 = this.m_engine.rand(0, n4 - 1);
        n4 = 0;
        for (int i = 0; i < SPEECHICONS.length; i += 2) {
            if ((n3 & SPEECHICONS[i + 1]) == 0) continue;
            if (n4 == n2) {
                return SPEECHICONS[i];
            }
            ++n4;
        }
        return 203;
    }

    public static final void DEBUG_CHANCE(String string) {
    }

    private boolean changeCardAppropriate(int n) {
        byte by = this.d_chanceCardResultNo1s[n];
        byte by2 = this.d_chanceCardResultNo2s[n];
        byte by3 = this.d_chanceCardResultYes1s[n];
        byte by4 = this.d_chanceCardResultYes2s[n];
        int n2 = this.getSimCareer(0);
        AppEngine.ASSERT(n2 != -1, "chance card means sim should have a job");
        int n3 = this.getSimCareerLevel(0);
        if ((by == 2 || by2 == 2 || by3 == 2 || by4 == 2) && n3 == 0) {
            SimData.DEBUG_CHANCE("avoiding demotion card");
            return false;
        }
        int n4 = this.d_careerLevelDescStrings[n2].length - 1;
        if ((by == 1 || by2 == 1 || by3 == 1 || by4 == 1) && n3 == n4) {
            SimData.DEBUG_CHANCE("avoiding promotion card");
            return false;
        }
        return true;
    }

    public int getChanceCardForWork() {
        int n;
        do {
            n = this.m_engine.rand(0, this.d_chanceCardPrompts.length - 1);
            SimData.DEBUG_CHANCE("trying card: " + n);
        } while (!this.changeCardAppropriate(n));
        SimData.DEBUG_CHANCE("final card: " + n);
        return n;
    }

    public int getChanceCardOutcome(int n, boolean bl) {
        int n2 = this.m_engine.randPercent();
        if (bl) {
            return n2 < this.d_chanceCardYesPercents[n] ? 0 : 1;
        }
        return n2 < this.d_chanceCardNoPercents[n] ? 2 : 3;
    }

    public int getChanceCardPromptString(int n) {
        return this.d_chanceCardPrompts[n];
    }

    public int getChanceCardOutcomeString(int n, int n2) {
        switch (n2) {
            default: {
                AppEngine.ASSERT(false, "invalid outcome");
            }
            case 0: {
                return this.d_chanceCardResultYes1Strings[n];
            }
            case 1: {
                return this.d_chanceCardResultYes2Strings[n];
            }
            case 2: {
                return this.d_chanceCardResultNo1Strings[n];
            }
            case 3: 
        }
        return this.d_chanceCardResultNo2Strings[n];
    }

    public void performChanceCardOutcome(int n, int n2) {
        byte by;
        switch (n2) {
            default: {
                AppEngine.ASSERT(false, "invalid outcome");
            }
            case 0: {
                by = this.d_chanceCardResultYes1s[n];
                break;
            }
            case 1: {
                by = this.d_chanceCardResultYes2s[n];
                break;
            }
            case 2: {
                by = this.d_chanceCardResultNo1s[n];
                break;
            }
            case 3: {
                by = this.d_chanceCardResultNo2s[n];
            }
        }
        byte by2 = this.d_simCareers[0];
        byte by3 = this.d_simCareerLevels[0];
        switch (by) {
            case 0: {
                break;
            }
            case 1: {
                this.dreamCompleteEvent(61);
                this.careerAcceptJob(by2, by3 + 1);
                break;
            }
            case 2: {
                this.careerAcceptJob(by2, by3 - 1);
                break;
            }
            case 3: {
                this.careerAcceptJob(-1, 0);
                break;
            }
            case 4: {
                int n3 = -1;
                int n4 = 1;
                switch (by2) {
                    case 3: {
                        n3 = 37;
                        break;
                    }
                    case 1: {
                        n3 = 14;
                        break;
                    }
                    case 4: {
                        n3 = 21;
                        break;
                    }
                    case 0: {
                        n3 = 25;
                        break;
                    }
                    case 2: {
                        n3 = 26;
                    }
                }
                this.adjustInventory(n3, n4);
                break;
            }
            case 5: {
                this.adjustMoney(1000);
            }
        }
    }

    private void initQuests() {
        if (this.m_questSims == null) {
            this.m_questSims = new byte[this.d_questPrompts.length];
            this.m_questTimes = new int[this.d_questPrompts.length];
        }
        AppEngine.fillArray(this.m_questSims, -1);
        AppEngine.fillArray(this.m_questTimes, -1);
    }

    public int getQuestPromptString(int n) {
        return this.d_questPrompts[n];
    }

    public int getQuestMessageString(int n) {
        return this.d_questMessages[n];
    }

    public int getQuestFlags(int n) {
        return this.d_questFlags[n];
    }

    private int getQuestForActionFinish(int n) {
        return AppEngine.indexOf(n, this.d_questFinishActions);
    }

    public static final void DEBUG_QUEST(String string) {
    }

    /*
     * Unable to fully structure code
     */
    private void questCheckTriggers(int var1_1, int var2_2, boolean var3_3) {
        var6_4 = this.getGameTimeAbs();
        var7_5 = this.d_simQuests[var1_1];
        for (var8_6 = 0; var8_6 < var7_5.length; ++var8_6) {
            var9_7 = var7_5[var8_6];
            var10_8 = this.m_questTimes[var9_7];
            var11_9 = false;
            if (this.m_questSims[var9_7] != var1_1) ** GOTO lbl17
            if (this.d_questFinishActions[var9_7] == var2_2) {
                this.m_engine.getSceneGame().triggerFetchQuestEnd(var9_7, var1_1);
                break;
            }
            if (var6_4 - var10_8 >= 1440) {
                var11_9 = true;
                SimData.DEBUG_QUEST("retrigger?");
            } else {
                SimData.DEBUG_QUEST("skip sim currently active");
                continue;
lbl17:
                // 1 sources

                if (this.m_questSims[var9_7] != -1) {
                    SimData.DEBUG_QUEST("skip active");
                    continue;
                }
            }
            if (!var3_3) {
                SimData.DEBUG_QUEST("skip supressed");
                continue;
            }
            if (AppEngine.indexOf(var2_2, this.d_questTriggerActions[var9_7]) == -1) continue;
            if (!var11_9) {
                if (AppEngine.indexOf(var1_1, this.m_questSims) != -1) {
                    SimData.DEBUG_QUEST("other active");
                    continue;
                }
                if (var10_8 != -1 && var6_4 - var10_8 < 1440) {
                    SimData.DEBUG_QUEST("skip time");
                    continue;
                }
                if (this.m_engine.randPercent() > 30) {
                    SimData.DEBUG_QUEST("skip chance");
                    continue;
                }
            }
            this.m_questTimes[var9_7] = this.getGameTimeAbs();
            this.questStart(var9_7, var1_1);
            break;
        }
    }

    private void questStart(int n, int n2) {
        AppEngine.ASSERT(this.m_questSims[n] == -1 || this.m_questSims[n] == n2, "quest already in progress");
        this.m_questSims[n] = (byte)n2;
        this.m_engine.getSceneGame().triggerFetchQuest(n, n2);
        switch (n) {
            case 0: {
                this.unsetSimCurRelStateFlags(1, 4096);
                break;
            }
            case 1: {
                this.unsetSimCurRelStateFlags(1, 2048);
                break;
            }
            case 4: {
                this.unsetSimCurRelStateFlags(2, 8192);
                break;
            }
            case 9: {
                this.unsetSimCurRelStateFlags(13, 4096);
                break;
            }
            case 16: {
                this.unsetSimCurRelStateFlags(4, 4096);
                break;
            }
            case 17: {
                this.unsetSimCurRelStateFlags(4, 16384);
                break;
            }
            case 18: {
                this.unsetSimCurRelStateFlags(4, 2048);
                break;
            }
            case 19: {
                this.unsetSimCurRelStateFlags(2, 4096);
                break;
            }
            case 20: {
                this.unsetSimCurRelStateFlags(2, 16384);
                break;
            }
            case 21: {
                this.unsetSimCurRelStateFlags(2, 2048);
                break;
            }
            case 31: {
                this.unsetSimCurRelStateFlags(7, 4096);
            }
        }
    }

    public void questCompleted(int n) {
        short s;
        short s2 = this.d_questRewardCash[n];
        if (s2 != 0) {
            this.adjustMoney(s2);
        }
        if ((s = this.d_questGiveItem[n]) != -1) {
            AppEngine.ASSERT(this.m_inventory[s] > 0, "invalid giving");
            this.adjustInventory(s, -1);
        }
        int n2 = -1;
        if ((this.d_questFlags[n] & 1) != 0) {
            n2 = -2;
        }
        this.m_questSims[n] = n2;
        this.m_questTimes[n] = this.getGameTimeAbs();
        if (n == 22) {
            this.adjustInventory(53, 1);
        }
    }

    private boolean questConditionsSatisfied(int n) {
        short[] sArray = this.m_currentRelStateFlags;
        switch (n) {
            case 0: {
                return (sArray[1] & 0x1000) != 0;
            }
            case 1: {
                return (sArray[1] & 0x800) != 0;
            }
            case 4: {
                return (sArray[2] & 0x2000) != 0;
            }
            case 9: {
                return (sArray[13] & 0x1000) != 0;
            }
            case 16: {
                return (sArray[4] & 0x1000) != 0;
            }
            case 17: {
                return (sArray[4] & 0x4000) != 0;
            }
            case 18: {
                return (sArray[4] & 0x800) != 0;
            }
            case 19: {
                return (sArray[2] & 0x1000) != 0;
            }
            case 20: {
                return (sArray[2] & 0x4000) != 0;
            }
            case 21: {
                return (sArray[2] & 0x800) != 0;
            }
            case 31: {
                return (sArray[7] & 0x1000) != 0;
            }
        }
        AppEngine.ASSERT(this.d_questGiveItem[n] != -1, "invalid quest items");
        return this.getInventoryCount(this.d_questGiveItem[n]) > 0;
    }

    private void initSims() {
        if (this.d_simTraits[0].length != 5) {
            this.d_simTraits[0] = new byte[5];
            AppEngine.fillArray(this.d_simTraits[0], -1);
        }
    }

    public int getSimCount() {
        return this.d_numSims;
    }

    public int getSimName(int n) {
        return this.d_simNameStrings[n];
    }

    public int getSimPartner(int n) {
        return this.d_simPartners[n];
    }

    public int getSimMacromapColor(int n) {
        return this.d_simMacromapColors[n];
    }

    public int getSimAttribute(int n, int n2) {
        return this.d_simAttributes[n][n2];
    }

    public int getSimHome(int n) {
        if (this.getSimCurRelStateFlags(n, 2)) {
            return 0;
        }
        return this.d_simHomes[n];
    }

    public int getSimCareer(int n) {
        if (n == 10 && this.m_engine.isBonusUnlocked()) {
            return 4;
        }
        return this.d_simCareers[n];
    }

    public int getSimCareerLevel(int n) {
        if (n == 10 && this.m_engine.isBonusUnlocked()) {
            return this.d_careerLevelDescStrings[4].length - 1;
        }
        return this.d_simCareerLevels[n];
    }

    public int getPresetCount() {
        return this.d_numPresets;
    }

    public byte[] getAttributePreset(int n) {
        return this.d_simPresets[n];
    }

    public void setPlayerSimAttribute(int n, int n2) {
        this.d_simAttributes[0][n] = (byte)n2;
    }

    public boolean hasSimGotFlag(int n, int n2) {
        return (this.d_simFlags[n] & n2) != 0;
    }

    public int hasSimGotTrait(int n, int n2) {
        return AppEngine.indexOf(n2, this.d_simTraits[n]);
    }

    public boolean isTraitDiscovered(int n, int n2) {
        int n3 = this.hasSimGotTrait(n, n2);
        if (n3 != -1) {
            return this.m_knownTraits[n][n3] >= 3;
        }
        return false;
    }

    public boolean tryDiscoverTrait(int n, int n2) {
        byte[] byArray = this.m_knownTraits[n];
        int n3 = this.hasSimGotTrait(n, n2);
        if (byArray[n3] < 3) {
            int n4 = n3;
            byArray[n4] = (byte)(byArray[n4] + 1);
            if (byArray[n3] == 3) {
                int n5 = this.getSimName(n);
                short s = this.d_traitDescStrings[n2];
                this.m_engine.dynamicString(-12, 419, n5, s);
                this.m_engine.getSceneGame().showTickerMessage(-12, -1);
                return true;
            }
        }
        return false;
    }

    public int getSimTraitCount(int n) {
        return this.d_simTraits[n].length;
    }

    public int getSimTrait(int n, int n2) {
        return this.d_simTraits[n][n2];
    }

    public int getNumPlayerTraits() {
        byte[] byArray = this.d_simTraits[0];
        return byArray.length - AppEngine.countOf(-1, byArray);
    }

    public void traitPlayerAdd(int n) {
        if (this.hasSimGotTrait(0, n) == -1) {
            int n2;
            short s = this.d_traitExcludes[n];
            if (s != -1) {
                this.traitPlayerRemove(s);
            }
            if ((n2 = this.hasSimGotTrait(0, -1)) != -1) {
                this.d_simTraits[0][n2] = (byte)n;
            }
        }
    }

    public void traitPlayerRemove(int n) {
        int n2 = this.hasSimGotTrait(0, n);
        if (n2 != -1) {
            this.d_simTraits[0][n2] = -1;
        }
    }

    public int getSimByName(int n) {
        return AppEngine.indexOf(n, this.d_simNameStrings, 1);
    }

    public boolean acceptInvitation(int n) {
        byte by = this.m_currentRelStates[n];
        return by != 2 && by != 3 && by != 4 && (this.getTimeFlags(n) & 0x10) == 0 && (this.getTimeFlags(n) & 8) != 0;
    }

    public void update(int n) {
        this.updateGameTime(n);
        this.updateCareer(n);
        if (!this.isDelayed()) {
            this.updateMotives(n);
            this.updateBuffs(n);
        }
        if (!this.isDelayed()) {
            this.updateRelationships(n);
        }
        if (!this.isDelayed()) {
            this.updateDreams(n);
        }
        if (this.isDelayed()) {
            this.m_timeoutDelay = Math.max(this.m_timeoutDelay - n, 0);
        }
    }

    public void newScene() {
        this.setFastforward(false);
        this.setLastNPC(-1);
        AppEngine.fillArray(this.m_motiveDecayAdjustsF, 0);
        for (int i = 1; i < this.d_numSims; ++i) {
            this.unsetSimCurRelStateFlags(i, 1);
            AppEngine.fillArray(this.m_commodityLevelsF[i], 0);
            AppEngine.fillArray(this.m_actionHistories[i], -1);
        }
        this.unsetSimCurRelStateFlags(0, 1);
        this.delayAlerts();
    }

    public void delayAlerts() {
        this.m_timeoutDelay = 2500;
    }

    public boolean isDelayed() {
        return this.m_timeoutDelay != 0;
    }

    public void newGame() {
        int n = this.getTaskCount();
        int n2 = this.getPersonaFlags();
        for (int i = 0; i < n; ++i) {
            if ((this.getTaskFlags(i) & n2) == 0) continue;
            this.m_engine.setGoalDiscovered(i);
        }
        this.setQuickLinkVisited(100);
    }

    private void initObjectValues() {
        if (this.m_objectStateIds == null) {
            this.m_objectStateIds = new short[100];
            this.m_objectStateValues = new int[100];
            this.m_objectStateTimes = new int[100];
        }
        AppEngine.fillArray(this.m_objectStateIds, -1);
        AppEngine.fillArray(this.m_objectStateValues, 0);
        AppEngine.fillArray(this.m_objectStateTimes, 0);
    }

    public void saveObjectValue(int n, int n2, int n3) {
        AppEngine.ASSERT(n2 >= 0, "invalid id");
        int n4 = n << 8 | n2;
        int n5 = AppEngine.indexOf(n4, this.m_objectStateIds);
        if (n3 == 0 && n5 != -1) {
            this.removeObjectValue(n, n2);
        } else {
            if (n5 == -1) {
                n5 = AppEngine.indexOf(-1, this.m_objectStateIds);
                AppEngine.ASSERT(n5 != -1, "no room in persistant object data");
            }
            this.m_objectStateIds[n5] = (short)n4;
            this.m_objectStateValues[n5] = n3;
            this.m_objectStateTimes[n5] = this.getGameTimeAbs();
        }
    }

    public int getObjectValue(int n, int n2) {
        AppEngine.ASSERT(n2 >= 0, "invalid id");
        int n3 = n << 8 | n2;
        int n4 = AppEngine.indexOf(n3, this.m_objectStateIds);
        if (n4 == -1) {
            return 0;
        }
        return this.m_objectStateValues[n4];
    }

    public int getObjectValueTime(int n, int n2) {
        AppEngine.ASSERT(n2 >= 0, "invalid id");
        int n3 = n << 8 | n2;
        int n4 = AppEngine.indexOf(n3, this.m_objectStateIds);
        if (n4 == -1) {
            return -1;
        }
        return this.m_objectStateTimes[n4];
    }

    public void removeObjectValue(int n, int n2) {
        int n3 = n << 8 | n2;
        int n4 = AppEngine.indexOf(n3, this.m_objectStateIds);
        if (n4 != -1) {
            this.m_objectStateIds[n4] = -1;
            this.m_objectStateValues[n4] = 0;
            this.m_objectStateTimes[n4] = 0;
        }
    }

    public void resetRMSGameData() {
        this.initGameTimeMoney();
        this.initInventory();
        this.initSkills();
        this.initCareer();
        this.m_persona = (byte)-1;
        AppEngine.fillArray(this.d_simTraits[0], -1);
        this.initDreams();
        this.initMotives();
        this.initBuffs();
        this.initMoods();
        this.initQuests();
        this.initSims();
        this.initRelationships();
        this.initObjectValues();
        AppEngine.fillArray(this.d_simAttributes[0], 0);
    }

    public void loadRMSGameData(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        for (int i = 0; i < 10; ++i) {
            this.d_simAttributes[0][i] = dataInputStream.readByte();
        }
        byte[] byArray = this.d_simTraits[0];
        for (n2 = 0; n2 < 5; ++n2) {
            byArray[n2] = dataInputStream.readByte();
        }
        this.m_timeTimer = dataInputStream.readInt();
        this.m_timeTotal = dataInputStream.readInt();
        this.m_money = dataInputStream.readInt();
        this.m_moneySpent = dataInputStream.readInt();
        this.m_furnitureStage = dataInputStream.readByte();
        this.m_houseUpgradeDay = dataInputStream.readShort();
        for (n2 = 0; n2 < this.m_inventory.length; ++n2) {
            this.m_inventory[n2] = dataInputStream.readByte();
        }
        for (n2 = 0; n2 < this.m_skillLevelsF.length; ++n2) {
            this.m_skillLevelsF[n2] = dataInputStream.readInt();
        }
        this.d_simCareers[0] = dataInputStream.readByte();
        this.d_simCareerLevels[0] = dataInputStream.readByte();
        this.m_careerAcceptDay = dataInputStream.readByte();
        this.m_careerDaysWorked = dataInputStream.readShort();
        this.m_careerDaysMissed = dataInputStream.readShort();
        for (n2 = 0; n2 < this.m_careerLevelsAttained.length; ++n2) {
            this.m_careerLevelsAttained[n2] = dataInputStream.readByte();
        }
        this.m_phoneCareer = dataInputStream.readByte();
        this.m_phoneCareerTimer = dataInputStream.readInt();
        this.m_persona = dataInputStream.readByte();
        this.m_dream = dataInputStream.readByte();
        this.m_dreamLGCSeed = dataInputStream.readShort();
        this.m_dreamTimer = dataInputStream.readInt();
        for (n2 = 0; n2 < this.m_promises.length; ++n2) {
            this.m_promises[n2] = dataInputStream.readByte();
        }
        this.m_personaGoalsCompleted = dataInputStream.readInt();
        this.m_achievements = dataInputStream.readInt();
        for (n2 = 0; n2 < this.m_timeRanges.length; ++n2) {
            this.m_timeRanges[n2] = dataInputStream.readInt();
        }
        this.m_dreamFishCount = dataInputStream.readShort();
        this.m_dreamHarvestCount = dataInputStream.readShort();
        for (n2 = 0; n2 < this.m_woohooTimes.length; ++n2) {
            this.m_woohooTimes[n2] = dataInputStream.readInt();
        }
        this.m_quickLinkFlags = dataInputStream.readInt();
        for (n2 = 0; n2 < this.m_motiveLevelsF.length; ++n2) {
            this.m_motiveLevelsF[n2] = dataInputStream.readInt();
        }
        for (n2 = 0; n2 < 6; ++n2) {
            this.m_buffsActive[n2] = dataInputStream.readShort();
            this.m_buffTimers[n2] = dataInputStream.readInt();
        }
        this.applyBuffsToMood();
        n2 = this.d_numSims;
        for (n = 1; n < n2; ++n) {
            this.m_currentRelStates[n] = dataInputStream.readByte();
            this.m_currentRelStateFlags[n] = dataInputStream.readShort();
            int[] nArray = this.m_currentRelLevelsF[n];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = dataInputStream.readInt();
            }
            byte[] byArray2 = this.m_knownTraits[n];
            for (int i = 0; i < byArray2.length; ++i) {
                byArray2[i] = dataInputStream.readByte();
            }
        }
        for (n = 0; n < 100; ++n) {
            this.m_objectStateIds[n] = dataInputStream.readShort();
            this.m_objectStateValues[n] = dataInputStream.readInt();
            this.m_objectStateTimes[n] = dataInputStream.readInt();
        }
        for (n = 0; n < this.m_questSims.length; ++n) {
            this.m_questSims[n] = dataInputStream.readByte();
            this.m_questTimes[n] = dataInputStream.readInt();
        }
    }

    public void saveRMSGameData(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        for (int i = 0; i < 10; ++i) {
            dataOutputStream.writeByte(this.d_simAttributes[0][i]);
        }
        byte[] byArray = this.d_simTraits[0];
        for (n2 = 0; n2 < 5; ++n2) {
            dataOutputStream.writeByte(byArray[n2]);
        }
        dataOutputStream.writeInt(this.m_timeTimer);
        dataOutputStream.writeInt(this.m_timeTotal);
        dataOutputStream.writeInt(this.m_money);
        dataOutputStream.writeInt(this.m_moneySpent);
        dataOutputStream.writeByte(this.m_furnitureStage);
        dataOutputStream.writeShort(this.m_houseUpgradeDay);
        for (n2 = 0; n2 < this.m_inventory.length; ++n2) {
            dataOutputStream.writeByte(this.m_inventory[n2]);
        }
        for (n2 = 0; n2 < this.m_skillLevelsF.length; ++n2) {
            dataOutputStream.writeInt(this.m_skillLevelsF[n2]);
        }
        dataOutputStream.writeByte(this.d_simCareers[0]);
        dataOutputStream.writeByte(this.d_simCareerLevels[0]);
        dataOutputStream.writeByte(this.m_careerAcceptDay);
        dataOutputStream.writeShort(this.m_careerDaysWorked);
        dataOutputStream.writeShort(this.m_careerDaysMissed);
        for (n2 = 0; n2 < this.m_careerLevelsAttained.length; ++n2) {
            dataOutputStream.writeByte(this.m_careerLevelsAttained[n2]);
        }
        dataOutputStream.writeByte(this.m_phoneCareer);
        dataOutputStream.writeInt(this.m_phoneCareerTimer);
        dataOutputStream.writeByte(this.m_persona);
        dataOutputStream.writeByte(this.m_dream);
        dataOutputStream.writeShort(this.m_dreamLGCSeed);
        dataOutputStream.writeInt(this.m_dreamTimer);
        for (n2 = 0; n2 < this.m_promises.length; ++n2) {
            dataOutputStream.writeByte(this.m_promises[n2]);
        }
        dataOutputStream.writeInt(this.m_personaGoalsCompleted);
        dataOutputStream.writeInt(this.m_achievements);
        for (n2 = 0; n2 < this.m_timeRanges.length; ++n2) {
            dataOutputStream.writeInt(this.m_timeRanges[n2]);
        }
        dataOutputStream.writeShort(this.m_dreamFishCount);
        dataOutputStream.writeShort(this.m_dreamHarvestCount);
        for (n2 = 0; n2 < this.m_woohooTimes.length; ++n2) {
            dataOutputStream.writeInt(this.m_woohooTimes[n2]);
        }
        dataOutputStream.writeInt(this.m_quickLinkFlags);
        for (n2 = 0; n2 < this.m_motiveLevelsF.length; ++n2) {
            dataOutputStream.writeInt(this.m_motiveLevelsF[n2]);
        }
        for (n2 = 0; n2 < 6; ++n2) {
            dataOutputStream.writeShort(this.m_buffsActive[n2]);
            dataOutputStream.writeInt(this.m_buffTimers[n2]);
        }
        n2 = this.d_numSims;
        for (n = 1; n < n2; ++n) {
            dataOutputStream.writeByte(this.m_currentRelStates[n]);
            dataOutputStream.writeShort(this.m_currentRelStateFlags[n]);
            int[] nArray = this.m_currentRelLevelsF[n];
            for (int i = 0; i < nArray.length; ++i) {
                dataOutputStream.writeInt(nArray[i]);
            }
            byte[] byArray2 = this.m_knownTraits[n];
            for (int i = 0; i < byArray2.length; ++i) {
                dataOutputStream.writeByte(byArray2[i]);
            }
        }
        for (n = 0; n < 100; ++n) {
            dataOutputStream.writeShort(this.m_objectStateIds[n]);
            dataOutputStream.writeInt(this.m_objectStateValues[n]);
            dataOutputStream.writeInt(this.m_objectStateTimes[n]);
        }
        for (n = 0; n < this.m_questSims.length; ++n) {
            dataOutputStream.writeByte(this.m_questSims[n]);
            dataOutputStream.writeInt(this.m_questTimes[n]);
        }
    }

    public void cheatMenuHook(int n) {
        int n2 = this.m_lastNPC;
        int[] nArray = this.m_skillLevelsF;
        switch (n) {
            case 0: {
                this.updateGameTime(60000);
                break;
            }
            case 1: {
                this.updateGameTime(1440000);
                break;
            }
            case 2: {
                int n3 = 0x320000;
                for (int i = 0; i < this.m_motiveLevelsF.length; ++i) {
                    this.m_motiveLevelsF[i] = n3;
                }
                break;
            }
            case 12: {
                for (int i = 1; i < this.d_numSims; ++i) {
                    if (this.m_currentRelStates[i] != 0) continue;
                    this.relationshipStateTransition(i, 5);
                }
                break;
            }
            case 3: {
                this.relationshipStateTransition(n2, 5);
                break;
            }
            case 4: {
                this.relationshipStateTransition(n2, 2);
                break;
            }
            case 5: {
                this.relationshipStateTransition(n2, 8);
                break;
            }
            case 6: {
                this.relationshipStateTransition(n2, 6);
                break;
            }
            case 7: {
                this.relationshipStateTransition(n2, 3);
                break;
            }
            case 8: {
                this.relationshipStateTransition(n2, 9);
                break;
            }
            case 9: {
                this.relationshipStateTransition(n2, 7);
                break;
            }
            case 10: {
                this.relationshipStateTransition(n2, 4);
                break;
            }
            case 11: {
                this.relationshipStateTransition(n2, 10);
                break;
            }
            case 14: {
                nArray[0] = Math.min(nArray[0] + 65536, 327680);
                break;
            }
            case 13: {
                nArray[0] = Math.max(nArray[0] - 65536, 0);
                nArray[0] = 327675;
                break;
            }
            case 16: {
                nArray[1] = Math.min(nArray[1] + 65536, 327680);
                break;
            }
            case 15: {
                nArray[1] = Math.max(nArray[1] - 65536, 0);
                nArray[1] = 327675;
                break;
            }
            case 18: {
                nArray[2] = Math.min(nArray[2] + 65536, 327680);
                break;
            }
            case 17: {
                nArray[2] = Math.max(nArray[2] - 65536, 0);
                nArray[2] = 327675;
                break;
            }
            case 20: {
                nArray[3] = Math.min(nArray[3] + 65536, 327680);
                break;
            }
            case 19: {
                nArray[3] = Math.max(nArray[3] - 65536, 0);
                nArray[3] = 327675;
                break;
            }
            case 22: {
                nArray[4] = Math.min(nArray[4] + 65536, 327680);
                break;
            }
            case 21: {
                nArray[4] = Math.max(nArray[4] - 65536, 0);
                nArray[4] = 327675;
                break;
            }
            case 23: {
                this.m_dream = (byte)this.dreamNew();
                this.m_dreamTimer = 0;
                break;
            }
            case 24: {
                for (int i = 0; i < this.d_dreamDescStrings.length; ++i) {
                    this.m_engine.setGoalDiscovered(i);
                    this.m_engine.setGoalCompleted(i);
                }
                this.m_engine.unlockBonus();
                break;
            }
            case 25: {
                for (int i = 0; i < this.m_inventory.length; ++i) {
                    this.m_inventory[i] = (byte)this.m_engine.getSimWorld().getItemMaxInventory(i);
                }
                break;
            }
        }
    }
}

