/*
 * Decompiled with CFR 0.152.
 */
package generic;

public abstract class MathExt {
    private static int[] s_temp2DVec1 = new int[2];
    private static final int[] Facos_neg_percalc = new int[]{205525, 205375, 205260, 205163, 205077};
    private static final int[] Facos_pos_percalc = new int[]{270, 512, 627, 724, 809};
    private static final int[] Fsqrt_smallest_precalced = new int[]{0, 256, 362, 443, 512, 572, 627, 677, 724, 768, 810, 849, 887, 923, 958, 991, 1024, 1056, 1086, 1116, 1145, 1173, 1201, 1227, 1254, 1280, 1305, 1330, 1355, 1378, 1402, 1425, 1448, 1471, 1493, 1515, 1536, 1557, 1578, 1599, 1619, 1639, 1659, 1679, 1698, 1717, 1736, 1755};
    private static final int FSQRT_NUM_PRECALCED = Fsqrt_smallest_precalced.length;
    private static final int FSQRT_LOWER_SCALE_LIMIT = Fsqrt_smallest_precalced[FSQRT_NUM_PRECALCED - 1];

    private MathExt() {
    }

    public static final int sign(int n) {
        return n > 0 ? 1 : (n < 0 ? -1 : 0);
    }

    public static final int clip(int n, int n2, int n3) {
        return Math.max(n2, Math.min(n3, n));
    }

    public static final int Fmul(int n, int n2) {
        return (int)((long)n * (long)n2 >> 16);
    }

    public static final int Fdiv(int n, int n2) {
        return (int)(((long)n << 16) / (long)n2);
    }

    public static final int Fmag2(int n, int n2) {
        long l = n;
        long l2 = n2;
        return MathExt.Fsqrt((int)(l * l + l2 * l2 >> 16));
    }

    public static final int normaliseAngleRadiansF(int n) {
        if (n > 205887) {
            n -= Math.max(1, n / 411775) * 411775;
        } else if (n < -205887) {
            n += Math.max(1, -n / 411775) * 411775;
        }
        return n;
    }

    public static final int Fcos(int n) {
        int n2 = n >= 0 ? 1 : -1;
        int n3 = MathExt.Fmul(n2 * n << 1, 20861) & 0x3FFFF;
        int n4 = n3 >> 16 & 3;
        n3 &= 0xFFFF;
        n2 = 1;
        if ((n4 & 1) != 0) {
            n2 = -n2;
            n3 = 65536 - n3;
        }
        if ((n4 & 2) != 0) {
            n2 = -n2;
        }
        n3 = MathExt.Fmul(n3, 205887) >> 1;
        int n5 = 262144;
        int n6 = MathExt.Fmul(n3, n3);
        int n7 = n6 << 1;
        n5 -= n7;
        n7 = MathExt.Fmul(MathExt.Fmul(n6, n7), 5461);
        n5 += n7;
        n7 = MathExt.Fmul(MathExt.Fmul(n6, n7), 2185);
        n5 -= n7;
        n7 = MathExt.Fmul(MathExt.Fmul(n6, n7), 1170);
        return (n5 += n7) * n2 >> 2;
    }

    public static final int Facos(int n) {
        if (n <= -65536) {
            return 205887;
        }
        if (65535 + n < Facos_neg_percalc.length) {
            return Facos_neg_percalc[65535 + n];
        }
        if (n >= 65536) {
            return 0;
        }
        if (65535 - n < Facos_pos_percalc.length) {
            return Facos_pos_percalc[65535 - n];
        }
        long l = (long)n * (long)n;
        if (n > 46661) {
            return 102944 - MathExt.Facos(MathExt.Fsqrt((int)(0x100000000L - l + 32768L >> 16)));
        }
        if (n < -46661) {
            return 102944 + MathExt.Facos(MathExt.Fsqrt((int)(0x100000000L - l + 32768L >> 16)));
        }
        int n2 = (int)(l + 32768L >> 16);
        int n3 = n;
        int n4 = -n3;
        n3 = MathExt.Fmul(n3, n2);
        n4 -= MathExt.Fmul(10923, n3);
        n3 = MathExt.Fmul(n3, n2);
        n4 -= MathExt.Fmul(4915, n3);
        n3 = MathExt.Fmul(n3, n2);
        return 102944 + (n4 -= MathExt.Fmul(2926, n3));
    }

    public static final int Fsin(int n) {
        return MathExt.Fcos(n - 102944);
    }

    public static final int Fatan2(int n, int n2) {
        if (n == 0) {
            if (n2 < 0) {
                return 205887;
            }
            return 0;
        }
        if (n2 == 0) {
            if (n < 0) {
                return -102944;
            }
            return 102944;
        }
        int n3 = MathExt.Fmag2(n, n2);
        int n4 = n2 < 0 ? -n2 : n2;
        int n5 = n3 > 0 ? MathExt.Fdiv(n4, n3) : n4;
        int n6 = MathExt.Facos(n5);
        if (n < 0 && n2 < 0) {
            n6 -= 205887;
        } else if (n < 0 && n2 > 0) {
            n6 = -n6;
        } else if (n > 0 && n2 < 0) {
            n6 = 205887 - n6;
        }
        return n6;
    }

    public static final int Fsqrt(int n) {
        int n2;
        if (n < 0) {
            return 0;
        }
        if (n < FSQRT_NUM_PRECALCED) {
            return Fsqrt_smallest_precalced[n];
        }
        int n3 = n;
        if (n < FSQRT_LOWER_SCALE_LIMIT) {
            n3 <<= 2;
        } else if (n > 0x400000) {
            n3 >>= 2;
        }
        if (n3 > 65200 && n3 < 65800) {
            n2 = n3 + 65536 >> 1;
        } else {
            int n4 = (n3 >> 3) + 131072;
            if (n4 > 0x800000) {
                n4 = 0x800000;
            }
            int n5 = FSQRT_LOWER_SCALE_LIMIT;
            n2 = n4 + n5 >> 1;
            for (int i = 0; i < 13; ++i) {
                int n6 = MathExt.Fmul(n2, n2);
                if (n6 > n3) {
                    n4 = n2;
                } else {
                    n5 = n2;
                }
                n2 = n4 + n5 >> 1;
            }
        }
        if (n < FSQRT_LOWER_SCALE_LIMIT) {
            n2 >>= 1;
        } else if (n > 0x400000) {
            n2 <<= 1;
        }
        return n2;
    }

    public static final int smoothstepF(int n, int n2, int n3) {
        if (n3 < n) {
            return 0;
        }
        if (n3 >= n2) {
            return 65536;
        }
        int n4 = n3 - n;
        int n5 = n2 - n;
        int n6 = MathExt.Fdiv(n4, n5);
        int n7 = MathExt.Fmul(n6, n6);
        return -2 * MathExt.Fmul(n7, n6) + 3 * n7;
    }
}

