/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.AppEngine;
import game.MapObject;
import game.SceneGame;
import game.SimData;
import game.SimWorld;
import generic.AnimPlayer;
import generic.AnimationManager;
import generic.MathExt;
import javax.microedition.lcdui.Graphics;

public final class MapObjectSim
extends MapObject {
    private int m_appearance;
    private int m_subAppearance;
    private int m_appearanceBank;
    private int m_simState;
    private int m_simStateTime;
    private int m_posture;
    private int m_targetPosture;
    private MapObject m_postureObject;
    private int m_simAction;
    private int m_simActionPhaseIndex;
    private int m_simPhase;
    private MapObject m_simActionArg1;
    private int m_simActionArg2;
    private int m_simActionArg3;
    private int m_queuedSimAction;
    private MapObject m_queuedSimActionArg1;
    private int m_queuedSimActionArg2;
    private int m_queuedSimActionArg3;
    private int m_needFlags;
    private int m_needCheckTimer;
    private MapObject m_occupiedObject;
    private int m_occupiedIndex;
    private int m_walkDestXF;
    private int m_walkDestZF;
    private int[] m_walkPath;
    private int m_walkPathPoint;
    private boolean m_walkStopShort;
    private int m_checkPosXF;
    private int m_checkPosZF;
    private int m_conversationSim;
    private int m_conversationTimer;
    private int m_lastConversationTimer;
    private int m_feedbackSubAppearance;
    private boolean m_feedbackLoop;
    private boolean m_feedbackRealTime;
    private int m_feedbackTime;
    private int m_feedbackFloaterAnimId;
    private boolean m_feedbackAnimateFloater;
    private int m_feedbackSpeechBubbleAnimId;
    private int callOverDirectionDir = -551;
    private static final int[] GENERIC_NEEDS = new int[]{4, 2, 8, 16, 64};

    public MapObjectSim(SceneGame sceneGame) {
        super(sceneGame);
    }

    public final void init(int n, int n2, int n3, int n4, int n5) {
        int n6;
        super.init(n, n2, n3, n4, n5);
        this.m_simState = 0;
        this.m_simStateTime = 0;
        this.m_posture = 0;
        this.m_targetPosture = 0;
        this.m_postureObject = null;
        this.m_simAction = 0;
        this.m_simActionPhaseIndex = 0;
        this.m_simPhase = 0;
        this.m_simActionArg1 = null;
        this.m_simActionArg2 = 0;
        this.m_simActionArg3 = 0;
        this.m_queuedSimAction = -1;
        this.m_queuedSimActionArg1 = null;
        this.m_queuedSimActionArg2 = 0;
        this.m_queuedSimActionArg3 = 0;
        this.m_needFlags = 0;
        this.m_needCheckTimer = 0;
        this.m_occupiedObject = null;
        this.m_occupiedIndex = -1;
        this.m_walkDestXF = this.getPosX();
        this.m_walkDestZF = this.getPosZ();
        this.m_walkPath = null;
        this.m_walkPathPoint = 0;
        this.m_walkStopShort = false;
        this.m_checkPosXF = 0;
        this.m_checkPosZF = 0;
        this.m_conversationSim = -1;
        this.m_conversationTimer = 0;
        this.m_lastConversationTimer = -1;
        this.m_feedbackSubAppearance = -1;
        this.m_feedbackLoop = true;
        this.m_feedbackTime = 0;
        this.m_feedbackAnimateFloater = false;
        this.m_feedbackSpeechBubbleAnimId = -1;
        this.getAnimPlayerCreate(2);
        this.getAnimPlayerCreate(1);
        this.m_appearance = -1;
        this.m_subAppearance = 0;
        SimData simData = this.getSimData();
        if (this.m_scene.isMapMode()) {
            this.m_appearanceBank = simData.getSimMacromapColor(n5);
            this.setAppearance(2);
        } else {
            int n7 = n6 = simData.getSimAttribute(n5, 0) == 0 ? 1 : 0;
            if (n6 != 0) {
                this.setAppearance(0);
            } else {
                this.setAppearance(1);
            }
            this.m_appearanceBank = -1;
        }
        if (n5 == 0) {
            for (n6 = 0; n6 < 6; ++n6) {
                int n8 = simData.getBuff(n6);
                if (n8 == -1) continue;
                this.startBuff(n8);
            }
        }
        this.simStateTransition(1);
    }

    public final void update(int n) {
        if (this.m_simStateTime < 3000000) {
            this.m_simStateTime += n;
        }
        if (this.m_conversationSim != -1) {
            this.m_conversationTimer += n;
            if (this.m_conversationTimer > 20000) {
                this.m_scene.DEBUG_EVENT("conversation timed out");
                this.clearConversation();
            }
        } else if (this.m_lastConversationTimer >= 0) {
            this.m_lastConversationTimer += n;
            if (this.m_lastConversationTimer > 20000) {
                this.m_lastConversationTimer = -1;
            }
        }
        switch (this.m_simState) {
            case 1: {
                this.simUpdateIdle(n);
                break;
            }
            case 2: {
                this.simUpdateChangePosture(n);
                break;
            }
            case 3: {
                this.simUpdateWalking(n);
                break;
            }
            case 4: {
                this.simUpdateFeedback(n);
                break;
            }
            case 5: {
                this.simUpdateGetAttention(n);
                break;
            }
            case 6: {
                this.simUpdateGetOccupied(n);
                break;
            }
            case 7: {
                this.simUpdateListen(n);
                break;
            }
            case 8: {
                this.simUpdateHide(n);
            }
        }
    }

    public final void render2D(Graphics graphics) {
        if (this.m_simState == 8 || this.m_appearanceBank == -1) {
            return;
        }
        SimWorld simWorld = this.getSimWorld();
        int n = simWorld.getCameraPixelX();
        int n2 = simWorld.getCameraPixelY();
        int n3 = n + simWorld.coordWorldToScreenPixelsX(this.getPosX(), this.getPosZ());
        int n4 = n2 + simWorld.coordWorldToScreenPixelsY(this.getPosX(), this.getPosZ());
        AnimPlayer animPlayer = null;
        if (this.m_subAppearance != 50) {
            if (!(this.m_scene.isMapMode() || this.m_scene.isShowingEvent() || this.m_targetPosture != 0 && this.m_targetPosture != 6)) {
                AnimationManager.drawAnimFrame(graphics, 34, 0, n3, n4);
            }
            AnimationManager.setBank(this.m_appearanceBank);
            animPlayer = this.getAnimPlayer(0);
            if (!this.m_scene.isMapMode()) {
                int n5 = animPlayer.getAnimID();
                int n6 = animPlayer.getCurrAnimFrame();
                this.drawSimAnim(graphics, n5, n6, n3, n4);
            } else {
                animPlayer.drawAnim(graphics, n3, n4);
                if (this.getId() == 0) {
                    this.m_scene.renderPlayerGem(graphics, n3, n4 - 16);
                }
            }
            if (this.getSimActionArg1Sim() != null && this.getSimActionArg1Sim().getPostureObject() == null) {
                this.getSimActionArg1Sim().render2DPost(graphics);
            }
            AnimationManager.setBank(0);
        }
        AnimPlayer animPlayer2 = this.getAnimPlayer(2);
        if (this.m_feedbackTime > 0 && animPlayer2.isAnimating()) {
            int[] nArray = MapObject.s_tempInt10;
            int n7 = this.m_feedbackAnimateFloater ? MathExt.smoothstepF(1000, 2000, this.m_feedbackTime) : 65536;
            int n8 = n7 * 10;
            int n9 = n3;
            int n10 = n4 + (n8 >> 16) - 60 - 10;
            AnimationManager.drawAnim(graphics, animPlayer2, n9, n10);
            if (this.m_simPhase == 5) {
                animPlayer2.getFirePointCurrFrame(nArray, 0);
                AnimationManager.drawAnimFrame(graphics, this.m_feedbackSpeechBubbleAnimId, 0, n9 + nArray[0], n10 + nArray[1]);
            }
        }
    }

    public final void render2DPost(Graphics graphics) {
        int n;
        SimWorld simWorld = this.getSimWorld();
        int n2 = simWorld.getSubAppearanceAnimSet(this.m_appearance, this.m_subAppearance, true);
        if (n2 != 0 && (n = simWorld.getAnim(n2, this.getFacingDir())) != 203) {
            int n3 = simWorld.getCameraPixelX();
            int n4 = simWorld.getCameraPixelY();
            int n5 = n3;
            int n6 = n4;
            if (this.m_subAppearance == 50) {
                int[] nArray = MapObject.s_tempInt10;
                this.m_simActionArg1.getBathSimPos(nArray);
                n5 += nArray[0];
                n6 += nArray[1];
            } else {
                n5 += simWorld.coordWorldToScreenPixelsX(this.getPosX(), this.getPosZ());
                n6 += simWorld.coordWorldToScreenPixelsY(this.getPosX(), this.getPosZ());
            }
            int n7 = this.getAnimPlayer(0).getCurrAnimFrame();
            AnimationManager.setBank(this.m_appearanceBank);
            this.drawSimAnim(graphics, n, n7, n5, n6);
            AnimationManager.setBank(0);
        }
    }

    private void drawSimAnim(Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl;
        int n5 = this.m_appearance == 0 ? 499 : 392;
        int n6 = this.getSimData().getSimAttribute(this.getId(), 2) + 1;
        int[] nArray = null;
        boolean bl2 = bl = this.getId() == 0;
        if (bl) {
            nArray = MapObject.s_tempInt10;
        }
        boolean bl3 = AnimationManager.drawAnimFrameExt(graphics, n, n2, n3, n4, n5, n6, nArray);
        if (bl && bl3) {
            this.m_scene.renderPlayerGem(graphics, nArray[0], nArray[1]);
        }
    }

    public final int getTooltipStringId() {
        return this.getSimData().getSimName(this.getId());
    }

    private final void setAppearance(int n) {
        if (this.m_appearance != n) {
            this.m_appearance = n;
            int n2 = this.m_subAppearance;
            this.m_subAppearance = -1;
            this.setSubAppearance(n2);
        }
    }

    public final void setSubAppearance(int n) {
        boolean bl = this.getFacingDir() == 0 || this.getFacingDir() == 1;
        n = this.getSimWorld().mapSubAppearance(n, bl);
        if (this.m_subAppearance != n) {
            this.m_subAppearance = n;
            int n2 = this.getSimWorld().getSubAppearanceAnimSet(this.m_appearance, n, false);
            this.setAnimSet(n2);
        }
    }

    public final void setBank(int n) {
        this.m_appearanceBank = n;
    }

    public final int getBank() {
        return this.m_appearanceBank;
    }

    private final void simStateTransition(int n) {
        if (n == 1 && this.m_simState == 4 && this.m_posture == 2 && this.getId() == 0 && this.callOverDirectionDir != -551) {
            this.setFacingDir(this.callOverDirectionDir);
        }
        SceneGame sceneGame = this.m_scene;
        switch (this.m_simState) {
            case 3: {
                this.callOverDirectionDir = -551;
                if (n == 3 || !sceneGame.isMapMode()) break;
                this.setAppearance(2);
                if (sceneGame.getCameraFollow() != this) break;
                sceneGame.setCameraFollow(null);
                break;
            }
            case 2: {
                if (this.m_postureObject == null || this.m_posture != 0) break;
                this.m_postureObject.releasePostRenderTarget(this);
                this.m_postureObject = null;
            }
        }
        this.setRuntimeFlag(128);
        int n2 = this.m_simState;
        this.m_simState = n;
        this.m_simStateTime = 0;
        switch (n) {
            case 1: {
                int n3 = this.m_posture == 4 ? 15 : (this.m_posture == 5 ? 54 : (this.m_posture == 1 ? 19 : (this.m_posture == 2 ? 19 : (this.m_posture == 3 ? 28 : (this.m_posture == 6 ? 43 : (this.m_posture == 7 ? 36 : 0))))));
                this.setSubAppearance(n3);
                break;
            }
            case 2: {
                int n4 = -1;
                int n5 = this.m_posture;
                MapObject mapObject = this.m_simActionArg1;
                switch (this.m_posture) {
                    default: {
                        AppEngine.ASSERT(false, "invalid current posture");
                    }
                    case 0: {
                        if (this.m_targetPosture == 7) {
                            n4 = 34;
                            n5 = 7;
                            this.m_postureObject = mapObject;
                            mapObject.phonePickup();
                            break;
                        }
                        if (this.m_targetPosture == 3) {
                            n4 = 27;
                            n5 = 3;
                            break;
                        }
                        if (this.m_targetPosture == 1 || this.m_targetPosture == 4 || this.m_targetPosture == 5) {
                            this.m_postureObject = mapObject;
                            mapObject.setPostRenderTarget(this);
                            n4 = 20;
                            n5 = 1;
                            break;
                        }
                        if (this.m_targetPosture == 6) {
                            n4 = 44;
                            n5 = 6;
                            break;
                        }
                        AppEngine.ASSERT(mapObject != null, "sitting without a chair");
                        mapObject.setPostRenderTarget(this);
                        this.m_postureObject = mapObject;
                        int n6 = 0;
                        int n7 = 0;
                        switch (this.getFacingDir()) {
                            default: {
                                AppEngine.ASSERT(false, "invalid sim facing");
                            }
                            case 0: {
                                n6 = 524288;
                                break;
                            }
                            case 1: {
                                n7 = 524288;
                                break;
                            }
                            case 2: {
                                n6 = -524288;
                                break;
                            }
                            case 3: {
                                n7 = -524288;
                            }
                        }
                        int n8 = mapObject.getFacingDir();
                        this.setFacingDir(n8);
                        int n9 = 0;
                        int n10 = 0;
                        switch (n8) {
                            default: {
                                AppEngine.ASSERT(false, "invalid chair facing");
                            }
                            case 0: {
                                n9 = -196608;
                                n6 += 131072;
                                break;
                            }
                            case 1: {
                                n10 = -196608;
                                n7 += 131072;
                                break;
                            }
                            case 2: {
                                n9 = 196608;
                                n6 -= 131072;
                                break;
                            }
                            case 3: {
                                n10 = 196608;
                                n7 -= 131072;
                            }
                        }
                        if (mapObject.chairShouldSnap()) {
                            mapObject.setPos(mapObject.getPosX() + n9, mapObject.getPosZ() + n10);
                            mapObject.setRuntimeFlag(131072);
                        } else {
                            n6 -= n9;
                            n7 -= n10;
                        }
                        this.setPos(this.getPosX() + n6, this.getPosZ() + n7);
                        n4 = 20;
                        n5 = 2;
                        break;
                    }
                    case 1: {
                        if (this.m_targetPosture == 0) {
                            n4 = 18;
                            n5 = 0;
                            break;
                        }
                        if (this.m_targetPosture == 4) {
                            n4 = 17;
                            n5 = 4;
                            break;
                        }
                        if (this.m_targetPosture != 5) break;
                        n4 = 53;
                        n5 = 5;
                        break;
                    }
                    case 2: {
                        n4 = 18;
                        n5 = 0;
                        break;
                    }
                    case 3: {
                        n4 = 30;
                        n5 = 0;
                        break;
                    }
                    case 4: {
                        n4 = 16;
                        n5 = 1;
                        break;
                    }
                    case 5: {
                        n4 = 55;
                        n5 = 1;
                        break;
                    }
                    case 6: {
                        n4 = 42;
                        n5 = 0;
                        break;
                    }
                    case 7: {
                        n4 = 35;
                        n5 = 0;
                        this.m_postureObject.phoneHangup();
                    }
                }
                AppEngine.ASSERT(n5 != this.m_posture, "invalid posture change");
                AppEngine.ASSERT(n4 != -1, "invalid posture transition appearance type");
                this.m_posture = n5;
                this.unsetRuntimeFlag(128);
                this.setSubAppearance(n4);
                break;
            }
            case 3: {
                AppEngine.ASSERT(this.m_posture == 0, "not standing but trying to walk!");
                this.setSubAppearance(1);
                if (this.getId() != 0 || !sceneGame.isMapMode() || this.isInView() || n2 == 3) break;
                sceneGame.setCameraFollow(this);
                break;
            }
            case 4: {
                SimData simData = this.getSimData();
                if (this.m_feedbackFloaterAnimId != -1) {
                    this.getAnimPlayer(2).startAnim(this.m_feedbackFloaterAnimId, 20);
                    if (this.m_simPhase == 5) {
                        this.m_feedbackSpeechBubbleAnimId = simData.getActionTalkIcon(this.m_simAction);
                    }
                } else {
                    this.getAnimPlayer(2).setAnimating(false);
                }
                if (this.m_feedbackSubAppearance == -1) {
                    this.m_feedbackSubAppearance = simData.getActionWorldArg(this.m_simAction);
                }
                MapObjectSim mapObjectSim = this.getSimActionArg1Sim();
                if (this.m_simAction == 84 || this.m_simAction == 85) {
                    if (simData.actionAccept(this.getId(), mapObjectSim.getId(), this.m_simAction)) {
                        mapObjectSim.unsetRuntimeFlag(128);
                        mapObjectSim.setSubAppearance(38);
                        this.m_feedbackSubAppearance = 41;
                    } else {
                        mapObjectSim.unsetRuntimeFlag(128);
                        mapObjectSim.setSubAppearance(40);
                        this.m_feedbackSubAppearance = 39;
                    }
                } else if (this.m_simAction == 95) {
                    mapObjectSim.unsetRuntimeFlag(128);
                    mapObjectSim.setSubAppearance(32);
                } else if (this.m_simAction == 86) {
                    int n11 = mapObjectSim.getId();
                    if (simData.actionAccept(this.getId(), n11, this.m_simAction)) {
                        sceneGame.triggerEvent(3, -1, n11);
                    }
                }
                if (!this.m_feedbackLoop) {
                    this.unsetRuntimeFlag(128);
                }
                this.setSubAppearance(this.m_feedbackSubAppearance);
                break;
            }
            case 5: 
            case 6: {
                this.setSubAppearance(0);
                break;
            }
            case 7: {
                this.setFacingObject(this.m_simActionArg1);
                int n12 = 7;
                if (this.getSimActionArg1Sim() != null && (this.getSimActionArg1Sim().getSimAction() == 84 || this.getSimActionArg1Sim().getSimAction() == 85)) {
                    n12 = 0;
                }
                this.setSubAppearance(n12);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                this.destroy();
            }
        }
        if (this.m_simState == 1 && this.m_posture == 2 && this.getId() == 0) {
            this.callOverDirectionDir = this.getFacingDir();
        }
    }

    private final void simFeedback(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.m_feedbackSubAppearance = n;
        this.m_feedbackLoop = n2 >= 0;
        this.m_feedbackTime = n2;
        this.m_feedbackFloaterAnimId = n3;
        this.m_feedbackAnimateFloater = bl;
        this.m_feedbackRealTime = bl2;
        this.simStateTransition(4);
    }

    private final void endFeedback() {
        this.m_feedbackSubAppearance = -1;
        this.m_feedbackLoop = false;
        this.m_feedbackTime = -1;
        this.m_feedbackFloaterAnimId = -1;
        this.m_feedbackAnimateFloater = false;
        this.m_feedbackRealTime = true;
    }

    private final void simHide(int n, boolean bl) {
        this.m_feedbackTime = n;
        this.m_feedbackRealTime = bl;
        this.simStateTransition(8);
    }

    private final void simUpdateIdle(int n) {
        MapObject mapObject;
        MapObject mapObject2;
        this.updateAnim(n);
        this.m_needCheckTimer += n;
        if (this.getType() == 0) {
            if (this.m_simStateTime > 3000 && this.getSimData().buffGetActiveSlot(10) != -1) {
                this.beginSimAction(3, null);
                return;
            }
            if (this.m_simStateTime > 3500 && this.m_posture == 0) {
                int n2 = this.getSimData().getMoodLevel();
                if (n2 > 0x4B0000) {
                    this.beginSimAction(5, null);
                    return;
                }
                if (n2 < -3276800) {
                    this.beginSimAction(6, null);
                    return;
                }
            }
        }
        if (this.m_posture == 1 && this.m_postureObject.getParentType() == 9 && (mapObject2 = this.m_scene.findRandomObjectByParentType(22)) != null && mapObject2.getRuntimeFlag(64) && this.m_simStateTime > 1000) {
            if (this.getId() == 0) {
                this.getSimData().dreamCompleteEvent(43);
            }
            int n3 = 16;
            if (mapObject2.getRuntimeFlag(32768)) {
                n3 = 15;
            }
            this.beginSimAction(n3, null);
            return;
        }
        if (this.m_posture == 0 && this.m_simStateTime > 5000 && (mapObject = this.m_scene.findRandomObjectByParentType(18)) != null && mapObject.getRuntimeFlag(64)) {
            SimWorld simWorld = this.getSimWorld();
            int n4 = simWorld.coordWorldToWorldTileX(mapObject.getPosX());
            int n5 = simWorld.coordWorldToWorldTileZ(mapObject.getPosZ());
            int n6 = simWorld.coordWorldToWorldTileX(this.getPosX());
            int n7 = simWorld.coordWorldToWorldTileZ(this.getPosZ());
            if (Math.abs(n6 - n4) + Math.abs(n7 - n5) < 8) {
                this.beginSimAction(17, null);
                return;
            }
        }
        if (this.m_needCheckTimer > 2500 && this.occupiedIsEmpty()) {
            this.m_needCheckTimer = 0;
            this.checkNeeds();
        }
    }

    public MapObject getPostureObject() {
        return this.m_postureObject;
    }

    private final void simUpdateChangePosture(int n) {
        this.updateAnim(n);
        if (!this.isAnimating()) {
            if (this.m_posture == 0 && this.m_postureObject != null && this.m_postureObject.getParentType() == 6) {
                int n2 = 131072;
                int n3 = 0;
                int n4 = 0;
                switch (this.getFacingDir()) {
                    default: {
                        AppEngine.ASSERT(false, "invalid facing, getting off chair");
                    }
                    case 0: {
                        n3 = 1;
                        break;
                    }
                    case 1: {
                        n4 = 1;
                        break;
                    }
                    case 2: {
                        n3 = -1;
                        break;
                    }
                    case 3: {
                        n4 = -1;
                    }
                }
                MapObject mapObject = this.m_postureObject;
                if (mapObject.getRuntimeFlag(131072)) {
                    mapObject.unsetRuntimeFlag(131072);
                    mapObject.setPos(mapObject.getPosX() + n3 * 196608, mapObject.getPosZ() + n4 * 196608);
                } else {
                    n2 += 196608;
                }
                SimWorld simWorld = this.getSimWorld();
                int n5 = this.getPosX() + n4 * 524288 + n3 * -n2;
                int n6 = this.getPosZ() + n3 * 524288 + n4 * -n2;
                boolean bl = simWorld.isWorldPointWalkable(n5, n6);
                int n7 = this.getPosX() + n4 * -524288 + n3 * -n2;
                int n8 = this.getPosZ() + n3 * -524288 + n4 * -n2;
                boolean bl2 = simWorld.isWorldPointWalkable(n7, n8);
                boolean bl3 = this.m_scene.isObjectAt(0, n7, n8);
                if (bl && (bl3 || !bl2)) {
                    this.setPos(n5, n6);
                } else {
                    this.setPos(n7, n8);
                }
            }
            if (this.m_posture == this.m_targetPosture) {
                this.endSimPhase();
            } else {
                this.simStateTransition(2);
            }
        }
    }

    private final void DEBUG_WALKING(String string) {
    }

    private final void simUpdateWalking(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        SimWorld simWorld = this.getSimWorld();
        int n6 = this.getPosX();
        int n7 = this.getPosZ();
        int n8 = this.m_walkDestXF;
        int n9 = this.m_walkDestZF;
        int n10 = simWorld.coordWorldToWorldTileX(n6);
        int n11 = simWorld.coordWorldToWorldTileZ(n7);
        int n12 = simWorld.getAttribute(n10, n11);
        int n13 = MathExt.sign(n8 - n6);
        int n14 = n13 != 0 ? 0 : MathExt.sign(n9 - n7);
        int n15 = 2048;
        int n16 = 1024;
        if (this.getRuntimeFlag(2048)) {
            n15 = 2621;
            n16 = 1310;
        } else if (this.getRuntimeFlag(4096)) {
            n15 = 1638;
            n16 = 786;
        }
        if (this.m_scene.isMapMode()) {
            n15 = n16;
            if (this.hasCar()) {
                n5 = simWorld.coordWorldToWorldTileX(n6);
                n3 = simWorld.getAttribute(n5, n4 = simWorld.coordWorldToWorldTileZ(n7));
                int n17 = n2 = (n3 & 0x20) != 0 ? 1 : 0;
                if (n2 != 0) {
                    int n18;
                    if (n14 == 0) {
                        n18 = simWorld.coordWorldTileToWorldCenterX(n5);
                        n3 = n13 < 0 && n6 <= n18 || n13 > 0 && n6 >= n18 ? simWorld.getAttribute(n5 + n13, n4) : simWorld.getAttribute(n5 - n13, n4);
                    } else {
                        n18 = simWorld.coordWorldTileToWorldCenterZ(n4);
                        n3 = n14 < 0 && n7 <= n18 || n14 > 0 && n7 >= n18 ? simWorld.getAttribute(n5, n4 + n14) : simWorld.getAttribute(n5, n4 - n14);
                    }
                    int n19 = n2 = (n3 & 0x20) != 0 ? 1 : 0;
                }
                if (n2 != 0) {
                    n15 = 2048;
                    this.setAppearance(3);
                } else {
                    this.setAppearance(2);
                }
            }
        }
        n5 = n15 * n;
        n7 += n14 * n5;
        if (n13 > 0 && (n6 += n13 * n5) > n8 || n13 < 0 && n6 < n8) {
            n6 = n8;
        }
        if (n14 > 0 && n7 > n9 || n14 < 0 && n7 < n9) {
            n7 = n9;
        }
        this.setFacingDir(n13, n14);
        this.setPos(n6, n7);
        if (!this.m_scene.isMapMode()) {
            n4 = simWorld.coordWorldToWorldTileX(n6);
            n3 = simWorld.coordWorldToWorldTileZ(n7);
            n2 = simWorld.getAttribute(n4, n3);
            if ((n12 & 0x20) == 0 && (n2 & 0x20) != 0) {
                this.DEBUG_WALKING("opening door");
                MapObject mapObject = this.m_scene.findRandomObjectByParentType(10);
                if (mapObject != null && !mapObject.getRuntimeFlag(64)) {
                    mapObject.respondToAction(152, this);
                }
            }
        }
        this.updateAnim(n);
        if (n6 == n8 && n7 == n9) {
            if (!this.occupiedIsEmpty() && this.getType() != 0) {
                this.DEBUG_WALKING("stopping for occupied flag");
                this.failSimPhase(true);
            } else if (this.m_simActionArg1 != null && (this.m_simActionArg1.getPosX() != this.m_checkPosXF || this.m_simActionArg1.getPosZ() != this.m_checkPosZF)) {
                this.DEBUG_WALKING("chasing moved destination");
                this.simWalkTo(this.m_simActionArg1, 0, 0);
            } else {
                n4 = !this.setOccupied(this.m_simActionArg1) ? 1 : 0;
                int[] nArray = this.m_walkPath;
                int n20 = nArray != null ? (nArray.length >> 1) - this.m_walkPathPoint : -1;
                if (n20 > ((n3 = this.m_walkStopShort || n4 != 0 ? 1 : 0) != 0 ? 2 : 1)) {
                    if (this.m_simActionArg1 != null && ((n20 & 3) == 0 || n20 < 4)) {
                        if (n4 == 0) {
                            this.DEBUG_WALKING("regetting occupied flag");
                            this.setOccupied(null);
                            this.setOccupied(this.m_simActionArg1);
                        }
                        this.DEBUG_WALKING("reevaluate path");
                        this.simWalkTo(this.m_simActionArg1, 0, 0);
                    } else {
                        this.DEBUG_WALKING("next path point");
                        ++this.m_walkPathPoint;
                        this.m_walkDestXF = nArray[(this.m_walkPathPoint << 1) + 0];
                        this.m_walkDestZF = nArray[(this.m_walkPathPoint << 1) + 1];
                    }
                } else {
                    this.m_walkPath = null;
                    if (n4 != 0) {
                        this.DEBUG_WALKING("start get occupied");
                        this.beginSimPhase(9);
                    } else {
                        this.DEBUG_WALKING("finished");
                        this.endSimPhase();
                    }
                }
            }
        }
    }

    private final void simWalkTo(MapObject mapObject, int n, int n2) {
        int n3;
        int n4;
        int n5;
        Object[] objectArray;
        int n6;
        SimWorld simWorld = this.getSimWorld();
        boolean bl = false;
        boolean bl2 = false;
        int n7 = n;
        int n8 = n2;
        if (mapObject != null) {
            bl = false;
            bl2 = !this.setOccupied(mapObject);
            n6 = this.m_occupiedIndex;
            if (n6 == -1) {
                n6 = mapObject.getClosestInterestPoint(this.getPosX(), this.getPosZ(), false, null);
                AppEngine.ASSERT(n6 != -1, "getClosestInterestPoint(false), returned -1");
            }
            objectArray = MapObject.s_tempInt10;
            mapObject.getInterestPoint((int[])objectArray, n6);
            n7 = objectArray[0];
            n8 = objectArray[1];
            this.m_checkPosXF = mapObject.getPosX();
            this.m_checkPosZF = mapObject.getPosZ();
        }
        n7 = simWorld.coordWorldTileToWorldCenterX(simWorld.coordWorldToWorldTileX(n7));
        n8 = simWorld.coordWorldTileToWorldCenterZ(simWorld.coordWorldToWorldTileZ(n8));
        if ((n7 != this.getPosX() || n8 != this.getPosZ()) && this.m_posture != 0) {
            this.DEBUG_WALKING("not standing, so getting up");
            --this.m_simActionPhaseIndex;
            this.beginSimPhase(32);
            return;
        }
        if (this.m_scene.isHouseMode() && simWorld.getHouseId() != 0 && this.getId() == 0 && this.m_simAction != 155 && !this.getRuntimeFlag(32) && !this.getSimData().getSimCurRelStateFlags(0, 1)) {
            this.DEBUG_WALKING("barging in check...");
            n6 = simWorld.coordWorldToWorldTileX(this.getPosX());
            int n9 = simWorld.coordWorldToWorldTileZ(this.getPosZ());
            n5 = simWorld.coordWorldToWorldTileX(n7);
            int n10 = simWorld.coordWorldToWorldTileZ(n8);
            if ((simWorld.getAttribute(n6, n9) & 0x10) == 0 && (simWorld.getAttribute(n5, n10) & 0x10) != 0) {
                this.DEBUG_WALKING("barge-in override");
                this.m_queuedSimAction = this.m_simAction;
                this.m_queuedSimActionArg1 = this.m_simActionArg1;
                this.m_queuedSimActionArg2 = this.m_simActionArg2;
                this.m_queuedSimActionArg3 = this.m_simActionArg3;
                this.setRuntimeFlag(16);
                this.beginSimAction(155, this.m_scene.findRandomObjectByParentType(10));
                return;
            }
        }
        this.unsetRuntimeFlag(32);
        n6 = 0;
        if (this.m_scene.isMapMode()) {
            n6 = this.hasCar() ? 2 : 4;
        } else {
            n6 = 8;
            objectArray = this.m_scene.getSimObjects();
            if (objectArray.length > 1) {
                simWorld.pathClearAvoidTiles();
                for (n5 = 0; n5 < objectArray.length; ++n5) {
                    int n11 = objectArray[n5];
                    if (n11 == this) continue;
                    n4 = simWorld.coordWorldToWorldTileX(n11.getPosX());
                    n3 = simWorld.coordWorldToWorldTileZ(n11.getPosZ());
                    simWorld.pathAddAvoidTile(n4, n3);
                }
                n6 |= 1;
            }
        }
        int n12 = this.getPosX();
        n5 = this.getPosZ();
        int[] nArray = simWorld.pathFind(n12, n5, n7, n8, n6);
        if (!bl && bl2 && nArray.length == 2) {
            this.DEBUG_WALKING("target busy, already there");
            this.beginSimPhase(9);
        } else if (bl && nArray.length == 2) {
            this.DEBUG_WALKING("stop short, already there");
            this.endSimPhase();
        } else if (nArray.length >= 2) {
            this.DEBUG_WALKING("starting to walk");
            this.m_walkPath = nArray;
            this.m_walkPathPoint = 0;
            this.m_walkStopShort = bl;
            this.m_walkDestXF = nArray[(this.m_walkPathPoint << 1) + 0];
            this.m_walkDestZF = nArray[(this.m_walkPathPoint << 1) + 1];
            this.simStateTransition(3);
        } else {
            n4 = n12 - n7;
            n3 = n5 - n8;
            int n13 = Math.abs(n4) + Math.abs(n3);
            if (n13 <= 524288) {
                if (n13 != 0) {
                    this.DEBUG_WALKING("very close");
                    this.m_walkPath = nArray;
                    this.m_walkPathPoint = 0;
                    this.m_walkStopShort = bl;
                    this.m_walkDestXF = n7;
                    this.m_walkDestZF = n8;
                    this.simStateTransition(3);
                } else {
                    this.DEBUG_WALKING("already there");
                    this.endSimPhase();
                }
            } else {
                this.DEBUG_WALKING("too far/invalid path");
                this.failSimPhase(false);
            }
        }
    }

    public final int getFeedbackTime() {
        return this.m_feedbackTime;
    }

    private final void simUpdateFeedback(int n) {
        int n2;
        int n3 = this.getAnimPlayer(0).getCurrAnimFrame();
        this.updateAnim(n);
        int n4 = this.getAnimPlayer(0).getCurrAnimFrame();
        AnimPlayer animPlayer = this.getAnimPlayer(0);
        if (n3 != n4) {
            if (this.m_simAction == 149 && n4 == 2) {
                this.m_simActionArg1.trashCanKick(this);
            }
            if (this.m_simAction == 95 && n4 == 2 && (this.getId() == 0 || this.getSimActionArg1Sim() != null && this.getSimActionArg1Sim().getId() == 0)) {
                this.m_engine.vibrate();
            }
            int n5 = n2 = this.getFacingDir() == 0 || this.getFacingDir() == 1 ? 2 : 3;
            if (this.m_simAction == 85 && this.m_subAppearance == 41 && n4 == n2) {
                this.m_scene.triggerEvent(2, 796, this.getSimActionArg1().getId());
            }
            if (this.m_simAction == 4 && n4 == 15 && this.m_engine.randPercent() < 5) {
                this.m_scene.killPlayer(810);
            }
        }
        this.getAnimPlayer(2).updateAnim(n);
        n2 = 0;
        if (this.m_feedbackLoop) {
            if (this.m_feedbackRealTime) {
                n2 = this.m_feedbackTime <= this.getSimData().getGameTimeAbs() ? 1 : 0;
            } else {
                if (!this.m_scene.inMiniGame()) {
                    this.m_feedbackTime -= n;
                }
                n2 = this.m_feedbackTime <= 0 ? 1 : 0;
            }
        } else {
            int n6 = n2 = !animPlayer.isAnimating() ? 1 : 0;
        }
        if (this.m_simPhase == 51 && this.getSimActionArg1().coffeeMachineIsReady()) {
            this.endSimPhase();
        }
        if (n2 != 0) {
            this.m_feedbackSubAppearance = -1;
            this.m_feedbackTime = -1;
            this.m_feedbackLoop = true;
            this.endSimPhase();
        } else {
            if (this.getId() == 0 && this.m_simPhase == 21 && this.m_simStateTime > 4000 && this.m_feedbackRealTime && this.m_feedbackTime - this.getSimData().getGameTimeAbs() > 60 && this.occupiedIsEmpty() && !this.m_scene.isCurtainActive()) {
                this.m_scene.startCurtainIn();
            }
            if (this.m_simPhase == 18 && this.m_simActionArg1.getParentType() == 3 && this.m_subAppearance != 50 && this.m_simActionArg1.bathIsFull()) {
                if (this.getId() == 0) {
                    this.getSimData().setMotiveAdjust(3, 655360);
                }
                this.setSubAppearance(50);
            }
        }
    }

    private final void simUpdateGetAttention(int n) {
        this.updateAnim(n);
        MapObjectSim mapObjectSim = this.getSimActionArg1Sim();
        if (this.m_simAction != 96) {
            int n2 = mapObjectSim.getPosX() - this.getPosX();
            int n3 = mapObjectSim.getPosZ() - this.getPosZ();
            int n4 = Math.abs(n2) + Math.abs(n3);
            if (n4 > 524288) {
                this.failSimPhase(false);
                return;
            }
        }
        if (this.m_simStateTime > 4000) {
            this.failSimPhase(false);
            return;
        }
        if (mapObjectSim.isIdle()) {
            mapObjectSim.beginSimAction(2, this);
            this.endSimPhase();
        }
    }

    private final void simUpdateGetOccupied(int n) {
        this.updateAnim(n);
        if (this.m_simStateTime > 4000) {
            this.failSimPhase(false);
            return;
        }
        if (this.setOccupied(this.m_simActionArg1)) {
            this.beginSimPhase(1);
        }
    }

    private final void simUpdateListen(int n) {
        this.updateAnim(n);
        MapObjectSim mapObjectSim = this.getSimActionArg1Sim();
        if (mapObjectSim == null || mapObjectSim.isIdle()) {
            this.endSimPhase();
        } else if (mapObjectSim != null && mapObjectSim.getRuntimeFlag(1024)) {
            SimData simData = this.getSimData();
            if (simData.hasSimGotTrait(this.getId(), 12) != -1) {
                if (!this.getRuntimeFlag(262144)) {
                    simData.tryDiscoverTrait(this.getId(), 12);
                    this.setRuntimeFlag(262144);
                }
            } else {
                mapObjectSim.interrupt();
                this.clearConversation();
                int n2 = 0;
                if (simData.hasSimGotTrait(this.getId(), 13) != -1) {
                    n2 = 34;
                    simData.tryDiscoverTrait(this.getId(), 13);
                    simData.adjustRelLevels(this.getId(), -1, -1);
                }
                this.beginSimAction(14, mapObjectSim, n2, 0);
            }
        }
    }

    private final void simUpdateHide(int n) {
        if (this.m_simAction == 165) {
            return;
        }
        if (this.m_feedbackRealTime) {
            if (this.m_feedbackTime <= this.getSimData().getGameTimeAbs()) {
                this.endSimPhase();
            }
        } else if (this.m_feedbackTime > 0) {
            this.m_feedbackTime -= n;
            if (this.m_feedbackTime <= 0) {
                this.endSimPhase();
            }
        }
    }

    public final int getSimAction() {
        return this.m_simAction;
    }

    public final int getSimPhase() {
        return this.m_simPhase;
    }

    public final MapObject getSimActionArg1() {
        return this.m_simActionArg1;
    }

    public final MapObjectSim getSimActionArg1Sim() {
        return this.m_simActionArg1 instanceof MapObjectSim ? (MapObjectSim)this.m_simActionArg1 : null;
    }

    public final boolean isIdle() {
        return (this.getSimData().getActionFlags(this.m_simAction) & 2) != 0;
    }

    public final boolean isReady() {
        return this.isIdle() || this.m_simPhase == 8 || this.m_simPhase == 9 || this.m_simPhase == 1;
    }

    public final boolean isWorking() {
        return this.m_simPhase == 28;
    }

    public final boolean isSleeping() {
        return (this.m_simAction == 124 || this.m_simAction == 123) && this.m_posture == 4;
    }

    public final void queueSimAction(int n, MapObject mapObject, int n2, int n3) {
        if (this.isReady()) {
            this.beginSimAction(n, mapObject, n2, n3);
        } else {
            this.m_queuedSimAction = n;
            this.m_queuedSimActionArg1 = mapObject;
            this.m_queuedSimActionArg2 = n2;
            this.m_queuedSimActionArg3 = n3;
        }
    }

    public final void beginSimAction(int n, MapObject mapObject) {
        this.beginSimAction(n, mapObject, 0, 0);
    }

    public final void beginSimAction(int n, MapObject mapObject, int n2, int n3) {
        MapObjectSim mapObjectSim;
        SimData simData = this.getSimData();
        if (this.m_simPhase != 0) {
            this.endSimPhase(true);
        }
        this.unsetRuntimeFlag(262146);
        if (n == 121 && this.m_appearance == 0 && this.m_engine.randPercent() < 50) {
            n = 122;
        }
        this.m_simAction = n;
        this.m_simActionArg1 = mapObject;
        this.m_simActionArg2 = n2;
        this.m_simActionArg3 = n3;
        if (mapObject == null && n != 108 || !this.setOccupied(mapObject)) {
            // empty if block
        }
        if ((mapObjectSim = this.getSimActionArg1Sim()) != null && (simData.getActionFlags(n) & 1) != 0) {
            this.setConversation(mapObjectSim);
        }
        int n4 = simData.getActionPhase(n, 0);
        this.m_simActionPhaseIndex = 0;
        this.beginSimPhase(n4);
    }

    public final void playerAction(MapObject mapObject) {
        if (mapObject != this && (this.m_needFlags & 0x20) != 0) {
            MapObjectSim mapObjectSim = this.m_scene.getPlayerSim().getSimActionArg1Sim();
            if (this.m_conversationSim == 0 || mapObjectSim != null && this.m_conversationSim == mapObjectSim.getId()) {
                this.m_scene.DEBUG_EVENT("abort talking");
                this.clearConversation();
            }
        }
    }

    public final boolean setOccupied(MapObject mapObject) {
        AppEngine.ASSERT(mapObject != this, "attempting to get occupied flag on self");
        if (mapObject == this.m_occupiedObject) {
            return true;
        }
        if (this.m_occupiedObject != null) {
            this.m_occupiedObject.occupiedRelease(this.m_occupiedIndex);
            this.m_occupiedObject = null;
            this.m_occupiedIndex = -1;
        }
        if (mapObject == null) {
            return true;
        }
        if (mapObject.occupiedIsAnyAvailable()) {
            int n;
            int n2;
            SimWorld simWorld;
            int n3;
            int n4 = -1;
            n4 = mapObject.getParentType() == 10 ? (((n3 = (simWorld = this.getSimWorld()).getAttribute(n2 = simWorld.coordWorldToWorldTileX(this.getPosX()), n = simWorld.coordWorldToWorldTileZ(this.getPosZ()))) & 0x10) != 0 ? 0 : 1) : mapObject.getClosestInterestPoint(this.getPosX(), this.getPosZ(), true, this);
            if (n4 != -1 && mapObject.occupiedCapture(n4, this)) {
                this.m_occupiedObject = mapObject;
                this.m_occupiedIndex = n4;
                return true;
            }
        }
        return false;
    }

    private final void endSimAction() {
        boolean bl = this.getRuntimeFlag(4);
        SimData simData = this.getSimData();
        this.unsetRuntimeFlag(12);
        int n = this.m_simAction;
        MapObject mapObject = this.m_simActionArg1;
        MapObjectSim mapObjectSim = this.getSimActionArg1Sim();
        boolean bl2 = this.getId() == 0;
        this.beginSimAction(0, null);
        int n2 = simData.getActionFlags(n);
        if (!bl && mapObjectSim != null && (n2 & 1) != 0) {
            this.setOccupied(null);
            mapObjectSim.setOccupied(null);
            boolean bl3 = mapObjectSim.respondToAction(n, this);
            if (bl3) {
                this.clearConversation();
            }
            if (bl2) {
                int n3 = mapObjectSim.getId();
                if (n == 95) {
                    simData.dreamCompleteEvent(26);
                    simData.setSimCurRelStateFlags(n3, 32);
                    simData.setSimCurRelStateFlags(n3, 2048);
                } else if (n == 107) {
                    simData.setSimCurRelStateFlags(n3, 256);
                }
            }
        } else if (!bl) {
            switch (n) {
                case 161: 
                case 162: 
                case 166: {
                    this.m_scene.gotoMapForObject(mapObject);
                    break;
                }
                case 109: {
                    this.m_scene.gotoMap();
                    break;
                }
                case 145: {
                    this.m_scene.showQuitJob();
                    break;
                }
                case 149: {
                    if (!bl2) break;
                    simData.dreamCompleteEvent(44);
                    simData.setHouseCurRelStateFlags(this.getSimWorld().getHouseId(), 16);
                    simData.setHouseCurRelStateFlags(this.getSimWorld().getHouseId(), 4096);
                    break;
                }
                case 4: {
                    if (bl2) {
                        simData.adjustMotiveLevel(3, -6553600);
                    }
                    if (this.m_scene.isObjectAt(1, this.getPosX(), this.getPosZ())) break;
                    int n4 = -1;
                    if (this.getSimWorld().getHouseId() == 0) {
                        n4 = this.getSimWorld().objectBuy(9, this.getPosX(), this.getPosZ(), this.getFacingDir());
                    }
                    this.m_scene.createObject(9, this.getPosX(), this.getPosZ(), this.getFacingDir(), n4);
                    break;
                }
                case 154: {
                    if (bl2) break;
                    this.m_simStateTime = 0;
                    this.m_scene.showDoorKnock(this.getId());
                    break;
                }
                case 113: 
                case 115: {
                    this.m_scene.increaseSkill(4);
                    break;
                }
                case 164: {
                    simData.dreamCompleteEvent(28);
                    simData.adjustMotiveLevel(0, 0x280000);
                    break;
                }
                case 123: 
                case 124: {
                    this.m_needFlags &= 0xFFFFFFFB;
                }
            }
        }
        if (n == 155) {
            this.unsetRuntimeFlag(16);
            if (bl) {
                this.m_queuedSimAction = -1;
                this.m_queuedSimActionArg1 = null;
            } else {
                this.setRuntimeFlag(32);
            }
        }
        if (mapObject != null && mapObjectSim == null && !bl) {
            mapObject.respondToAction(n, this);
            if (bl2) {
                simData.setQuickLinkVisited(mapObject.getType());
            }
        }
        if (this.m_queuedSimAction != -1 && this.isIdle()) {
            this.beginSimAction(this.m_queuedSimAction, this.m_queuedSimActionArg1, this.m_queuedSimActionArg2, this.m_queuedSimActionArg3);
            this.m_queuedSimAction = -1;
            this.m_queuedSimActionArg1 = null;
        }
    }

    public final boolean respondToAction(int n, MapObjectSim mapObjectSim) {
        SimData simData = this.getSimData();
        int n2 = mapObjectSim.getId();
        int n3 = this.getId();
        int[] nArray = MapObject.s_tempInt10;
        simData.relationshipAction(nArray, n2, n3, n);
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = nArray[2];
        if ((n4 & 0x40) != 0) {
            this.m_scene.advertiseEvent(25, mapObjectSim, this);
        }
        if (n == 105 || n == 100) {
            this.beginSimAction(0, null);
            this.setNeedFlag(256);
        } else if (n5 != -1) {
            if ((simData.getActionFlags(n5) & 1) == 0 && n5 != 108) {
                mapObjectSim = null;
            }
            if (n2 == 0 && n5 == 13) {
                simData.dreamCompleteEvent(22);
                simData.setSimCurRelStateFlags(n3, 8192);
            }
            this.beginSimAction(n5, mapObjectSim, n4, 0);
            if (n6 != -1) {
                this.m_scene.createEffectAnim(this.getPosX(), this.getPosZ(), n6, 0);
            }
        }
        return (n4 & 0x20) != 0;
    }

    public final boolean respondToEvent(int n, MapObjectSim mapObjectSim, MapObject mapObject) {
        SimData simData = this.getSimData();
        if (this.isSleeping()) {
            return false;
        }
        if (n == 25) {
            AppEngine.ASSERT(mapObject instanceof MapObjectSim, "wtf: romancing a non-sim!");
            int n2 = simData.getSimPartner(this.getId());
            if (n2 != mapObject.getId()) {
                return false;
            }
        }
        int[] nArray = MapObject.s_tempInt10;
        simData.relationshipAction(nArray, mapObjectSim.getId(), this.getId(), n);
        int n3 = nArray[1];
        if (n3 != -1) {
            int n4 = nArray[0];
            MapObject mapObject2 = (n4 & 0x4000) != 0 ? mapObject : mapObjectSim;
            this.interrupt();
            this.queueSimAction(n3, mapObject2, 0, 0);
            if (n == 25 && mapObjectSim.getId() == 0) {
                simData.dreamCompleteEvent(58);
            }
            this.setRuntimeFlag(8);
            return true;
        }
        return false;
    }

    private final void beginSimPhase(int n) {
        boolean bl;
        SceneGame sceneGame = this.m_scene;
        SimData simData = this.getSimData();
        this.m_simPhase = n;
        int n2 = this.m_simAction;
        MapObject mapObject = this.m_simActionArg1;
        MapObjectSim mapObjectSim = this.getSimActionArg1Sim();
        int n3 = this.m_simActionArg2;
        int n4 = this.m_simActionArg3;
        AppEngine appEngine = this.m_engine;
        boolean bl2 = bl = this.getId() == 0;
        if (bl && mapObjectSim != null) {
            simData.setLastNPC(mapObjectSim.getId());
        }
        boolean bl3 = false;
        System.out.println("beginSimPhase 7");
        switch (n) {
            case 0: {
                if (this.m_posture == 7 || this.m_posture == 6) {
                    --this.m_simActionPhaseIndex;
                    this.beginSimPhase(32);
                    break;
                }
                this.simStateTransition(1);
                break;
            }
            case 1: {
                this.simWalkTo(mapObject, n3, n4);
                break;
            }
            case 2: 
            case 3: {
                if (mapObject != null) {
                    this.setFacingObject(mapObject);
                } else {
                    this.setFacingDir(n3 - this.getPosX(), n4 - this.getPosZ());
                }
                if (n == 3) {
                    this.setFacingDir(this.getFacingDir() + 2 & 3);
                }
                this.endSimPhase();
                break;
            }
            case 4: {
                this.setFacingDir(mapObject.getFacingDir());
                this.endSimPhase();
                break;
            }
            case 8: {
                this.simStateTransition(5);
                break;
            }
            case 9: {
                this.simStateTransition(6);
                break;
            }
            case 10: {
                this.getSimActionArg1Sim().interrupt();
                this.endSimPhase();
                break;
            }
            case 11: {
                this.simStateTransition(7);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.performPhaseFeedback(n2, n);
                bl3 = true;
                break;
            }
            case 22: {
                mapObject.turnOn();
                this.endSimPhase();
                bl3 = true;
                break;
            }
            case 23: {
                if (simData.startXmasLighting()) {
                    mapObject.turnOn();
                    this.endSimPhase();
                    bl3 = true;
                    appEngine.getSimWorld().glowLightForXmas();
                    break;
                }
                this.failSimPhase(false);
                break;
            }
            case 24: {
                mapObject.turnOff();
                this.endSimPhase();
                bl3 = true;
                appEngine.getSimWorld().switchOffLightForXmas();
                break;
            }
            case 55: {
                mapObject.turnOn();
                this.endSimPhase();
                bl3 = true;
                break;
            }
            case 56: {
                mapObject.turnOff();
                this.endSimPhase();
                bl3 = true;
                break;
            }
            case 25: {
                MapObject mapObject2;
                if (bl) {
                    simData.dreamCompleteEvent(43);
                }
                if ((mapObject2 = sceneGame.findRandomObjectByParentType(9)) != null) {
                    this.beginSimAction(146, mapObject2, 0, 0);
                } else {
                    this.beginSimAction(108, mapObject, 0, 0);
                }
                bl3 = true;
                break;
            }
            case 26: {
                MapObject mapObject3 = sceneGame.findRandomNeedObject(128);
                if (mapObject3 != null) {
                    this.m_simActionArg1 = mapObject3;
                    this.endSimPhase();
                    break;
                }
                this.failSimPhase(false);
                break;
            }
            case 27: {
                if (bl) {
                    simData.setMotiveAdjust(5, 196608);
                }
                this.simFeedback(58, 10000, -1, false, false);
                break;
            }
            case 12: {
                AppEngine.ASSERT(bl, "NPC cooking!");
                if (simData.startRecipe(n3)) {
                    sceneGame.beginMiniGame(0, mapObject);
                    AppEngine.ASSERT(mapObject.getParentType() == 19, "cooking at non-stove!");
                    mapObject.stoveStart();
                    this.simFeedback(4, 1000, -1, false, false);
                    break;
                }
                this.failSimPhase(false);
                break;
            }
            case 13: {
                AppEngine.ASSERT(bl, "NPC fishing!");
                if (simData.startFishing()) {
                    sceneGame.beginMiniGame(1, mapObject);
                    if (mapObject.getType() == 5) {
                        this.setFacingDir(0);
                    } else {
                        this.setFacingDir(1);
                    }
                    this.setZSortOffset(20);
                    this.simFeedback(24, 1000, -1, false, false);
                    break;
                }
                this.failSimPhase(false);
                break;
            }
            case 16: {
                AppEngine.ASSERT(bl, "NPC fishing!");
                if (simData.startSkiing()) {
                    sceneGame.beginMiniGame(4, mapObject);
                    break;
                }
                this.failSimPhase(false);
                break;
            }
            case 14: {
                AppEngine.ASSERT(bl, "NPC repairing!");
                if (simData.startRepairing()) {
                    sceneGame.beginMiniGame(2, mapObject);
                    this.simFeedback(4, 1000, -1, false, false);
                    break;
                }
                this.failSimPhase(false);
                break;
            }
            case 15: {
                AppEngine.ASSERT(bl, "NPC cleaning!");
                if (simData.startCleaning()) {
                    sceneGame.beginMiniGame(3, mapObject);
                    this.simFeedback(4, 1000, -1, false, false);
                    break;
                }
                this.failSimPhase(false);
                break;
            }
            case 17: {
                int n5;
                int n6 = 5000;
                if (bl) {
                    n5 = 458752;
                    if (n2 == 128) {
                        n5 = this.getSimWorld().getRecipeReplenishes(n3);
                    }
                    simData.setMotiveAdjust(0, n5);
                }
                if (mapObject.getParentType() == 13) {
                    mapObject.fridgeOpen();
                    n6 = 3500;
                }
                n5 = 4;
                if (this.m_posture == 2 || this.m_posture == 1) {
                    n5 = 60;
                }
                this.simFeedback(n5, n6, -1, false, false);
                bl3 = true;
                break;
            }
            case 18: {
                int n7 = mapObject.getParentType();
                if (n7 == 17) {
                    if (bl) {
                        simData.setMotiveAdjust(3, 655360);
                    }
                    mapObject.showerStart();
                    this.simHide(5000, false);
                    bl3 = true;
                    break;
                }
                if (n7 == 3) {
                    mapObject.bathToFill();
                    mapObject.setPostRenderTarget(this);
                    this.simFeedback(4, 8000, -1, false, false);
                    bl3 = true;
                    break;
                }
                if (n7 == 2) {
                    if (bl && !this.getRuntimeFlag(1024)) {
                        simData.setMotiveAdjust(3, 655360);
                    }
                    mapObject.basinStart();
                    this.simFeedback(4, 1500, -1, false, false);
                    break;
                }
                AppEngine.ASSERT(false, "what are we washing at?!");
                break;
            }
            case 19: {
                if (bl) {
                    simData.setMotiveAdjust(2, 0x320000);
                }
                int n8 = n2 == 121 ? 28 : 29;
                this.simFeedback(n8, 2000, -1, false, false);
                break;
            }
            case 20: 
            case 21: {
                this.performPhaseSleep(n);
                bl3 = true;
                break;
            }
            case 30: {
                AppEngine.ASSERT(bl, "NPC looking for work!");
                int n9 = simData.getJobSearchCareerFromObject(mapObject);
                int n10 = simData.getJobSearchLevel(n9);
                sceneGame.showJobOffer(n9, n10, true);
                this.endSimPhase();
                break;
            }
            case 28: {
                if (bl) {
                    this.simStateTransition(8);
                    sceneGame.startCurtainIn();
                    break;
                }
                MapObjectSim[] mapObjectSimArray = sceneGame.getSimObjects();
                if (mapObjectSimArray.length == 2 && !simData.isWelcome()) {
                    sceneGame.kickPlayer(774, simData.getSimName(this.getId()));
                }
                this.simStateTransition(9);
                break;
            }
            case 29: {
                sceneGame.finishCallAction(n2, n3);
                this.endSimPhase();
                break;
            }
            case 45: {
                sceneGame.buyFurniture();
                this.endSimPhase();
                break;
            }
            case 46: {
                sceneGame.upgradeHouse();
                this.endSimPhase();
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.performPhasePosture(n);
                break;
            }
            case 31: {
                sceneGame.kickPlayer(773, 772);
                this.endSimPhase();
                break;
            }
            case 41: {
                if (bl) {
                    this.performPhaseCheckMoney();
                    break;
                }
                this.endSimPhase();
                break;
            }
            case 42: {
                if (bl) {
                    this.performPhaseCheckLock();
                    break;
                }
                this.endSimPhase();
                break;
            }
            case 43: {
                if (bl) {
                    this.performPhaseCheckHappy();
                    break;
                }
                this.endSimPhase();
                break;
            }
            case 44: {
                sceneGame.openShop(mapObject);
                this.endSimPhase();
                break;
            }
            case 47: {
                this.performPhasePlant();
                break;
            }
            case 48: {
                this.performPhaseTend();
                break;
            }
            case 49: {
                mapObject.plantHarvest();
                this.endSimPhase();
                break;
            }
            case 50: {
                mapObject.plantUproot();
                this.endSimPhase();
                break;
            }
            case 51: {
                AppEngine.ASSERT(mapObject.getParentType() == 7, "drinking at non-coffee machine");
                mapObject.coffeeMachineActivate();
                this.simFeedback(0, 60000, -1, false, false);
                bl3 = true;
                break;
            }
            case 52: {
                if (bl) {
                    simData.setMotiveAdjust(2, -327680);
                    simData.setMotiveAdjust(1, 655360);
                }
                this.simFeedback(4, 2000, -1, false, false);
                break;
            }
            case 53: {
                MapObject mapObject4;
                this.m_simActionArg1 = mapObject4 = mapObject.computerGetChair();
                this.setFacingObject(mapObject4);
                this.beginSimPhase(33);
                break;
            }
            case 54: {
                if (bl) {
                    simData.setMotiveAdjust(5, 393216);
                }
                this.m_simActionArg1 = this.m_simActionArg1.computerChairGetComputer();
                this.m_simActionArg1.turnOn();
                this.simFeedback(60, 15000, -1, false, false);
                break;
            }
        }
        if (bl && bl3 && (simData.getActionFlags(n2) & 0x100000) != 0) {
            sceneGame.advertiseEvent(22, this, this.m_simActionArg1);
        }
        if (this.getRuntimeFlag(2)) {
            this.failSimPhase(true);
        }
    }

    private void performPhaseFeedback(int n, int n2) {
        int n3;
        int n4;
        MapObject mapObject;
        SimData simData = this.getSimData();
        if (n == 154 && (mapObject = this.m_scene.findRandomObjectByParentType(10)) != null && mapObject.getRuntimeFlag(64)) {
            this.endSimPhase();
            return;
        }
        int n5 = -1;
        int n6 = -1;
        if (n2 == 5) {
            int n7 = n6 = this.getFacingDir() == 3 || this.getFacingDir() == 0 ? 670 : 671;
            if (simData.getSimAttribute(this.getId(), 0) == 1) {
                n4 = 4;
                n3 = 6;
            } else {
                n4 = 7;
                n3 = 9;
            }
            AppEngine appEngine = AppEngine.getCanvas();
            appEngine.getSoundManager().playSound(appEngine.rand(n4, n3));
        }
        n4 = 0;
        if (n != 138 && n != 139 && n != 113 && this.m_simActionArg2 != 0) {
            n6 = SimData.responseToFeedbackAnim(this.m_simActionArg2);
            n4 = 1;
        }
        int n8 = n3 = n2 == 7 ? -1 : 2000;
        if (n == 17) {
            n3 = 5000;
        }
        this.simFeedback(n5, n3, n6, n4 != 0, false);
        if (this.getId() == 0) {
            if (n == 150) {
                simData.setMotiveAdjust(3, -1310720);
            } else if (n == 15 || n == 16) {
                simData.setMotiveAdjust(5, 196608);
            } else if (n == 17) {
                simData.setMotiveAdjust(5, 196608);
            }
        }
    }

    private void performPhaseSleep(int n) {
        SimData simData = this.getSimData();
        int n2 = simData.getGameTimeAbs();
        int n3 = simData.getWakeupTime(this.getId());
        if (n == 20) {
            n3 = Math.min(n3, n2 + 120);
        }
        int n4 = n3 - n2;
        if (this.getId() == 0) {
            simData.setFastforward(true);
            simData.setMotiveAdjust(1, 65536);
        }
        this.stopSecondaryAnim();
        this.setEffectAnimId(this.getFacingDir() == 0 ? 37 : 36);
        int n5 = n2 + n4;
        this.simFeedback(15, n5, -1, false, true);
    }

    private void performPhasePosture(int n) {
        int n2;
        if (n == 33) {
            AppEngine.ASSERT(this.m_simActionArg1 != null, "can't auto-sit without a chair");
            if (this.m_simActionArg1.getParentType() == 6) {
                n = 35;
            } else {
                this.setFacingDir(this.getFacingDir() + 2 & 3);
                n = 34;
            }
        }
        int n3 = n == 32 ? 0 : (n == 34 ? 1 : (n == 35 ? 2 : (n == 36 ? 3 : (n == 39 ? 6 : (n == 37 ? 4 : (n2 = n == 38 ? 5 : 7))))));
        if (this.m_posture == n2) {
            this.endSimPhase();
        } else {
            this.m_targetPosture = n2;
            this.simStateTransition(2);
        }
    }

    private void performPhaseCheckMoney() {
        SimData simData = this.getSimData();
        int n = simData.getCostForAction(this.m_simAction);
        int n2 = simData.getMoney();
        if (n2 >= n) {
            simData.adjustMoney(-n);
            this.m_scene.createEffectMoney(this.getPosX(), this.getPosZ(), n);
            this.endSimPhase();
        } else {
            this.failSimPhase(false);
        }
    }

    private void performPhaseCheckLock() {
        SimData simData = this.getSimData();
        boolean bl = true;
        MapObjectSim[] mapObjectSimArray = this.m_scene.getSimObjects();
        if (mapObjectSimArray.length > 1) {
            bl = false;
        } else if (simData.getSimCareer(0) == 4) {
            bl = false;
        } else if (simData.isWelcome()) {
            bl = false;
        }
        if (bl) {
            this.failSimPhase(false);
        } else {
            this.endSimPhase();
        }
    }

    private void performPhaseCheckHappy() {
        SimData simData = this.getSimData();
        if (simData.buffGetActiveSlot(12) != -1 || simData.buffGetActiveSlot(11) != -1) {
            int n = 7;
            if (this.m_engine.randPercent() < 50) {
                n = 14;
            }
            this.beginSimAction(n, this.m_simActionArg1);
        } else {
            this.endSimPhase();
        }
    }

    private void performPhasePlant() {
        int n;
        SimData simData = this.getSimData();
        if (simData.getInventoryCount(n = this.m_simActionArg2) > 0) {
            simData.adjustInventory(n, -1);
            this.m_simActionArg1.plantSeed(n);
            this.endSimPhase();
        } else {
            this.failSimPhase(false);
        }
    }

    private void performPhaseTend() {
        SimData simData = this.getSimData();
        if (simData.getInventoryCount(7) > 0 && simData.getInventoryCount(8) > 0) {
            simData.adjustInventory(8, -1);
            this.m_simActionArg1.plantGrow();
            this.endSimPhase();
        } else {
            this.failSimPhase(false);
        }
    }

    public final void endSimPhase() {
        this.endSimPhase(false);
    }

    private final void endSimPhase(boolean bl) {
        int n;
        SimData simData = this.getSimData();
        SimWorld simWorld = this.getSimWorld();
        int n2 = simWorld.getHouseId();
        int n3 = simData.getActionPhaseCount(this.m_simAction);
        boolean bl2 = this.getId() == 0;
        MapObject mapObject = this.m_simActionArg1;
        switch (this.m_simPhase) {
            case 28: {
                break;
            }
            case 17: {
                if (bl2) {
                    simData.setMotiveAdjust(0, 0);
                }
                if (mapObject == null || mapObject.getParentType() != 13) break;
                mapObject.fridgeClose();
                break;
            }
            case 27: {
                if (!bl2) break;
                simData.setMotiveAdjust(5, 0);
                break;
            }
            case 12: {
                AppEngine.ASSERT(mapObject.getParentType() == 19, "cooking at non-stove!");
                mapObject.stoveEnd();
                break;
            }
            case 20: 
            case 21: {
                if (bl2) {
                    simData.setMotiveAdjust(1, 0);
                    simData.setFastforward(false);
                    if (this.m_simPhase == 21 && n2 != 0) {
                        simData.dreamCompleteEvent(45);
                        n = mapObject.bedGetRelStateFlags();
                        simData.setHouseCurRelStateFlags(n2, n);
                    }
                }
                this.setEffectAnimId(-1);
                this.recheckBuffEffects();
                break;
            }
            case 18: {
                if (bl2) {
                    simData.setMotiveAdjust(3, 0);
                }
                if (mapObject == null) break;
                n = mapObject.getParentType();
                if (n == 17) {
                    mapObject.showerEnd();
                    if (!bl2 || n2 == 0) break;
                    simData.dreamCompleteEvent(46);
                    simData.setHouseCurRelStateFlags(n2, 8);
                    break;
                }
                if (n == 2) {
                    mapObject.basinEnd();
                    break;
                }
                if (n != 3) break;
                mapObject.bathToEmpty();
                mapObject.releasePostRenderTarget(this);
                break;
            }
            case 19: {
                if (!bl2) break;
                simData.setMotiveAdjust(2, 0);
                if (n2 == 0) break;
                simData.dreamCompleteEvent(47);
                simData.setHouseCurRelStateFlags(n2, 4);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.endFeedback();
                if (!bl2) break;
                if (this.m_simAction == 150) {
                    simData.setMotiveAdjust(3, 0);
                    break;
                }
                if (this.m_simAction != 15 && this.m_simAction != 16 && this.m_simAction != 17) break;
                simData.setMotiveAdjust(5, 0);
                break;
            }
            case 51: {
                if (mapObject == null) break;
                mapObject.coffeeMachineDeactivate();
                break;
            }
            case 52: {
                if (!bl2) break;
                simData.setMotiveAdjust(2, 0);
                simData.setMotiveAdjust(1, 0);
                break;
            }
            case 54: {
                if (bl2) {
                    simData.setMotiveAdjust(5, 0);
                }
                mapObject.turnOff();
                break;
            }
            case 13: {
                this.setZSortOffset(0);
                break;
            }
            case 16: {
                this.setZSortOffset(0);
                break;
            }
        }
        if (!bl) {
            if (this.m_simActionPhaseIndex < n3 - 1) {
                ++this.m_simActionPhaseIndex;
                n = simData.getActionPhase(this.m_simAction, this.m_simActionPhaseIndex);
                this.beginSimPhase(n);
            } else {
                this.endSimAction();
            }
        }
    }

    public final void interrupt() {
        this.DEBUG_SIM("interrupt");
        int n = this.getSimData().getActionFlags(this.m_simAction);
        if ((n & 1) != 0 && (n & 0x80000) == 0 && this.getSimActionArg1Sim() != null) {
            this.getSimActionArg1Sim().interrupt();
        }
        this.setRuntimeFlag(2);
        this.failSimPhase(true);
    }

    private final void failSimPhase(boolean bl) {
        this.setRuntimeFlag(4);
        int n = -1;
        int n2 = 280;
        switch (this.m_simPhase) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: {
                break;
            }
            case 1: {
                n = 285;
                break;
            }
            case 26: {
                if (this.m_simAction == 148) {
                    n = 322;
                    break;
                }
                n = 308;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 17: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 51: 
            case 52: {
                this.endSimPhase(true);
                this.endSimAction();
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 54: {
                this.endSimPhase();
                break;
            }
            case 12: {
                n = 786;
                n2 = this.getSimWorld().getRecipeDesc(this.m_simActionArg2);
                break;
            }
            case 13: {
                n = 343;
                break;
            }
            case 16: {
                n = 994;
                break;
            }
            case 23: {
                n = 995;
                break;
            }
            case 14: {
                n = 290;
                break;
            }
            case 15: {
                n = 288;
                break;
            }
            case 47: {
                n = 292;
                break;
            }
            case 48: {
                n = 295;
                break;
            }
            case 41: {
                n = 306;
                break;
            }
            case 42: {
                n = 330;
                break;
            }
            case 43: {
                break;
            }
        }
        if (n != -1) {
            if (!bl && this.getId() == 0) {
                this.m_scene.showMessageBox(n, n2);
            }
            this.endSimAction();
        }
    }

    private final void checkNeeds() {
        AppEngine appEngine = this.m_engine;
        int n = this.m_needFlags;
        if ((n & 0x101) != 0) {
            MapObject mapObject = this.m_scene.findRandomObjectByType(4);
            this.beginSimAction(165, mapObject);
            return;
        }
        if (this.m_scene.getContextMenuObject() == this || this.getType() == 0 && this.m_scene.getContextMenuObject() != null) {
            return;
        }
        if (this.m_lastConversationTimer == -1 && (this.m_needFlags & 0x20) != 0 && (this.getId() != 0 || appEngine.getAutonomityEnabled() && this.m_scene.isPlayerInactive()) && (this.getId() == 0 || (this.m_needFlags & 4) == 0) && this.checkNeedChat()) {
            return;
        }
        if ((n & 0x5E) != 0) {
            int n2 = appEngine.rand(0, GENERIC_NEEDS.length - 1);
            if ((n & 4) != 0) {
                n2 = AppEngine.indexOf(4, GENERIC_NEEDS);
            }
            for (int i = 0; i < GENERIC_NEEDS.length; ++i) {
                MapObject mapObject;
                int n3 = GENERIC_NEEDS[n2];
                if ((n & n3) != 0 && (mapObject = this.m_scene.findRandomNeedObject(n3)) != null) {
                    SimWorld simWorld = this.getSimWorld();
                    int n4 = mapObject.getType();
                    short s = simWorld.getObjectActions(n4)[0];
                    this.beginSimAction(s, mapObject);
                    int n5 = simWorld.getObjectNeed(n4);
                    this.m_needFlags &= ~n5;
                    return;
                }
                n2 = (n2 + 1) % GENERIC_NEEDS.length;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean checkNeedChat() {
        int n;
        MapObjectSim mapObjectSim;
        AppEngine appEngine;
        block9: {
            int n2;
            appEngine = this.m_engine;
            SimData simData = this.getSimData();
            mapObjectSim = null;
            if (this.m_conversationSim != -1 && !this.checkNeedChatSim(mapObjectSim = this.m_scene.findSim(this.m_conversationSim))) {
                mapObjectSim = null;
            }
            if (simData.getSimHome(n2 = this.getId()) != this.getSimWorld().getHouseId() && !simData.getSimCurRelStateFlags(n2, 1) && (n2 != 0 || appEngine.getAutonomityEnabled())) {
                if ((this.m_needFlags & 0x200) == 0) {
                    MapObject mapObject = this.m_scene.findRandomObjectByParentType(10);
                    if (mapObject != null) {
                        this.beginSimAction(154, mapObject);
                        this.m_scene.DEBUG_EVENT("knocking on door");
                        this.m_needFlags |= 0x200;
                        return true;
                    }
                    break block9;
                } else {
                    if (n2 != 0) {
                        if (this.m_simStateTime <= 30000) return true;
                        this.m_scene.DEBUG_EVENT("leaving...");
                        this.m_needFlags |= 0x100;
                        return true;
                    }
                    this.m_needFlags &= 0xFFFFFDFF;
                    return true;
                }
            }
            this.m_needFlags &= 0xFFFFFDFF;
        }
        if (mapObjectSim == null) {
            MapObjectSim[] mapObjectSimArray = this.m_scene.getSimObjects();
            n = mapObjectSimArray.length;
            int n3 = appEngine.rand(0, n - 1);
            for (int i = 0; i < n; ++i) {
                MapObjectSim mapObjectSim2 = mapObjectSimArray[n3];
                n3 = (n3 + 1) % mapObjectSimArray.length;
                if (!this.checkNeedChatSim(mapObjectSim2)) {
                    continue;
                }
                mapObjectSim = mapObjectSim2;
                break;
            }
        }
        if (mapObjectSim == null) return false;
        int n4 = appEngine.randPercent();
        n = n4 < 30 ? 65 : (n4 < 70 ? 92 : 78);
        this.beginSimAction(n, mapObjectSim);
        return true;
    }

    private final boolean checkNeedChatSim(MapObjectSim mapObjectSim) {
        if (mapObjectSim == this || mapObjectSim == null) {
            return false;
        }
        MapObject mapObject = this.m_scene.getContextMenuObject();
        if (mapObjectSim == mapObject) {
            return false;
        }
        if (mapObjectSim.getId() == 0 && mapObject != null) {
            return false;
        }
        if (mapObjectSim.isSleeping()) {
            return false;
        }
        if (mapObjectSim.m_conversationSim != -1 && mapObjectSim.m_conversationSim != this.getId()) {
            return false;
        }
        if (mapObjectSim.getRuntimeFlag(8)) {
            return false;
        }
        return !mapObjectSim.getRuntimeFlag(1024) || this.getSimData().hasSimGotTrait(this.getId(), 12) != -1;
    }

    public final void clearNeedFlags() {
        this.m_needFlags = 0;
    }

    public final void setNeedFlag(int n) {
        this.m_needFlags |= n;
    }

    public final void startBuff(int n) {
        switch (n) {
            case 9: {
                this.setRuntimeFlag(1024);
                if (this.m_scene.isMapMode()) break;
                this.setEffectAnimId(44);
                this.setSecondaryAnim(41, 20);
                break;
            }
            case 6: {
                this.setRuntimeFlag(2048);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                this.setRuntimeFlag(4096);
            }
        }
    }

    public final void endBuff(int n) {
        switch (n) {
            case 9: {
                this.unsetRuntimeFlag(1024);
                if (this.m_scene.isMapMode()) break;
                this.setEffectAnimId(-1);
                this.stopSecondaryAnim();
                break;
            }
            case 6: {
                this.unsetRuntimeFlag(2048);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                this.unsetRuntimeFlag(4096);
            }
        }
    }

    private void recheckBuffEffects() {
        if (this.getRuntimeFlag(1024)) {
            this.startBuff(9);
        }
    }

    public final void setConversation(MapObjectSim mapObjectSim) {
        this.m_conversationSim = mapObjectSim.getId();
        this.m_lastConversationTimer = -1;
        this.setNeedFlag(32);
        mapObjectSim.m_conversationSim = this.getId();
        mapObjectSim.m_lastConversationTimer = -1;
        mapObjectSim.setNeedFlag(32);
    }

    private final void clearConversation() {
        MapObjectSim mapObjectSim = this.m_scene.findSim(this.m_conversationSim);
        if (mapObjectSim != null) {
            mapObjectSim.m_needFlags &= 0xFFFFFFDF;
            mapObjectSim.m_conversationSim = -1;
            mapObjectSim.m_conversationTimer = 0;
            mapObjectSim.m_lastConversationTimer = 0;
        }
        this.m_needFlags &= 0xFFFFFFDF;
        this.m_conversationSim = -1;
        this.m_conversationTimer = 0;
        this.m_lastConversationTimer = 0;
    }

    private final boolean hasCar() {
        SimData simData = this.getSimData();
        int n = simData.getSimCareer(this.getId());
        if (n != -1) {
            boolean bl;
            int n2 = simData.getSimCareerLevel(this.getId());
            boolean bl2 = bl = (simData.getCareerLevelFlags(n, n2) & 1) != 0;
            if (bl) {
                return true;
            }
        }
        if (this.getType() == 0 && simData.getInventoryCount(40) != 0) {
            return true;
        }
        return simData.hasSimGotFlag(this.getId(), 1);
    }

    public void gotoSleep(MapObject mapObject) {
        AppEngine.ASSERT(mapObject != null, "can't sleep on null");
        boolean bl = this.setOccupied(mapObject);
        AppEngine.ASSERT(bl, "couldn't get occupied flag for bed");
        int[] nArray = MapObject.s_tempInt10;
        mapObject.getInterestPoint(nArray, this.m_occupiedIndex);
        this.setPos(nArray[0], nArray[1]);
        this.setFacingObject(mapObject);
        this.setFacingDir((this.getFacingDir() + 2) % 4);
        this.m_posture = 4;
        this.m_targetPosture = 4;
        this.m_postureObject = mapObject;
        mapObject.setPostRenderTarget(this);
        if (this.getId() == 0) {
            this.m_scene.snapCameraAndCursor(mapObject);
        }
        this.beginSimAction(124, mapObject);
    }

    private final void DEBUG_SIM(String string) {
    }
}

