/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.pizza.views;

import com.rocktasticgames.pizza.animated.AnimatedDelivery;
import com.rocktasticgames.pizza.animated.AnimatedElement;
import com.rocktasticgames.pizza.animated.AnimatedOrder;
import com.rocktasticgames.pizza.animated.Appliance;
import com.rocktasticgames.pizza.animated.CookItem;
import com.rocktasticgames.pizza.animated.MenuItem;
import com.rocktasticgames.pizza.animated.OrderItem;
import com.rocktasticgames.pizza.animated.StatusBar;
import com.rocktasticgames.pizza.c2m.C2MValues;
import com.rocktasticgames.pizza.main.MainActivity;
import com.rocktasticgames.pizza.utils.List;
import com.rocktasticgames.pizza.utils.MotionEvent;
import com.rocktasticgames.pizza.views.MenuView;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class KitchenView {
    public static final int LINES_PER_DIALOG = 3;
    private Image background;
    private Image note;
    private Image[] orderbmps;
    private MainActivity activity;
    private AnimatedElement scene;
    private StatusBar topbar;
    private AnimatedElement pause;
    private AnimatedElement twood;
    private AnimatedElement bwood;
    private AnimatedElement map;
    private AnimatedElement kitchen;
    private Appliance oven1;
    private Appliance oven2;
    private Appliance salad;
    private Appliance drink;
    private Appliance dessert;
    private AnimatedElement appboard;
    private AnimatedElement appnext;
    private AnimatedElement appprev;
    private AnimatedElement appok;
    private AnimatedElement apptrash;
    private AnimatedElement apptitle;
    private AnimatedElement appplus;
    private Image appempty;
    private Image appready;
    private Image appslotup;
    private MenuItem[] appmenu;
    private MenuItem[] appmenuold;
    private AnimatedElement ordercanv;
    private AnimatedElement orderok;
    private List orderitems;
    private boolean loaded = false;
    private boolean apploaded = false;
    private boolean orderloaded = false;
    private boolean upgradeloaded = false;
    private List aelist;
    private List appliances;
    private List menus;
    private List overmenu;
    private int select_option = 0;
    private AnimatedOrder select_order = null;
    private AnimatedOrder on_order = null;
    private Appliance select_appliance = null;
    private int select_menu = -1;
    private int select_slot = -1;
    private int on_slot = -1;
    private long last_time;
    private int pageoffset = 0;
    private float clickx = -1.0f;
    private List deliveries;
    private boolean deliveryloaded = false;
    private AnimatedElement deliverycanv;
    private AnimatedElement deliveryno;
    private int select_delivery = -1;
    private Image exclamation;
    private Image warning;
    private AnimatedElement upcanv;
    private AnimatedElement upimg;
    private AnimatedElement upback;
    private AnimatedElement upupgrade;
    private boolean upgrade_isfortime = false;
    private int upgrade_cost;
    private String upgrade_res;
    private boolean app_canaddslot = false;
    private boolean app_canupgrade = false;
    private boolean isslotasupgrade = false;
    private boolean dialogloaded = false;
    private String[] dialog_lines;
    private int dialog_index;
    private String dialog_res;
    private AnimatedElement dialog_box;
    private AnimatedElement dialog_img;
    private AnimatedElement dialog_btn;
    private boolean dialog_to_upgrade = false;
    private boolean dialog_to_app = false;
    private boolean dialog_to_dessert = false;
    private boolean dialog_to_salad = false;
    private boolean dialog_to_order = false;
    private Image mininote;
    private Image nitem;
    private boolean options_loaded = false;
    private AnimatedElement optioncanv;
    private AnimatedElement quit;
    private AnimatedElement music;
    private AnimatedElement sound;
    private AnimatedElement back;
    private boolean leveluploaded = false;
    private AnimatedElement leveluppanel;
    private AnimatedElement levelupowner;
    private AnimatedElement levelupstar;
    private AnimatedElement levelupok;
    private boolean isvictory = false;
    private AnimatedElement post_dialog_target = null;

    public KitchenView(MainActivity mainActivity) {
        this.activity = mainActivity;
        this.x3Init();
    }

    public void x3Init() {
        if (this.activity == null) {
            return;
        }
        this.aelist = new List();
        this.appliances = new List();
        this.menus = new List();
        this.overmenu = new List();
        this.orderitems = new List();
        try {
            this.background = Image.createImage((String)"/background.png");
            this.note = Image.createImage((String)"/pizzaorder_notebase_v2.png");
            this.exclamation = Image.createImage((String)"/completion_exclamation.png");
            this.warning = Image.createImage((String)"/warning_exclamation.png");
            this.nitem = Image.createImage((String)("/" + this.activity.getLanguageCode() + "newitem.png"));
            this.mininote = Image.createImage((String)"/mininote.png");
            this.orderbmps = new Image[]{Image.createImage((String)("/" + this.activity.getLanguageCode() + "text_new.png")), Image.createImage((String)("/" + this.activity.getLanguageCode() + "text_working.png")), Image.createImage((String)("/" + this.activity.getLanguageCode() + "text_ready.png")), Image.createImage((String)("/" + this.activity.getLanguageCode() + "text_failed.png")), Image.createImage((String)"/smiley_happy.png"), Image.createImage((String)"/smiley_neutral.png"), Image.createImage((String)"/smiley_sad.png"), Image.createImage((String)"/timebar_empty.png")};
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.appmenu = new MenuItem[6];
        this.appmenuold = new MenuItem[6];
        this.last_time = this.activity.getTime();
        for (int i = 0; i < this.activity.getOrders().size(); ++i) {
            ((AnimatedOrder)this.activity.getOrders().get(i)).setPNG(this.note);
            ((AnimatedOrder)this.activity.getOrders().get(i)).setBMPS(this.orderbmps);
        }
    }

    public void destroy() {
        this.background = null;
        this.note = null;
        this.exclamation = null;
        this.warning = null;
        this.orderbmps = null;
        if (this.topbar != null) {
            this.pause = null;
            this.kitchen = null;
            this.map = null;
            this.topbar = null;
        }
        if (this.apploaded) {
            this.unloadApp();
        } else if (this.orderloaded) {
            this.unloadOrder();
        } else if (this.upgradeloaded) {
            this.unloadUpgrade();
        }
        if (this.dialogloaded) {
            this.unloadDialog();
        }
        if (this.options_loaded) {
            this.unloadOptions();
        }
        if (this.leveluploaded) {
            this.unloadLevelUp();
        }
        System.gc();
    }

    public AnimatedElement traverse(AnimatedElement animatedElement, int n) {
        boolean bl = false;
        int n2 = -1;
        if (!(!this.activity.isPaused() || this.upgradeloaded || this.dialogloaded || this.options_loaded || this.leveluploaded)) {
            return this.pause;
        }
        if (this.leveluploaded) {
            return this.levelupok;
        }
        if (this.dialogloaded) {
            return this.dialog_btn;
        }
        switch (n) {
            case 1: {
                if (this.options_loaded) {
                    if (animatedElement == this.back) {
                        return this.sound;
                    }
                    return this.quit;
                }
                if (this.orderloaded) {
                    if (animatedElement == this.orderok || animatedElement == this.deliveryno) {
                        return this.pause;
                    }
                    if (this.deliveryloaded) {
                        if (animatedElement == this.map) {
                            for (int i = 0; i < this.deliveries.size(); ++i) {
                                if (this.activity.getDeliveryState(i) >= 2) continue;
                                return (AnimatedElement)this.deliveries.get(i);
                            }
                        }
                        return this.deliveryno;
                    }
                    if (animatedElement == this.map) {
                        if (this.on_order != null) {
                            return this.on_order;
                        }
                        if (this.activity.getOrders().size() > 0) {
                            return (AnimatedElement)this.activity.getOrders().get(0);
                        }
                    }
                    return this.orderok;
                }
                if (this.apploaded) {
                    int n3;
                    if (animatedElement == this.map) {
                        if (this.activity.getOrders().size() > 0) {
                            return (AnimatedElement)this.activity.getOrders().get(0);
                        }
                        return this.appok;
                    }
                    for (n3 = 0; n3 < this.activity.getOrders().size(); ++n3) {
                        if (animatedElement != this.activity.getOrders().get(n3)) continue;
                        return this.appok;
                    }
                    for (n3 = 0; n3 < 3; ++n3) {
                        if (animatedElement != this.activity.getCooking(this.getAppCode(this.select_appliance))[n3]) continue;
                        bl = true;
                    }
                    if (animatedElement == this.appok || animatedElement == this.apptrash || bl) {
                        if (this.appmenu[4] != null) {
                            return this.appmenu[4];
                        }
                        if (this.appmenu[1] != null) {
                            return this.appmenu[1];
                        }
                        return this.appmenu[0];
                    }
                    if (animatedElement == this.appprev) {
                        return this.appmenu[0];
                    }
                    if (animatedElement == this.appnext) {
                        if (this.appmenu[2] != null) {
                            return this.appmenu[2];
                        }
                        if (this.appmenu[1] != null) {
                            return this.appmenu[1];
                        }
                        return this.appmenu[0];
                    }
                    for (n3 = 0; n3 < this.appmenu.length; ++n3) {
                        if (this.appmenu[n3] == null || animatedElement != this.appmenu[n3]) continue;
                        if (n3 > 2) {
                            return this.appmenu[n3 - 3];
                        }
                        if (this.appplus != null) {
                            return this.appplus;
                        }
                        return this.pause;
                    }
                    return this.pause;
                }
                if (this.upgradeloaded) {
                    if (animatedElement == this.upupgrade) {
                        return this.upupgrade;
                    }
                    if (animatedElement == this.upback) {
                        return this.upback;
                    }
                }
                if (animatedElement == this.pause) {
                    return this.pause;
                }
                if (animatedElement == this.map) {
                    if (this.activity.getOrders().size() > 0) {
                        return (AnimatedElement)this.activity.getOrders().get(0);
                    }
                    return this.oven1;
                }
                for (int i = 0; i < this.activity.getOrders().size(); ++i) {
                    if (animatedElement != this.activity.getOrders().get(i)) continue;
                    return this.oven1;
                }
                return this.pause;
            }
            case 6: {
                if (this.options_loaded) {
                    if (animatedElement == this.quit) {
                        return this.sound;
                    }
                    return this.back;
                }
                if (this.orderloaded) {
                    if (this.deliveryloaded) {
                        if (animatedElement == this.pause) {
                            return this.deliveryno;
                        }
                        if (animatedElement == this.deliveryno) {
                            for (int i = 0; i < this.deliveries.size(); ++i) {
                                if (this.activity.getDeliveryState(i) >= 2) continue;
                                return (AnimatedElement)this.deliveries.get(i);
                            }
                        }
                        return this.map;
                    }
                    if (animatedElement == this.pause) {
                        return this.orderok;
                    }
                    if (animatedElement == this.orderok) {
                        if (this.on_order != null) {
                            return this.on_order;
                        }
                        if (this.activity.getOrders().size() > 0) {
                            return (AnimatedElement)this.activity.getOrders().get(0);
                        }
                    }
                    return this.map;
                }
                if (animatedElement == this.map) {
                    return this.map;
                }
                if (this.apploaded) {
                    int n4;
                    if (animatedElement == this.pause && this.appplus != null) {
                        return this.appplus;
                    }
                    if (animatedElement == this.pause || animatedElement == this.appplus && this.appplus != null) {
                        if (this.appmenu[1] != null) {
                            return this.appmenu[1];
                        }
                        return this.appmenu[0];
                    }
                    for (n4 = 0; n4 < this.activity.getOrders().size(); ++n4) {
                        if (animatedElement != this.activity.getOrders().get(n4)) continue;
                        return this.map;
                    }
                    for (n4 = 0; n4 < 3; ++n4) {
                        if (animatedElement != this.activity.getCooking(this.getAppCode(this.select_appliance))[n4]) continue;
                        bl = true;
                    }
                    if (animatedElement == this.appok || animatedElement == this.apptrash || bl) {
                        if (this.activity.getOrders().size() > 0) {
                            return (AnimatedOrder)this.activity.getOrders().get(0);
                        }
                        return this.map;
                    }
                    if (animatedElement == this.appprev) {
                        if (this.appmenu[3] != null) {
                            return this.appmenu[3];
                        }
                        return this.appok;
                    }
                    if (animatedElement == this.appnext) {
                        if (this.appmenu[5] != null) {
                            return this.appmenu[5];
                        }
                        if (this.appmenu[4] != null) {
                            return this.appmenu[4];
                        }
                        if (this.appmenu[3] != null) {
                            return this.appmenu[3];
                        }
                        return this.appok;
                    }
                    for (n4 = 0; n4 < this.appmenu.length; ++n4) {
                        if (this.appmenu[n4] == null || animatedElement != this.appmenu[n4]) continue;
                        if (n4 < 3 && this.appmenu[n4 + 3] != null) {
                            return this.appmenu[n4 + 3];
                        }
                        return this.appok;
                    }
                    return this.map;
                }
                if (this.upgradeloaded) {
                    if (animatedElement == this.upupgrade) {
                        return this.upupgrade;
                    }
                    if (animatedElement == this.upback) {
                        return this.upback;
                    }
                }
                if (animatedElement == this.pause) {
                    return this.oven1;
                }
                if (animatedElement == this.oven1 || animatedElement == this.oven2 || animatedElement == this.drink || animatedElement == this.salad || animatedElement == this.dessert) {
                    if (this.activity.getOrders().size() > 0) {
                        return (AnimatedElement)this.activity.getOrders().get(0);
                    }
                    return this.map;
                }
                return this.map;
            }
            case 5: {
                int n5;
                if (this.options_loaded) {
                    return animatedElement;
                }
                if (animatedElement == this.pause) {
                    return this.pause;
                }
                if (animatedElement == this.map) {
                    return this.map;
                }
                if (this.upgradeloaded) {
                    if (animatedElement == this.upupgrade) {
                        return this.upback;
                    }
                    if (animatedElement == this.upback) {
                        return this.upback;
                    }
                }
                if (animatedElement == this.appplus && this.appplus != null) {
                    return this.appplus;
                }
                if (this.orderloaded) {
                    int n6;
                    if (animatedElement == this.orderok) {
                        return this.orderok;
                    }
                    if (animatedElement == this.deliveryno) {
                        return this.deliveryno;
                    }
                    if (this.deliveryloaded) {
                        for (n6 = 0; n6 < this.deliveries.size(); ++n6) {
                            if (animatedElement != this.deliveries.get(n6)) continue;
                            ++n6;
                            while (n6 < this.deliveries.size()) {
                                if (this.activity.getDeliveryState(n6) < 2) {
                                    return (AnimatedElement)this.deliveries.get(n6);
                                }
                                ++n6;
                            }
                            return animatedElement;
                        }
                    }
                    for (n6 = 0; n6 < this.activity.getOrders().size(); ++n6) {
                        if (animatedElement != this.activity.getOrders().get(n6)) continue;
                        return (AnimatedOrder)this.activity.getOrders().get(Math.min(n6 + 1, this.activity.getOrders().size() - 1));
                    }
                    return this.map;
                }
                for (n5 = 0; n5 < this.activity.getOrders().size(); ++n5) {
                    if (animatedElement != this.activity.getOrders().get(n5)) continue;
                    return (AnimatedOrder)this.activity.getOrders().get(Math.min(n5 + 1, this.activity.getOrders().size() - 1));
                }
                if (this.apploaded) {
                    if (animatedElement == this.appprev) {
                        return this.appmenu[0];
                    }
                    if (animatedElement == this.appnext) {
                        this.appNext(this.last_time);
                        return this.appmenu[0];
                    }
                    for (n5 = 0; n5 < this.appmenu.length; ++n5) {
                        if (this.appmenu[n5] == null || animatedElement != this.appmenu[n5]) continue;
                        if (n5 % 3 == 2) {
                            if (this.appnext.isAnimatingOut()) {
                                return this.appmenu[n5];
                            }
                            return this.appnext;
                        }
                        if (this.appmenu[n5 + 1] == null) {
                            if (this.appnext.isAnimatingOut()) {
                                return this.appmenu[n5];
                            }
                            return this.appnext;
                        }
                        return this.appmenu[n5 + 1];
                    }
                    for (n5 = 0; n5 < 3; ++n5) {
                        if (animatedElement != this.activity.getCooking(this.getAppCode(this.select_appliance))[n5]) continue;
                        n2 = n5 + 1;
                    }
                    if (animatedElement == this.apptrash) {
                        n2 = 4;
                    }
                    if (animatedElement == this.appok) {
                        n2 = 0;
                    }
                    ++n2;
                    while (n2 < 4) {
                        if (this.activity.getCooking(this.getAppCode(this.select_appliance))[n2 - 1] != null && (this.activity.getCooking(this.getAppCode(this.select_appliance))[n2 - 1].isSelectable() || this.activity.getCooking(this.getAppCode(this.select_appliance))[n2 - 1].isPlus())) {
                            return this.activity.getCooking(this.getAppCode(this.select_appliance))[n2 - 1];
                        }
                        ++n2;
                    }
                    if (this.on_slot == -1) {
                        return animatedElement;
                    }
                    return this.apptrash;
                }
                if (animatedElement == this.pause) {
                    return this.pause;
                }
                if (animatedElement == this.map) {
                    return this.map;
                }
                if (animatedElement == this.oven1 || animatedElement == this.oven2 || animatedElement == this.drink || animatedElement == this.salad || animatedElement == this.dessert) {
                    for (n5 = 1; n5 <= 5; ++n5) {
                        if (this.getAppliance((this.getAppCode((Appliance)animatedElement) + n5) % 5) == null) continue;
                        return this.getAppliance((this.getAppCode((Appliance)animatedElement) + n5) % 5);
                    }
                }
                return this.map;
            }
            case 2: {
                int n7;
                if (this.options_loaded) {
                    return animatedElement;
                }
                if (animatedElement == this.pause) {
                    return this.pause;
                }
                if (animatedElement == this.map) {
                    return this.map;
                }
                if (this.upgradeloaded) {
                    if (animatedElement == this.upupgrade) {
                        return this.upupgrade;
                    }
                    if (animatedElement == this.upback) {
                        return this.upupgrade;
                    }
                }
                if (animatedElement == this.appplus && this.appplus != null) {
                    return this.appplus;
                }
                if (this.orderloaded) {
                    int n8;
                    if (animatedElement == this.orderok) {
                        return this.orderok;
                    }
                    if (animatedElement == this.deliveryno) {
                        return this.deliveryno;
                    }
                    if (this.deliveryloaded) {
                        for (n8 = 0; n8 < this.deliveries.size(); ++n8) {
                            if (animatedElement != this.deliveries.get(n8)) continue;
                            --n8;
                            while (n8 >= 0) {
                                if (this.activity.getDeliveryState(n8) < 2) {
                                    return (AnimatedElement)this.deliveries.get(n8);
                                }
                                --n8;
                            }
                            return animatedElement;
                        }
                    }
                    for (n8 = 0; n8 < this.activity.getOrders().size(); ++n8) {
                        if (animatedElement != this.activity.getOrders().get(n8)) continue;
                        return (AnimatedOrder)this.activity.getOrders().get(Math.max(n8 - 1, 0));
                    }
                    return this.map;
                }
                for (n7 = 0; n7 < this.activity.getOrders().size(); ++n7) {
                    if (animatedElement != this.activity.getOrders().get(n7)) continue;
                    return (AnimatedOrder)this.activity.getOrders().get(Math.max(n7 - 1, 0));
                }
                if (this.apploaded) {
                    if (animatedElement == this.appprev) {
                        this.appPrev(this.last_time);
                        if (this.appmenu[2] != null) {
                            return this.appmenu[2];
                        }
                        if (this.appmenu[1] != null) {
                            return this.appmenu[1];
                        }
                        return this.appmenu[0];
                    }
                    if (animatedElement == this.appnext) {
                        if (this.appmenu[2] != null) {
                            return this.appmenu[2];
                        }
                        if (this.appmenu[1] != null) {
                            return this.appmenu[1];
                        }
                        return this.appmenu[0];
                    }
                    for (n7 = 0; n7 < this.appmenu.length; ++n7) {
                        if (this.appmenu[n7] == null || animatedElement != this.appmenu[n7]) continue;
                        if (n7 % 3 == 0) {
                            if (this.appprev.isAnimatingOut()) {
                                return this.appmenu[n7];
                            }
                            return this.appprev;
                        }
                        return this.appmenu[n7 - 1];
                    }
                    for (n7 = 0; n7 < 3; ++n7) {
                        if (animatedElement != this.activity.getCooking(this.getAppCode(this.select_appliance))[n7]) continue;
                        n2 = n7 + 1;
                    }
                    if (animatedElement == this.apptrash) {
                        n2 = 4;
                    }
                    if (animatedElement == this.appok) {
                        n2 = 0;
                    }
                    --n2;
                    while (n2 > 0) {
                        if (this.activity.getCooking(this.getAppCode(this.select_appliance))[n2 - 1] != null && (this.activity.getCooking(this.getAppCode(this.select_appliance))[n2 - 1].isSelectable() || this.activity.getCooking(this.getAppCode(this.select_appliance))[n2 - 1].isPlus())) {
                            return this.activity.getCooking(this.getAppCode(this.select_appliance))[n2 - 1];
                        }
                        --n2;
                    }
                    return this.appok;
                }
                if (animatedElement == this.pause) {
                    return this.pause;
                }
                if (animatedElement == this.map) {
                    return this.map;
                }
                if (animatedElement == this.oven1 || animatedElement == this.oven2 || animatedElement == this.drink || animatedElement == this.salad || animatedElement == this.dessert) {
                    for (n7 = 1; n7 <= 5; ++n7) {
                        if (this.getAppliance((this.getAppCode((Appliance)animatedElement) + 5 - n7) % 5) == null) continue;
                        return this.getAppliance((this.getAppCode((Appliance)animatedElement) + 5 - n7) % 5);
                    }
                }
                for (n7 = 0; n7 < this.activity.getOrders().size(); ++n7) {
                    if (animatedElement != this.activity.getOrders().get(n7)) continue;
                    return (AnimatedOrder)this.activity.getOrders().get(Math.max(n7 - 1, 0));
                }
                return this.map;
            }
        }
        return animatedElement;
    }

    public void loadLevelUp(float f, float f2, float f3) {
        this.activity.pause();
        long l = this.last_time;
        this.leveluppanel = new AnimatedElement(this.activity, "panel_levelup", 0.5f, this.scene.getY(0L) / f3 + 0.2063802f * f, f2, f3, 0, l);
        this.levelupowner = new AnimatedElement(this.activity, "shop_and_owner", 0.5f, this.scene.getY(0L) / f3 + -0.140625f * f, f2, f3, 0, l);
        this.levelupstar = new AnimatedElement(this.activity, "star", 0.5f, this.scene.getY(0L) / f3 + 0.22526042f * f, f2, f3, 0, l);
        this.levelupok = new AnimatedElement(this.activity, "button_dialogueok", 0.5f, this.scene.getY(0L) / f3 + 0.36002603f * f, f2, f3, 0, l);
        this.overmenu.addAll(new AnimatedElement[]{this.levelupowner, this.leveluppanel, this.levelupstar, this.levelupok});
        this.leveluploaded = true;
    }

    public void unloadLevelUp() {
        this.activity.resume();
        this.leveluploaded = false;
        this.overmenu.removeAll(new AnimatedElement[]{this.levelupowner, this.leveluppanel, this.levelupstar, this.levelupok});
        this.levelupowner.recycle();
        this.leveluppanel.recycle();
        this.levelupstar.recycle();
        this.levelupok.recycle();
        this.applianceInit();
        this.activity.checkMessage(14);
    }

    public void applianceInit() {
        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
        float f2 = this.background.getWidth();
        float f3 = (float)this.activity.getCanvas().getHeight() / f;
        if (this.activity.getAppSlots(3) > 0 && !this.activity.getSharedPref().getBoolean("salad_shown", false)) {
            if (this.apploaded) {
                this.unloadApp();
            } else if (this.orderloaded) {
                this.unloadOrder();
            }
            this.dialog_to_salad = true;
            this.select_option = 0;
            this.loadDialog(f2 / f3, f2, f3, "dialogue_chefluc", C2MValues.SALAD_AVAILABLE_MESSAGE[this.activity.getLanguage()]);
            this.activity.getPrefEditor().putBoolean("salad_shown", true);
            this.activity.getPrefEditor().commit();
        } else if (this.activity.getAppSlots(4) > 0 && !this.activity.getSharedPref().getBoolean("dessert_shown", false)) {
            if (this.apploaded) {
                this.unloadApp();
            } else if (this.orderloaded) {
                this.unloadOrder();
            }
            this.dialog_to_dessert = true;
            this.select_option = 0;
            this.loadDialog(f2 / f3, f2, f3, "dialogue_ownerpatti", C2MValues.DESSERT_AVAILABLE_MESSAGE[this.activity.getLanguage()]);
            this.activity.getPrefEditor().putBoolean("dessert_shown", true);
            this.activity.getPrefEditor().commit();
        }
    }

    public void onLevelUp() {
        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
        float f2 = this.background.getWidth();
        float f3 = (float)this.activity.getCanvas().getHeight() / f;
        if (this.apploaded) {
            this.unloadApp();
            this.loadApp(f2 / f3, f2, f3);
        }
        this.loadLevelUp(f2 / f3, f2, f3);
    }

    public void onVictory() {
        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
        float f2 = this.background.getWidth();
        float f3 = (float)this.activity.getCanvas().getHeight() / f;
        float f4 = f2 / f3;
        this.activity.pause();
        long l = this.last_time;
        this.leveluppanel = new AnimatedElement(this.activity, "panel_victory", 0.5f, this.scene.getY(0L) / f3 + 0.23828125f * f4, f2, f3, 0, l);
        this.levelupowner = new AnimatedElement(this.activity, "shop_and_owner", 0.5f, this.scene.getY(0L) / f3 + -0.140625f * f4, f2, f3, 0, l);
        this.levelupstar = new AnimatedElement(this.activity, "star", 0.0f, 0.0f, f2, f3, 0, l);
        this.levelupok = new AnimatedElement(this.activity, "button_dialogueok", 0.5f, this.scene.getY(0L) / f3 + 0.421875f * f4, f2, f3, 0, l);
        this.overmenu.addAll(new AnimatedElement[]{this.levelupowner, this.leveluppanel, this.levelupok});
        this.leveluploaded = true;
        this.isvictory = true;
    }

    public Appliance getSelectedAppliance() {
        return this.select_appliance;
    }

    public void registerOrder(AnimatedOrder animatedOrder) {
        animatedOrder.setBMPS(this.orderbmps);
        animatedOrder.setPNG(this.note);
    }

    private void loadResources(float f, float f2, float f3) {
        this.activity.registerDimensions(f2, f3);
        long l = this.last_time;
        this.scene = new AnimatedElement(this.background, 0.5f, 0.40185547f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.38484073f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.topbar = new StatusBar(this.activity, this.activity.topbar, 0.44596353f, 0.046875f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.05346027f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.pause = new AnimatedElement(this.activity.pausebutton, 0.9433594f, 0.046875f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.05346027f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.kitchen = new AnimatedElement(this.activity.kitchenbutton, 0.24869792f, 0.9238281f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.91175395f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.map = new AnimatedElement(this.activity.mapbutton, 0.75130206f, 0.9238281f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.91175395f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.bwood = new AnimatedElement(this.activity.wood, 0.5f, 0.8847656f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.8293665f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.twood = new AnimatedElement(0.5f, -0.1274414f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) - 0.062614426f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.twood.setPNG(this.activity.wood);
        this.aelist.addAll(new AnimatedElement[]{this.scene, this.bwood, this.twood, this.topbar, this.pause, this.kitchen, this.map});
        this.loadOven1(f, f2, f3, l);
        this.loadOven2(f, f2, f3, l);
        this.loadDrink(f, f2, f3, l);
        this.loadSalad(f, f2, f3, l);
        this.loadDessert(f, f2, f3, l);
        this.activity.getCanvas().setFocus(this.map);
        this.loaded = true;
        this.applianceInit();
    }

    public boolean goBack() {
        this.activity.invalidate();
        if (this.orderloaded && !this.activity.isPaused()) {
            this.unloadOrder();
            this.on_order = null;
            this.select_order = null;
            if (this.deliveryloaded) {
                this.unloadDelivery();
            }
            return true;
        }
        if (this.apploaded && !this.activity.isPaused()) {
            this.unloadApp();
            this.select_appliance = null;
            return true;
        }
        if (this.upgradeloaded) {
            this.unloadUpgrade();
            return true;
        }
        if (this.leveluploaded) {
            this.unloadLevelUp();
            return true;
        }
        if (this.dialogloaded) {
            this.unloadDialog();
            return true;
        }
        if (!this.activity.isPaused()) {
            this.activity.togglePause();
            float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
            float f2 = this.background.getWidth();
            float f3 = (float)this.activity.getCanvas().getHeight() / f;
            this.loadOptions(f2 / f3, f2, f3, System.currentTimeMillis());
            return true;
        }
        this.activity.togglePause();
        this.unloadOptions();
        return true;
    }

    private void loadDialog(float f, float f2, float f3, String string, String string2) {
        this.post_dialog_target = this.activity.getCanvas().getFocus();
        this.activity.pause();
        if (this.dialogloaded) {
            this.unloadDialog();
        }
        this.dialog_res = string;
        this.dialog_index = 0;
        int n = 1;
        float f4 = 0.0f;
        string2 = string2.toUpperCase();
        string2 = string2 + " ";
        int n2 = 0;
        while (n2 + 1 < string2.length()) {
            if (f4 + (float)this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1))) < 1160.0f * f2 / 1536.0f) {
                f4 += (float)this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1)));
            } else {
                f4 = this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1)));
                ++n;
            }
            n2 = string2.indexOf(" ", n2 + 1);
        }
        this.dialog_lines = new String[n];
        this.dialog_lines[0] = " ";
        n = 0;
        f4 = 0.0f;
        n2 = 0;
        while (n2 + 1 < string2.length()) {
            if (f4 + (float)this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1))) < 1160.0f * f2 / 1536.0f) {
                f4 += (float)this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1)));
                int n3 = n;
                this.dialog_lines[n3] = this.dialog_lines[n3] + string2.substring(n2, string2.indexOf(" ", n2 + 1));
            } else {
                f4 = this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1)));
                this.dialog_lines[++n] = string2.substring(n2, string2.indexOf(" ", n2 + 1));
            }
            n2 = string2.indexOf(" ", n2 + 1);
        }
        long l = this.last_time;
        this.dialog_box = new AnimatedElement(this.activity, "dialoguebox", 0.5f, this.bwood.getY(0L) / f3 + -0.5449219f * f, f2, f3, 0, l);
        this.dialog_img = new AnimatedElement(this.activity, string, 0.69466144f, this.bwood.getY(0L) / f3 + -0.79752606f * f, f2, f3, 0, l);
        this.dialog_btn = this.dialog_lines.length > 3 ? new AnimatedElement(this.activity, "button_dialoguenext", 0.5f, this.bwood.getY(0L) / f3 + -0.35546875f * f, f2, f3, 0, l) : new AnimatedElement(this.activity, "button_dialogueok", 0.5f, this.bwood.getY(0L) / f3 + -0.35546875f * f, f2, f3, 0, l);
        this.overmenu.addAll(new AnimatedElement[]{this.dialog_img, this.dialog_box, this.dialog_btn});
        this.dialogloaded = true;
        this.activity.getCanvas().setFocus(this.dialog_btn);
    }

    private void unloadDialog() {
        this.overmenu.removeAll(new AnimatedElement[]{this.dialog_img, this.dialog_box, this.dialog_btn});
        this.dialog_img = null;
        this.dialog_box = null;
        this.dialog_btn = null;
        this.dialogloaded = false;
        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
        float f2 = this.background.getWidth();
        float f3 = (float)this.activity.getCanvas().getHeight() / f;
        long l = this.last_time;
        if (this.dialog_to_upgrade) {
            this.dialog_to_upgrade = false;
            this.loadUpgrade(f2 / f3, f2, f3, this.upgrade_res, this.upgrade_cost, this.upgrade_isfortime);
        } else if (this.dialog_to_app) {
            this.dialog_to_app = false;
            this.loadApp(f2 / f3, f2, f3);
            this.activity.resume();
        } else if (this.dialog_to_salad) {
            this.dialog_to_salad = false;
            this.loadSalad(f2 / f3, f2, f3, l);
            this.loadDialog(f2 / f3, f2, f3, "dialogue_ownerpatti", C2MValues.SALAD_INSTALLED_MESSAGE[this.activity.getLanguage()]);
        } else if (this.dialog_to_dessert) {
            this.dialog_to_dessert = false;
            this.loadDessert(f2 / f3, f2, f3, l);
            this.loadDialog(f2 / f3, f2, f3, "dialogue_chefluc", C2MValues.DESSERT_INSTALLED_MESSAGE[this.activity.getLanguage()]);
        } else if (this.dialog_to_order) {
            this.dialog_to_order = false;
            this.loadOrder(f2 / f3, f2, f3);
            this.activity.resume();
        } else {
            this.activity.resume();
            this.activity.getCanvas().setFocus(this.post_dialog_target);
        }
    }

    private void loadUpgrade(float f, float f2, float f3, String string, int n, boolean bl) {
        this.upgrade_cost = n;
        this.upgrade_isfortime = bl;
        long l = this.last_time;
        this.upcanv = new AnimatedElement(this.activity, this.activity.getLanguageCode() + "upgradecanvas", 0.5f, this.scene.getY(0L) / f3 + -0.032552082f * f, f2, f3, 0, l);
        this.upimg = new AnimatedElement(this.activity, string, 0.5f, this.scene.getY(0L) / f3 + -0.055338543f * f, f2, f3, 0, l);
        this.upback = new AnimatedElement(this.activity, "button_back", 0.65690106f, this.scene.getY(0L) / f3 + 0.2298177f * f, f2, f3, 0, l);
        this.upupgrade = new AnimatedElement(this.activity, "button_upgrade", 0.34114584f, this.scene.getY(0L) / f3 + 0.2298177f * f, f2, f3, 0, l);
        this.overmenu.addAll(new AnimatedElement[]{this.upcanv, this.upimg, this.upback, this.upupgrade});
        this.activity.getCanvas().setFocus(this.upupgrade);
        this.upgradeloaded = true;
    }

    private void unloadUpgrade() {
        this.overmenu.removeAll(new AnimatedElement[]{this.upcanv, this.upimg, this.upback, this.upupgrade});
        this.upgradeloaded = false;
    }

    private void loadOrder(float f, float f2, float f3) {
        this.orderloaded = true;
        if (this.on_order.isReady()) {
            this.loadDelivery();
            return;
        }
        long l = this.last_time;
        this.ordercanv = new AnimatedElement(this.activity, "order_sheet_large_canvas_v2", 0.5f, this.scene.getY(0L) / f3 + -0.03515625f * f, f2, f3, 0, l);
        this.orderok = new AnimatedElement(this.activity, "button_ok", 0.2955729f, this.scene.getY(0L) / f3 + 0.25520834f * f, f2, f3, 0, l);
        this.orderitems.clear();
        float f4 = 356.0f;
        for (int i = 0; i < this.on_order.getItems().length; ++i) {
            this.orderitems.add(new OrderItem(this.activity, MainActivity.appitems[this.on_order.getItems()[i][0]][this.on_order.getItems()[i][1]], 0.30208334f, this.scene.getY(0L) / f3 + (f4 - 823.0f) / 2048.0f * 4.0f / 3.0f * f, f2, f3, 0, l, MainActivity.cooknames[this.on_order.getItems()[i][0]][this.on_order.getItems()[i][1]], this.on_order.getItems()[i][2], this.on_order.getItems()[i][3], MainActivity.cookprices[this.on_order.getItems()[i][0]][this.on_order.getItems()[i][1]]));
            f4 += 179.0f;
        }
        this.menus.add(this.ordercanv);
        this.menus.add(this.orderok);
        this.checkMessage(2);
    }

    private void unloadOrder() {
        this.orderloaded = false;
        if (this.deliveryloaded) {
            this.unloadDelivery();
            return;
        }
        this.menus.remove(this.ordercanv);
        this.menus.remove(this.orderok);
        this.ordercanv = null;
        this.orderok = null;
        if (this.select_option != 1) {
            this.checkMessage(3);
        }
    }

    private void loadDelivery() {
        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
        float f2 = this.background.getWidth();
        float f3 = (float)this.activity.getCanvas().getHeight() / f;
        long l = this.last_time;
        this.deliverycanv = new AnimatedElement(this.activity, "choosedriver_canvas", 0.5f, this.bwood.getY(0L) / f3 + -0.37565103f * f2 / f3, f2, f3, 0, l);
        this.deliveryno = new AnimatedElement(this.activity, "button_no", 0.9316406f, this.bwood.getY(0L) / f3 + -0.37565103f * f2 / f3, f2, f3, 0, l);
        this.menus.add(this.deliverycanv);
        this.menus.add(this.deliveryno);
        this.deliveries = new List();
        for (int i = 0; i < this.activity.getDeliverers(); ++i) {
            this.deliveries.add(new AnimatedDelivery(this.activity, MainActivity.delivery_pics[i], this.activity.getEmptyOrder(), this.activity.getFullOrder(), 0.1f + (float)i * 0.2f, this.map.getY(0L) / f3 - 0.2233073f * f2 / f3, f2, f3, 7, 0L, i));
        }
        this.deliveryloaded = true;
        this.checkMessage(10);
    }

    private void unloadDelivery() {
        this.menus.remove(this.deliverycanv);
        this.menus.remove(this.deliveryno);
        this.deliverycanv.recycle();
        this.deliveryno.recycle();
        this.deliveries.clear();
        this.deliveries = null;
        this.deliveryloaded = false;
    }

    private void loadOptions(float f, float f2, float f3, long l) {
        this.optioncanv = new AnimatedElement(this.activity, "options_canvas", 0.5f, f * 800.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.quit = new AnimatedElement(this.activity, this.activity.getLanguageCode() + "button_quitgame", 0.5f, f * 678.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.sound = this.activity.getSharedPref().getBoolean("sound_on", true) ? new AnimatedElement(this.activity, "toggleon_sound", 0.5f, f * 879.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l) : new AnimatedElement(this.activity, "toggleoff_sound", 0.5f, f * 879.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.back = new AnimatedElement(this.activity, "button_back", 0.2578125f, f * 1098.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.overmenu.addAll(new AnimatedElement[]{this.optioncanv, this.quit, this.sound, this.back});
        this.options_loaded = true;
        this.activity.getCanvas().setFocus(this.sound);
    }

    private void unloadOptions() {
        AnimatedElement[] animatedElementArray = new AnimatedElement[]{this.optioncanv, this.quit, this.sound, this.back};
        for (int i = 0; i < animatedElementArray.length; ++i) {
            this.overmenu.remove(animatedElementArray[i]);
            animatedElementArray[i].recycle();
        }
        this.options_loaded = false;
    }

    private void loadApp(float f, float f2, float f3) {
        int n;
        int n2;
        this.appempty = this.activity.appempty;
        this.appready = this.activity.appready;
        long l = this.last_time;
        this.appboard = new AnimatedElement(this.activity.appboard, 0.5f, this.scene.getY(0L) / f3 + -0.031901043f * f, f2, f3, 0, l);
        this.appnext = new AnimatedElement(this.activity.appnext, 0.88411456f, this.scene.getY(0L) / f3 + -0.087890625f * f, f2, f3, 0, l);
        this.appprev = new AnimatedElement(this.activity.appprev, 0.1171875f, this.scene.getY(0L) / f3 + -0.087890625f * f, f2, f3, 0, l);
        this.appok = new AnimatedElement(this.activity.appok, 0.14322917f, this.scene.getY(0L) / f3 + 0.21679688f * f, f2, f3, 0, l);
        this.apptrash = new AnimatedElement(this.activity.apptrash, 0.8652344f, this.scene.getY(0L) / f3 + 0.21679688f * f, f2, f3, 0, l);
        this.apptitle = new AnimatedElement(this.activity, this.activity.apptitles[this.getAppCode(this.select_appliance)], 0.5f, this.scene.getY(0L) / f3 + -0.35091147f * f, f2, f3, 0, l);
        this.menus.addAll(new AnimatedElement[]{this.appboard, this.appok, this.appnext, this.appprev, this.apptrash, this.apptitle});
        if (this.isslotasupgrade || this.app_canupgrade) {
            this.appplus = new AnimatedElement(this.activity, "upgradeplus", 0.9f, this.scene.getY(0L) / f3 + -0.33789062f * f, f2, f3, 0, l);
            this.menus.add(this.appplus);
        }
        if (this.app_canaddslot && !this.isslotasupgrade) {
            try {
                this.appslotup = Image.createImage((String)"/upgradeavailable.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.pageoffset = this.activity.getSharedPref().getInt("app_page" + this.getAppCode(this.select_appliance), 0);
        if (this.pageoffset > 0) {
            this.appprev.animate(0, l);
        } else {
            this.appprev.animateOut(0L);
        }
        if (this.pageoffset < MainActivity.appitems[this.getAppCode(this.select_appliance)].length - 6) {
            this.appnext.animate(0, l);
        } else {
            this.appnext.animateOut(0L);
        }
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 2; ++n) {
                if (this.pageoffset + n * 3 + n2 < MainActivity.appitems[this.getAppCode(this.select_appliance)].length) {
                    this.appmenu[n * 3 + n2] = new MenuItem(this.activity, MainActivity.appitems[this.getAppCode(this.select_appliance)][this.pageoffset + n * 3 + n2], this.mininote, (442.0f + 331.0f * (float)n2) / 1536.0f, this.scene.getY(0L) / f3 + (450.0f + 354.0f * (float)n - 823.0f) / 2048.0f * 4.0f / 3.0f * f, f2, f3, 0, l, MainActivity.cooknames[this.getAppCode(this.select_appliance)][this.pageoffset + n * 3 + n2]);
                    if (this.pageoffset + n * 3 + n2 < this.activity.getSharedPref().getInt("index_shown_A" + Math.max(1, this.getAppCode(this.select_appliance)), 4)) continue;
                    this.appmenu[n * 3 + n2].setNew(this.nitem);
                    continue;
                }
                this.appmenu[n * 3 + n2] = null;
            }
        }
        for (n2 = 0; n2 < 5; ++n2) {
            n = 0;
            if (n2 == this.getAppCode(this.select_appliance) && this.appslotup != null) {
                n = 1;
            }
            for (int i = 0; i < this.activity.getAppSlots(n2) + n; ++i) {
                if (this.activity.getCooking(n2)[i] == null) {
                    this.activity.getCooking((int)n2)[i] = new CookItem(this.appempty, this.appready, (768.0f + 258.0f * (float)i - (float)(this.activity.getAppSlots(n2) - 1) * 129.0f) / 1536.0f, this.scene.getY(0L) / f3 + 0.21875f * f, f2, f3, 0, l);
                } else if (this.activity.getCooking(n2)[i].isEmpty()) {
                    this.activity.getCooking(n2)[i].setEmpty(this.appempty, this.appready);
                } else {
                    this.activity.getCooking(n2)[i].setReadyBMP(this.appready);
                }
                if (n == 1) {
                    this.activity.getCooking(n2)[i].setX((768.0f + 258.0f * (float)i - (float)this.activity.getAppSlots(n2) * 129.0f) / 1536.0f);
                    continue;
                }
                this.activity.getCooking(n2)[i].setX((768.0f + 258.0f * (float)i - (float)(this.activity.getAppSlots(n2) - 1) * 129.0f) / 1536.0f);
            }
        }
        if (this.appslotup != null) {
            this.activity.getCooking(this.getAppCode(this.select_appliance))[this.activity.getAppSlots(this.getAppCode(this.select_appliance))].setPlusBMP(this.appslotup);
        }
        this.activity.getCanvas().setFocus(this.appok);
        this.apploaded = true;
    }

    private void appNext(long l) {
        int n;
        if (this.appnext.isAnimatingOut()) {
            return;
        }
        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
        float f2 = this.background.getWidth();
        float f3 = (float)this.activity.getCanvas().getHeight() / f;
        float f4 = f2 / f3;
        this.pageoffset += 6;
        this.activity.getPrefEditor().putInt("app_page" + this.getAppCode(this.select_appliance), this.pageoffset);
        this.activity.getPrefEditor().commit();
        this.appmenuold = new MenuItem[6];
        for (n = 0; n < this.appmenu.length; ++n) {
            this.appmenuold[n] = this.appmenu[n];
            if (this.appmenuold[n] == null) continue;
            this.appmenuold[n].animate(3, l);
            this.appmenuold[n].animateOut(l);
        }
        for (n = 0; n < 3; ++n) {
            for (int i = 0; i < 2; ++i) {
                this.appmenuold[i * 3 + n] = this.appmenu[i * 3 + n];
                if (this.pageoffset + i * 3 + n < MainActivity.appitems[this.getAppCode(this.select_appliance)].length) {
                    this.appmenu[i * 3 + n] = new MenuItem(this.activity, MainActivity.appitems[this.getAppCode(this.select_appliance)][this.pageoffset + i * 3 + n], this.mininote, (437.0f + 331.0f * (float)n) / 1536.0f, this.scene.getY(0L) / f3 + (450.0f + 354.0f * (float)i - 823.0f) / 2048.0f * 4.0f / 3.0f * f4, f2, f3, 4, l, MainActivity.cooknames[this.getAppCode(this.select_appliance)][this.pageoffset + i * 3 + n]);
                    if (this.pageoffset + i * 3 + n < this.activity.getSharedPref().getInt("index_shown_A" + Math.max(1, this.getAppCode(this.select_appliance)), 4)) continue;
                    this.appmenu[i * 3 + n].setNew(this.nitem);
                    continue;
                }
                this.appmenu[i * 3 + n] = null;
            }
        }
        if (this.pageoffset > 0) {
            this.appprev.animate(0, l);
        } else {
            this.appprev.animateOut(0L);
        }
        if (this.pageoffset < MainActivity.appitems[this.getAppCode(this.select_appliance)].length - 6) {
            this.appnext.animate(0, l);
        } else {
            this.appnext.animateOut(0L);
            this.activity.getCanvas().setFocus(this.appmenu[Math.min(2, (MainActivity.appitems[this.getAppCode(this.select_appliance)].length - 1) % 6)]);
        }
    }

    private void appPrev(long l) {
        int n;
        if (this.appprev.isAnimatingOut()) {
            return;
        }
        if (Math.min(this.pageoffset + 6, MainActivity.appitems[Math.max(0, this.getAppCode(this.select_appliance) - 1)].length) > this.activity.getSharedPref().getInt("index_shown_A" + Math.max(1, this.getAppCode(this.select_appliance)), 4)) {
            this.activity.getPrefEditor().putInt("index_shown_A" + Math.max(1, this.getAppCode(this.select_appliance)), Math.min(this.pageoffset + 6, MainActivity.appitems[Math.max(0, this.getAppCode(this.select_appliance) - 1)].length));
            this.activity.getPrefEditor().commit();
        }
        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
        float f2 = this.background.getWidth();
        float f3 = (float)this.activity.getCanvas().getHeight() / f;
        float f4 = f2 / f3;
        this.pageoffset -= 6;
        this.activity.getPrefEditor().putInt("app_page" + this.getAppCode(this.select_appliance), this.pageoffset);
        this.activity.getPrefEditor().commit();
        this.appmenuold = new MenuItem[6];
        for (n = 0; n < this.appmenu.length; ++n) {
            this.appmenuold[n] = this.appmenu[n];
            if (this.appmenuold[n] == null) continue;
            this.appmenuold[n].animate(4, l);
            this.appmenuold[n].animateOut(l);
        }
        for (n = 0; n < 3; ++n) {
            for (int i = 0; i < 2; ++i) {
                this.appmenuold[i * 3 + n] = this.appmenu[i * 3 + n];
                if (this.pageoffset + i * 3 + n < MainActivity.appitems[this.getAppCode(this.select_appliance)].length) {
                    this.appmenu[i * 3 + n] = new MenuItem(this.activity, MainActivity.appitems[this.getAppCode(this.select_appliance)][this.pageoffset + i * 3 + n], this.mininote, (437.0f + 331.0f * (float)n) / 1536.0f, this.scene.getY(0L) / f3 + (450.0f + 354.0f * (float)i - 823.0f) / 2048.0f * 4.0f / 3.0f * f4, f2, f3, 3, l, MainActivity.cooknames[this.getAppCode(this.select_appliance)][this.pageoffset + i * 3 + n]);
                    if (this.pageoffset + i * 3 + n < this.activity.getSharedPref().getInt("index_shown_A" + Math.max(1, this.getAppCode(this.select_appliance)), 4)) continue;
                    this.appmenu[i * 3 + n].setNew(this.nitem);
                    continue;
                }
                this.appmenu[i * 3 + n] = null;
            }
        }
        if (this.pageoffset > 0) {
            this.appprev.animate(0, l);
        } else {
            this.appprev.animateOut(0L);
            this.activity.getCanvas().setFocus(this.appmenu[0]);
        }
        if (this.pageoffset < MainActivity.appitems[this.getAppCode(this.select_appliance)].length - 6) {
            this.appnext.animate(0, l);
        } else {
            this.appnext.animateOut(0L);
        }
    }

    private void unloadApp() {
        if (!this.apploaded) {
            return;
        }
        if (Math.min(this.pageoffset + 6, MainActivity.appitems[Math.max(0, this.getAppCode(this.select_appliance) - 1)].length) > this.activity.getSharedPref().getInt("index_shown_A" + Math.max(1, this.getAppCode(this.select_appliance)), 4)) {
            this.activity.getPrefEditor().putInt("index_shown_A" + Math.max(1, this.getAppCode(this.select_appliance)), Math.min(this.pageoffset + 6, MainActivity.appitems[Math.max(0, this.getAppCode(this.select_appliance) - 1)].length));
            this.activity.getPrefEditor().commit();
        }
        this.menus.removeAll(new AnimatedElement[]{this.appboard, this.appok, this.appprev, this.appnext, this.apptrash, this.apptitle, this.appplus});
        for (int i = 0; i < this.appmenu.length; ++i) {
            if (this.appmenu[i] != null) {
                this.appmenu[i] = null;
            }
            this.appmenu[i] = null;
        }
        this.apploaded = false;
        this.appboard = null;
        this.appok = null;
        this.apptrash = null;
        this.apptitle = null;
        this.appempty = null;
        this.appready = null;
        this.app_canaddslot = false;
        this.app_canupgrade = false;
        this.isslotasupgrade = false;
        if (this.appplus != null) {
            this.appplus = null;
        }
        this.appplus = null;
        if (this.appslotup != null) {
            this.appslotup = null;
        }
        this.appslotup = null;
    }

    public void updateAppImage(int n) {
        switch (n) {
            case 0: {
                this.oven1.setPNG(MainActivity.appimgs[0][this.activity.getAppUpgrade(0)]);
                break;
            }
            case 1: {
                this.oven2.setPNG(MainActivity.appimgs[1][this.activity.getAppUpgrade(1)]);
                break;
            }
            case 2: {
                this.drink.setPNG(MainActivity.appimgs[2][this.activity.getAppUpgrade(2)]);
                break;
            }
            case 3: {
                this.salad.setPNG(MainActivity.appimgs[3][this.activity.getAppUpgrade(3)]);
                break;
            }
            case 4: {
                this.dessert.setPNG(MainActivity.appimgs[4][this.activity.getAppUpgrade(4)]);
            }
        }
    }

    public void addCooking(int n, int n2, long l) {
        for (int i = 0; i < this.activity.getAppSlots(n); ++i) {
            if (!this.activity.getCooking(n)[i].isEmpty()) continue;
            this.activity.getCooking(n)[i].setCooking(this.activity, MainActivity.cookitems[n][n2], this.appready, l, (long)(C2MValues.PREP_TIME_BY_UPGRADE[this.activity.getApplianceUpgrade(n)][Math.max(0, n - 1)] * 1000.0f));
            if (n != 0) break;
            this.checkMessage(4);
            break;
        }
    }

    public void removeOrder(AnimatedOrder animatedOrder, long l) {
        boolean bl = false;
        if (this.on_order == animatedOrder && this.orderloaded) {
            if (this.activity.getCanvas().getFocus() == this.orderok) {
                this.activity.getCanvas().setFocus(this.map);
            }
            this.unloadOrder();
        }
        for (int i = 0; i < this.activity.getOrders().size(); ++i) {
            if (bl) {
                ((AnimatedOrder)this.activity.getOrders().get(i)).setIndex(i, l);
                continue;
            }
            if ((AnimatedOrder)this.activity.getOrders().get(i) != animatedOrder) continue;
            this.activity.getOrders().remove(animatedOrder);
            bl = true;
            --i;
        }
    }

    private void loadOven1(float f, float f2, float f3, long l) {
        if (this.activity.getAppSlots(0) == 0) {
            return;
        }
        this.oven1 = new Appliance(this.activity, MainActivity.appimgs[0][this.activity.getAppUpgrade(0)], this.exclamation, this.warning, 0.26106772f, this.scene.getY(0L) / f3 - 0.26367188f * f, f2, f3, 0, l);
        this.appliances.add(this.oven1);
        for (int i = 0; i < this.activity.getCooking(0).length; ++i) {
            if (this.activity.getCooking(0)[i] == null) continue;
            if (this.activity.getCooking(0)[i].isReady(this.last_time) && !this.activity.getCooking(0)[i].isEmpty()) {
                this.oven1.signalDone(this.last_time);
                break;
            }
            if (!this.activity.getCooking(0)[i].isWarn(this.last_time) || this.activity.getCooking(0)[i].isEmpty()) continue;
            this.oven1.signalWarn(this.last_time);
            break;
        }
    }

    private void loadOven2(float f, float f2, float f3, long l) {
        if (this.activity.getAppSlots(1) == 0) {
            return;
        }
        this.oven2 = new Appliance(this.activity, MainActivity.appimgs[1][this.activity.getAppUpgrade(1)], this.exclamation, this.warning, 0.50911456f, this.scene.getY(0L) / f3 - 0.26367188f * f, f2, f3, 0, l);
        this.appliances.add(this.oven2);
        for (int i = 0; i < this.activity.getCooking(1).length; ++i) {
            if (this.activity.getCooking(1)[i] == null) continue;
            if (this.activity.getCooking(1)[i].isReady(this.last_time) && !this.activity.getCooking(1)[i].isEmpty()) {
                this.oven2.signalDone(this.last_time);
                break;
            }
            if (!this.activity.getCooking(1)[i].isWarn(this.last_time) || this.activity.getCooking(1)[i].isEmpty()) continue;
            this.oven2.signalWarn(this.last_time);
            break;
        }
    }

    private void loadDrink(float f, float f2, float f3, long l) {
        if (this.activity.getAppSlots(2) == 0) {
            return;
        }
        this.drink = new Appliance(this.activity, MainActivity.appimgs[2][this.activity.getAppUpgrade(2)], this.exclamation, this.warning, 0.8652344f, this.scene.getY(0L) / f3 + 0.016276041f * f, f2, f3, 0, l);
        this.appliances.add(this.drink);
        for (int i = 0; i < this.activity.getCooking(2).length; ++i) {
            if (this.activity.getCooking(2)[i] == null) continue;
            if (this.activity.getCooking(2)[i].isReady(this.last_time) && !this.activity.getCooking(2)[i].isEmpty()) {
                this.drink.signalDone(this.last_time);
                break;
            }
            if (!this.activity.getCooking(2)[i].isWarn(this.last_time) || this.activity.getCooking(2)[i].isEmpty()) continue;
            this.drink.signalWarn(this.last_time);
            break;
        }
    }

    private void loadSalad(float f, float f2, float f3, long l) {
        if (this.activity.getAppSlots(3) == 0) {
            return;
        }
        this.salad = new Appliance(this.activity, MainActivity.appimgs[3][this.activity.getAppUpgrade(3)], this.exclamation, this.warning, 0.14778645f, this.scene.getY(0L) / f3 + 0.0703125f * f, f2, f3, 0, l);
        this.appliances.add(this.salad);
        for (int i = 0; i < this.activity.getCooking(3).length; ++i) {
            if (this.activity.getCooking(3)[i] == null) continue;
            if (this.activity.getCooking(3)[i].isReady(this.last_time) && !this.activity.getCooking(3)[i].isEmpty()) {
                this.salad.signalDone(this.last_time);
                break;
            }
            if (!this.activity.getCooking(3)[i].isWarn(this.last_time) || this.activity.getCooking(3)[i].isEmpty()) continue;
            this.salad.signalWarn(this.last_time);
            break;
        }
    }

    private void loadDessert(float f, float f2, float f3, long l) {
        if (this.activity.getAppSlots(4) == 0) {
            return;
        }
        this.dessert = new Appliance(this.activity, MainActivity.appimgs[4][this.activity.getAppUpgrade(4)], this.exclamation, this.warning, 0.52994794f, this.scene.getY(0L) / f3 + 0.18359375f * f, f2, f3, 0, l);
        this.appliances.add(this.dessert);
        for (int i = 0; i < this.activity.getCooking(4).length; ++i) {
            if (this.activity.getCooking(4)[i] == null) continue;
            if (this.activity.getCooking(4)[i].isReady(this.last_time) && !this.activity.getCooking(4)[i].isEmpty()) {
                this.dessert.signalDone(this.last_time);
                break;
            }
            if (!this.activity.getCooking(4)[i].isWarn(this.last_time) || this.activity.getCooking(4)[i].isEmpty()) continue;
            this.dessert.signalWarn(this.last_time);
            break;
        }
    }

    public boolean checkMessage(int n) {
        if (this.activity.getSharedPref().getBoolean("msg_" + n, false)) {
            return false;
        }
        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
        float f2 = this.background.getWidth();
        float f3 = (float)this.activity.getCanvas().getHeight() / f;
        String string = "dialogue_ownerpatti";
        if (n == 1 || n == 3 || n == 5 || n == 8 || n == 13 || n > 15) {
            string = "dialogue_chefluc";
        }
        this.loadDialog(f2 / f3, f2, f3, string, C2MValues.TUTORIAL_DIALOG[this.activity.getLanguage()][n]);
        this.activity.getPrefEditor().putBoolean("msg_" + n, true);
        this.activity.getPrefEditor().commit();
        return true;
    }

    public void onDraw(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.background == null) {
            graphics.setColor(-16776961);
            graphics.fillRect(0, 0, this.activity.getCanvas().getWidth(), this.activity.getCanvas().getHeight());
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.x3Init();
        } else if (this.background.getWidth() < 50) {
            graphics.setColor(-16711936);
            graphics.fillRect(0, 0, this.activity.getCanvas().getWidth(), this.activity.getCanvas().getHeight());
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.x3Init();
        } else if (!this.loaded) {
            graphics.setColor(-1);
            graphics.fillRect(0, 0, this.activity.getCanvas().getWidth(), this.activity.getCanvas().getHeight());
        }
        long l = this.activity.getTime();
        float f = (float)this.activity.getCanvas().getWidth() / 240.0f;
        float f2 = 240.0f;
        float f3 = (float)this.activity.getCanvas().getHeight() / f;
        if (!this.loaded) {
            this.loadResources(f2 / f3, f2, f3);
        }
        graphics.setColor(-16777216);
        graphics.fillRect(0, this.activity.getCanvas().getHeight() * 9 / 10, this.activity.getCanvas().getWidth(), this.activity.getCanvas().getHeight() * 2 / 10);
        if (this.activity.getOrders().size() > 0) {
            if (((AnimatedOrder)this.activity.getOrders().peek()).isAnimatingOut() && ((AnimatedOrder)this.activity.getOrders().peek()).getElapsed(l) > 200L) {
                this.removeOrder((AnimatedOrder)this.activity.getOrders().peek(), l);
            } else {
                if (this.select_appliance == this.oven1 && this.apploaded && this.activity.getCooking(0)[0] != null && (this.activity.getCooking(0)[0].isReady(l) || this.activity.getCooking(0)[0].isWarn(l))) {
                    this.checkMessage(6);
                }
                if (this.activity.getSharedPref().getInt("orders", 0) == 2) {
                    this.checkMessage(15);
                }
            }
        }
        this.activity.refresh(l);
        boolean bl = false;
        for (n4 = 0; n4 < this.aelist.size(); ++n4) {
            if (((AnimatedElement)this.aelist.get(n4)).render(graphics, l)) continue;
            bl = true;
        }
        for (n4 = 0; n4 < this.appliances.size(); ++n4) {
            if (((AnimatedElement)this.appliances.get(n4)).render(graphics, l)) continue;
            bl = true;
        }
        for (n4 = 0; n4 < this.menus.size(); ++n4) {
            if (((AnimatedElement)this.menus.get(n4)).render(graphics, l)) continue;
            bl = true;
        }
        if (this.apploaded) {
            n4 = this.getAppCode(this.select_appliance);
            n3 = 0;
            for (n2 = 0; n2 < this.activity.getAppSlots(n4); ++n2) {
                if (!this.activity.getCooking(n4)[n2].isEmpty()) continue;
                n3 = 1;
            }
            for (n2 = 0; n2 < this.appmenu.length; ++n2) {
                if (this.appmenu[n2] == null || this.appmenu[n2].render(graphics, l)) continue;
                bl = true;
            }
            for (n2 = 0; n2 < this.appmenuold.length; ++n2) {
                if (this.appmenuold[n2] == null || this.appmenuold[n2].render(graphics, l)) continue;
                bl = true;
            }
            n2 = 0;
            if (this.appslotup != null) {
                n2 = 1;
            }
            for (n = 0; n < this.activity.getAppSlots(n4) + n2; ++n) {
                if (this.activity.getCooking(n4)[n].fetchBurntSignal(l)) {
                    this.activity.playSound("food_burnt");
                    if (n4 == 0) {
                        this.checkMessage(18);
                    } else if (n4 == 2) {
                        this.checkMessage(19);
                    }
                    if (this.on_slot == n) {
                        this.activity.getCooking(n4)[n].deselect();
                        this.on_slot = -1;
                    }
                }
                if (this.activity.getCooking(n4)[n].clearBurntTime(l)) {
                    this.activity.getCooking(n4)[n].setEmpty(this.appempty, this.appready);
                }
                if (this.activity.getCooking(n4)[n].render(graphics, l)) continue;
                bl = true;
            }
        } else if (this.orderloaded && !this.deliveryloaded) {
            n4 = 0;
            for (n3 = 0; n3 < this.orderitems.size(); ++n3) {
                n4 += ((OrderItem)this.orderitems.get(n3)).getValue();
                if (((OrderItem)this.orderitems.get(n3)).render(graphics, l)) continue;
                bl = true;
            }
            graphics.translate((int)(f2 * 414.0f / 1536.0f), (int)(this.scene.getY(0L) + 0.14127605f * f2));
            this.activity.getBrady().renderString(graphics, -16777216, C2MValues.TEXT_TOTAL[this.activity.getLanguage()]);
            graphics.translate((int)(f2 * 693.0f / 1536.0f) - this.activity.getBrady().measure("$" + n4) / 2, 0);
            this.activity.getBrady().renderString(graphics, -16744448, "$" + n4);
            graphics.translate(-((int)(f2 * 1107.0f / 1536.0f)) + this.activity.getBrady().measure("$" + n4) / 2, -((int)(this.scene.getY(0L) + 0.14127605f * f2)));
        }
        if (this.deliveryloaded) {
            for (n4 = 0; n4 < this.deliveries.size(); ++n4) {
                if (this.activity.getDeliveryState(n4) >= 2) {
                    ((AnimatedDelivery)this.deliveries.get(n4)).setFilter(MenuView.filter_dark);
                    if (((AnimatedDelivery)this.deliveries.get(n4)).getAnimation() == 7) {
                        ((AnimatedDelivery)this.deliveries.get(n4)).animate(0, l);
                    }
                } else if (((AnimatedDelivery)this.deliveries.get(n4)).getAnimation() != 7) {
                    ((AnimatedDelivery)this.deliveries.get(n4)).animate(7, l);
                }
                if (!((AnimatedDelivery)this.deliveries.get(n4)).render(graphics, l)) {
                    bl = true;
                }
                ((AnimatedDelivery)this.deliveries.get(n4)).setFilter(null);
            }
            graphics.translate((int)(f2 * 240.0f / 1536.0f), (int)(this.deliverycanv.getY(l) - f2 * 70.0f / 1536.0f));
            this.activity.getBrady().renderString(graphics, -16777216, C2MValues.TEXT_CHOOSE_DRIVER[this.activity.getLanguage()][0]);
            graphics.translate(0, (int)(f2 * 80.0f / 1536.0f));
            this.activity.getBrady().renderString(graphics, -16777216, C2MValues.TEXT_CHOOSE_DRIVER[this.activity.getLanguage()][1]);
            graphics.translate(-((int)(f2 * 240.0f / 1536.0f)), -((int)(this.deliverycanv.getY(l) - f2 * 70.0f / 1536.0f)) - (int)(f2 * 80.0f / 1536.0f));
        } else {
            for (n2 = 0; n2 < this.activity.getOrders().size(); ++n2) {
                n4 = 0;
                n3 = 0;
                if (this.apploaded && this.on_slot != -1) {
                    n = this.getAppCode(this.select_appliance);
                    if ((this.activity.getCooking(n)[this.on_slot].isReady(this.last_time) || this.activity.getCooking(n)[this.on_slot].isWarn(this.last_time)) && !((AnimatedOrder)this.activity.getOrders().get(n2)).isNew()) {
                        String string = this.activity.getCooking(n)[this.on_slot].getItemResource();
                        for (int i = 0; i < MainActivity.cookitems[n].length; ++i) {
                            if (!MainActivity.cookitems[n][i].equals(string) || !((AnimatedOrder)this.activity.getOrders().get(n2)).needsItem(n, i)) continue;
                            n4 = 1;
                        }
                    }
                    if (n4 == 0) {
                        if (((AnimatedOrder)this.activity.getOrders().get(n2)).getFilter() != MenuView.filter_dark) {
                            n3 = 1;
                        }
                        ((AnimatedOrder)this.activity.getOrders().get(n2)).setFilter(MenuView.filter_dark);
                    }
                }
                if (!(this.on_slot == -1 && ((AnimatedOrder)this.activity.getOrders().get(n2)).isReady() || n4 != 0)) {
                    if (((AnimatedOrder)this.activity.getOrders().get(n2)).getAnimation() == 7) {
                        ((AnimatedOrder)this.activity.getOrders().get(n2)).animate(0, l);
                    }
                } else if (((AnimatedOrder)this.activity.getOrders().get(n2)).getAnimation() != 7) {
                    ((AnimatedOrder)this.activity.getOrders().get(n2)).animate(7, l);
                }
                if (!((AnimatedOrder)this.activity.getOrders().get(n2)).render(graphics, l)) {
                    bl = true;
                }
                if (n4 != 0 || n3 == 0) continue;
                ((AnimatedOrder)this.activity.getOrders().get(n2)).setFilter(null);
            }
        }
        if (this.leveluploaded) {
            for (n4 = 0; n4 < this.overmenu.size(); ++n4) {
                if (((AnimatedElement)this.overmenu.get(n4)).render(graphics, l)) continue;
                bl = true;
            }
            if (this.isvictory) {
                graphics.translate((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]) / 2)), (int)(this.leveluppanel.getY(l) + -0.22460938f * f2));
                this.activity.getBrady().renderString(graphics, -16746616, C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]);
                graphics.translate(-((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]) / 2))), -((int)(this.leveluppanel.getY(l) + -0.22460938f * f2)));
                for (n4 = 0; n4 < C2MValues.TEXT_VICTORY[this.activity.getLanguage()].length; ++n4) {
                    graphics.translate((int)(f2 / 2.0f - (float)(this.activity.getKomika().measure(C2MValues.TEXT_VICTORY[this.activity.getLanguage()][n4].toUpperCase()) / 2)), (int)(this.leveluppanel.getY(l) + (-181.0f + 70.0f * (float)n4) / 2048.0f * 4.0f / 3.0f * f2));
                    this.activity.getKomika().renderString(graphics, -16777216, C2MValues.TEXT_VICTORY[this.activity.getLanguage()][n4].toUpperCase());
                    graphics.translate(-((int)(f2 / 2.0f - (float)(this.activity.getKomika().measure(C2MValues.TEXT_VICTORY[this.activity.getLanguage()][n4].toUpperCase()) / 2))), -((int)(this.leveluppanel.getY(l) + (-181.0f + 70.0f * (float)n4) / 2048.0f * 4.0f / 3.0f * f2)));
                }
            } else {
                graphics.translate((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]) / 2)), (int)(this.leveluppanel.getY(l) + -0.19270833f * f2));
                this.activity.getBrady().renderString(graphics, -16746616, C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]);
                graphics.translate(-((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]) / 2))), -((int)(this.leveluppanel.getY(l) + -0.19270833f * f2)));
                graphics.translate((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_REACHED_LEVEL[this.activity.getLanguage()]) / 2)), (int)(this.leveluppanel.getY(l) + -0.10221354f * f2));
                this.activity.getBrady().renderString(graphics, -16777216, C2MValues.TEXT_REACHED_LEVEL[this.activity.getLanguage()]);
                graphics.translate(-((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_REACHED_LEVEL[this.activity.getLanguage()]) / 2))), -((int)(this.leveluppanel.getY(l) + -0.10221354f * f2)));
                graphics.translate((int)(f2 / 2.0f - (float)(this.activity.getCartoon().measure(String.valueOf(this.activity.getLevel())) / 2)), (int)(this.leveluppanel.getY(l) + -0.022786459f * f2));
                this.activity.getCartoon().renderString(graphics, -16746616, String.valueOf(this.activity.getLevel()));
                graphics.translate(-((int)(f2 / 2.0f - (float)(this.activity.getCartoon().measure(String.valueOf(this.activity.getLevel())) / 2))), -((int)(this.leveluppanel.getY(l) + -0.022786459f * f2)));
            }
        } else if (this.dialogloaded) {
            for (n4 = 0; n4 < this.overmenu.size(); ++n4) {
                if (((AnimatedElement)this.overmenu.get(n4)).render(graphics, l)) continue;
                bl = true;
            }
            graphics.translate((int)(f2 * 159.0f / 1536.0f), (int)(this.bwood.getY(0L) + -0.71875f * f2));
            if (this.dialog_res.equals("dialogue_ownerpatti")) {
                this.activity.getCartoon().renderString(graphics, -1, C2MValues.CHARACTER_NAMES[this.activity.getLanguage()][0]);
            } else if (this.dialog_res.equals("dialogue_chefluc")) {
                this.activity.getCartoon().renderString(graphics, -1, C2MValues.CHARACTER_NAMES[this.activity.getLanguage()][1]);
            } else if (this.dialog_res.equals("dialogue_elizabeth")) {
                this.activity.getCartoon().renderString(graphics, -1, C2MValues.CHARACTER_NAMES[this.activity.getLanguage()][2]);
            } else if (this.dialog_res.equals("dialogue_emily")) {
                this.activity.getCartoon().renderString(graphics, -1, C2MValues.CHARACTER_NAMES[this.activity.getLanguage()][3]);
            } else if (this.dialog_res.equals("dialogue_jacob")) {
                this.activity.getCartoon().renderString(graphics, -1, C2MValues.CHARACTER_NAMES[this.activity.getLanguage()][4]);
            } else if (this.dialog_res.equals("dialogue_josh")) {
                this.activity.getCartoon().renderString(graphics, -1, C2MValues.CHARACTER_NAMES[this.activity.getLanguage()][5]);
            } else if (this.dialog_res.equals("dialogue_nathan")) {
                this.activity.getCartoon().renderString(graphics, -1, C2MValues.CHARACTER_NAMES[this.activity.getLanguage()][6]);
            }
            graphics.translate(-((int)(f2 * 159.0f / 1536.0f)), -((int)(this.bwood.getY(0L) + -0.71875f * f2)));
            graphics.translate((int)(f2 * 195.0f / 1536.0f), (int)(this.bwood.getY(0L) + -0.5807292f * f2));
            this.activity.getKomika().renderString(graphics, -16777216, this.dialog_lines[this.dialog_index]);
            graphics.translate(-((int)(f2 * 195.0f / 1536.0f)), -((int)(this.bwood.getY(0L) + -0.5807292f * f2)));
            if (this.dialog_lines.length > this.dialog_index + 1) {
                graphics.translate((int)(f2 * 195.0f / 1536.0f), (int)(this.bwood.getY(0L) + -0.52213544f * f2));
                this.activity.getKomika().renderString(graphics, -16777216, this.dialog_lines[this.dialog_index + 1]);
                graphics.translate(-((int)(f2 * 195.0f / 1536.0f)), -((int)(this.bwood.getY(0L) + -0.52213544f * f2)));
            }
            if (this.dialog_lines.length > this.dialog_index + 2) {
                graphics.translate((int)(f2 * 195.0f / 1536.0f), (int)(this.bwood.getY(0L) + -0.46354166f * f2));
                this.activity.getKomika().renderString(graphics, -16777216, this.dialog_lines[this.dialog_index + 2]);
                graphics.translate(-((int)(f2 * 195.0f / 1536.0f)), -((int)(this.bwood.getY(0L) + -0.46354166f * f2)));
            }
        } else if (this.upgradeloaded) {
            this.activity.pause();
            for (n4 = 0; n4 < this.overmenu.size(); ++n4) {
                if (((AnimatedElement)this.overmenu.get(n4)).render(graphics, l)) continue;
                bl = true;
            }
            String string = C2MValues.APPLIANCE_NAMES[this.activity.getLanguage()][Math.max(0, this.getAppCode(this.select_appliance) - 1)];
            String[] stringArray = new String[]{"", "", C2MValues.TEXT_UPGRADE_COST[this.activity.getLanguage()] + "  $" + this.upgrade_cost, C2MValues.TEXT_YOUR_CASH[this.activity.getLanguage()] + "   $" + this.activity.getMoney()};
            float[] fArray = new float[]{-0.79f, -0.615f, 0.521f, 0.685f};
            if (this.upgrade_isfortime) {
                stringArray[0] = this.getAppCode(this.select_appliance) < 2 ? stringArray[0] + "-2 " + C2MValues.TEXT_PREP_TIME[this.activity.getLanguage()] : stringArray[0] + "-1 " + C2MValues.TEXT_PREP_TIME[this.activity.getLanguage()];
                stringArray[1] = stringArray[1] + C2MValues.TEXT_UPTO_1[this.activity.getLanguage()] + string + C2MValues.TEXT_UPTO_2[this.activity.getLanguage()];
            } else if (this.select_appliance == this.oven1 && this.activity.getAppSlots(1) == 0 && this.activity.getAppSlots(0) == 3) {
                stringArray[0] = stringArray[0] + C2MValues.TEXT_BUY_OVEN[this.activity.getLanguage()];
                stringArray[1] = stringArray[1] + C2MValues.TEXT_ADDS_OVEN[this.activity.getLanguage()];
            } else {
                stringArray[0] = stringArray[0] + string;
                stringArray[1] = stringArray[1] + C2MValues.TEXT_ADDS_SLOT[this.activity.getLanguage()];
            }
            for (n = 0; n < 4; ++n) {
                graphics.translate((int)this.upimg.getX(0L) - this.activity.getBrady().measure(stringArray[n]) / 2, (int)(this.upimg.getY(0L) + (float)this.upimg.getHeight() * fArray[n]));
                this.activity.getBrady().renderString(graphics, -16777216, stringArray[n]);
                graphics.translate(-((int)this.upimg.getX(0L)) + this.activity.getBrady().measure(stringArray[n]) / 2, -((int)(this.upimg.getY(0L) + (float)this.upimg.getHeight() * fArray[n])));
            }
        }
        for (int i = 0; i < this.activity.getDeliverers(); ++i) {
            if (this.activity.getDeliveryState(i) != 1 && this.activity.getDeliveryState(i) != 2) continue;
            graphics.drawImage(this.exclamation, (int)(this.map.getX(l) + (float)(this.map.getWidth() / 2)), (int)(this.map.getY(l) - (float)(this.map.getHeight() / 2)), 10);
            break;
        }
        if (this.activity.isPaused()) {
            bl = false;
        }
        if (this.activity.isPaused() && !this.upgradeloaded && !this.dialogloaded && !this.leveluploaded) {
            long l2 = System.currentTimeMillis();
            if (!this.options_loaded) {
                this.loadOptions(f2 / f3, f2, f3, l2);
            }
            for (int i = 0; i < this.overmenu.size(); ++i) {
                if (((AnimatedElement)this.overmenu.get(i)).render(graphics, l2)) continue;
                bl = true;
            }
            graphics.translate((int)(this.optioncanv.getX(l2) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_PAUSED[this.activity.getLanguage()]) / 2)), (int)(f2 * 408.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f)));
            this.activity.getCartoon().renderString(graphics, -16746616, C2MValues.TEXT_PAUSED[this.activity.getLanguage()]);
            graphics.translate(-((int)(this.optioncanv.getX(l2) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_PAUSED[this.activity.getLanguage()]) / 2))), -((int)(f2 * 408.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f))));
        }
        if (bl) {
            this.activity.invalidate();
        } else if (this.apploaded) {
            this.activity.postInvalidateDelayed(100L - (l - this.last_time));
        } else {
            this.activity.postInvalidateDelayed(1000L - (l - this.last_time));
        }
        this.last_time = l;
    }

    public int getAppCode(Appliance appliance) {
        if (appliance == this.oven1) {
            return 0;
        }
        if (appliance == this.oven2) {
            return 1;
        }
        if (appliance == this.drink) {
            return 2;
        }
        if (appliance == this.salad) {
            return 3;
        }
        if (appliance == this.dessert) {
            return 4;
        }
        return -1;
    }

    public Appliance getAppliance(int n) {
        switch (n) {
            case 0: {
                return this.oven1;
            }
            case 1: {
                return this.oven2;
            }
            case 2: {
                return this.drink;
            }
            case 3: {
                return this.salad;
            }
            case 4: {
                return this.dessert;
            }
        }
        return null;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        this.activity.invalidate();
        if (!this.loaded) {
            return false;
        }
        switch (n) {
            case 1: {
                switch (this.select_option) {
                    case 22: {
                        this.unloadLevelUp();
                        break;
                    }
                    case 18: {
                        this.activity.loadAll();
                        this.activity.openMainMenu();
                        break;
                    }
                    case 19: {
                        this.activity.getPrefEditor().putBoolean("sound_on", !this.activity.getSharedPref().getBoolean("sound_on", true));
                        this.activity.getPrefEditor().putBoolean("music_on", !this.activity.getSharedPref().getBoolean("music_on", true));
                        this.activity.getPrefEditor().commit();
                        if (this.activity.getSharedPref().getBoolean("sound_on", true)) {
                            this.sound.setPNG("toggleon_sound");
                            this.activity.getMusic().startMusic();
                        } else {
                            this.sound.setPNG("toggleoff_sound");
                            this.activity.getMusic().stopMusic();
                        }
                        this.sound.setFilter(null);
                        break;
                    }
                    case 20: {
                        this.unloadOptions();
                        this.activity.resume();
                        break;
                    }
                    case 17: {
                        this.dialog_index += 3;
                        if (this.dialog_lines.length > this.dialog_index) {
                            if (this.dialog_lines.length <= this.dialog_index + 3) {
                                this.dialog_btn.setPNG("button_dialogueok");
                            }
                            this.dialog_btn.setFilter(null);
                            break;
                        }
                        this.unloadDialog();
                        break;
                    }
                    case 1: {
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) {
                            this.map.setFilter(null);
                            break;
                        }
                        this.activity.openMap();
                        break;
                    }
                    case 2: {
                        this.pause.setFilter(null);
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                        this.activity.togglePause();
                        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
                        float f2 = this.background.getWidth();
                        float f3 = (float)this.activity.getCanvas().getHeight() / f;
                        this.loadOptions(f2 / f3, f2, f3, System.currentTimeMillis());
                        break;
                    }
                    case 16: {
                        if (this.upgrade_isfortime) {
                            this.activity.upgradeAppliance(this.getAppCode(this.select_appliance));
                            this.app_canupgrade = false;
                        } else {
                            float f;
                            float f4;
                            float f5;
                            this.activity.addApplianceSlot(this.getAppCode(this.select_appliance));
                            this.app_canaddslot = false;
                            if (this.select_appliance == this.oven1 && this.activity.getAppSlots(1) == 1 && this.activity.getAppSlots(0) == 3) {
                                f5 = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
                                f4 = this.background.getWidth();
                                f = (float)this.activity.getCanvas().getHeight() / f5;
                                this.loadOven2(f4 / f, f4, f, this.last_time);
                            }
                            this.dialog_to_app = true;
                            this.unloadUpgrade();
                            f5 = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
                            f4 = this.background.getWidth();
                            f = (float)this.activity.getCanvas().getHeight() / f5;
                            int n2 = Math.max(1, this.getAppCode(this.select_appliance));
                            int n3 = this.activity.getAppSlots(n2);
                            if (n2 == 1) {
                                n3 += this.activity.getAppSlots(0);
                            }
                            switch (n2) {
                                case 1: {
                                    if (n3 != 5) {
                                        this.loadDialog(f4 / f, f4, f, "dialogue_chefluc", C2MValues.PIZZA_SLOT_BOUGHT_MESSAGES[this.activity.getLanguage()][n3 - 2]);
                                        break;
                                    }
                                    this.loadDialog(f4 / f, f4, f, "dialogue_ownerpatti", C2MValues.PIZZA_SLOT_BOUGHT_MESSAGES[this.activity.getLanguage()][n3 - 2]);
                                    break;
                                }
                                case 2: {
                                    if (n3 == 3) {
                                        this.loadDialog(f4 / f, f4, f, "dialogue_chefluc", C2MValues.BEVERAGE_SLOT_BOUGHT_MESSAGES[this.activity.getLanguage()][n3 - 2]);
                                        break;
                                    }
                                    this.loadDialog(f4 / f, f4, f, "dialogue_ownerpatti", C2MValues.BEVERAGE_SLOT_BOUGHT_MESSAGES[this.activity.getLanguage()][n3 - 2]);
                                    break;
                                }
                                case 3: {
                                    if (n3 == 2) {
                                        this.loadDialog(f4 / f, f4, f, "dialogue_chefluc", C2MValues.SALAD_SLOT_BOUGHT_MESSAGES[this.activity.getLanguage()][n3 - 2]);
                                        break;
                                    }
                                    this.loadDialog(f4 / f, f4, f, "dialogue_ownerpatti", C2MValues.SALAD_SLOT_BOUGHT_MESSAGES[this.activity.getLanguage()][n3 - 2]);
                                    break;
                                }
                                case 4: {
                                    if (n3 == 3) {
                                        this.loadDialog(f4 / f, f4, f, "dialogue_chefluc", C2MValues.DESSERT_SLOT_BOUGHT_MESSAGES[this.activity.getLanguage()][n3 - 2]);
                                        break;
                                    }
                                    this.loadDialog(f4 / f, f4, f, "dialogue_ownerpatti", C2MValues.DESSERT_SLOT_BOUGHT_MESSAGES[this.activity.getLanguage()][n3 - 2]);
                                }
                            }
                            return false;
                        }
                    }
                    case 15: {
                        this.unloadUpgrade();
                        this.activity.resume();
                        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
                        float f6 = this.background.getWidth();
                        float f7 = (float)this.activity.getCanvas().getHeight() / f;
                        this.loadApp(f6 / f7, f6, f7);
                        break;
                    }
                    case 3: {
                        this.select_order.setFilter(null);
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                        if (this.apploaded) {
                            if (this.on_slot != -1) {
                                int n4 = this.getAppCode(this.select_appliance);
                                if (this.activity.getCooking(n4)[this.on_slot].isReady(this.last_time) || this.activity.getCooking(n4)[this.on_slot].isWarn(this.last_time)) {
                                    String string = this.activity.getCooking(n4)[this.on_slot].getItemResource();
                                    boolean bl = false;
                                    for (int i = 0; i < MainActivity.cookitems[n4].length; ++i) {
                                        if (!MainActivity.cookitems[n4][i].equals(string)) continue;
                                        if (!this.select_order.needsItem(n4, i)) break;
                                        this.select_order.addItem(n4, i);
                                        this.activity.getCooking(n4)[this.on_slot].deselect();
                                        this.activity.getCooking(n4)[this.on_slot].setEmpty(this.appempty, this.appready);
                                        this.on_slot = -1;
                                        break;
                                    }
                                    this.select_order = null;
                                    break;
                                }
                                this.activity.getCooking(n4)[this.on_slot].deselect();
                                this.on_slot = -1;
                                this.select_order = null;
                                break;
                            }
                            this.unloadApp();
                            this.select_appliance = null;
                        }
                        if (this.select_order == this.on_order) {
                            this.unloadOrder();
                            this.on_order = null;
                            this.select_order = null;
                            break;
                        }
                        if (this.orderloaded) {
                            this.unloadOrder();
                        }
                        this.on_order = this.select_order;
                        this.on_order.select();
                        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
                        float f8 = this.background.getWidth();
                        float f9 = (float)this.activity.getCanvas().getHeight() / f;
                        this.loadOrder(f8 / f9, f8, f9);
                        this.select_order = null;
                        break;
                    }
                    case 4: 
                    case 21: {
                        this.activity.getCanvas().setFocus(this.on_order);
                        this.unloadOrder();
                        this.on_order = null;
                        break;
                    }
                    case 11: {
                        this.appplus.setFilter(null);
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                    }
                    case 12: {
                        int n5;
                        if (this.select_option == 12) {
                            this.activity.getCooking(this.getAppCode(this.select_appliance))[this.select_slot].setFilter(null);
                        }
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                        int n6 = Math.max(1, this.getAppCode(this.select_appliance));
                        if (this.select_option == 12 || this.isslotasupgrade) {
                            n5 = this.activity.getAppSlots(n6);
                            if (n6 == 1) {
                                n5 += this.activity.getAppSlots(0);
                            }
                            this.activity.getPrefEditor().putBoolean("upgrade_shown_A" + n6 + "_S" + (n5 + 1), false);
                        } else {
                            this.activity.getPrefEditor().putBoolean("upgrade_shown_A" + n6 + "_U" + (this.activity.getApplianceUpgrade(n6) + 1), false);
                        }
                        this.activity.getPrefEditor().commit();
                        this.unloadApp();
                    }
                    case 5: {
                        this.select_appliance.setFilter(null);
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                        this.select_appliance.clearSignal();
                        float f = (float)this.activity.getCanvas().getWidth() / (float)this.background.getWidth();
                        float f10 = this.background.getWidth();
                        float f11 = (float)this.activity.getCanvas().getHeight() / f;
                        int n6 = Math.max(1, this.getAppCode(this.select_appliance));
                        if (this.activity.getApplianceUpgrade(n6) < 2 && this.activity.getLevel() >= C2MValues.APPLIANCE_UPGRADES[(n6 - 1) * 4 + this.activity.getApplianceUpgrade(n6) * 2] && this.activity.getMoney() >= C2MValues.APPLIANCE_UPGRADES[(n6 - 1) * 4 + this.activity.getApplianceUpgrade(n6) * 2 + 1]) {
                            this.app_canupgrade = true;
                            if (!this.activity.getSharedPref().getBoolean("upgrade_shown_A" + n6 + "_U" + (this.activity.getApplianceUpgrade(n6) + 1), false)) {
                                this.upgrade_res = MainActivity.appups[n6][this.activity.getApplianceUpgrade(n6) + 1];
                                this.upgrade_cost = C2MValues.APPLIANCE_UPGRADES[(n6 - 1) * 4 + this.activity.getApplianceUpgrade(n6) * 2 + 1];
                                this.upgrade_isfortime = true;
                                this.dialog_to_upgrade = true;
                                int n7 = n6 * 2 + this.activity.getApplianceUpgrade(n6);
                                if (n7 == 2 || n7 == 4 || n7 == 7 || n7 == 8) {
                                    this.loadDialog(f10 / f11, f10, f11, "dialogue_chefluc", C2MValues.APPLIANCE_UPGRADE_MESSAGES[this.activity.getLanguage()][n7 - 2]);
                                } else {
                                    this.loadDialog(f10 / f11, f10, f11, "dialogue_ownerpatti", C2MValues.APPLIANCE_UPGRADE_MESSAGES[this.activity.getLanguage()][n7 - 2]);
                                }
                                this.activity.getPrefEditor().putBoolean("upgrade_shown_A" + n6 + "_U" + (this.activity.getApplianceUpgrade(n6) + 1), true);
                                this.activity.getPrefEditor().commit();
                                break;
                            }
                        }
                        int n5 = this.activity.getAppSlots(n6);
                        if (n6 == 1) {
                            n5 += this.activity.getAppSlots(0);
                        }
                        if (n5 < 3 || this.select_appliance == this.oven2 && n5 < 6 || this.select_appliance == this.oven1 && n5 == 3) {
                            int n8;
                            boolean bl = false;
                            switch (n6) {
                                default: {
                                    n8 = C2MValues.PIZZA_SLOTS[n5 * 2 - 1];
                                    if (this.activity.getLevel() < C2MValues.PIZZA_SLOTS[n5 * 2 - 2] || this.activity.getMoney() < n8) break;
                                    bl = true;
                                    if (this.activity.getSharedPref().getBoolean("upgrade_shown_A" + n6 + "_S" + (n5 + 1), false)) break;
                                    if (n5 > 3) {
                                        this.loadDialog(f10 / f11, f10, f11, "dialogue_chefluc", C2MValues.PIZZA_SLOT_AVAILABLE_MESSAGES[this.activity.getLanguage()][n5 - 1]);
                                        break;
                                    }
                                    this.loadDialog(f10 / f11, f10, f11, "dialogue_ownerpatti", C2MValues.PIZZA_SLOT_AVAILABLE_MESSAGES[this.activity.getLanguage()][n5 - 1]);
                                    break;
                                }
                                case 2: {
                                    n8 = C2MValues.BEVERAGE_SLOTS[n5 * 2 - 1];
                                    if (this.activity.getLevel() < C2MValues.BEVERAGE_SLOTS[n5 * 2 - 2] || this.activity.getMoney() < n8) break;
                                    bl = true;
                                    if (this.activity.getSharedPref().getBoolean("upgrade_shown_A" + n6 + "_S" + (n5 + 1), false)) break;
                                    if (n5 == 2) {
                                        this.loadDialog(f10 / f11, f10, f11, "dialogue_chefluc", C2MValues.BEVERAGE_SLOT_AVAILABLE_MESSAGES[this.activity.getLanguage()][n5 - 1]);
                                        break;
                                    }
                                    this.loadDialog(f10 / f11, f10, f11, "dialogue_ownerpatti", C2MValues.BEVERAGE_SLOT_AVAILABLE_MESSAGES[this.activity.getLanguage()][n5 - 1]);
                                    break;
                                }
                                case 3: {
                                    n8 = C2MValues.SALAD_SLOTS[n5 * 2 - 1];
                                    if (this.activity.getLevel() < C2MValues.SALAD_SLOTS[n5 * 2 - 2] || this.activity.getMoney() < n8) break;
                                    bl = true;
                                    if (this.activity.getSharedPref().getBoolean("upgrade_shown_A" + n6 + "_S" + (n5 + 1), false)) break;
                                    if (n5 == 2) {
                                        this.loadDialog(f10 / f11, f10, f11, "dialogue_chefluc", C2MValues.SALAD_SLOT_AVAILABLE_MESSAGES[this.activity.getLanguage()][n5 - 1]);
                                        break;
                                    }
                                    this.loadDialog(f10 / f11, f10, f11, "dialogue_ownerpatti", C2MValues.SALAD_SLOT_AVAILABLE_MESSAGES[this.activity.getLanguage()][n5 - 1]);
                                    break;
                                }
                                case 4: {
                                    n8 = C2MValues.DESSERT_SLOTS[n5 * 2 - 1];
                                    if (this.activity.getLevel() < C2MValues.DESSERT_SLOTS[n5 * 2 - 2] || this.activity.getMoney() < n8) break;
                                    bl = true;
                                    if (this.activity.getSharedPref().getBoolean("upgrade_shown_A" + n6 + "_S" + (n5 + 1), false)) break;
                                    if (n5 == 1) {
                                        this.loadDialog(f10 / f11, f10, f11, "dialogue_chefluc", C2MValues.DESSERT_SLOT_AVAILABLE_MESSAGES[this.activity.getLanguage()][n5 - 1]);
                                        break;
                                    }
                                    this.loadDialog(f10 / f11, f10, f11, "dialogue_ownerpatti", C2MValues.DESSERT_SLOT_AVAILABLE_MESSAGES[this.activity.getLanguage()][n5 - 1]);
                                }
                            }
                            if (bl) {
                                this.app_canaddslot = true;
                                if (n5 == 3 && n6 == 1) {
                                    this.isslotasupgrade = true;
                                }
                                if (!this.activity.getSharedPref().getBoolean("upgrade_shown_A" + n6 + "_S" + (n5 + 1), false)) {
                                    this.upgrade_res = MainActivity.appups[n6][this.activity.getApplianceUpgrade(n6)];
                                    this.upgrade_cost = n8;
                                    this.upgrade_isfortime = false;
                                    this.dialog_to_upgrade = true;
                                    this.activity.getPrefEditor().putBoolean("upgrade_shown_A" + n6 + "_S" + (n5 + 1), true);
                                    this.activity.getPrefEditor().commit();
                                    break;
                                }
                            }
                        }
                        this.loadApp(f10 / f11, f10, f11);
                        break;
                    }
                    case 6: {
                        this.unloadApp();
                        this.activity.getCanvas().setFocus(this.select_appliance);
                        this.select_appliance = null;
                        break;
                    }
                    case 7: {
                        this.appnext.setFilter(null);
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                        this.appNext(this.last_time);
                        break;
                    }
                    case 8: {
                        this.appprev.setFilter(null);
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                        this.appPrev(this.last_time);
                        break;
                    }
                    case 9: {
                        this.appmenu[this.select_menu].setFilter(null);
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                        this.addCooking(this.getAppCode(this.select_appliance), this.select_menu + this.pageoffset, this.last_time);
                        break;
                    }
                    case 10: {
                        if (this.on_slot != -1) {
                            this.activity.getCooking(this.getAppCode(this.select_appliance))[this.on_slot].deselect();
                        }
                        this.activity.getCooking(this.getAppCode(this.select_appliance))[this.select_slot].setFilter(null);
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded || !this.activity.getCooking(this.getAppCode(this.select_appliance))[this.select_slot].isSelectable()) break;
                        this.activity.getCooking(this.getAppCode(this.select_appliance))[this.select_slot].setSelected(this.activity, "white_border_selection_forslot");
                        this.on_slot = this.select_slot;
                        break;
                    }
                    case 13: {
                        this.apptrash.setFilter(null);
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                        this.activity.getCooking(this.getAppCode(this.select_appliance))[this.on_slot].deselect();
                        this.activity.getCooking(this.getAppCode(this.select_appliance))[this.on_slot].setEmpty(this.appempty, this.appready);
                        this.on_slot = -1;
                        this.activity.getCanvas().setFocus(this.appok);
                        break;
                    }
                    case 14: {
                        ((AnimatedDelivery)this.deliveries.get(this.select_delivery)).setFilter(null);
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                        this.activity.addToDelivery(this.select_delivery, this.on_order, this.last_time);
                        this.removeOrder(this.on_order, this.last_time);
                        this.select_delivery = -1;
                        this.unloadOrder();
                        this.checkMessage(11);
                        this.activity.getCanvas().setFocus(this.map);
                    }
                }
                if (this.select_option != 10 && this.on_slot != -1) {
                    this.activity.getCooking(this.getAppCode(this.select_appliance))[this.on_slot].deselect();
                    this.on_slot = -1;
                }
                this.clickx = -1.0f;
                this.select_option = 0;
                return false;
            }
            case 2: {
                if (this.leveluploaded) {
                    if (this.levelupok.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                        this.select_option = 22;
                        this.levelupok.setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                    }
                    return true;
                }
                if (this.dialogloaded) {
                    if (this.dialog_btn.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                        this.select_option = 17;
                        this.dialog_btn.setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                    }
                    return true;
                }
                if (this.upgradeloaded) {
                    if (this.upback.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                        this.select_option = 15;
                        this.upback.setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.upupgrade.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                        this.select_option = 16;
                        this.upupgrade.setFilter(MenuView.filter_dark);
                        this.activity.playSound("confirm_upgrade");
                    }
                    return true;
                }
                if (this.pause.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                    this.select_option = 2;
                    this.pause.setFilter(MenuView.filter_dark);
                    this.activity.playSound("standard_click");
                    return true;
                }
                if (this.activity.isPaused()) {
                    if (this.options_loaded) {
                        if (this.quit.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                            this.select_option = 18;
                            this.quit.setFilter(MenuView.filter_dark);
                            this.activity.playSound("standard_click");
                        } else if (this.sound.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                            this.select_option = 19;
                            this.sound.setFilter(MenuView.filter_dark);
                            this.activity.playSound("standard_click");
                        } else if (this.back.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                            this.select_option = 20;
                            this.back.setFilter(MenuView.filter_dark);
                            this.activity.playSound("standard_click");
                        }
                    }
                    return true;
                }
                if (this.map.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight()) && !this.deliveryloaded) {
                    this.select_option = 1;
                    this.map.setFilter(MenuView.filter_dark);
                    this.activity.playSound("standard_click");
                } else if (this.apploaded) {
                    if (this.appok.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                        this.select_option = 6;
                        this.appok.setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.appnext.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                        this.select_option = 7;
                        this.appnext.setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.appprev.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                        this.select_option = 8;
                        this.appprev.setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.apptrash.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight()) && this.on_slot != -1) {
                        this.select_option = 13;
                        this.apptrash.setFilter(MenuView.filter_dark);
                        this.activity.playSound("trash_items");
                    } else {
                        int n9;
                        int n10;
                        if (this.appplus != null && this.appplus.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                            this.select_option = 11;
                            this.appplus.setFilter(MenuView.filter_dark);
                            this.activity.playSound("standard_click");
                        }
                        block63: for (n10 = 0; n10 < this.activity.getAppSlots(this.getAppCode(this.select_appliance)); ++n10) {
                            if (!this.activity.getCooking(this.getAppCode(this.select_appliance))[n10].isEmpty()) continue;
                            for (n9 = 0; n9 < 6; ++n9) {
                                if (this.appmenu[n9] == null || !this.appmenu[n9].inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) continue;
                                this.select_option = 9;
                                this.select_menu = n9;
                                this.appmenu[this.select_menu].setFilter(MenuView.filter_dark);
                                this.activity.playSound("put_food_in_slots");
                                break block63;
                            }
                            break;
                        }
                        n10 = this.getAppCode(this.select_appliance);
                        for (n9 = 0; n9 < 3; ++n9) {
                            if (this.activity.getCooking(n10)[n9] == null || !this.activity.getCooking(n10)[n9].inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) continue;
                            if (this.activity.getCooking(n10)[n9].isPlus()) {
                                this.select_option = 12;
                                this.select_slot = n9;
                                this.activity.getCooking(n10)[this.select_slot].setFilter(MenuView.filter_dark);
                                this.activity.playSound("standard_click");
                                break;
                            }
                            if (this.activity.getCooking(n10)[n9].isEmpty()) continue;
                            this.select_option = 10;
                            this.select_slot = n9;
                            this.activity.getCooking(n10)[this.select_slot].setFilter(MenuView.filter_dark);
                            this.activity.playSound("pick_up_food");
                            break;
                        }
                        if (this.on_slot != -1) {
                            if (this.activity.getCooking(n10)[this.on_slot].isReady(this.last_time) || this.activity.getCooking(n10)[this.on_slot].isWarn(this.last_time)) {
                                for (n9 = 0; n9 < this.activity.getOrders().size(); ++n9) {
                                    if (((AnimatedOrder)this.activity.getOrders().get(n9)).isNew()) continue;
                                    String string = this.activity.getCooking(n10)[this.on_slot].getItemResource();
                                    boolean bl = false;
                                    for (int i = 0; i < MainActivity.cookitems[n10].length; ++i) {
                                        if (!MainActivity.cookitems[n10][i].equals(string)) continue;
                                        if (!((AnimatedOrder)this.activity.getOrders().get(n9)).needsItem(n10, i)) break;
                                        bl = true;
                                        break;
                                    }
                                    if (!((AnimatedOrder)this.activity.getOrders().get(n9)).inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight()) || !bl) continue;
                                    this.select_option = 3;
                                    this.select_order = (AnimatedOrder)this.activity.getOrders().get(n9);
                                    this.select_order.setFilter(MenuView.filter_dark);
                                    this.activity.playSound("standard_click");
                                    return true;
                                }
                            }
                            this.activity.playSound("food_error");
                            return true;
                        }
                        for (n9 = 0; n9 < this.activity.getOrders().size(); ++n9) {
                            if (!((AnimatedOrder)this.activity.getOrders().get(n9)).inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) continue;
                            this.select_option = 3;
                            this.select_order = (AnimatedOrder)this.activity.getOrders().get(n9);
                            this.select_order.setFilter(MenuView.filter_dark);
                            this.activity.playSound("standard_click");
                            return true;
                        }
                    }
                    if ((float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight() > 0.1f && (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight() < 0.5f) {
                        this.clickx = motionEvent.getX();
                    }
                    if (this.on_slot != -1 && this.select_option != 13 && this.select_option != 10 && this.select_option != 3) {
                        this.activity.getCooking(this.getAppCode(this.select_appliance))[this.on_slot].deselect();
                        this.on_slot = -1;
                        this.activity.playSound("standard_click");
                    }
                } else if (this.orderloaded) {
                    if (this.deliveryloaded) {
                        for (int i = 0; i < this.deliveries.size(); ++i) {
                            if (((AnimatedDelivery)this.deliveries.get(i)).inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight()) && this.activity.getDeliveryState(i) < 2) {
                                this.select_option = 14;
                                this.select_delivery = i;
                                ((AnimatedDelivery)this.deliveries.get(i)).setFilter(MenuView.filter_dark);
                                this.activity.playSound("standard_click");
                                return true;
                            }
                            if (!this.deliveryno.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) continue;
                            this.select_option = 21;
                            this.deliveryno.setFilter(MenuView.filter_dark);
                            this.activity.playSound("standard_click");
                            return true;
                        }
                        return true;
                    }
                    if (this.orderok.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                        this.select_option = 4;
                        this.orderok.setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                        return true;
                    }
                    for (int i = 0; i < this.activity.getOrders().size(); ++i) {
                        if (!((AnimatedOrder)this.activity.getOrders().get(i)).inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) continue;
                        this.select_option = 3;
                        this.select_order = (AnimatedOrder)this.activity.getOrders().get(i);
                        this.select_order.setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                        return true;
                    }
                } else {
                    int n11;
                    for (n11 = 0; n11 < this.appliances.size(); ++n11) {
                        if (!((Appliance)this.appliances.get(n11)).inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) continue;
                        this.select_option = 5;
                        this.select_appliance = (Appliance)this.appliances.get(n11);
                        this.select_appliance.setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                        return true;
                    }
                    for (n11 = 0; n11 < this.activity.getOrders().size(); ++n11) {
                        if (!((AnimatedOrder)this.activity.getOrders().get(n11)).inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) continue;
                        this.select_option = 3;
                        this.select_order = (AnimatedOrder)this.activity.getOrders().get(n11);
                        this.select_order.setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                        return true;
                    }
                }
                return true;
            }
            case 3: {
                switch (this.select_option) {
                    case 22: {
                        if (this.levelupok.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.levelupok.setFilter(null);
                        break;
                    }
                    case 21: {
                        if (this.deliveryno.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.deliveryno.setFilter(null);
                        break;
                    }
                    case 18: {
                        if (this.quit.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.quit.setFilter(null);
                        break;
                    }
                    case 19: {
                        if (this.sound.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.sound.setFilter(null);
                        break;
                    }
                    case 20: {
                        if (this.back.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.back.setFilter(null);
                        break;
                    }
                    case 17: {
                        if (this.dialog_btn.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.dialog_btn.setFilter(null);
                        break;
                    }
                    case 1: {
                        if (this.map.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.map.setFilter(null);
                        break;
                    }
                    case 2: {
                        if (this.pause.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.pause.setFilter(null);
                        break;
                    }
                    case 15: {
                        if (this.upback.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.upback.setFilter(null);
                        break;
                    }
                    case 16: {
                        if (this.upupgrade.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.upupgrade.setFilter(null);
                        break;
                    }
                    case 3: {
                        if (this.select_order.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.select_order.setFilter(null);
                        this.select_order = null;
                        break;
                    }
                    case 4: {
                        if (this.orderok.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.orderok.setFilter(null);
                        break;
                    }
                    case 5: {
                        if (this.select_appliance.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.select_appliance.setFilter(null);
                        this.select_appliance = null;
                        break;
                    }
                    case 6: {
                        if (this.appok.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.appok.setFilter(null);
                        break;
                    }
                    case 7: {
                        if (this.appnext.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.appnext.setFilter(null);
                        break;
                    }
                    case 8: {
                        if (this.appprev.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.appprev.setFilter(null);
                        break;
                    }
                    case 9: {
                        if (this.appmenu[this.select_menu].inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.appmenu[this.select_menu].setFilter(null);
                        this.select_menu = -1;
                        break;
                    }
                    case 11: {
                        if (this.appplus.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.appplus.setFilter(null);
                        break;
                    }
                    case 10: 
                    case 12: {
                        if (this.activity.getCooking(this.getAppCode(this.select_appliance))[this.select_slot].inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.activity.getCooking(this.getAppCode(this.select_appliance))[this.select_slot].setFilter(null);
                        this.select_slot = -1;
                        break;
                    }
                    case 13: {
                        if (this.apptrash.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.apptrash.setFilter(null);
                        break;
                    }
                    case 14: {
                        if (((AnimatedDelivery)this.deliveries.get(this.select_delivery)).inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        ((AnimatedDelivery)this.deliveries.get(this.select_delivery)).setFilter(null);
                        this.select_delivery = -1;
                    }
                }
                if (this.clickx != -1.0f && this.apploaded && this.select_option == 0) {
                    if ((float)motionEvent.getX() - this.clickx > (float)(this.activity.getCanvas().getWidth() / 10)) {
                        this.appPrev(this.last_time);
                        this.clickx = -1.0f;
                    } else if (this.clickx - (float)motionEvent.getX() > (float)(this.activity.getCanvas().getWidth() / 10)) {
                        this.appNext(this.last_time);
                        this.clickx = -1.0f;
                    }
                }
                return true;
            }
        }
        return true;
    }

    public static class MenuOption {
        public static final int NONE = 0;
        public static final int MAP = 1;
        public static final int PAUSE = 2;
        public static final int ORDER = 3;
        public static final int ORDER_OK = 4;
        public static final int APPLIANCE = 5;
        public static final int APP_OK = 6;
        public static final int APP_NEXT = 7;
        public static final int APP_PREV = 8;
        public static final int APP_MENU = 9;
        public static final int APP_SLOT = 10;
        public static final int APP_PLUS = 11;
        public static final int APP_PLUSSLOT = 12;
        public static final int APP_TRASH = 13;
        public static final int DELIVERY = 14;
        public static final int UP_BACK = 15;
        public static final int UP_UPGRADE = 16;
        public static final int DIALOG = 17;
        public static final int QUIT = 18;
        public static final int SOUND = 19;
        public static final int BACK = 20;
        public static final int DELIVERY_NO = 21;
        public static final int LEVELUP_OK = 22;
    }
}

