/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.WorldLayerPiece;
import baltorogames.project_gameplay.WorldObject;
import java.io.DataInputStream;
import java.io.IOException;

public class WorldLayer {
    protected WorldLayerPiece[] m_arrLayerPieces = null;
    protected int m_nPiecesSize = 0;

    public int Load(DataInputStream dataInputStream) throws IOException {
        this.Destroy();
        this.m_nPiecesSize = dataInputStream.readInt();
        this.m_arrLayerPieces = new WorldLayerPiece[this.m_nPiecesSize];
        for (int i = 0; i < this.m_nPiecesSize; ++i) {
            this.m_arrLayerPieces[i] = new WorldLayerPiece();
            this.m_arrLayerPieces[i].Load(dataInputStream);
        }
        return 1;
    }

    public WorldLayerPiece GetLayerPiece(int n) {
        return this.m_arrLayerPieces[n];
    }

    public int GetPiecesSize() {
        return this.m_nPiecesSize;
    }

    public void ActiveAllObjects() {
        for (int i = 0; i < this.m_nPiecesSize; ++i) {
            this.m_arrLayerPieces[i].ActiveAllObjects();
        }
    }

    public void Render(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.m_nPiecesSize) {
            n2 = this.m_nPiecesSize - 1;
        }
        for (int i = n; i <= n2; ++i) {
            this.m_arrLayerPieces[i].Render();
        }
    }

    public void Destroy() {
        if (this.m_arrLayerPieces != null) {
            for (int i = 0; i < this.m_nPiecesSize; ++i) {
                if (this.m_arrLayerPieces[i] == null) continue;
                this.m_arrLayerPieces[i].Destroy();
                this.m_arrLayerPieces[i] = null;
            }
            this.m_arrLayerPieces = null;
        }
        this.m_nPiecesSize = 0;
    }

    WorldObject FindByTextureName(String string) {
        int n = this.m_arrLayerPieces.length;
        for (int i = 0; i < n; ++i) {
            WorldObject worldObject = this.m_arrLayerPieces[i].FindByTextureName(string);
            if (worldObject == null) continue;
            return worldObject;
        }
        return null;
    }

    WorldObject FindByCollisionID(int n) {
        int n2 = this.m_arrLayerPieces.length;
        for (int i = 0; i < n2; ++i) {
            WorldObject worldObject = this.m_arrLayerPieces[i].FindByCollisionID(n);
            if (worldObject == null) continue;
            return worldObject;
        }
        return null;
    }
}

