/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.system.BGStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CGUserCareer {
    public static final int eMaxLevels = 45;
    public static final int eNumTimedLevels = 3;
    public static final int eNumSurvivalLevels = 3;
    public static final int eNumBoost = 5;
    public static final int eNumSpecialJewels = 5;
    public static boolean isStoryTutorialOn = true;
    public static boolean isSurvivalTutorialOn = true;
    public static boolean isStoryPopupInfoOn = true;
    public static boolean isSurviPopupInfoOn = true;
    public static boolean isSequencePopupInfoOn = true;
    protected static String m_szNick = new String("");
    protected static String m_szDevicePlatform;
    protected static int m_nAdventureLevel;
    public static int[] m_arrLevelScore;
    public static int[] m_arrLevelBestScore;
    public static int m_nMoney;
    public static int[] m_nBestSurvivalScore;
    public static int[] m_nBestSequenceScore;
    public static boolean[] m_arrBoostAvailable;
    public static boolean[] m_arrSpecjalJewelInfoNeeded;
    public static boolean[] m_arrWorldUnlockInfoNeeded;
    public static boolean m_bReadyToSave;

    public static void Reset() {
        int n;
        m_nAdventureLevel = 0;
        isStoryTutorialOn = true;
        isSurvivalTutorialOn = true;
        isStoryPopupInfoOn = true;
        isSurviPopupInfoOn = true;
        isSequencePopupInfoOn = true;
        m_szNick = "";
        m_szDevicePlatform = "";
        m_arrLevelScore = new int[45];
        m_arrLevelBestScore = new int[45];
        for (n = 0; n < 45; ++n) {
            CGUserCareer.m_arrLevelScore[n] = 0;
            CGUserCareer.m_arrLevelBestScore[n] = 0;
        }
        m_arrSpecjalJewelInfoNeeded = new boolean[5];
        for (n = 0; n < 5; ++n) {
            CGUserCareer.m_arrSpecjalJewelInfoNeeded[n] = true;
        }
        m_arrWorldUnlockInfoNeeded = new boolean[2];
        for (n = 0; n < 2; ++n) {
            CGUserCareer.m_arrWorldUnlockInfoNeeded[n] = true;
        }
        m_nMoney = 0;
        m_nBestSequenceScore = new int[3];
        for (n = 0; n < 3; ++n) {
            CGUserCareer.m_nBestSequenceScore[n] = 0;
        }
        m_nBestSurvivalScore = new int[3];
        for (n = 0; n < 3; ++n) {
            CGUserCareer.m_nBestSurvivalScore[n] = 0;
        }
        m_arrBoostAvailable = new boolean[5];
        CGUserCareer.m_arrBoostAvailable[0] = true;
        for (n = 1; n < 5; ++n) {
            CGUserCareer.m_arrBoostAvailable[n] = false;
        }
    }

    public static boolean IsGoodScore(int n) {
        return n > m_arrLevelScore[9];
    }

    public static void Load() {
        CGUserCareer.Reset();
        m_bReadyToSave = true;
        BGStore bGStore = BGStore.openStoreToRead("UserCareer");
        if (bGStore == null) {
            return;
        }
        try {
            DataInputStream dataInputStream = bGStore.getInStream();
            if (dataInputStream != null && dataInputStream.available() > 0) {
                int n;
                m_nAdventureLevel = dataInputStream.readInt();
                m_arrLevelScore = new int[45];
                for (n = 0; n < 45; ++n) {
                    CGUserCareer.m_arrLevelScore[n] = dataInputStream.readInt();
                }
                m_arrLevelBestScore = new int[45];
                for (n = 0; n < 45; ++n) {
                    CGUserCareer.m_arrLevelBestScore[n] = dataInputStream.readInt();
                }
                m_arrSpecjalJewelInfoNeeded = new boolean[5];
                for (n = 0; n < 5; ++n) {
                    CGUserCareer.m_arrSpecjalJewelInfoNeeded[n] = dataInputStream.readBoolean();
                }
                m_arrWorldUnlockInfoNeeded = new boolean[2];
                for (n = 0; n < 2; ++n) {
                    CGUserCareer.m_arrWorldUnlockInfoNeeded[n] = dataInputStream.readBoolean();
                }
                m_nMoney = dataInputStream.readInt();
                for (n = 0; n < 3; ++n) {
                    CGUserCareer.m_nBestSurvivalScore[n] = dataInputStream.readInt();
                }
                for (n = 0; n < 3; ++n) {
                    CGUserCareer.m_nBestSequenceScore[n] = dataInputStream.readInt();
                }
                for (n = 0; n < m_arrBoostAvailable.length; ++n) {
                    CGUserCareer.m_arrBoostAvailable[n] = dataInputStream.readBoolean();
                }
                isStoryTutorialOn = dataInputStream.readBoolean();
                isSurvivalTutorialOn = dataInputStream.readBoolean();
                isStoryPopupInfoOn = dataInputStream.readBoolean();
                isSurviPopupInfoOn = dataInputStream.readBoolean();
                isSequencePopupInfoOn = dataInputStream.readBoolean();
            }
            bGStore.close();
        }
        catch (Exception exception) {
            CGUserCareer.Reset();
            return;
        }
    }

    public static void Save() {
        if (!m_bReadyToSave) {
            return;
        }
        if (m_arrLevelScore == null) {
            return;
        }
        if (m_arrLevelBestScore == null) {
            return;
        }
        BGStore bGStore = BGStore.openStoreToWrite("UserCareer");
        if (bGStore == null) {
            return;
        }
        try {
            int n;
            DataOutputStream dataOutputStream = bGStore.getOutStream();
            dataOutputStream.writeInt(m_nAdventureLevel);
            for (n = 0; n < 45; ++n) {
                dataOutputStream.writeInt(m_arrLevelScore[n]);
            }
            for (n = 0; n < 45; ++n) {
                dataOutputStream.writeInt(m_arrLevelBestScore[n]);
            }
            for (n = 0; n < 5; ++n) {
                dataOutputStream.writeBoolean(m_arrSpecjalJewelInfoNeeded[n]);
            }
            for (n = 0; n < 2; ++n) {
                dataOutputStream.writeBoolean(m_arrWorldUnlockInfoNeeded[n]);
            }
            dataOutputStream.writeInt(m_nMoney);
            for (n = 0; n < 3; ++n) {
                dataOutputStream.writeInt(m_nBestSurvivalScore[n]);
            }
            for (n = 0; n < 3; ++n) {
                dataOutputStream.writeInt(m_nBestSequenceScore[n]);
            }
            for (n = 0; n < m_arrBoostAvailable.length; ++n) {
                dataOutputStream.writeBoolean(m_arrBoostAvailable[n]);
            }
            dataOutputStream.writeBoolean(isStoryTutorialOn);
            dataOutputStream.writeBoolean(isSurvivalTutorialOn);
            dataOutputStream.writeBoolean(isStoryPopupInfoOn);
            dataOutputStream.writeBoolean(isSurviPopupInfoOn);
            dataOutputStream.writeBoolean(isSequencePopupInfoOn);
            bGStore.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void SetAdventureLevel(int n) {
        m_nAdventureLevel = n;
    }

    public static int GetAdventureLevel() {
        return m_nAdventureLevel;
    }

    public static void SetNick(String string) {
        m_szNick = string;
    }

    public static String GetNick() {
        return m_szNick;
    }

    public static void SetDevicePlatform(String string) {
        m_szDevicePlatform = string;
    }

    public static String GetDevicePlatform() {
        return m_szDevicePlatform;
    }

    public static void UnlockAllLevels() {
        m_nAdventureLevel = 45;
        for (int i = 0; i < 45; ++i) {
            CGUserCareer.m_arrLevelScore[i] = 3;
        }
    }

    public static void UnlockAllBoosts() {
        for (int i = 0; i < m_arrBoostAvailable.length; ++i) {
            CGUserCareer.m_arrBoostAvailable[i] = true;
        }
    }

    static {
        m_nAdventureLevel = 0;
        m_arrLevelScore = new int[45];
        m_arrLevelBestScore = new int[45];
        m_nMoney = 0;
        m_bReadyToSave = false;
    }
}

