/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.ListInt;
import baltorogames.system.Options;
import java.util.Vector;

public class AchievementPopup {
    private static Vector infoList = new Vector();
    private static long startTime = 0L;
    private static float m_xpos;
    private static float m_ypos;
    private static float m_width;
    private static float m_height;
    private static CGTexture backTexture;
    private static String text;

    public static void Init() {
        startTime = 0L;
        backTexture = TextureManager.CreateFilteredTexture("/menu/achievement_popup.png");
        m_width = 680.0f;
        m_height = 130.0f;
        m_xpos = -100.0f;
        m_ypos = 700.0f - m_height;
    }

    public static boolean IsEnabled() {
        return startTime > 0L;
    }

    public static void Step() {
        if (startTime > 0L) {
            long l = ApplicationData.getAppTime() - startTime;
            if (l > 2000L) {
                if (infoList.size() > 0) {
                    int n = ((ListInt)AchievementPopup.infoList.elementAt((int)0)).nValue;
                    infoList.removeElementAt(0);
                    AchievementPopup.NewAchievementInfoInternal(n);
                } else {
                    startTime = 0L;
                }
            } else {
                AchievementPopup.Render(l);
            }
        }
    }

    public static void NewAchievement(int n) {
        if (startTime > 0L) {
            ListInt listInt = new ListInt();
            listInt.nValue = n;
            infoList.addElement(listInt);
        } else {
            AchievementPopup.NewAchievementInfoInternal(n);
        }
    }

    private static void NewAchievementInfoInternal(int n) {
        startTime = ApplicationData.getAppTime();
        if (n < 100) {
            text = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ACHIEVEMENT_HEADER_" + n);
        }
    }

    private static void Render(long l) {
        float f = 0.0f;
        if (l <= 300L) {
            f = (float)l / 300.0f;
        } else if (l <= 2500L) {
            f = 1.0f;
        } else if (l <= 2800L) {
            f = 1.0f - (float)(l - 2500L) / 300.0f;
        } else if (l <= 3000L) {
            f = 0.0f;
        }
        if (f == 1.0f) {
            float f2 = CGEngineRenderer.m_fScreenOffsetY + m_ypos * CGEngine.m_fEngineScale + (CGEngineRenderer.m_fScreenOffsetY + (m_ypos + m_height) * CGEngine.m_fEngineScale);
            Graphic2D.DrawImage(backTexture, ApplicationData.screenWidth / 2, (int)(f2 / 2.0f), 3);
            Utils.drawString(text, ApplicationData.screenWidth / 2, (int)(f2 / 2.0f), 3, 0);
        }
    }

    static {
        backTexture = null;
        text = new String();
    }
}

