/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core;

public class MathExt {
    static final double sq2p1 = 2.414213562373095;
    static final double sq2m1 = 0.41421356237309503;
    static final double p4 = 16.15364129822302;
    static final double p3 = 268.42548195503974;
    static final double p2 = 1153.029351540485;
    static final double p1 = 1780.406316433197;
    static final double p0 = 896.7859740366387;
    static final double q4 = 58.95697050844462;
    static final double q3 = 536.2653740312153;
    static final double q2 = 1666.7838148816338;
    static final double q1 = 2079.33497444541;
    static final double q0 = 896.7859740366387;
    static final double PIO2 = 1.5707963267948966;
    static final double nan = Double.NaN;

    private static double mxatan(double d) {
        double d2 = d * d;
        double d3 = (((16.15364129822302 * d2 + 268.42548195503974) * d2 + 1153.029351540485) * d2 + 1780.406316433197) * d2 + 896.7859740366387;
        return (d3 /= ((((d2 + 58.95697050844462) * d2 + 536.2653740312153) * d2 + 1666.7838148816338) * d2 + 2079.33497444541) * d2 + 896.7859740366387) * d;
    }

    private static double msatan(double d) {
        if (d < 0.41421356237309503) {
            return MathExt.mxatan(d);
        }
        if (d > 2.414213562373095) {
            return 1.5707963267948966 - MathExt.mxatan(1.0 / d);
        }
        return 0.7853981633974483 + MathExt.mxatan((d - 1.0) / (d + 1.0));
    }

    public static double atan(double d) {
        if (d > 0.0) {
            return MathExt.msatan(d);
        }
        return -MathExt.msatan(-d);
    }

    public static double atan2(double d, double d2) {
        if (d + d2 == d) {
            if (d >= 0.0) {
                return 1.5707963267948966;
            }
            return -1.5707963267948966;
        }
        d = MathExt.atan(d / d2);
        if (d2 < 0.0) {
            if (d <= 0.0) {
                return d + Math.PI;
            }
            return d - Math.PI;
        }
        return d;
    }

    public static double asin(double d) {
        int n = 0;
        if (d < 0.0) {
            d = -d;
            ++n;
        }
        if (d > 1.0) {
            return Double.NaN;
        }
        double d2 = Math.sqrt(1.0 - d * d);
        d2 = d > 0.7 ? 1.5707963267948966 - MathExt.atan(d2 / d) : MathExt.atan(d / d2);
        if (n > 0) {
            d2 = -d2;
        }
        return d2;
    }

    public static double acos(double d) {
        if (d > 1.0 || d < -1.0) {
            return Double.NaN;
        }
        return 1.5707963267948966 - MathExt.asin(d);
    }

    public static double Min(double d, double d2) {
        if (d < d2) {
            return d;
        }
        return d2;
    }

    public static double Max(double d, double d2) {
        if (d > d2) {
            return d;
        }
        return d2;
    }

    private static double Check_PointViaSection(double d, double d2, double d3, double d4, double d5, double d6) {
        return d * d4 * 1.0 + d3 * d6 * 1.0 + d2 * 1.0 * d5 - 1.0 * d4 * d5 - 1.0 * d6 * d - 1.0 * d2 * d3;
    }

    private static boolean Check_PointInSection(double d, double d2, double d3, double d4, double d5, double d6) {
        return d5 >= MathExt.Min(d, d3) && d5 <= MathExt.Max(d, d3) && d6 >= MathExt.Min(d2, d4) && d6 <= MathExt.Max(d2, d4) && MathExt.Check_PointViaSection(d, d2, d3, d4, d5, d6) == 0.0;
    }

    private static boolean Check_QuickPointInSection(double d, double d2, double d3, double d4, double d5, double d6) {
        return d5 >= MathExt.Min(d, d3) && d5 <= MathExt.Max(d, d3) && d6 >= MathExt.Min(d2, d4) && d6 <= MathExt.Max(d2, d4);
    }

    public static double CheckSections(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d4 - d2;
        double d10 = d - d3;
        double d11 = -(d9 * d + d10 * d2);
        double d12 = d8 - d6;
        double d13 = d5 - d7;
        double d14 = -(d12 * d5 + d13 * d6);
        double d15 = d9 * d13 - d12 * d10;
        if (d15 == 0.0) {
            return -1.0;
        }
        double d16 = -d11 * d13 - -d14 * d10;
        double d17 = d9 * -d14 - d12 * -d11;
        double d18 = d16 / d15;
        double d19 = d17 / d15;
        if (d5 == d7) {
            d18 = d5;
        }
        if (d6 == d8) {
            d19 = d6;
        }
        if (d == d3) {
            d18 = d;
        }
        if (d2 == d4) {
            d19 = d2;
        }
        if (!MathExt.Check_QuickPointInSection(d, d2, d3, d4, d18, d19)) {
            return -1.0;
        }
        if (!MathExt.Check_QuickPointInSection(d5, d6, d7, d8, d18, d19)) {
            return -1.0;
        }
        if (d != d3) {
            return (d18 - d) / (d3 - d);
        }
        return (d19 - d2) / (d4 - d2);
    }

    public static float GetBezierValueX(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f;
        float f11 = f2;
        float f12 = f7;
        float f13 = f8;
        float f14 = f3;
        float f15 = f4;
        float f16 = f5;
        float f17 = f6;
        if (f9 <= 0.0f) {
            return f10;
        }
        if (f9 >= 1.0f) {
            return f12;
        }
        float f18 = f9;
        float f19 = f18 * f18;
        float f20 = f18 * f19;
        float f21 = 1.0f - f18;
        float f22 = f21 * f21;
        float f23 = f21 * f22;
        return f23 * f10 + 3.0f * f18 * f22 * f14 + 3.0f * f19 * f21 * f16 + f20 * f12;
    }

    public static float GetBezierValueY(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f;
        float f11 = f2;
        float f12 = f7;
        float f13 = f8;
        float f14 = f3;
        float f15 = f4;
        float f16 = f5;
        float f17 = f6;
        if (f9 <= 0.0f) {
            return f11;
        }
        if (f9 >= 1.0f) {
            return f13;
        }
        float f18 = f9;
        float f19 = f18 * f18;
        float f20 = f18 * f19;
        float f21 = 1.0f - f18;
        float f22 = f21 * f21;
        float f23 = f21 * f22;
        return f23 * f11 + 3.0f * f18 * f22 * f15 + 3.0f * f19 * f21 * f17 + f20 * f13;
    }
}

