/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core;

import baltorogames.core.ApplicationData;
import baltorogames.system.FileManager;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class LanguagePack {
    private int numStringID;
    private int[] stringIDs = null;
    private int[] fontIDs = null;
    private int numLanguages;
    private String[] languageNames;
    private Vector stringTranslations;
    private Vector stringTranslationsFonts;
    private Vector stringHashIDs;
    public static int currentLanguageID = -1;
    private static final int MAX_STRING_LETTERS = 1536;
    private static char[] charBuffer = new char[1536];
    private static byte[] byteBuffer = new byte[1536];
    private static byte[] byteBuffer2 = new byte[3072];

    public int getNumLanguages() {
        return this.numLanguages;
    }

    public static LanguagePack create(String string, int n) {
        LanguagePack languagePack = new LanguagePack();
        try {
            InputStream inputStream = FileManager.OpenFile(string);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            languagePack.deserializeLanguagePack(dataInputStream, n);
            dataInputStream.close();
            currentLanguageID = n;
        }
        catch (Exception exception) {
            languagePack = null;
        }
        return languagePack;
    }

    public String getTranslatedString(int n, String string) {
        if (n >= this.numLanguages) {
            n = 0;
        }
        int n2 = 0;
        try {
            for (n2 = 0; n2 < this.stringHashIDs.size(); ++n2) {
                String string2 = (String)this.stringHashIDs.elementAt(n2);
                if (string2.compareTo(string) != 0) continue;
                return (String)this.stringTranslations.elementAt(n2);
            }
            return "NO_STRING_FOUND";
        }
        catch (Exception exception) {
            return "NO_STRING_FOUND";
        }
    }

    private void deserializeLanguagePack(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        this.numStringID = dataInputStream.readInt();
        this.stringIDs = new int[this.numStringID];
        this.stringHashIDs = new Vector();
        this.fontIDs = new int[this.numStringID];
        for (n2 = 0; n2 < this.numStringID; ++n2) {
            this.stringIDs[n2] = dataInputStream.readInt();
            this.stringHashIDs.addElement(LanguagePack.deSerializeString(dataInputStream));
            this.fontIDs[n2] = dataInputStream.readInt();
        }
        this.numLanguages = dataInputStream.readInt();
        this.languageNames = new String[this.numLanguages];
        this.stringTranslations = null;
        this.stringTranslationsFonts = null;
        for (n2 = 0; n2 < this.numLanguages; ++n2) {
            int n3;
            String string;
            this.languageNames[n2] = string = LanguagePack.deSerializeString2(dataInputStream);
            if (n == n2) {
                this.stringTranslations = new Vector();
            }
            for (n3 = 0; n3 < this.numStringID; ++n3) {
                if (n == n2) {
                    String string2 = LanguagePack.deSerializeAndDecodeString(dataInputStream);
                    this.stringTranslations.addElement(string2);
                    continue;
                }
                LanguagePack.skipShortsString(dataInputStream);
            }
            n3 = dataInputStream.readInt();
            if (n == n2) {
                this.stringTranslationsFonts = new Vector();
            }
            for (int i = 0; i < n3; ++i) {
                if (n == n2) {
                    String string3 = LanguagePack.deSerializeString(dataInputStream);
                    this.stringTranslationsFonts.addElement(string3);
                    continue;
                }
                LanguagePack.skipString(dataInputStream);
            }
        }
    }

    public static String deSerializeString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        dataInputStream.read(byteBuffer, 0, n);
        return new String(byteBuffer, 0, n);
    }

    public static String deSerializeString2(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        dataInputStream.read(byteBuffer2, 0, n * 2);
        for (int i = 0; i < n; ++i) {
            LanguagePack.byteBuffer[i] = byteBuffer2[i * 2 + 1];
        }
        return new String(byteBuffer, 0, n);
    }

    public static String deSerializeAndDecodeString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            short s = dataInputStream.readShort();
            if (s == 13) {
                s = dataInputStream.readShort();
                if (s == 10) {
                    LanguagePack.charBuffer[i] = 255;
                    --n;
                    continue;
                }
                LanguagePack.charBuffer[i] = ApplicationData.defaultFont.getDecodedCharIndex(13);
                LanguagePack.charBuffer[i + 1] = ApplicationData.defaultFont.getDecodedCharIndex(s);
                ++i;
                continue;
            }
            LanguagePack.charBuffer[i] = ApplicationData.defaultFont.getDecodedCharIndex(s);
        }
        return new String(charBuffer, 0, n);
    }

    public static void skipString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        dataInputStream.skip(n);
    }

    public static void skipShortsString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        dataInputStream.skip(n * 2);
    }
}

