/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.system;

import baltorogames.core.ApplicationData;
import baltorogames.core.Log;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SoundEngine {
    private static int MUSIC_DEFAULT_VOLUME = 100;
    private static int DEFAULT_SFX_VOLUME = 100;
    public static int SOUND_VOLUME_SILENCE = 0;
    public static int SOUND_VOLUME_LOW = 100;
    public static int SOUND_VOLUME_MEDIUM = 100;
    public static int SOUND_VOLUME_HIGH = 100;
    private static final int MAXIMUM_NUMBER_OF_SOUNDS = 15;
    private boolean deviceIsMixCapable = false;
    public static int soundVolume = SOUND_VOLUME_SILENCE;
    private boolean enableSound = true;
    private boolean enableSFX = true;
    public static final int SOUND_MAIN_MENU_SHOW = 0;
    public static final int SOUND_MAIN_MENU_HIDE = 1;
    public static final int SOUND_LEVEL_LOADED = 2;
    public static final int SOUND_COUNT_DOWN_STARTED = 3;
    public static final int SOUND_RACE_STARTED = 4;
    public static final int SOUND_GAME_PAUSED = 5;
    public static final int SOUND_GAME_RESUMED = 6;
    public static final int SOUND_RACE_FINISHED = 7;
    public static final int SOUND_SKATE_1 = 8;
    public static final int SOUND_SKATE_2 = 9;
    public static final int SOUND_ITEM_CHANGED = 10;
    public static final int SOUND_ITEM_SELECTED = 11;
    public static final int SOUND_NITRO_AVAILABLE = 12;
    public static final int SOUND_NITRO_LAUNCHED = 13;
    public static final int SOUND_ENABLED = 14;
    public static final int SOUND_DISABLED = 15;
    public static final int SOUND_BEEP_1 = 16;
    public static final int SOUND_BEEP_2 = 17;
    public static final int SOUND_RABBIT = 18;
    public static final int SOUND_VOLUME_CHANGED = 19;
    private Player musicPlayer;
    private Player[] players = new Player[15];
    private boolean[] preFetchable = new boolean[]{true, true, true, true};
    public static String[] gameMusics = new String[]{"/antigravity.mid", "/breakneck.mid", "/skiJump.mid", "/antigravity.mid", "/breakneck.mid", "/skiJump.mid", "/antigravity.mid", "/breakneck.mid", "/skiJump.mid", "/antigravity.mid", "/breakneck.mid", "/skiJump.mid", "/antigravity.mid", "/breakneck.mid", "/skiJump.mid", "/antigravity.mid", "/breakneck.mid", "/skiJump.mid"};
    public static final int CROWD = 0;
    public static final int SKATE_1 = 1;
    public static final int SKATE_2 = 2;
    public static final int START_1 = 3;
    public static final int START_2 = 4;
    public static String[] soundNames = new String[]{"/crowd_1.wav", "/snow_skate_1.wav", "/snow_skate_2.wav", "/beep_start_1.wav", "/beep_start_2.wav"};

    public boolean isDeviceSupportMixing() {
        return this.deviceIsMixCapable;
    }

    public void enableSound() {
        this.enableSound = true;
    }

    public void disableSound() {
        this.enableSound = false;
    }

    public boolean isSoundEnabled() {
        return this.enableSound;
    }

    public void turnOnOrOff() {
        this.enableSound = !this.enableSound;
    }

    public void startMID(String string) {
        System.out.println("SOUND TO LAUNCH: " + string);
        if (!this.enableSound) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            try {
                Thread.sleep(20L);
                if (this.musicPlayer != null) {
                    this.musicPlayer.stop();
                    this.musicPlayer.close();
                    this.musicPlayer = null;
                }
                this.musicPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(string), (String)"audio/midi");
                this.musicPlayer.setLoopCount(-1);
                this.musicPlayer.start();
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Log.DEBUG_LOG(2, "Playing mid failed");
                continue;
            }
        }
    }

    public void pauseMID() {
        this.stopMID();
    }

    public void stopMID() {
        try {
            if (this.musicPlayer != null) {
                this.musicPlayer.stop();
                this.musicPlayer.close();
                this.musicPlayer = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopSound(int n) {
        try {
            if (this.players[n] != null) {
                this.players[n].stop();
                this.players[n].close();
                this.players[n] = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pauseSound(int n) {
        try {
            if (this.players[n] != null) {
                this.players[n].stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopAllSounds() {
        this.stopMID();
        for (int i = 0; i < 15; ++i) {
            this.stopSound(i);
        }
    }

    private void preCacheSounds() {
        for (int i = 0; i < soundNames.length; ++i) {
            if (!this.preFetchable[i]) continue;
            this.prefechSound(i);
        }
    }

    public boolean initialize() {
        try {
            this.deviceIsMixCapable = System.getProperty("supports.mixing").compareTo("true") == 0;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void prefechSound(int n) {
        if (!(this.enableSound && this.enableSFX && this.deviceIsMixCapable)) {
            return;
        }
        try {
            if (this.players[n] == null) {
                this.players[n] = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(soundNames[n]), (String)"audio/x-wav");
            }
            this.players[n].realize();
            this.players[n].prefetch();
            return;
        }
        catch (Exception exception) {
            try {
                if (this.players[n] == null) {
                    this.players[n] = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(soundNames[n]), (String)"audio/mpeg");
                }
                this.players[n].realize();
                this.players[n].prefetch();
                return;
            }
            catch (Exception exception2) {
                return;
            }
        }
    }

    private void playSound(int n) {
        this._playSound(n, false);
    }

    private void _playSound(int n, boolean bl) {
        if (!(this.enableSound && this.enableSFX && this.deviceIsMixCapable)) {
            return;
        }
        try {
            if (this.players[n] == null) {
                this.players[n] = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(soundNames[n]), (String)"audio/x-wav");
            }
            if (this.players[n].getState() != 400) {
                if (bl) {
                    this.players[n].setLoopCount(-1);
                }
                this.players[n].start();
                VolumeControl volumeControl = (VolumeControl)this.players[n].getControl("VolumeControl");
                if (volumeControl != null) {
                    volumeControl.setLevel(soundVolume);
                }
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void onGameEvent(int n, Object object) {
        switch (n) {
            case 2: {
                this.stopMID();
                this.preCacheSounds();
                break;
            }
            case 1: {
                break;
            }
            case 8: {
                this.playSound(1);
                break;
            }
            case 9: {
                this.playSound(2);
                break;
            }
            case 16: {
                this.playSound(3);
                break;
            }
            case 17: {
                this.playSound(4);
                break;
            }
            case 7: {
                this.playSound(0);
                break;
            }
            case 14: {
                this.enableSound = true;
                break;
            }
            case 15: {
                ApplicationData.soundEngine.stopAllSounds();
                this.enableSound = false;
                break;
            }
            case 19: {
                if (SOUND_VOLUME_SILENCE == soundVolume) {
                    this.enableSound = true;
                    soundVolume = SOUND_VOLUME_MEDIUM;
                    break;
                }
                if (SOUND_VOLUME_MEDIUM != soundVolume) break;
                ApplicationData.soundEngine.stopAllSounds();
                this.enableSound = false;
                soundVolume = SOUND_VOLUME_SILENCE;
            }
        }
    }

    void playerUpdate(Player player, String string, Object object) {
    }
}

