/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGJewel;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.EndOfCareerScreen;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.SelectWorldScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class StoryScoreScreen
extends MainScreen {
    protected String strLine1 = null;
    protected String strLine2 = null;
    protected String strLine3 = null;
    private UIFloatingTextBox resultspointsBox;
    private UIFloatingTextBox windowHeader;
    private UIFloatingTextBox currBestScoreBox;
    public int m_nMinimumScore;
    public int m_nCurrentScore;
    public int m_nStarsY;
    protected boolean m_bEndOfCareer = false;
    CGTexture[] m_Textures;
    private int nScore;

    public StoryScoreScreen(int n) {
        this.nScore = n;
        this.autoSize();
        this.m_Textures = new CGTexture[2];
        this.m_Textures[0] = TextureManager.AddTexture("/menu/star_empty.png");
        this.m_Textures[1] = TextureManager.AddTexture("/menu/star_full.png");
        this.drawTitle = false;
        int n2 = ApplicationData.screenHeight / 2 - 6 * ApplicationData.getFontByID(0).getFontHeight();
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = 3 * ApplicationData.defaultFont.getFontHeight();
        int n4 = ApplicationData.screenWidth - 2;
        this.resultspointsBox = new UIFloatingTextBox(false, (ApplicationData.screenWidth - n4) / 2, n2, n4, n3);
        this.windowHeader = new UIFloatingTextBox(false, (ApplicationData.screenWidth - n4) / 2, n2 - n3, n4, n3);
        this.currBestScoreBox = new UIFloatingTextBox(false, (ApplicationData.screenWidth - n4) / 2, n2 + 2 * ApplicationData.defaultFont.getFontHeight(), n4, n3);
        this.m_nCurrentScore = CGLevelStats.m_nScore;
        this.m_nMinimumScore = CGEngine.m_arrStoryLevelScoreNeeded[CGEngine.m_nCurrentStoryLevel];
        if (CGLevelStats.m_nScore > CGUserCareer.m_arrLevelBestScore[CGEngine.m_nCurrentStoryLevel]) {
            CGUserCareer.m_arrLevelBestScore[CGEngine.m_nCurrentStoryLevel] = CGLevelStats.m_nScore;
        }
        this.m_nStarsY = (n2 += n3) + n3;
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbCANCEL, ObjectsCache.menuSbCANCEL_a);
        this.UpdateInfo();
    }

    public void UpdateInfo() {
        CGTexture cGTexture;
        CGTexture cGTexture2;
        this.strLine2 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_RESULTS_WHACKED") + ApplicationData.defaultFont.encodeDynamicString(" " + CGLevelStats.m_nScore);
        this.resultspointsBox.setText(this.strLine2);
        this.strLine3 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_SCORE_HEADER") + ApplicationData.defaultFont.encodeDynamicString(": " + CGUserCareer.m_arrLevelBestScore[CGEngine.m_nCurrentStoryLevel]);
        this.currBestScoreBox.setText(this.strLine3);
        if (this.nScore < 0) {
            this.windowHeader.setText(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_RESULT_LOST"));
        } else {
            this.windowHeader.setText(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_RESULT_WIN"));
        }
        CGEngine.m_bPause = true;
        CGEngine.m_bGameActive = false;
        CGTexture cGTexture3 = TextureManager.AddTexture("/menu/selectlevel.png");
        CGTexture cGTexture4 = TextureManager.AddTexture("/menu/selectlevel_s.png");
        CGAchievements.completeAchievement(0);
        if (this.m_nCurrentScore >= this.m_nMinimumScore) {
            if (CGUserCareer.GetAdventureLevel() < CGEngine.m_nCurrentStoryLevel + 1) {
                CGUserCareer.SetAdventureLevel(CGEngine.m_nCurrentStoryLevel + 1);
            }
            if (CGEngine.m_nCurrentStoryLevel + 1 >= 45) {
                CGAchievements.completeAchievement(6);
                this.m_bEndOfCareer = true;
            }
            cGTexture2 = TextureManager.AddTexture("/menu/play.png");
            cGTexture = TextureManager.AddTexture("/menu/play_s.png");
        } else {
            cGTexture2 = TextureManager.AddTexture("/menu/restart.png");
            cGTexture = TextureManager.AddTexture("/menu/restart_s.png");
        }
        this.setSoftButtonImage(cGTexture3, cGTexture4, cGTexture2, cGTexture);
    }

    public void onUpdate(float f) {
        super.onUpdate(f);
    }

    public void drawWindowBackground() {
        super.drawWindowBackground();
        this.resultspointsBox.draw();
        this.windowHeader.draw();
        this.currBestScoreBox.draw();
        int n = this.m_nStarsY + this.m_Textures[0].GetHeight();
        int n2 = ApplicationData.screenWidth / 2;
        Graphic2D.DrawImage(this.m_Textures[0], n2 - 5 * this.m_Textures[0].GetWidth() / 4, n, 3);
        Graphic2D.DrawImage(this.m_Textures[0], n2, n, 3);
        Graphic2D.DrawImage(this.m_Textures[0], n2 + 5 * this.m_Textures[0].GetWidth() / 4, n, 3);
        if (this.m_nCurrentScore >= this.m_nMinimumScore) {
            Graphic2D.DrawImage(this.m_Textures[1], n2 - 5 * this.m_Textures[0].GetWidth() / 4, n, 3);
        }
        if (this.m_nCurrentScore >= this.m_nMinimumScore + this.m_nMinimumScore / 2) {
            Graphic2D.DrawImage(this.m_Textures[1], n2, n, 3);
        }
        if (this.m_nCurrentScore >= 2 * this.m_nMinimumScore) {
            Graphic2D.DrawImage(this.m_Textures[1], n2 + 5 * this.m_Textures[0].GetWidth() / 4, n, 3);
            CGAchievements.completeAchievement(5);
        }
    }

    public boolean leftSoftButton() {
        CGSoundSystem.Play(2, false);
        ApplicationData.setMainMenuMode();
        CGEngine.m_bPause = false;
        CGEngine.m_bGameActive = false;
        UIScreen.SetCurrentScreen(null);
        ApplicationData.SetMusic();
        ApplicationData.goToMainMenu();
        this.readyForClose = true;
        return true;
    }

    public boolean rightSoftButton() {
        CGSoundSystem.Play(2, false);
        CGLevelStats.m_nScore = 0;
        if (this.m_bEndOfCareer) {
            CGSoundSystem.Play(2, false);
            UIScreen.SetNextScreen(new EndOfCareerScreen());
            UIScreen.GetNextScreen().setParent(this);
            this.readyForClose = true;
        } else {
            if (this.m_nCurrentScore >= this.m_nMinimumScore) {
                ++CGEngine.m_nCurrentStoryLevel;
            }
            if (CGEngine.m_nCurrentStoryLevel == 15 || CGEngine.m_nCurrentStoryLevel == 30) {
                UIScreen.SetNextScreen(new SelectWorldScreen(CGEngine.m_nCurrentStoryLevel / 15));
                UIScreen.GetNextScreen().setParent(this);
                this.readyForClose = true;
            } else {
                CGJewel.NUM_JEWEL_COLORS = CGEngine.m_arrNumberOfJewelPerLvl[CGEngine.m_nCurrentStoryLevel];
                CGBoard.m_nNrofTypes = CGEngine.m_arrNumberOfJewelPerLvl[CGEngine.m_nCurrentStoryLevel];
                String string = "/level_" + CGEngine.m_nCurrentWorld + ".lrs";
                ApplicationData.getGame().startLoading(string);
                ApplicationData.getGame().stepLoading(string);
                ApplicationData.getGame().stepLoading(string);
                ApplicationData.getGame().stepLoading(string);
                ApplicationData.getGame().stepLoading(string);
                ApplicationData.getGame().endLoading(string);
                ApplicationData.generalGameMode = 4;
                CGEngine.m_bGameActive = true;
                this.readyForClose = true;
            }
        }
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }
}

