/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gui.MainScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class AchievementsScreen
extends MainScreen {
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    public static int selectedAchiev = 0;
    private int nStartBoxY = 0;
    private int nStopBoxY = 0;
    private int nBoxWidth = 0;
    private UIFloatingTextBox infoBox;
    private String csText1;
    private String csText2;
    private CGTexture[] achievImages = null;

    protected void Clean() {
        if (this.achievImages != null) {
            for (int i = 0; i < 2; ++i) {
                TextureManager.DeleteTexture(this.achievImages[i]);
                this.achievImages[i] = null;
            }
        }
        this.achievImages = null;
    }

    public void onFocusBack() {
        super.onFocusBack();
        if (this.achievImages == null) {
            this.achievImages = new CGTexture[2];
            this.achievImages[0] = TextureManager.AddTexture("/menu/achi_ico.png");
            this.achievImages[1] = TextureManager.AddTexture("/menu/achi_ico_n.png");
        }
    }

    public AchievementsScreen() {
        int n;
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        selectedAchiev = 0;
        this.drawTop = true;
        this.drawTitle = false;
        this.setCaption(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ACHIEVEMENTS"));
        this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.achievImages = new CGTexture[2];
        this.achievImages[0] = TextureManager.AddTexture("/menu/achi_ico.png");
        this.achievImages[1] = TextureManager.AddTexture("/menu/achi_ico_n.png");
        int n2 = ApplicationData.screenWidth / 2 - this.achievImages[0].GetWidth() / 2;
        int n3 = ApplicationData.screenHeight / 2 - this.achievImages[0].GetHeight();
        int n4 = n3 + this.achievImages[0].GetHeight() / 2 - ObjectsCache.arrowLeft.GetHeight() / 2;
        int n5 = (ApplicationData.screenWidth / 2 - this.achievImages[0].GetWidth() / 2) / 2 - ObjectsCache.arrowLeft.GetWidth() / 2;
        if (n5 < 0) {
            n5 = 0;
        }
        if ((n = ApplicationData.screenWidth / 2 + this.achievImages[0].GetWidth() / 2 + (ApplicationData.screenWidth - (ApplicationData.screenWidth / 2 + this.achievImages[0].GetWidth() / 2)) / 2 - ObjectsCache.arrowLeft.GetWidth() / 2) > ApplicationData.screenWidth - ObjectsCache.arrowLeft.GetWidth()) {
            n = ApplicationData.screenWidth - ObjectsCache.arrowLeft.GetWidth();
        }
        UIAnimatedButtonH uIAnimatedButtonH = new UIAnimatedButtonH(n, n4, ObjectsCache.arrowRight, ObjectsCache.arrowRight_a, 101);
        uIAnimatedButtonH.setScreen(this);
        uIAnimatedButtonH.setAnimDir(1.0f);
        this.addButton(uIAnimatedButtonH);
        UIAnimatedButtonH uIAnimatedButtonH2 = new UIAnimatedButtonH(n5, n4, ObjectsCache.arrowLeft, ObjectsCache.arrowLeft_a, 100);
        uIAnimatedButtonH2.setScreen(this);
        uIAnimatedButtonH2.setAnimDir(-1.0f);
        this.addButton(uIAnimatedButtonH2);
        this.nStartBoxY = n3 + this.achievImages[0].GetHeight();
        this.nStopBoxY = ApplicationData.screenHeight - ObjectsCache.menuSbOK.GetHeight() - ApplicationData.getFontByID(0).getFontHeight() - ApplicationData.getFontByID(0).getFontHeight() / 4;
        this.nBoxWidth = ObjectsCache.bgTextElements[1] != null ? ObjectsCache.bgTextElements[1].GetWidth() : ApplicationData.screenWidth;
        this.infoBox = new UIFloatingTextBox(false, (ApplicationData.screenWidth - this.nBoxWidth) / 2, this.nStartBoxY, this.nBoxWidth, this.nStopBoxY - this.nStartBoxY);
        this.updateAchievementInfo();
    }

    private void updateAchievementInfo() {
        this.csText1 = ApplicationData.defaultFont.encodeDynamicString("" + (selectedAchiev + 1) + " / " + 15);
        this.csText2 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ACHIEVEMENT_HEADER_" + selectedAchiev);
        this.infoBox.setText(ApplicationData.defaultFont.encodeDynamicString("  ") + ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ACHIEVEMENT_LONG_DESCRIPTION_" + selectedAchiev));
    }

    public void autoSize() {
    }

    public void draw() {
        int n = ApplicationData.screenWidth / 2 - this.achievImages[0].GetWidth() / 2;
        int n2 = ApplicationData.screenHeight / 2 - this.achievImages[0].GetHeight();
        boolean bl = CGAchievements.isAchievementCompleted(selectedAchiev);
        if (bl) {
            Graphic2D.DrawImage(this.achievImages[0], n, n2, 20);
        } else {
            Graphic2D.DrawImage(this.achievImages[1], n, n2, 20);
        }
        if (ObjectsCache.bgTextElements[0] != null) {
            Graphic2D.DrawImage(ObjectsCache.bgTextElements[0], ApplicationData.screenWidth / 2, n2, 33);
            Graphic2D.DrawImage(ObjectsCache.bgTextElements[1], ApplicationData.screenWidth >> 1, n2 + this.achievImages[0].GetHeight(), 17);
        }
        if (ObjectsCache.bgTextElements[0] != null) {
            Utils.drawString(this.csText2, ApplicationData.screenWidth >> 1, n2 - ApplicationData.getFontByID(0).getFontHeight() / 8 - ObjectsCache.bgTextElements[0].GetHeight() / 4, 33, 0);
            Utils.drawString(this.csText1, ApplicationData.screenWidth >> 1, n2 - ApplicationData.getFontByID(0).getFontHeight() - ApplicationData.getFontByID(0).getFontHeight() / 8 - ObjectsCache.bgTextElements[0].GetHeight() / 4, 33, 0);
        } else {
            Utils.drawString(this.csText2, ApplicationData.screenWidth >> 1, n2 - ApplicationData.getFontByID(0).getFontHeight() / 8 - 16, 33, 0);
            Utils.drawString(this.csText1, ApplicationData.screenWidth >> 1, n2 - ApplicationData.getFontByID(0).getFontHeight() - ApplicationData.getFontByID(0).getFontHeight() / 8 - 16, 33, 0);
        }
        this.infoBox.draw();
    }

    public boolean rightSoftButton() {
        this.Clean();
        if (this.parentScreen != null) {
            this.readyForClose = true;
            return true;
        }
        return false;
    }

    public boolean leftSoftButton() {
        return false;
    }

    public boolean selectLeftAction() {
        UIButton uIButton = this.findByID(100);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton uIButton = this.findByID(101);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean onRightAction() {
        if (++selectedAchiev >= 15) {
            selectedAchiev = 0;
        }
        this.updateAchievementInfo();
        return true;
    }

    public boolean onLeftAction() {
        if (--selectedAchiev < 0) {
            selectedAchiev = 14;
        }
        this.updateAchievementInfo();
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (super.actionSoftButton(n, bl)) {
            return true;
        }
        if (!bl) {
            this.unselectAllButtons();
            if (n == 100) {
                this.onLeftAction();
                return true;
            }
            if (n == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public void drawWindowBackground() {
        super.drawWindowBackground();
        int n = ObjectsCache.backgroundElements[0].GetWidth();
        int n2 = ApplicationData.screenWidth / n;
        for (int i = 0; i <= n2; ++i) {
            Graphic2D.DrawImage(ObjectsCache.backgroundElements[0], i * n, 0, 20);
        }
    }
}

