/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.RandSync;
import baltorogames.core.VectorF2;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;

public class CGJewel {
    public static int NUM_JEWEL_COLORS = 7;
    public static int NUM_JEWEL_SPECIAL = 5;
    public static int eSpecial_Bomb = 7;
    public static int eSpecial_Color = 8;
    public static int eSpecial_Destroyer = 9;
    public static int eSpecial_Random = 10;
    public static int eSpecial_Star = 11;
    public static int NUM_FRAME_ANIM_JEWEL = 16;
    public static int eType_Unvisible = 100;
    static boolean FIRST_TIME_ANIM = true;
    public static float m_fPixelsPerSec = 750.0f;
    static CGTexture[][] m_animTextures = null;
    public float m_fRadiusX;
    public float m_fRadiusY;
    public int frameOfAnim = 0;
    public boolean isJewelAnimationPlayed = true;
    public float m_fX;
    public float m_fY;
    public float m_fRotateX;
    public float m_fRotateY;
    public float m_fTargetY;
    public int m_nType = -1;
    public boolean m_bToDestroy = false;

    public static void Initialize() {
        int n;
        m_animTextures = new CGTexture[NUM_JEWEL_COLORS + NUM_JEWEL_SPECIAL][NUM_FRAME_ANIM_JEWEL];
        for (n = 0; n < NUM_JEWEL_COLORS; ++n) {
            for (int i = 0; i < NUM_FRAME_ANIM_JEWEL; ++i) {
                CGJewel.m_animTextures[n][i] = TextureManager.AddTexture("/gameplay/jewel/jewel_" + (n + 1) + "_" + (i + 1) + ".png");
            }
        }
        for (n = 0; n < NUM_FRAME_ANIM_JEWEL; ++n) {
            CGJewel.m_animTextures[CGJewel.NUM_JEWEL_COLORS][n] = TextureManager.AddTexture("/gameplay/jewel/jewel_bomb.png");
            CGJewel.m_animTextures[CGJewel.NUM_JEWEL_COLORS + 1][n] = TextureManager.AddTexture("/gameplay/jewel/jewel_color.png");
            CGJewel.m_animTextures[CGJewel.NUM_JEWEL_COLORS + 2][n] = TextureManager.AddTexture("/gameplay/jewel/jewel_destroy.png");
            CGJewel.m_animTextures[CGJewel.NUM_JEWEL_COLORS + 3][n] = TextureManager.AddTexture("/gameplay/jewel/jewel_rand.png");
            CGJewel.m_animTextures[CGJewel.NUM_JEWEL_COLORS + 4][n] = TextureManager.AddTexture("/gameplay/jewel/jewel_star.png");
        }
    }

    public void Init(int n, float f, float f2) {
        this.m_fX = f;
        this.m_fY = f2;
        this.m_nType = n;
        this.m_fRadiusX = -1000.0f;
        this.m_fRadiusY = -1000.0f;
    }

    public void SetTargetY(float f) {
        this.m_fTargetY = f;
        CGEngine.m_Board.m_Board[this.GetBoardX()][this.GetBoardY()] = this;
    }

    public void Step(int n) {
        if (this.m_fRadiusX == -1000.0f && this.m_fRadiusY == -1000.0f) {
            float f = m_fPixelsPerSec * (float)n / 1000.0f;
            if (this.m_fY < this.m_fTargetY) {
                this.m_fY += f;
                if (this.m_fY >= this.m_fTargetY) {
                    this.m_fY = this.m_fTargetY;
                }
            }
        } else if (this.m_fRadiusX != -1000.0f) {
            VectorF2 vectorF2 = VectorF2.vecTmp1;
            vectorF2.x = this.m_fRadiusX;
            vectorF2.y = 0.0;
            VectorF2 vectorF22 = VectorF2.vecTmp2;
            VectorF2.RotateVector(vectorF2, CGBoard.m_fCurrentRotateAngle, vectorF22);
            this.m_fRotateX = CGBoard.m_fCurrentRotateCenterX + (float)vectorF22.x;
            this.m_fRotateY = CGBoard.m_fCurrentRotateCenterY + (float)vectorF22.y;
        } else if (this.m_fRadiusY != -1000.0f) {
            VectorF2 vectorF2 = VectorF2.vecTmp1;
            vectorF2.x = 0.0;
            vectorF2.y = this.m_fRadiusY;
            VectorF2 vectorF23 = VectorF2.vecTmp2;
            VectorF2.RotateVector(vectorF2, CGBoard.m_fCurrentRotateAngle, vectorF23);
            this.m_fRotateX = CGBoard.m_fCurrentRotateCenterX + (float)vectorF23.x;
            this.m_fRotateY = CGBoard.m_fCurrentRotateCenterY + (float)vectorF23.y;
        }
    }

    public void Render() {
        if (this.m_nType >= eType_Unvisible) {
            return;
        }
        if (this.m_fRadiusX == -1000.0f && this.m_fRadiusY == -1000.0f) {
            if (this.IsInBoard()) {
                this.RenderAnimationWhenLvlStarts(this);
            }
            CGEngineRenderer.RenderJewel(this);
        } else {
            CGEngineRenderer.RenderRotateJewel(this);
        }
    }

    int GetBoardX() {
        return (int)this.m_fX / (int)CGBoard.m_fSize;
    }

    int GetBoardY() {
        return (int)this.m_fTargetY / (int)CGBoard.m_fSize;
    }

    boolean IsInBoard() {
        return !(this.m_fY < this.m_fTargetY);
    }

    public void RenderAnimationWhenLvlStarts(CGJewel cGJewel) {
        if (this.m_nType == RandSync.nextInt(800)) {
            this.isJewelAnimationPlayed = true;
        }
        if (this.frameOfAnim >= NUM_FRAME_ANIM_JEWEL - 1) {
            this.frameOfAnim = 0;
            this.isJewelAnimationPlayed = false;
        } else if (System.currentTimeMillis() % 2L == 0L) {
            ++this.frameOfAnim;
        }
    }
}

