/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core_gui.UIFloatingTextBoxEx;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.SelectModeScreen;
import baltorogames.project_gui.TutorialScreenSecond;
import baltorogames.project_gui.TutorialThirdScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class TutorialScreen
extends MainScreen {
    private int m_nFrameDelay = 0;
    CGTexture[] firstTutorialFrames = new CGTexture[7];
    UIFloatingTextBoxEx textBox;
    String tutorialInfo = new String();

    public TutorialScreen() {
        this.loadImagesForTutorial();
        this.tutorialInfo = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TUT_SCREEN_1");
        this.textBox = new UIFloatingTextBoxEx(true, 0, ApplicationData.screenHeight / 3 * 2, ApplicationData.screenWidth, ApplicationData.screenHeight / 3 - ObjectsCache.menuSbOK.GetHeight());
        this.textBox.setText(this.tutorialInfo);
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
    }

    public void draw() {
        this.drawWindowBackground();
        Graphic2D.DrawImage(this.firstTutorialFrames[this.m_nFrameDelay], ApplicationData.screenWidth / 2, 0, 17);
        this.textBox.draw();
    }

    public void onUpdate(float f) {
        super.onUpdate(f);
        this.textBox.onUpdate(f);
        this.m_nFrameDelay = (int)(this.getLifeTime() * 1000.0f) / 400;
        this.m_nFrameDelay %= 7;
    }

    public void drawWindowBackground() {
        this.drawTitle = false;
        this.drawBottom = false;
        int n = ObjectsCache.backgroundElements[0].GetWidth();
        int n2 = ApplicationData.screenWidth / n;
        for (int i = 0; i <= n2; ++i) {
            Graphic2D.DrawImage(ObjectsCache.backgroundElements[0], i * n, 0, 20);
        }
    }

    public void loadImagesForTutorial() {
        if (ApplicationData.isTouchScreen) {
            for (int i = 0; i < this.firstTutorialFrames.length; ++i) {
                this.firstTutorialFrames[i] = TextureManager.AddTexture("/menu/tutorial/tut1_" + (i + 1) + ".png");
            }
        } else {
            for (int i = 0; i < this.firstTutorialFrames.length; ++i) {
                this.firstTutorialFrames[i] = TextureManager.AddTexture("/menu/tutorial/tut1_" + (i + 1) + "_notouch.png");
            }
        }
    }

    public boolean rightSoftButton() {
        UIScreen.SetCurrentScreen(new SelectModeScreen());
        return true;
    }

    public boolean leftSoftButton() {
        if (CGEngine.m_nGameMode == 1) {
            UIScreen.SetCurrentScreen(new TutorialScreenSecond());
        } else if (CGEngine.m_nGameMode == 2) {
            UIScreen.SetCurrentScreen(new TutorialThirdScreen());
        }
        return true;
    }
}

