/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;

public class CGBoardKeyboardMarker {
    int m_nCurrentX = 0;
    int m_nCurrentY = 0;
    int m_nSelectState = 0;

    public void Reset() {
        this.m_nCurrentX = 0;
        this.m_nCurrentY = 0;
    }

    public void Render() {
        float f = CGEngine.m_Board.GetMiddleX(this.m_nCurrentX, this.m_nCurrentY);
        float f2 = CGEngine.m_Board.GetMiddleY(this.m_nCurrentX, this.m_nCurrentY);
        if (!ApplicationData.isTouchScreen) {
            CGEngineRenderer.RenderMarker(f, f2);
        }
    }

    public void onLeft() {
        --this.m_nCurrentX;
        if (this.m_nCurrentX < 0) {
            this.m_nCurrentX = 0;
        }
        if (this.m_nSelectState > 0) {
            CGEngine.m_CurrentSelectPointX = (float)this.m_nCurrentX * CGBoard.m_fSize + CGBoard.m_fSize / 2.0f;
            CGEngine.m_CurrentSelectPointY = (float)this.m_nCurrentY * CGBoard.m_fSize + CGBoard.m_fSize / 2.0f;
        }
    }

    public void onRight() {
        ++this.m_nCurrentX;
        if (this.m_nCurrentX >= CGBoard.BOARD_MAX_WIDTH) {
            this.m_nCurrentX = CGBoard.BOARD_MAX_WIDTH - 1;
        }
        if (this.m_nSelectState > 0) {
            CGEngine.m_CurrentSelectPointX = (float)this.m_nCurrentX * CGBoard.m_fSize + CGBoard.m_fSize / 2.0f;
            CGEngine.m_CurrentSelectPointY = (float)this.m_nCurrentY * CGBoard.m_fSize + CGBoard.m_fSize / 2.0f;
        }
    }

    public void onUp() {
        --this.m_nCurrentY;
        if (this.m_nCurrentY < 0) {
            this.m_nCurrentY = 0;
        }
        if (this.m_nSelectState > 0) {
            CGEngine.m_CurrentSelectPointX = (float)this.m_nCurrentX * CGBoard.m_fSize + CGBoard.m_fSize / 2.0f;
            CGEngine.m_CurrentSelectPointY = (float)this.m_nCurrentY * CGBoard.m_fSize + CGBoard.m_fSize / 2.0f;
        }
    }

    public void onDown() {
        ++this.m_nCurrentY;
        if (this.m_nCurrentY >= CGBoard.BOARD_MAX_HEIGHT) {
            this.m_nCurrentY = CGBoard.BOARD_MAX_HEIGHT - 1;
        }
        if (this.m_nSelectState > 0) {
            CGEngine.m_CurrentSelectPointX = (float)this.m_nCurrentX * CGBoard.m_fSize + CGBoard.m_fSize / 2.0f;
            CGEngine.m_CurrentSelectPointY = (float)this.m_nCurrentY * CGBoard.m_fSize + CGBoard.m_fSize / 2.0f;
        }
    }

    public void onSelect() {
        if (this.m_nSelectState == 0) {
            CGEngine.m_StartSelectPointX = (float)this.m_nCurrentX * CGBoard.m_fSize + CGBoard.m_fSize / 2.0f;
            CGEngine.m_StartSelectPointY = (float)this.m_nCurrentY * CGBoard.m_fSize + CGBoard.m_fSize / 2.0f;
            CGEngine.m_CurrentSelectPointX = CGEngine.m_StartSelectPointX;
            CGEngine.m_CurrentSelectPointY = CGEngine.m_StartSelectPointY;
            this.m_nSelectState = 1;
        } else {
            if (CGEngine.m_Board.IsReady()) {
                CGEngine.m_Board.ChangePos();
            }
            CGEngine.m_StartSelectPointX = -1000000.0f;
            CGEngine.m_StartSelectPointY = -1000000.0f;
            CGEngine.m_CurrentSelectPointX = -1000000.0f;
            CGEngine.m_CurrentSelectPointY = -1000000.0f;
            this.m_nSelectState = 0;
        }
    }
}

