/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.RandSync;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGHit;
import baltorogames.project_gameplay.CGJewel;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.DestroyLineData;
import java.util.Vector;

public class CGBoard {
    public static int COMBO_TURN_MAX_INTERVAL = 3000;
    public static float SCORE_TO_LIFETIME_MULTIPLIER = 0.01f;
    public static float m_fSize = 80.0f;
    public static float m_fStartX;
    public static float m_fStartY;
    public static int m_nNrofTypes;
    public static final int MAX_NUM_COLORS = 7;
    public static int m_nStartSelectX;
    public static int m_nStartSelectY;
    public static int m_nEndSelectX;
    public static int m_nEndSelectY;
    static CGTexture m_SelectTexture;
    static CGTexture[] m_arrSelectTexture;
    private static int m_nNewJewelIndex;
    private static int m_nSpecialJewelIndex;
    private static int m_nSpecialJewelType;
    public static CGTexture m_buttonSelectLevel;
    public static float m_fCurrentRotateAngle;
    public static float m_fCurrentRotateCenterX;
    public static float m_fCurrentRotateCenterY;
    int jewelsDestroyed = 0;
    public Vector m_arrJewels = null;
    public CGJewel[][] m_Board = null;
    static CGTexture m_MarkerTexture;
    public static int currentComboLevel;
    public static boolean comboLevelHasChanged;
    public static int currentChainLevel;
    public static long timeFromLastDestroyMs;
    public static boolean nothingDestroyedInLastTurn;
    public static int BOARD_MAX_WIDTH;
    public static int BOARD_MAX_HEIGHT;
    private boolean m_bIsFour = false;
    private boolean m_bIsFive = false;
    private boolean m_bIsCrossShape = false;
    private boolean m_bIsLShape = false;
    private boolean m_bIsTShape = false;
    private static int[] arrTmp;

    public static void Initialize() {
        m_SelectTexture = TextureManager.CreateFilteredTexture("/gameplay/select.png");
        m_arrSelectTexture = new CGTexture[9];
        for (int i = 0; i < m_arrSelectTexture.length; ++i) {
            CGBoard.m_arrSelectTexture[i] = TextureManager.CreateFilteredTexture("/gameplay/select_" + (i + 1) + ".png");
        }
        m_MarkerTexture = TextureManager.CreateFilteredTexture("/gameplay/marker.png");
        m_fStartX = 240.0f - 2.5f * m_fSize;
        m_fStartY = 180.0f;
    }

    public void Init() {
        int n;
        int n2;
        if (this.m_Board == null) {
            this.m_Board = new CGJewel[BOARD_MAX_WIDTH][BOARD_MAX_HEIGHT];
        }
        for (n2 = 0; n2 < BOARD_MAX_WIDTH; ++n2) {
            for (n = 0; n < BOARD_MAX_HEIGHT; ++n) {
                this.m_Board[n2][n] = null;
            }
        }
        this.m_arrJewels = new Vector();
        for (n2 = 0; n2 < BOARD_MAX_HEIGHT; ++n2) {
            for (n = 0; n < BOARD_MAX_WIDTH; ++n) {
                this.NewJewelForPos(n, n2);
            }
        }
        m_fCurrentRotateAngle = 0.0f;
    }

    public void NewJewelForPos(int n, int n2) {
        float f = (float)n * m_fSize + m_fSize / 2.0f;
        float f2 = (float)n2 * m_fSize + m_fSize / 2.0f;
        CGJewel cGJewel = new CGJewel();
        float f3 = 6.0f;
        if (n2 == 3) {
            f3 = 6.5f;
        } else if (n2 == 2) {
            f3 = 7.0f;
        } else if (n2 == 1) {
            f3 = 7.5f;
        } else if (n2 == 0) {
            f3 = 8.0f;
        }
        int n3 = RandSync.nextInt(m_nNrofTypes);
        if (n == 0 && n2 == 0) {
            n3 = 0;
        }
        if (CGBoard.getM_nSpecialJewelIndex() >= 0 && CGBoard.getM_nSpecialJewelType() > 0 && m_nNewJewelIndex == CGBoard.getM_nSpecialJewelIndex()) {
            n3 = CGBoard.getM_nSpecialJewelType();
        }
        cGJewel.Init(n3, f, f2 - f3 * m_fSize);
        cGJewel.SetTargetY(f2);
        this.ChangeJewelType(cGJewel);
        this.m_arrJewels.addElement(cGJewel);
        ++m_nNewJewelIndex;
    }

    public void Step(int n) {
        int n2;
        if (m_fCurrentRotateAngle > 0.0f) {
            if (m_fCurrentRotateAngle < 180.0f) {
                if ((m_fCurrentRotateAngle += 480.0f * (float)n / 1000.0f) >= 180.0f) {
                    m_fCurrentRotateAngle = 180.0f;
                }
            } else {
                this.EndOfRotate();
                ++CGLevelStats.m_nTotalMoves;
                m_fCurrentRotateAngle = 0.0f;
            }
        }
        int n3 = this.m_arrJewels.size();
        for (n2 = 0; n2 < n3; ++n2) {
            CGJewel cGJewel = (CGJewel)this.m_arrJewels.elementAt(n2);
            cGJewel.Step(n);
        }
        if (this.IsReady()) {
            DestroyLineData.Clear();
            this.CheckDestroy(n);
            if (!this.m_bIsFour) {
                this.m_bIsFour = DestroyLineData.IsFour();
            }
            if (!this.m_bIsFive) {
                this.m_bIsFive = DestroyLineData.IsFive();
            }
            if (!this.m_bIsCrossShape) {
                this.m_bIsCrossShape = DestroyLineData.IsCrossShape();
            }
            if (!this.m_bIsLShape) {
                this.m_bIsLShape = DestroyLineData.IsLShape();
            }
            if (!this.m_bIsTShape) {
                this.m_bIsTShape = DestroyLineData.IsTShape();
            }
        }
        if (!this.IsTurnFinished()) {
            timeFromLastDestroyMs = 0L;
        } else {
            nothingDestroyedInLastTurn = true;
            currentChainLevel = 0;
            if ((timeFromLastDestroyMs += (long)n) > (long)COMBO_TURN_MAX_INTERVAL) {
                currentComboLevel = 1;
            }
        }
        for (n2 = 0; n2 < BOARD_MAX_WIDTH; ++n2) {
            this.CheckColumn(n2);
        }
        if (this.IsReady()) {
            if ((this.m_bIsFour || this.m_bIsFive || this.m_bIsCrossShape || this.m_bIsLShape || this.m_bIsTShape) && CGEngine.m_nGameMode == 1) {
                int n4;
                n2 = 0;
                for (n4 = 0; n4 < BOARD_MAX_WIDTH; ++n4) {
                    n2 += this.CountCheckColumnForNew(n4);
                }
                if (n2 > 0) {
                    CGBoard.setM_nSpecialJewelIndex(RandSync.nextInt(n2));
                    CGBoard.setM_nSpecialJewelType(7 + RandSync.nextInt(5));
                    if (this.m_bIsFive) {
                        CGBoard.setM_nSpecialJewelType(CGJewel.eSpecial_Destroyer);
                    } else if (this.m_bIsFour) {
                        CGBoard.setM_nSpecialJewelType(CGJewel.eSpecial_Bomb);
                    } else if (this.m_bIsCrossShape) {
                        CGBoard.setM_nSpecialJewelType(CGJewel.eSpecial_Star);
                    } else if (this.m_bIsLShape) {
                        CGBoard.setM_nSpecialJewelType(CGJewel.eSpecial_Color);
                    } else if (this.m_bIsTShape) {
                        CGBoard.setM_nSpecialJewelType(CGJewel.eSpecial_Random);
                    }
                    m_nNewJewelIndex = 0;
                    for (n4 = 0; n4 < BOARD_MAX_WIDTH; ++n4) {
                        this.CheckColumnForNew(n4);
                    }
                    this.m_bIsFour = false;
                    this.m_bIsFive = false;
                    this.m_bIsCrossShape = false;
                    this.m_bIsLShape = false;
                    this.m_bIsTShape = false;
                }
            } else {
                CGBoard.setM_nSpecialJewelIndex(-1);
                CGBoard.setM_nSpecialJewelType(-1);
                m_nNewJewelIndex = 0;
                for (n2 = 0; n2 < BOARD_MAX_WIDTH; ++n2) {
                    this.CheckColumnForNew(n2);
                }
            }
        }
        this.CheckSelect();
    }

    public void ChangeJewelType(CGJewel cGJewel) {
        int n = cGJewel.GetBoardX();
        int n2 = cGJewel.GetBoardY();
        if (n - 1 > 0 && n - 1 < 4 && this.m_Board[n - 1][n2] != null && this.m_Board[n - 1][n2].m_nType == cGJewel.m_nType) {
            while (this.m_Board[n - 1][n2].m_nType == cGJewel.m_nType) {
                cGJewel.m_nType = RandSync.nextInt(CGJewel.NUM_JEWEL_COLORS);
            }
        }
        if (n2 - 1 > 0 && n2 - 1 < 4 && this.m_Board[n][n2 - 1] != null && this.m_Board[n][n2 - 1].m_nType == cGJewel.m_nType) {
            while (this.m_Board[n][n2 - 1].m_nType == cGJewel.m_nType) {
                cGJewel.m_nType = RandSync.nextInt(CGJewel.NUM_JEWEL_COLORS);
            }
        }
        if (n + 1 > 0 && n + 1 < 4 && this.m_Board[n + 1][n2] != null && this.m_Board[n + 1][n2].m_nType == cGJewel.m_nType) {
            while (this.m_Board[n + 1][n2].m_nType == cGJewel.m_nType) {
                cGJewel.m_nType = RandSync.nextInt(CGJewel.NUM_JEWEL_COLORS);
            }
        }
        if (n2 + 1 > 0 && n2 + 1 < 4 && this.m_Board[n][n2 + 1] != null && this.m_Board[n][n2 + 1].m_nType == cGJewel.m_nType) {
            while (this.m_Board[n][n2 + 1].m_nType == cGJewel.m_nType) {
                cGJewel.m_nType = RandSync.nextInt(CGJewel.NUM_JEWEL_COLORS);
            }
        }
    }

    public float GetMiddleX(int n, int n2) {
        return ((float)n + 0.5f) * m_fSize;
    }

    public float GetMiddleY(int n, int n2) {
        return ((float)n2 + 0.5f) * m_fSize;
    }

    public int GetTypeAt(int n, int n2) {
        if (n < 0 || n > 4 || n2 < 0 || n2 > 4) {
            return -3;
        }
        if (this.m_Board[n][n2] == null) {
            return -2;
        }
        if (!this.m_Board[n][n2].IsInBoard()) {
            return -1;
        }
        return this.m_Board[n][n2].m_nType;
    }

    private void NotifyJewelDestroyed(int n, int n2) {
        int n3 = CGEngine.POINTS_FOR_JEWEL_DESTROYED_ARCADE * currentComboLevel;
        if (CGEngine.m_nGameMode == 1 && CGEngine.m_nMovesLeft < 0) {
            n3 = 0;
        }
        if (CGLevelStats.m_nTotalMoves >= 0) {
            CGLevelStats.AddScore(n3);
        }
        if (timeFromLastDestroyMs <= (long)COMBO_TURN_MAX_INTERVAL && nothingDestroyedInLastTurn) {
            ++currentComboLevel;
            timeFromLastDestroyMs = 0L;
            comboLevelHasChanged = true;
        }
        if (CGEngine.m_nGameMode == 2 && (CGEngine.m_fLifeLine += (float)CGEngine.POINTS_FOR_JEWEL_DESTROYED_ARCADE * SCORE_TO_LIFETIME_MULTIPLIER) > 1.0f) {
            CGEngine.m_fLifeLine = 1.0f;
        }
        nothingDestroyedInLastTurn = false;
    }

    void DestroyBomb(int n, int n2) {
        for (int i = n - 1; i <= n + 1; ++i) {
            for (int j = n2 - 1; j <= n2 + 1; ++j) {
                if (i < 0 || j < 0 || i >= BOARD_MAX_WIDTH || j >= BOARD_MAX_HEIGHT || this.m_Board[i][j] == null) continue;
                this.m_Board[i][j].m_bToDestroy = true;
            }
        }
    }

    void DestroyDestroyer(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < BOARD_MAX_WIDTH; ++n3) {
            if (this.m_Board[n3][n2] == null) continue;
            this.m_Board[n3][n2].m_bToDestroy = true;
        }
        for (n3 = 0; n3 < BOARD_MAX_HEIGHT; ++n3) {
            if (this.m_Board[n][n3] == null) continue;
            this.m_Board[n][n3].m_bToDestroy = true;
        }
    }

    void DestroyStar(int n, int n2) {
        for (int i = 1; i < 6; ++i) {
            if (n - i >= 0 && n2 - i >= 0 && this.m_Board[n - i][n2 - i] != null) {
                this.m_Board[n - i][n2 - i].m_bToDestroy = true;
            }
            if (n - i >= 0 && n2 + i < BOARD_MAX_HEIGHT && this.m_Board[n - i][n2 + i] != null) {
                this.m_Board[n - i][n2 + i].m_bToDestroy = true;
            }
            if (n + i < BOARD_MAX_WIDTH && n2 - i >= 0 && this.m_Board[n + i][n2 - i] != null) {
                this.m_Board[n + i][n2 - i].m_bToDestroy = true;
            }
            if (n + i >= BOARD_MAX_WIDTH || n2 + i >= BOARD_MAX_HEIGHT || this.m_Board[n + i][n2 + i] == null) continue;
            this.m_Board[n + i][n2 + i].m_bToDestroy = true;
        }
    }

    void DestroyColor(int n) {
        for (int i = 0; i < BOARD_MAX_WIDTH; ++i) {
            for (int j = 0; j < BOARD_MAX_HEIGHT; ++j) {
                if (this.m_Board[i][j] == null || this.m_Board[i][j].m_nType != n) continue;
                this.m_Board[i][j].m_bToDestroy = true;
            }
        }
    }

    void DestroyRandom() {
        for (int i = 0; i < 7; ++i) {
            int n;
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < BOARD_MAX_WIDTH; ++n2) {
                for (n = 0; n < BOARD_MAX_HEIGHT; ++n) {
                    if (this.m_Board[n2][n] == null || this.m_Board[n2][n].m_bToDestroy) continue;
                    CGBoard.arrTmp[n3] = n * BOARD_MAX_WIDTH + n2;
                    ++n3;
                }
            }
            if (n3 <= 0) break;
            n2 = RandSync.nextInt(n3);
            n = arrTmp[n2] % BOARD_MAX_WIDTH;
            int n4 = arrTmp[n2] / BOARD_MAX_WIDTH;
            this.m_Board[n][n4].m_bToDestroy = true;
        }
    }

    void CheckDestroyH(int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = 0;
        int n12 = this.GetTypeAt(n, n2);
        if (n12 >= m_nNrofTypes && (n12 = this.GetTypeAt(n + 1, n2)) >= m_nNrofTypes) {
            n12 = this.GetTypeAt(n + 2, n2);
        }
        if (n12 >= 0) {
            int n13;
            for (n13 = 1; n13 < 10 && (this.GetTypeAt(n + n13, n2) == n12 || this.GetTypeAt(n + n13, n2) >= m_nNrofTypes); ++n13) {
                ++n11;
            }
            if (n11 >= 2) {
                if (n11 >= 4) {
                    this.m_bIsFive = true;
                } else if (n11 >= 3) {
                    this.m_bIsFour = true;
                }
                DestroyLineData.Add(1, n2, n, n + n11);
                for (n13 = 0; n13 <= n11; ++n13) {
                    this.m_Board[n + n13][n2].m_bToDestroy = true;
                    if (this.m_Board[n + n13][n2].m_nType == CGJewel.eSpecial_Bomb) {
                        n3 = n + n13;
                        n4 = n2;
                        continue;
                    }
                    if (this.m_Board[n + n13][n2].m_nType == CGJewel.eSpecial_Destroyer) {
                        n5 = n + n13;
                        n6 = n2;
                        continue;
                    }
                    if (this.m_Board[n + n13][n2].m_nType == CGJewel.eSpecial_Star) {
                        n7 = n + n13;
                        n8 = n2;
                        continue;
                    }
                    if (this.m_Board[n + n13][n2].m_nType == CGJewel.eSpecial_Color) {
                        if (n + n13 < BOARD_MAX_WIDTH - 1 && this.m_Board[n + n13 + 1][n2] != null) {
                            n9 = this.m_Board[n + n13 + 1][n2].m_nType;
                            continue;
                        }
                        if (n + n13 - 1 < 0 || this.m_Board[n + n13 - 1][n2] == null) continue;
                        n9 = this.m_Board[n + n13 - 1][n2].m_nType;
                        continue;
                    }
                    if (this.m_Board[n + n13][n2].m_nType != CGJewel.eSpecial_Random) continue;
                    n10 = 7;
                }
                this.NotifyLineDestroyed(n, n2, n11, n12, true);
            }
        }
        if (n3 >= 0 && n4 >= 0) {
            this.DestroyBomb(n3, n4);
        }
        if (n5 >= 0 && n6 >= 0) {
            this.DestroyDestroyer(n5, n6);
        }
        if (n7 >= 0 && n8 >= 0) {
            this.DestroyStar(n7, n8);
        }
        if (n9 >= 0) {
            this.DestroyColor(n9);
        }
        if (n10 >= 0) {
            this.DestroyRandom();
        }
    }

    void CheckDestroyV(int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = 0;
        int n12 = this.GetTypeAt(n, n2);
        if (n12 >= m_nNrofTypes && (n12 = this.GetTypeAt(n, n2 + 1)) >= m_nNrofTypes) {
            n12 = this.GetTypeAt(n, n2 + 2);
        }
        if (n12 >= 0) {
            int n13;
            for (n13 = 1; n13 < 10 && (this.GetTypeAt(n, n2 + n13) == n12 || this.GetTypeAt(n, n2 + n13) >= m_nNrofTypes); ++n13) {
                ++n11;
            }
            if (n11 >= 2) {
                if (n11 >= 4) {
                    this.m_bIsFive = true;
                } else if (n11 >= 3) {
                    this.m_bIsFour = true;
                }
                DestroyLineData.Add(0, n, n2, n2 + n11);
                for (n13 = 0; n13 <= n11; ++n13) {
                    this.m_Board[n][n2 + n13].m_bToDestroy = true;
                    if (this.m_Board[n][n2 + n13].m_nType == CGJewel.eSpecial_Bomb) {
                        n3 = n;
                        n4 = n2 + n13;
                        continue;
                    }
                    if (this.m_Board[n][n2 + n13].m_nType == CGJewel.eSpecial_Destroyer) {
                        n5 = n;
                        n6 = n2 + n13;
                        continue;
                    }
                    if (this.m_Board[n][n2 + n13].m_nType == CGJewel.eSpecial_Star) {
                        n7 = n;
                        n8 = n2 + n13;
                        continue;
                    }
                    if (this.m_Board[n][n2 + n13].m_nType == CGJewel.eSpecial_Color) {
                        if (n2 + n13 < BOARD_MAX_HEIGHT - 1 && this.m_Board[n][n2 + n13 + 1] != null) {
                            n9 = this.m_Board[n][n2 + n13 + 1].m_nType;
                            continue;
                        }
                        if (n2 + n13 - 1 < 0 || this.m_Board[n][n2 + n13 - 1] == null) continue;
                        n9 = this.m_Board[n][n2 + n13 - 1].m_nType;
                        continue;
                    }
                    if (this.m_Board[n][n2 + n13].m_nType != CGJewel.eSpecial_Random) continue;
                    n10 = 7;
                }
                this.NotifyLineDestroyed(n, n2, n11, n12, false);
            }
        }
        if (n3 >= 0 && n4 >= 0) {
            this.DestroyBomb(n3, n4);
        }
        if (n5 >= 0 && n6 >= 0) {
            this.DestroyDestroyer(n5, n6);
        }
        if (n7 >= 0 && n8 >= 0) {
            this.DestroyStar(n7, n8);
        }
        if (n9 >= 0) {
            this.DestroyColor(n9);
        }
        if (n10 >= 0) {
            this.DestroyRandom();
        }
    }

    public void NotifyLineDestroyed(int n, int n2, int n3, int n4, boolean bl) {
        ++currentChainLevel;
    }

    public boolean IsReady() {
        if (m_fCurrentRotateAngle > 0.0f) {
            return false;
        }
        for (int i = 0; i < BOARD_MAX_HEIGHT; ++i) {
            for (int j = 0; j < BOARD_MAX_WIDTH; ++j) {
                if (this.m_Board[j][i] == null || this.m_Board[j][i].IsInBoard()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean IsTurnFinished() {
        if (!this.IsReady()) {
            return false;
        }
        for (int i = 0; i < BOARD_MAX_WIDTH; ++i) {
            for (int j = 0; j < BOARD_MAX_HEIGHT; ++j) {
                if (this.m_Board[i][j] != null) continue;
                return false;
            }
        }
        return true;
    }

    public void CheckDestroy(long l) {
        int n;
        int n2;
        for (n2 = 0; n2 < BOARD_MAX_HEIGHT; ++n2) {
            for (n = 0; n < BOARD_MAX_WIDTH; ++n) {
                if (this.m_Board[n][n2] == null) continue;
                this.m_Board[n][n2].m_bToDestroy = false;
            }
        }
        for (n2 = 0; n2 < BOARD_MAX_HEIGHT; ++n2) {
            for (n = 0; n < BOARD_MAX_WIDTH; ++n) {
                this.CheckDestroyH(n, n2);
                this.CheckDestroyV(n, n2);
            }
        }
        this.jewelsDestroyed = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < BOARD_MAX_HEIGHT; ++i) {
            for (int j = 0; j < BOARD_MAX_WIDTH; ++j) {
                if (this.m_Board[j][i] == null || !this.m_Board[j][i].m_bToDestroy) continue;
                CGHit.NewHit(0, this.GetMiddleX(j, i) + 42.0f, this.GetMiddleY(j, i) + m_fStartY, 300L);
                f += this.GetMiddleX(j, i) + m_fStartX;
                f2 += this.GetMiddleX(j, i) + m_fStartY;
                this.DeleteFromJewels(this.m_Board[j][i]);
                this.m_Board[j][i] = null;
                this.NotifyJewelDestroyed(j, i);
                ++this.jewelsDestroyed;
            }
        }
        if (this.jewelsDestroyed >= 5) {
            CGAchievements.completeAchievement(13);
        }
        if (currentComboLevel > 2 && this.jewelsDestroyed > 0) {
            CGDynamicObj.AddToCurrentDynamics("combo.do", f /= (float)this.jewelsDestroyed, f2 /= (float)this.jewelsDestroyed, 0.0f);
            CGAchievements.completeAchievement(2);
        } else if (currentComboLevel > 5 && this.jewelsDestroyed > 0) {
            CGAchievements.completeAchievement(3);
        } else if (currentComboLevel > 10 && this.jewelsDestroyed > 0) {
            CGAchievements.completeAchievement(4);
        }
        if (currentChainLevel > 5) {
            CGAchievements.completeAchievement(14);
        }
        if (comboLevelHasChanged) {
            switch (currentComboLevel) {
                case 3: {
                    CGHit.NewHit(1, this.GetMiddleX(2, 0), m_fStartY * 3.0f / 2.0f + this.GetMiddleY(2, 4), 800L);
                    comboLevelHasChanged = false;
                    break;
                }
                case 4: {
                    CGHit.NewHit(2, this.GetMiddleX(2, 0), m_fStartY * 3.0f / 2.0f + this.GetMiddleY(2, 4), 800L);
                    comboLevelHasChanged = false;
                    break;
                }
                case 5: {
                    CGHit.NewHit(3, this.GetMiddleX(2, 0), m_fStartY * 3.0f / 2.0f + this.GetMiddleY(2, 4), 800L);
                    comboLevelHasChanged = false;
                    break;
                }
                case 6: {
                    CGHit.NewHit(4, this.GetMiddleX(2, 0), m_fStartY * 3.0f / 2.0f + this.GetMiddleY(2, 4), 800L);
                    comboLevelHasChanged = false;
                    break;
                }
            }
        }
        System.out.println(currentComboLevel);
    }

    public void CheckColumn(int n) {
        for (int i = BOARD_MAX_HEIGHT - 2; i >= 0; --i) {
            if (this.m_Board[n][i] == null || this.m_Board[n][i].m_nType >= 100 || !this.m_Board[n][i].IsInBoard() || this.m_Board[n][i + 1] != null) continue;
            int n2 = i + 1;
            boolean bl = false;
            for (int j = i + 1; j < BOARD_MAX_HEIGHT; ++j) {
                if (this.m_Board[n][j] == null) continue;
                n2 = j - 1;
                bl = true;
                break;
            }
            if (!bl) {
                n2 = BOARD_MAX_HEIGHT - 1;
            }
            CGJewel cGJewel = this.m_Board[n][i];
            this.m_Board[n][i] = null;
            cGJewel.SetTargetY((float)n2 * m_fSize + m_fSize / 2.0f);
        }
    }

    public void CheckColumnForNew(int n) {
        for (int i = 0; i < BOARD_MAX_HEIGHT && this.m_Board[n][i] == null; ++i) {
            this.NewJewelForPos(n, i);
        }
    }

    public int CountCheckColumnForNew(int n) {
        int n2 = 0;
        for (int i = 0; i < BOARD_MAX_HEIGHT && this.m_Board[n][i] == null; ++i) {
            ++n2;
        }
        return n2;
    }

    public void DeleteFromJewels(CGJewel cGJewel) {
        int n = this.m_arrJewels.size();
        for (int i = 0; i < n; ++i) {
            CGJewel cGJewel2 = (CGJewel)this.m_arrJewels.elementAt(i);
            if (cGJewel2 != cGJewel) continue;
            this.m_arrJewels.removeElementAt(i);
            return;
        }
    }

    public void EndOfRotate() {
        for (int i = 0; i < BOARD_MAX_HEIGHT; ++i) {
            for (int j = 0; j < BOARD_MAX_WIDTH; ++j) {
                if (this.m_Board[j][i] == null) continue;
                this.m_Board[j][i].m_fRadiusX = -1000.0f;
                this.m_Board[j][i].m_fRadiusY = -1000.0f;
            }
        }
        if (--CGEngine.m_nMovesLeft < 0) {
            CGEngine.m_nMovesLeft = 0;
        }
    }

    public void Render() {
        int n;
        int n2;
        for (n2 = 0; n2 < BOARD_MAX_HEIGHT; ++n2) {
            for (n = 0; n < BOARD_MAX_WIDTH; ++n) {
                float f = this.GetMiddleX(n, n2);
                float f2 = this.GetMiddleY(n, n2);
            }
        }
        n2 = this.m_arrJewels.size();
        for (n = 0; n < n2; ++n) {
            CGJewel cGJewel = (CGJewel)this.m_arrJewels.elementAt(n);
            if (cGJewel.m_fRadiusX != -1000.0f || cGJewel.m_fRadiusY != -1000.0f) continue;
            cGJewel.Render();
        }
        for (n = 0; n < n2; ++n) {
            CGJewel cGJewel = (CGJewel)this.m_arrJewels.elementAt(n);
            if (cGJewel.m_fRadiusX == -1000.0f && cGJewel.m_fRadiusY == -1000.0f) continue;
            cGJewel.Render();
        }
        if (this.IsGoodSelect() && m_nStartSelectX >= 0 && m_nStartSelectY >= 0 && m_nEndSelectX >= 0 && m_nEndSelectY >= 0) {
            if (m_nStartSelectX == m_nEndSelectX) {
                float f = this.GetMiddleX(m_nStartSelectX, m_nStartSelectY);
                float f3 = this.GetMiddleY(m_nStartSelectX, m_nStartSelectY);
                CGEngineRenderer.RenderSelectJewel(f, f3, Math.abs(m_nStartSelectY - m_nEndSelectY), false);
            } else {
                float f = this.GetMiddleX(m_nStartSelectX, m_nStartSelectY);
                float f4 = this.GetMiddleY(m_nStartSelectX, m_nStartSelectY);
                CGEngineRenderer.RenderSelectJewel(f, f4, Math.abs(m_nEndSelectX - m_nStartSelectX), true);
            }
        }
    }

    public void CheckSelect() {
        m_nStartSelectX = -10;
        m_nStartSelectY = -10;
        m_nEndSelectX = -10;
        m_nEndSelectY = -10;
        if (CGEngine.m_StartSelectPointX > 0.0f && CGEngine.m_StartSelectPointY > 0.0f) {
            int n = (int)CGEngine.m_StartSelectPointX / (int)m_fSize;
            int n2 = (int)CGEngine.m_StartSelectPointY / (int)m_fSize;
            int n3 = (int)CGEngine.m_CurrentSelectPointX / (int)m_fSize;
            int n4 = (int)CGEngine.m_CurrentSelectPointY / (int)m_fSize;
            if (Math.abs(n3 - n) < Math.abs(n4 - n2)) {
                n3 = n;
                if (n2 > n4) {
                    int n5 = n2;
                    n2 = n4;
                    n4 = n5;
                }
                m_nStartSelectX = n;
                m_nStartSelectY = n2;
                if (m_nStartSelectY < 0) {
                    m_nStartSelectY = 0;
                }
                m_nEndSelectX = n;
                m_nEndSelectY = n4;
                if (m_nEndSelectY > 4) {
                    m_nEndSelectY = 4;
                }
            } else {
                n4 = n2;
                if (n > n3) {
                    int n6 = n;
                    n = n3;
                    n3 = n6;
                }
                if ((m_nStartSelectX = n) < 0) {
                    m_nStartSelectX = 0;
                }
                m_nStartSelectY = n2;
                m_nEndSelectX = n3;
                if (m_nEndSelectX > 4) {
                    m_nEndSelectX = 4;
                }
                m_nEndSelectY = n4;
            }
        }
    }

    public boolean IsGoodSelect() {
        if (m_nStartSelectX >= 0 && m_nStartSelectY >= 0 && m_nEndSelectX >= 0 && m_nEndSelectY >= 0) {
            if (m_nStartSelectX == m_nEndSelectX) {
                for (int i = m_nStartSelectY; i <= m_nEndSelectY; ++i) {
                    if (this.m_Board[m_nStartSelectX][i] != null && this.m_Board[CGBoard.m_nStartSelectX][i].m_nType != CGJewel.eType_Unvisible) continue;
                    return false;
                }
            } else {
                for (int i = m_nStartSelectX; i <= m_nEndSelectX; ++i) {
                    if (this.m_Board[i][m_nStartSelectY] != null && this.m_Board[i][CGBoard.m_nStartSelectY].m_nType != CGJewel.eType_Unvisible) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void ChangePos() {
        block3: {
            block4: {
                if (!this.IsGoodSelect()) {
                    return;
                }
                if (m_nStartSelectX < 0 || m_nStartSelectY < 0 || m_nEndSelectX < 0 || m_nEndSelectY < 0) break block3;
                if (m_nStartSelectX != m_nEndSelectX || m_nEndSelectY - m_nStartSelectY < 2) break block4;
                m_fCurrentRotateCenterX = ((float)m_nStartSelectX + 0.5f) * m_fSize;
                m_fCurrentRotateCenterY = (((float)m_nStartSelectY + 0.5f) * m_fSize + ((float)m_nEndSelectY + 0.5f) * m_fSize) / 2.0f;
                m_fCurrentRotateAngle = 1.0f;
                int n = m_nEndSelectY - m_nStartSelectY + 1;
                for (int i = 0; i < n / 2; ++i) {
                    CGJewel cGJewel = this.m_Board[m_nStartSelectX][m_nStartSelectY + i];
                    CGJewel cGJewel2 = this.m_Board[m_nStartSelectX][m_nStartSelectY + n - i - 1];
                    cGJewel.m_fRadiusY = (float)(m_nStartSelectY + i) * m_fSize + m_fSize / 2.0f - m_fCurrentRotateCenterY;
                    cGJewel2.m_fRadiusY = (float)(m_nStartSelectY + n - i - 1) * m_fSize + m_fSize / 2.0f - m_fCurrentRotateCenterY;
                    this.m_Board[CGBoard.m_nStartSelectX][CGBoard.m_nStartSelectY + i] = cGJewel2;
                    cGJewel2.m_fX = (float)m_nStartSelectX * m_fSize + m_fSize / 2.0f;
                    cGJewel2.m_fTargetY = cGJewel2.m_fY = (float)(m_nStartSelectY + i) * m_fSize + m_fSize / 2.0f;
                    this.m_Board[CGBoard.m_nStartSelectX][CGBoard.m_nStartSelectY + n - i - 1] = cGJewel;
                    cGJewel.m_fX = (float)m_nStartSelectX * m_fSize + m_fSize / 2.0f;
                    cGJewel.m_fTargetY = cGJewel.m_fY = (float)(m_nStartSelectY + n - i - 1) * m_fSize + m_fSize / 2.0f;
                }
                break block3;
            }
            if (m_nStartSelectY != m_nEndSelectY || m_nEndSelectX - m_nStartSelectX < 2) break block3;
            m_fCurrentRotateCenterX = (((float)m_nStartSelectX + 0.5f) * m_fSize + ((float)m_nEndSelectX + 0.5f) * m_fSize) / 2.0f;
            m_fCurrentRotateCenterY = ((float)m_nStartSelectY + 0.5f) * m_fSize;
            m_fCurrentRotateAngle = 1.0f;
            int n = m_nEndSelectX - m_nStartSelectX + 1;
            for (int i = 0; i < n / 2; ++i) {
                CGJewel cGJewel = this.m_Board[m_nStartSelectX + i][m_nStartSelectY];
                CGJewel cGJewel3 = this.m_Board[m_nStartSelectX + n - i - 1][m_nStartSelectY];
                cGJewel.m_fRadiusX = (float)(m_nStartSelectX + i) * m_fSize + m_fSize / 2.0f - m_fCurrentRotateCenterX;
                cGJewel3.m_fRadiusX = (float)(m_nStartSelectX + n - i - 1) * m_fSize + m_fSize / 2.0f - m_fCurrentRotateCenterX;
                this.m_Board[CGBoard.m_nStartSelectX + i][CGBoard.m_nStartSelectY] = cGJewel3;
                cGJewel3.m_fX = (float)(m_nStartSelectX + i) * m_fSize + m_fSize / 2.0f;
                cGJewel3.m_fTargetY = cGJewel3.m_fY = (float)m_nStartSelectY * m_fSize + m_fSize / 2.0f;
                this.m_Board[CGBoard.m_nStartSelectX + n - i - 1][CGBoard.m_nStartSelectY] = cGJewel;
                cGJewel.m_fX = (float)(m_nStartSelectX + n - i - 1) * m_fSize + m_fSize / 2.0f;
                cGJewel.m_fTargetY = cGJewel.m_fY = (float)m_nStartSelectY * m_fSize + m_fSize / 2.0f;
            }
        }
    }

    public static int getM_nSpecialJewelIndex() {
        return m_nSpecialJewelIndex;
    }

    public static void setM_nSpecialJewelIndex(int n) {
        m_nSpecialJewelIndex = n;
    }

    public static int getM_nSpecialJewelType() {
        return m_nSpecialJewelType;
    }

    public static void setM_nSpecialJewelType(int n) {
        m_nSpecialJewelType = n;
    }

    static {
        m_nNrofTypes = 7;
        m_SelectTexture = null;
        m_arrSelectTexture = null;
        m_nNewJewelIndex = -1;
        m_nSpecialJewelIndex = -1;
        m_nSpecialJewelType = -1;
        m_buttonSelectLevel = null;
        m_fCurrentRotateAngle = 0.0f;
        m_fCurrentRotateCenterX = 0.0f;
        m_fCurrentRotateCenterY = 0.0f;
        m_MarkerTexture = null;
        currentComboLevel = 1;
        comboLevelHasChanged = false;
        currentChainLevel = 0;
        timeFromLastDestroyMs = 0L;
        nothingDestroyedInLastTurn = true;
        BOARD_MAX_WIDTH = 5;
        BOARD_MAX_HEIGHT = 5;
        arrTmp = new int[BOARD_MAX_WIDTH * BOARD_MAX_HEIGHT];
    }
}

