/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.graphic3d;

import baltorogames.graphic3d.BGTransform;
import baltorogames.graphic3d.VectorF3;

public class MatrixF44
implements BGTransform {
    protected static float[] zeroArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public float[] a = new float[16];
    public static MatrixF44 g_Matrix1 = new MatrixF44();
    public static MatrixF44 g_Matrix2 = new MatrixF44();
    public static MatrixF44 g_Matrix3 = new MatrixF44();
    public static MatrixF44 g_Matrix4 = new MatrixF44();
    public static MatrixF44 g_Matrix5 = new MatrixF44();
    public static MatrixF44 g_Matrix6 = new MatrixF44();
    public static MatrixF44 g_Matrix7 = new MatrixF44();
    public static MatrixF44 g_Matrix8 = new MatrixF44();
    public static MatrixF44 g_Matrix9 = new MatrixF44();
    public static MatrixF44 g_Matrix10 = new MatrixF44();
    static float[] tmp = new float[16];

    public MatrixF44() {
        MatrixF44.MatrixF44_Identity(this);
    }

    float Get(int n, int n2) {
        return this.a[(n << 2) + n2];
    }

    public void postScale(float f, float f2, float f3) {
        MatrixF44 matrixF44 = new MatrixF44();
        MatrixF44.MatrixF44_Scale(matrixF44, f, f2, f3);
        MatrixF44.MatrixF44_Multiply(this, matrixF44, this);
    }

    public void postTranslate(float f, float f2, float f3) {
        this.a[12] = this.a[12] + f;
        this.a[13] = this.a[13] + f2;
        this.a[14] = this.a[14] + f3;
    }

    public void postRotate(float f, float f2, float f3, float f4) {
        MatrixF44 matrixF44 = new MatrixF44();
        MatrixF44.MatrixF44_RotXYZ(matrixF44, f, f2, f3, f4);
        MatrixF44.MatrixF44_Multiply(this, matrixF44, this);
    }

    public void setIdentity() {
        System.arraycopy(zeroArray, 0, this.a, 0, 16);
        this.a[0] = 1.0f;
        this.a[5] = 1.0f;
        this.a[10] = 1.0f;
        this.a[15] = 1.0f;
    }

    public void postMultiply(BGTransform bGTransform) {
        float[] fArray = bGTransform.get();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                float f = 0.0f;
                for (int k = 0; k < 4; ++k) {
                    f += fArray[k * 4 + i] * this.a[j * 4 + k];
                }
                MatrixF44.tmp[j * 4 + i] = f;
            }
        }
        System.arraycopy(tmp, 0, this.a, 0, 16);
    }

    public void transpose() {
        float f = 0.0f;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                f = this.a[j * 4 + i];
                this.a[j * 4 + i] = this.a[i * 4 + j];
                this.a[i * 4 + j] = f;
            }
        }
    }

    public void invert() {
    }

    public void transform(float[] fArray) {
        float[] fArray2 = new float[4];
        System.arraycopy(fArray, 0, fArray2, 0, 4);
        fArray[0] = fArray2[0] * this.a[0] + fArray2[1] * this.a[4] + fArray2[2] * this.a[8] + fArray2[3] * this.a[12];
        fArray[1] = fArray2[0] * this.a[1] + fArray2[1] * this.a[5] + fArray2[2] * this.a[9] + fArray2[3] * this.a[13];
        fArray[2] = fArray2[0] * this.a[2] + fArray2[1] * this.a[6] + fArray2[2] * this.a[10] + fArray2[3] * this.a[14];
        fArray[3] = fArray2[0] * this.a[3] + fArray2[1] * this.a[7] + fArray2[2] * this.a[11] + fArray2[3] * this.a[15];
    }

    public void set(float[] fArray) {
        System.arraycopy(fArray, 0, this.a, 0, 16);
    }

    public void set(BGTransform bGTransform) {
        float[] fArray = bGTransform.get();
        System.arraycopy(fArray, 0, this.a, 0, 16);
    }

    public float[] get() {
        float[] fArray = new float[16];
        System.arraycopy(this.a, 0, fArray, 0, 16);
        return fArray;
    }

    public static void MatrixF44_Mul_VectorF3(VectorF3 vectorF3, MatrixF44 matrixF44, VectorF3 vectorF32) {
        vectorF32.x = vectorF3.x * matrixF44.a[0] + vectorF3.y * matrixF44.a[4] + vectorF3.z * matrixF44.a[8];
        vectorF32.y = vectorF3.x * matrixF44.a[1] + vectorF3.y * matrixF44.a[5] + vectorF3.z * matrixF44.a[9];
        vectorF32.z = vectorF3.x * matrixF44.a[2] + vectorF3.y * matrixF44.a[6] + vectorF3.z * matrixF44.a[10];
    }

    public static void MatrixF44_Copy(MatrixF44 matrixF44, MatrixF44 matrixF442) {
        System.arraycopy(matrixF44.a, 0, matrixF442.a, 0, 16);
    }

    public static void MatrixF44_Identity(MatrixF44 matrixF44) {
        System.arraycopy(zeroArray, 0, matrixF44.a, 0, 16);
        matrixF44.a[0] = 1.0f;
        matrixF44.a[5] = 1.0f;
        matrixF44.a[10] = 1.0f;
        matrixF44.a[15] = 1.0f;
    }

    public static void MatrixF44_Scale(MatrixF44 matrixF44, float f, float f2, float f3) {
        System.arraycopy(zeroArray, 0, matrixF44.a, 0, 16);
        matrixF44.a[0] = f;
        matrixF44.a[5] = f2;
        matrixF44.a[10] = f3;
        matrixF44.a[15] = 1.0f;
    }

    public static void MatrixF44_RotX(MatrixF44 matrixF44, float f, float f2, float f3) {
        MatrixF44.MatrixF44_Identity(matrixF44);
        matrixF44.a[5] = f2;
        matrixF44.a[6] = f;
        matrixF44.a[9] = -f;
        matrixF44.a[10] = f2;
    }

    public static void MatrixF44_RotX(MatrixF44 matrixF44, float f) {
        float f2;
        MatrixF44.MatrixF44_Identity(matrixF44);
        matrixF44.a[6] = f2 = (float)Math.sin(f);
        matrixF44.a[9] = -f2;
        matrixF44.a[5] = f2 = (float)Math.cos(f);
        matrixF44.a[10] = f2;
    }

    public static void MatrixF44_RotY(MatrixF44 matrixF44, float f, float f2, float f3) {
        MatrixF44.MatrixF44_Identity(matrixF44);
        matrixF44.a[0] = f2;
        matrixF44.a[2] = -f;
        matrixF44.a[8] = f;
        matrixF44.a[10] = f2;
    }

    public static void MatrixF44_RotY(MatrixF44 matrixF44, float f) {
        MatrixF44.MatrixF44_Identity(matrixF44);
        float f2 = (float)Math.sin(f);
        matrixF44.a[2] = -f2;
        matrixF44.a[8] = f2;
        matrixF44.a[0] = f2 = (float)Math.cos(f);
        matrixF44.a[10] = f2;
    }

    public static void MatrixF44_RotZ(MatrixF44 matrixF44, float f, float f2, float f3) {
        MatrixF44.MatrixF44_Identity(matrixF44);
        matrixF44.a[0] = f2;
        matrixF44.a[1] = f;
        matrixF44.a[4] = -f;
        matrixF44.a[5] = f2;
    }

    public static void MatrixF44_RotZ(MatrixF44 matrixF44, float f) {
        float f2;
        MatrixF44.MatrixF44_Identity(matrixF44);
        matrixF44.a[1] = f2 = (float)Math.sin(f);
        matrixF44.a[4] = -f2;
        matrixF44.a[0] = f2 = (float)Math.cos(f);
        matrixF44.a[5] = f2;
    }

    public static void MatrixF44_RotXYZ(MatrixF44 matrixF44, float f, float f2, float f3, float f4) {
        float f5 = (float)Math.sin(f);
        float f6 = (float)Math.cos(f);
        matrixF44.a[0] = f2 * f2 + (1.0f - f2 * f2) * f6;
        matrixF44.a[1] = f2 * f3 * (1.0f - f6) - f4 * f5;
        matrixF44.a[2] = f2 * f4 * (1.0f - f6) - f3 * f5;
        matrixF44.a[3] = 0.0f;
        matrixF44.a[4] = f2 * f3 * (1.0f - f6) + f4 * f5;
        matrixF44.a[5] = f3 * f3 + (1.0f - f3 * f3) * f6;
        matrixF44.a[6] = f3 * f4 * (1.0f - f6) - f2 * f5;
        matrixF44.a[7] = 0.0f;
        matrixF44.a[8] = f2 * f4 * (1.0f - f6) - f3 * f5;
        matrixF44.a[9] = f3 * f4 * (1.0f - f6) + f2 * f5;
        matrixF44.a[10] = f4 * f4 + (1.0f - f4 * f4) * f6;
        matrixF44.a[11] = 0.0f;
        matrixF44.a[12] = 0.0f;
        matrixF44.a[13] = 0.0f;
        matrixF44.a[14] = 0.0f;
        matrixF44.a[15] = 1.0f;
    }

    public static void MatrixF44_Multiply(MatrixF44 matrixF44, MatrixF44 matrixF442, MatrixF44 matrixF443) {
        MatrixF44 matrixF444 = g_Matrix10;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                float f = 0.0f;
                for (int k = 0; k < 4; ++k) {
                    f += matrixF442.a[k * 4 + i] * matrixF44.a[j * 4 + k];
                }
                matrixF444.a[j * 4 + i] = f;
            }
        }
        MatrixF44.MatrixF44_Copy(matrixF444, matrixF443);
    }

    public static void MatrixF44_MultiplyQ(MatrixF44 matrixF44, MatrixF44 matrixF442, MatrixF44 matrixF443) {
        MatrixF44 matrixF444 = g_Matrix10;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                float f = 0.0f;
                for (int k = 0; k < 4; ++k) {
                    f += matrixF442.a[k * 4 + i] * matrixF44.a[j * 4 + k];
                }
                matrixF443.a[j * 4 + i] = f;
            }
        }
    }

    public static void IdentityMatrix(float[] fArray) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = 0.0f;
        fArray[5] = 1.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 0.0f;
        fArray[9] = 0.0f;
        fArray[10] = 1.0f;
        fArray[11] = 0.0f;
        fArray[12] = 0.0f;
        fArray[13] = 0.0f;
        fArray[14] = 0.0f;
        fArray[15] = 1.0f;
    }

    public static void CopyMatrix(float[] fArray, float[] fArray2) {
        System.arraycopy(fArray, 0, fArray2, 0, 16);
    }

    public static void MultiplyMatrixes(float[] fArray, float[] fArray2, float[] fArray3) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                float f = 0.0f;
                for (int k = 0; k < 4; ++k) {
                    f += fArray2[k * 4 + i] * fArray[j * 4 + k];
                }
                MatrixF44.tmp[j * 4 + i] = f;
            }
        }
        System.arraycopy(tmp, 0, fArray3, 0, 16);
    }
}

