/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.AppCanvas;
import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonV;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.system.ObjectsCache;
import java.util.Vector;

public class UITextBox
extends UIScreen {
    private final int UP_ARROW_ID;
    private final int DOWN_ARROW_ID;
    protected boolean smallHeight = false;
    protected Vector textLines = new Vector();
    protected int textHeight = 0;
    protected float scrollOffset = 0.0f;
    protected boolean scrollable = false;
    private final float SCROLL_SPEED;
    protected int fontID = 0;
    protected boolean hasBackground = false;
    private boolean isUp = false;
    private boolean isDown = false;
    protected int m_nTextAllign = 17;

    public void setTextAllign(int n) {
        this.m_nTextAllign = n;
    }

    public void setBackground(boolean bl) {
        this.hasBackground = bl;
    }

    public void AddArrows() {
        this.removeByID(100);
        this.removeByID(101);
        int n = ApplicationData.screenWidth / 2 - ObjectsCache.arrowUp.GetWidth() / 2;
        int n2 = this.positionY - ObjectsCache.arrowUp.GetHeight();
        UIAnimatedButtonV uIAnimatedButtonV = new UIAnimatedButtonV(n, n2, ObjectsCache.arrowUp, ObjectsCache.arrowUp_a, 100);
        uIAnimatedButtonV.setScreen(this);
        uIAnimatedButtonV.setAnimDir(1.0f);
        this.addButton(uIAnimatedButtonV);
        uIAnimatedButtonV.setVisible(false);
        n2 = this.positionY + this.height;
        UIAnimatedButtonV uIAnimatedButtonV2 = new UIAnimatedButtonV(n, n2, ObjectsCache.arrowDown, ObjectsCache.arrowDown_a, 101);
        uIAnimatedButtonV2.setScreen(this);
        uIAnimatedButtonV2.setAnimDir(-1.0f);
        this.addButton(uIAnimatedButtonV2);
        uIAnimatedButtonV2.setVisible(false);
    }

    public UITextBox(int n, int n2, int n3, int n4, boolean bl, int n5, boolean bl2, UIScreen uIScreen) {
        this.UP_ARROW_ID = 100;
        this.DOWN_ARROW_ID = 101;
        this.SCROLL_SPEED = 60.0f;
        this.scrollable = bl;
        this.showScrollbars(this.scrollable);
        this.fontID = n5;
        this.hasBackground = bl2;
        this.userPositionX = n;
        this.userPositionY = n2;
        this.userWidth = n3;
        this.userHeight = n4;
        this.setupDrawingArea();
        if (this.scrollable) {
            this.AddArrows();
        }
        this.parentScreen = uIScreen;
    }

    public UITextBox(int n, int n2, int n3, int n4, boolean bl) {
        this.UP_ARROW_ID = 100;
        this.DOWN_ARROW_ID = 101;
        this.SCROLL_SPEED = 60.0f;
        this.scrollable = bl;
        this.showScrollbars(this.scrollable);
        this.userPositionX = n;
        this.userPositionY = n2;
        this.userWidth = n3;
        this.userHeight = n4;
        this.setupDrawingArea();
        if (this.scrollable) {
            this.AddArrows();
        }
    }

    public UITextBox(int n, int n2, int n3, int n4, boolean bl, UIScreen uIScreen) {
        this.UP_ARROW_ID = 100;
        this.DOWN_ARROW_ID = 101;
        this.SCROLL_SPEED = 60.0f;
        this.scrollable = bl;
        this.parentScreen = uIScreen;
        this.showScrollbars(this.scrollable);
        this.userPositionX = n;
        this.userPositionY = n2;
        this.userWidth = n3;
        this.userHeight = n4;
        this.setupDrawingArea();
        if (this.scrollable) {
            this.AddArrows();
        }
    }

    protected void setupDrawingArea() {
        if (!this.hasBackground) {
            this.positionX = this.userPositionX;
            this.positionY = this.userPositionY;
            this.width = this.userWidth;
            this.height = this.userHeight;
        }
    }

    public void onUpdate(float f) {
        super.onUpdate(f);
        if (this.scrollable) {
            UIButton uIButton = this.findByID(100);
            if (uIButton != null && !uIButton.isVisible && this.scrollOffset < 0.0f) {
                uIButton.setVisible(true);
            }
            if (AppCanvas.uitbUP || uIButton != null && uIButton.isActive && uIButton.isVisible && uIButton.isSelected) {
                if (this.scrollOffset < 0.0f) {
                    this.scrollOffset += f * 60.0f;
                    if (this.scrollOffset > 0.0f) {
                        this.scrollOffset = 0.0f;
                    }
                } else {
                    uIButton.setVisible(false);
                    uIButton.setSelect(false);
                }
            }
            int n = -ApplicationData.getFontByID(this.fontID).getFontHeight() * (this.textLines.size() - this.height / ApplicationData.getFontByID(this.fontID).getFontHeight());
            uIButton = this.findByID(101);
            if (uIButton != null && !uIButton.isVisible && this.scrollOffset > (float)n) {
                uIButton.setVisible(true);
            }
            if (AppCanvas.uitbDOWN || uIButton != null && uIButton.isActive && uIButton.isVisible && uIButton.isSelected) {
                if (this.scrollOffset > (float)n) {
                    this.scrollOffset -= f * 60.0f;
                    if (this.scrollOffset < (float)n) {
                        this.scrollOffset = n;
                    }
                } else {
                    uIButton.setVisible(false);
                    uIButton.setSelect(false);
                }
            }
        } else {
            UIButton uIButton = this.findByID(100);
            if (uIButton != null) {
                uIButton.setVisible(false);
            }
            if ((uIButton = this.findByID(101)) != null) {
                uIButton.setVisible(false);
            }
        }
    }

    public void setText(String string, String string2) {
        this.textLines = Utils.splitText(string, string2, this.width);
        this.textHeight = this.textLines.size() * ApplicationData.getFontByID(this.fontID).getFontHeight() - ApplicationData.getFontByID(this.fontID).getFontSpacing();
        if (this.checkIfScrollsAreNeeded()) {
            this.textLines = Utils.splitText(string, string2, this.width);
            this.textHeight = this.textLines.size() * ApplicationData.getFontByID(this.fontID).getFontHeight();
        }
    }

    public void setText(String string) {
        this.setText(string, "+");
        this.scrollOffset = 0.0f;
    }

    private boolean checkIfScrollsAreNeeded() {
        this.showScrollbars = this.scrollable = this.textHeight > this.height;
        return this.scrollable;
    }

    public void drawWindowBackground() {
    }

    public void drawWindowForeground() {
    }

    public void draw() {
        int n = ApplicationData.getFontByID(this.fontID).getFontHeight();
        int n2 = 0;
        if (!this.scrollable) {
            n2 = (this.height - n * this.textLines.size()) / 2;
        }
        if (this.hasBackground) {
            // empty if block
        }
        Graphic2D.SetClip(this.positionX, this.positionY, this.width, this.height);
        int n3 = this.positionX + this.width / 2;
        if ((this.m_nTextAllign & 4) > 0) {
            n3 = this.positionX;
        } else if ((this.m_nTextAllign & 8) > 0) {
            n3 = this.positionX + this.width;
        }
        for (int i = 0; i < this.textLines.size(); ++i) {
            int n4 = this.positionY + i * n + (int)this.scrollOffset + n2;
            if (n4 < 0 || n4 > ApplicationData.screenHeight) continue;
            if (!this.showScrollbars) {
                Utils.drawString((String)this.textLines.elementAt(i), n3, n4, this.m_nTextAllign, this.fontID);
                continue;
            }
            Utils.drawString((String)this.textLines.elementAt(i), n3, n4, this.m_nTextAllign, this.fontID);
        }
        Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
    }

    protected void drawTextBoxBackground(int n, int n2) {
    }

    public boolean actionSoftButton(int n) {
        return false;
    }

    public boolean rightSoftButton() {
        if (this.findByID(UIScreen.ID_BUTTON_CANCEL) != null && this.parentScreen != null) {
            this.readyForClose = true;
            return true;
        }
        return false;
    }

    public boolean leftSoftButton() {
        if (this.findByID(UIScreen.ID_BUTTON_OK) != null && this.parentScreen != null) {
            this.readyForClose = true;
            return true;
        }
        return false;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean selectDownAction() {
        if (this.scrollable) {
            UIButton uIButton = this.findByID(101);
            if (uIButton != null) {
                uIButton.setSelect(true);
            }
            this.isUp = false;
            this.isDown = true;
            return true;
        }
        return false;
    }

    public boolean onDownAction() {
        if (this.scrollable) {
            this.isDown = false;
            return true;
        }
        return false;
    }

    public boolean selectUpAction() {
        if (this.scrollable) {
            UIButton uIButton = this.findByID(100);
            if (uIButton != null) {
                uIButton.setSelect(true);
            }
            this.isUp = true;
            this.isDown = false;
            return true;
        }
        return false;
    }

    public boolean onUpAction() {
        if (this.scrollable) {
            this.isUp = false;
            return true;
        }
        return false;
    }

    public void updateSize() {
    }

    public void autoSize() {
    }

    public void onFocusBack() {
        super.onFocusBack();
    }
}

