/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core;

import baltorogames.core.ApplicationData;
import baltorogames.core.CustomFont;
import java.util.Vector;

public class Utils {
    private static float[] cos_Table = new float[360];
    private static float[] sin_Table = new float[360];

    public static int CLAMP_INT(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public static float Lerp(float f, float f2, float f3) {
        return f * (1.0f - f3) + f2 * f3;
    }

    public static boolean isPointInRect(int n, int n2, int n3, int n4, int n5, int n6) {
        return n > n3 && n < n5 && n2 > n4 && n2 < n6;
    }

    public static boolean isPointInRect2(int n, int n2, int n3, int n4, int n5, int n6) {
        return Utils.isPointInRect(n, n2, n3, n4, n3 + n5, n4 + n6);
    }

    public static boolean parseNetResults(Vector vector, Vector vector2, String string) {
        int n = 0;
        int n2;
        while ((n2 = string.indexOf(36, n)) != -1) {
            vector.addElement(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf(36, n);
            if (n2 == -1) {
                return false;
            }
            vector2.addElement(string.substring(n, n2));
            n = n2 + 1;
        }
        return true;
    }

    public static String urlEncoder(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 3);
        try {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '&') {
                    stringBuffer.append("&");
                    continue;
                }
                if (c == ' ') {
                    stringBuffer.append('+');
                    continue;
                }
                if (c >= ',' && c <= ';' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '?') {
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append('%');
                if (c > '\u000f') {
                    stringBuffer.append(Integer.toHexString(c));
                    continue;
                }
                stringBuffer.append("0" + Integer.toHexString(c));
            }
        }
        catch (Exception exception) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static boolean intersection(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = (f8 - f6) * (f3 - f) - (f7 - f5) * (f4 - f2);
        if (f9 == 0.0f) {
            return false;
        }
        float f10 = ((f7 - f5) * (f2 - f6) - (f8 - f6) * (f - f5)) / f9;
        float f11 = ((f3 - f) * (f2 - f6) - (f4 - f2) * (f - f5)) / f9;
        return f10 > 0.0f && f10 < 1.0f && f11 > 0.0f && f11 < 1.0f;
    }

    public static float sqrDist(float f, float f2, float f3, float f4, float f5, float f6) {
        return Math.abs((f5 - f3) * (f4 - f2) - (f3 - f) * (f6 - f4)) / (float)Math.sqrt((f5 - f3) * (f5 - f3) + (f6 - f4) * (f6 - f4));
    }

    public static void initTRIGONOMETRY() {
        for (int i = 0; i < 360; ++i) {
            Utils.cos_Table[i] = (float)Math.cos(Math.toRadians(i));
            Utils.sin_Table[i] = (float)Math.sin(Math.toRadians(i));
        }
    }

    public static float COS(float f) {
        int n = (int)f % 360;
        if (n < 0) {
            n += 360;
        }
        return cos_Table[n];
    }

    public static float SIN(float f) {
        int n = (int)f % 360;
        if (n < 0) {
            n += 360;
        }
        return sin_Table[n];
    }

    public static Vector splitText(String string, String string2) {
        return Utils.splitText(string, string2, ApplicationData.screenWidth, 0);
    }

    public static Vector splitText(String string, String string2, int n) {
        return Utils.splitText(string, string2, n, 0);
    }

    public static Vector splitText(String string, String string2, int n, int n2) {
        int n3 = 0;
        Vector<String> vector = new Vector<String>();
        string2 = ApplicationData.defaultFont.encodeDynamicString(string2);
        int n4 = 255;
        while (true) {
            int n5;
            if ((n5 = string.indexOf(n4, n3)) == -1) {
                if (n3 >= string.length()) break;
                vector.addElement(string.substring(n3, string.length()));
                break;
            }
            vector.addElement(string.substring(n3, n5));
            n3 = n5 + 1;
        }
        if (vector.size() == 0) {
            vector.addElement(string);
        }
        return Utils.fitWidth(vector, n, n2);
    }

    public static Vector fitWidth(Vector vector, int n, int n2) {
        int n3 = 0;
        Vector<String> vector2 = new Vector<String>();
        String string = ApplicationData.defaultFont.encodeDynamicString(" ");
        String string2 = new String();
        block0: for (int i = 0; i < vector.size(); ++i) {
            String string3 = (String)vector.elementAt(i);
            n3 = 0;
            string2 = new String();
            while (true) {
                String string4;
                int n4;
                if ((n4 = string3.indexOf(string, n3)) == -1) {
                    string4 = string2 + string3.substring(n3);
                    if (Utils.stringWidth(string4, n2) >= n) {
                        vector2.addElement(string2);
                        vector2.addElement(string3.substring(n3));
                        continue block0;
                    }
                    vector2.addElement(string4);
                    continue block0;
                }
                string4 = string2 + string3.substring(n3, n4 + 1);
                if (Utils.stringWidth(string4, n2) >= n) {
                    vector2.addElement(string2);
                    string2 = string3.substring(n3, n4 + 1);
                } else {
                    string2 = string2 + string3.substring(n3, n4 + 1);
                }
                n3 = n4 + 1;
            }
        }
        return vector2;
    }

    public static int stringWidth(String string, int n) {
        return (int)ApplicationData.getFontByID(n).stringWidth(string);
    }

    public static void drawTimeString(long l, int n, int n2, int n3, int n4) {
        ApplicationData.getFontByID(n4).drawTimeString(l, n, n2, n3);
    }

    public static void drawString(String string, int n, int n2, int n3, int n4) {
        ApplicationData.getFontByID(n4).drawString(string, n, n2, n3);
    }

    public static void drawString(Vector vector, int n, int n2, int n3, int n4) {
        CustomFont customFont = ApplicationData.getFontByID(n4);
        int n5 = customFont.getFontHeight();
        if ((n3 & 0x20) != 0) {
            int n6 = vector.size() - 1;
            int n7 = 0;
            while (n6 >= 0) {
                customFont.drawString((String)vector.elementAt(n6), n, n2 - n7 * n5, n3);
                --n6;
                ++n7;
            }
        } else if ((n3 & 2) != 0) {
            int n8 = n5 * vector.size() / 2;
            for (int i = 0; i < vector.size(); ++i) {
                customFont.drawString((String)vector.elementAt(i), n, n2 + i * n5 - n8, n3);
            }
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                customFont.drawString((String)vector.elementAt(i), n, n2 + i * n5, n3);
            }
        }
    }

    public static String formatTimeAsc(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        long l4 = l2 % 60L;
        long l5 = l % 1000L / 10L;
        if (l3 < 10L) {
            stringBuffer.append(0);
        }
        stringBuffer.append(l3);
        stringBuffer.append(":");
        if (l4 < 10L) {
            stringBuffer.append(0);
        }
        stringBuffer.append(l4);
        stringBuffer.append(":");
        if (l5 < 10L) {
            stringBuffer.append(0);
        }
        stringBuffer.append(l5);
        return stringBuffer.toString();
    }
}

