/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core;

import baltorogames.core.CGFontChar;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.system.FileManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class CustomFont {
    int[] characters = new int[8];
    char[] numchar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    protected Vector m_vector = new Vector();
    protected int m_nLineHeight = 0;
    protected int m_nBaseLine = 0;
    protected int m_nTextureWidth = 0;
    protected int m_nTextureHeight = 0;
    protected String m_szTextureName;
    protected CGTexture m_Texture = null;
    protected int m_nColorR = 255;
    protected int m_nColorG = 255;
    protected int m_nColorB = 255;
    protected int m_nColorA = 255;
    protected float m_fColorR = 1.0f;
    protected float m_fColorG = 1.0f;
    protected float m_fColorB = 1.0f;
    protected float m_fColorA = 1.0f;
    protected float m_fScale = 1.0f;
    protected float m_fSize = 30.0f;

    public int Load(String szFileNameTXT) {
        Vector<String> vector = new Vector<String>();
        try {
            int ch;
            InputStream is = FileManager.OpenFile(szFileNameTXT);
            if (is == null) {
                is = FileManager.OpenURLFile(szFileNameTXT);
            }
            if (is == null) {
                return 0;
            }
            StringBuffer sb = new StringBuffer();
            while ((ch = is.read()) != -1) {
                sb.append((char)ch);
            }
            StringBuffer sub = new StringBuffer();
            int nLength = sb.length();
            for (int i = 0; i < nLength; ++i) {
                char c = sb.charAt(i);
                if (c == '\r' || c == '\n') {
                    String s = sub.toString();
                    vector.addElement(s);
                    sub.delete(0, sb.length());
                    ++i;
                    continue;
                }
                sub.append(c);
            }
            if (sub.length() > 0) {
                String s = sub.toString();
                vector.addElement(s);
                sub.delete(0, sb.length());
            }
        }
        catch (IOException e2) {
            System.out.println("Error1 FONT reading");
            e2.printStackTrace();
            return 0;
        }
        if (vector.size() == 0 || ((String)vector.elementAt(0)).length() == 0) {
            System.out.println("Error2 FONT reading");
            return 0;
        }
        String szTmp = null;
        String szLine = (String)vector.elementAt(1);
        int nIndex = szLine.indexOf("=");
        if (nIndex >= 0) {
            szLine = szLine.substring(nIndex + 1);
            nIndex = szLine.indexOf(" ");
            szTmp = szLine.substring(0, nIndex);
            this.m_nLineHeight = Integer.parseInt(szTmp);
        }
        if ((nIndex = szLine.indexOf("=")) >= 0) {
            szLine = szLine.substring(nIndex + 1);
            nIndex = szLine.indexOf(" ");
            szTmp = szLine.substring(0, nIndex);
            this.m_nBaseLine = Integer.parseInt(szTmp);
        }
        if ((nIndex = szLine.indexOf("=")) >= 0) {
            szLine = szLine.substring(nIndex + 1);
            nIndex = szLine.indexOf(" ");
            szTmp = szLine.substring(0, nIndex);
            this.m_nTextureWidth = Integer.parseInt(szTmp);
        }
        if ((nIndex = szLine.indexOf("=")) >= 0) {
            szLine = szLine.substring(nIndex + 1);
            nIndex = szLine.indexOf(" ");
            szTmp = szLine.substring(0, nIndex);
            this.m_nTextureHeight = Integer.parseInt(szTmp);
        }
        String szTextureName = null;
        szLine = (String)vector.elementAt(2);
        nIndex = szLine.indexOf("file=");
        if (nIndex >= 0 && (nIndex = (szTextureName = szLine.substring(nIndex + 6)).indexOf(34)) >= 0) {
            szTextureName = szTextureName.substring(0, nIndex);
        }
        this.m_szTextureName = szTextureName;
        int nCharSize = 0;
        szLine = (String)vector.elementAt(3);
        nIndex = szLine.indexOf("=");
        if (nIndex >= 0) {
            String szS = szLine.substring(nIndex + 1);
            nCharSize = Integer.parseInt(szS);
        }
        for (int nLine = 4; nLine < nCharSize + 4; ++nLine) {
            int nID = -1;
            int nX = -1;
            int nY = -1;
            int nW = -1;
            int nH = -1;
            int nOX = 0;
            int nOY = 0;
            szLine = (String)vector.elementAt(nLine);
            nIndex = szLine.indexOf("=");
            if (nIndex >= 0) {
                szLine = szLine.substring(nIndex + 1);
                nIndex = szLine.indexOf(" ");
                szTmp = szLine.substring(0, nIndex);
                nID = Integer.parseInt(szTmp);
            }
            if ((nIndex = szLine.indexOf("=")) >= 0) {
                szLine = szLine.substring(nIndex + 1);
                nIndex = szLine.indexOf(" ");
                szTmp = szLine.substring(0, nIndex);
                nX = Integer.parseInt(szTmp);
            }
            if ((nIndex = szLine.indexOf("=")) >= 0) {
                szLine = szLine.substring(nIndex + 1);
                nIndex = szLine.indexOf(" ");
                szTmp = szLine.substring(0, nIndex);
                nY = Integer.parseInt(szTmp);
            }
            if ((nIndex = szLine.indexOf("=")) >= 0) {
                szLine = szLine.substring(nIndex + 1);
                nIndex = szLine.indexOf(" ");
                szTmp = szLine.substring(0, nIndex);
                nW = Integer.parseInt(szTmp);
            }
            if ((nIndex = szLine.indexOf("=")) >= 0) {
                szLine = szLine.substring(nIndex + 1);
                nIndex = szLine.indexOf(" ");
                szTmp = szLine.substring(0, nIndex);
                nH = Integer.parseInt(szTmp);
            }
            if ((nIndex = szLine.indexOf("=")) >= 0) {
                szLine = szLine.substring(nIndex + 1);
                nIndex = szLine.indexOf(" ");
                szTmp = szLine.substring(0, nIndex);
                nOX = Integer.parseInt(szTmp);
            }
            if ((nIndex = szLine.indexOf("=")) >= 0) {
                szLine = szLine.substring(nIndex + 1);
                nIndex = szLine.indexOf(" ");
                szTmp = szLine.substring(0, nIndex);
                nOY = Integer.parseInt(szTmp);
            }
            CGFontChar fc = new CGFontChar();
            fc.m_nChar = nID;
            fc.m_nX = nX;
            fc.m_nY = nY;
            fc.m_nW = nW + 1;
            fc.m_nH = nH;
            fc.m_nOffsetX = nOX;
            fc.m_nOffsetY = nOY;
            fc.fU1 = (float)fc.m_nX / (float)this.m_nTextureWidth;
            fc.fU2 = (float)(fc.m_nX + fc.m_nW) / (float)this.m_nTextureWidth;
            fc.fV1 = (float)fc.m_nY / (float)this.m_nTextureHeight;
            fc.fV2 = (float)(fc.m_nY + fc.m_nH) / (float)this.m_nTextureHeight;
            this.m_vector.addElement(fc);
        }
        this.m_Texture = TextureManager.AddTexture("/" + this.m_szTextureName, true);
        if (this.m_Texture == null) {
            return 0;
        }
        int nSpaceIndex = this.FindCharIndex(32);
        if (nSpaceIndex >= 0) {
            ((CGFontChar)this.m_vector.elementAt((int)nSpaceIndex)).m_nW = 1;
            ((CGFontChar)this.m_vector.elementAt((int)nSpaceIndex)).m_nOffsetX = this.m_nLineHeight / 3;
        }
        return 1;
    }

    protected int FindCharIndex(int nC) {
        for (int i = 0; i < this.m_vector.size(); ++i) {
            if (((CGFontChar)this.m_vector.elementAt((int)i)).m_nChar != nC) continue;
            return i;
        }
        return -1;
    }

    public void drawString(String szText, int fX, int fY, int anchor) {
        float fTX = fX;
        if ((anchor & 1) != 0) {
            fTX -= this.stringWidth(szText) / 2.0f;
        } else if ((anchor & 8) != 0) {
            fTX -= this.stringWidth(szText);
        }
        float fTY = fY;
        if ((anchor & 2) != 0) {
            fTY -= (float)this.m_nLineHeight * this.m_fScale / 2.0f;
        } else if ((anchor & 0x20) != 0) {
            fTY -= (float)this.m_nLineHeight * this.m_fScale;
        }
        this.RenderStringInternal(fTX, fTY, szText);
    }

    protected void RenderStringInternal(float fX, float fY, String szText) {
        float fCurrX = fX;
        float fCurrY = fY;
        int nL = szText.length();
        for (int i = 0; i < nL; ++i) {
            float x2;
            float x1;
            char nC = szText.charAt(i);
            if (nC < '\u0000' || nC >= this.m_vector.size()) continue;
            CGFontChar fc = (CGFontChar)this.m_vector.elementAt(nC);
            if (i == 0) {
                x1 = fCurrX;
                x2 = fCurrX + (float)fc.m_nW * this.m_fScale;
            } else {
                x1 = fCurrX + (float)fc.m_nOffsetX * this.m_fScale;
                x2 = fCurrX + (float)fc.m_nOffsetX * this.m_fScale + (float)fc.m_nW * this.m_fScale;
            }
            float y1 = fCurrY + (float)fc.m_nOffsetY * this.m_fScale;
            float y2 = fCurrY + (float)(fc.m_nH + fc.m_nOffsetY) * this.m_fScale;
            Graphic2D.DrawRegion(this.m_Texture, fc.m_nX, fc.m_nY, fc.m_nW, fc.m_nH, 0, (int)x1, (int)y1, 0);
            if (i == 0) {
                fCurrX += (float)fc.m_nW * this.m_fScale;
                continue;
            }
            fCurrX += (float)(fc.m_nW + fc.m_nOffsetX) * this.m_fScale;
        }
    }

    public int getFontHeight() {
        return this.m_nLineHeight;
    }

    public int getFontSpacing() {
        return this.m_nLineHeight / 3;
    }

    public void drawTimeString(long _currentTime, int x, int y, int anchor) {
        this.drawTimeChars(_currentTime, 0, x, y, anchor);
    }

    public void drawTimeChars(long _currentTime, int p, int x, int y, int anchor) {
        int i;
        int index = 0;
        int seconds = (int)_currentTime / 1000;
        int m = seconds / 60;
        int s = seconds % 60;
        int mm = (int)(_currentTime % 1000L) / 10;
        this.characters[index++] = this.FindCharIndex(this.numchar[m / 10]);
        this.characters[index++] = this.FindCharIndex(this.numchar[m % 10]);
        this.characters[index++] = this.FindCharIndex(58);
        this.characters[index++] = this.FindCharIndex(this.numchar[s / 10]);
        this.characters[index++] = this.FindCharIndex(this.numchar[s % 10]);
        this.characters[index++] = this.FindCharIndex(58);
        this.characters[index++] = this.FindCharIndex(this.numchar[mm / 10]);
        this.characters[index++] = this.FindCharIndex(this.numchar[mm % 10]);
        int nH = 0;
        for (i = 0; i < 8; ++i) {
            nH += ((CGFontChar)this.m_vector.elementAt((int)this.characters[i])).m_nW + ((CGFontChar)this.m_vector.elementAt((int)this.characters[i])).m_nOffsetX;
        }
        if ((anchor & 8) != 0) {
            x -= nH;
        } else if ((anchor & 1) != 0) {
            x -= nH / 2;
        }
        for (i = 0; i < 8; ++i) {
            CGFontChar fc = (CGFontChar)this.m_vector.elementAt(this.characters[i]);
            float x1 = x;
            float y1 = (float)y + (float)fc.m_nOffsetY * this.m_fScale;
            float x2 = (float)x + (float)fc.m_nW * this.m_fScale;
            float y2 = (float)y + (float)(fc.m_nH + fc.m_nOffsetY) * this.m_fScale;
            Graphic2D.DrawRegion(this.m_Texture, x1, y1, fc.fU1, fc.fV1, x2, y2, fc.fU2, fc.fV2);
            x = (int)((float)x + (float)(fc.m_nW + fc.m_nOffsetX) * this.m_fScale);
        }
    }

    public float stringWidth(String szText) {
        float fCurrX = 0.0f;
        int nL = szText.length();
        for (int i = 0; i < nL; ++i) {
            char nC = szText.charAt(i);
            if (nC < '\u0000' || nC >= this.m_vector.size()) continue;
            CGFontChar fc = (CGFontChar)this.m_vector.elementAt(nC);
            fCurrX += (float)(fc.m_nW + fc.m_nOffsetX) * this.m_fScale;
        }
        return fCurrX;
    }

    public void SetColor(int r, int g, int b, int a) {
        this.m_nColorR = r;
        this.m_nColorG = g;
        this.m_nColorB = b;
        this.m_nColorA = a;
        this.m_fColorR = (float)r / 255.0f;
        this.m_fColorG = (float)g / 255.0f;
        this.m_fColorB = (float)b / 255.0f;
        this.m_fColorA = (float)a / 255.0f;
    }

    public int GetR() {
        return this.m_nColorR;
    }

    public int GetG() {
        return this.m_nColorG;
    }

    public int GetB() {
        return this.m_nColorB;
    }

    public int GetA() {
        return this.m_nColorA;
    }

    public void SetSize(float f) {
    }

    public float GetSize() {
        return this.m_fSize;
    }

    public float GetHeight() {
        return this.m_fScale * (float)this.m_nLineHeight;
    }

    public char getDecodedCharIndex(int i) {
        return (char)this.FindCharIndex(i);
    }

    public String encodeDynamicString(String szIn) {
        String szOut = "";
        for (int i = 0; i < szIn.length(); ++i) {
            szOut = szOut + this.getDecodedCharIndex(szIn.charAt(i));
        }
        return szOut;
    }

    public void Destroy() {
    }
}

