/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.system.Platform;
import java.util.Vector;

public class UIFloatingTextBox {
    protected Vector textLines = new Vector();
    private int textHeight = 0;
    protected float scrollOffset = 0.0f;
    protected boolean scrollable = false;
    protected final float SCROLL_SPEED;
    private int positionX;
    private int positionY;
    private int width;
    protected int height;
    public boolean hasBackground = false;
    public int fontID = 0;

    public UIFloatingTextBox(boolean _scrollable, int x, int y, int w, int h) {
        this.SCROLL_SPEED = 30.0f;
        this.positionX = x;
        this.positionY = y;
        this.width = w;
        this.height = h;
        this.scrollable = _scrollable;
    }

    public void setPositionY(int i) {
        this.positionY = i;
    }

    public void onUpdate(float deltaTime) {
        if (this.scrollable) {
            int maxScrollValue;
            if (ApplicationData.isUpPressed() && this.scrollOffset < 0.0f) {
                this.scrollOffset += deltaTime * 30.0f;
            }
            if (ApplicationData.isDownPressed() && this.scrollOffset > (float)(maxScrollValue = -ApplicationData.getFontByID(this.fontID).getFontHeight() * (this.textLines.size() - this.height / ApplicationData.getFontByID(this.fontID).getFontHeight()))) {
                this.scrollOffset -= deltaTime * 30.0f;
            }
        }
    }

    public void setText(String newText, String separator) {
        this.textLines = Utils.splitText(newText, separator);
        this.textHeight = this.textLines.size() * ApplicationData.getFontByID(this.fontID).getFontHeight() - ApplicationData.getFontByID(this.fontID).getFontSpacing();
        if (this.checkIfScrollsAreNeeded()) {
            this.textLines = Utils.splitText(newText, separator, ApplicationData.screenWidth - Platform.WND_FRAME_MARGIN_LEFT - Platform.WND_FRAME_MARGIN_RIGHT);
            this.textHeight = this.textLines.size() * ApplicationData.getFontByID(this.fontID).getFontHeight();
        }
    }

    public void setText(String newText) {
        this.setText(newText, "+");
    }

    private boolean checkIfScrollsAreNeeded() {
        this.scrollable = this.textHeight > this.height;
        return this.scrollable;
    }

    public void draw() {
        int fontHeight = ApplicationData.getFontByID(this.fontID).getFontHeight();
        int yCenterAlign = 0;
        if (!this.scrollable) {
            yCenterAlign = (this.height - fontHeight * this.textLines.size()) / 2;
        }
        Graphic2D.SetClip(this.positionX + Platform.WND_MARGIN_LEFT, this.positionY + Platform.WND_MARGIN_TOP, this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT, this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM);
        if (this.hasBackground) {
            this.drawTextBoxBackground(this.width, this.height);
            Graphic2D.SetClip(this.positionX + Platform.WND_FRAME_MARGIN_LEFT, this.positionY + Platform.WND_FRAME_MARGIN_TOP, this.width - Platform.WND_MARGIN_LEFT - Platform.WND_FRAME_MARGIN_RIGHT, this.height - Platform.WND_MARGIN_TOP - Platform.WND_FRAME_MARGIN_BOTTOM);
        } else {
            Graphic2D.SetClip(this.positionX, this.positionY + Platform.WND_FRAME_MARGIN_TOP, this.width, this.height - Platform.WND_MARGIN_TOP - Platform.WND_FRAME_MARGIN_BOTTOM);
        }
        int clientAreaY = 0;
        for (int i = 0; i < this.textLines.size(); ++i) {
            int yPosition = this.positionY + clientAreaY + i * fontHeight + (int)this.scrollOffset + yCenterAlign;
            if (yPosition < 0 || yPosition > ApplicationData.screenHeight) continue;
            if (!this.scrollable) {
                Utils.drawString((String)this.textLines.elementAt(i), this.positionX + this.width / 2, yPosition, 17, this.fontID);
                continue;
            }
            Utils.drawString((String)this.textLines.elementAt(i), this.positionX + this.width / 2, yPosition, 17, this.fontID);
        }
        Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
    }

    private void drawTextBoxBackground(int w, int h) {
    }
}

