/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGJewel;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.EndOfCareerScreen;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.SelectWorldScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class StoryScoreScreen
extends MainScreen {
    protected String strLine1 = null;
    protected String strLine2 = null;
    protected String strLine3 = null;
    private UIFloatingTextBox resultspointsBox;
    private UIFloatingTextBox windowHeader;
    private UIFloatingTextBox currBestScoreBox;
    public int m_nMinimumScore;
    public int m_nCurrentScore;
    public int m_nStarsY;
    protected boolean m_bEndOfCareer = false;
    CGTexture[] m_Textures;
    private int nScore;

    public StoryScoreScreen(int Score) {
        this.nScore = Score;
        this.autoSize();
        this.m_Textures = new CGTexture[2];
        this.m_Textures[0] = TextureManager.AddTexture("/menu/star_empty.png");
        this.m_Textures[1] = TextureManager.AddTexture("/menu/star_full.png");
        this.drawTitle = false;
        int nY = ApplicationData.screenHeight / 2 - 6 * ApplicationData.getFontByID(0).getFontHeight();
        if (nY < 0) {
            nY = 0;
        }
        int nBoxHeight = 3 * ApplicationData.defaultFont.getFontHeight();
        int nBoxWidth = ApplicationData.screenWidth - 2;
        this.resultspointsBox = new UIFloatingTextBox(false, (ApplicationData.screenWidth - nBoxWidth) / 2, nY, nBoxWidth, nBoxHeight);
        this.windowHeader = new UIFloatingTextBox(false, (ApplicationData.screenWidth - nBoxWidth) / 2, nY - nBoxHeight, nBoxWidth, nBoxHeight);
        this.currBestScoreBox = new UIFloatingTextBox(false, (ApplicationData.screenWidth - nBoxWidth) / 2, nY + 2 * ApplicationData.defaultFont.getFontHeight(), nBoxWidth, nBoxHeight);
        this.m_nCurrentScore = CGLevelStats.m_nScore;
        this.m_nMinimumScore = CGEngine.m_arrStoryLevelScoreNeeded[CGEngine.m_nCurrentStoryLevel];
        if (CGLevelStats.m_nScore > CGUserCareer.m_arrLevelBestScore[CGEngine.m_nCurrentStoryLevel]) {
            CGUserCareer.m_arrLevelBestScore[CGEngine.m_nCurrentStoryLevel] = CGLevelStats.m_nScore;
        }
        this.m_nStarsY = (nY += nBoxHeight) + nBoxHeight;
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbCANCEL, ObjectsCache.menuSbCANCEL_a);
        this.UpdateInfo();
    }

    public void UpdateInfo() {
        CGTexture t4;
        CGTexture t3;
        this.strLine2 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_RESULTS_WHACKED") + ApplicationData.defaultFont.encodeDynamicString(" " + CGLevelStats.m_nScore);
        this.resultspointsBox.setText(this.strLine2);
        this.strLine3 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_SCORE_HEADER") + ApplicationData.defaultFont.encodeDynamicString(": " + CGUserCareer.m_arrLevelBestScore[CGEngine.m_nCurrentStoryLevel]);
        this.currBestScoreBox.setText(this.strLine3);
        if (this.nScore < 0) {
            this.windowHeader.setText(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_RESULT_LOST"));
        } else {
            this.windowHeader.setText(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_RESULT_WIN"));
        }
        CGEngine.m_bPause = true;
        CGEngine.m_bGameActive = false;
        CGTexture t1 = TextureManager.AddTexture("/menu/selectlevel.png");
        CGTexture t2 = TextureManager.AddTexture("/menu/selectlevel_s.png");
        CGAchievements.completeAchievement(0);
        if (this.m_nCurrentScore >= this.m_nMinimumScore) {
            if (CGUserCareer.GetAdventureLevel() < CGEngine.m_nCurrentStoryLevel + 1) {
                CGUserCareer.SetAdventureLevel(CGEngine.m_nCurrentStoryLevel + 1);
            }
            if (CGEngine.m_nCurrentStoryLevel + 1 >= 45) {
                CGAchievements.completeAchievement(6);
                this.m_bEndOfCareer = true;
            }
            t3 = TextureManager.AddTexture("/menu/play.png");
            t4 = TextureManager.AddTexture("/menu/play_s.png");
        } else {
            t3 = TextureManager.AddTexture("/menu/restart.png");
            t4 = TextureManager.AddTexture("/menu/restart_s.png");
        }
        this.setSoftButtonImage(t1, t2, t3, t4);
    }

    public void onUpdate(float deltaTime) {
        super.onUpdate(deltaTime);
    }

    public void drawWindowBackground() {
        super.drawWindowBackground();
        this.resultspointsBox.draw();
        this.windowHeader.draw();
        this.currBestScoreBox.draw();
        int nStarY = this.m_nStarsY + this.m_Textures[0].GetHeight();
        int nStarX = ApplicationData.screenWidth / 2;
        Graphic2D.DrawImage(this.m_Textures[0], nStarX - 5 * this.m_Textures[0].GetWidth() / 4, nStarY, 3);
        Graphic2D.DrawImage(this.m_Textures[0], nStarX, nStarY, 3);
        Graphic2D.DrawImage(this.m_Textures[0], nStarX + 5 * this.m_Textures[0].GetWidth() / 4, nStarY, 3);
        if (this.m_nCurrentScore >= this.m_nMinimumScore) {
            Graphic2D.DrawImage(this.m_Textures[1], nStarX - 5 * this.m_Textures[0].GetWidth() / 4, nStarY, 3);
        }
        if (this.m_nCurrentScore >= this.m_nMinimumScore + this.m_nMinimumScore / 2) {
            Graphic2D.DrawImage(this.m_Textures[1], nStarX, nStarY, 3);
        }
        if (this.m_nCurrentScore >= 2 * this.m_nMinimumScore) {
            Graphic2D.DrawImage(this.m_Textures[1], nStarX + 5 * this.m_Textures[0].GetWidth() / 4, nStarY, 3);
            CGAchievements.completeAchievement(5);
        }
    }

    public boolean leftSoftButton() {
        CGSoundSystem.Play(2, false);
        ApplicationData.setMainMenuMode();
        CGEngine.m_bPause = false;
        CGEngine.m_bGameActive = false;
        UIScreen.SetCurrentScreen(null);
        ApplicationData.SetMusic();
        ApplicationData.goToMainMenu();
        this.readyForClose = true;
        return true;
    }

    public boolean rightSoftButton() {
        CGSoundSystem.Play(2, false);
        CGLevelStats.m_nScore = 0;
        if (this.m_bEndOfCareer) {
            CGSoundSystem.Play(2, false);
            UIScreen.SetNextScreen(new EndOfCareerScreen());
            UIScreen.GetNextScreen().setParent(this);
            this.readyForClose = true;
        } else {
            if (this.m_nCurrentScore >= this.m_nMinimumScore) {
                ++CGEngine.m_nCurrentStoryLevel;
            }
            if (CGEngine.m_nCurrentStoryLevel == 15 || CGEngine.m_nCurrentStoryLevel == 30) {
                UIScreen.SetNextScreen(new SelectWorldScreen(CGEngine.m_nCurrentStoryLevel / 15));
                UIScreen.GetNextScreen().setParent(this);
                this.readyForClose = true;
            } else {
                CGJewel.NUM_JEWEL_COLORS = CGEngine.m_arrNumberOfJewelPerLvl[CGEngine.m_nCurrentStoryLevel];
                CGBoard.m_nNrofTypes = CGEngine.m_arrNumberOfJewelPerLvl[CGEngine.m_nCurrentStoryLevel];
                String fileName = "/level_" + CGEngine.m_nCurrentWorld + ".lrs";
                ApplicationData.getGame().startLoading(fileName);
                ApplicationData.getGame().stepLoading(fileName);
                ApplicationData.getGame().stepLoading(fileName);
                ApplicationData.getGame().stepLoading(fileName);
                ApplicationData.getGame().stepLoading(fileName);
                ApplicationData.getGame().endLoading(fileName);
                ApplicationData.generalGameMode = 4;
                CGEngine.m_bGameActive = true;
                this.readyForClose = true;
            }
        }
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }
}

