/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.RandSync;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGHit;
import baltorogames.project_gameplay.CGJewel;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.DestroyLineData;
import java.util.Vector;

public class CGBoard {
    public static int COMBO_TURN_MAX_INTERVAL = 3000;
    public static float SCORE_TO_LIFETIME_MULTIPLIER = 0.01f;
    public static float m_fSize = 80.0f;
    public static float m_fStartX;
    public static float m_fStartY;
    public static int m_nNrofTypes;
    public static final int MAX_NUM_COLORS = 7;
    public static int m_nStartSelectX;
    public static int m_nStartSelectY;
    public static int m_nEndSelectX;
    public static int m_nEndSelectY;
    static CGTexture m_SelectTexture;
    static CGTexture[] m_arrSelectTexture;
    private static int m_nNewJewelIndex;
    private static int m_nSpecialJewelIndex;
    private static int m_nSpecialJewelType;
    public static CGTexture m_buttonSelectLevel;
    public static float m_fCurrentRotateAngle;
    public static float m_fCurrentRotateCenterX;
    public static float m_fCurrentRotateCenterY;
    int jewelsDestroyed = 0;
    public Vector m_arrJewels = null;
    public CGJewel[][] m_Board = null;
    static CGTexture m_MarkerTexture;
    public static int currentComboLevel;
    public static boolean comboLevelHasChanged;
    public static int currentChainLevel;
    public static long timeFromLastDestroyMs;
    public static boolean nothingDestroyedInLastTurn;
    public static int BOARD_MAX_WIDTH;
    public static int BOARD_MAX_HEIGHT;
    private boolean m_bIsFour = false;
    private boolean m_bIsFive = false;
    private boolean m_bIsCrossShape = false;
    private boolean m_bIsLShape = false;
    private boolean m_bIsTShape = false;
    private static int[] arrTmp;

    public static void Initialize() {
        m_SelectTexture = TextureManager.CreateFilteredTexture("/gameplay/select.png");
        m_arrSelectTexture = new CGTexture[9];
        for (int i = 0; i < m_arrSelectTexture.length; ++i) {
            CGBoard.m_arrSelectTexture[i] = TextureManager.CreateFilteredTexture("/gameplay/select_" + (i + 1) + ".png");
        }
        m_MarkerTexture = TextureManager.CreateFilteredTexture("/gameplay/marker.png");
        m_fStartX = 240.0f - 2.5f * m_fSize;
        m_fStartY = 180.0f;
    }

    public void Init() {
        if (this.m_Board == null) {
            this.m_Board = new CGJewel[BOARD_MAX_WIDTH][BOARD_MAX_HEIGHT];
        }
        for (int x = 0; x < BOARD_MAX_WIDTH; ++x) {
            for (int y = 0; y < BOARD_MAX_HEIGHT; ++y) {
                this.m_Board[x][y] = null;
            }
        }
        this.m_arrJewels = new Vector();
        for (int y = 0; y < BOARD_MAX_HEIGHT; ++y) {
            for (int x = 0; x < BOARD_MAX_WIDTH; ++x) {
                this.NewJewelForPos(x, y);
            }
        }
        m_fCurrentRotateAngle = 0.0f;
    }

    public void NewJewelForPos(int x, int y) {
        float fX = (float)x * m_fSize + m_fSize / 2.0f;
        float fY = (float)y * m_fSize + m_fSize / 2.0f;
        CGJewel j = new CGJewel();
        float fTY = 6.0f;
        if (y == 3) {
            fTY = 6.5f;
        } else if (y == 2) {
            fTY = 7.0f;
        } else if (y == 1) {
            fTY = 7.5f;
        } else if (y == 0) {
            fTY = 8.0f;
        }
        int nT = RandSync.nextInt(m_nNrofTypes);
        if (x == 0 && y == 0) {
            nT = 0;
        }
        if (CGBoard.getM_nSpecialJewelIndex() >= 0 && CGBoard.getM_nSpecialJewelType() > 0 && m_nNewJewelIndex == CGBoard.getM_nSpecialJewelIndex()) {
            nT = CGBoard.getM_nSpecialJewelType();
        }
        j.Init(nT, fX, fY - fTY * m_fSize);
        j.SetTargetY(fY);
        this.ChangeJewelType(j);
        this.m_arrJewels.addElement(j);
        ++m_nNewJewelIndex;
    }

    public void Step(int nDeltaTimeInMs) {
        int x;
        if (m_fCurrentRotateAngle > 0.0f) {
            if (m_fCurrentRotateAngle < 180.0f) {
                if ((m_fCurrentRotateAngle += 480.0f * (float)nDeltaTimeInMs / 1000.0f) >= 180.0f) {
                    m_fCurrentRotateAngle = 180.0f;
                }
            } else {
                this.EndOfRotate();
                ++CGLevelStats.m_nTotalMoves;
                m_fCurrentRotateAngle = 0.0f;
            }
        }
        int nS = this.m_arrJewels.size();
        for (int i = 0; i < nS; ++i) {
            CGJewel j = (CGJewel)this.m_arrJewels.elementAt(i);
            j.Step(nDeltaTimeInMs);
        }
        if (this.IsReady()) {
            DestroyLineData.Clear();
            this.CheckDestroy(nDeltaTimeInMs);
            if (!this.m_bIsFour) {
                this.m_bIsFour = DestroyLineData.IsFour();
            }
            if (!this.m_bIsFive) {
                this.m_bIsFive = DestroyLineData.IsFive();
            }
            if (!this.m_bIsCrossShape) {
                this.m_bIsCrossShape = DestroyLineData.IsCrossShape();
            }
            if (!this.m_bIsLShape) {
                this.m_bIsLShape = DestroyLineData.IsLShape();
            }
            if (!this.m_bIsTShape) {
                this.m_bIsTShape = DestroyLineData.IsTShape();
            }
        }
        if (!this.IsTurnFinished()) {
            timeFromLastDestroyMs = 0L;
        } else {
            nothingDestroyedInLastTurn = true;
            currentChainLevel = 0;
            if ((timeFromLastDestroyMs += (long)nDeltaTimeInMs) > (long)COMBO_TURN_MAX_INTERVAL) {
                currentComboLevel = 1;
            }
        }
        for (x = 0; x < BOARD_MAX_WIDTH; ++x) {
            this.CheckColumn(x);
        }
        if (this.IsReady()) {
            if ((this.m_bIsFour || this.m_bIsFive || this.m_bIsCrossShape || this.m_bIsLShape || this.m_bIsTShape) && CGEngine.m_nGameMode == 1) {
                int x2;
                int nC = 0;
                for (x2 = 0; x2 < BOARD_MAX_WIDTH; ++x2) {
                    nC += this.CountCheckColumnForNew(x2);
                }
                if (nC > 0) {
                    CGBoard.setM_nSpecialJewelIndex(RandSync.nextInt(nC));
                    CGBoard.setM_nSpecialJewelType(7 + RandSync.nextInt(5));
                    if (this.m_bIsFive) {
                        CGBoard.setM_nSpecialJewelType(CGJewel.eSpecial_Destroyer);
                    } else if (this.m_bIsFour) {
                        CGBoard.setM_nSpecialJewelType(CGJewel.eSpecial_Bomb);
                    } else if (this.m_bIsCrossShape) {
                        CGBoard.setM_nSpecialJewelType(CGJewel.eSpecial_Star);
                    } else if (this.m_bIsLShape) {
                        CGBoard.setM_nSpecialJewelType(CGJewel.eSpecial_Color);
                    } else if (this.m_bIsTShape) {
                        CGBoard.setM_nSpecialJewelType(CGJewel.eSpecial_Random);
                    }
                    m_nNewJewelIndex = 0;
                    for (x2 = 0; x2 < BOARD_MAX_WIDTH; ++x2) {
                        this.CheckColumnForNew(x2);
                    }
                    this.m_bIsFour = false;
                    this.m_bIsFive = false;
                    this.m_bIsCrossShape = false;
                    this.m_bIsLShape = false;
                    this.m_bIsTShape = false;
                }
            } else {
                CGBoard.setM_nSpecialJewelIndex(-1);
                CGBoard.setM_nSpecialJewelType(-1);
                m_nNewJewelIndex = 0;
                for (x = 0; x < BOARD_MAX_WIDTH; ++x) {
                    this.CheckColumnForNew(x);
                }
            }
        }
        this.CheckSelect();
    }

    public void ChangeJewelType(CGJewel jewel) {
        int x1 = jewel.GetBoardX();
        int y1 = jewel.GetBoardY();
        if (x1 - 1 > 0 && x1 - 1 < 4 && this.m_Board[x1 - 1][y1] != null && this.m_Board[x1 - 1][y1].m_nType == jewel.m_nType) {
            while (this.m_Board[x1 - 1][y1].m_nType == jewel.m_nType) {
                jewel.m_nType = RandSync.nextInt(CGJewel.NUM_JEWEL_COLORS);
            }
        }
        if (y1 - 1 > 0 && y1 - 1 < 4 && this.m_Board[x1][y1 - 1] != null && this.m_Board[x1][y1 - 1].m_nType == jewel.m_nType) {
            while (this.m_Board[x1][y1 - 1].m_nType == jewel.m_nType) {
                jewel.m_nType = RandSync.nextInt(CGJewel.NUM_JEWEL_COLORS);
            }
        }
        if (x1 + 1 > 0 && x1 + 1 < 4 && this.m_Board[x1 + 1][y1] != null && this.m_Board[x1 + 1][y1].m_nType == jewel.m_nType) {
            while (this.m_Board[x1 + 1][y1].m_nType == jewel.m_nType) {
                jewel.m_nType = RandSync.nextInt(CGJewel.NUM_JEWEL_COLORS);
            }
        }
        if (y1 + 1 > 0 && y1 + 1 < 4 && this.m_Board[x1][y1 + 1] != null && this.m_Board[x1][y1 + 1].m_nType == jewel.m_nType) {
            while (this.m_Board[x1][y1 + 1].m_nType == jewel.m_nType) {
                jewel.m_nType = RandSync.nextInt(CGJewel.NUM_JEWEL_COLORS);
            }
        }
    }

    public float GetMiddleX(int x, int y) {
        return ((float)x + 0.5f) * m_fSize;
    }

    public float GetMiddleY(int x, int y) {
        return ((float)y + 0.5f) * m_fSize;
    }

    public int GetTypeAt(int x, int y) {
        if (x < 0 || x > 4 || y < 0 || y > 4) {
            return -3;
        }
        if (this.m_Board[x][y] == null) {
            return -2;
        }
        if (!this.m_Board[x][y].IsInBoard()) {
            return -1;
        }
        return this.m_Board[x][y].m_nType;
    }

    private void NotifyJewelDestroyed(int x, int y) {
        int scoreToAdd = CGEngine.POINTS_FOR_JEWEL_DESTROYED_ARCADE * currentComboLevel;
        if (CGEngine.m_nGameMode == 1 && CGEngine.m_nMovesLeft < 0) {
            scoreToAdd = 0;
        }
        if (CGLevelStats.m_nTotalMoves >= 0) {
            CGLevelStats.AddScore(scoreToAdd);
        }
        if (timeFromLastDestroyMs <= (long)COMBO_TURN_MAX_INTERVAL && nothingDestroyedInLastTurn) {
            ++currentComboLevel;
            timeFromLastDestroyMs = 0L;
            comboLevelHasChanged = true;
        }
        if (CGEngine.m_nGameMode == 2 && (CGEngine.m_fLifeLine += (float)CGEngine.POINTS_FOR_JEWEL_DESTROYED_ARCADE * SCORE_TO_LIFETIME_MULTIPLIER) > 1.0f) {
            CGEngine.m_fLifeLine = 1.0f;
        }
        nothingDestroyedInLastTurn = false;
    }

    void DestroyBomb(int x, int y) {
        for (int xx = x - 1; xx <= x + 1; ++xx) {
            for (int yy = y - 1; yy <= y + 1; ++yy) {
                if (xx < 0 || yy < 0 || xx >= BOARD_MAX_WIDTH || yy >= BOARD_MAX_HEIGHT || this.m_Board[xx][yy] == null) continue;
                this.m_Board[xx][yy].m_bToDestroy = true;
            }
        }
    }

    void DestroyDestroyer(int x, int y) {
        for (int xx = 0; xx < BOARD_MAX_WIDTH; ++xx) {
            if (this.m_Board[xx][y] == null) continue;
            this.m_Board[xx][y].m_bToDestroy = true;
        }
        for (int yy = 0; yy < BOARD_MAX_HEIGHT; ++yy) {
            if (this.m_Board[x][yy] == null) continue;
            this.m_Board[x][yy].m_bToDestroy = true;
        }
    }

    void DestroyStar(int x, int y) {
        for (int i = 1; i < 6; ++i) {
            if (x - i >= 0 && y - i >= 0 && this.m_Board[x - i][y - i] != null) {
                this.m_Board[x - i][y - i].m_bToDestroy = true;
            }
            if (x - i >= 0 && y + i < BOARD_MAX_HEIGHT && this.m_Board[x - i][y + i] != null) {
                this.m_Board[x - i][y + i].m_bToDestroy = true;
            }
            if (x + i < BOARD_MAX_WIDTH && y - i >= 0 && this.m_Board[x + i][y - i] != null) {
                this.m_Board[x + i][y - i].m_bToDestroy = true;
            }
            if (x + i >= BOARD_MAX_WIDTH || y + i >= BOARD_MAX_HEIGHT || this.m_Board[x + i][y + i] == null) continue;
            this.m_Board[x + i][y + i].m_bToDestroy = true;
        }
    }

    void DestroyColor(int color) {
        for (int xx = 0; xx < BOARD_MAX_WIDTH; ++xx) {
            for (int yy = 0; yy < BOARD_MAX_HEIGHT; ++yy) {
                if (this.m_Board[xx][yy] == null || this.m_Board[xx][yy].m_nType != color) continue;
                this.m_Board[xx][yy].m_bToDestroy = true;
            }
        }
    }

    void DestroyRandom() {
        for (int i = 0; i < 7; ++i) {
            int nCount = 0;
            for (int xx = 0; xx < BOARD_MAX_WIDTH; ++xx) {
                for (int yy = 0; yy < BOARD_MAX_HEIGHT; ++yy) {
                    if (this.m_Board[xx][yy] == null || this.m_Board[xx][yy].m_bToDestroy) continue;
                    CGBoard.arrTmp[nCount] = yy * BOARD_MAX_WIDTH + xx;
                    ++nCount;
                }
            }
            if (nCount <= 0) break;
            int nR = RandSync.nextInt(nCount);
            int xxx = arrTmp[nR] % BOARD_MAX_WIDTH;
            int yyy = arrTmp[nR] / BOARD_MAX_WIDTH;
            this.m_Board[xxx][yyy].m_bToDestroy = true;
        }
    }

    void CheckDestroyH(int x, int y) {
        int nBomb_X = -1;
        int nBomb_Y = -1;
        int nDestroyer_X = -1;
        int nDestroyer_Y = -1;
        int nStar_X = -1;
        int nStar_Y = -1;
        int nColor_C = -1;
        int nRandom = -1;
        int nC = 0;
        int nType = this.GetTypeAt(x, y);
        if (nType >= m_nNrofTypes && (nType = this.GetTypeAt(x + 1, y)) >= m_nNrofTypes) {
            nType = this.GetTypeAt(x + 2, y);
        }
        if (nType >= 0) {
            int i;
            for (i = 1; i < 10 && (this.GetTypeAt(x + i, y) == nType || this.GetTypeAt(x + i, y) >= m_nNrofTypes); ++i) {
                ++nC;
            }
            if (nC >= 2) {
                if (nC >= 4) {
                    this.m_bIsFive = true;
                } else if (nC >= 3) {
                    this.m_bIsFour = true;
                }
                DestroyLineData.Add(1, y, x, x + nC);
                for (i = 0; i <= nC; ++i) {
                    this.m_Board[x + i][y].m_bToDestroy = true;
                    if (this.m_Board[x + i][y].m_nType == CGJewel.eSpecial_Bomb) {
                        nBomb_X = x + i;
                        nBomb_Y = y;
                        continue;
                    }
                    if (this.m_Board[x + i][y].m_nType == CGJewel.eSpecial_Destroyer) {
                        nDestroyer_X = x + i;
                        nDestroyer_Y = y;
                        continue;
                    }
                    if (this.m_Board[x + i][y].m_nType == CGJewel.eSpecial_Star) {
                        nStar_X = x + i;
                        nStar_Y = y;
                        continue;
                    }
                    if (this.m_Board[x + i][y].m_nType == CGJewel.eSpecial_Color) {
                        if (x + i < BOARD_MAX_WIDTH - 1 && this.m_Board[x + i + 1][y] != null) {
                            nColor_C = this.m_Board[x + i + 1][y].m_nType;
                            continue;
                        }
                        if (x + i - 1 < 0 || this.m_Board[x + i - 1][y] == null) continue;
                        nColor_C = this.m_Board[x + i - 1][y].m_nType;
                        continue;
                    }
                    if (this.m_Board[x + i][y].m_nType != CGJewel.eSpecial_Random) continue;
                    nRandom = 7;
                }
                this.NotifyLineDestroyed(x, y, nC, nType, true);
            }
        }
        if (nBomb_X >= 0 && nBomb_Y >= 0) {
            this.DestroyBomb(nBomb_X, nBomb_Y);
        }
        if (nDestroyer_X >= 0 && nDestroyer_Y >= 0) {
            this.DestroyDestroyer(nDestroyer_X, nDestroyer_Y);
        }
        if (nStar_X >= 0 && nStar_Y >= 0) {
            this.DestroyStar(nStar_X, nStar_Y);
        }
        if (nColor_C >= 0) {
            this.DestroyColor(nColor_C);
        }
        if (nRandom >= 0) {
            this.DestroyRandom();
        }
    }

    void CheckDestroyV(int x, int y) {
        int nBomb_X = -1;
        int nBomb_Y = -1;
        int nDestroyer_X = -1;
        int nDestroyer_Y = -1;
        int nStar_X = -1;
        int nStar_Y = -1;
        int nColor_C = -1;
        int nRandom = -1;
        int nC = 0;
        int nType = this.GetTypeAt(x, y);
        if (nType >= m_nNrofTypes && (nType = this.GetTypeAt(x, y + 1)) >= m_nNrofTypes) {
            nType = this.GetTypeAt(x, y + 2);
        }
        if (nType >= 0) {
            int i;
            for (i = 1; i < 10 && (this.GetTypeAt(x, y + i) == nType || this.GetTypeAt(x, y + i) >= m_nNrofTypes); ++i) {
                ++nC;
            }
            if (nC >= 2) {
                if (nC >= 4) {
                    this.m_bIsFive = true;
                } else if (nC >= 3) {
                    this.m_bIsFour = true;
                }
                DestroyLineData.Add(0, x, y, y + nC);
                for (i = 0; i <= nC; ++i) {
                    this.m_Board[x][y + i].m_bToDestroy = true;
                    if (this.m_Board[x][y + i].m_nType == CGJewel.eSpecial_Bomb) {
                        nBomb_X = x;
                        nBomb_Y = y + i;
                        continue;
                    }
                    if (this.m_Board[x][y + i].m_nType == CGJewel.eSpecial_Destroyer) {
                        nDestroyer_X = x;
                        nDestroyer_Y = y + i;
                        continue;
                    }
                    if (this.m_Board[x][y + i].m_nType == CGJewel.eSpecial_Star) {
                        nStar_X = x;
                        nStar_Y = y + i;
                        continue;
                    }
                    if (this.m_Board[x][y + i].m_nType == CGJewel.eSpecial_Color) {
                        if (y + i < BOARD_MAX_HEIGHT - 1 && this.m_Board[x][y + i + 1] != null) {
                            nColor_C = this.m_Board[x][y + i + 1].m_nType;
                            continue;
                        }
                        if (y + i - 1 < 0 || this.m_Board[x][y + i - 1] == null) continue;
                        nColor_C = this.m_Board[x][y + i - 1].m_nType;
                        continue;
                    }
                    if (this.m_Board[x][y + i].m_nType != CGJewel.eSpecial_Random) continue;
                    nRandom = 7;
                }
                this.NotifyLineDestroyed(x, y, nC, nType, false);
            }
        }
        if (nBomb_X >= 0 && nBomb_Y >= 0) {
            this.DestroyBomb(nBomb_X, nBomb_Y);
        }
        if (nDestroyer_X >= 0 && nDestroyer_Y >= 0) {
            this.DestroyDestroyer(nDestroyer_X, nDestroyer_Y);
        }
        if (nStar_X >= 0 && nStar_Y >= 0) {
            this.DestroyStar(nStar_X, nStar_Y);
        }
        if (nColor_C >= 0) {
            this.DestroyColor(nColor_C);
        }
        if (nRandom >= 0) {
            this.DestroyRandom();
        }
    }

    public void NotifyLineDestroyed(int x, int y, int length, int color, boolean isVertical) {
        ++currentChainLevel;
    }

    public boolean IsReady() {
        if (m_fCurrentRotateAngle > 0.0f) {
            return false;
        }
        for (int y = 0; y < BOARD_MAX_HEIGHT; ++y) {
            for (int x = 0; x < BOARD_MAX_WIDTH; ++x) {
                if (this.m_Board[x][y] == null || this.m_Board[x][y].IsInBoard()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean IsTurnFinished() {
        if (!this.IsReady()) {
            return false;
        }
        for (int x = 0; x < BOARD_MAX_WIDTH; ++x) {
            for (int y = 0; y < BOARD_MAX_HEIGHT; ++y) {
                if (this.m_Board[x][y] != null) continue;
                return false;
            }
        }
        return true;
    }

    public void CheckDestroy(long nDeltaTimeInMs) {
        int x;
        int y;
        for (y = 0; y < BOARD_MAX_HEIGHT; ++y) {
            for (x = 0; x < BOARD_MAX_WIDTH; ++x) {
                if (this.m_Board[x][y] == null) continue;
                this.m_Board[x][y].m_bToDestroy = false;
            }
        }
        for (y = 0; y < BOARD_MAX_HEIGHT; ++y) {
            for (x = 0; x < BOARD_MAX_WIDTH; ++x) {
                this.CheckDestroyH(x, y);
                this.CheckDestroyV(x, y);
            }
        }
        this.jewelsDestroyed = 0;
        float xCombo = 0.0f;
        float yCombo = 0.0f;
        for (int y2 = 0; y2 < BOARD_MAX_HEIGHT; ++y2) {
            for (int x2 = 0; x2 < BOARD_MAX_WIDTH; ++x2) {
                if (this.m_Board[x2][y2] == null || !this.m_Board[x2][y2].m_bToDestroy) continue;
                CGHit.NewHit(0, this.GetMiddleX(x2, y2) + 42.0f, this.GetMiddleY(x2, y2) + m_fStartY, 300L);
                xCombo += this.GetMiddleX(x2, y2) + m_fStartX;
                yCombo += this.GetMiddleX(x2, y2) + m_fStartY;
                this.DeleteFromJewels(this.m_Board[x2][y2]);
                this.m_Board[x2][y2] = null;
                this.NotifyJewelDestroyed(x2, y2);
                ++this.jewelsDestroyed;
            }
        }
        if (this.jewelsDestroyed >= 5) {
            CGAchievements.completeAchievement(13);
        }
        if (currentComboLevel > 2 && this.jewelsDestroyed > 0) {
            CGDynamicObj.AddToCurrentDynamics("combo.do", xCombo /= (float)this.jewelsDestroyed, yCombo /= (float)this.jewelsDestroyed, 0.0f);
            CGAchievements.completeAchievement(2);
        } else if (currentComboLevel > 5 && this.jewelsDestroyed > 0) {
            CGAchievements.completeAchievement(3);
        } else if (currentComboLevel > 10 && this.jewelsDestroyed > 0) {
            CGAchievements.completeAchievement(4);
        }
        if (currentChainLevel > 5) {
            CGAchievements.completeAchievement(14);
        }
        if (comboLevelHasChanged) {
            switch (currentComboLevel) {
                case 3: {
                    CGHit.NewHit(1, this.GetMiddleX(2, 0), m_fStartY * 3.0f / 2.0f + this.GetMiddleY(2, 4), 800L);
                    comboLevelHasChanged = false;
                    break;
                }
                case 4: {
                    CGHit.NewHit(2, this.GetMiddleX(2, 0), m_fStartY * 3.0f / 2.0f + this.GetMiddleY(2, 4), 800L);
                    comboLevelHasChanged = false;
                    break;
                }
                case 5: {
                    CGHit.NewHit(3, this.GetMiddleX(2, 0), m_fStartY * 3.0f / 2.0f + this.GetMiddleY(2, 4), 800L);
                    comboLevelHasChanged = false;
                    break;
                }
                case 6: {
                    CGHit.NewHit(4, this.GetMiddleX(2, 0), m_fStartY * 3.0f / 2.0f + this.GetMiddleY(2, 4), 800L);
                    comboLevelHasChanged = false;
                    break;
                }
            }
        }
        System.out.println(currentComboLevel);
    }

    public void CheckColumn(int x) {
        for (int y = BOARD_MAX_HEIGHT - 2; y >= 0; --y) {
            if (this.m_Board[x][y] == null || this.m_Board[x][y].m_nType >= 100 || !this.m_Board[x][y].IsInBoard() || this.m_Board[x][y + 1] != null) continue;
            int nTY = y + 1;
            boolean bOK = false;
            for (int j = y + 1; j < BOARD_MAX_HEIGHT; ++j) {
                if (this.m_Board[x][j] == null) continue;
                nTY = j - 1;
                bOK = true;
                break;
            }
            if (!bOK) {
                nTY = BOARD_MAX_HEIGHT - 1;
            }
            CGJewel jwl = this.m_Board[x][y];
            this.m_Board[x][y] = null;
            jwl.SetTargetY((float)nTY * m_fSize + m_fSize / 2.0f);
        }
    }

    public void CheckColumnForNew(int x) {
        for (int y = 0; y < BOARD_MAX_HEIGHT && this.m_Board[x][y] == null; ++y) {
            this.NewJewelForPos(x, y);
        }
    }

    public int CountCheckColumnForNew(int x) {
        int nC = 0;
        for (int y = 0; y < BOARD_MAX_HEIGHT && this.m_Board[x][y] == null; ++y) {
            ++nC;
        }
        return nC;
    }

    public void DeleteFromJewels(CGJewel jtd) {
        int nS = this.m_arrJewels.size();
        for (int i = 0; i < nS; ++i) {
            CGJewel j = (CGJewel)this.m_arrJewels.elementAt(i);
            if (j != jtd) continue;
            this.m_arrJewels.removeElementAt(i);
            return;
        }
    }

    public void EndOfRotate() {
        for (int y = 0; y < BOARD_MAX_HEIGHT; ++y) {
            for (int x = 0; x < BOARD_MAX_WIDTH; ++x) {
                if (this.m_Board[x][y] == null) continue;
                this.m_Board[x][y].m_fRadiusX = -1000.0f;
                this.m_Board[x][y].m_fRadiusY = -1000.0f;
            }
        }
        if (--CGEngine.m_nMovesLeft < 0) {
            CGEngine.m_nMovesLeft = 0;
        }
    }

    public void Render() {
        int i;
        for (int y = 0; y < BOARD_MAX_HEIGHT; ++y) {
            for (int x = 0; x < BOARD_MAX_WIDTH; ++x) {
                float fX = this.GetMiddleX(x, y);
                float fY = this.GetMiddleY(x, y);
            }
        }
        int nS = this.m_arrJewels.size();
        for (i = 0; i < nS; ++i) {
            CGJewel j = (CGJewel)this.m_arrJewels.elementAt(i);
            if (j.m_fRadiusX != -1000.0f || j.m_fRadiusY != -1000.0f) continue;
            j.Render();
        }
        for (i = 0; i < nS; ++i) {
            CGJewel j = (CGJewel)this.m_arrJewels.elementAt(i);
            if (j.m_fRadiusX == -1000.0f && j.m_fRadiusY == -1000.0f) continue;
            j.Render();
        }
        if (this.IsGoodSelect() && m_nStartSelectX >= 0 && m_nStartSelectY >= 0 && m_nEndSelectX >= 0 && m_nEndSelectY >= 0) {
            if (m_nStartSelectX == m_nEndSelectX) {
                float fX = this.GetMiddleX(m_nStartSelectX, m_nStartSelectY);
                float fY = this.GetMiddleY(m_nStartSelectX, m_nStartSelectY);
                CGEngineRenderer.RenderSelectJewel(fX, fY, Math.abs(m_nStartSelectY - m_nEndSelectY), false);
            } else {
                float fX1 = this.GetMiddleX(m_nStartSelectX, m_nStartSelectY);
                float fY1 = this.GetMiddleY(m_nStartSelectX, m_nStartSelectY);
                CGEngineRenderer.RenderSelectJewel(fX1, fY1, Math.abs(m_nEndSelectX - m_nStartSelectX), true);
            }
        }
    }

    public void CheckSelect() {
        m_nStartSelectX = -10;
        m_nStartSelectY = -10;
        m_nEndSelectX = -10;
        m_nEndSelectY = -10;
        if (CGEngine.m_StartSelectPointX > 0.0f && CGEngine.m_StartSelectPointY > 0.0f) {
            int nSBX = (int)CGEngine.m_StartSelectPointX / (int)m_fSize;
            int nSBY = (int)CGEngine.m_StartSelectPointY / (int)m_fSize;
            int nEBX = (int)CGEngine.m_CurrentSelectPointX / (int)m_fSize;
            int nEBY = (int)CGEngine.m_CurrentSelectPointY / (int)m_fSize;
            if (Math.abs(nEBX - nSBX) < Math.abs(nEBY - nSBY)) {
                nEBX = nSBX;
                if (nSBY > nEBY) {
                    int yy = nSBY;
                    nSBY = nEBY;
                    nEBY = yy;
                }
                m_nStartSelectX = nSBX;
                m_nStartSelectY = nSBY;
                if (m_nStartSelectY < 0) {
                    m_nStartSelectY = 0;
                }
                m_nEndSelectX = nSBX;
                m_nEndSelectY = nEBY;
                if (m_nEndSelectY > 4) {
                    m_nEndSelectY = 4;
                }
            } else {
                nEBY = nSBY;
                if (nSBX > nEBX) {
                    int xx = nSBX;
                    nSBX = nEBX;
                    nEBX = xx;
                }
                if ((m_nStartSelectX = nSBX) < 0) {
                    m_nStartSelectX = 0;
                }
                m_nStartSelectY = nSBY;
                m_nEndSelectX = nEBX;
                if (m_nEndSelectX > 4) {
                    m_nEndSelectX = 4;
                }
                m_nEndSelectY = nEBY;
            }
        }
    }

    public boolean IsGoodSelect() {
        if (m_nStartSelectX >= 0 && m_nStartSelectY >= 0 && m_nEndSelectX >= 0 && m_nEndSelectY >= 0) {
            if (m_nStartSelectX == m_nEndSelectX) {
                for (int y = m_nStartSelectY; y <= m_nEndSelectY; ++y) {
                    if (this.m_Board[m_nStartSelectX][y] != null && this.m_Board[CGBoard.m_nStartSelectX][y].m_nType != CGJewel.eType_Unvisible) continue;
                    return false;
                }
            } else {
                for (int x = m_nStartSelectX; x <= m_nEndSelectX; ++x) {
                    if (this.m_Board[x][m_nStartSelectY] != null && this.m_Board[x][CGBoard.m_nStartSelectY].m_nType != CGJewel.eType_Unvisible) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void ChangePos() {
        block3: {
            block4: {
                if (!this.IsGoodSelect()) {
                    return;
                }
                if (m_nStartSelectX < 0 || m_nStartSelectY < 0 || m_nEndSelectX < 0 || m_nEndSelectY < 0) break block3;
                if (m_nStartSelectX != m_nEndSelectX || m_nEndSelectY - m_nStartSelectY < 2) break block4;
                m_fCurrentRotateCenterX = ((float)m_nStartSelectX + 0.5f) * m_fSize;
                m_fCurrentRotateCenterY = (((float)m_nStartSelectY + 0.5f) * m_fSize + ((float)m_nEndSelectY + 0.5f) * m_fSize) / 2.0f;
                m_fCurrentRotateAngle = 1.0f;
                int nSize = m_nEndSelectY - m_nStartSelectY + 1;
                for (int y = 0; y < nSize / 2; ++y) {
                    CGJewel j1 = this.m_Board[m_nStartSelectX][m_nStartSelectY + y];
                    CGJewel j2 = this.m_Board[m_nStartSelectX][m_nStartSelectY + nSize - y - 1];
                    j1.m_fRadiusY = (float)(m_nStartSelectY + y) * m_fSize + m_fSize / 2.0f - m_fCurrentRotateCenterY;
                    j2.m_fRadiusY = (float)(m_nStartSelectY + nSize - y - 1) * m_fSize + m_fSize / 2.0f - m_fCurrentRotateCenterY;
                    this.m_Board[CGBoard.m_nStartSelectX][CGBoard.m_nStartSelectY + y] = j2;
                    j2.m_fX = (float)m_nStartSelectX * m_fSize + m_fSize / 2.0f;
                    j2.m_fTargetY = j2.m_fY = (float)(m_nStartSelectY + y) * m_fSize + m_fSize / 2.0f;
                    this.m_Board[CGBoard.m_nStartSelectX][CGBoard.m_nStartSelectY + nSize - y - 1] = j1;
                    j1.m_fX = (float)m_nStartSelectX * m_fSize + m_fSize / 2.0f;
                    j1.m_fTargetY = j1.m_fY = (float)(m_nStartSelectY + nSize - y - 1) * m_fSize + m_fSize / 2.0f;
                }
                break block3;
            }
            if (m_nStartSelectY != m_nEndSelectY || m_nEndSelectX - m_nStartSelectX < 2) break block3;
            m_fCurrentRotateCenterX = (((float)m_nStartSelectX + 0.5f) * m_fSize + ((float)m_nEndSelectX + 0.5f) * m_fSize) / 2.0f;
            m_fCurrentRotateCenterY = ((float)m_nStartSelectY + 0.5f) * m_fSize;
            m_fCurrentRotateAngle = 1.0f;
            int nSize = m_nEndSelectX - m_nStartSelectX + 1;
            for (int x = 0; x < nSize / 2; ++x) {
                CGJewel j1 = this.m_Board[m_nStartSelectX + x][m_nStartSelectY];
                CGJewel j2 = this.m_Board[m_nStartSelectX + nSize - x - 1][m_nStartSelectY];
                j1.m_fRadiusX = (float)(m_nStartSelectX + x) * m_fSize + m_fSize / 2.0f - m_fCurrentRotateCenterX;
                j2.m_fRadiusX = (float)(m_nStartSelectX + nSize - x - 1) * m_fSize + m_fSize / 2.0f - m_fCurrentRotateCenterX;
                this.m_Board[CGBoard.m_nStartSelectX + x][CGBoard.m_nStartSelectY] = j2;
                j2.m_fX = (float)(m_nStartSelectX + x) * m_fSize + m_fSize / 2.0f;
                j2.m_fTargetY = j2.m_fY = (float)m_nStartSelectY * m_fSize + m_fSize / 2.0f;
                this.m_Board[CGBoard.m_nStartSelectX + nSize - x - 1][CGBoard.m_nStartSelectY] = j1;
                j1.m_fX = (float)(m_nStartSelectX + nSize - x - 1) * m_fSize + m_fSize / 2.0f;
                j1.m_fTargetY = j1.m_fY = (float)m_nStartSelectY * m_fSize + m_fSize / 2.0f;
            }
        }
    }

    public static int getM_nSpecialJewelIndex() {
        return m_nSpecialJewelIndex;
    }

    public static void setM_nSpecialJewelIndex(int m_nSpecialJewelIndex) {
        CGBoard.m_nSpecialJewelIndex = m_nSpecialJewelIndex;
    }

    public static int getM_nSpecialJewelType() {
        return m_nSpecialJewelType;
    }

    public static void setM_nSpecialJewelType(int m_nSpecialJewelType) {
        CGBoard.m_nSpecialJewelType = m_nSpecialJewelType;
    }

    static {
        m_nNrofTypes = 7;
        m_SelectTexture = null;
        m_arrSelectTexture = null;
        m_nNewJewelIndex = -1;
        m_nSpecialJewelIndex = -1;
        m_nSpecialJewelType = -1;
        m_buttonSelectLevel = null;
        m_fCurrentRotateAngle = 0.0f;
        m_fCurrentRotateCenterX = 0.0f;
        m_fCurrentRotateCenterY = 0.0f;
        m_MarkerTexture = null;
        currentComboLevel = 1;
        comboLevelHasChanged = false;
        currentChainLevel = 0;
        timeFromLastDestroyMs = 0L;
        nothingDestroyedInLastTurn = true;
        BOARD_MAX_WIDTH = 5;
        BOARD_MAX_HEIGHT = 5;
        arrTmp = new int[BOARD_MAX_WIDTH * BOARD_MAX_HEIGHT];
    }
}

