/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gui.MainTextBox;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class SubHelp2Screen
extends MainTextBox {
    public static int selectedAchiev = 0;
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    private String csText1;
    private String csText2;
    private CGTexture[] gameModes = null;

    protected void Clean() {
        if (this.gameModes != null) {
            for (int i = 0; i < 3; ++i) {
                TextureManager.DeleteTexture(this.gameModes[i]);
                this.gameModes[i] = null;
            }
        }
    }

    public void onFocusBack() {
        super.onFocusBack();
        if (this.gameModes == null) {
            this.gameModes = new CGTexture[3];
            this.gameModes[0] = TextureManager.AddTexture("/menu/ico_arcade.png");
            this.gameModes[1] = TextureManager.AddTexture("/menu/ico_survival.png");
            this.gameModes[2] = TextureManager.AddTexture("/menu/ico_sequence.png");
        }
    }

    public SubHelp2Screen() {
        super(0, ApplicationData.screenHeight / 3, ApplicationData.screenWidth, ApplicationData.screenHeight / 3 * 2 - ObjectsCache.menuSbOK.GetHeight(), true, 0, false, null);
        int arrowRightX;
        this.LEFT_ARROW_ID = 111;
        this.RIGHT_ARROW_ID = 112;
        this.autoSize();
        selectedAchiev = 0;
        this.drawTop = true;
        this.drawTitle = false;
        this.setCaption(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ACHIEVEMENTS"));
        this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.gameModes = new CGTexture[3];
        this.gameModes[0] = TextureManager.AddTexture("/menu/ico_arcade.png");
        this.gameModes[1] = TextureManager.AddTexture("/menu/ico_survival.png");
        this.gameModes[2] = TextureManager.AddTexture("/menu/ico_sequence.png");
        int trackIconX = ApplicationData.screenWidth / 2 - this.gameModes[0].GetWidth() / 2;
        int trackIconY = ApplicationData.screenHeight / 4 - this.gameModes[0].GetHeight();
        int arrowsY = trackIconY + this.gameModes[0].GetHeight() / 2 - ObjectsCache.arrowLeft.GetHeight() / 2;
        int arrowLeftX = (ApplicationData.screenWidth / 2 - this.gameModes[0].GetWidth() / 2) / 2 - ObjectsCache.arrowLeft.GetWidth() / 2;
        if (arrowLeftX < 0) {
            arrowLeftX = 0;
        }
        if ((arrowRightX = ApplicationData.screenWidth / 2 + this.gameModes[0].GetWidth() / 2 + (ApplicationData.screenWidth - (ApplicationData.screenWidth / 2 + this.gameModes[0].GetWidth() / 2)) / 2 - ObjectsCache.arrowLeft.GetWidth() / 2) > ApplicationData.screenWidth - ObjectsCache.arrowLeft.GetWidth()) {
            arrowRightX = ApplicationData.screenWidth - ObjectsCache.arrowLeft.GetWidth();
        }
        UIAnimatedButtonH right_B = new UIAnimatedButtonH(arrowRightX, arrowsY, ObjectsCache.arrowRight, ObjectsCache.arrowRight_a, 112);
        right_B.setScreen(this);
        right_B.setAnimDir(1.0f);
        this.addButton(right_B);
        UIAnimatedButtonH left_B = new UIAnimatedButtonH(arrowLeftX, arrowsY, ObjectsCache.arrowLeft, ObjectsCache.arrowLeft_a, 111);
        left_B.setScreen(this);
        left_B.setAnimDir(-1.0f);
        this.addButton(left_B);
        this.updateInfo();
    }

    private void updateInfo() {
        this.csText1 = ApplicationData.defaultFont.encodeDynamicString("" + (selectedAchiev + 1) + " / " + 3);
        this.csText2 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_HELP_MODES_HEADER_" + (selectedAchiev + 1));
        this.setText(ApplicationData.defaultFont.encodeDynamicString(" ") + ApplicationData.lp.getTranslatedString(Options.languageID, "TID_HELP_MODES_DESC_" + (selectedAchiev + 1)));
    }

    public void draw() {
        super.draw();
        int trackIconX = ApplicationData.screenWidth / 2 - this.gameModes[0].GetWidth() / 2;
        int trackIconY = ApplicationData.screenHeight / 4 - this.gameModes[0].GetHeight();
        Graphic2D.DrawImage(this.gameModes[selectedAchiev], trackIconX, trackIconY, 20);
        Utils.drawString(this.csText2, ApplicationData.screenWidth >> 1, trackIconY, 33, 0);
    }

    public boolean selectLeftAction() {
        UIButton b = this.findByID(111);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton b = this.findByID(112);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean onRightAction() {
        if (++selectedAchiev >= 3) {
            selectedAchiev = 0;
        }
        this.updateInfo();
        return true;
    }

    public boolean onLeftAction() {
        if (--selectedAchiev < 0) {
            selectedAchiev = 2;
        }
        this.updateInfo();
        return true;
    }

    public boolean rightSoftButton() {
        this.Clean();
        if (this.parentScreen != null) {
            this.readyForClose = true;
            return true;
        }
        return false;
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            this.unselectAllButtons();
            if (nID == 111) {
                this.onLeftAction();
                return true;
            }
            if (nID == 112) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public boolean leftSoftButton() {
        return false;
    }

    public void drawWindowBackground() {
        int backgroundTileWidth = ObjectsCache.backgroundElements[0].GetWidth();
        int numTilesX = ApplicationData.screenWidth / backgroundTileWidth;
        for (int x = 0; x <= numTilesX; ++x) {
            Graphic2D.DrawImage(ObjectsCache.backgroundElements[0], x * backgroundTileWidth, 0, 20);
        }
    }
}

