/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.KeyCommand;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gui.InGameMainMenu;
import baltorogames.system.ObjectsCache;

public class HudScreen
extends UIScreen {
    protected static final int POWERUP1_ID = 10;
    protected static final int POWERUP2_ID = 11;
    protected static final int POWERUP3_ID = 12;
    CGTexture scoreBgTexture = null;
    CGTexture timeBgTexture = null;
    CGTexture jewelsBar = null;
    CGTexture bugTexture = null;
    CGTexture bombTexture = null;
    CGTexture[] lifeTexture = null;
    CGTexture[] comboTexture = null;
    CGTexture loadingBar = TextureManager.AddTexture("/menu/time_fill.png");
    CGTexture loadingBarBg = TextureManager.AddTexture("/menu/time_bg.png");
    int offset = this.loadingBar.GetWidth();
    int offsetPart = this.offset / 60;
    String str = null;
    String str2 = null;
    int m_nBombIcoX;
    int m_nBombIcoY;
    int jewelsOffset = 0;
    int x_tmp = 0;
    private int blinkInterval = 0;

    public HudScreen() {
        this.m_bModalScreen = false;
        this.scoreBgTexture = TextureManager.AddTexture("/menu/hud_score_ico.png");
        this.timeBgTexture = TextureManager.AddTexture("/menu/hud_time_ico.png");
        this.setSoftButtonImage(null, null, ObjectsCache.menuSbPAUSE, ObjectsCache.menuSbPAUSE);
    }

    public void drawWindowBackground() {
        Graphic2D.DrawImage(this.timeBgTexture, 0, 0, 20);
        Graphic2D.DrawImage(this.scoreBgTexture, ApplicationData.screenWidth, 0, 24);
    }

    public void drawWindowForeground() {
    }

    public void draw() {
        int nY = 2 + ApplicationData.getFontByID(0).getFontHeight();
        if (nY < 2 + this.scoreBgTexture.GetHeight()) {
            nY = 2 + this.scoreBgTexture.GetHeight();
        }
        if (CGEngine.m_nGameMode == 1) {
            this.str = ApplicationData.defaultFont.encodeDynamicString("" + CGEngine.m_nMovesLeft + "/" + CGEngine.m_nMaxArcadeLevelMoves);
            this.str2 = ApplicationData.defaultFont.encodeDynamicString("" + CGLevelStats.m_nScore + "/" + CGEngine.m_nCurrentLevelScoreNeeded);
            if (CGEngine.m_nMovesLeft == 0) {
                this.drawBlurredBackground();
            }
        } else if (CGEngine.m_nGameMode == 2) {
            this.str = ApplicationData.defaultFont.encodeDynamicString("" + CGLevelStats.m_nSurvivalTime / 1000);
            this.str2 = ApplicationData.defaultFont.encodeDynamicString("" + CGLevelStats.m_nScore);
            Graphic2D.DrawImage(this.loadingBarBg, ApplicationData.screenWidth / 2, ApplicationData.screenHeight - this.loadingBarBg.GetHeight() / 2, 33);
            this.offset = (int)(CGEngine.m_fLifeLine * (float)this.loadingBar.GetWidth());
            if (CGEngine.m_fLifeLine > 0.25f) {
                Graphic2D.DrawRegion(this.loadingBar, 0, 0, this.offset, this.loadingBar.GetHeight(), 0, ApplicationData.screenWidth / 2 - this.loadingBarBg.GetWidth() / 2, ApplicationData.screenHeight - this.loadingBar.GetHeight() / 2, 36);
            } else if (this.blinkInterval < 500) {
                Graphic2D.DrawRegion(this.loadingBar, 0, 0, this.offset, this.loadingBar.GetHeight(), 0, ApplicationData.screenWidth / 2 - this.loadingBarBg.GetWidth() / 2, ApplicationData.screenHeight - this.loadingBar.GetHeight() / 2, 36);
            }
            if (CGEngine.m_fLifeLine < 0.0f) {
                this.drawBlurredBackground();
            }
        }
        if (CGEngine.m_nGameMode == 3) {
            this.str = CGEngine.m_nMovesLeft <= 10 ? (this.blinkInterval < 500 ? ApplicationData.defaultFont.encodeDynamicString(CGEngine.m_nMovesLeft + "/" + CGEngine.m_nMaxSeqMoves) : "") : ApplicationData.defaultFont.encodeDynamicString(CGEngine.m_nMovesLeft + "/" + CGEngine.m_nMaxSeqMoves);
            this.str2 = ApplicationData.defaultFont.encodeDynamicString("" + CGLevelStats.m_nScore);
            if (CGEngine.m_nMovesLeft == 0) {
                this.drawBlurredBackground();
            }
        }
        Utils.drawString(this.str, this.timeBgTexture.GetWidth() / 2, this.timeBgTexture.GetHeight() / 2, 3, 0);
        Utils.drawString(this.str2, ApplicationData.screenWidth - this.scoreBgTexture.GetWidth() / 2, this.scoreBgTexture.GetHeight() / 2, 3, 0);
    }

    public void onSystemPauseAction() {
        UIScreen.SetNextScreen(new InGameMainMenu());
        UIScreen.GetNextScreen().setParent(this);
        this.readyForClose = true;
    }

    public boolean rightSoftButton() {
        CGSoundSystem.Play(2, false);
        UIScreen.SetNextScreen(new InGameMainMenu());
        UIScreen.GetNextScreen().setParent(this);
        this.readyForClose = true;
        return true;
    }

    public boolean onFireAction() {
        System.out.println("CGEngine.m_BoardMarker.onSelect();");
        CGEngine.m_BoardMarker.onSelect();
        return true;
    }

    public boolean keyEvent(KeyCommand cmd) {
        if (!cmd.pressed) {
            this.unselectAllButtons();
            if (cmd.keyCode == ApplicationData.SoftButton1_Code) {
                return this.leftSoftButton();
            }
            if (cmd.keyCode == ApplicationData.SoftButton2_Code) {
                return this.rightSoftButton();
            }
            return this.onKeyAction(cmd.keyCode);
        }
        if (cmd.keyCode == ApplicationData.SoftButton1_Code) {
            return this.leftSelectSoftButton();
        }
        if (cmd.keyCode == ApplicationData.SoftButton2_Code) {
            return this.rightSelectSoftButton();
        }
        return this.onKeyDownAction(cmd.keyCode);
    }

    public boolean onKeyDownAction(int nkeyCode) {
        if (nkeyCode == 50) {
            System.out.println("CGEngine.m_BoardMarker.onUp();");
            CGEngine.m_BoardMarker.onUp();
        } else if (nkeyCode == 56) {
            System.out.println("CGEngine.m_BoardMarker.onDown();");
            CGEngine.m_BoardMarker.onDown();
        } else if (nkeyCode == 52) {
            System.out.println("CGEngine.m_BoardMarker.onLeft();");
            CGEngine.m_BoardMarker.onLeft();
        } else if (nkeyCode == 54) {
            System.out.println("CGEngine.m_BoardMarker.onRight();");
            CGEngine.m_BoardMarker.onRight();
        } else if (nkeyCode == 53) {
            System.out.println("CGEngine.m_BoardMarker.onSelect();");
            CGEngine.m_BoardMarker.onSelect();
        }
        return true;
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            // empty if block
        }
        return false;
    }

    public void onUpdate(float deltaTime) {
        this.blinkInterval += 20;
        if (this.blinkInterval > 1000) {
            this.blinkInterval = 0;
        }
    }

    private void drawBlurredBackground() {
        int backgroundTileWidth = ObjectsCache.menuBackground.GetWidth();
        int backgroundTileHeight = ObjectsCache.menuBackground.GetHeight();
        int numTilesX = ApplicationData.screenWidth / backgroundTileWidth;
        int numTilesY = ApplicationData.screenHeight / backgroundTileHeight;
        for (int x = 0; x <= numTilesX; ++x) {
            for (int y = 0; y <= numTilesY; ++y) {
                Graphic2D.DrawImage(ObjectsCache.menuBackground, x * backgroundTileWidth, y * backgroundTileHeight, 20);
            }
        }
    }
}

