/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngineRenderer;
import java.util.Vector;

public class CGHit {
    public static final int eType_Normal = 0;
    public static final int eType_Combo = 1;
    public static final int eType_LevelCleared = 5;
    public static final int eType_LevelFailed = 6;
    private static final int NUM_HIT_FRAMES = 4;
    public static final int NORMAL_HIT_LENGTH = 400;
    public static final int COLOR_LENGTH = 300;
    public static final int FIRE_LENGTH = 800;
    public static final int LVL_CLEARED_LENGTH = 900;
    public static final int LVL_FAILED_LENGTH = 900;
    public float m_fRealX;
    public float m_fRealY;
    public int m_nTime = -1;
    public int m_nFullTime = 500;
    int m_nCurrentFrame;
    int m_nType = -1;
    public static CGTexture[][] m_HitTextures = null;
    static Vector m_TmpVector = null;
    static Vector m_Vector = null;

    public static void Initialize() {
        int i;
        m_HitTextures = new CGTexture[10][];
        CGHit.m_HitTextures[0] = new CGTexture[4];
        for (i = 0; i < 4; ++i) {
            CGHit.m_HitTextures[0][i] = TextureManager.AddTexture("/gameplay/NORMALOBJECTS/HIT/bug_hit_" + (i + 1) + ".png");
        }
        CGHit.m_HitTextures[1] = new CGTexture[1];
        CGHit.m_HitTextures[1][0] = TextureManager.AddTexture("/gameplay/NORMALOBJECTS/HIT/hud_combo_x2.png");
        CGHit.m_HitTextures[2] = new CGTexture[1];
        CGHit.m_HitTextures[2][0] = TextureManager.AddTexture("/gameplay/NORMALOBJECTS/HIT/hud_combo_x3.png");
        CGHit.m_HitTextures[3] = new CGTexture[1];
        CGHit.m_HitTextures[3][0] = TextureManager.AddTexture("/gameplay/NORMALOBJECTS/HIT/hud_combo_x4.png");
        CGHit.m_HitTextures[4] = new CGTexture[1];
        CGHit.m_HitTextures[4][0] = TextureManager.AddTexture("/gameplay/NORMALOBJECTS/HIT/hud_combo_x5.png");
        CGHit.m_HitTextures[5] = new CGTexture[1];
        CGHit.m_HitTextures[5][0] = TextureManager.AddTexture("/gameplay/NORMALOBJECTS/HIT/good.png");
        CGHit.m_HitTextures[6] = new CGTexture[1];
        CGHit.m_HitTextures[6][0] = TextureManager.AddTexture("/gameplay/NORMALOBJECTS/HIT/bad.png");
        m_TmpVector = new Vector();
        m_Vector = new Vector();
        for (i = 0; i < 32; ++i) {
            CGHit pH = new CGHit();
            m_TmpVector.addElement(pH);
        }
    }

    public static void Reset() {
        int nS = m_Vector.size();
        if (nS > 0) {
            for (int i = nS - 1; i >= 0; --i) {
                m_TmpVector.addElement(m_Vector.elementAt(i));
            }
            m_Vector.removeAllElements();
        }
    }

    public static void NewHit(int nType, float x, float y, long miliseconds) {
        int nS = m_TmpVector.size();
        if (nS > 0) {
            CGHit pH = (CGHit)m_TmpVector.elementAt(nS - 1);
            m_TmpVector.removeElementAt(nS - 1);
            pH.Active(nType, x, y, miliseconds);
            m_Vector.addElement(pH);
        }
    }

    public static void StepAll(int nDeltaTimeInMs) {
        int nS = m_Vector.size();
        for (int i = nS - 1; i >= 0; --i) {
            CGHit pH = (CGHit)m_Vector.elementAt(i);
            pH.Step(nDeltaTimeInMs);
            if (pH.m_nTime >= 0) continue;
            m_Vector.removeElementAt(i);
            m_TmpVector.addElement(pH);
        }
    }

    public static void RenderAll() {
        int nS = m_Vector.size();
        for (int i = nS - 1; i >= 0; --i) {
            ((CGHit)m_Vector.elementAt(i)).Render();
        }
    }

    public void Init() {
        this.m_nTime = -1;
    }

    public void Active(int nType, float x, float y, long miliseconds) {
        this.m_nType = nType;
        this.m_nTime = 1;
        this.m_nFullTime = (int)miliseconds;
        this.m_nCurrentFrame = 0;
        this.m_fRealX = x;
        this.m_fRealY = y;
    }

    public void Disactive() {
        this.m_nTime = -1;
    }

    public void Step(int nDeltaTimeInMs) {
        this.m_nTime += nDeltaTimeInMs;
        if (this.m_nTime > this.m_nFullTime) {
            this.Disactive();
        }
        float fT = (float)this.m_nTime / (float)this.m_nFullTime;
        fT = 1.0f - fT;
        fT *= fT;
        fT *= fT;
        fT = 1.0f - fT;
        int numFrames = m_HitTextures[this.m_nType].length;
        this.m_nCurrentFrame = (int)((float)numFrames * fT);
        this.m_nCurrentFrame %= numFrames;
    }

    public void Render() {
        if (this.m_nTime < 0) {
            return;
        }
        CGEngineRenderer.RenderHit(this, this.m_fRealX, this.m_fRealY);
    }
}

