/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core_gui.UIScreen;
import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.AchievementPopup;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGBoardKeyboardMarker;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGHit;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gameplay.GiftScore;
import baltorogames.project_gameplay.MyGame;
import baltorogames.project_gameplay.WorldMap;
import baltorogames.project_gui.SequenceScoreScreen;
import baltorogames.project_gui.StoryScoreScreen;
import baltorogames.project_gui.SurvivalScoreScreen;
import java.io.DataInputStream;

public class CGEngine {
    public static int POINTS_FOR_JEWEL_DESTROYED_ARCADE = 5;
    public static int GAME_OVER_DELAY = 500;
    public static final int eGameMode_Story = 1;
    public static final int eGameMode_Survival = 2;
    public static final int eGameMode_Sequence = 3;
    public static final int eGameWorld_1 = 0;
    public static final int eGameWorld_2 = 1;
    public static final int eGameWorld_3 = 2;
    public static final int eLevelsPerWorld = 15;
    public static int m_nCurrentWorld = 0;
    public static int m_nSurvivalLevel = -1;
    public static int m_nGameMode = 1;
    public static int m_nViewMode = 0;
    public static int m_nGameTick = 0;
    public static int m_nCurrentStoryLevel = 0;
    public static int[] m_arrStoryLevelScoreNeeded = new int[]{140, 190, 350, 510, 570, 640, 660, 670, 710, 720, 750, 770, 830, 1100, 1400, 320, 340, 400, 620, 710, 920, 850, 860, 900, 950, 1000, 900, 1200, 1340, 1740, 350, 380, 400, 640, 760, 1000, 900, 940, 930, 950, 1050, 950, 1250, 1350, 1850};
    public static int[] m_arrNumberOfJewelPerLvl = new int[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7};
    public static int[] m_arrStoryLevelTime = new int[]{40, 55, 65, 80, 90, 90, 110, 120, 120, 130, 140, 150, 160, 170, 180, 90, 120, 110, 120, 100, 110, 100, 90, 120, 110, 130, 120, 110, 140, 200, 90, 120, 110, 120, 100, 110, 100, 90, 120, 110, 130, 120, 110, 140, 200};
    public static int[] m_arrStoryLevelMaxMoves = new int[]{10, 15, 20, 25, 25, 30, 30, 35, 35, 40, 40, 45, 45, 50, 50, 25, 25, 30, 30, 35, 35, 40, 40, 45, 45, 50, 50, 55, 55, 55, 25, 25, 30, 30, 35, 40, 40, 45, 45, 45, 50, 50, 55, 55, 60};
    public static int m_nCurrentLevelScoreNeeded = 60;
    public static int m_nCurrentLevelTimeLimit = 60;
    public static int m_nCurrentLevelTime = 60000;
    public static int m_nMovesLeft = -1;
    public static int m_nMaxSeqMoves = 0;
    public static int m_nMaxArcadeLevelMoves = 0;
    public static float m_fLifeLine = 1.0f;
    public static float m_fCurrentLifeTimeDecPerSec = 0.01f;
    public static float m_fStartLifeTimeDecPerSec = 0.01f;
    public static float m_fEndLifeTimeDecPerSec = 0.4f;
    public static int m_nFromStartToEndInSecs = 600;
    public static final int e_power_up_multi_point = 0;
    public static final int e_power_up_free_time = 1;
    public static final int e_power_up_big_bombs = 2;
    public static final int e_power_up_combo_warp = 3;
    public static final int e_power_up_special_gem = 4;
    public static final int e_max_num_powerups = 5;
    public static boolean[] m_arrPowerUps = new boolean[5];
    public static boolean m_bGameActive = false;
    public static float m_fCameraPosX = 0.0f;
    public static float m_fCameraPosY = 0.0f;
    public static boolean m_nTouchActive = false;
    public static float m_fTouchX = -1000000.0f;
    public static float m_fTouchY = -1000000.0f;
    public static float m_StartSelectPointX;
    public static float m_StartSelectPointY;
    public static float m_CurrentSelectPointX;
    public static float m_CurrentSelectPointY;
    public static int[] m_nComboAnimFrames;
    public static CGBoardKeyboardMarker m_BoardMarker;
    public static CGBoard m_Board;
    public static float m_fEngineScale;
    public static boolean m_bPause;
    public static boolean m_bGameOver;
    public static int m_nGameOverDelay;
    public static int m_nGameResult;
    protected static int m_nUpdateDeltaTime;
    public static int m_nEngineTime;
    public static int m_nDisplayComboTime;

    public static void Load1(DataInputStream dis) {
        CGEngine.Destroy();
        int nScreenX = 480;
        int nScreenY = 800;
        float fScaleX = (float)ApplicationData.screenWidth / (float)nScreenX;
        float fScaleY = (float)ApplicationData.screenHeight / (float)nScreenY;
        m_fEngineScale = fScaleX < fScaleY ? fScaleX : fScaleY;
        CGEngineRenderer.m_fScreenOffsetX = ((float)ApplicationData.screenWidth - m_fEngineScale * (float)nScreenX) / 2.0f;
        CGEngineRenderer.m_fScreenOffsetY = ((float)ApplicationData.screenHeight - m_fEngineScale * (float)nScreenY) / 2.0f;
        CGEngineRenderer.m_fScreenOffsetX = ((float)ApplicationData.screenWidth - m_fEngineScale * (float)nScreenX) / 2.0f;
        CGEngineRenderer.m_fScreenOffsetY = ((float)ApplicationData.screenHeight + 20.0f - m_fEngineScale * (float)nScreenY) / 2.0f;
    }

    public static void Load2(DataInputStream dis) {
        CGLevelStats.Reset();
        CGUserCareer.m_nMoney = 0;
        m_bPause = false;
        m_nEngineTime = 0;
        m_bGameOver = false;
        m_nGameOverDelay = 0;
        m_nGameResult = 0;
        m_nUpdateDeltaTime = 0;
        m_bGameActive = true;
        m_nMovesLeft = m_nMaxSeqMoves;
        m_fLifeLine = 1.0f;
        m_nCurrentLevelTime = m_arrStoryLevelTime[m_nCurrentStoryLevel] * 1000;
        m_nMaxArcadeLevelMoves = m_arrStoryLevelMaxMoves[m_nCurrentStoryLevel];
        m_nCurrentLevelTimeLimit = m_arrStoryLevelTime[m_nCurrentStoryLevel];
        m_nCurrentLevelScoreNeeded = m_arrStoryLevelScoreNeeded[m_nCurrentStoryLevel];
        if (m_nGameMode == 1) {
            m_nMovesLeft = m_nMaxArcadeLevelMoves;
        }
        WorldMap wm = ((MyGame)ApplicationData.game).m_WorldMap;
        m_bGameActive = true;
        m_nTouchActive = false;
        m_fTouchX = -1000000.0f;
        m_fTouchY = -1000000.0f;
        m_StartSelectPointX = -1000000.0f;
        m_StartSelectPointY = -1000000.0f;
        m_CurrentSelectPointX = -1000000.0f;
        m_CurrentSelectPointY = -1000000.0f;
        CGHit.Reset();
        GiftScore.Reset();
        m_nViewMode = 0;
        CGEngineRenderer.m_nComboTime = -1;
        m_nGameTick = 0;
        m_nDisplayComboTime = -1;
        m_Board = new CGBoard();
        m_Board.Init();
        m_BoardMarker = new CGBoardKeyboardMarker();
        m_BoardMarker.Reset();
    }

    public static int Init() {
        return 1;
    }

    public static void Destroy() {
    }

    public static void Update(int nDeltaTimeInMs) {
        m_nUpdateDeltaTime = nDeltaTimeInMs;
        m_nEngineTime += m_nUpdateDeltaTime;
        if (m_nDisplayComboTime >= 0 && (m_nDisplayComboTime += nDeltaTimeInMs) > 1250) {
            m_nDisplayComboTime = -1;
        }
        if (m_nUpdateDeltaTime <= 30) {
            CGEngine.UpdateInternal(m_nUpdateDeltaTime);
        } else {
            int nT = 0;
            for (nT = 30; nT < m_nUpdateDeltaTime; nT += 30) {
                CGEngine.UpdateInternal(30);
            }
            nT = m_nUpdateDeltaTime % 30;
            if (nT > 0) {
                CGEngine.UpdateInternal(nT);
            }
        }
    }

    public static void UpdateInternal(int nDeltaTimeInMs) {
        m_nViewMode = 0;
        if (ApplicationData.isInGameMode() && m_nGameMode == 1 && m_nCurrentStoryLevel >= 15) {
            m_nViewMode = 0;
        }
        if (m_bPause) {
            return;
        }
        ++m_nGameTick;
        if (m_bGameActive) {
            CGEngine.CheckSuccessLosConditions(nDeltaTimeInMs);
            if (m_nGameMode != 2 && m_nMovesLeft != 0) {
                m_Board.Step(nDeltaTimeInMs);
                CGHit.StepAll(nDeltaTimeInMs);
                GiftScore.StepAll(nDeltaTimeInMs);
            } else if (m_nGameMode == 2 && m_fLifeLine > 0.0f) {
                m_Board.Step(nDeltaTimeInMs);
                CGHit.StepAll(nDeltaTimeInMs);
                GiftScore.StepAll(nDeltaTimeInMs);
            }
        }
        if (m_bGameActive && m_bGameOver) {
            CGEngine.HandleGameOver(nDeltaTimeInMs);
        }
    }

    public static boolean isPowerUpAvailable(int powerup_id) {
        return m_arrPowerUps[powerup_id];
    }

    private static void CheckSuccessLosConditions(int nDeltaTimeInMs) {
        if (m_nGameMode == 1) {
            if (m_nMovesLeft <= 0) {
                boolean levelWon = true;
                if (m_nCurrentLevelScoreNeeded > 0 && m_nCurrentLevelScoreNeeded > CGLevelStats.m_nScore) {
                    levelWon = false;
                    CGAchievements.completeAchievement(1);
                }
                if (levelWon) {
                    CGEngine.EventWin();
                } else {
                    CGEngine.EventLost(false);
                }
            } else if ((m_nCurrentLevelTime -= nDeltaTimeInMs) < 0) {
                m_nCurrentLevelTime = 0;
            }
        } else if (m_nGameMode == 3) {
            if (m_nMovesLeft == 0) {
                CGEngine.EventLost(false);
            } else {
                CGLevelStats.m_nTimeStatsInMs += nDeltaTimeInMs + m_nCurrentLevelTime;
            }
        } else if (m_nGameMode == 2) {
            if (m_fLifeLine <= 0.0f) {
                CGEngine.EventLost(false);
            } else {
                float factor;
                CGLevelStats.m_nSurvivalTime += nDeltaTimeInMs;
                if ((m_fLifeLine -= (float)nDeltaTimeInMs / 1000.0f * m_fCurrentLifeTimeDecPerSec) < 0.0f) {
                    m_fLifeLine = 0.0f;
                }
                if ((factor = (float)CGLevelStats.m_nSurvivalTime / ((float)m_nFromStartToEndInSecs * 1000.0f)) >= 1.0f) {
                    factor = 1.0f;
                }
                m_fCurrentLifeTimeDecPerSec = m_fStartLifeTimeDecPerSec * (1.0f - factor) + factor * m_fEndLifeTimeDecPerSec;
            }
        }
        if (!m_bGameOver) {
            CGLevelStats.m_nTimeStatsInMs += nDeltaTimeInMs;
        }
    }

    private static void HandleGameOver(int nDeltaTimeInMs) {
        if (m_nGameOverDelay > 0 && (m_nGameOverDelay -= nDeltaTimeInMs) <= 0) {
            m_nGameOverDelay = 0;
            if (m_nGameResult < 0) {
                if (m_nGameMode == 1) {
                    UIScreen.SetCurrentScreen(null);
                    UIScreen.SetNextScreen(null);
                    UIScreen.SetCurrentScreen(new StoryScoreScreen(-1));
                } else if (m_nGameMode == 2) {
                    UIScreen.SetCurrentScreen(null);
                    UIScreen.SetNextScreen(null);
                    UIScreen.SetCurrentScreen(new SurvivalScoreScreen(999));
                } else {
                    UIScreen.SetCurrentScreen(null);
                    UIScreen.SetNextScreen(null);
                    UIScreen.SetCurrentScreen(new SequenceScoreScreen(999));
                }
            } else {
                UIScreen.SetCurrentScreen(null);
                UIScreen.SetNextScreen(null);
                UIScreen.SetCurrentScreen(new StoryScoreScreen(999));
                int nStars = CGUserCareer.m_arrLevelScore[m_nCurrentStoryLevel];
                int nCS = 0;
                if (CGLevelStats.m_nScore >= 2 * m_arrStoryLevelScoreNeeded[m_nCurrentStoryLevel]) {
                    nCS = 3;
                } else if (CGLevelStats.m_nScore >= m_arrStoryLevelScoreNeeded[m_nCurrentStoryLevel] + m_arrStoryLevelScoreNeeded[m_nCurrentStoryLevel] / 2) {
                    nCS = 2;
                } else if (CGLevelStats.m_nScore >= m_arrStoryLevelScoreNeeded[m_nCurrentStoryLevel]) {
                    nCS = 1;
                }
                if (nCS > nStars) {
                    CGUserCareer.m_arrLevelScore[CGEngine.m_nCurrentStoryLevel] = nCS;
                }
            }
        }
    }

    public static void EventWin() {
        if (!m_bGameOver) {
            m_bGameOver = true;
            m_nGameOverDelay = GAME_OVER_DELAY;
            m_nGameResult = 1;
            CGSoundSystem.Play(1, false);
        }
    }

    public static void EventLost(boolean bPlaySound) {
        if (!m_bGameOver) {
            m_bGameOver = true;
            m_nGameOverDelay = GAME_OVER_DELAY;
            m_nGameResult = -1;
            if (bPlaySound) {
                CGSoundSystem.Play(0, false);
            }
        }
    }

    public static void Render() {
        if (m_bGameActive) {
            m_Board.Render();
            m_BoardMarker.Render();
            GiftScore.RenderAll();
            CGHit.RenderAll();
            CGDynamicObj.StepCurrentDynamics(m_nUpdateDeltaTime);
            AchievementPopup.Step();
        }
    }

    static {
        m_nComboAnimFrames = new int[]{0, 1, 2, 2, 2, 1};
        m_fEngineScale = 1.0f;
        m_bPause = false;
        m_bGameOver = false;
        m_nGameOverDelay = 0;
        m_nGameResult = 0;
        m_nUpdateDeltaTime = 0;
        m_nEngineTime = 0;
    }
}

