/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core_gui.UIFloatingTextBoxEx;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.StoryParamsScreen;
import baltorogames.project_gui.TutorialScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class TutorialScreenSecond
extends MainScreen {
    private int m_nFrameDelay = 0;
    private int FontHeight = ApplicationData.defaultFont.getFontHeight();
    CGTexture[] firstTutorialFrames = new CGTexture[5];
    UIFloatingTextBoxEx textBox;
    String tutorialInfo = new String();

    public TutorialScreenSecond() {
        CGUserCareer.isStoryTutorialOn = false;
        this.loadImagesForTutorial();
        this.tutorialInfo = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TUT_SCREEN_2");
        this.textBox = new UIFloatingTextBoxEx(true, 0, ApplicationData.screenHeight / 3 * 2, ApplicationData.screenWidth, ApplicationData.screenHeight / 3 - ObjectsCache.menuSbOK.GetHeight());
        this.textBox.setText(this.tutorialInfo);
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
    }

    public void draw() {
        this.drawWindowBackground();
        Graphic2D.DrawImage(this.firstTutorialFrames[this.m_nFrameDelay], ApplicationData.screenWidth / 2, 0, 17);
        this.textBox.draw();
    }

    public void onUpdate(float f) {
        super.onUpdate(f);
        this.textBox.onUpdate(f);
        this.m_nFrameDelay = (int)(this.getLifeTime() * 1000.0f) / 400;
        this.m_nFrameDelay %= 5;
    }

    public void drawWindowBackground() {
        this.drawTitle = false;
        this.drawBottom = false;
        int n = ObjectsCache.backgroundElements[0].GetWidth();
        int n2 = ApplicationData.screenWidth / n;
        for (int i = 0; i <= n2; ++i) {
            Graphic2D.DrawImage(ObjectsCache.backgroundElements[0], i * n, 0, 20);
        }
    }

    public void loadImagesForTutorial() {
        for (int i = 0; i < this.firstTutorialFrames.length; ++i) {
            this.firstTutorialFrames[i] = TextureManager.AddTexture("/menu/tutorial/tut2_" + (i + 1) + ".png");
        }
    }

    public boolean rightSoftButton() {
        UIScreen.SetCurrentScreen(new TutorialScreen());
        return true;
    }

    public boolean leftSoftButton() {
        if (CGEngine.m_nGameMode == 1) {
            CGSoundSystem.Play(2, false);
            UIScreen.SetNextScreen(new StoryParamsScreen());
            UIScreen.GetNextScreen().setParent(this);
            this.readyForClose = true;
        }
        return true;
    }
}

