/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGJewel;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.SelectWorldScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import baltorogames.system.Platform;

public class StoryParamsScreen
extends MainScreen {
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    public static int selectedAchiev = 0;
    private int nStartBoxY = 0;
    private int nStopBoxY = 0;
    private int nBoxWidth = 0;
    private UIFloatingTextBox infoBox;
    private String csText;
    protected int nScore = 0;
    private CGTexture[] achievImages = null;
    private CGTexture[] starsImages = null;

    protected void Clean() {
        int n;
        if (this.achievImages != null) {
            for (n = 0; n < 2; ++n) {
                TextureManager.DeleteTexture(this.achievImages[n]);
                this.achievImages[n] = null;
            }
        }
        this.achievImages = null;
        if (this.starsImages != null) {
            for (n = 0; n < 4; ++n) {
                TextureManager.DeleteTexture(this.starsImages[n]);
                this.starsImages[n] = null;
            }
        }
        this.starsImages = null;
    }

    public void onFocusBack() {
        super.onFocusBack();
        if (this.achievImages == null) {
            this.achievImages = new CGTexture[2];
            this.achievImages[0] = TextureManager.AddTexture("/menu/level_ico.png");
            this.achievImages[1] = TextureManager.AddTexture("/menu/level_ico_n.png");
        }
        if (this.starsImages == null) {
            this.starsImages = new CGTexture[4];
            this.starsImages[0] = TextureManager.AddTexture("/menu/stars0.png");
            this.starsImages[1] = TextureManager.AddTexture("/menu/stars1.png");
            this.starsImages[2] = TextureManager.AddTexture("/menu/stars2.png");
            this.starsImages[3] = TextureManager.AddTexture("/menu/stars3.png");
        }
    }

    public StoryParamsScreen() {
        int n;
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        selectedAchiev = 0;
        this.drawTop = true;
        this.drawTitle = false;
        this.setCaption(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ACHIEVEMENTS"));
        this.achievImages = new CGTexture[2];
        this.achievImages[0] = TextureManager.AddTexture("/menu/level_ico.png");
        this.achievImages[1] = TextureManager.AddTexture("/menu/level_ico_n.png");
        this.starsImages = new CGTexture[4];
        this.starsImages[0] = TextureManager.AddTexture("/menu/stars0.png");
        this.starsImages[1] = TextureManager.AddTexture("/menu/stars1.png");
        this.starsImages[2] = TextureManager.AddTexture("/menu/stars2.png");
        this.starsImages[3] = TextureManager.AddTexture("/menu/stars3.png");
        int n2 = ApplicationData.screenWidth / 2 - this.achievImages[0].GetWidth() / 2;
        int n3 = ApplicationData.screenHeight / 2 - this.achievImages[0].GetHeight() / 2;
        int n4 = n3 + this.achievImages[0].GetHeight() / 2 - ObjectsCache.arrowLeft.GetHeight() / 2;
        int n5 = (ApplicationData.screenWidth / 2 - this.achievImages[0].GetWidth() / 2) / 2 - ObjectsCache.arrowLeft.GetWidth() / 2;
        if (n5 < 0) {
            n5 = 0;
        }
        if ((n = ApplicationData.screenWidth / 2 + this.achievImages[0].GetWidth() / 2 + (ApplicationData.screenWidth - (ApplicationData.screenWidth / 2 + this.achievImages[0].GetWidth() / 2)) / 2 - ObjectsCache.arrowLeft.GetWidth() / 2) > ApplicationData.screenWidth - ObjectsCache.arrowLeft.GetWidth()) {
            n = ApplicationData.screenWidth - ObjectsCache.arrowLeft.GetWidth();
        }
        UIAnimatedButtonH uIAnimatedButtonH = new UIAnimatedButtonH(n, n4, ObjectsCache.arrowRight, ObjectsCache.arrowRight_a, 101);
        uIAnimatedButtonH.setScreen(this);
        uIAnimatedButtonH.setAnimDir(1.0f);
        this.addButton(uIAnimatedButtonH);
        UIAnimatedButtonH uIAnimatedButtonH2 = new UIAnimatedButtonH(n5, n4, ObjectsCache.arrowLeft, ObjectsCache.arrowLeft_a, 100);
        uIAnimatedButtonH2.setScreen(this);
        uIAnimatedButtonH2.setAnimDir(-1.0f);
        this.addButton(uIAnimatedButtonH2);
        this.nStartBoxY = ApplicationData.getFontByID(0).getFontHeight();
        this.nStopBoxY = n3;
        this.nBoxWidth = ApplicationData.screenWidth;
        this.infoBox = new UIFloatingTextBox(false, (ApplicationData.screenWidth - this.nBoxWidth) / 2, this.nStartBoxY, this.nBoxWidth, this.nStopBoxY - this.nStartBoxY);
        this.updateAchievementInfo();
    }

    private void updateAchievementInfo() {
        this.csText = ApplicationData.getFontByID(0).encodeDynamicString(selectedAchiev + 1 + "/15");
        this.findByID(100).setVisible(selectedAchiev > 0);
        this.findByID(101).setVisible(selectedAchiev + 1 < 15);
        if (CGUserCareer.GetAdventureLevel() >= CGEngine.m_nCurrentWorld * 15 + selectedAchiev || Platform.isDebug) {
            this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        } else {
            this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        }
    }

    public void autoSize() {
    }

    public void draw() {
        int n = ApplicationData.screenWidth / 2 - this.achievImages[0].GetWidth() / 2;
        int n2 = ApplicationData.screenHeight / 2 - this.achievImages[0].GetHeight() / 2;
        if (CGUserCareer.GetAdventureLevel() >= CGEngine.m_nCurrentWorld * 15 + selectedAchiev) {
            Graphic2D.DrawImage(this.achievImages[0], n, n2, 20);
            int n3 = CGUserCareer.m_arrLevelScore[CGEngine.m_nCurrentWorld * 15 + selectedAchiev];
            Graphic2D.DrawImage(this.starsImages[n3], ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
        } else {
            Graphic2D.DrawImage(this.achievImages[1], n, n2, 20);
            Graphic2D.DrawImage(this.starsImages[0], ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
        }
        Utils.drawString(this.csText, ApplicationData.screenWidth >> 1, n2 - 2 * ApplicationData.getFontByID(0).getFontHeight(), 3, 0);
        this.infoBox.draw();
    }

    public boolean rightSoftButton() {
        this.Clean();
        if (this.parentScreen != null) {
            this.readyForClose = true;
            return true;
        }
        this.parentScreen = new SelectWorldScreen();
        this.readyForClose = true;
        return true;
    }

    public boolean leftSoftButton() {
        if (CGUserCareer.GetAdventureLevel() >= CGEngine.m_nCurrentWorld * 15 + selectedAchiev || Platform.isDebug) {
            CGEngine.m_nGameMode = 1;
            CGEngine.m_nCurrentStoryLevel = CGEngine.m_nCurrentWorld * 15 + selectedAchiev;
            CGJewel.NUM_JEWEL_COLORS = CGEngine.m_arrNumberOfJewelPerLvl[CGEngine.m_nCurrentStoryLevel];
            CGBoard.m_nNrofTypes = CGEngine.m_arrNumberOfJewelPerLvl[CGEngine.m_nCurrentStoryLevel];
            String string = "/level_" + CGEngine.m_nCurrentWorld + ".lrs";
            ApplicationData.getGame().startLoading(string);
            ApplicationData.getGame().stepLoading(string);
            ApplicationData.getGame().stepLoading(string);
            ApplicationData.getGame().stepLoading(string);
            ApplicationData.getGame().stepLoading(string);
            ApplicationData.getGame().endLoading(string);
            ApplicationData.generalGameMode = 4;
            CGEngine.m_bGameActive = true;
            this.readyForClose = true;
            return true;
        }
        return false;
    }

    public boolean selectLeftAction() {
        UIButton uIButton = this.findByID(100);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton uIButton = this.findByID(101);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean onRightAction() {
        if (++selectedAchiev >= 14) {
            selectedAchiev = 14;
        }
        this.updateAchievementInfo();
        return true;
    }

    public boolean onLeftAction() {
        if (--selectedAchiev < 0) {
            selectedAchiev = 0;
        }
        this.updateAchievementInfo();
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (super.actionSoftButton(n, bl)) {
            return true;
        }
        if (!bl) {
            this.unselectAllButtons();
            if (n == 100) {
                this.onLeftAction();
                return true;
            }
            if (n == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public void drawWindowBackground() {
        int n = ObjectsCache.backgroundElements[0].GetWidth();
        int n2 = ApplicationData.screenWidth / n;
        for (int i = 0; i <= n2; ++i) {
            Graphic2D.DrawImage(ObjectsCache.backgroundElements[0], i * n, 0, 20);
        }
    }
}

