/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core_gui.UIScreen;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gui.AbortApplicationTB;
import baltorogames.project_gui.AchievementsScreen;
import baltorogames.project_gui.HelpSelectionScreen;
import baltorogames.project_gui.MainListAnimated;
import baltorogames.project_gui.NewYesNoDialogScreen;
import baltorogames.project_gui.SelectModeScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class MainMenu
extends MainListAnimated {
    public static int selectedGameMode;
    boolean isBTAvailable = false;
    private int FREE_TRIAL_ID = -1;
    private int UPSELL_ID = -1;
    private int PLAY_ID = 0;
    private int ACHIEVE_ID = 1;
    private int HELP_ID = 2;
    private int OPTIONS_ID = 3;
    private int QUIT_ID = 4;
    public static boolean isInitialized;

    public MainMenu() {
        isInitialized = true;
        this.drawTop = false;
        this.drawTitle = true;
        this.drawWindowBackground();
        if (ApplicationData.demoEnabled) {
            this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_DEMO_VERSION"));
            this.updateIDsForDemo();
        }
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, ApplicationData.demoEnabled ? "ID_TRIAL_INFO_HEADER" : "TID_PLAY"));
        if (ApplicationData.upSellEnabled) {
            this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_UPSELL_GAME"), true);
            this.updateIDsForUpSell();
        }
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ACHIEVEMENTS"));
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_HELP"));
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_OPTIONS"));
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_EXIT"));
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, null, null);
    }

    private void updateIDsForDemo() {
        this.FREE_TRIAL_ID = 0;
        ++this.PLAY_ID;
        ++this.ACHIEVE_ID;
        ++this.HELP_ID;
        ++this.OPTIONS_ID;
        ++this.QUIT_ID;
    }

    private void updateIDsForUpSell() {
        this.UPSELL_ID = this.PLAY_ID + 1;
        ++this.ACHIEVE_ID;
        ++this.HELP_ID;
        ++this.OPTIONS_ID;
        ++this.QUIT_ID;
    }

    public void onFocusBack() {
        super.onFocusBack();
        this.currentItem = 0;
    }

    public void currentItemChanged(int n, int n2) {
    }

    public void currentItemSelected(int n) {
        if (n == this.PLAY_ID) {
            CGSoundSystem.Play(2, false);
            UIScreen.SetNextScreen(new SelectModeScreen());
            UIScreen.GetNextScreen().setParent(this);
            this.readyForClose = true;
        }
        if (n == this.ACHIEVE_ID) {
            CGSoundSystem.Play(2, false);
            UIScreen.SetNextScreen(new AchievementsScreen());
            UIScreen.GetNextScreen().setParent(this);
            this.readyForClose = true;
        }
        if (n == this.HELP_ID) {
            CGSoundSystem.Play(2, false);
            UIScreen.SetNextScreen(new HelpSelectionScreen());
            UIScreen.GetNextScreen().setParent(this);
            this.readyForClose = true;
        }
        if (n == this.OPTIONS_ID) {
            CGSoundSystem.Play(2, false);
            UIScreen.SetNextScreen(new Options());
            UIScreen.GetNextScreen().setParent(this);
            this.readyForClose = true;
        }
        if (n == this.QUIT_ID) {
            UIScreen.SetCurrentScreen(new AbortApplicationTB());
        }
        if (n == this.FREE_TRIAL_ID) {
            UIScreen.SetCurrentScreen(new NewYesNoDialogScreen());
        }
        if (n == this.UPSELL_ID) {
            // empty if block
        }
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (bl) {
            return super.actionSoftButton(n, bl);
        }
        if (n >= 1000) {
            this.currentItemSelected(n - 1000);
            return true;
        }
        return super.actionSoftButton(n, bl);
    }

    public boolean leftSoftButton() {
        this.currentItemSelected(this.currentItem);
        return true;
    }

    static {
        isInitialized = false;
    }
}

