/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gui.MainScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;

public class LoadingLevelScreen
extends MainScreen {
    private int emptyBarColor = -16777216;
    private int emptyBarHeight = 30;
    private int fullBarColor = -1;
    private int fullBarHeight = 22;
    private static final int MAX_NUM_LOADING_HINTS = 4;
    private static final int NUM_PLAYED_GAMES_WE_NEED_MORE_INFO = 10;
    private static final int LEFT_RIGHT_MARGIN = 5;
    private static int numPlayedGames = 0;
    private static Random rnd = new Random();
    private int counterDraw = 0;
    private int fontID = 0;
    private Vector textLines = new Vector();
    private String levelToLoad = null;

    public LoadingLevelScreen() {
        this.drawTop = false;
        this.drawTitle = false;
        ApplicationData.soundEngine.stopMID();
        int n = Math.abs(ApplicationData.rnd.nextInt()) % 4;
        this.setText(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_COSMO_INFO_" + n));
        this.setupDrawingArea();
        ApplicationData.generalGameMode = 3;
        this.levelToLoad = "level_" + CGEngine.m_nCurrentWorld + ".lrs";
    }

    public void updateSize() {
    }

    public void drawWindowBackground() {
        super.drawWindowBackground();
    }

    public void drawWindowForeground() {
    }

    public static void deSerialize(DataInputStream dataInputStream) throws IOException {
        numPlayedGames = dataInputStream.readInt();
    }

    public static void serialize(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(numPlayedGames);
    }

    private void setupDrawingArea() {
    }

    public void setText(String string, String string2) {
        int n = 0;
        int n2 = ApplicationData.screenWidth;
        this.textLines = Utils.splitText(string, string2, n2 - n, this.fontID);
    }

    public void setText(String string) {
        this.setText(string, "+");
    }

    public void draw() {
        int n = ApplicationData.getFontByID(this.fontID).getFontHeight();
        int n2 = ApplicationData.screenWidth / 20;
        int n3 = ApplicationData.screenHeight - ObjectsCache.menuSbOK.GetHeight() / 2 - this.emptyBarHeight;
        Graphic2D.SetColor(this.emptyBarColor);
        Graphic2D.FillRect(0, n3, ApplicationData.screenWidth, this.emptyBarHeight);
        Graphic2D.SetColor(this.fullBarColor);
        Graphic2D.FillRect(0, n3 += (this.emptyBarHeight - this.fullBarHeight) / 2, this.counterDraw * ApplicationData.screenWidth / 50, this.fullBarHeight);
        int n4 = this.textLines.size();
        int n5 = ApplicationData.screenHeight / 2;
        n5 -= n4 * n / 2;
        if (this.counterDraw == 21) {
            // empty if block
        }
        if (this.counterDraw < 50) {
            ++this.counterDraw;
        }
    }

    public void onUpdate(float f) {
        if (this.counterDraw >= 50) {
            ApplicationData.getGame().startLoading(this.levelToLoad);
            ApplicationData.getGame().stepLoading(this.levelToLoad);
            ApplicationData.getGame().stepLoading(this.levelToLoad);
            ApplicationData.getGame().stepLoading(this.levelToLoad);
            ApplicationData.getGame().stepLoading(this.levelToLoad);
            ApplicationData.getGame().endLoading(this.levelToLoad);
            ApplicationData.generalGameMode = 4;
            CGEngine.m_bGameActive = true;
        }
    }
}

