/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.Log;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.TmpWorldObjectsDataBase;
import baltorogames.project_gameplay.WorldLayer;
import baltorogames.project_gameplay.WorldObject;
import baltorogames.system.FileManager;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class WorldMap {
    public static int m_nNrOfPiecesToDraw = 100;
    protected WorldLayer[] m_arrLayers = null;

    public int LoadFromFile(String string) {
        try {
            InputStream inputStream = FileManager.OpenFile(string);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.Load(dataInputStream);
            CGEngine.Load1(dataInputStream);
            CGEngine.Load2(dataInputStream);
        }
        catch (Exception exception) {
            Log.DEBUG_LOG(16, "WorldMap " + string + " loading error!!!");
            return 0;
        }
        return 1;
    }

    public int Load(DataInputStream dataInputStream) throws IOException {
        this.Destroy();
        TmpWorldObjectsDataBase.Clear();
        TmpWorldObjectsDataBase.Import(dataInputStream);
        this.m_arrLayers = new WorldLayer[10];
        this.m_arrLayers[0] = new WorldLayer();
        for (int i = 0; i < 10; ++i) {
            this.m_arrLayers[i] = new WorldLayer();
            this.m_arrLayers[i].Load(dataInputStream);
        }
        TmpWorldObjectsDataBase.Clear();
        return 1;
    }

    public WorldLayer GetLayer(int n) {
        return this.m_arrLayers[n];
    }

    public void Render(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this.m_arrLayers[i].Render(0, m_nNrOfPiecesToDraw);
        }
    }

    public void Render(int n, int n2, int n3, int n4) {
        for (int i = n; i <= n2; ++i) {
            this.m_arrLayers[i].Render(n3, n4);
        }
    }

    public void Destroy() {
        if (this.m_arrLayers != null) {
            for (int i = 0; i < 10; ++i) {
                if (this.m_arrLayers[i] == null) continue;
                this.m_arrLayers[i].Destroy();
                this.m_arrLayers[i] = null;
            }
            this.m_arrLayers = null;
        }
    }

    public void ActiveAllObjects() {
        for (int i = 1; i <= 4; ++i) {
            if (this.m_arrLayers == null || this.m_arrLayers[i] == null) continue;
            this.m_arrLayers[i].ActiveAllObjects();
        }
    }

    public WorldObject FindByTextureName(String string, int n) {
        if (this.m_arrLayers != null && this.m_arrLayers[n] != null) {
            return this.m_arrLayers[n].FindByTextureName(string);
        }
        return null;
    }

    public WorldObject FindObjectByCollisionID(int n) {
        for (int i = 0; i < 10; ++i) {
            WorldObject worldObject;
            if (this.m_arrLayers == null || this.m_arrLayers[i] == null || (worldObject = this.m_arrLayers[i].FindByCollisionID(n)) == null) continue;
            return worldObject;
        }
        return null;
    }
}

