/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.TmpWorldObject;
import baltorogames.project_gameplay.TmpWorldObjectsDataBase;
import baltorogames.project_gameplay.WorldObject;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public class WorldLayerPiece {
    protected Vector m_Vector = new Vector();

    public int Load(DataInputStream dataInputStream) throws IOException {
        this.Destroy();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            byte by = dataInputStream.readByte();
            TmpWorldObject tmpWorldObject = TmpWorldObjectsDataBase.GetByID(by);
            if (tmpWorldObject == null) {
                System.out.println("ERROR: Bad object ID (" + by + ")");
                continue;
            }
            WorldObject worldObject = null;
            String string = new String(tmpWorldObject.m_szTextureName);
            worldObject = new WorldObject();
            int n2 = worldObject.Load(dataInputStream, by);
            if (n2 <= 0 || worldObject == null) continue;
            this.m_Vector.addElement(worldObject);
        }
        return 1;
    }

    public int GetObjectsSize() {
        return this.m_Vector.size();
    }

    public WorldObject GetObject(int n) {
        return (WorldObject)this.m_Vector.elementAt(n);
    }

    public void RemoveObject(int n) {
        this.m_Vector.removeElementAt(n);
    }

    public void Destroy() {
        this.m_Vector.removeAllElements();
    }

    public void ActiveAllObjects() {
        int n = this.m_Vector.size();
        for (int i = 0; i < n; ++i) {
            WorldObject worldObject = (WorldObject)this.m_Vector.elementAt(i);
            worldObject.m_nActive = 1;
        }
    }

    public void Render() {
        int n = this.m_Vector.size();
        for (int i = 0; i < n; ++i) {
            WorldObject worldObject = (WorldObject)this.m_Vector.elementAt(i);
            worldObject.Render();
        }
    }

    WorldObject FindByTextureName(String string) {
        int n = this.m_Vector.size();
        for (int i = 0; i < n; ++i) {
            WorldObject worldObject = (WorldObject)this.m_Vector.elementAt(i);
            if (worldObject.m_TextureName[0] == null || worldObject.m_TextureName[0].intern() != string.intern()) continue;
            return worldObject;
        }
        return null;
    }

    WorldObject FindByCollisionID(int n) {
        int n2 = this.m_Vector.size();
        for (int i = 0; i < n2; ++i) {
            WorldObject worldObject = (WorldObject)this.m_Vector.elementAt(i);
            if (worldObject.m_nCollisionID != n) continue;
            return worldObject;
        }
        return null;
    }
}

