/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngineRenderer;
import java.util.Vector;

public class GiftScore {
    public static int[] nFrames = new int[]{0, 1, 2, 3, 2, 1, 0, 1, 2, 3, 2, 1, 0, 1, 2, 3, 2, 1, 0, 1, 2, 3, 2, 1, 0};
    public float m_fStartX;
    public float m_fStartY;
    public float m_fStopX = 10.0f;
    public float m_fStopY = 10.0f;
    public float m_fCurrentX;
    public float m_fCurrentY;
    public int m_nTime = 1000000;
    public int m_nFullTime = 300;
    public int m_nType;
    int m_nCurrentFrame;
    float m_fScale = 1.0f;
    public static CGTexture[] m_GiftTextures = null;
    public static CGTexture[] m_2SecondsTextures = null;
    static Vector m_TmpVector = null;
    static Vector m_Vector = null;

    public static void Initialize() {
        m_GiftTextures = new CGTexture[4];
        GiftScore.m_GiftTextures[0] = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/POINTS/point_1_1.png");
        GiftScore.m_GiftTextures[1] = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/POINTS/point_1_2.png");
        GiftScore.m_GiftTextures[2] = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/POINTS/point_1_3.png");
        GiftScore.m_GiftTextures[3] = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/POINTS/point_1_4.png");
        m_2SecondsTextures = new CGTexture[4];
        GiftScore.m_2SecondsTextures[0] = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/POINTS/minus2s.png");
        GiftScore.m_2SecondsTextures[1] = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/POINTS/minus2s.png");
        GiftScore.m_2SecondsTextures[2] = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/POINTS/minus2s.png");
        GiftScore.m_2SecondsTextures[3] = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/POINTS/minus2s.png");
        m_TmpVector = new Vector();
        m_Vector = new Vector();
        for (int i = 0; i < 64; ++i) {
            GiftScore giftScore = new GiftScore();
            m_TmpVector.addElement(giftScore);
        }
    }

    public static void Reset() {
        int n = m_Vector.size();
        if (n > 0) {
            for (int i = n - 1; i >= 0; --i) {
                m_TmpVector.addElement(m_Vector.elementAt(i));
            }
            m_Vector.removeAllElements();
        }
    }

    public static void NewGifts(float f, float f2, int n) {
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                GiftScore.NewGift(0.4f, f, f2, -i * 70, 0);
            }
        } else {
            GiftScore.NewGift(0.6f, f, f2, 0, 1);
        }
    }

    public static void NewGift(float f, float f2, float f3, int n, int n2) {
        int n3 = m_TmpVector.size();
        if (n3 > 0) {
            GiftScore giftScore = (GiftScore)m_TmpVector.elementAt(n3 - 1);
            m_TmpVector.removeElementAt(n3 - 1);
            giftScore.Active(f, f2, f3, n, n2);
            m_Vector.addElement(giftScore);
        }
    }

    public static void StepAll(int n) {
        int n2 = m_Vector.size();
        for (int i = n2 - 1; i >= 0; --i) {
            GiftScore giftScore = (GiftScore)m_Vector.elementAt(i);
            giftScore.Step(n);
            if (giftScore.m_nTime < 1000000) continue;
            m_Vector.removeElementAt(i);
            m_TmpVector.addElement(giftScore);
        }
    }

    public static void RenderAll() {
        int n = m_Vector.size();
        for (int i = n - 1; i >= 0; --i) {
            ((GiftScore)m_Vector.elementAt(i)).Render();
        }
    }

    public void Init() {
        this.m_nTime = -1;
    }

    public void Active(float f, float f2, float f3, int n, int n2) {
        this.m_nTime = n;
        this.m_nCurrentFrame = 0;
        this.m_nType = n2;
        if (this.m_nType == 0) {
            this.m_fStopX = 120.0f;
            this.m_fStopY = 10.0f;
            this.m_nFullTime = 300;
        } else {
            this.m_fStopX = 270.0f;
            this.m_fStopY = 10.0f;
            this.m_nFullTime = 600;
        }
        this.m_fStartX = f2;
        this.m_fStartY = f3;
        this.m_fScale = f;
    }

    public void Disactive() {
        this.m_nTime = 1000000;
    }

    public void Step(int n) {
        this.m_nTime += n;
        if (this.m_nTime < 0) {
            return;
        }
        if (this.m_nTime > this.m_nFullTime) {
            this.m_nTime = 1000000;
            return;
        }
        float f = (float)this.m_nTime / (float)this.m_nFullTime;
        this.m_fCurrentX = this.m_fStartX + f * (this.m_fStopX - this.m_fStartX);
        this.m_fCurrentY = this.m_fStartY + f * (this.m_fStopY - this.m_fStartY);
        this.m_nCurrentFrame = this.m_nTime / 50;
        this.m_nCurrentFrame %= nFrames.length;
        this.m_nCurrentFrame = nFrames[this.m_nCurrentFrame];
    }

    public void Render() {
        if (this.m_nTime < 0) {
            return;
        }
        CGEngineRenderer.RenderGiftScore(this);
    }
}

