/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGHit;
import baltorogames.project_gameplay.CGJewel;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.GiftScore;
import baltorogames.project_gameplay.WorldObject;

public class CGEngineRenderer {
    public static float m_fScreenOffsetX = 0.0f;
    public static float m_fScreenOffsetY = 0.0f;
    public static CGTexture m_BackGroundTexture = null;
    public static CGTexture m_ComboTexture = null;
    public static int timeIntervalForJewelAnim = 0;
    public static int m_nComboTime;

    public static void StartCombo(int n) {
        m_nComboTime = n;
    }

    public static void Init() {
        if (CGEngine.m_nCurrentWorld == 0) {
            m_BackGroundTexture = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/BG1/lvl1_bg.png");
        } else if (CGEngine.m_nCurrentWorld == 1) {
            m_BackGroundTexture = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/BG1/lvl2_bg.png");
        } else if (CGEngine.m_nCurrentWorld == 2) {
            m_BackGroundTexture = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/BG1/lvl3_bg.png");
        }
    }

    public static void Render() {
        Graphic2D.DrawRegion(m_BackGroundTexture, 0.0f, 0.0f, 0.0f, 0.0f, (float)ApplicationData.screenWidth, (float)ApplicationData.screenHeight, 1.0f, 1.0f);
    }

    public static void RenderHit(CGHit cGHit, float f, float f2) {
        CGTexture cGTexture = CGHit.m_HitTextures[cGHit.m_nType][cGHit.m_nCurrentFrame];
        if (cGTexture != null) {
            Graphic2D.DrawCenter(cGTexture, (int)(0.5f + f * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetX, (int)(0.5f + (f2 + m_fScreenOffsetY) * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetY);
        }
    }

    public static void RenderGiftScore(GiftScore giftScore) {
        CGTexture cGTexture = giftScore.m_nType == 0 ? GiftScore.m_GiftTextures[giftScore.m_nCurrentFrame] : GiftScore.m_2SecondsTextures[giftScore.m_nCurrentFrame];
        if (cGTexture == null) {
            return;
        }
        float f = 96.0f * giftScore.m_fScale;
        float f2 = 1.0f * CGEngine.m_fEngineScale;
        float f3 = giftScore.m_fCurrentX - CGEngine.m_fCameraPosX;
        float f4 = giftScore.m_fCurrentY - CGEngine.m_fCameraPosY;
        Graphic2D.DrawRegion(cGTexture, m_fScreenOffsetX + (f3 - f) * f2, m_fScreenOffsetY + (f4 - f) * f2, 0.0f, 0.0f, m_fScreenOffsetX + (f3 + f) * f2, m_fScreenOffsetY + (f4 + f) * f2, 1.0f, 1.0f);
    }

    public static void RenderMarker(float f, float f2) {
        float f3 = 1.0f * CGEngine.m_fEngineScale;
        if (CGEngine.m_nViewMode == 0) {
            Graphic2D.DrawRegion(CGBoard.m_MarkerTexture, m_fScreenOffsetX + (CGBoard.m_fStartX + f - CGBoard.m_fSize / 2.0f) * f3, m_fScreenOffsetY + (CGBoard.m_fStartY + f2 - CGBoard.m_fSize / 2.0f) * f3, 0.0f, 0.0f, m_fScreenOffsetX + (CGBoard.m_fStartX + f + CGBoard.m_fSize / 2.0f) * f3, m_fScreenOffsetY + (CGBoard.m_fStartY + f2 + CGBoard.m_fSize / 2.0f) * f3, 1.0f, 1.0f);
        }
    }

    public static void RenderSelectJewel(float f, float f2, int n, boolean bl) {
        int n2 = n;
        float f3 = 0.0f;
        float f4 = 1.0f * CGEngine.m_fEngineScale;
        float f5 = m_fScreenOffsetX + (CGBoard.m_fStartX + f - CGBoard.m_fSize / 2.0f) * f4;
        float f6 = m_fScreenOffsetY + (CGBoard.m_fStartY + f2 - CGBoard.m_fSize / 2.0f) * f4;
        float f7 = m_fScreenOffsetX + (CGBoard.m_fStartX + f + CGBoard.m_fSize / 2.0f) * f4;
        float f8 = m_fScreenOffsetY + (CGBoard.m_fStartY + f2 + CGBoard.m_fSize / 2.0f) * f4;
        if (n2 > 0 && bl) {
            f7 += CGBoard.m_fSize * (float)n2 * f4;
            f3 = 0.0f;
        } else if (n2 > 0 && !bl) {
            f8 += CGBoard.m_fSize * (float)n2 * f4;
            f3 = 1.57f;
            n2 += 4;
        }
        Graphic2D.DrawRegion(CGBoard.m_arrSelectTexture[n2], f5, f6, 0.0f, 0.0f, f7, f8, 1.0f, 1.0f, 0.0f);
    }

    public static void RenderJewel(CGJewel cGJewel) {
        float f = 1.0f * CGEngine.m_fEngineScale;
        if (cGJewel.isJewelAnimationPlayed && CGJewel.FIRST_TIME_ANIM && CGJewel.NUM_FRAME_ANIM_JEWEL > 1) {
            Graphic2D.DrawRegion(CGJewel.m_animTextures[cGJewel.m_nType][cGJewel.frameOfAnim], m_fScreenOffsetX + (CGBoard.m_fStartX + cGJewel.m_fX - CGBoard.m_fSize / 2.0f) * f, m_fScreenOffsetY + (CGBoard.m_fStartY + cGJewel.m_fY - CGBoard.m_fSize / 2.0f) * f, 0.0f, 0.0f, m_fScreenOffsetX + (CGBoard.m_fStartX + cGJewel.m_fX + CGBoard.m_fSize / 2.0f) * f, m_fScreenOffsetY + (CGBoard.m_fStartY + cGJewel.m_fY + CGBoard.m_fSize / 2.0f) * f, 1.0f, 1.0f);
        } else {
            Graphic2D.DrawRegion(CGJewel.m_animTextures[cGJewel.m_nType][0], m_fScreenOffsetX + (CGBoard.m_fStartX + cGJewel.m_fX - CGBoard.m_fSize / 2.0f) * f, m_fScreenOffsetY + (CGBoard.m_fStartY + cGJewel.m_fY - CGBoard.m_fSize / 2.0f) * f, 0.0f, 0.0f, m_fScreenOffsetX + (CGBoard.m_fStartX + cGJewel.m_fX + CGBoard.m_fSize / 2.0f) * f, m_fScreenOffsetY + (CGBoard.m_fStartY + cGJewel.m_fY + CGBoard.m_fSize / 2.0f) * f, 1.0f, 1.0f);
        }
    }

    public static void RenderAnimationWhenLvlStarts(CGJewel cGJewel) {
        ++cGJewel.frameOfAnim;
        if (CGEngine.m_nGameMode == 2) {
            if (cGJewel.frameOfAnim >= CGJewel.NUM_FRAME_ANIM_JEWEL) {
                cGJewel.frameOfAnim = 0;
                if (CGJewel.FIRST_TIME_ANIM && CGLevelStats.m_nSurvivalTime > 2000) {
                    CGJewel.FIRST_TIME_ANIM = false;
                }
            } else if (CGLevelStats.m_nSurvivalTime < 2000) {
                CGJewel.FIRST_TIME_ANIM = true;
            }
        } else if (CGEngine.m_nGameMode == 1) {
            if (cGJewel.frameOfAnim >= CGJewel.NUM_FRAME_ANIM_JEWEL) {
                cGJewel.frameOfAnim = 0;
                if (CGJewel.FIRST_TIME_ANIM && CGEngine.m_nCurrentLevelTimeLimit - CGEngine.m_nCurrentLevelTime / 1000 > 2) {
                    CGJewel.FIRST_TIME_ANIM = false;
                }
            } else if (CGEngine.m_nCurrentLevelTimeLimit - CGEngine.m_nCurrentLevelTime / 1000 < 2) {
                CGJewel.FIRST_TIME_ANIM = true;
            }
        }
    }

    public static void RenderRotateJewel(CGJewel cGJewel) {
        float f = 1.0f * CGEngine.m_fEngineScale;
        Graphic2D.DrawRegion(CGJewel.m_animTextures[cGJewel.m_nType][0], m_fScreenOffsetX + (CGBoard.m_fStartX + cGJewel.m_fRotateX - CGBoard.m_fSize / 2.0f) * f, m_fScreenOffsetY + (CGBoard.m_fStartY + cGJewel.m_fRotateY - CGBoard.m_fSize / 2.0f) * f, 0.0f, 0.0f, m_fScreenOffsetX + (CGBoard.m_fStartX + cGJewel.m_fRotateX + CGBoard.m_fSize / 2.0f) * f, m_fScreenOffsetY + (CGBoard.m_fStartY + cGJewel.m_fRotateY + CGBoard.m_fSize / 2.0f) * f, 1.0f, 1.0f);
    }

    public static void RenderWorldObject(WorldObject worldObject) {
        CGTexture cGTexture = worldObject.m_Texture[CGEngine.m_nViewMode];
        if (cGTexture == null) {
            return;
        }
        float f = 1.0f * CGEngine.m_fEngineScale;
        float f2 = (float)worldObject.m_fX - CGEngine.m_fCameraPosX;
        float f3 = (float)worldObject.m_fY - CGEngine.m_fCameraPosY;
        float f4 = m_fScreenOffsetX + f2 * f;
        if (f4 > (float)ApplicationData.screenWidth) {
            return;
        }
        f4 = m_fScreenOffsetX + (f2 + (float)worldObject.m_fW) * f;
        if (f4 < 0.0f) {
            return;
        }
        f4 = m_fScreenOffsetY + f3 * f;
        if (f4 > (float)ApplicationData.screenHeight) {
            return;
        }
        f4 = m_fScreenOffsetY + (f3 + (float)worldObject.m_fH) * f;
        if (f4 < 0.0f) {
            return;
        }
        if (worldObject.m_nAnimSize <= 1) {
            if (worldObject.m_nM == 1) {
                Graphic2D.DrawRegion(cGTexture, m_fScreenOffsetX + f2 * f, m_fScreenOffsetY + f3 * f, 1.0f, 0.0f, m_fScreenOffsetX + (f2 + (float)worldObject.m_fW) * f, m_fScreenOffsetY + (f3 + (float)worldObject.m_fH) * f, 0.0f, 1.0f);
            }
            if (worldObject.m_nM == 2) {
                Graphic2D.DrawRegion(cGTexture, m_fScreenOffsetX + f2 * f, m_fScreenOffsetY + f3 * f, 0.0f, 1.0f, m_fScreenOffsetX + (f2 + (float)worldObject.m_fW) * f, m_fScreenOffsetY + (f3 + (float)worldObject.m_fH) * f, 1.0f, 0.0f);
            } else if (worldObject.m_nM == 3) {
                Graphic2D.DrawRegion(cGTexture, m_fScreenOffsetX + f2 * f, m_fScreenOffsetY + f3 * f, 1.0f, 1.0f, m_fScreenOffsetX + (f2 + (float)worldObject.m_fW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (f3 + (float)worldObject.m_fH) * CGEngine.m_fEngineScale, 0.0f, 0.0f);
            } else {
                Graphic2D.DrawRegion(cGTexture, m_fScreenOffsetX + f2 * f, m_fScreenOffsetY + f3 * f, 0.0f, 0.0f, m_fScreenOffsetX + (f2 + (float)worldObject.m_fW) * f, m_fScreenOffsetY + (f3 + (float)worldObject.m_fH) * f, 1.0f, 1.0f);
            }
        } else {
            int n = 0;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 1.0f;
            float f8 = 1.0f;
            if (worldObject.m_nAnimSize > 1) {
                n = worldObject.m_nCurrentFrame;
                int n2 = n % worldObject.m_nAnimGridX;
                int n3 = n / worldObject.m_nAnimGridX;
                f5 = (float)n2 / (float)worldObject.m_nAnimGridX;
                f6 = (float)n3 / (float)worldObject.m_nAnimGridY;
                f7 = f5 + 1.0f / (float)worldObject.m_nAnimGridX;
                f8 = f6 + 1.0f / (float)worldObject.m_nAnimGridY;
            }
            if (worldObject.m_nM == 1) {
                Graphic2D.DrawRegion(cGTexture, m_fScreenOffsetX + f2 * f, m_fScreenOffsetY + f3 * f, f7, f6, m_fScreenOffsetX + (f2 + (float)worldObject.m_fW) * f, m_fScreenOffsetY + (f3 + (float)worldObject.m_fH) * f, f5, f8);
            }
            if (worldObject.m_nM == 2) {
                Graphic2D.DrawRegion(cGTexture, m_fScreenOffsetX + f2 * f, m_fScreenOffsetY + f3 * f, f5, f8, m_fScreenOffsetX + (f2 + (float)worldObject.m_fW) * f, m_fScreenOffsetY + (f3 + (float)worldObject.m_fH) * f, f7, f6);
            }
            if (worldObject.m_nM == 3) {
                Graphic2D.DrawRegion(cGTexture, m_fScreenOffsetX + f2 * f, m_fScreenOffsetY + f3 * f, f7, f8, m_fScreenOffsetX + (f2 + (float)worldObject.m_fW) * f, m_fScreenOffsetY + (f3 + (float)worldObject.m_fH) * f, f5, f6);
            } else {
                Graphic2D.DrawRegion(cGTexture, m_fScreenOffsetX + f2 * f, m_fScreenOffsetY + f3 * f, f5, f6, m_fScreenOffsetX + (f2 + (float)worldObject.m_fW) * f, m_fScreenOffsetY + (f3 + (float)worldObject.m_fH) * f, f7, f8);
            }
        }
    }
}

