/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGJewel;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.SelectModeScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class SequenceParamScreen
extends MainScreen {
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    public static int selectedWorld = 0;
    private int nStartBoxY = 0;
    private int nStopBoxY = 0;
    private int nBoxWidth = 0;
    private UIFloatingTextBox infoBox;
    private String csText;
    protected int nScore = 0;
    private String[] worldInfos = new String[]{"", "TID_INFO_STORY_W2_UNLOCK", "TID_INFO_STORY_W3_UNLOCK"};
    private boolean bAvailable = true;
    private CGTexture[] worldImages = null;

    protected void Clean() {
        if (this.worldImages != null) {
            for (int i = 0; i < 4; ++i) {
                TextureManager.DeleteTexture(this.worldImages[i]);
                this.worldImages[i] = null;
            }
        }
        this.worldImages = null;
    }

    public void onFocusBack() {
        super.onFocusBack();
        if (this.worldImages == null) {
            this.worldImages = new CGTexture[4];
            this.worldImages[0] = TextureManager.AddTexture("/menu/ico_world_1.png");
            this.worldImages[1] = TextureManager.AddTexture("/menu/ico_world_2.png");
            this.worldImages[2] = TextureManager.AddTexture("/menu/ico_world_3.png");
            this.worldImages[3] = TextureManager.AddTexture("/menu/ico_world_locked.png");
        }
    }

    public SequenceParamScreen() {
        int n;
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        selectedWorld = 0;
        this.drawTop = true;
        this.drawTitle = false;
        this.worldImages = new CGTexture[4];
        this.worldImages[0] = TextureManager.AddTexture("/menu/ico_world_1.png");
        this.worldImages[1] = TextureManager.AddTexture("/menu/ico_world_2.png");
        this.worldImages[2] = TextureManager.AddTexture("/menu/ico_world_3.png");
        this.worldImages[3] = TextureManager.AddTexture("/menu/ico_world_locked.png");
        this.bAvailable = false;
        int n2 = ApplicationData.screenWidth / 2 - this.worldImages[0].GetWidth() / 2;
        int n3 = ApplicationData.screenHeight / 2 - this.worldImages[0].GetHeight() / 2;
        int n4 = n3 - ObjectsCache.arrowLeft.GetHeight() / 2;
        int n5 = (ApplicationData.screenWidth / 2 - this.worldImages[0].GetWidth() / 2) / 2 - ObjectsCache.arrowLeft.GetWidth() / 2;
        if (n5 < 0) {
            n5 = 0;
        }
        if ((n = ApplicationData.screenWidth / 2 + this.worldImages[0].GetWidth() / 2 + (ApplicationData.screenWidth - (ApplicationData.screenWidth / 2 + this.worldImages[0].GetWidth() / 2)) / 2 - ObjectsCache.arrowLeft.GetWidth() / 2) > ApplicationData.screenWidth - ObjectsCache.arrowLeft.GetWidth()) {
            n = ApplicationData.screenWidth - ObjectsCache.arrowLeft.GetWidth();
        }
        UIAnimatedButtonH uIAnimatedButtonH = new UIAnimatedButtonH(n, n4, ObjectsCache.arrowRight, ObjectsCache.arrowRight_a, 101);
        uIAnimatedButtonH.setScreen(this);
        uIAnimatedButtonH.setAnimDir(1.0f);
        this.addButton(uIAnimatedButtonH);
        UIAnimatedButtonH uIAnimatedButtonH2 = new UIAnimatedButtonH(n5, n4, ObjectsCache.arrowLeft, ObjectsCache.arrowLeft_a, 100);
        uIAnimatedButtonH2.setScreen(this);
        uIAnimatedButtonH2.setAnimDir(-1.0f);
        this.addButton(uIAnimatedButtonH2);
        this.nStartBoxY = ApplicationData.screenHeight / 2;
        this.nStopBoxY = ApplicationData.screenHeight - ObjectsCache.menuSbBACK.GetHeight();
        this.nBoxWidth = ApplicationData.screenWidth;
        this.infoBox = new UIFloatingTextBox(false, (ApplicationData.screenWidth - this.nBoxWidth) / 2, this.nStartBoxY, this.nBoxWidth, this.nStopBoxY - this.nStartBoxY);
        this.updateAchievementInfo();
    }

    private void updateAchievementInfo() {
        this.csText = ApplicationData.getFontByID(0).encodeDynamicString(selectedWorld + 1 + "/3");
        this.infoBox.setText(ApplicationData.lp.getTranslatedString(Options.languageID, this.worldInfos[selectedWorld]));
        this.findByID(100).setVisible(selectedWorld > 0);
        this.findByID(101).setVisible(selectedWorld < 2);
        if (CGUserCareer.GetAdventureLevel() < 15 && selectedWorld == 1 || CGUserCareer.GetAdventureLevel() < 30 && selectedWorld == 2) {
            this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        } else {
            this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        }
    }

    public void autoSize() {
    }

    public void draw() {
        int n = ApplicationData.screenWidth / 2 - this.worldImages[0].GetWidth() / 2;
        int n2 = ApplicationData.screenHeight / 2 - this.worldImages[0].GetHeight();
        if (CGUserCareer.GetAdventureLevel() < 15 && selectedWorld == 1 || CGUserCareer.GetAdventureLevel() < 30 && selectedWorld == 2) {
            Graphic2D.DrawImage(this.worldImages[3], n, n2, 20);
            this.bAvailable = false;
            this.infoBox.draw();
        } else {
            Graphic2D.DrawImage(this.worldImages[selectedWorld], n, n2, 20);
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("" + CGUserCareer.m_nBestSequenceScore[selectedWorld]), ApplicationData.screenWidth >> 1, n2 + this.worldImages[selectedWorld].GetHeight(), 17, 0);
            this.bAvailable = true;
        }
        Utils.drawString(this.csText, ApplicationData.screenWidth >> 1, n2 - 2 * ApplicationData.getFontByID(0).getFontHeight(), 3, 0);
    }

    public boolean rightSoftButton() {
        this.Clean();
        if (this.parentScreen != null) {
            this.readyForClose = true;
            return true;
        }
        this.parentScreen = new SelectModeScreen();
        this.readyForClose = true;
        return true;
    }

    public boolean leftSoftButton() {
        if (this.bAvailable) {
            CGEngine.m_nGameMode = 3;
            CGEngine.m_nCurrentWorld = selectedWorld;
            switch (CGEngine.m_nCurrentWorld) {
                case 0: {
                    CGEngine.m_nMaxSeqMoves = 30;
                    CGJewel.NUM_JEWEL_COLORS = 5;
                    CGBoard.m_nNrofTypes = 5;
                    break;
                }
                case 1: {
                    CGEngine.m_nMaxSeqMoves = 60;
                    CGJewel.NUM_JEWEL_COLORS = 6;
                    CGBoard.m_nNrofTypes = 6;
                    break;
                }
                case 2: {
                    CGEngine.m_nMaxSeqMoves = 120;
                    CGJewel.NUM_JEWEL_COLORS = 7;
                    CGBoard.m_nNrofTypes = 7;
                    break;
                }
            }
            String string = "/level_" + CGEngine.m_nCurrentWorld + ".lrs";
            ApplicationData.getGame().startLoading(string);
            ApplicationData.getGame().stepLoading(string);
            ApplicationData.getGame().stepLoading(string);
            ApplicationData.getGame().stepLoading(string);
            ApplicationData.getGame().stepLoading(string);
            ApplicationData.getGame().endLoading(string);
            ApplicationData.generalGameMode = 4;
            CGEngine.m_bGameActive = true;
            this.readyForClose = true;
            return true;
        }
        return false;
    }

    public boolean selectLeftAction() {
        UIButton uIButton = this.findByID(100);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton uIButton = this.findByID(101);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean onRightAction() {
        if (++selectedWorld >= 2) {
            selectedWorld = 2;
        }
        this.updateAchievementInfo();
        return true;
    }

    public boolean onLeftAction() {
        if (--selectedWorld < 0) {
            selectedWorld = 0;
        }
        this.updateAchievementInfo();
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (super.actionSoftButton(n, bl)) {
            return true;
        }
        if (!bl) {
            this.unselectAllButtons();
            if (n == 100) {
                this.onLeftAction();
                return true;
            }
            if (n == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public void drawWindowBackground() {
        int n = ObjectsCache.backgroundElements[0].GetWidth();
        int n2 = ApplicationData.screenWidth / n;
        for (int i = 0; i <= n2; ++i) {
            Graphic2D.DrawImage(ObjectsCache.backgroundElements[0], i * n, 0, 20);
        }
    }
}

