/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.RandSync;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.TmpWorldObject;
import baltorogames.project_gameplay.TmpWorldObjectsDataBase;
import java.io.DataInputStream;
import java.io.IOException;

public class WorldObject {
    public int m_fX;
    public int m_fY;
    public int m_fH;
    public int m_fW;
    public int m_nM;
    public int m_nAnimSize = 1;
    public int m_nAnimGridX = 1;
    public int m_nAnimGridY = 1;
    public int m_nAnimFrameTime = 40;
    public int m_nAnimStopDelay = 0;
    public int m_nStartFrame = 0;
    public int m_nActive = 1;
    public int m_nAnimDir = 0;
    public char m_bIsBusStopH = '\u0000';
    public char m_bIsBusStopV = '\u0000';
    public CGTexture[] m_Texture;
    public String[] m_TextureName;
    public int m_nTextureFrameWidth;
    public int m_nTextureFrameHeight;
    public int m_nCurrentTime = 0;
    public int m_nCurrentFrame = 0;
    public int m_nStayOnLastFrame = 0;
    public float m_fMoveByX = 0.0f;
    public int m_nCollisionID = -1;
    public int m_nHideCollisionObject = 0;
    public int m_nStartTime = -1;

    public int Load(DataInputStream dataInputStream, int n) throws IOException {
        int n2 = 0;
        TmpWorldObject tmpWorldObject = TmpWorldObjectsDataBase.GetByID(n);
        if (tmpWorldObject == null) {
            System.out.println("ERROR: Bad object ID (" + n + ")");
        }
        this.m_fX = dataInputStream.readInt();
        this.m_fY = dataInputStream.readInt();
        this.m_TextureName = new String[2];
        this.m_TextureName[0] = tmpWorldObject.m_szTextureName;
        this.m_TextureName[1] = tmpWorldObject.m_szTexture2Name;
        this.m_fW = tmpWorldObject.m_fW;
        this.m_fH = tmpWorldObject.m_fH;
        this.m_nM = tmpWorldObject.m_nMirrored;
        this.m_nAnimSize = tmpWorldObject.m_nAnimSize;
        this.m_nAnimGridX = tmpWorldObject.m_nAnimGridX;
        this.m_nAnimGridY = tmpWorldObject.m_nAnimGridY;
        this.m_nAnimFrameTime = tmpWorldObject.m_nAnimFrameTime;
        this.m_nAnimStopDelay = tmpWorldObject.m_nAnimStopDelay;
        this.m_nStartFrame = 0;
        if (tmpWorldObject.m_nStartFrame > 0) {
            this.m_nStartFrame = RandSync.nextInt(this.m_nAnimSize);
        }
        this.m_fMoveByX = tmpWorldObject.m_fMoveByX;
        this.m_nCollisionID = tmpWorldObject.m_nCollisionID;
        this.m_nHideCollisionObject = tmpWorldObject.m_nHideCollisionObject;
        this.m_nStayOnLastFrame = tmpWorldObject.m_nStayOnLastFrame;
        this.m_Texture = new CGTexture[2];
        String string = "/gameplay/" + this.m_TextureName[0];
        this.m_Texture[0] = TextureManager.CreateFilteredTexture(string);
        string = "/gameplay/" + this.m_TextureName[1];
        this.m_Texture[1] = TextureManager.CreateFilteredTexture(string);
        this.m_nM = this.m_nM != 0 ? (this.m_nM == 1 ? 2 : (this.m_nM == 2 ? 1 : 3)) : 0;
        if (n2 > 0 && this.m_Texture == null) {
            System.out.println("(nRecquireTexture>0 && m_Texture==null) [" + this.m_TextureName + "]");
            return 0;
        }
        this.m_nCurrentTime = RandSync.nextInt() % 1000;
        if (this.m_Texture[0] != null) {
            this.m_nTextureFrameWidth = this.m_Texture[0].GetWidth() / this.m_nAnimGridX;
            this.m_nTextureFrameHeight = this.m_Texture[0].GetHeight() / this.m_nAnimGridY;
        } else if (this.m_Texture[1] != null) {
            this.m_nTextureFrameWidth = this.m_Texture[1].GetWidth() / this.m_nAnimGridX;
            this.m_nTextureFrameHeight = this.m_Texture[1].GetHeight() / this.m_nAnimGridY;
        }
        if (this.m_TextureName[0].equalsIgnoreCase("bus_stop_1.png") || this.m_TextureName[1].equalsIgnoreCase("bus_stop_1.png") || this.m_TextureName[0].equalsIgnoreCase("bus_stop_1_s.png") || this.m_TextureName[1].equalsIgnoreCase("bus_stop_1_s.png")) {
            this.m_bIsBusStopH = '\u0001';
        }
        if (this.m_TextureName[0].equalsIgnoreCase("bus_stop_2.png") || this.m_TextureName[1].equalsIgnoreCase("bus_stop_2.png") || this.m_TextureName[0].equalsIgnoreCase("bus_stop_2_s.png") || this.m_TextureName[1].equalsIgnoreCase("bus_stop_2_s.png")) {
            this.m_bIsBusStopV = '\u0001';
        }
        if (this.m_TextureName[0].equalsIgnoreCase("bus_stop_1_city.png") || this.m_TextureName[1].equalsIgnoreCase("bus_stop_1_city.png")) {
            this.m_bIsBusStopH = (char)2;
        }
        if (this.m_TextureName[0].equalsIgnoreCase("bus_stop_2_city.png") || this.m_TextureName[1].equalsIgnoreCase("bus_stop_2_city.png")) {
            this.m_bIsBusStopV = (char)2;
        }
        return 1;
    }

    public void Render() {
        if (this.m_fMoveByX != 0.0f) {
            float f = this.m_fMoveByX * (float)CGEngine.m_nUpdateDeltaTime / 1000.0f;
            this.m_fX = (int)((float)this.m_fX + f);
            if (f > 0.0f && this.m_fX > 580) {
                this.m_fX = -this.m_fW;
            } else if (f < 0.0f && this.m_fX < -this.m_fW - 100) {
                this.m_fX = 580;
            }
        }
        if (this.m_nAnimSize > 1) {
            if (this.m_nCollisionID >= 0) {
                if (this.m_nStartTime < 0) {
                    this.m_nCurrentFrame = 0;
                    CGEngineRenderer.RenderWorldObject(this);
                } else {
                    this.m_nStartTime += CGEngine.m_nUpdateDeltaTime;
                    this.m_nCurrentFrame = this.m_nStartTime / this.m_nAnimFrameTime;
                    if (this.m_nCurrentFrame < this.m_nAnimSize) {
                        CGEngineRenderer.RenderWorldObject(this);
                    } else if (this.m_nStayOnLastFrame == 0) {
                        this.m_nCurrentFrame = 0;
                        this.m_nStartTime = -1;
                        CGEngineRenderer.RenderWorldObject(this);
                    } else {
                        this.m_nCurrentFrame = this.m_nAnimSize - 1;
                        CGEngineRenderer.RenderWorldObject(this);
                    }
                }
            } else {
                this.m_nCurrentTime += CGEngine.m_nUpdateDeltaTime;
                this.m_nCurrentFrame = this.m_nCurrentTime / this.m_nAnimFrameTime;
                this.m_nCurrentFrame += this.m_nStartFrame;
                this.m_nCurrentFrame %= this.m_nAnimSize + this.m_nAnimStopDelay;
                if (this.m_nCurrentFrame < this.m_nAnimSize) {
                    CGEngineRenderer.RenderWorldObject(this);
                }
            }
        } else {
            CGEngineRenderer.RenderWorldObject(this);
        }
    }

    public boolean GetHideCollisionObject() {
        return this.m_nHideCollisionObject > 0;
    }

    public void StartOneAnim() {
        if (this.m_nStayOnLastFrame > 0 && this.m_nCurrentFrame > 0) {
            return;
        }
        this.m_nStartTime = 0;
    }
}

