/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.system;

import baltorogames.core.Utils;
import baltorogames.system.HttpRequestResultListener;
import baltorogames.system.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class HttpManager {
    public static String urlEncoder(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        StringBuffer sb = new StringBuffer(s.length() * 3);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '&') {
                sb.append("&");
                continue;
            }
            if (c == ' ') {
                sb.append('+');
                continue;
            }
            if (c >= ',' && c <= ';' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '?') {
                sb.append(c);
                continue;
            }
            sb.append('%');
            if (c > '\u000f') {
                sb.append(Integer.toHexString(c));
                continue;
            }
            sb.append("0" + Integer.toHexString(c));
        }
        return sb.toString();
    }

    public static String toEncoded(Vector parameters, Vector values) {
        String encodedParameters = "";
        for (int i = 0; i < parameters.size(); ++i) {
            if (i > 0) {
                encodedParameters = encodedParameters + "&";
            }
            encodedParameters = encodedParameters + (String)parameters.elementAt(i);
            encodedParameters = encodedParameters + "=";
            encodedParameters = encodedParameters + Utils.urlEncoder((String)values.elementAt(i));
        }
        return encodedParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makePostRequest(String sessionID, Vector parameters, Vector values, String url, String method, HttpRequestResultListener listener) throws IOException {
        HttpConnection c = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            String s;
            c = (HttpConnection)Connector.open((String)(url + method));
            String encodedData = HttpManager.toEncoded(parameters, values);
            c.setRequestMethod("POST");
            c.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            c.setRequestProperty("Content-Length", "" + encodedData.length());
            c.setRequestProperty("User-Agent", "Profile/MIDP-2.0 Configuration/CLDC-1.1");
            c.setRequestProperty("Cookie", sessionID);
            os = c.openOutputStream();
            os.write(encodedData.getBytes());
            int rc = c.getResponseCode();
            if (rc != 200) {
                throw new IOException("HTTP response code: " + rc);
            }
            is = c.openInputStream();
            HttpResponse response = new HttpResponse(c.getType());
            if (!response.contentType.startsWith("text/plain")) {
                throw new IOException("Not supported content-type: " + response.contentType);
            }
            response.textData = HttpManager.readString(c, is);
            response.sessionID = "";
            for (int i = 0; i < 100 && (s = c.getHeaderFieldKey(i)) != null; ++i) {
                response.sessionID = response.sessionID + s;
            }
            listener.OnHttpResultAvailable(response);
        }
        catch (ClassCastException e) {
            listener.OnHttpError("Class Cast Exception");
            throw new IllegalArgumentException("Not an HTTP URL");
        }
        catch (IOException e) {
            e.printStackTrace();
            listener.OnHttpError("IOException");
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            listener.OnHttpError(e.toString());
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            if (c != null) {
                c.close();
            }
        }
        return null;
    }

    private static String readString(HttpConnection c, InputStream is) throws IOException {
        int len = (int)c.getLength();
        if (len > 0) {
            int bytesread;
            int actual = 0;
            byte[] data = new byte[len];
            for (bytesread = 0; bytesread != len && actual != -1; bytesread += actual) {
                actual = is.read(data, bytesread, len - bytesread);
            }
            return new String(data, 0, bytesread);
        }
        return null;
    }
}

