/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGHit;
import baltorogames.project_gameplay.CGJewel;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.GiftScore;
import baltorogames.project_gameplay.WorldObject;

public class CGEngineRenderer {
    public static float m_fScreenOffsetX = 0.0f;
    public static float m_fScreenOffsetY = 0.0f;
    public static CGTexture m_BackGroundTexture = null;
    public static CGTexture m_ComboTexture = null;
    public static int timeIntervalForJewelAnim = 0;
    public static int m_nComboTime;

    public static void StartCombo(int nTime) {
        m_nComboTime = nTime;
    }

    public static void Init() {
        if (CGEngine.m_nCurrentWorld == 0) {
            m_BackGroundTexture = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/BG1/lvl1_bg.png");
        } else if (CGEngine.m_nCurrentWorld == 1) {
            m_BackGroundTexture = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/BG1/lvl2_bg.png");
        } else if (CGEngine.m_nCurrentWorld == 2) {
            m_BackGroundTexture = TextureManager.CreateFilteredTexture("/gameplay/NORMALOBJECTS/BG1/lvl3_bg.png");
        }
    }

    public static void Render() {
        Graphic2D.DrawRegion(m_BackGroundTexture, 0.0f, 0.0f, 0.0f, 0.0f, (float)ApplicationData.screenWidth, (float)ApplicationData.screenHeight, 1.0f, 1.0f);
    }

    public static void RenderHit(CGHit hit, float x, float y) {
        CGTexture frame = CGHit.m_HitTextures[hit.m_nType][hit.m_nCurrentFrame];
        if (frame != null) {
            Graphic2D.DrawCenter(frame, (int)(0.5f + x * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetX, (int)(0.5f + (y + m_fScreenOffsetY) * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetY);
        }
    }

    public static void RenderGiftScore(GiftScore b) {
        CGTexture t = b.m_nType == 0 ? GiftScore.m_GiftTextures[b.m_nCurrentFrame] : GiftScore.m_2SecondsTextures[b.m_nCurrentFrame];
        if (t == null) {
            return;
        }
        float fHalfSize = 96.0f * b.m_fScale;
        float fViewModeScale = 1.0f * CGEngine.m_fEngineScale;
        float fX = b.m_fCurrentX - CGEngine.m_fCameraPosX;
        float fY = b.m_fCurrentY - CGEngine.m_fCameraPosY;
        Graphic2D.DrawRegion(t, m_fScreenOffsetX + (fX - fHalfSize) * fViewModeScale, m_fScreenOffsetY + (fY - fHalfSize) * fViewModeScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + fHalfSize) * fViewModeScale, m_fScreenOffsetY + (fY + fHalfSize) * fViewModeScale, 1.0f, 1.0f);
    }

    public static void RenderMarker(float fX, float fY) {
        float fViewModeScale = 1.0f * CGEngine.m_fEngineScale;
        if (CGEngine.m_nViewMode == 0) {
            Graphic2D.DrawRegion(CGBoard.m_MarkerTexture, m_fScreenOffsetX + (CGBoard.m_fStartX + fX - CGBoard.m_fSize / 2.0f) * fViewModeScale, m_fScreenOffsetY + (CGBoard.m_fStartY + fY - CGBoard.m_fSize / 2.0f) * fViewModeScale, 0.0f, 0.0f, m_fScreenOffsetX + (CGBoard.m_fStartX + fX + CGBoard.m_fSize / 2.0f) * fViewModeScale, m_fScreenOffsetY + (CGBoard.m_fStartY + fY + CGBoard.m_fSize / 2.0f) * fViewModeScale, 1.0f, 1.0f);
        }
    }

    public static void RenderSelectJewel(float fX1, float fY1, int selectedJewels, boolean horizontal) {
        int i = selectedJewels;
        float angle = 0.0f;
        float fViewModeScale = 1.0f * CGEngine.m_fEngineScale;
        float X1 = m_fScreenOffsetX + (CGBoard.m_fStartX + fX1 - CGBoard.m_fSize / 2.0f) * fViewModeScale;
        float Y1 = m_fScreenOffsetY + (CGBoard.m_fStartY + fY1 - CGBoard.m_fSize / 2.0f) * fViewModeScale;
        float X2 = m_fScreenOffsetX + (CGBoard.m_fStartX + fX1 + CGBoard.m_fSize / 2.0f) * fViewModeScale;
        float Y2 = m_fScreenOffsetY + (CGBoard.m_fStartY + fY1 + CGBoard.m_fSize / 2.0f) * fViewModeScale;
        if (i > 0 && horizontal) {
            X2 += CGBoard.m_fSize * (float)i * fViewModeScale;
            angle = 0.0f;
        } else if (i > 0 && !horizontal) {
            Y2 += CGBoard.m_fSize * (float)i * fViewModeScale;
            angle = 1.57f;
            i += 4;
        }
        Graphic2D.DrawRegion(CGBoard.m_arrSelectTexture[i], X1, Y1, 0.0f, 0.0f, X2, Y2, 1.0f, 1.0f, 0.0f);
    }

    public static void RenderJewel(CGJewel j) {
        float fViewModeScale = 1.0f * CGEngine.m_fEngineScale;
        if (j.isJewelAnimationPlayed && CGJewel.FIRST_TIME_ANIM && CGJewel.NUM_FRAME_ANIM_JEWEL > 1) {
            Graphic2D.DrawRegion(CGJewel.m_animTextures[j.m_nType][j.frameOfAnim], m_fScreenOffsetX + (CGBoard.m_fStartX + j.m_fX - CGBoard.m_fSize / 2.0f) * fViewModeScale, m_fScreenOffsetY + (CGBoard.m_fStartY + j.m_fY - CGBoard.m_fSize / 2.0f) * fViewModeScale, 0.0f, 0.0f, m_fScreenOffsetX + (CGBoard.m_fStartX + j.m_fX + CGBoard.m_fSize / 2.0f) * fViewModeScale, m_fScreenOffsetY + (CGBoard.m_fStartY + j.m_fY + CGBoard.m_fSize / 2.0f) * fViewModeScale, 1.0f, 1.0f);
        } else {
            Graphic2D.DrawRegion(CGJewel.m_animTextures[j.m_nType][0], m_fScreenOffsetX + (CGBoard.m_fStartX + j.m_fX - CGBoard.m_fSize / 2.0f) * fViewModeScale, m_fScreenOffsetY + (CGBoard.m_fStartY + j.m_fY - CGBoard.m_fSize / 2.0f) * fViewModeScale, 0.0f, 0.0f, m_fScreenOffsetX + (CGBoard.m_fStartX + j.m_fX + CGBoard.m_fSize / 2.0f) * fViewModeScale, m_fScreenOffsetY + (CGBoard.m_fStartY + j.m_fY + CGBoard.m_fSize / 2.0f) * fViewModeScale, 1.0f, 1.0f);
        }
    }

    public static void RenderAnimationWhenLvlStarts(CGJewel j) {
        ++j.frameOfAnim;
        if (CGEngine.m_nGameMode == 2) {
            if (j.frameOfAnim >= CGJewel.NUM_FRAME_ANIM_JEWEL) {
                j.frameOfAnim = 0;
                if (CGJewel.FIRST_TIME_ANIM && CGLevelStats.m_nSurvivalTime > 2000) {
                    CGJewel.FIRST_TIME_ANIM = false;
                }
            } else if (CGLevelStats.m_nSurvivalTime < 2000) {
                CGJewel.FIRST_TIME_ANIM = true;
            }
        } else if (CGEngine.m_nGameMode == 1) {
            if (j.frameOfAnim >= CGJewel.NUM_FRAME_ANIM_JEWEL) {
                j.frameOfAnim = 0;
                if (CGJewel.FIRST_TIME_ANIM && CGEngine.m_nCurrentLevelTimeLimit - CGEngine.m_nCurrentLevelTime / 1000 > 2) {
                    CGJewel.FIRST_TIME_ANIM = false;
                }
            } else if (CGEngine.m_nCurrentLevelTimeLimit - CGEngine.m_nCurrentLevelTime / 1000 < 2) {
                CGJewel.FIRST_TIME_ANIM = true;
            }
        }
    }

    public static void RenderRotateJewel(CGJewel j) {
        float fViewModeScale = 1.0f * CGEngine.m_fEngineScale;
        Graphic2D.DrawRegion(CGJewel.m_animTextures[j.m_nType][0], m_fScreenOffsetX + (CGBoard.m_fStartX + j.m_fRotateX - CGBoard.m_fSize / 2.0f) * fViewModeScale, m_fScreenOffsetY + (CGBoard.m_fStartY + j.m_fRotateY - CGBoard.m_fSize / 2.0f) * fViewModeScale, 0.0f, 0.0f, m_fScreenOffsetX + (CGBoard.m_fStartX + j.m_fRotateX + CGBoard.m_fSize / 2.0f) * fViewModeScale, m_fScreenOffsetY + (CGBoard.m_fStartY + j.m_fRotateY + CGBoard.m_fSize / 2.0f) * fViewModeScale, 1.0f, 1.0f);
    }

    public static void RenderWorldObject(WorldObject w) {
        CGTexture t = w.m_Texture[CGEngine.m_nViewMode];
        if (t == null) {
            return;
        }
        float fViewModeScale = 1.0f * CGEngine.m_fEngineScale;
        float fX = (float)w.m_fX - CGEngine.m_fCameraPosX;
        float fY = (float)w.m_fY - CGEngine.m_fCameraPosY;
        float fF = m_fScreenOffsetX + fX * fViewModeScale;
        if (fF > (float)ApplicationData.screenWidth) {
            return;
        }
        fF = m_fScreenOffsetX + (fX + (float)w.m_fW) * fViewModeScale;
        if (fF < 0.0f) {
            return;
        }
        fF = m_fScreenOffsetY + fY * fViewModeScale;
        if (fF > (float)ApplicationData.screenHeight) {
            return;
        }
        fF = m_fScreenOffsetY + (fY + (float)w.m_fH) * fViewModeScale;
        if (fF < 0.0f) {
            return;
        }
        if (w.m_nAnimSize <= 1) {
            if (w.m_nM == 1) {
                Graphic2D.DrawRegion(t, m_fScreenOffsetX + fX * fViewModeScale, m_fScreenOffsetY + fY * fViewModeScale, 1.0f, 0.0f, m_fScreenOffsetX + (fX + (float)w.m_fW) * fViewModeScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * fViewModeScale, 0.0f, 1.0f);
            }
            if (w.m_nM == 2) {
                Graphic2D.DrawRegion(t, m_fScreenOffsetX + fX * fViewModeScale, m_fScreenOffsetY + fY * fViewModeScale, 0.0f, 1.0f, m_fScreenOffsetX + (fX + (float)w.m_fW) * fViewModeScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * fViewModeScale, 1.0f, 0.0f);
            } else if (w.m_nM == 3) {
                Graphic2D.DrawRegion(t, m_fScreenOffsetX + fX * fViewModeScale, m_fScreenOffsetY + fY * fViewModeScale, 1.0f, 1.0f, m_fScreenOffsetX + (fX + (float)w.m_fW) * CGEngine.m_fEngineScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * CGEngine.m_fEngineScale, 0.0f, 0.0f);
            } else {
                Graphic2D.DrawRegion(t, m_fScreenOffsetX + fX * fViewModeScale, m_fScreenOffsetY + fY * fViewModeScale, 0.0f, 0.0f, m_fScreenOffsetX + (fX + (float)w.m_fW) * fViewModeScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * fViewModeScale, 1.0f, 1.0f);
            }
        } else {
            int nCurrentFrame = 0;
            float u1 = 0.0f;
            float v1 = 0.0f;
            float u2 = 1.0f;
            float v2 = 1.0f;
            if (w.m_nAnimSize > 1) {
                nCurrentFrame = w.m_nCurrentFrame;
                int nX = nCurrentFrame % w.m_nAnimGridX;
                int nY = nCurrentFrame / w.m_nAnimGridX;
                u1 = (float)nX / (float)w.m_nAnimGridX;
                v1 = (float)nY / (float)w.m_nAnimGridY;
                u2 = u1 + 1.0f / (float)w.m_nAnimGridX;
                v2 = v1 + 1.0f / (float)w.m_nAnimGridY;
            }
            if (w.m_nM == 1) {
                Graphic2D.DrawRegion(t, m_fScreenOffsetX + fX * fViewModeScale, m_fScreenOffsetY + fY * fViewModeScale, u2, v1, m_fScreenOffsetX + (fX + (float)w.m_fW) * fViewModeScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * fViewModeScale, u1, v2);
            }
            if (w.m_nM == 2) {
                Graphic2D.DrawRegion(t, m_fScreenOffsetX + fX * fViewModeScale, m_fScreenOffsetY + fY * fViewModeScale, u1, v2, m_fScreenOffsetX + (fX + (float)w.m_fW) * fViewModeScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * fViewModeScale, u2, v1);
            }
            if (w.m_nM == 3) {
                Graphic2D.DrawRegion(t, m_fScreenOffsetX + fX * fViewModeScale, m_fScreenOffsetY + fY * fViewModeScale, u2, v2, m_fScreenOffsetX + (fX + (float)w.m_fW) * fViewModeScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * fViewModeScale, u1, v1);
            } else {
                Graphic2D.DrawRegion(t, m_fScreenOffsetX + fX * fViewModeScale, m_fScreenOffsetY + fY * fViewModeScale, u1, v1, m_fScreenOffsetX + (fX + (float)w.m_fW) * fViewModeScale, m_fScreenOffsetY + (fY + (float)w.m_fH) * fViewModeScale, u2, v2);
            }
        }
    }
}

