/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core_gui.UIFloatingTextBoxEx;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.TutorialScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class TutorialThirdScreen
extends MainScreen {
    private int m_nFrameDelay = 0;
    private int FontHeight = ApplicationData.defaultFont.getFontHeight();
    CGTexture[] firstTutorialFrames = new CGTexture[6];
    UIFloatingTextBoxEx textBox;
    String tutorialInfo = new String();

    public TutorialThirdScreen() {
        CGUserCareer.isSurvivalTutorialOn = false;
        this.loadImagesForTutorial();
        this.tutorialInfo = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TUT_SCREEN_3");
        this.textBox = new UIFloatingTextBoxEx(true, 0, ApplicationData.screenHeight / 3 * 2, ApplicationData.screenWidth, ApplicationData.screenHeight / 3 - ObjectsCache.menuSbOK.GetHeight());
        this.textBox.setText(this.tutorialInfo);
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
    }

    public void draw() {
        this.drawWindowBackground();
        Graphic2D.DrawImage(this.firstTutorialFrames[this.m_nFrameDelay], ApplicationData.screenWidth / 2, 0, 17);
        this.textBox.draw();
    }

    public void onUpdate(float deltaTime) {
        super.onUpdate(deltaTime);
        this.textBox.onUpdate(deltaTime);
        this.m_nFrameDelay = (int)(this.getLifeTime() * 1000.0f) / 400;
        this.m_nFrameDelay %= 6;
    }

    public void drawWindowBackground() {
        this.drawTitle = false;
        this.drawBottom = false;
        int backgroundTileWidth = ObjectsCache.backgroundElements[0].GetWidth();
        int numTilesX = ApplicationData.screenWidth / backgroundTileWidth;
        for (int x = 0; x <= numTilesX; ++x) {
            Graphic2D.DrawImage(ObjectsCache.backgroundElements[0], x * backgroundTileWidth, 0, 20);
        }
    }

    public void loadImagesForTutorial() {
        for (int i = 0; i < this.firstTutorialFrames.length; ++i) {
            this.firstTutorialFrames[i] = TextureManager.AddTexture("/menu/tutorial/tut3_" + (i + 1) + ".png");
        }
    }

    public boolean rightSoftButton() {
        UIScreen.SetCurrentScreen(new TutorialScreen());
        return true;
    }

    public boolean leftSoftButton() {
        if (CGEngine.m_nGameMode == 2) {
            CGSoundSystem.Play(2, false);
            String fileName = "/level.lrs";
            ApplicationData.getGame().startLoading(fileName);
            ApplicationData.getGame().stepLoading(fileName);
            ApplicationData.getGame().stepLoading(fileName);
            ApplicationData.getGame().stepLoading(fileName);
            ApplicationData.getGame().stepLoading(fileName);
            ApplicationData.getGame().endLoading(fileName);
            ApplicationData.generalGameMode = 4;
            CGEngine.m_bGameActive = true;
            this.readyForClose = true;
        }
        return true;
    }
}

