/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.KeyCommand;
import baltorogames.core.Log;
import baltorogames.core.RandSync;
import baltorogames.core.TouchCommand;
import baltorogames.core_gui.UIScreen;
import baltorogames.gameplay.Game;
import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.AchievementPopup;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gameplay.WorldMap;
import baltorogames.project_gui.HudScreen;
import baltorogames.system.FileManager;
import java.io.DataInputStream;
import java.io.InputStream;

public class MyGame
extends Game {
    public WorldMap m_WorldMap = null;
    protected DataInputStream m_dis = null;
    public int m_nLoadingStepNr = 0;
    public int m_nLastTouchX = -1;
    public int m_nLastTouchY = -1;
    public int m_nLastFlickX = -1;
    public int m_nLastFlickY = -1;
    public static final int NUM_WAVES = 10;

    public int init() {
        CGUserCareer.Reset();
        CGUserCareer.Load();
        CGAchievements.Load();
        CGDynamicObj.Initialize();
        CGDynamicObj.SetGlobalScale(30.0f);
        AchievementPopup.Init();
        RandSync.Init();
        RandSync.SetStartValue((int)System.currentTimeMillis() % 1000);
        return CGEngine.Init();
    }

    public void destroy() {
        CGDynamicObj.Uninitialize();
        CGUserCareer.Save();
        CGEngine.Destroy();
    }

    public int startLoading(String fileName) {
        CGEngineRenderer.Init();
        CGBoard.Initialize();
        this.m_dis = null;
        this.m_nLoadingStepNr = 0;
        return 1;
    }

    public int stepLoading(String fileName) {
        try {
            if (this.m_nLoadingStepNr == 0) {
                InputStream is = null;
                is = null;
                if (is == null) {
                    is = FileManager.OpenFile(fileName);
                }
                if (is == null) {
                    System.out.println("ERROR WHILE READING LEVEL " + fileName + " !!!!");
                    return 0;
                }
                this.m_dis = new DataInputStream(is);
                this.m_nLoadingStepNr = 1;
            } else if (this.m_nLoadingStepNr == 1) {
                System.out.println("START READING LEVEL " + fileName + " 1");
                if (this.m_dis != null) {
                    this.m_WorldMap = new WorldMap();
                    this.m_WorldMap.Load(this.m_dis);
                    System.out.println("START READING LEVEL " + fileName + " 2");
                }
                this.m_nLoadingStepNr = 2;
            } else if (this.m_nLoadingStepNr == 2) {
                if (this.m_dis != null) {
                    CGEngine.Load1(this.m_dis);
                }
                this.m_nLoadingStepNr = 3;
            } else if (this.m_nLoadingStepNr == 3) {
                if (this.m_dis != null) {
                    CGEngine.Load2(this.m_dis);
                }
                this.m_nLoadingStepNr = 4;
            }
            return 1;
        }
        catch (Exception e) {
            Log.DEBUG_LOG(16, "Engine " + fileName + " loading error!!!");
            return 0;
        }
    }

    public int endLoading(String fileName) {
        UIScreen.SetNextScreen(new HudScreen());
        ApplicationData.generalGameMode = 4;
        ApplicationData.PlayMusicInGame();
        CGEngine.m_nTouchActive = false;
        CGEngine.m_fTouchX = -1000000.0f;
        CGEngine.m_fTouchY = -1000000.0f;
        return 1;
    }

    public void updateLogic(long deltaTimeInMs) {
        CGEngine.Update((int)deltaTimeInMs);
    }

    public void drawGamePlay() {
        CGEngineRenderer.Render();
        if (this.m_WorldMap != null) {
            this.m_WorldMap.Render(1, 9, 0, 100);
        }
        CGEngine.Render();
    }

    public void processTouchCommand(TouchCommand cmd) {
        if (CGEngine.m_bGameActive) {
            if (cmd.onPressed == 1 || cmd.onPressed == 3) {
                float fViewModeScale = 1.0f * CGEngine.m_fEngineScale;
                float fX = ((float)cmd.areaX - CGEngineRenderer.m_fScreenOffsetX) / fViewModeScale;
                float fY = ((float)cmd.areaY - CGEngineRenderer.m_fScreenOffsetY) / fViewModeScale;
                CGEngine.m_nTouchActive = true;
                CGEngine.m_fTouchX = fX;
                CGEngine.m_fTouchY = fY;
                if (CGEngine.m_Board.IsReady()) {
                    CGEngine.m_StartSelectPointX = fX - CGBoard.m_fStartX;
                    CGEngine.m_StartSelectPointY = fY - CGBoard.m_fStartY;
                    if (!(CGEngine.m_StartSelectPointX > 0.0f && CGEngine.m_StartSelectPointX < 5.0f * CGBoard.m_fSize && CGEngine.m_StartSelectPointY > 0.0f && CGEngine.m_StartSelectPointY < 5.0f * CGBoard.m_fSize)) {
                        CGEngine.m_StartSelectPointX = -1000000.0f;
                        CGEngine.m_StartSelectPointY = -1000000.0f;
                    }
                    CGEngine.m_CurrentSelectPointX = CGEngine.m_StartSelectPointX;
                    CGEngine.m_CurrentSelectPointY = CGEngine.m_StartSelectPointY;
                } else {
                    CGEngine.m_StartSelectPointX = -1000000.0f;
                    CGEngine.m_StartSelectPointY = -1000000.0f;
                }
            } else if (cmd.onPressed == 2) {
                float fViewModeScale = 1.0f * CGEngine.m_fEngineScale;
                float fX = ((float)cmd.areaX - CGEngineRenderer.m_fScreenOffsetX) / fViewModeScale;
                float fY = ((float)cmd.areaY - CGEngineRenderer.m_fScreenOffsetY) / fViewModeScale;
                float fDX = fX - CGEngine.m_fTouchX;
                float fDY = fY - CGEngine.m_fTouchY;
                System.out.println("Flick: DX = " + fDX + "  DY =" + fDY);
                CGEngine.m_nTouchActive = true;
                CGEngine.m_fTouchX = fX;
                CGEngine.m_fTouchY = fY;
                if (CGEngine.m_StartSelectPointX > 0.0f && CGEngine.m_StartSelectPointY > 0.0f) {
                    CGEngine.m_CurrentSelectPointX = fX - CGBoard.m_fStartX;
                    CGEngine.m_CurrentSelectPointY = fY - CGBoard.m_fStartY;
                }
            } else {
                if (CGEngine.m_Board.IsReady()) {
                    CGEngine.m_Board.ChangePos();
                }
                CGEngine.m_StartSelectPointX = -1000000.0f;
                CGEngine.m_StartSelectPointY = -1000000.0f;
                CGEngine.m_CurrentSelectPointX = -1000000.0f;
                CGEngine.m_CurrentSelectPointY = -1000000.0f;
            }
        }
    }

    public void processKeyCommand(KeyCommand cmd) {
    }
}

